// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudIamSSOConfig hashicorp cloud iam s s o config
//
// swagger:model hashicorp.cloud.iam.SSOConfig
type HashicorpCloudIamSSOConfig struct {

	// created_ at is the time of creation for the configuration
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// default_role is the default RBAC role that users joining the
	// SSO organization should get.
	DefaultRole string `json:"default_role,omitempty"`

	// SAML holds SAML SSO configuration details.
	Saml *HashicorpCloudIamSAMLDetails `json:"saml,omitempty"`

	// Type is the type of Single Sign-On.
	Type *HashicorpCloudIamSSOType `json:"type,omitempty"`

	// updated_at is the last time that the configuration was modified.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud iam s s o config
func (m *HashicorpCloudIamSSOConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSaml(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamSSOConfig) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudIamSSOConfig) validateSaml(formats strfmt.Registry) error {
	if swag.IsZero(m.Saml) { // not required
		return nil
	}

	if m.Saml != nil {
		if err := m.Saml.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("saml")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("saml")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamSSOConfig) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if m.Type != nil {
		if err := m.Type.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamSSOConfig) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam s s o config based on the context it is used
func (m *HashicorpCloudIamSSOConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSaml(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamSSOConfig) contextValidateSaml(ctx context.Context, formats strfmt.Registry) error {

	if m.Saml != nil {

		if swag.IsZero(m.Saml) { // not required
			return nil
		}

		if err := m.Saml.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("saml")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("saml")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamSSOConfig) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if m.Type != nil {

		if swag.IsZero(m.Type) { // not required
			return nil
		}

		if err := m.Type.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamSSOConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamSSOConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamSSOConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
