// python wrapper for ttkPeriodicGhostsGeneration
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkPeriodicGhostsGeneration.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkPeriodicGhostsGeneration(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkPeriodicGhostsGeneration_ClassNew(); }


static PyObject *
PyttkPeriodicGhostsGeneration_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkPeriodicGhostsGeneration::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPeriodicGhostsGeneration *op = static_cast<ttkPeriodicGhostsGeneration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkPeriodicGhostsGeneration::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkPeriodicGhostsGeneration *tempr = ttkPeriodicGhostsGeneration::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPeriodicGhostsGeneration *op = static_cast<ttkPeriodicGhostsGeneration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkPeriodicGhostsGeneration *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkPeriodicGhostsGeneration::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkPeriodicGhostsGeneration::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPeriodicGhostsGeneration *op = static_cast<ttkPeriodicGhostsGeneration *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkPeriodicGhostsGeneration::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_MPIPeriodicGhostPipelinePreconditioning(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MPIPeriodicGhostPipelinePreconditioning");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPeriodicGhostsGeneration *op = static_cast<ttkPeriodicGhostsGeneration *>(vp);

  vtkImageData *temp0 = nullptr;
  vtkImageData *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkImageData") &&
      ap.GetVTKObject(temp1, "vtkImageData"))
  {
    int tempr = (ap.IsBound() ?
      op->MPIPeriodicGhostPipelinePreconditioning(temp0, temp1) :
      op->ttkPeriodicGhostsGeneration::MPIPeriodicGhostPipelinePreconditioning(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPeriodicGhostsGeneration_getNeighbors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "getNeighbors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPeriodicGhostsGeneration *op = static_cast<ttkPeriodicGhostsGeneration *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->getNeighbors() :
      op->ttkPeriodicGhostsGeneration::getNeighbors());

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}

static PyMethodDef PyttkPeriodicGhostsGeneration_Methods[] = {
  {"IsTypeOf", PyttkPeriodicGhostsGeneration_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkPeriodicGhostsGeneration_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkPeriodicGhostsGeneration_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkPeriodicGhostsGeneration\nC++: static ttkPeriodicGhostsGeneration *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkPeriodicGhostsGeneration_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkPeriodicGhostsGeneration\nC++: ttkPeriodicGhostsGeneration *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkPeriodicGhostsGeneration_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkPeriodicGhostsGeneration_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"MPIPeriodicGhostPipelinePreconditioning", PyttkPeriodicGhostsGeneration_MPIPeriodicGhostPipelinePreconditioning, METH_VARARGS,
   "MPIPeriodicGhostPipelinePreconditioning(self,\n    imageIn:vtkImageData, imageOut:vtkImageData) -> int\nC++: int MPIPeriodicGhostPipelinePreconditioning(\n    vtkImageData *imageIn, vtkImageData *imageOut)\n\nThis method is called in GetTriangulation, if the triangulation\nis periodic, to create ghosts specific to dealing with this type\nof triangulation. This may add points to the dataset of a process\nand therefore invalidates the triangulation object taken as\nparameter here.\n"},
  {"getNeighbors", PyttkPeriodicGhostsGeneration_getNeighbors, METH_VARARGS,
   "getNeighbors(self) -> (int, ...)\nC++: std::vector<int> getNeighbors()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkPeriodicGhostsGeneration_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkPeriodicGhostsGeneration_Doc =
  "ttkPeriodicGhostsGeneration - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Eve Le Guillou <eve.le-guillou@lip6.fr>\\date June 2023.\n\n"
  "TTK VTK-filter that generates an outside ghost layer for periodic\n"
  "implicit\n"
  " grids when used in a distributed context.\n\n"
  "\\param Input Scalar field on an vtkImageData.\n"
  "\\param Output Scalar field on an vtkImageData.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(),\n"
  "GetOutputDataObject()).\n\n"
  "The input data array needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::PeriodicGhostsGeneration\n"
  "\\sa ttkAlgorithm\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkPeriodicGhostsGeneration_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkPeriodicGhostsGeneration.ttkPeriodicGhostsGeneration", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkPeriodicGhostsGeneration_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkPeriodicGhostsGeneration_StaticNew()
{
  return ttkPeriodicGhostsGeneration::New();
}

PyObject *PyttkPeriodicGhostsGeneration_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkPeriodicGhostsGeneration_Type, PyttkPeriodicGhostsGeneration_Methods,
    "ttkPeriodicGhostsGeneration",
 &PyttkPeriodicGhostsGeneration_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkPeriodicGhostsGeneration_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkPeriodicGhostsGeneration(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkPeriodicGhostsGeneration_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkPeriodicGhostsGeneration", o) != 0)
  {
    Py_DECREF(o);
  }

}

