const char string_lua[] =
"local ffi = require('ffi')\n"
"local buffer = require('buffer')\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"ffi.cdef[[\n"
"    const char *\n"
"    memmem(const char *haystack, size_t haystack_len,\n"
"           const char *needle,   size_t needle_len);\n"
"    int memcmp(const char *mem1, const char *mem2, size_t num);\n"
"    int isspace(int c);\n"
"    void\n"
"    string_strip_helper(const char *inp, size_t inp_len, const char *chars,\n"
"                        size_t chars_len, bool lstrip, bool rstrip,\n"
"                        size_t *newstart, size_t *newlen);\n"
"]]\n"
"\n"
"local c_char_ptr     = ffi.typeof('const char *')\n"
"\n"
"local memcmp  = ffi.C.memcmp\n"
"local memmem  = ffi.C.memmem\n"
"local isspace = ffi.C.isspace\n"
"\n"
"local err_string_arg = \"bad argument #%d to '%s' (%s expected, got %s)\"\n"
"local space_chars    = ' \\t\\n\\v\\f\\r'\n"
"\n"
"local function string_split_empty(inp, maxsplit)\n"
"    local p = c_char_ptr(inp)\n"
"    local p_end = p + #inp\n"
"    local rv = {}\n"
"    while true do\n"
"        -- skip the leading whitespaces\n"
"        while p < p_end and isspace(p[0]) ~= 0 do\n"
"            p = p + 1\n"
"        end\n"
"        if p == p_end then\n"
"            break\n"
"        end\n"
"        if maxsplit <= 0 then\n"
"            table.insert(rv, ffi.string(p, p_end - p))\n"
"            break\n"
"        end\n"
"        local chunk = p\n"
"        -- skip all non-whitespace characters\n"
"        while p < p_end and isspace(p[0]) == 0 do\n"
"            p = p + 1\n"
"        end\n"
"        assert((p - chunk) > 0)\n"
"        table.insert(rv, ffi.string(chunk, p - chunk))\n"
"        maxsplit = maxsplit - 1\n"
"    end\n"
"    return rv\n"
"end\n"
"\n"
"local function string_split_internal(inp, sep, maxsplit)\n"
"    local p = c_char_ptr(inp)\n"
"    local p_end = p + #inp\n"
"    local sep_len = #sep\n"
"    if sep_len == 0 then\n"
"        error(err_string_arg:format(2, 'string.split', 'non-empty string',\n"
"              \"empty string\"), 3)\n"
"    end\n"
"    local rv = {}\n"
"    while true do\n"
"        assert(p <= p_end)\n"
"        if maxsplit <= 0 or p == p_end then\n"
"            table.insert(rv, ffi.string(p, p_end - p))\n"
"            break\n"
"        end\n"
"        local chunk = p\n"
"        p = memmem(p, p_end - p, sep, sep_len)\n"
"        if p == nil then\n"
"            table.insert(rv, ffi.string(chunk, p_end - chunk))\n"
"            break\n"
"        end\n"
"        table.insert(rv, ffi.string(chunk, p - chunk))\n"
"        p = p + sep_len\n"
"        maxsplit = maxsplit - 1\n"
"    end\n"
"    return rv\n"
"end\n"
"\n"
"local function string_split(inp, sep, max)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.split', 'string', type(inp)), 2)\n"
"    end\n"
"    if sep ~= nil and type(sep) ~= 'string' then\n"
"        error(err_string_arg:format(2, 'string.split', 'string', type(sep)), 2)\n"
"    end\n"
"    if max ~= nil and (type(max) ~= 'number' or max < 0) then\n"
"        error(err_string_arg:format(3, 'string.split', 'positive integer',\n"
"                                    type(max)), 2)\n"
"    end\n"
"    max = max or 0xffffffff\n"
"    if not sep then\n"
"        return string_split_empty(inp, max)\n"
"    end\n"
"    return string_split_internal(inp, sep, max)\n"
"end\n"
"\n"
"--- Left-justify string in a field of given width.\n"
"-- Append \"width - len(inp)\" chars to given string. Input is never trucated.\n"
"-- @function ljust\n"
"-- @string       inp    the string\n"
"-- @int          width  at least bytes to be returned\n"
"-- @string[opt]  char   char of length 1 to fill with (\" \" by default)\n"
"-- @returns             result string\n"
"local function string_ljust(inp, width, char)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.ljust', 'string', type(inp)), 2)\n"
"    end\n"
"    if type(width) ~= 'number' or width < 0 then\n"
"        error(err_string_arg:format(2, 'string.ljust', 'positive integer',\n"
"                                    type(width)), 2)\n"
"    end\n"
"    if char ~= nil and (type(char) ~= 'string' or #char ~= 1) then\n"
"        error(err_string_arg:format(3, 'string.ljust', 'char',\n"
"                                    type(char)), 2)\n"
"    end\n"
"    char = char or \" \"\n"
"    local delta = width - #inp\n"
"    if delta < 0 then\n"
"        return inp\n"
"    end\n"
"    return inp .. char:rep(delta)\n"
"end\n"
"\n"
"--- Right-justify string in a field of given width.\n"
"-- Prepend \"width - len(inp)\" chars to given string. Input is never trucated.\n"
"-- @function rjust\n"
"-- @string       inp    the string\n"
"-- @int          width  at least bytes to be returned\n"
"-- @string[opt]  char   char of length 1 to fill with (\" \" by default)\n"
"-- @returns             result string\n"
"local function string_rjust(inp, width, char)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.rjust', 'string', type(inp)), 2)\n"
"    end\n"
"    if type(width) ~= 'number' or width < 0 then\n"
"        error(err_string_arg:format(2, 'string.rjust', 'positive integer',\n"
"                                    type(width)), 2)\n"
"    end\n"
"    if char ~= nil and (type(char) ~= 'string' or #char ~= 1) then\n"
"        error(err_string_arg:format(3, 'string.rjust', 'char',\n"
"                                    type(char)), 2)\n"
"    end\n"
"    char = char or \" \"\n"
"    local delta = width - #inp\n"
"    if delta < 0 then\n"
"        return inp\n"
"    end\n"
"    return char:rep(delta) .. inp\n"
"end\n"
"\n"
"--- Center string in a field of given width.\n"
"-- Prepend and append \"(width - len(inp))/2\" chars to given string.\n"
"-- Input is never trucated.\n"
"-- @function center\n"
"-- @string       inp    the string\n"
"-- @int          width  at least bytes to be returned\n"
"-- @string[opt]  char   char of length 1 to fill with (\" \" by default)\n"
"-- @returns             result string\n"
"local function string_center(inp, width, char)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.center', 'string', type(inp)), 2)\n"
"    end\n"
"    if type(width) ~= 'number' or width < 0 then\n"
"        error(err_string_arg:format(2, 'string.center', 'positive integer',\n"
"                                    type(width)), 2)\n"
"    end\n"
"    if char ~= nil and (type(char) ~= 'string' or #char ~= 1) then\n"
"        error(err_string_arg:format(3, 'string.center', 'char',\n"
"                                    type(char)), 2)\n"
"    end\n"
"    char = char or \" \"\n"
"    local delta = width - #inp\n"
"    if delta < 0 then\n"
"        return inp\n"
"    end\n"
"    local pad_left = math.floor(delta / 2)\n"
"    local pad_right = delta - pad_left\n"
"    return char:rep(pad_left) .. inp .. char:rep(pad_right)\n"
"end\n"
"\n"
"-- For now the best way to check, that string starts with sequence\n"
"-- (with patterns disabled) is to cut line and check strings for equality\n"
"\n"
"--- Check that string (or substring) starts with given string\n"
"-- Optionally restricting the matching with the given offsets\n"
"-- @function startswith\n"
"-- @string    inp     original string\n"
"-- @string    head    the substring to check against\n"
"-- @int[opt]  _start  start index of matching boundary\n"
"-- @int[opt]  _end    end index of matching boundary\n"
"-- @returns           boolean\n"
"local function string_startswith(inp, head, _start, _end)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.startswith', 'string',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if type(head) ~= 'string' then\n"
"        error(err_string_arg:format(2, 'string.startswith', 'string',\n"
"                                    type(head)), 2)\n"
"    end\n"
"    if _start ~= nil and type(_start) ~= 'number' then\n"
"        error(err_string_arg:format(3, 'string.startswith', 'integer',\n"
"                                    type(_start)), 2)\n"
"    end\n"
"    if _end ~= nil and type(_end) ~= 'number' then\n"
"        error(err_string_arg:format(4, 'string.startswith', 'integer',\n"
"                                    type(_end)), 2)\n"
"    end\n"
"    -- prepare input arguments (move negative values [offset from the end] to\n"
"    -- positive ones and/or assign default values)\n"
"    local head_len, inp_len = #head, #inp\n"
"    if _start == nil then\n"
"        _start = 1\n"
"    elseif _start < 0 then\n"
"        _start = inp_len + _start + 1\n"
"        if _start < 0 then _start = 0 end\n"
"    end\n"
"    if _end == nil or _end > inp_len then\n"
"        _end = inp_len\n"
"    elseif _end < 0 then\n"
"        _end = inp_len + _end + 1\n"
"        if _end < 0 then _end = 0 end\n"
"    end\n"
"    -- check for degenerate case (interval lesser than input)\n"
"    if head_len == 0 then\n"
"        return true\n"
"    elseif _end - _start + 1 < head_len or _start > _end then\n"
"        return false\n"
"    end\n"
"    _start = _start - 1\n"
"    return memcmp(c_char_ptr(inp) + _start, c_char_ptr(head), head_len) == 0\n"
"end\n"
"\n"
"--- Check that string (or substring) ends with given string\n"
"-- Optionally restricting the matching with the given offsets\n"
"-- @function endswith\n"
"-- @string    inp     original string\n"
"-- @string    tail    the substring to check against\n"
"-- @int[opt]  _start  start index of matching boundary\n"
"-- @int[opt]  _end    end index of matching boundary\n"
"-- @returns           boolean\n"
"local function string_endswith(inp, tail, _start, _end)\n"
"    local tail_len, inp_len = #tail, #inp\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.endswith', 'string',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if type(tail) ~= 'string' then\n"
"        error(err_string_arg:format(2, 'string.endswith', 'string',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if _start ~= nil and type(_start) ~= 'number' then\n"
"        error(err_string_arg:format(3, 'string.endswith', 'integer',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if _end ~= nil and type(_end) ~= 'number' then\n"
"        error(err_string_arg:format(4, 'string.endswith', 'integer',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    -- prepare input arguments (move negative values [offset from the end] to\n"
"    -- positive ones and/or assign default values)\n"
"    if _start == nil then\n"
"        _start = 1\n"
"    elseif _start < 0 then\n"
"        _start = inp_len + _start + 1\n"
"        if _start < 0 then _start = 0 end\n"
"    end\n"
"    if _end == nil or _end > inp_len then\n"
"        _end = inp_len\n"
"    elseif _end < 0 then\n"
"        _end = inp_len + _end + 1\n"
"        if _end < 0 then _end = 0 end\n"
"    end\n"
"    -- check for degenerate case (interval lesser than input)\n"
"    if tail_len == 0 then\n"
"        return true\n"
"    elseif _end - _start + 1 < tail_len or _start > _end  then\n"
"        return false\n"
"    end\n"
"    _start = _end - tail_len\n"
"    return memcmp(c_char_ptr(inp) + _start, c_char_ptr(tail), tail_len) == 0\n"
"end\n"
"\n"
"local function string_hex(inp)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.hex', 'string', type(inp)), 2)\n"
"    end\n"
"    local len = inp:len() * 2\n"
"    local ibuf = cord_ibuf_take()\n"
"    local res = ibuf:alloc(len + 1)\n"
"\n"
"    local uinp = ffi.cast('const unsigned char *', inp)\n"
"    for i = 0, inp:len() - 1 do\n"
"        ffi.C.snprintf(res + i * 2, 3, \"%02x\", ffi.cast('unsigned', uinp[i]))\n"
"    end\n"
"    res = ffi.string(res, len)\n"
"    cord_ibuf_put(ibuf)\n"
"    return res\n"
"end\n"
"\n"
"local hexadecimal_chars = {\n"
"    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A',\n"
"    'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f'}\n"
"\n"
"local hexadecimal_values = {\n"
"    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10,\n"
"    10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15}\n"
"\n"
"local hexadecimals_mapping = {}\n"
"\n"
"for i, char in ipairs(hexadecimal_chars) do\n"
"    hexadecimals_mapping[string.byte(char)] = hexadecimal_values[i]\n"
"end\n"
"\n"
"\n"
"--\n"
"-- Match a hexadecimal representation of a string to its\n"
"-- string representation.\n"
"-- @param inp the string of hexadecimals\n"
"--\n"
"-- @retval formatted string\n"
"--\n"
"local function string_fromhex(inp)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, 'string.fromhex', 'string',\n"
"                                    type(inp)), 2)\n"
"    end\n"
"    if inp:len() % 2 ~= 0 then\n"
"        error(err_string_arg:format(1, 'string.fromhex',\n"
"                                    'even amount of chars',\n"
"                                    'odd amount'), 2)\n"
"    end\n"
"    local len = inp:len() / 2\n"
"    local casted_inp = ffi.cast('const char *', inp)\n"
"    local ibuf = cord_ibuf_take()\n"
"    local res = ibuf:alloc(len)\n"
"    for i = 0, len - 1 do\n"
"        local first = hexadecimals_mapping[casted_inp[i * 2]]\n"
"        local second = hexadecimals_mapping[casted_inp[i * 2 + 1]]\n"
"        if first == nil or second == nil then\n"
"            cord_ibuf_put(ibuf)\n"
"            error(err_string_arg:format(1, 'string.fromhex', 'hex string',\n"
"                                        'non hex chars'), 2)\n"
"        end\n"
"        res[i] = first * 16 + second\n"
"    end\n"
"    res = ffi.string(res, len)\n"
"    cord_ibuf_put(ibuf)\n"
"    return res\n"
"end\n"
"\n"
"local function string_strip(inp, chars)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, \"string.strip\", 'string', type(inp)), 2)\n"
"    end\n"
"    if inp == '' then\n"
"        return inp\n"
"    end\n"
"    if chars == nil then\n"
"        chars = space_chars\n"
"    elseif type(chars) ~= 'string' then\n"
"        error(err_string_arg:format(2, \"string.strip\", 'string', type(chars)), 2)\n"
"    elseif chars == '' then\n"
"        return inp\n"
"    end\n"
"\n"
"    local casted_inp = c_char_ptr(inp)\n"
"    local strip_newstart = ffi.new('unsigned long[1]')\n"
"    local strip_newlen = ffi.new('unsigned long[1]')\n"
"    ffi.C.string_strip_helper(inp, #inp, chars, #chars, true, true,\n"
"                              strip_newstart, strip_newlen)\n"
"    return ffi.string(casted_inp + strip_newstart[0], strip_newlen[0])\n"
"end\n"
"\n"
"local function string_lstrip(inp, chars)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, \"string.lstrip\", 'string', type(inp)), 2)\n"
"    end\n"
"    if inp == '' then\n"
"        return inp\n"
"    end\n"
"    if chars == nil then\n"
"        chars = space_chars\n"
"    elseif type(chars) ~= 'string' then\n"
"        error(err_string_arg:format(2, \"string.lstrip\", 'string', type(chars)), 2)\n"
"    elseif chars == '' then\n"
"        return inp\n"
"    end\n"
"\n"
"    local casted_inp = c_char_ptr(inp)\n"
"    local strip_newstart = ffi.new('unsigned long[1]')\n"
"    local strip_newlen = ffi.new('unsigned long[1]')\n"
"    ffi.C.string_strip_helper(inp, #inp, chars, #chars, true, false,\n"
"                              strip_newstart, strip_newlen)\n"
"    return ffi.string(casted_inp + strip_newstart[0], strip_newlen[0])\n"
"end\n"
"\n"
"local function string_rstrip(inp, chars)\n"
"    if type(inp) ~= 'string' then\n"
"        error(err_string_arg:format(1, \"string.rstrip\", 'string', type(inp)), 2)\n"
"    end\n"
"    if inp == '' then\n"
"        return inp\n"
"    end\n"
"    if chars == nil then\n"
"        chars = space_chars\n"
"    elseif type(chars) ~= 'string' then\n"
"        error(err_string_arg:format(2, \"string.rstrip\", 'string', type(chars)), 2)\n"
"    elseif chars == '' then\n"
"        return inp\n"
"    end\n"
"\n"
"    local casted_inp = c_char_ptr(inp)\n"
"    local strip_newstart = ffi.new('unsigned long[1]')\n"
"    local strip_newlen = ffi.new('unsigned long[1]')\n"
"    ffi.C.string_strip_helper(inp, #inp, chars, #chars, false, true,\n"
"                              strip_newstart, strip_newlen)\n"
"    return ffi.string(casted_inp + strip_newstart[0], strip_newlen[0])\n"
"end\n"
"\n"
"\n"
"-- It'll automatically set string methods, too.\n"
"local string = require('string')\n"
"string.split      = string_split\n"
"string.ljust      = string_ljust\n"
"string.rjust      = string_rjust\n"
"string.center     = string_center\n"
"string.startswith = string_startswith\n"
"string.endswith   = string_endswith\n"
"string.hex        = string_hex\n"
"string.fromhex    = string_fromhex\n"
"string.strip      = string_strip\n"
"string.lstrip      = string_lstrip\n"
"string.rstrip      = string_rstrip\n"
""
;
