// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by hack/docgen tool. DO NOT EDIT.

package network

import (
	"net/netip"

	"github.com/siderolabs/talos/pkg/machinery/config/encoder"
	"github.com/siderolabs/talos/pkg/machinery/nethelpers"
)

func (DefaultActionConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NetworkDefaultActionConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NetworkDefaultActionConfig is a ingress firewall default action configuration document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NetworkDefaultActionConfig is a ingress firewall default action configuration document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "ingress",
				Type:        "DefaultAction",
				Note:        "",
				Description: "Default action for all not explicitly configured ingress traffic: accept or block.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Default action for all not explicitly configured ingress traffic: accept or block." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"accept",
					"block",
				},
			},
		},
	}

	doc.AddExample("", exampleDefaultActionConfigV1Alpha1())

	return doc
}

func (DummyLinkConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "DummyLinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "DummyLinkConfig is a config document to create a dummy (virtual) network link." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "DummyLinkConfig is a config document to create a dummy (virtual) network link.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the dummy link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the dummy link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hardwareAddr",
				Type:        "HardwareAddr",
				Note:        "",
				Description: "Override the hardware (MAC) address of the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Override the hardware (MAC) address of the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleDummyLinkConfigV1Alpha1())

	doc.Fields[1].AddExample("", "dummy1")
	doc.Fields[2].AddExample("", nethelpers.HardwareAddr{0x2e, 0x3c, 0x4d, 0x5e, 0x6f, 0x70})

	return doc
}

func (EthernetConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetConfig is a config document to configure Ethernet interfaces." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetConfig is a config document to configure Ethernet interfaces.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "features",
				Type:        "map[string]bool",
				Note:        "",
				Description: "Configuration for Ethernet features.\n\nSet of features available and whether they can be enabled or disabled is driver specific.\nUse `talosctl get ethernetstatus <link> -o yaml` to get the list of available features and\ntheir current status.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet features." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rings",
				Type:        "EthernetRingsConfig",
				Note:        "",
				Description: "Configuration for Ethernet link rings.\n\nThis is similar to `ethtool -G` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet link rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "channels",
				Type:        "EthernetChannelsConfig",
				Note:        "",
				Description: "Configuration for Ethernet link channels.\n\nThis is similar to `ethtool -L` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configuration for Ethernet link channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "wakeOnLan",
				Type:        "[]WOLMode",
				Note:        "",
				Description: "Wake-on-LAN modes to enable.\n\nIf this field is omitted, Wake-on-LAN configuration is not changed.\nAn empty list disables Wake-on-LAN.\n\nThis is similar to `ethtool -s <link> wol <options>` command.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Wake-on-LAN modes to enable." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"phy",
					"unicast",
					"multicast",
					"broadcast",
					"arp",
					"magic",
					"magicsecure",
					"filter",
				},
			},
		},
	}

	doc.AddExample("", exampleEthernetConfigV1Alpha1())

	doc.Fields[5].AddExample("", []nethelpers.WOLMode{nethelpers.WOLModeUnicast, nethelpers.WOLModeMagic})

	return doc
}

func (EthernetRingsConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetRingsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetRingsConfig is a configuration for Ethernet link rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetRingsConfig is a configuration for Ethernet link rings.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EthernetConfigV1Alpha1",
				FieldName: "rings",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "rx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of TX rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of TX rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-mini",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX mini rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX mini rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-jumbo",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX jumbo rings.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX jumbo rings." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-buf-len",
				Type:        "uint32",
				Note:        "",
				Description: "RX buffer length.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "RX buffer length." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "cqe-size",
				Type:        "uint32",
				Note:        "",
				Description: "CQE size.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "CQE size." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx-push",
				Type:        "bool",
				Note:        "",
				Description: "TX push enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TX push enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "rx-push",
				Type:        "bool",
				Note:        "",
				Description: "RX push enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "RX push enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx-push-buf-len",
				Type:        "uint32",
				Note:        "",
				Description: "TX push buffer length.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TX push buffer length." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tcp-data-split",
				Type:        "bool",
				Note:        "",
				Description: "TCP data split enabled.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "TCP data split enabled." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (EthernetChannelsConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "EthernetChannelsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "EthernetChannelsConfig is a configuration for Ethernet link channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "EthernetChannelsConfig is a configuration for Ethernet link channels.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "EthernetConfigV1Alpha1",
				FieldName: "channels",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "rx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of RX channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of RX channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "tx",
				Type:        "uint32",
				Note:        "",
				Description: "Number of TX channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of TX channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "other",
				Type:        "uint32",
				Note:        "",
				Description: "Number of other channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of other channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "combined",
				Type:        "uint32",
				Note:        "",
				Description: "Number of combined channels.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Number of combined channels." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (HostnameConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "HostnameConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "HostnameConfig is a config document to configure the hostname: either a static hostname or an automatically generated hostname." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "HostnameConfig is a config document to configure the hostname: either a static hostname or an automatically generated hostname.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "auto",
				Type:        "AutoHostnameKind",
				Note:        "",
				Description: "A method to automatically generate a hostname for the machine.\n\nThere are two methods available:\n  - `stable` - generates a stable hostname based on machine identity\n  - `off` - disables automatic hostname generation, Talos will wait for an external source to provide a hostname (DHCP, cloud-init, etc).\n\nAutomatic hostnames have the lowest priority over any other hostname sources: DHCP, cloud-init, etc.\nConflicts with `hostname` field.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A method to automatically generate a hostname for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"stable",
					"off",
				},
			},
			{
				Name:        "hostname",
				Type:        "string",
				Note:        "",
				Description: "A static hostname to set for the machine.\n\nThis hostname has the highest priority over any other hostname sources: DHCP, cloud-init, etc.\nConflicts with `auto` field.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A static hostname to set for the machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleHostnameConfigV1Alpha1())

	doc.AddExample("", exampleHostnameConfigV1Alpha2())

	doc.Fields[2].AddExample("", "controlplane1")
	doc.Fields[2].AddExample("", "controlplane1.example.org")

	return doc
}

func (KubespanEndpointsConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "KubeSpanEndpointsConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "KubeSpanEndpointsConfig is a config document to configure KubeSpan endpoints." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "KubeSpanEndpointsConfig is a config document to configure KubeSpan endpoints.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "extraAnnouncedEndpoints",
				Type:        "[]AddrPort",
				Note:        "",
				Description: "A list of extra Wireguard endpoints to announce from this machine.\n\nTalos automatically adds endpoints based on machine addresses, public IP, etc.\nThis field allows to add extra endpoints which are managed outside of Talos, e.g. NAT mapping.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "A list of extra Wireguard endpoints to announce from this machine." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleKubespanEndpointsV1Alpha1())

	return doc
}

func (LinkConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "LinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "LinkConfig is a config document to configure physical interfaces (network links)." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "LinkConfig is a config document to configure physical interfaces (network links).",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the link (interface).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the link (interface)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Type:   "CommonLinkConfig",
				Inline: true,
			},
		},
	}

	doc.AddExample("", exampleLinkConfigV1Alpha1())

	doc.Fields[1].AddExample("", "enp0s2")
	doc.Fields[1].AddExample("", "eth1")

	return doc
}

func (CommonLinkConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "CommonLinkConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "CommonLinkConfig is common configuration for network links, and logical links." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "CommonLinkConfig is common configuration for network links, and logical links.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "DummyLinkConfigV1Alpha1",
				FieldName: "",
			},
			{
				TypeName:  "LinkConfigV1Alpha1",
				FieldName: "",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "up",
				Type:        "bool",
				Note:        "",
				Description: "Bring the link up or down.\n\nIf not specified, the link will be brought up.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Bring the link up or down." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mtu",
				Type:        "uint32",
				Note:        "",
				Description: "Configure LinkMTU (Maximum Transmission Unit) for the link.\n\nIf not specified, the system default LinkMTU will be used (usually 1500).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure LinkMTU (Maximum Transmission Unit) for the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "addresses",
				Type:        "[]AddressConfig",
				Note:        "",
				Description: "Configure addresses to be statically assigned to the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure addresses to be statically assigned to the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routes",
				Type:        "[]RouteConfig",
				Note:        "",
				Description: "Configure routes to be statically created via the link.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure routes to be statically created via the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	return doc
}

func (AddressConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "AddressConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "AddressConfig represents a network address configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "AddressConfig represents a network address configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "CommonLinkConfig",
				FieldName: "addresses",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "address",
				Type:        "Prefix",
				Note:        "",
				Description: "IP address to be assigned to the link.\n\nThis field must include the network prefix length (e.g. /24 for IPv4, /64 for IPv6).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address to be assigned to the link." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "routePriority",
				Type:        "uint32",
				Note:        "",
				Description: "Configure the route priority (metric) for routes created for this address.\n\nIf not specified, the system default route priority will be used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Configure the route priority (metric) for routes created for this address." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", netip.MustParsePrefix("192.168.1.100/24"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("fd00::1/64"))

	return doc
}

func (RouteConfig) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RouteConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RouteConfig represents a network route configuration." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RouteConfig represents a network route configuration.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "CommonLinkConfig",
				FieldName: "routes",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "destination",
				Type:        "Prefix",
				Note:        "",
				Description: "The route's destination as an address prefix.\n\nIf not specified, a default route will be created for the address family of the gateway.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's destination as an address prefix." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "gateway",
				Type:        "Addr",
				Note:        "",
				Description: "The route's gateway (if empty, creates link scope route).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's gateway (if empty, creates link scope route)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "source",
				Type:        "Addr",
				Note:        "",
				Description: "The route's source address (optional).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The route's source address (optional)." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "metric",
				Type:        "uint32",
				Note:        "",
				Description: "The optional metric for the route.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The optional metric for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "mtu",
				Type:        "uint32",
				Note:        "",
				Description: "The optional MTU for the route.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The optional MTU for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "table",
				Type:        "RoutingTable",
				Note:        "",
				Description: "The routing table to use for the route.\n\nIf not specified, the main routing table will be used.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "The routing table to use for the route." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", Prefix{netip.MustParsePrefix("10.0.0.0/8")})
	doc.Fields[1].AddExample("", Addr{netip.MustParseAddr("10.0.0.1")})

	return doc
}

func (RuleConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "NetworkRuleConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "NetworkRuleConfig is a network firewall rule config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "NetworkRuleConfig is a network firewall rule config document.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "Name of the config document.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Name of the config document." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "portSelector",
				Type:        "RulePortSelector",
				Note:        "",
				Description: "Port selector defines which ports and protocols on the host are affected by the rule.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Port selector defines which ports and protocols on the host are affected by the rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "ingress",
				Type:        "[]IngressRule",
				Note:        "",
				Description: "Ingress defines which source subnets are allowed to access the host ports/protocols defined by the `portSelector`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ingress defines which source subnets are allowed to access the host ports/protocols defined by the `portSelector`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleRuleConfigV1Alpha1())

	return doc
}

func (RulePortSelector) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "RulePortSelector",
		Comments:    [3]string{"" /* encoder.HeadComment */, "RulePortSelector is a port selector for the network rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "RulePortSelector is a port selector for the network rule.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RuleConfigV1Alpha1",
				FieldName: "portSelector",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "ports",
				Type:        "PortRanges",
				Note:        "",
				Description: "Ports defines a list of port ranges or single ports.\nThe port ranges are inclusive, and should not overlap.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Ports defines a list of port ranges or single ports." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "protocol",
				Type:        "Protocol",
				Note:        "",
				Description: "Protocol defines traffic protocol (e.g. TCP or UDP).",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Protocol defines traffic protocol (e.g. TCP or UDP)." /* encoder.LineComment */, "" /* encoder.FootComment */},
				Values: []string{
					"tcp",
					"udp",
					"icmp",
					"icmpv6",
				},
			},
		},
	}

	doc.Fields[0].AddExample("", examplePortRanges1())
	doc.Fields[0].AddExample("", examplePortRanges2())

	return doc
}

func (IngressRule) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "IngressRule",
		Comments:    [3]string{"" /* encoder.HeadComment */, "IngressRule is a ingress rule." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "IngressRule is a ingress rule.",
		AppearsIn: []encoder.Appearance{
			{
				TypeName:  "RuleConfigV1Alpha1",
				FieldName: "ingress",
			},
		},
		Fields: []encoder.Doc{
			{
				Name:        "subnet",
				Type:        "Prefix",
				Note:        "",
				Description: "Subnet defines a source subnet.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Subnet defines a source subnet." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "except",
				Type:        "Prefix",
				Note:        "",
				Description: "Except defines a source subnet to exclude from the rule, it gets excluded from the `subnet`.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "Except defines a source subnet to exclude from the rule, it gets excluded from the `subnet`." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.Fields[0].AddExample("", netip.MustParsePrefix("10.3.4.0/24"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("2001:db8::/32"))
	doc.Fields[0].AddExample("", netip.MustParsePrefix("1.3.4.5/32"))

	return doc
}

func (StaticHostConfigV1Alpha1) Doc() *encoder.Doc {
	doc := &encoder.Doc{
		Type:        "StaticHostConfig",
		Comments:    [3]string{"" /* encoder.HeadComment */, "StaticHostConfig is a config document to set /etc/hosts entries." /* encoder.LineComment */, "" /* encoder.FootComment */},
		Description: "StaticHostConfig is a config document to set /etc/hosts entries.",
		Fields: []encoder.Doc{
			{
				Type:   "Meta",
				Inline: true,
			},
			{
				Name:        "name",
				Type:        "string",
				Note:        "",
				Description: "IP address (IPv4 or IPv6) to map the hostnames to.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "IP address (IPv4 or IPv6) to map the hostnames to." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
			{
				Name:        "hostnames",
				Type:        "[]string",
				Note:        "",
				Description: "List of hostnames to map to the IP address.",
				Comments:    [3]string{"" /* encoder.HeadComment */, "List of hostnames to map to the IP address." /* encoder.LineComment */, "" /* encoder.FootComment */},
			},
		},
	}

	doc.AddExample("", exampleStaticHostConfigV1Alpha1())

	return doc
}

// GetFileDoc returns documentation for the file network_doc.go.
func GetFileDoc() *encoder.FileDoc {
	return &encoder.FileDoc{
		Name:        "network",
		Description: "Package network provides network machine configuration documents.\n",
		Structs: []*encoder.Doc{
			DefaultActionConfigV1Alpha1{}.Doc(),
			DummyLinkConfigV1Alpha1{}.Doc(),
			EthernetConfigV1Alpha1{}.Doc(),
			EthernetRingsConfig{}.Doc(),
			EthernetChannelsConfig{}.Doc(),
			HostnameConfigV1Alpha1{}.Doc(),
			KubespanEndpointsConfigV1Alpha1{}.Doc(),
			LinkConfigV1Alpha1{}.Doc(),
			CommonLinkConfig{}.Doc(),
			AddressConfig{}.Doc(),
			RouteConfig{}.Doc(),
			RuleConfigV1Alpha1{}.Doc(),
			RulePortSelector{}.Doc(),
			IngressRule{}.Doc(),
			StaticHostConfigV1Alpha1{}.Doc(),
		},
	}
}
