/* FirewallPanel.c generated by valac 0.56.17, the Vala compiler
 * generated from FirewallPanel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2014-2018 elementary LLC. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "security-privacy.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <polkit/polkit.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <switchboard.h>
#include <float.h>
#include <math.h>
#include <unistd.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SECURITY_PRIVACY_FIREWALL_PANEL_0_PROPERTY,
	SECURITY_PRIVACY_FIREWALL_PANEL_NUM_PROPERTIES
};
static GParamSpec* security_privacy_firewall_panel_properties[SECURITY_PRIVACY_FIREWALL_PANEL_NUM_PROPERTIES];
typedef enum  {
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ACTION,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_PROTOCOL,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_DIRECTION,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_TO,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_FROM,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_V6,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE,
	SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_N_COLUMNS
} SecurityPrivacyFirewallPanelColumns;

#define SECURITY_PRIVACY_FIREWALL_PANEL_TYPE_COLUMNS (security_privacy_firewall_panel_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SecurityPrivacyFirewallPanelPrivate {
	GtkFrame* frame;
	GtkListStore* list_store;
	GtkTreeView* view;
	gboolean loading;
	GtkButton* remove_button;
	GSettings* settings;
	GeeHashMap* disabled_rules;
	PolkitPermission* permission;
};

struct _Block1Data {
	int _ref_count_;
	SecurityPrivacyFirewallPanel* self;
	SecurityPrivacyUFWHelpersRule* rule;
	gchar* ufw_hash;
};

struct _Block2Data {
	int _ref_count_;
	SecurityPrivacyFirewallPanel* self;
	GtkButton* add_button;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GtkComboBoxText* policy_combobox;
	GtkComboBoxText* protocol_combobox;
	GtkComboBoxText* version_combobox;
	GtkComboBoxText* direction_combobox;
	GtkEntry* ports_entry;
	GtkPopover* add_popover;
};

struct _Block4Data {
	int _ref_count_;
	SecurityPrivacyFirewallPanel* self;
	GtkButton* lock_button;
};

static gint SecurityPrivacyFirewallPanel_private_offset;
static gpointer security_privacy_firewall_panel_parent_class = NULL;

static GType security_privacy_firewall_panel_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void security_privacy_firewall_panel_load_disabled_rules (SecurityPrivacyFirewallPanel* self);
static gchar* security_privacy_firewall_panel_generate_hash_for_rule (SecurityPrivacyFirewallPanel* self,
                                                               SecurityPrivacyUFWHelpersRule* r);
static void security_privacy_firewall_panel_reload_rule_numbers (SecurityPrivacyFirewallPanel* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda16_ (Block1Data* _data1_,
                        GtkTreeModel* model,
                        GtkTreePath* path,
                        GtkTreeIter* iter);
static gboolean _____lambda16__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                     GtkTreePath* path,
                                                     GtkTreeIter* iter,
                                                     gpointer self);
static void security_privacy_firewall_panel_show_rules (SecurityPrivacyFirewallPanel* self);
static void security_privacy_firewall_panel_disable_rule (SecurityPrivacyFirewallPanel* self,
                                                   SecurityPrivacyUFWHelpersRule* rule);
static void security_privacy_firewall_panel_save_disabled_rules (SecurityPrivacyFirewallPanel* self,
                                                          SecurityPrivacyUFWHelpersRule* additional_rule);
static void security_privacy_firewall_panel_enable_rule (SecurityPrivacyFirewallPanel* self,
                                                  const gchar* hash);
static void security_privacy_firewall_panel_delete_disabled_rule (SecurityPrivacyFirewallPanel* self,
                                                           const gchar* hash);
static void security_privacy_firewall_panel_create_treeview (SecurityPrivacyFirewallPanel* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda17_ (SecurityPrivacyFirewallPanel* self,
                  const gchar* path);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void ___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
static void __lambda18_ (SecurityPrivacyFirewallPanel* self);
static void ___lambda18__gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                                gpointer self);
static void __lambda19_ (Block2Data* _data2_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda20_ (Block3Data* _data3_);
static void ___lambda20__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda21_ (SecurityPrivacyFirewallPanel* self);
static void ___lambda21__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void security_privacy_firewall_panel_update_status (SecurityPrivacyFirewallPanel* self);
static GObject * security_privacy_firewall_panel_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _security_privacy_firewall_panel___lambda22_ (SecurityPrivacyFirewallPanel* self);
static void __security_privacy_firewall_panel___lambda22__g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _security_privacy_firewall_panel____lambda23_ (Block4Data* _data4_);
static void __security_privacy_firewall_panel____lambda23__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _security_privacy_firewall_panel____lambda24_ (SecurityPrivacyFirewallPanel* self);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void __security_privacy_firewall_panel____lambda24__gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void security_privacy_firewall_panel_finalize (GObject * obj);
static GType security_privacy_firewall_panel_get_type_once (void);

static inline gpointer
security_privacy_firewall_panel_get_instance_private (SecurityPrivacyFirewallPanel* self)
{
	return G_STRUCT_MEMBER_P (self, SecurityPrivacyFirewallPanel_private_offset);
}

static GType
security_privacy_firewall_panel_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ACTION, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ACTION", "action"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_PROTOCOL, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_PROTOCOL", "protocol"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_DIRECTION, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_DIRECTION", "direction"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_TO, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_TO", "to"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_FROM, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_FROM", "from"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_V6, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_V6", "v6"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED", "enabled"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE", "rule"}, {SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_N_COLUMNS, "SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType security_privacy_firewall_panel_columns_type_id;
	security_privacy_firewall_panel_columns_type_id = g_enum_register_static ("SecurityPrivacyFirewallPanelColumns", values);
	return security_privacy_firewall_panel_columns_type_id;
}

static GType
security_privacy_firewall_panel_columns_get_type (void)
{
	static volatile gsize security_privacy_firewall_panel_columns_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_firewall_panel_columns_type_id__once)) {
		GType security_privacy_firewall_panel_columns_type_id;
		security_privacy_firewall_panel_columns_type_id = security_privacy_firewall_panel_columns_get_type_once ();
		g_once_init_leave (&security_privacy_firewall_panel_columns_type_id__once, security_privacy_firewall_panel_columns_type_id);
	}
	return security_privacy_firewall_panel_columns_type_id__once;
}

SecurityPrivacyFirewallPanel*
security_privacy_firewall_panel_construct (GType object_type)
{
	SecurityPrivacyFirewallPanel * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("network-firewall");
	_tmp1_ = _tmp0_;
	self = (SecurityPrivacyFirewallPanel*) g_object_new (object_type, "activatable", TRUE, "icon", _tmp1_, "title", _ ("Firewall"), NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

SecurityPrivacyFirewallPanel*
security_privacy_firewall_panel_new (void)
{
	return security_privacy_firewall_panel_construct (SECURITY_PRIVACY_TYPE_FIREWALL_PANEL);
}

static void
security_privacy_firewall_panel_load_disabled_rules (SecurityPrivacyFirewallPanel* self)
{
	GeeHashMap* _tmp0_;
	gchar* to = NULL;
	gchar* _tmp1_;
	gchar* to_ports = NULL;
	gchar* _tmp2_;
	gchar* from = NULL;
	gchar* _tmp3_;
	gchar* from_ports = NULL;
	gchar* _tmp4_;
	gint action = 0;
	gint protocol = 0;
	gint direction = 0;
	gint version = 0;
	GVariant* rules = NULL;
	GSettings* _tmp5_;
	GVariant* _tmp6_;
	GVariantIter* iter = NULL;
	GVariant* _tmp7_;
	GVariantIter* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->disabled_rules);
	self->priv->disabled_rules = _tmp0_;
	_tmp1_ = g_strdup ("");
	to = _tmp1_;
	_tmp2_ = g_strdup ("");
	to_ports = _tmp2_;
	_tmp3_ = g_strdup ("");
	from = _tmp3_;
	_tmp4_ = g_strdup ("");
	from_ports = _tmp4_;
	action = 0;
	protocol = 0;
	direction = 0;
	version = 0;
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_get_value (_tmp5_, "disabled-firewall-rules");
	rules = _tmp6_;
	_tmp7_ = rules;
	_tmp8_ = g_variant_iter_new (_tmp7_);
	iter = _tmp8_;
	while (TRUE) {
		GVariantIter* _tmp9_;
		gboolean _tmp10_;
		SecurityPrivacyUFWHelpersRule* new_rule = NULL;
		SecurityPrivacyUFWHelpersRule* _tmp11_;
		SecurityPrivacyUFWHelpersRule* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		SecurityPrivacyUFWHelpersRule* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		SecurityPrivacyUFWHelpersRule* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		SecurityPrivacyUFWHelpersRule* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		SecurityPrivacyUFWHelpersRule* _tmp24_;
		SecurityPrivacyUFWHelpersRule* _tmp25_;
		SecurityPrivacyUFWHelpersRule* _tmp26_;
		SecurityPrivacyUFWHelpersRule* _tmp27_;
		gchar* hash = NULL;
		SecurityPrivacyUFWHelpersRule* _tmp28_;
		gchar* _tmp29_;
		GeeHashMap* _tmp30_;
		const gchar* _tmp31_;
		SecurityPrivacyUFWHelpersRule* _tmp32_;
		_tmp9_ = iter;
		_tmp10_ = g_variant_iter_next (_tmp9_, "(ssssiiii)", &to, &to_ports, &from, &from_ports, &action, &protocol, &direction, &version, NULL);
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = security_privacy_ufw_helpers_rule_new ();
		new_rule = _tmp11_;
		_tmp12_ = new_rule;
		_tmp13_ = to;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (_tmp12_->to);
		_tmp12_->to = _tmp14_;
		_tmp15_ = new_rule;
		_tmp16_ = to_ports;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (_tmp15_->to_ports);
		_tmp15_->to_ports = _tmp17_;
		_tmp18_ = new_rule;
		_tmp19_ = from;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (_tmp18_->from);
		_tmp18_->from = _tmp20_;
		_tmp21_ = new_rule;
		_tmp22_ = from_ports;
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (_tmp21_->from_ports);
		_tmp21_->from_ports = _tmp23_;
		_tmp24_ = new_rule;
		_tmp24_->action = (SecurityPrivacyUFWHelpersRuleAction) action;
		_tmp25_ = new_rule;
		_tmp25_->protocol = (SecurityPrivacyUFWHelpersRuleProtocol) protocol;
		_tmp26_ = new_rule;
		_tmp26_->direction = (SecurityPrivacyUFWHelpersRuleDirection) direction;
		_tmp27_ = new_rule;
		_tmp27_->version = (SecurityPrivacyUFWHelpersRuleVersion) version;
		_tmp28_ = new_rule;
		_tmp29_ = security_privacy_firewall_panel_generate_hash_for_rule (self, _tmp28_);
		hash = _tmp29_;
		_tmp30_ = self->priv->disabled_rules;
		_tmp31_ = hash;
		_tmp32_ = new_rule;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp32_);
		_g_free0 (hash);
		_g_object_unref0 (new_rule);
	}
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (rules);
	_g_free0 (from_ports);
	_g_free0 (from);
	_g_free0 (to_ports);
	_g_free0 (to);
}

static gchar*
security_privacy_firewall_panel_generate_hash_for_rule (SecurityPrivacyFirewallPanel* self,
                                                        SecurityPrivacyUFWHelpersRule* r)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GEnumValue* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GEnumValue* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GEnumValue* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GEnumValue* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = r->to;
	_tmp1_ = r->to_ports;
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = r->from;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = r->from_ports;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_enum_get_value (g_type_class_ref (SECURITY_PRIVACY_UFW_HELPERS_RULE_TYPE_ACTION), r->action);
	_tmp11_ = g_strconcat (_tmp9_, (_tmp10_ != NULL) ? _tmp10_->value_name : NULL, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_enum_get_value (g_type_class_ref (SECURITY_PRIVACY_UFW_HELPERS_RULE_TYPE_PROTOCOL), r->protocol);
	_tmp14_ = g_strconcat (_tmp12_, (_tmp13_ != NULL) ? _tmp13_->value_name : NULL, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_enum_get_value (g_type_class_ref (SECURITY_PRIVACY_UFW_HELPERS_RULE_TYPE_DIRECTION), r->direction);
	_tmp17_ = g_strconcat (_tmp15_, (_tmp16_ != NULL) ? _tmp16_->value_name : NULL, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_enum_get_value (g_type_class_ref (SECURITY_PRIVACY_UFW_HELPERS_RULE_TYPE_VERSION), r->version);
	_tmp20_ = g_strconcat (_tmp18_, (_tmp19_ != NULL) ? _tmp19_->value_name : NULL, NULL);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp21_;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SecurityPrivacyFirewallPanel* self;
		self = _data1_->self;
		_g_free0 (_data1_->ufw_hash);
		_g_object_unref0 (_data1_->rule);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
____lambda16_ (Block1Data* _data1_,
               GtkTreeModel* model,
               GtkTreePath* path,
               GtkTreeIter* iter)
{
	SecurityPrivacyFirewallPanel* self;
	GValue val = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	SecurityPrivacyUFWHelpersRule* tree_rule = NULL;
	GValue _tmp3_;
	SecurityPrivacyUFWHelpersRule* _tmp4_;
	gchar* tree_hash = NULL;
	SecurityPrivacyUFWHelpersRule* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, &_tmp2_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp2_;
	_tmp3_ = val;
	_tmp4_ = _g_object_ref0 (g_value_get_object (&_tmp3_));
	tree_rule = _tmp4_;
	_tmp5_ = tree_rule;
	_tmp6_ = security_privacy_firewall_panel_generate_hash_for_rule (self, _tmp5_);
	tree_hash = _tmp6_;
	_tmp7_ = _data1_->ufw_hash;
	_tmp8_ = tree_hash;
	if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
		SecurityPrivacyUFWHelpersRule* _tmp9_;
		SecurityPrivacyUFWHelpersRule* _tmp10_;
		GtkListStore* _tmp11_;
		GtkTreeIter _tmp12_;
		SecurityPrivacyUFWHelpersRule* _tmp13_;
		GValue _tmp14_ = {0};
		_tmp9_ = tree_rule;
		_tmp10_ = _data1_->rule;
		_tmp9_->number = _tmp10_->number;
		_tmp11_ = self->priv->list_store;
		_tmp12_ = *iter;
		_tmp13_ = tree_rule;
		g_value_init (&_tmp14_, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE);
		g_value_set_object (&_tmp14_, _tmp13_);
		gtk_list_store_set_value (_tmp11_, &_tmp12_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, &_tmp14_);
		G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		result = TRUE;
		_g_free0 (tree_hash);
		_g_object_unref0 (tree_rule);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return result;
	}
	result = FALSE;
	_g_free0 (tree_hash);
	_g_object_unref0 (tree_rule);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	return result;
}

static gboolean
_____lambda16__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                            GtkTreePath* path,
                                            GtkTreeIter* iter,
                                            gpointer self)
{
	gboolean result;
	result = ____lambda16_ (self, model, path, iter);
	return result;
}

static void
security_privacy_firewall_panel_reload_rule_numbers (SecurityPrivacyFirewallPanel* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _rule_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _rule_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _rule_index = 0;
		_tmp0_ = security_privacy_ufw_helpers_get_rules ();
		_rule_list = _tmp0_;
		_tmp1_ = _rule_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_rule_size = _tmp3_;
		_rule_index = -1;
		while (TRUE) {
			Block1Data* _data1_;
			gint _tmp4_;
			gint _tmp5_;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			SecurityPrivacyUFWHelpersRule* _tmp8_;
			gchar* _tmp9_;
			GtkTreeModelForeachFunc update_row = NULL;
			gpointer update_row_target;
			GDestroyNotify update_row_target_destroy_notify;
			GtkListStore* _tmp10_;
			GtkTreeModelForeachFunc _tmp11_;
			gpointer _tmp11__target;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_rule_index = _rule_index + 1;
			_tmp4_ = _rule_index;
			_tmp5_ = _rule_size;
			if (!(_tmp4_ < _tmp5_)) {
				block1_data_unref (_data1_);
				_data1_ = NULL;
				break;
			}
			_tmp6_ = _rule_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _rule_index);
			_data1_->rule = (SecurityPrivacyUFWHelpersRule*) _tmp7_;
			_tmp8_ = _data1_->rule;
			_tmp9_ = security_privacy_firewall_panel_generate_hash_for_rule (self, _tmp8_);
			_data1_->ufw_hash = _tmp9_;
			update_row = _____lambda16__gtk_tree_model_foreach_func;
			update_row_target = block1_data_ref (_data1_);
			update_row_target_destroy_notify = block1_data_unref;
			_tmp10_ = self->priv->list_store;
			_tmp11_ = update_row;
			_tmp11__target = update_row_target;
			gtk_tree_model_foreach ((GtkTreeModel*) _tmp10_, _tmp11_, _tmp11__target);
			(update_row_target_destroy_notify == NULL) ? NULL : (update_row_target_destroy_notify (update_row_target), NULL);
			update_row = NULL;
			update_row_target = NULL;
			update_row_target_destroy_notify = NULL;
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (_rule_list);
	}
}

static void
security_privacy_firewall_panel_show_rules (SecurityPrivacyFirewallPanel* self)
{
	GtkListStore* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->remove_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	{
		GeeLinkedList* _rule_list = NULL;
		GeeLinkedList* _tmp2_;
		gint _rule_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _rule_index = 0;
		_tmp2_ = security_privacy_ufw_helpers_get_rules ();
		_rule_list = _tmp2_;
		_tmp3_ = _rule_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_rule_size = _tmp5_;
		_rule_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			SecurityPrivacyUFWHelpersRule* rule = NULL;
			GeeLinkedList* _tmp8_;
			gpointer _tmp9_;
			SecurityPrivacyUFWHelpersRule* _tmp10_;
			_rule_index = _rule_index + 1;
			_tmp6_ = _rule_index;
			_tmp7_ = _rule_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _rule_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _rule_index);
			rule = (SecurityPrivacyUFWHelpersRule*) _tmp9_;
			_tmp10_ = rule;
			security_privacy_firewall_panel_add_rule (self, _tmp10_, TRUE, "");
			_g_object_unref0 (rule);
		}
		_g_object_unref0 (_rule_list);
	}
	security_privacy_firewall_panel_load_disabled_rules (self);
	{
		GeeIterator* _rule_it = NULL;
		GeeHashMap* _tmp11_;
		GeeSet* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _tmp16_;
		_tmp11_ = self->priv->disabled_rules;
		_tmp12_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_rule_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			GeeMapEntry* rule = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			GeeMapEntry* _tmp20_;
			gconstpointer _tmp21_;
			gconstpointer _tmp22_;
			GeeMapEntry* _tmp23_;
			gconstpointer _tmp24_;
			gconstpointer _tmp25_;
			_tmp17_ = _rule_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _rule_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			rule = (GeeMapEntry*) _tmp19_;
			_tmp20_ = rule;
			_tmp21_ = gee_map_entry_get_value (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = rule;
			_tmp24_ = gee_map_entry_get_key (_tmp23_);
			_tmp25_ = _tmp24_;
			security_privacy_firewall_panel_add_rule (self, (SecurityPrivacyUFWHelpersRule*) _tmp22_, FALSE, (const gchar*) _tmp25_);
			_g_object_unref0 (rule);
		}
		_g_object_unref0 (_rule_it);
	}
}

static void
security_privacy_firewall_panel_disable_rule (SecurityPrivacyFirewallPanel* self,
                                              SecurityPrivacyUFWHelpersRule* rule)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (rule != NULL);
	security_privacy_firewall_panel_save_disabled_rules (self, rule);
	security_privacy_ufw_helpers_remove_rule (rule);
}

static void
security_privacy_firewall_panel_enable_rule (SecurityPrivacyFirewallPanel* self,
                                             const gchar* hash)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	SecurityPrivacyUFWHelpersRule* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hash != NULL);
	_tmp0_ = self->priv->disabled_rules;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, hash);
	_tmp2_ = (SecurityPrivacyUFWHelpersRule*) _tmp1_;
	security_privacy_ufw_helpers_add_rule (_tmp2_);
	_g_object_unref0 (_tmp2_);
	security_privacy_firewall_panel_delete_disabled_rule (self, hash);
}

static void
security_privacy_firewall_panel_delete_disabled_rule (SecurityPrivacyFirewallPanel* self,
                                                      const gchar* hash)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hash != NULL);
	_tmp0_ = self->priv->disabled_rules;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, hash, NULL);
	security_privacy_firewall_panel_save_disabled_rules (self, NULL);
}

static void
security_privacy_firewall_panel_save_disabled_rules (SecurityPrivacyFirewallPanel* self,
                                                     SecurityPrivacyUFWHelpersRule* additional_rule)
{
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GSettings* _tmp31_;
	GVariantBuilder* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_variant_type_new ("a(ssssiiii)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	{
		GeeIterator* _existing_rule_it = NULL;
		GeeHashMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp4_ = self->priv->disabled_rules;
		_tmp5_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_existing_rule_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			SecurityPrivacyUFWHelpersRule* existing_rule = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			GVariantBuilder* _tmp13_;
			SecurityPrivacyUFWHelpersRule* _tmp14_;
			const gchar* _tmp15_;
			SecurityPrivacyUFWHelpersRule* _tmp16_;
			const gchar* _tmp17_;
			SecurityPrivacyUFWHelpersRule* _tmp18_;
			const gchar* _tmp19_;
			SecurityPrivacyUFWHelpersRule* _tmp20_;
			const gchar* _tmp21_;
			SecurityPrivacyUFWHelpersRule* _tmp22_;
			SecurityPrivacyUFWHelpersRule* _tmp23_;
			SecurityPrivacyUFWHelpersRule* _tmp24_;
			SecurityPrivacyUFWHelpersRule* _tmp25_;
			_tmp10_ = _existing_rule_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _existing_rule_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			existing_rule = (SecurityPrivacyUFWHelpersRule*) _tmp12_;
			_tmp13_ = builder;
			_tmp14_ = existing_rule;
			_tmp15_ = _tmp14_->to;
			_tmp16_ = existing_rule;
			_tmp17_ = _tmp16_->to_ports;
			_tmp18_ = existing_rule;
			_tmp19_ = _tmp18_->from;
			_tmp20_ = existing_rule;
			_tmp21_ = _tmp20_->from_ports;
			_tmp22_ = existing_rule;
			_tmp23_ = existing_rule;
			_tmp24_ = existing_rule;
			_tmp25_ = existing_rule;
			g_variant_builder_add (_tmp13_, "(ssssiiii)", _tmp15_, _tmp17_, _tmp19_, _tmp21_, _tmp22_->action, _tmp23_->protocol, _tmp24_->direction, _tmp25_->version, NULL);
			_g_object_unref0 (existing_rule);
		}
		_g_object_unref0 (_existing_rule_it);
	}
	if (additional_rule != NULL) {
		GVariantBuilder* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp26_ = builder;
		_tmp27_ = additional_rule->to;
		_tmp28_ = additional_rule->to_ports;
		_tmp29_ = additional_rule->from;
		_tmp30_ = additional_rule->from_ports;
		g_variant_builder_add (_tmp26_, "(ssssiiii)", _tmp27_, _tmp28_, _tmp29_, _tmp30_, additional_rule->action, additional_rule->protocol, additional_rule->direction, additional_rule->version, NULL);
	}
	_tmp31_ = self->priv->settings;
	_tmp32_ = builder;
	_tmp33_ = g_variant_builder_end (_tmp32_);
	g_variant_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	g_settings_set_value (_tmp31_, "disabled-firewall-rules", _tmp34_);
	_g_variant_unref0 (_tmp34_);
	security_privacy_firewall_panel_load_disabled_rules (self);
	_g_variant_builder_unref0 (builder);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
security_privacy_firewall_panel_add_rule (SecurityPrivacyFirewallPanel* self,
                                          SecurityPrivacyUFWHelpersRule* rule,
                                          gboolean enabled,
                                          const gchar* hash)
{
	gchar* action = NULL;
	gchar* _tmp0_;
	gchar* protocol = NULL;
	gchar* _tmp5_;
	gchar* direction = NULL;
	gchar* _tmp9_;
	gchar* version = NULL;
	gchar* _tmp12_;
	gchar* from = NULL;
	gchar* _tmp15_;
	gchar* to = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp33_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp49_;
	GtkTreeIter _tmp50_ = {0};
	GtkListStore* _tmp51_;
	GtkTreeIter _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rule != NULL);
	g_return_if_fail (hash != NULL);
	_tmp0_ = g_strdup (_ ("Unknown"));
	action = _tmp0_;
	switch (rule->action) {
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_ALLOW:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Allow"));
			_g_free0 (action);
			action = _tmp1_;
			break;
		}
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Deny"));
			_g_free0 (action);
			action = _tmp2_;
			break;
		}
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Reject"));
			_g_free0 (action);
			action = _tmp3_;
			break;
		}
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Limit"));
			_g_free0 (action);
			action = _tmp4_;
			break;
		}
		default:
		break;
	}
	_tmp5_ = g_strdup (_ ("Unknown"));
	protocol = _tmp5_;
	switch (rule->protocol) {
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("UDP");
			_g_free0 (protocol);
			protocol = _tmp6_;
			break;
		}
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_TCP:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("TCP");
			_g_free0 (protocol);
			protocol = _tmp7_;
			break;
		}
		case SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_BOTH:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("TCP/UDP");
			_g_free0 (protocol);
			protocol = _tmp8_;
			break;
		}
		default:
		break;
	}
	_tmp9_ = g_strdup (_ ("Unknown"));
	direction = _tmp9_;
	if (rule->direction == SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_IN) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (_ ("In"));
		_g_free0 (direction);
		direction = _tmp10_;
	} else {
		if (rule->direction == SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Out"));
			_g_free0 (direction);
			direction = _tmp11_;
		}
	}
	_tmp12_ = g_strdup (_ ("Unknown"));
	version = _tmp12_;
	if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("IPv6");
		_g_free0 (version);
		version = _tmp13_;
	} else {
		if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("IPv4");
			_g_free0 (version);
			version = _tmp14_;
		}
	}
	_tmp15_ = g_strdup ("");
	from = _tmp15_;
	_tmp16_ = g_strdup ("");
	to = _tmp16_;
	_tmp17_ = rule->from_ports;
	if (g_strcmp0 (_tmp17_, "") != 0) {
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		_tmp19_ = rule->from_ports;
		if (string_contains (_tmp19_, ":")) {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = rule->from_ports;
			_tmp18_ = string_contains (_tmp20_, ",");
		}
		if (_tmp18_) {
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp21_ = rule->from;
			_tmp22_ = rule->from_ports;
			_tmp23_ = string_replace (_tmp22_, ":", "-");
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (_ ("%s Ports %s"), _tmp21_, _tmp24_);
			_g_free0 (from);
			from = _tmp25_;
			_g_free0 (_tmp24_);
		} else {
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp26_ = rule->from;
			_tmp27_ = rule->from_ports;
			_tmp28_ = string_replace (_tmp27_, ":", "-");
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf (_ ("%s Port %s"), _tmp26_, _tmp29_);
			_g_free0 (from);
			from = _tmp30_;
			_g_free0 (_tmp29_);
		}
	} else {
		const gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp31_ = rule->from;
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (from);
		from = _tmp32_;
	}
	_tmp33_ = rule->to_ports;
	if (g_strcmp0 (_tmp33_, "") != 0) {
		gboolean _tmp34_ = FALSE;
		const gchar* _tmp35_;
		_tmp35_ = rule->to_ports;
		if (string_contains (_tmp35_, ":")) {
			_tmp34_ = TRUE;
		} else {
			const gchar* _tmp36_;
			_tmp36_ = rule->to_ports;
			_tmp34_ = string_contains (_tmp36_, ",");
		}
		if (_tmp34_) {
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			_tmp37_ = rule->to;
			_tmp38_ = rule->to_ports;
			_tmp39_ = string_replace (_tmp38_, ":", "-");
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf (_ ("%s Ports %s"), _tmp37_, _tmp40_);
			_g_free0 (to);
			to = _tmp41_;
			_g_free0 (_tmp40_);
		} else {
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp42_ = rule->to;
			_tmp43_ = rule->to_ports;
			_tmp44_ = string_replace (_tmp43_, ":", "-");
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf (_ ("%s Port %s"), _tmp42_, _tmp45_);
			_g_free0 (to);
			to = _tmp46_;
			_g_free0 (_tmp45_);
		}
	} else {
		const gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp47_ = rule->to;
		_tmp48_ = g_strdup (_tmp47_);
		_g_free0 (to);
		to = _tmp48_;
	}
	_tmp49_ = self->priv->list_store;
	gtk_list_store_append (_tmp49_, &_tmp50_);
	iter = _tmp50_;
	_tmp51_ = self->priv->list_store;
	_tmp52_ = iter;
	_tmp53_ = action;
	_tmp54_ = protocol;
	_tmp55_ = direction;
	_tmp56_ = version;
	_tmp57_ = to;
	_tmp58_ = string_strip (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = from;
	_tmp61_ = string_strip (_tmp60_);
	_tmp62_ = _tmp61_;
	gtk_list_store_set (_tmp51_, &_tmp52_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ACTION, _tmp53_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_PROTOCOL, _tmp54_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_DIRECTION, _tmp55_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_V6, _tmp56_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, enabled, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, rule, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_TO, _tmp59_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_FROM, _tmp62_, -1);
	_g_free0 (_tmp62_);
	_g_free0 (_tmp59_);
	_g_free0 (to);
	_g_free0 (from);
	_g_free0 (version);
	_g_free0 (direction);
	_g_free0 (protocol);
	_g_free0 (action);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SecurityPrivacyFirewallPanel* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->add_button);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__lambda17_ (SecurityPrivacyFirewallPanel* self,
             const gchar* path)
{
	GValue active = {0};
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	GValue _tmp6_ = {0};
	gboolean is_active = FALSE;
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	GValue rule_value = {0};
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	GValue _tmp11_ = {0};
	SecurityPrivacyUFWHelpersRule* rule = NULL;
	GObject* _tmp12_;
	SecurityPrivacyUFWHelpersRule* _tmp13_;
	gchar* gen_hash = NULL;
	SecurityPrivacyUFWHelpersRule* _tmp14_;
	gchar* _tmp15_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = gtk_tree_path_new_from_string (path);
	_tmp2_ = _tmp1_;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	__vala_GtkTreePath_free0 (_tmp2_);
	_tmp4_ = self->priv->list_store;
	_tmp5_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp5_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, &_tmp6_);
	G_IS_VALUE (&active) ? (g_value_unset (&active), NULL) : NULL;
	active = _tmp6_;
	is_active = !g_value_get_boolean (&active);
	_tmp7_ = self->priv->list_store;
	_tmp8_ = iter;
	gtk_list_store_set (_tmp7_, &_tmp8_, SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, is_active, -1);
	_tmp9_ = self->priv->list_store;
	_tmp10_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp9_, &_tmp10_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, &_tmp11_);
	G_IS_VALUE (&rule_value) ? (g_value_unset (&rule_value), NULL) : NULL;
	rule_value = _tmp11_;
	_tmp12_ = g_value_get_object (&rule_value);
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, SecurityPrivacyUFWHelpersRule));
	rule = _tmp13_;
	_tmp14_ = rule;
	_tmp15_ = security_privacy_firewall_panel_generate_hash_for_rule (self, _tmp14_);
	gen_hash = _tmp15_;
	if (is_active == FALSE) {
		SecurityPrivacyUFWHelpersRule* _tmp16_;
		_tmp16_ = rule;
		security_privacy_firewall_panel_disable_rule (self, _tmp16_);
	} else {
		const gchar* _tmp17_;
		_tmp17_ = gen_hash;
		security_privacy_firewall_panel_enable_rule (self, _tmp17_);
	}
	security_privacy_firewall_panel_reload_rule_numbers (self);
	_g_free0 (gen_hash);
	_g_object_unref0 (rule);
	G_IS_VALUE (&rule_value) ? (g_value_unset (&rule_value), NULL) : NULL;
	G_IS_VALUE (&active) ? (g_value_unset (&active), NULL) : NULL;
}

static void
___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
	__lambda17_ ((SecurityPrivacyFirewallPanel*) self, path);
}

static void
__lambda18_ (SecurityPrivacyFirewallPanel* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->remove_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
}

static void
___lambda18__gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                           gpointer self)
{
	__lambda18_ ((SecurityPrivacyFirewallPanel*) self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SecurityPrivacyFirewallPanel* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->add_popover);
		_g_object_unref0 (_data3_->ports_entry);
		_g_object_unref0 (_data3_->direction_combobox);
		_g_object_unref0 (_data3_->version_combobox);
		_g_object_unref0 (_data3_->protocol_combobox);
		_g_object_unref0 (_data3_->policy_combobox);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda20_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	SecurityPrivacyFirewallPanel* self;
	SecurityPrivacyUFWHelpersRule* rule = NULL;
	SecurityPrivacyUFWHelpersRule* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp15_;
	gint _tmp16_;
	SecurityPrivacyUFWHelpersRule* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	SecurityPrivacyUFWHelpersRule* _tmp24_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = security_privacy_ufw_helpers_rule_new ();
	rule = _tmp0_;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _data3_->direction_combobox);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		SecurityPrivacyUFWHelpersRule* _tmp3_;
		_tmp3_ = rule;
		_tmp3_->direction = SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_IN;
	} else {
		SecurityPrivacyUFWHelpersRule* _tmp4_;
		_tmp4_ = rule;
		_tmp4_->direction = SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT;
	}
	_tmp5_ = gtk_combo_box_get_active ((GtkComboBox*) _data3_->protocol_combobox);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		SecurityPrivacyUFWHelpersRule* _tmp7_;
		_tmp7_ = rule;
		_tmp7_->protocol = SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_TCP;
	} else {
		SecurityPrivacyUFWHelpersRule* _tmp8_;
		_tmp8_ = rule;
		_tmp8_->protocol = SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP;
	}
	_tmp9_ = gtk_combo_box_get_active ((GtkComboBox*) _data3_->policy_combobox);
	_tmp10_ = _tmp9_;
	switch (_tmp10_) {
		case 0:
		{
			SecurityPrivacyUFWHelpersRule* _tmp11_;
			_tmp11_ = rule;
			_tmp11_->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_ALLOW;
			break;
		}
		case 1:
		{
			SecurityPrivacyUFWHelpersRule* _tmp12_;
			_tmp12_ = rule;
			_tmp12_->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY;
			break;
		}
		case 2:
		{
			SecurityPrivacyUFWHelpersRule* _tmp13_;
			_tmp13_ = rule;
			_tmp13_->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT;
			break;
		}
		case 3:
		{
			SecurityPrivacyUFWHelpersRule* _tmp14_;
			_tmp14_ = rule;
			_tmp14_->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT;
			break;
		}
		default:
		break;
	}
	_tmp15_ = gtk_combo_box_get_active ((GtkComboBox*) _data3_->version_combobox);
	_tmp16_ = _tmp15_;
	switch (_tmp16_) {
		case 0:
		{
			SecurityPrivacyUFWHelpersRule* _tmp17_;
			_tmp17_ = rule;
			_tmp17_->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4;
			break;
		}
		case 1:
		{
			SecurityPrivacyUFWHelpersRule* _tmp18_;
			_tmp18_ = rule;
			_tmp18_->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6;
			break;
		}
		case 2:
		{
			SecurityPrivacyUFWHelpersRule* _tmp19_;
			_tmp19_ = rule;
			_tmp19_->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH;
			break;
		}
		default:
		break;
	}
	_tmp20_ = rule;
	_tmp21_ = gtk_editable_get_text ((GtkEditable*) _data3_->ports_entry);
	_tmp22_ = _tmp21_;
	_tmp23_ = string_replace (_tmp22_, "-", ":");
	_g_free0 (_tmp20_->to_ports);
	_tmp20_->to_ports = _tmp23_;
	_tmp24_ = rule;
	security_privacy_ufw_helpers_add_rule (_tmp24_);
	gtk_popover_popdown (_data3_->add_popover);
	security_privacy_firewall_panel_show_rules (self);
	_g_object_unref0 (rule);
}

static void
___lambda20__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda20_ (self);
}

static void
__lambda19_ (Block2Data* _data2_)
{
	SecurityPrivacyFirewallPanel* self;
	Block3Data* _data3_;
	GtkComboBoxText* _tmp0_;
	GtkLabel* policy_label = NULL;
	GtkWidget* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkComboBoxText* _tmp3_;
	GtkLabel* protocol_label = NULL;
	GtkWidget* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkComboBoxText* _tmp6_;
	GtkLabel* version_label = NULL;
	GtkWidget* _tmp7_;
	GtkLabel* _tmp8_ = NULL;
	GtkComboBoxText* _tmp9_;
	GtkLabel* direction_label = NULL;
	GtkWidget* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	gchar* _tmp12_;
	GtkEntry* _tmp13_ = NULL;
	GtkLabel* ports_label = NULL;
	GtkWidget* _tmp14_;
	GtkLabel* _tmp15_ = NULL;
	GtkButton* do_add_button = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkGrid* popover_grid = NULL;
	GtkGrid* _tmp17_ = NULL;
	GtkWidget* _tmp18_;
	GtkPopover* _tmp19_ = NULL;
	GtkButton* _tmp20_;
	self = _data2_->self;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->_data2_ = block2_data_ref (_data2_);
	_tmp0_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp0_);
	_data3_->policy_combobox = _tmp0_;
	gtk_combo_box_text_append_text (_data3_->policy_combobox, _ ("Allow"));
	gtk_combo_box_text_append_text (_data3_->policy_combobox, _ ("Deny"));
	gtk_combo_box_text_append_text (_data3_->policy_combobox, _ ("Reject"));
	gtk_combo_box_text_append_text (_data3_->policy_combobox, _ ("Limit"));
	gtk_combo_box_set_active ((GtkComboBox*) _data3_->policy_combobox, 0);
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _data3_->policy_combobox);
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("Action:"));
	gtk_label_set_mnemonic_widget (_tmp2_, _tmp1_);
	_g_object_unref0 (_tmp1_);
	gtk_label_set_xalign (_tmp2_, (gfloat) 1);
	g_object_ref_sink (_tmp2_);
	policy_label = _tmp2_;
	_tmp3_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp3_);
	_data3_->protocol_combobox = _tmp3_;
	gtk_combo_box_text_append_text (_data3_->protocol_combobox, "TCP");
	gtk_combo_box_text_append_text (_data3_->protocol_combobox, "UDP");
	gtk_combo_box_set_active ((GtkComboBox*) _data3_->protocol_combobox, 0);
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _data3_->protocol_combobox);
	_tmp5_ = (GtkLabel*) gtk_label_new (_ ("Protocol:"));
	gtk_label_set_mnemonic_widget (_tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	gtk_label_set_xalign (_tmp5_, (gfloat) 1);
	g_object_ref_sink (_tmp5_);
	protocol_label = _tmp5_;
	_tmp6_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp6_);
	_data3_->version_combobox = _tmp6_;
	gtk_combo_box_text_append_text (_data3_->version_combobox, "IPv4");
	gtk_combo_box_text_append_text (_data3_->version_combobox, "IPv6");
	gtk_combo_box_text_append_text (_data3_->version_combobox, _ ("Both"));
	gtk_combo_box_set_active ((GtkComboBox*) _data3_->version_combobox, 0);
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _data3_->version_combobox);
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("Version:"));
	gtk_label_set_mnemonic_widget (_tmp8_, _tmp7_);
	_g_object_unref0 (_tmp7_);
	gtk_label_set_xalign (_tmp8_, (gfloat) 1);
	g_object_ref_sink (_tmp8_);
	version_label = _tmp8_;
	_tmp9_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp9_);
	_data3_->direction_combobox = _tmp9_;
	gtk_combo_box_text_append_text (_data3_->direction_combobox, _ ("In"));
	gtk_combo_box_text_append_text (_data3_->direction_combobox, _ ("Out"));
	gtk_combo_box_set_active ((GtkComboBox*) _data3_->direction_combobox, 0);
	_tmp10_ = _g_object_ref0 ((GtkWidget*) _data3_->direction_combobox);
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Direction:"));
	gtk_label_set_mnemonic_widget (_tmp11_, _tmp10_);
	_g_object_unref0 (_tmp10_);
	gtk_label_set_xalign (_tmp11_, (gfloat) 1);
	g_object_ref_sink (_tmp11_);
	direction_label = _tmp11_;
	_tmp12_ = g_strdup_printf (_ ("%d or %d-%d"), 80, 80, 85);
	_tmp13_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_input_purpose (_tmp13_, GTK_INPUT_PURPOSE_NUMBER);
	gtk_entry_set_placeholder_text (_tmp13_, _tmp12_);
	_g_free0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	_data3_->ports_entry = _tmp13_;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _data3_->ports_entry);
	_tmp15_ = (GtkLabel*) gtk_label_new (_ ("Ports:"));
	gtk_label_set_mnemonic_widget (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	gtk_label_set_xalign (_tmp15_, (gfloat) 1);
	g_object_ref_sink (_tmp15_);
	ports_label = _tmp15_;
	_tmp16_ = (GtkButton*) gtk_button_new_with_label (_ ("Add Rule"));
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 6);
	g_object_ref_sink (_tmp16_);
	do_add_button = _tmp16_;
	gtk_widget_add_css_class ((GtkWidget*) do_add_button, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 12);
	gtk_grid_set_column_spacing (_tmp17_, 12);
	gtk_grid_set_row_spacing (_tmp17_, 6);
	g_object_ref_sink (_tmp17_);
	popover_grid = _tmp17_;
	gtk_grid_attach (popover_grid, (GtkWidget*) policy_label, 0, 0, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) _data3_->policy_combobox, 1, 0, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) protocol_label, 0, 1, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) _data3_->protocol_combobox, 1, 1, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) version_label, 0, 2, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) _data3_->version_combobox, 1, 2, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) direction_label, 0, 3, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) _data3_->direction_combobox, 1, 3, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) ports_label, 0, 4, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) _data3_->ports_entry, 1, 4, 1, 1);
	gtk_grid_attach (popover_grid, (GtkWidget*) do_add_button, 0, 5, 2, 1);
	_tmp18_ = _g_object_ref0 ((GtkWidget*) popover_grid);
	_tmp19_ = (GtkPopover*) gtk_popover_new ();
	gtk_popover_set_child (_tmp19_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_data3_->add_popover = _tmp19_;
	_tmp20_ = _data2_->add_button;
	gtk_widget_set_parent ((GtkWidget*) _data3_->add_popover, (GtkWidget*) _tmp20_);
	gtk_popover_popup (_data3_->add_popover);
	g_signal_connect_data (do_add_button, "clicked", (GCallback) ___lambda20__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (popover_grid);
	_g_object_unref0 (do_add_button);
	_g_object_unref0 (ports_label);
	_g_object_unref0 (direction_label);
	_g_object_unref0 (version_label);
	_g_object_unref0 (protocol_label);
	_g_object_unref0 (policy_label);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
___lambda19__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda19_ (self);
}

static void
__lambda21_ (SecurityPrivacyFirewallPanel* self)
{
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreePath* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	GValue val = {0};
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_;
	GValue _tmp9_ = {0};
	SecurityPrivacyUFWHelpersRule* rule = NULL;
	GObject* _tmp10_;
	SecurityPrivacyUFWHelpersRule* _tmp11_;
	gchar* gen_hash = NULL;
	SecurityPrivacyUFWHelpersRule* _tmp12_;
	gchar* _tmp13_;
	GValue active = {0};
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	GValue _tmp16_ = {0};
	_tmp0_ = self->priv->view;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, &_tmp2_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_g_object_unref0 (column);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	column = _tmp3_;
	_tmp4_ = self->priv->list_store;
	_tmp5_ = path;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp4_, &_tmp6_, _tmp5_);
	iter = _tmp6_;
	_tmp7_ = self->priv->list_store;
	_tmp8_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp7_, &_tmp8_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_RULE, &_tmp9_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp9_;
	_tmp10_ = g_value_get_object (&val);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, SecurityPrivacyUFWHelpersRule));
	rule = _tmp11_;
	_tmp12_ = rule;
	_tmp13_ = security_privacy_firewall_panel_generate_hash_for_rule (self, _tmp12_);
	gen_hash = _tmp13_;
	_tmp14_ = self->priv->list_store;
	_tmp15_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp14_, &_tmp15_, (gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, &_tmp16_);
	G_IS_VALUE (&active) ? (g_value_unset (&active), NULL) : NULL;
	active = _tmp16_;
	if (g_value_get_boolean (&active)) {
		SecurityPrivacyUFWHelpersRule* _tmp17_;
		_tmp17_ = rule;
		security_privacy_ufw_helpers_remove_rule (_tmp17_);
	} else {
		const gchar* _tmp18_;
		_tmp18_ = gen_hash;
		security_privacy_firewall_panel_delete_disabled_rule (self, _tmp18_);
	}
	security_privacy_firewall_panel_show_rules (self);
	G_IS_VALUE (&active) ? (g_value_unset (&active), NULL) : NULL;
	_g_free0 (gen_hash);
	_g_object_unref0 (rule);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
}

static void
___lambda21__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda21_ ((SecurityPrivacyFirewallPanel*) self);
}

static void
security_privacy_firewall_panel_create_treeview (SecurityPrivacyFirewallPanel* self)
{
	Block2Data* _data2_;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_ = NULL;
	GtkCellRendererToggle* celltoggle = NULL;
	GtkCellRendererToggle* _tmp3_;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkCellRendererToggle* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkTreeView* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkCellRendererToggle* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp22_;
	GtkActionBar* _tmp23_;
	GtkActionBar* _tmp24_;
	GtkButton* _tmp25_;
	GtkActionBar* _tmp26_;
	GtkButton* _tmp27_;
	GtkScrolledWindow* scrolled = NULL;
	GtkTreeView* _tmp28_;
	GtkWidget* _tmp29_;
	GtkScrolledWindow* _tmp30_ = NULL;
	GtkBox* view_box = NULL;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkScrolledWindow* _tmp33_;
	GtkBox* _tmp34_;
	GtkActionBar* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GtkSwitch* _tmp37_;
	GtkSwitch* _tmp38_;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GtkBox* _tmp44_;
	GtkWidget* _tmp45_;
	GtkFrame* _tmp46_ = NULL;
	GtkFrame* _tmp47_;
	GtkTreeView* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gtk_list_store_new ((gint) SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, -1);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp0_;
	_tmp1_ = self->priv->list_store;
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp1_);
	gtk_tree_view_set_activate_on_single_click (_tmp2_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp2_;
	_tmp3_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp3_);
	celltoggle = _tmp3_;
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	cell = _tmp4_;
	_tmp5_ = self->priv->view;
	_tmp6_ = celltoggle;
	gtk_tree_view_insert_column_with_attributes (_tmp5_, -1, _ ("Enabled"), (GtkCellRenderer*) _tmp6_, "active", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ENABLED, NULL);
	_tmp7_ = self->priv->view;
	_tmp8_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp7_, -1, _ ("Version"), (GtkCellRenderer*) _tmp8_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_V6, NULL);
	_tmp9_ = self->priv->view;
	_tmp10_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp9_, -1, _ ("Action"), (GtkCellRenderer*) _tmp10_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_ACTION, NULL);
	_tmp11_ = self->priv->view;
	_tmp12_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp11_, -1, _ ("Protocol"), (GtkCellRenderer*) _tmp12_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_PROTOCOL, NULL);
	_tmp13_ = self->priv->view;
	_tmp14_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp13_, -1, _ ("Direction"), (GtkCellRenderer*) _tmp14_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_DIRECTION, NULL);
	_tmp15_ = self->priv->view;
	_tmp16_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp15_, -1, _ ("To"), (GtkCellRenderer*) _tmp16_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_TO, NULL);
	_tmp17_ = self->priv->view;
	_tmp18_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp17_, -1, _ ("From"), (GtkCellRenderer*) _tmp18_, "text", SECURITY_PRIVACY_FIREWALL_PANEL_COLUMNS_FROM, NULL);
	_tmp19_ = celltoggle;
	g_signal_connect_object (_tmp19_, "toggled", (GCallback) ___lambda17__gtk_cell_renderer_toggle_toggled, self, 0);
	_tmp20_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic");
	g_object_ref_sink (_tmp20_);
	_data2_->add_button = _tmp20_;
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic");
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, FALSE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = _tmp21_;
	_tmp22_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp22_);
	actionbar = _tmp22_;
	_tmp23_ = actionbar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, GRANITE_STYLE_CLASS_FLAT);
	_tmp24_ = actionbar;
	_tmp25_ = _data2_->add_button;
	gtk_action_bar_pack_start (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = actionbar;
	_tmp27_ = self->priv->remove_button;
	gtk_action_bar_pack_start (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->view;
	_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp30_, _tmp29_);
	_g_object_unref0 (_tmp29_);
	g_object_ref_sink (_tmp30_);
	scrolled = _tmp30_;
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp31_);
	view_box = _tmp31_;
	_tmp32_ = view_box;
	_tmp33_ = scrolled;
	gtk_box_append (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = view_box;
	_tmp35_ = actionbar;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp37_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = gtk_switch_get_active (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_) {
		PolkitPermission* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		_tmp41_ = self->priv->permission;
		_tmp42_ = g_permission_get_allowed ((GPermission*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp36_ = _tmp43_;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp44_ = view_box;
	_tmp45_ = _g_object_ref0 ((GtkWidget*) _tmp44_);
	_tmp46_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp46_, _tmp45_);
	_g_object_unref0 (_tmp45_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp46_, _tmp36_);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp46_;
	_tmp47_ = self->priv->frame;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp47_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp48_ = self->priv->view;
	g_signal_connect_object (_tmp48_, "cursor-changed", (GCallback) ___lambda18__gtk_tree_view_cursor_changed, self, 0);
	_tmp49_ = _data2_->add_button;
	g_signal_connect_data (_tmp49_, "clicked", (GCallback) ___lambda19__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp50_ = self->priv->remove_button;
	g_signal_connect_object (_tmp50_, "clicked", (GCallback) ___lambda21__gtk_button_clicked, self, 0);
	_g_object_unref0 (view_box);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (cell);
	_g_object_unref0 (celltoggle);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
security_privacy_firewall_panel_update_status (SecurityPrivacyFirewallPanel* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkFrame* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp1_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		PolkitPermission* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->permission;
		_tmp6_ = g_permission_get_allowed ((GPermission*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = self->priv->frame;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, _tmp0_);
	_tmp9_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_switch_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Enabled"));
		security_privacy_firewall_panel_show_rules (self);
	} else {
		switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
		switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Disabled"));
	}
}

static void
_security_privacy_firewall_panel___lambda22_ (SecurityPrivacyFirewallPanel* self)
{
	if (self->priv->loading == FALSE) {
		GtkSwitch* _tmp0_;
		GtkSwitch* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gtk_switch_get_active (_tmp1_);
		_tmp3_ = _tmp2_;
		security_privacy_ufw_helpers_set_status (_tmp3_);
	}
	security_privacy_firewall_panel_update_status (self);
}

static void
__security_privacy_firewall_panel___lambda22__g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	_security_privacy_firewall_panel___lambda22_ ((SecurityPrivacyFirewallPanel*) self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SecurityPrivacyFirewallPanel* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->lock_button);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_security_privacy_firewall_panel____lambda23_ (Block4Data* _data4_)
{
	SecurityPrivacyFirewallPanel* self;
	PolkitPermission* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkSwitch* _tmp8_;
	GtkSwitch* _tmp9_;
	PolkitPermission* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	GtkSwitch* _tmp14_;
	GtkSwitch* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GtkFrame* _tmp21_;
	self = _data4_->self;
	_tmp0_ = self->priv->permission;
	_tmp1_ = g_permission_get_allowed ((GPermission*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkSwitch* _tmp3_;
		GtkSwitch* _tmp4_;
		GtkButton* _tmp5_;
		GtkButton* _tmp6_;
		self->priv->loading = TRUE;
		_tmp3_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp4_ = _tmp3_;
		gtk_switch_set_active (_tmp4_, security_privacy_ufw_helpers_get_status ());
		_tmp5_ = self->priv->remove_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
		self->priv->loading = FALSE;
		_tmp6_ = _data4_->lock_button;
		gtk_button_set_label (_tmp6_, _ ("Lock"));
	} else {
		GtkButton* _tmp7_;
		_tmp7_ = _data4_->lock_button;
		gtk_button_set_label (_tmp7_, _ ("Unlock"));
	}
	_tmp8_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->permission;
	_tmp11_ = g_permission_get_allowed ((GPermission*) _tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp12_);
	_tmp14_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gtk_switch_get_active (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		PolkitPermission* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp18_ = self->priv->permission;
		_tmp19_ = g_permission_get_allowed ((GPermission*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp13_ = _tmp20_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp21_ = self->priv->frame;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, _tmp13_);
}

static void
__security_privacy_firewall_panel____lambda23__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_security_privacy_firewall_panel____lambda23_ (self);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
_security_privacy_firewall_panel____lambda24_ (SecurityPrivacyFirewallPanel* self)
{
	PolkitPermission* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->permission;
	_tmp1_ = g_permission_get_allowed ((GPermission*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		{
			PolkitPermission* _tmp3_;
			_tmp3_ = self->priv->permission;
			g_permission_release ((GPermission*) _tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_critical ("FirewallPanel.vala:97: Unable to release permission: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		{
			PolkitPermission* _tmp6_;
			_tmp6_ = self->priv->permission;
			g_permission_acquire ((GPermission*) _tmp6_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			if (!g_error_matches (_tmp7_, g_io_error_quark (), G_IO_ERROR_CANCELLED)) {
				GraniteMessageDialog* message_dialog = NULL;
				GThemedIcon* _tmp8_;
				GThemedIcon* _tmp9_;
				GThemedIcon* _tmp10_;
				GtkRoot* _tmp11_;
				GtkWindow* _tmp12_;
				GraniteMessageDialog* _tmp13_ = NULL;
				GraniteMessageDialog* _tmp14_;
				GraniteMessageDialog* _tmp15_;
				GError* _tmp16_;
				const gchar* _tmp17_;
				GraniteMessageDialog* _tmp18_;
				GraniteMessageDialog* _tmp19_;
				GraniteMessageDialog* _tmp20_;
				_tmp8_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
				_tmp9_ = _tmp8_;
				_tmp10_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
				_tmp11_ = gtk_widget_get_root ((GtkWidget*) self);
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
				_tmp13_ = granite_message_dialog_new (_ ("Unable to acquire permission"), _ ("Firewall rules can't be changed without the required system permission" \
"."), (GIcon*) _tmp9_, GTK_BUTTONS_CLOSE);
				granite_message_dialog_set_badge_icon (_tmp13_, (GIcon*) _tmp10_);
				_g_object_unref0 (_tmp10_);
				gtk_window_set_modal ((GtkWindow*) _tmp13_, TRUE);
				gtk_window_set_transient_for ((GtkWindow*) _tmp13_, _tmp12_);
				_g_object_unref0 (_tmp12_);
				g_object_ref_sink (_tmp13_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp9_);
				message_dialog = _tmp14_;
				_tmp15_ = message_dialog;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				granite_message_dialog_show_error_details (_tmp15_, _tmp17_);
				_tmp18_ = message_dialog;
				_tmp19_ = message_dialog;
				g_signal_connect_object ((GtkDialog*) _tmp18_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp19_, 0);
				_tmp20_ = message_dialog;
				gtk_window_present ((GtkWindow*) _tmp20_);
				_g_object_unref0 (message_dialog);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
__security_privacy_firewall_panel____lambda24__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	_security_privacy_firewall_panel____lambda24_ ((SecurityPrivacyFirewallPanel*) self);
}

static GObject *
security_privacy_firewall_panel_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SecurityPrivacyFirewallPanel * self;
	GSettings* _tmp0_;
	GeeHashMap* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (security_privacy_firewall_panel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_FIREWALL_PANEL, SecurityPrivacyFirewallPanel);
	_tmp0_ = g_settings_new ("io.elementary.settings.security-privacy");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->disabled_rules);
	self->priv->disabled_rules = _tmp1_;
	security_privacy_firewall_panel_load_disabled_rules (self);
	_tmp2_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::active", (GCallback) __security_privacy_firewall_panel___lambda22__g_object_notify, self, 0);
	security_privacy_firewall_panel_create_treeview (self);
	{
		Block4Data* _data4_;
		PolkitPermission* _tmp4_ = NULL;
		PolkitUnixProcess* _tmp5_;
		PolkitUnixProcess* _tmp6_;
		PolkitPermission* _tmp7_;
		PolkitPermission* _tmp8_;
		PolkitPermission* _tmp9_;
		GtkButton* _tmp10_;
		GtkSwitch* _tmp11_;
		GtkSwitch* _tmp12_;
		PolkitPermission* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		PolkitPermission* _tmp16_;
		GtkButton* _tmp17_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp5_ = (PolkitUnixProcess*) polkit_unix_process_new ((gint) getpid ());
		_tmp6_ = _tmp5_;
		_tmp7_ = (PolkitPermission*) polkit_permission_new_sync ("io.elementary.settings.security-privacy", (PolkitSubject*) _tmp6_, NULL, &_inner_error0_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp4_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block4_data_unref (_data4_);
			_data4_ = NULL;
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->permission);
		self->priv->permission = _tmp9_;
		_tmp10_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Unlock"));
		_data4_->lock_button = _tmp10_;
		_tmp11_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->permission;
		_tmp14_ = g_permission_get_allowed ((GPermission*) _tmp13_);
		_tmp15_ = _tmp14_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, _tmp15_);
		_tmp16_ = self->priv->permission;
		g_signal_connect_data ((GObject*) _tmp16_, "notify::allowed", (GCallback) __security_privacy_firewall_panel____lambda23__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp17_ = _data4_->lock_button;
		g_signal_connect_object (_tmp17_, "clicked", (GCallback) __security_privacy_firewall_panel____lambda24__gtk_button_clicked, self, 0);
		_g_object_unref0 (_tmp4_);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_critical ("FirewallPanel.vala:123: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
security_privacy_firewall_panel_class_init (SecurityPrivacyFirewallPanelClass * klass,
                                            gpointer klass_data)
{
	security_privacy_firewall_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SecurityPrivacyFirewallPanel_private_offset);
	G_OBJECT_CLASS (klass)->constructor = security_privacy_firewall_panel_constructor;
	G_OBJECT_CLASS (klass)->finalize = security_privacy_firewall_panel_finalize;
}

static void
security_privacy_firewall_panel_instance_init (SecurityPrivacyFirewallPanel * self,
                                               gpointer klass)
{
	self->priv = security_privacy_firewall_panel_get_instance_private (self);
	self->priv->loading = FALSE;
}

static void
security_privacy_firewall_panel_finalize (GObject * obj)
{
	SecurityPrivacyFirewallPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_TYPE_FIREWALL_PANEL, SecurityPrivacyFirewallPanel);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->remove_button);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->disabled_rules);
	_g_object_unref0 (self->priv->permission);
	G_OBJECT_CLASS (security_privacy_firewall_panel_parent_class)->finalize (obj);
}

static GType
security_privacy_firewall_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyFirewallPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_firewall_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyFirewallPanel), 0, (GInstanceInitFunc) security_privacy_firewall_panel_instance_init, NULL };
	GType security_privacy_firewall_panel_type_id;
	security_privacy_firewall_panel_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "SecurityPrivacyFirewallPanel", &g_define_type_info, 0);
	SecurityPrivacyFirewallPanel_private_offset = g_type_add_instance_private (security_privacy_firewall_panel_type_id, sizeof (SecurityPrivacyFirewallPanelPrivate));
	return security_privacy_firewall_panel_type_id;
}

GType
security_privacy_firewall_panel_get_type (void)
{
	static volatile gsize security_privacy_firewall_panel_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_firewall_panel_type_id__once)) {
		GType security_privacy_firewall_panel_type_id;
		security_privacy_firewall_panel_type_id = security_privacy_firewall_panel_get_type_once ();
		g_once_init_leave (&security_privacy_firewall_panel_type_id__once, security_privacy_firewall_panel_type_id);
	}
	return security_privacy_firewall_panel_type_id__once;
}

