/* Plug.c generated by valac 0.56.17, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PLUG_0_PROPERTY,
	PRINTERS_PLUG_NUM_PROPERTIES
};
static GParamSpec* printers_plug_properties[PRINTERS_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PrintersPlugSearchData PrintersPlugSearchData;

struct _PrintersPlugPrivate {
	GtkPaned* main_paned;
	GtkStack* main_stack;
	PrintersPrinterList* list;
};

struct _PrintersPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PrintersPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* _tmp0_;
};

static gint PrintersPlug_private_offset;
static gpointer printers_plug_parent_class = NULL;

static GtkWidget* printers_plug_real_get_widget (SwitchboardPlug* base);
static void printers_plug_update_alert_visible (PrintersPlug* self);
static void ___lambda46_ (PrintersPlug* self);
static void ____lambda46__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void printers_plug_real_shown (SwitchboardPlug* base);
static void printers_plug_real_hidden (SwitchboardPlug* base);
static void printers_plug_real_search_callback (SwitchboardPlug* base,
                                         const gchar* location);
static void printers_plug_real_search_data_free (gpointer _data);
static void printers_plug_real_search (SwitchboardPlug* base,
                                const gchar* search,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static gboolean printers_plug_real_search_co (PrintersPlugSearchData* _data_);
static void printers_plug_finalize (GObject * obj);
static GType printers_plug_get_type_once (void);

static inline gpointer
printers_plug_get_instance_private (PrintersPlug* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPlug_private_offset);
}

PrintersPlug*
printers_plug_construct (GType object_type)
{
	PrintersPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (BUILD_GETTEXT_PACKAGE, BUILD_LOCALEDIR);
	bind_textdomain_codeset (BUILD_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "printer", NULL);
	self = (PrintersPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.printers", "display-name", _ ("Printers"), "description", _ ("Configure printers, manage print queues, and view ink levels"), "icon", "printer", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

PrintersPlug*
printers_plug_new (void)
{
	return printers_plug_construct (PRINTERS_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda46_ (PrintersPlug* self)
{
	printers_plug_update_alert_visible (self);
}

static void
____lambda46__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda46_ ((PrintersPlug*) self);
}

static GtkWidget*
printers_plug_real_get_widget (SwitchboardPlug* base)
{
	PrintersPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp19_;
	GtkWidget* _tmp20_;
	GtkWidget* result;
	self = (PrintersPlug*) base;
	_tmp0_ = self->priv->main_paned;
	if (_tmp0_ == NULL) {
		GtkStack* stack = NULL;
		GtkStack* _tmp1_ = NULL;
		GtkStack* _tmp2_;
		PrintersPrinterList* _tmp3_;
		GranitePlaceholder* empty_alert = NULL;
		gchar* _tmp4_;
		GThemedIcon* _tmp5_;
		GranitePlaceholder* _tmp6_ = NULL;
		GranitePlaceholder* _tmp7_;
		GtkStack* _tmp8_ = NULL;
		GtkStack* _tmp9_;
		GranitePlaceholder* _tmp10_;
		GtkStack* _tmp11_;
		GtkStack* _tmp12_;
		PrintersPrinterList* _tmp13_;
		GtkWidget* _tmp14_;
		GtkStack* _tmp15_;
		GtkWidget* _tmp16_;
		GtkPaned* _tmp17_ = NULL;
		PrintersPrinterList* _tmp18_;
		_tmp1_ = (GtkStack*) gtk_stack_new ();
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
		g_object_ref_sink (_tmp1_);
		stack = _tmp1_;
		_tmp2_ = stack;
		_tmp3_ = printers_printer_list_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->list);
		self->priv->list = _tmp3_;
		_tmp4_ = g_strdup (_ ("Connect to a printer by clicking the icon in the toolbar below."));
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("printer-error");
		_tmp6_ = granite_placeholder_new (_ ("No Printers Available"));
		granite_placeholder_set_description (_tmp6_, _tmp4_);
		_g_free0 (_tmp4_);
		granite_placeholder_set_icon (_tmp6_, (GIcon*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
		g_object_ref_sink (_tmp6_);
		empty_alert = _tmp6_;
		_tmp7_ = empty_alert;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_VIEW);
		_tmp8_ = (GtkStack*) gtk_stack_new ();
		gtk_stack_set_transition_type (_tmp8_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (self->priv->main_stack);
		self->priv->main_stack = _tmp8_;
		_tmp9_ = self->priv->main_stack;
		_tmp10_ = empty_alert;
		gtk_stack_add_named (_tmp9_, (GtkWidget*) _tmp10_, "empty-alert");
		_tmp11_ = self->priv->main_stack;
		_tmp12_ = stack;
		gtk_stack_add_named (_tmp11_, (GtkWidget*) _tmp12_, "main-paned");
		_tmp13_ = self->priv->list;
		_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
		_tmp15_ = self->priv->main_stack;
		_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
		_tmp17_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp17_, _tmp14_);
		_g_object_unref0 (_tmp14_);
		gtk_paned_set_resize_start_child (_tmp17_, FALSE);
		gtk_paned_set_shrink_start_child (_tmp17_, FALSE);
		gtk_paned_set_end_child (_tmp17_, _tmp16_);
		_g_object_unref0 (_tmp16_);
		gtk_paned_set_resize_end_child (_tmp17_, TRUE);
		gtk_paned_set_shrink_end_child (_tmp17_, FALSE);
		g_object_ref_sink (_tmp17_);
		_g_object_unref0 (self->priv->main_paned);
		self->priv->main_paned = _tmp17_;
		printers_plug_update_alert_visible (self);
		_tmp18_ = self->priv->list;
		g_signal_connect_object ((GObject*) _tmp18_, "notify::has-child", (GCallback) ____lambda46__g_object_notify, self, 0);
		_g_object_unref0 (empty_alert);
		_g_object_unref0 (stack);
	}
	_tmp19_ = self->priv->main_paned;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	result = _tmp20_;
	return result;
}

static void
printers_plug_update_alert_visible (PrintersPlug* self)
{
	PrintersPrinterList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = printers_printer_list_get_has_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->main_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "main-paned");
	} else {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->main_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "empty-alert");
	}
}

static void
printers_plug_real_shown (SwitchboardPlug* base)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
}

static void
printers_plug_real_hidden (SwitchboardPlug* base)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
}

static void
printers_plug_real_search_callback (SwitchboardPlug* base,
                                    const gchar* location)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
printers_plug_real_search_data_free (gpointer _data)
{
	PrintersPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PrintersPlugSearchData, _data_);
}

static void
printers_plug_real_search (SwitchboardPlug* base,
                           const gchar* search,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	PrintersPlug * self;
	PrintersPlugSearchData* _data_;
	PrintersPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (PrintersPlug*) base;
	_data_ = g_slice_new0 (PrintersPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, printers_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	printers_plug_real_search_co (_data_);
}

static GeeTreeMap*
printers_plug_search_finish (SwitchboardPlug* base,
                             GAsyncResult* _res_)
{
	GeeTreeMap* result;
	PrintersPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
printers_plug_real_search_co (PrintersPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
printers_plug_class_init (PrintersPlugClass * klass,
                          gpointer klass_data)
{
	printers_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) printers_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) printers_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) printers_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) printers_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) printers_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) printers_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = printers_plug_finalize;
}

static void
printers_plug_instance_init (PrintersPlug * self,
                             gpointer klass)
{
	self->priv = printers_plug_get_instance_private (self);
}

static void
printers_plug_finalize (GObject * obj)
{
	PrintersPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PLUG, PrintersPlug);
	_g_object_unref0 (self->priv->main_paned);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (printers_plug_parent_class)->finalize (obj);
}

static GType
printers_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPlug), 0, (GInstanceInitFunc) printers_plug_instance_init, NULL };
	GType printers_plug_type_id;
	printers_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "PrintersPlug", &g_define_type_info, 0);
	PrintersPlug_private_offset = g_type_add_instance_private (printers_plug_type_id, sizeof (PrintersPlugPrivate));
	return printers_plug_type_id;
}

GType
printers_plug_get_type (void)
{
	static volatile gsize printers_plug_type_id__once = 0;
	if (g_once_init_enter (&printers_plug_type_id__once)) {
		GType printers_plug_type_id;
		printers_plug_type_id = printers_plug_get_type_once ();
		g_once_init_leave (&printers_plug_type_id__once, printers_plug_type_id);
	}
	return printers_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	PrintersPlug* plug = NULL;
	PrintersPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:97: Activating Printers plug");
	_tmp0_ = printers_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

