/* DesktopFileEnumerator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DesktopFileEnumerator.vala, do not modify */

/*
* Copyright 2013-2018 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Julien Spautz <spautz.julien@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "applications.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR (startup_backend_desktop_file_enumerator_get_type ())
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumerator))
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumeratorClass))
#define STARTUP_BACKEND_IS_DESKTOP_FILE_ENUMERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR))
#define STARTUP_BACKEND_IS_DESKTOP_FILE_ENUMERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR))
#define STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumeratorClass))

typedef struct _StartupBackendDesktopFileEnumerator StartupBackendDesktopFileEnumerator;
typedef struct _StartupBackendDesktopFileEnumeratorClass StartupBackendDesktopFileEnumeratorClass;
typedef struct _StartupBackendDesktopFileEnumeratorPrivate StartupBackendDesktopFileEnumeratorPrivate;
enum  {
	STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_0_PROPERTY,
	STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_NUM_PROPERTIES
};
static GParamSpec* startup_backend_desktop_file_enumerator_properties[STARTUP_BACKEND_DESKTOP_FILE_ENUMERATOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _StartupBackendDesktopFileEnumerator {
	GObject parent_instance;
	StartupBackendDesktopFileEnumeratorPrivate * priv;
};

struct _StartupBackendDesktopFileEnumeratorClass {
	GObjectClass parent_class;
};

struct _StartupBackendDesktopFileEnumeratorPrivate {
	gchar** dirs;
	gint dirs_length1;
	gint _dirs_size_;
};

static gint StartupBackendDesktopFileEnumerator_private_offset;
static gpointer startup_backend_desktop_file_enumerator_parent_class = NULL;

VALA_EXTERN GType startup_backend_desktop_file_enumerator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StartupBackendDesktopFileEnumerator* startup_backend_desktop_file_enumerator_new (gchar** dirs,
                                                                                  gint dirs_length1);
VALA_EXTERN StartupBackendDesktopFileEnumerator* startup_backend_desktop_file_enumerator_construct (GType object_type,
                                                                                        gchar** dirs,
                                                                                        gint dirs_length1);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
VALA_EXTERN gchar** startup_backend_desktop_file_enumerator_get_desktop_files (StartupBackendDesktopFileEnumerator* self,
                                                                   gint* result_length1);
static gchar** startup_backend_desktop_file_enumerator_enumerate_children (StartupBackendDesktopFileEnumerator* self,
                                                                    const gchar* dir,
                                                                    gint* result_length1,
                                                                    GError** error);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void startup_backend_desktop_file_enumerator_finalize (GObject * obj);
static GType startup_backend_desktop_file_enumerator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
startup_backend_desktop_file_enumerator_get_instance_private (StartupBackendDesktopFileEnumerator* self)
{
	return G_STRUCT_MEMBER_P (self, StartupBackendDesktopFileEnumerator_private_offset);
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

StartupBackendDesktopFileEnumerator*
startup_backend_desktop_file_enumerator_construct (GType object_type,
                                                   gchar** dirs,
                                                   gint dirs_length1)
{
	StartupBackendDesktopFileEnumerator * self = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (StartupBackendDesktopFileEnumerator*) g_object_new (object_type, NULL);
	_tmp0_ = (dirs != NULL) ? _vala_array_dup3 (dirs, dirs_length1) : dirs;
	_tmp0__length1 = dirs_length1;
	self->priv->dirs = (_vala_array_free (self->priv->dirs, self->priv->dirs_length1, (GDestroyNotify) g_free), NULL);
	self->priv->dirs = _tmp0_;
	self->priv->dirs_length1 = _tmp0__length1;
	self->priv->_dirs_size_ = self->priv->dirs_length1;
	return self;
}

StartupBackendDesktopFileEnumerator*
startup_backend_desktop_file_enumerator_new (gchar** dirs,
                                             gint dirs_length1)
{
	return startup_backend_desktop_file_enumerator_construct (STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, dirs, dirs_length1);
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar**
startup_backend_desktop_file_enumerator_get_desktop_files (StartupBackendDesktopFileEnumerator* self,
                                                           gint* result_length1)
{
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = self->priv->dirs;
	_tmp1__length1 = self->priv->dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp1_;
		dir_collection_length1 = _tmp1__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp2_;
			gchar* dir = NULL;
			_tmp2_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp2_;
			{
				{
					gchar** _tmp3_ = NULL;
					const gchar* _tmp4_;
					gint _tmp5_ = 0;
					gchar** _tmp6_;
					gint _tmp3__length1;
					gint __tmp3__size_;
					_tmp4_ = dir;
					_tmp6_ = startup_backend_desktop_file_enumerator_enumerate_children (self, _tmp4_, &_tmp5_, &_inner_error0_);
					_tmp3_ = _tmp6_;
					_tmp3__length1 = _tmp5_;
					__tmp3__size_ = _tmp3__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					{
						gchar** name_collection = NULL;
						gint name_collection_length1 = 0;
						gint _name_collection_size_ = 0;
						gint name_it = 0;
						name_collection = _tmp3_;
						name_collection_length1 = _tmp3__length1;
						for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
							gchar* _tmp7_;
							gchar* name = NULL;
							_tmp7_ = g_strdup (name_collection[name_it]);
							name = _tmp7_;
							{
								const gchar* _tmp8_;
								_tmp8_ = name;
								if (startup_utils_is_desktop_file (_tmp8_)) {
									const gchar* _tmp9_;
									const gchar* _tmp10_;
									gchar* _tmp11_;
									_tmp9_ = dir;
									_tmp10_ = name;
									_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
									_vala_array_add3 (&_result_, &_result__length1, &__result__size_, _tmp11_);
								}
								_g_free0 (name);
							}
						}
					}
					_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GError* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp12_ = dir;
					_tmp13_ = string_to_string (_tmp12_);
					_tmp14_ = e;
					_tmp15_ = _tmp14_->message;
					_tmp16_ = string_to_string (_tmp15_);
					_tmp17_ = g_strconcat ("Error inside ", _tmp13_, ": ", _tmp16_, NULL);
					_tmp18_ = _tmp17_;
					g_warning ("DesktopFileEnumerator.vala:44: %s", _tmp18_);
					_g_free0 (_tmp18_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (dir);
					_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (dir);
			}
		}
	}
	_tmp19_ = _result_;
	_tmp19__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
startup_backend_desktop_file_enumerator_enumerate_children (StartupBackendDesktopFileEnumerator* self,
                                                            const gchar* dir,
                                                            gint* result_length1,
                                                            GError** error)
{
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	GFileInfo* file_info = NULL;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileEnumerator* _tmp3_;
	GFileEnumerator* _tmp4_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = g_file_new_for_path (dir);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	enumerator = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	while (TRUE) {
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = enumerator;
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (file_info);
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp8_;
		_tmp9_ = file_info;
		if (!(_tmp9_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			break;
		}
		_tmp10_ = file_info;
		_tmp11_ = g_file_info_get_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_vala_array_add4 (&_result_, &_result__length1, &__result__size_, _tmp12_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp13_ = _result_;
	_tmp13__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_g_object_unref0 (enumerator);
	_g_object_unref0 (file_info);
	return result;
}

static void
startup_backend_desktop_file_enumerator_class_init (StartupBackendDesktopFileEnumeratorClass * klass,
                                                    gpointer klass_data)
{
	startup_backend_desktop_file_enumerator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StartupBackendDesktopFileEnumerator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = startup_backend_desktop_file_enumerator_finalize;
}

static void
startup_backend_desktop_file_enumerator_instance_init (StartupBackendDesktopFileEnumerator * self,
                                                       gpointer klass)
{
	self->priv = startup_backend_desktop_file_enumerator_get_instance_private (self);
}

static void
startup_backend_desktop_file_enumerator_finalize (GObject * obj)
{
	StartupBackendDesktopFileEnumerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STARTUP_BACKEND_TYPE_DESKTOP_FILE_ENUMERATOR, StartupBackendDesktopFileEnumerator);
	self->priv->dirs = (_vala_array_free (self->priv->dirs, self->priv->dirs_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (startup_backend_desktop_file_enumerator_parent_class)->finalize (obj);
}

/**
 * This class lists all .desktop files in a given directory.
 */
static GType
startup_backend_desktop_file_enumerator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StartupBackendDesktopFileEnumeratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) startup_backend_desktop_file_enumerator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartupBackendDesktopFileEnumerator), 0, (GInstanceInitFunc) startup_backend_desktop_file_enumerator_instance_init, NULL };
	GType startup_backend_desktop_file_enumerator_type_id;
	startup_backend_desktop_file_enumerator_type_id = g_type_register_static (G_TYPE_OBJECT, "StartupBackendDesktopFileEnumerator", &g_define_type_info, 0);
	StartupBackendDesktopFileEnumerator_private_offset = g_type_add_instance_private (startup_backend_desktop_file_enumerator_type_id, sizeof (StartupBackendDesktopFileEnumeratorPrivate));
	return startup_backend_desktop_file_enumerator_type_id;
}

GType
startup_backend_desktop_file_enumerator_get_type (void)
{
	static volatile gsize startup_backend_desktop_file_enumerator_type_id__once = 0;
	if (g_once_init_enter (&startup_backend_desktop_file_enumerator_type_id__once)) {
		GType startup_backend_desktop_file_enumerator_type_id;
		startup_backend_desktop_file_enumerator_type_id = startup_backend_desktop_file_enumerator_get_type_once ();
		g_once_init_leave (&startup_backend_desktop_file_enumerator_type_id__once, startup_backend_desktop_file_enumerator_type_id);
	}
	return startup_backend_desktop_file_enumerator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

