/* WelcomeDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WelcomeDialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#define RESOURCES_OK_LABEL _ ("_OK")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_WELCOME_SERVICE_ENTRY (welcome_service_entry_get_type ())
#define WELCOME_SERVICE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WELCOME_SERVICE_ENTRY, WelcomeServiceEntry))
#define IS_WELCOME_SERVICE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WELCOME_SERVICE_ENTRY))
#define WELCOME_SERVICE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_WELCOME_SERVICE_ENTRY, WelcomeServiceEntryIface))

typedef struct _WelcomeServiceEntry WelcomeServiceEntry;
typedef struct _WelcomeServiceEntryIface WelcomeServiceEntryIface;

#define TYPE_WELCOME_DIALOG (welcome_dialog_get_type ())
#define WELCOME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WELCOME_DIALOG, WelcomeDialog))
#define WELCOME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WELCOME_DIALOG, WelcomeDialogClass))
#define IS_WELCOME_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WELCOME_DIALOG))
#define IS_WELCOME_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WELCOME_DIALOG))
#define WELCOME_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WELCOME_DIALOG, WelcomeDialogClass))

typedef struct _WelcomeDialog WelcomeDialog;
typedef struct _WelcomeDialogClass WelcomeDialogClass;
typedef struct _WelcomeDialogPrivate WelcomeDialogPrivate;

#define SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST (spit_data_imports_welcome_import_meta_host_get_type ())
#define SPIT_DATA_IMPORTS_WELCOME_IMPORT_META_HOST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST, SpitDataImportsWelcomeImportMetaHost))
#define SPIT_DATA_IMPORTS_WELCOME_IMPORT_META_HOST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST, SpitDataImportsWelcomeImportMetaHostClass))
#define SPIT_DATA_IMPORTS_IS_WELCOME_IMPORT_META_HOST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST))
#define SPIT_DATA_IMPORTS_IS_WELCOME_IMPORT_META_HOST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST))
#define SPIT_DATA_IMPORTS_WELCOME_IMPORT_META_HOST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPIT_DATA_IMPORTS_TYPE_WELCOME_IMPORT_META_HOST, SpitDataImportsWelcomeImportMetaHostClass))

typedef struct _SpitDataImportsWelcomeImportMetaHost SpitDataImportsWelcomeImportMetaHost;
typedef struct _SpitDataImportsWelcomeImportMetaHostClass SpitDataImportsWelcomeImportMetaHostClass;
enum  {
	WELCOME_DIALOG_0_PROPERTY,
	WELCOME_DIALOG_NUM_PROPERTIES
};
static GParamSpec* welcome_dialog_properties[WELCOME_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WelcomeServiceEntryIface {
	GTypeInterface parent_iface;
	gchar* (*get_service_name) (WelcomeServiceEntry* self);
	void (*execute) (WelcomeServiceEntry* self);
};

struct _WelcomeDialog {
	GtkDialog parent_instance;
	WelcomeDialogPrivate * priv;
};

struct _WelcomeDialogClass {
	GtkDialogClass parent_class;
};

struct _WelcomeDialogPrivate {
	GtkCheckButton* hide_button;
	GtkCheckButton* system_pictures_import_check;
	GtkCheckButton** external_import_checks;
	gint external_import_checks_length1;
	gint _external_import_checks_size_;
	WelcomeServiceEntry** external_import_entries;
	gint external_import_entries_length1;
	gint _external_import_entries_size_;
	GtkLabel* secondary_text;
	GtkLabel* instruction_header;
	GtkBox* import_content;
	GtkBox* import_action_checkbox_packer;
	GtkBox* external_import_action_checkbox_packer;
	SpitDataImportsWelcomeImportMetaHost* import_meta_host;
	gboolean import_content_already_installed;
	gboolean ok_clicked;
};

static gint WelcomeDialog_private_offset;
static gpointer welcome_dialog_parent_class = NULL;

VALA_EXTERN GType welcome_service_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WelcomeServiceEntry, g_object_unref)
VALA_EXTERN gchar* welcome_service_entry_get_service_name (WelcomeServiceEntry* self);
VALA_EXTERN void welcome_service_entry_execute (WelcomeServiceEntry* self);
static GType welcome_service_entry_get_type_once (void);
VALA_EXTERN GType welcome_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WelcomeDialog, g_object_unref)
VALA_EXTERN GType spit_data_imports_welcome_import_meta_host_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpitDataImportsWelcomeImportMetaHost, g_object_unref)
VALA_EXTERN WelcomeDialog* welcome_dialog_new (GtkWindow* owner);
VALA_EXTERN WelcomeDialog* welcome_dialog_construct (GType object_type,
                                         GtkWindow* owner);
VALA_EXTERN gint resources_use_header_bar (void);
VALA_EXTERN SpitDataImportsWelcomeImportMetaHost* spit_data_imports_welcome_import_meta_host_new (WelcomeDialog* dialog);
VALA_EXTERN SpitDataImportsWelcomeImportMetaHost* spit_data_imports_welcome_import_meta_host_construct (GType object_type,
                                                                                            WelcomeDialog* dialog);
static gboolean welcome_dialog_is_system_pictures_import_possible (void);
VALA_EXTERN gchar* get_display_pathname (GFile* file);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
static void welcome_dialog_install_import_content (WelcomeDialog* self);
VALA_EXTERN void spit_data_imports_welcome_import_meta_host_start (SpitDataImportsWelcomeImportMetaHost* self);
VALA_EXTERN void welcome_dialog_install_service_entry (WelcomeDialog* self,
                                           WelcomeServiceEntry* entry);
static void _vala_array_add131 (WelcomeServiceEntry** * array,
                         gint* length,
                         gint* size,
                         WelcomeServiceEntry* value);
static void _vala_array_add132 (GtkCheckButton** * array,
                         gint* length,
                         gint* size,
                         GtkCheckButton* value);
static void welcome_dialog_on_dismiss (WelcomeDialog* self,
                                gint resp);
VALA_EXTERN gboolean welcome_dialog_execute (WelcomeDialog* self,
                                 WelcomeServiceEntry*** selected_import_entries,
                                 gint* selected_import_entries_length1,
                                 gboolean* do_system_pictures_import);
static void _welcome_dialog_on_dismiss_gtk_dialog_response (GtkDialog* _sender,
                                                     gint response_id,
                                                     gpointer self);
static void _vala_array_add133 (WelcomeServiceEntry** * array,
                         gint* length,
                         gint* size,
                         WelcomeServiceEntry* value);
static WelcomeServiceEntry** _vala_array_dup37 (WelcomeServiceEntry** self,
                                         gssize length);
static void welcome_dialog_finalize (GObject * obj);
static GType welcome_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
welcome_service_entry_get_service_name (WelcomeServiceEntry* self)
{
	WelcomeServiceEntryIface* _iface_;
	g_return_val_if_fail (IS_WELCOME_SERVICE_ENTRY (self), NULL);
	_iface_ = WELCOME_SERVICE_ENTRY_GET_INTERFACE (self);
	if (_iface_->get_service_name) {
		return _iface_->get_service_name (self);
	}
	return NULL;
}

void
welcome_service_entry_execute (WelcomeServiceEntry* self)
{
	WelcomeServiceEntryIface* _iface_;
	g_return_if_fail (IS_WELCOME_SERVICE_ENTRY (self));
	_iface_ = WELCOME_SERVICE_ENTRY_GET_INTERFACE (self);
	if (_iface_->execute) {
		_iface_->execute (self);
	}
}

static void
welcome_service_entry_default_init (WelcomeServiceEntryIface * iface,
                                    gpointer iface_data)
{
}

static GType
welcome_service_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WelcomeServiceEntryIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) welcome_service_entry_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType welcome_service_entry_type_id;
	welcome_service_entry_type_id = g_type_register_static (G_TYPE_INTERFACE, "WelcomeServiceEntry", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (welcome_service_entry_type_id, G_TYPE_OBJECT);
	return welcome_service_entry_type_id;
}

GType
welcome_service_entry_get_type (void)
{
	static volatile gsize welcome_service_entry_type_id__once = 0;
	if (g_once_init_enter (&welcome_service_entry_type_id__once)) {
		GType welcome_service_entry_type_id;
		welcome_service_entry_type_id = welcome_service_entry_get_type_once ();
		g_once_init_leave (&welcome_service_entry_type_id__once, welcome_service_entry_type_id);
	}
	return welcome_service_entry_type_id__once;
}

static inline gpointer
welcome_dialog_get_instance_private (WelcomeDialog* self)
{
	return G_STRUCT_MEMBER_P (self, WelcomeDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

WelcomeDialog*
welcome_dialog_construct (GType object_type,
                          GtkWindow* owner)
{
	WelcomeDialog * self = NULL;
	SpitDataImportsWelcomeImportMetaHost* _tmp0_;
	gboolean show_system_pictures_import = FALSE;
	GtkWidget* ok_button = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkLabel* primary_text = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkImage* image = NULL;
	GtkImage* _tmp15_;
	GtkBox* header_text = NULL;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkBox* header_content = NULL;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkImage* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkLabel* instructions = NULL;
	GtkLabel* _tmp26_;
	gchar* indent_prefix = NULL;
	gchar* _tmp27_;
	GtkLabel* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	GtkBox* _tmp49_;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkBox* content = NULL;
	GtkBox* _tmp64_;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkBox* _tmp67_;
	GtkLabel* _tmp68_;
	GtkCheckButton* _tmp69_;
	GtkCheckButton* _tmp70_;
	GtkCheckButton* _tmp71_;
	GtkBox* _tmp72_;
	GtkWidget* _tmp73_;
	SpitDataImportsWelcomeImportMetaHost* _tmp74_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), NULL);
	self = (WelcomeDialog*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
	_tmp0_ = spit_data_imports_welcome_import_meta_host_new (self);
	_g_object_unref0 (self->priv->import_meta_host);
	self->priv->import_meta_host = _tmp0_;
	show_system_pictures_import = welcome_dialog_is_system_pictures_import_possible ();
	_tmp1_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_OK_LABEL, (gint) GTK_RESPONSE_CLOSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ok_button = _tmp2_;
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_CLOSE);
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _ ("Welcome!"));
	gtk_window_set_resizable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), FALSE);
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), owner);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	primary_text = _tmp3_;
	_tmp4_ = primary_text;
	_tmp5_ = g_strdup_printf ("<span size=\"large\" weight=\"bold\">%s</span>", _ ("Welcome to Shotwell!"));
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = primary_text;
	gtk_label_set_xalign (_tmp7_, 0.0f);
	_tmp8_ = primary_text;
	gtk_label_set_yalign (_tmp8_, 0.5f);
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->secondary_text);
	self->priv->secondary_text = _tmp9_;
	_tmp10_ = self->priv->secondary_text;
	_tmp11_ = g_strdup_printf ("<span weight=\"normal\">%s</span>", _ ("To get started, import photos in any of these ways:"));
	_tmp12_ = _tmp11_;
	gtk_label_set_markup (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->secondary_text;
	gtk_label_set_xalign (_tmp13_, 0.0f);
	_tmp14_ = self->priv->secondary_text;
	gtk_label_set_yalign (_tmp14_, 0.5f);
	_tmp15_ = (GtkImage*) gtk_image_new_from_icon_name ("shotwell", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp15_);
	image = _tmp15_;
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp16_);
	header_text = _tmp16_;
	_tmp17_ = header_text;
	_tmp18_ = primary_text;
	gtk_box_pack_start (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 5);
	_tmp19_ = header_text;
	_tmp20_ = self->priv->secondary_text;
	gtk_box_pack_start (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp21_);
	header_content = _tmp21_;
	_tmp22_ = header_content;
	_tmp23_ = image;
	gtk_box_pack_start (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp24_ = header_content;
	_tmp25_ = header_text;
	gtk_box_pack_start (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp26_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp26_);
	instructions = _tmp26_;
	_tmp27_ = g_strdup ("   ");
	indent_prefix = _tmp27_;
	_tmp28_ = instructions;
	_tmp29_ = indent_prefix;
	_tmp30_ = g_strconcat (_tmp29_, "&#8226; %s\n", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = indent_prefix;
	_tmp33_ = g_strconcat (_tmp32_, "&#8226; %s\n", NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = indent_prefix;
	_tmp38_ = g_strconcat (_tmp37_, "&#8226; %s", NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf (_tmp41_, _ ("Choose “Import From Folder” from the File menu"), _ ("Drag and drop photos onto the Shotwell window"), _ ("Connect a camera to your computer and import"));
	_tmp43_ = _tmp42_;
	gtk_label_set_markup (_tmp28_, _tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	_tmp44_ = instructions;
	gtk_label_set_xalign (_tmp44_, 0.0f);
	_tmp45_ = instructions;
	gtk_label_set_yalign (_tmp45_, 0.5f);
	_tmp46_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->import_action_checkbox_packer);
	self->priv->import_action_checkbox_packer = _tmp46_;
	_tmp47_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->external_import_action_checkbox_packer);
	self->priv->external_import_action_checkbox_packer = _tmp47_;
	_tmp48_ = self->priv->import_action_checkbox_packer;
	_tmp49_ = self->priv->external_import_action_checkbox_packer;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget));
	if (show_system_pictures_import) {
		GFile* _tmp50_;
		GFile* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GtkCheckButton* _tmp56_;
		GtkBox* _tmp57_;
		GtkCheckButton* _tmp58_;
		GtkCheckButton* _tmp59_;
		_tmp50_ = app_dirs_get_import_dir ();
		_tmp51_ = _tmp50_;
		_tmp52_ = get_display_pathname (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf (_ ("_Import photos from your %s folder"), _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp55_);
		g_object_ref_sink (_tmp56_);
		_g_object_unref0 (self->priv->system_pictures_import_check);
		self->priv->system_pictures_import_check = _tmp56_;
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_g_object_unref0 (_tmp51_);
		_tmp57_ = self->priv->import_action_checkbox_packer;
		_tmp58_ = self->priv->system_pictures_import_check;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget));
		_tmp59_ = self->priv->system_pictures_import_check;
		gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	}
	_tmp60_ = (GtkLabel*) gtk_label_new (_ ("You can also import photos in any of these ways:"));
	g_object_ref_sink (_tmp60_);
	_g_object_unref0 (self->priv->instruction_header);
	self->priv->instruction_header = _tmp60_;
	_tmp61_ = self->priv->instruction_header;
	gtk_label_set_xalign (_tmp61_, 0.0f);
	_tmp62_ = self->priv->instruction_header;
	gtk_label_set_yalign (_tmp62_, 0.5f);
	_tmp63_ = self->priv->instruction_header;
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget), 20);
	_tmp64_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 16);
	g_object_ref_sink (_tmp64_);
	content = _tmp64_;
	_tmp65_ = header_content;
	gtk_box_pack_start (content, G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_widget_get_type (), GtkWidget), TRUE, TRUE, (guint) 0);
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->import_content);
	self->priv->import_content = _tmp66_;
	_tmp67_ = self->priv->import_content;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_widget_get_type (), GtkWidget));
	_tmp68_ = instructions;
	gtk_box_pack_start (content, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp69_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("_Don’t show this message again"));
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->hide_button);
	self->priv->hide_button = _tmp69_;
	_tmp70_ = self->priv->hide_button;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp71_ = self->priv->hide_button;
	gtk_box_pack_start (content, G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 6);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_FILL);
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), 12);
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), 0);
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), 12);
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), 12);
	_tmp72_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	gtk_box_pack_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_box_get_type (), GtkBox), G_TYPE_CHECK_INSTANCE_CAST (content, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp73_ = ok_button;
	gtk_widget_grab_focus (_tmp73_);
	welcome_dialog_install_import_content (self);
	_tmp74_ = self->priv->import_meta_host;
	spit_data_imports_welcome_import_meta_host_start (_tmp74_);
	_g_object_unref0 (content);
	_g_free0 (indent_prefix);
	_g_object_unref0 (instructions);
	_g_object_unref0 (header_content);
	_g_object_unref0 (header_text);
	_g_object_unref0 (image);
	_g_object_unref0 (primary_text);
	_g_object_unref0 (ok_button);
	return self;
}

WelcomeDialog*
welcome_dialog_new (GtkWindow* owner)
{
	return welcome_dialog_construct (TYPE_WELCOME_DIALOG, owner);
}

static void
welcome_dialog_install_import_content (WelcomeDialog* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkCheckButton** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (IS_WELCOME_DIALOG (self));
	_tmp2_ = self->priv->external_import_checks;
	_tmp2__length1 = self->priv->external_import_checks_length1;
	if (_tmp2__length1 > 0) {
		_tmp1_ = TRUE;
	} else {
		GtkCheckButton* _tmp3_;
		_tmp3_ = self->priv->system_pictures_import_check;
		_tmp1_ = _tmp3_ != NULL;
	}
	if (_tmp1_) {
		_tmp0_ = self->priv->import_content_already_installed == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp4_;
		GtkBox* _tmp5_;
		GtkBox* _tmp6_;
		GtkBox* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp4_ = self->priv->secondary_text;
		gtk_label_set_markup (_tmp4_, "");
		_tmp5_ = self->priv->import_content;
		_tmp6_ = self->priv->import_action_checkbox_packer;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		_tmp7_ = self->priv->import_content;
		_tmp8_ = self->priv->instruction_header;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		self->priv->import_content_already_installed = TRUE;
	}
}

static void
_vala_array_add131 (WelcomeServiceEntry** * array,
                    gint* length,
                    gint* size,
                    WelcomeServiceEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WelcomeServiceEntry*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add132 (GtkCheckButton** * array,
                    gint* length,
                    gint* size,
                    GtkCheckButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkCheckButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
welcome_dialog_install_service_entry (WelcomeDialog* self,
                                      WelcomeServiceEntry* entry)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	WelcomeServiceEntry* _tmp4_;
	GtkCheckButton* entry_check = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkCheckButton* _tmp9_;
	GtkCheckButton* _tmp10_;
	GtkCheckButton* _tmp11_;
	GtkBox* _tmp12_;
	g_return_if_fail (IS_WELCOME_DIALOG (self));
	g_return_if_fail (IS_WELCOME_SERVICE_ENTRY (entry));
	_tmp0_ = welcome_service_entry_get_service_name (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("WelcomeDialog: Installing service entry for %s", _tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("WelcomeDialog.vala:130: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = _g_object_ref0 (entry);
	_vala_array_add131 (&self->priv->external_import_entries, &self->priv->external_import_entries_length1, &self->priv->_external_import_entries_size_, _tmp4_);
	_tmp5_ = welcome_service_entry_get_service_name (entry);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (_ ("Import photos from your %s library"), _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	entry_check = _tmp10_;
	_tmp11_ = _g_object_ref0 (entry_check);
	_vala_array_add132 (&self->priv->external_import_checks, &self->priv->external_import_checks_length1, &self->priv->_external_import_checks_size_, _tmp11_);
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (entry_check, gtk_toggle_button_get_type (), GtkToggleButton), TRUE);
	_tmp12_ = self->priv->external_import_action_checkbox_packer;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry_check, gtk_widget_get_type (), GtkWidget));
	welcome_dialog_install_import_content (self);
	_g_object_unref0 (entry_check);
}

/**
     * Connected to the 'response' signal.  This is part of a workaround
     * for the fact that run()-ning this dialog can interfere with displaying
     * images from a camera; please see #4997 for details.
     */
static void
welcome_dialog_on_dismiss (WelcomeDialog* self,
                           gint resp)
{
	g_return_if_fail (IS_WELCOME_DIALOG (self));
	if (resp == ((gint) GTK_RESPONSE_CLOSE)) {
		self->priv->ok_clicked = TRUE;
	}
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_main_quit ();
}

static void
_welcome_dialog_on_dismiss_gtk_dialog_response (GtkDialog* _sender,
                                                gint response_id,
                                                gpointer self)
{
	welcome_dialog_on_dismiss ((WelcomeDialog*) self, response_id);
}

static void
_vala_array_add133 (WelcomeServiceEntry** * array,
                    gint* length,
                    gint* size,
                    WelcomeServiceEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (WelcomeServiceEntry*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static WelcomeServiceEntry**
_vala_array_dup37 (WelcomeServiceEntry** self,
                   gssize length)
{
	if (length >= 0) {
		WelcomeServiceEntry** result;
		gssize i;
		result = g_new0 (WelcomeServiceEntry*, length + 1);
		for (i = 0; i < length; i++) {
			WelcomeServiceEntry* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gboolean
welcome_dialog_execute (WelcomeDialog* self,
                        WelcomeServiceEntry*** selected_import_entries,
                        gint* selected_import_entries_length1,
                        gboolean* do_system_pictures_import)
{
	WelcomeServiceEntry** _vala_selected_import_entries = NULL;
	gint _vala_selected_import_entries_length1 = 0;
	gboolean _vala_do_system_pictures_import = FALSE;
	guint _tmp0_;
	gboolean ok = FALSE;
	gboolean show_dialog = FALSE;
	WelcomeServiceEntry** _result_ = NULL;
	WelcomeServiceEntry** _tmp2_;
	gint _result__length1;
	gint __result__size_;
	WelcomeServiceEntry** _tmp11_;
	gint _tmp11__length1;
	WelcomeServiceEntry** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp13_ = FALSE;
	GtkCheckButton* _tmp14_;
	gboolean result;
	g_return_val_if_fail (IS_WELCOME_DIALOG (self), FALSE);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) _welcome_dialog_on_dismiss_gtk_dialog_response, self, 0);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_main ();
	g_signal_parse_name ("response", gtk_dialog_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _welcome_dialog_on_dismiss_gtk_dialog_response, self);
	ok = self->priv->ok_clicked;
	show_dialog = TRUE;
	if (ok) {
		GtkCheckButton* _tmp1_;
		_tmp1_ = self->priv->hide_button;
		show_dialog = !gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton));
	}
	_tmp2_ = g_new0 (WelcomeServiceEntry*, 0 + 1);
	_result_ = _tmp2_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				WelcomeServiceEntry** _tmp5_;
				gint _tmp5__length1;
				GtkCheckButton** _tmp6_;
				gint _tmp6__length1;
				GtkCheckButton* _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->external_import_entries;
				_tmp5__length1 = self->priv->external_import_entries_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = self->priv->external_import_checks;
				_tmp6__length1 = self->priv->external_import_checks_length1;
				_tmp7_ = _tmp6_[i];
				if (gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_toggle_button_get_type (), GtkToggleButton)) == TRUE) {
					WelcomeServiceEntry** _tmp8_;
					gint _tmp8__length1;
					WelcomeServiceEntry* _tmp9_;
					WelcomeServiceEntry* _tmp10_;
					_tmp8_ = self->priv->external_import_entries;
					_tmp8__length1 = self->priv->external_import_entries_length1;
					_tmp9_ = _tmp8_[i];
					_tmp10_ = _g_object_ref0 (_tmp9_);
					_vala_array_add133 (&_result_, &_result__length1, &__result__size_, _tmp10_);
				}
			}
		}
	}
	_tmp11_ = _result_;
	_tmp11__length1 = _result__length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup37 (_tmp11_, _tmp11__length1) : _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_vala_selected_import_entries = (_vala_array_free (_vala_selected_import_entries, _vala_selected_import_entries_length1, (GDestroyNotify) g_object_unref), NULL);
	_vala_selected_import_entries = _tmp12_;
	_vala_selected_import_entries_length1 = _tmp12__length1;
	_tmp14_ = self->priv->system_pictures_import_check;
	if (_tmp14_ != NULL) {
		GtkCheckButton* _tmp15_;
		_tmp15_ = self->priv->system_pictures_import_check;
		_tmp13_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_button_get_type (), GtkToggleButton));
	} else {
		_tmp13_ = FALSE;
	}
	_vala_do_system_pictures_import = _tmp13_;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = show_dialog;
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
	if (selected_import_entries) {
		*selected_import_entries = _vala_selected_import_entries;
	} else {
		_vala_selected_import_entries = (_vala_array_free (_vala_selected_import_entries, _vala_selected_import_entries_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (selected_import_entries_length1) {
		*selected_import_entries_length1 = _vala_selected_import_entries_length1;
	}
	if (do_system_pictures_import) {
		*do_system_pictures_import = _vala_do_system_pictures_import;
	}
	return result;
}

static gboolean
welcome_dialog_is_system_pictures_import_possible (void)
{
	GFile* system_pictures = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = app_dirs_get_import_dir ();
	system_pictures = _tmp0_;
	_tmp1_ = system_pictures;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = FALSE;
		_g_object_unref0 (system_pictures);
		return result;
	}
	_tmp2_ = system_pictures;
	if (!(g_file_query_file_type (_tmp2_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY)) {
		result = FALSE;
		_g_object_unref0 (system_pictures);
		return result;
	}
	{
		GFileEnumerator* syspics_child_enum = NULL;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_;
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_;
		GFileInfo* _tmp7_;
		_tmp3_ = system_pictures;
		_tmp4_ = g_file_enumerate_children (_tmp3_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		syspics_child_enum = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = syspics_child_enum;
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (syspics_child_enum);
			goto __catch0_g_error;
		}
		result = _tmp5_ != NULL;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (syspics_child_enum);
		_g_object_unref0 (system_pictures);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (system_pictures);
		return result;
	}
	__finally0:
	_g_object_unref0 (system_pictures);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static void
welcome_dialog_class_init (WelcomeDialogClass * klass,
                           gpointer klass_data)
{
	welcome_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WelcomeDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = welcome_dialog_finalize;
}

static void
welcome_dialog_instance_init (WelcomeDialog * self,
                              gpointer klass)
{
	GtkCheckButton** _tmp0_;
	WelcomeServiceEntry** _tmp1_;
	self->priv = welcome_dialog_get_instance_private (self);
	self->priv->system_pictures_import_check = NULL;
	_tmp0_ = g_new0 (GtkCheckButton*, 0 + 1);
	self->priv->external_import_checks = _tmp0_;
	self->priv->external_import_checks_length1 = 0;
	self->priv->_external_import_checks_size_ = self->priv->external_import_checks_length1;
	_tmp1_ = g_new0 (WelcomeServiceEntry*, 0 + 1);
	self->priv->external_import_entries = _tmp1_;
	self->priv->external_import_entries_length1 = 0;
	self->priv->_external_import_entries_size_ = self->priv->external_import_entries_length1;
	self->priv->import_content_already_installed = FALSE;
	self->priv->ok_clicked = FALSE;
}

static void
welcome_dialog_finalize (GObject * obj)
{
	WelcomeDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WELCOME_DIALOG, WelcomeDialog);
	_g_object_unref0 (self->priv->hide_button);
	_g_object_unref0 (self->priv->system_pictures_import_check);
	self->priv->external_import_checks = (_vala_array_free (self->priv->external_import_checks, self->priv->external_import_checks_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->external_import_entries = (_vala_array_free (self->priv->external_import_entries, self->priv->external_import_entries_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->secondary_text);
	_g_object_unref0 (self->priv->instruction_header);
	_g_object_unref0 (self->priv->import_content);
	_g_object_unref0 (self->priv->import_action_checkbox_packer);
	_g_object_unref0 (self->priv->external_import_action_checkbox_packer);
	_g_object_unref0 (self->priv->import_meta_host);
	G_OBJECT_CLASS (welcome_dialog_parent_class)->finalize (obj);
}

static GType
welcome_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WelcomeDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) welcome_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WelcomeDialog), 0, (GInstanceInitFunc) welcome_dialog_instance_init, NULL };
	GType welcome_dialog_type_id;
	welcome_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "WelcomeDialog", &g_define_type_info, 0);
	WelcomeDialog_private_offset = g_type_add_instance_private (welcome_dialog_type_id, sizeof (WelcomeDialogPrivate));
	return welcome_dialog_type_id;
}

GType
welcome_dialog_get_type (void)
{
	static volatile gsize welcome_dialog_type_id__once = 0;
	if (g_once_init_enter (&welcome_dialog_type_id__once)) {
		GType welcome_dialog_type_id;
		welcome_dialog_type_id = welcome_dialog_get_type_once ();
		g_once_init_leave (&welcome_dialog_type_id__once, welcome_dialog_type_id);
	}
	return welcome_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

