/* Resources.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Resources.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "shotwell-plugin-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static void _vala_array_add2 (GdkPixbuf** * array,
                       gint* length,
                       gint* size,
                       GdkPixbuf* value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add2 (GdkPixbuf** * array,
                  gint* length,
                  gint* size,
                  GdkPixbuf* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GdkPixbuf*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GdkPixbuf**
resources_load_from_resource (const gchar* resource_path,
                              gint* result_length1)
{
	GdkPixbuf* icon = NULL;
	GdkPixbuf* _tmp5_;
	GdkPixbuf** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	GdkPixbuf** result;
	g_return_val_if_fail (resource_path != NULL, NULL);
	icon = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		g_debug ("Resources.vala:36: Loading icon from %s", resource_path);
		_tmp1_ = gdk_pixbuf_new_from_resource_at_scale (resource_path, -1, 24, TRUE, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (icon);
		icon = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("Resources.vala:39: Couldn't load icon set from %s: %s", resource_path, _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = icon;
	if (_tmp5_ != NULL) {
		GdkPixbuf** icon_pixbuf_set = NULL;
		GdkPixbuf** _tmp6_;
		gint icon_pixbuf_set_length1;
		gint _icon_pixbuf_set_size_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		GdkPixbuf** _tmp9_;
		gint _tmp9__length1;
		_tmp6_ = g_new0 (GdkPixbuf*, 0 + 1);
		icon_pixbuf_set = _tmp6_;
		icon_pixbuf_set_length1 = 0;
		_icon_pixbuf_set_size_ = icon_pixbuf_set_length1;
		_tmp7_ = icon;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_vala_array_add2 (&icon_pixbuf_set, &icon_pixbuf_set_length1, &_icon_pixbuf_set_size_, _tmp8_);
		_tmp9_ = icon_pixbuf_set;
		_tmp9__length1 = icon_pixbuf_set_length1;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		_g_object_unref0 (icon);
		return result;
	}
	_tmp10_ = NULL;
	_tmp10__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (icon);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

