/* DataSet.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataSet.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/**/
/* DataSet*/
/**/
/* A DataSet is a collection class used for internal implementations of DataCollection*/
/* and its children.  It may be of use to other classes, however.*/
/**/
/* The general purpose of DataSet is to provide low-cost implementations of various collection*/
/* operations at a cost of internally maintaining its objects in more than one simple collection.*/
/* contains(), for example, can return a result with hash-table performance while notions of*/
/* ordering are maintained by a SortedList.  The cost is in adding and removing objects (in general,*/
/* there are others).*/
/**/
/* Because this class has no signalling mechanisms and does not manipulate DataObjects in ways*/
/* they expect to be manipulated (these features are performed by DataCollection), it's probably*/
/* best not to use this class.  Even in cases of building a list of DataObjects for some quick*/
/* operation is probably best done by a Gee.ArrayList.*/
/**/
/* ComparatorPredicate is used to determine if a re-sort operation is necessary; it has no*/
/* effect on adding a DataObject to a DataSet in sorted order.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
typedef struct _DataSetPrivate DataSetPrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecDataSet ParamSpecDataSet;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataSet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataSetPrivate * priv;
};

struct _DataSetClass {
	GTypeClass parent_class;
	void (*finalize) (DataSet *self);
};

struct _DataSetPrivate {
	SortedList* list;
	GeeHashSet* hash_set;
	Comparator user_comparator;
	gpointer user_comparator_target;
	ComparatorPredicate comparator_predicate;
	gpointer comparator_predicate_target;
};

struct _ParamSpecDataSet {
	GParamSpec parent_instance;
};

static gint DataSet_private_offset;
static gpointer data_set_parent_class = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_set_ref (gpointer instance);
VALA_EXTERN void data_set_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_set (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_data_set (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_data_set (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_data_set (const GValue* value);
VALA_EXTERN GType data_set_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSet, data_set_unref)
VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
VALA_EXTERN DataSet* data_set_new (void);
VALA_EXTERN DataSet* data_set_construct (GType object_type);
VALA_EXTERN void data_set_reset_comparator (DataSet* self);
static gint64 data_set_order_added_comparator (DataSet* self,
                                        void* a,
                                        void* b);
VALA_EXTERN gint64 data_object_internal_get_ordinal (DataObject* self);
static gboolean data_set_order_added_predicate (DataSet* self,
                                         DataObject* object,
                                         Alteration* alteration);
static gint64 data_set_comparator_wrapper (DataSet* self,
                                    void* a,
                                    void* b);
VALA_EXTERN gboolean data_set_contains (DataSet* self,
                            DataObject* object);
VALA_EXTERN gint data_set_get_count (DataSet* self);
VALA_EXTERN gint sorted_list_get_count (SortedList* self);
static gboolean _data_set_order_added_predicate_comparator_predicate (DataObject* object,
                                                               Alteration* alteration,
                                                               gpointer self);
VALA_EXTERN void sorted_list_resort (SortedList* self,
                         Comparator new_cmp,
                         gpointer new_cmp_target);
static gint64 _data_set_order_added_comparator_comparator (void* a,
                                                    void* b,
                                                    gpointer self);
VALA_EXTERN Comparator data_set_get_comparator (DataSet* self,
                                    gpointer* result_target);
VALA_EXTERN ComparatorPredicate data_set_get_comparator_predicate (DataSet* self,
                                                       gpointer* result_target);
VALA_EXTERN void data_set_set_comparator (DataSet* self,
                              Comparator user_comparator,
                              gpointer user_comparator_target,
                              ComparatorPredicate comparator_predicate,
                              gpointer comparator_predicate_target);
static gint64 _data_set_comparator_wrapper_comparator (void* a,
                                                void* b,
                                                gpointer self);
VALA_EXTERN GeeList* data_set_get_all (DataSet* self);
VALA_EXTERN GeeList* sorted_list_get_read_only_view_as_list (SortedList* self);
VALA_EXTERN DataSet* data_set_copy (DataSet* self);
VALA_EXTERN SortedList* sorted_list_copy (SortedList* self);
VALA_EXTERN DataObject* data_set_get_at (DataSet* self,
                             gint index);
VALA_EXTERN gpointer sorted_list_get_at (SortedList* self,
                             gint index);
VALA_EXTERN gint data_set_index_of (DataSet* self,
                        DataObject* object);
VALA_EXTERN gint sorted_list_locate (SortedList* self,
                         gconstpointer search,
                         gboolean altered,
                         GEqualFunc equal_func);
VALA_EXTERN gboolean data_set_add (DataSet* self,
                       DataObject* object);
VALA_EXTERN gboolean data_set_add_many (DataSet* self,
                            GeeCollection* objects);
VALA_EXTERN gboolean data_set_remove (DataSet* self,
                          DataObject* object);
VALA_EXTERN gboolean data_set_remove_many (DataSet* self,
                               GeeCollection* objects);
VALA_EXTERN gboolean data_set_resort_object (DataSet* self,
                                 DataObject* object,
                                 Alteration* alteration);
VALA_EXTERN gboolean sorted_list_resort_item (SortedList* self,
                                  gconstpointer item);
static void data_set_finalize (DataSet * obj);
static GType data_set_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
data_set_get_instance_private (DataSet* self)
{
	return G_STRUCT_MEMBER_P (self, DataSet_private_offset);
}

DataSet*
data_set_construct (GType object_type)
{
	DataSet* self = NULL;
	self = (DataSet*) g_type_create_instance (object_type);
	data_set_reset_comparator (self);
	return self;
}

DataSet*
data_set_new (void)
{
	return data_set_construct (TYPE_DATA_SET);
}

static gint64
data_set_order_added_comparator (DataSet* self,
                                 void* a,
                                 void* b)
{
	gint64 result;
	g_return_val_if_fail (IS_DATA_SET (self), 0LL);
	result = data_object_internal_get_ordinal (G_TYPE_CHECK_INSTANCE_CAST ((DataObject*) a, TYPE_DATA_OBJECT, DataObject)) - data_object_internal_get_ordinal (G_TYPE_CHECK_INSTANCE_CAST ((DataObject*) b, TYPE_DATA_OBJECT, DataObject));
	return result;
}

static gboolean
data_set_order_added_predicate (DataSet* self,
                                DataObject* object,
                                Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = FALSE;
	return result;
}

static gint64
data_set_comparator_wrapper (DataSet* self,
                             void* a,
                             void* b)
{
	gint64 _result_ = 0LL;
	Comparator _tmp0_;
	gpointer _tmp0__target;
	gint64 result;
	g_return_val_if_fail (IS_DATA_SET (self), 0LL);
	if (a == b) {
		result = (gint64) 0;
		return result;
	}
	_result_ = (gint64) 0;
	_tmp0_ = self->priv->user_comparator;
	_tmp0__target = self->priv->user_comparator_target;
	if (_tmp0_ != NULL) {
		Comparator _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->user_comparator;
		_tmp1__target = self->priv->user_comparator_target;
		_result_ = _tmp1_ (a, b, _tmp1__target);
	}
	if (_result_ == ((gint64) 0)) {
		_result_ = data_set_order_added_comparator (self, a, b);
	}
	_vala_assert (_result_ != ((gint64) 0), "result != 0");
	result = _result_;
	return result;
}

gboolean
data_set_contains (DataSet* self,
                   DataObject* object)
{
	GeeHashSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = self->priv->hash_set;
	result = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
	return result;
}

inline gint
data_set_get_count (DataSet* self)
{
	SortedList* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_DATA_SET (self), 0);
	_tmp0_ = self->priv->list;
	result = sorted_list_get_count (_tmp0_);
	return result;
}

static gboolean
_data_set_order_added_predicate_comparator_predicate (DataObject* object,
                                                      Alteration* alteration,
                                                      gpointer self)
{
	gboolean result;
	result = data_set_order_added_predicate ((DataSet*) self, object, alteration);
	return result;
}

static gint64
_data_set_order_added_comparator_comparator (void* a,
                                             void* b,
                                             gpointer self)
{
	gint64 result;
	result = data_set_order_added_comparator ((DataSet*) self, a, b);
	return result;
}

void
data_set_reset_comparator (DataSet* self)
{
	SortedList* _tmp0_;
	g_return_if_fail (IS_DATA_SET (self));
	self->priv->user_comparator = NULL;
	self->priv->user_comparator_target = NULL;
	self->priv->comparator_predicate = _data_set_order_added_predicate_comparator_predicate;
	self->priv->comparator_predicate_target = self;
	_tmp0_ = self->priv->list;
	sorted_list_resort (_tmp0_, _data_set_order_added_comparator_comparator, self);
}

Comparator
data_set_get_comparator (DataSet* self,
                         gpointer* result_target)
{
	Comparator _tmp0_;
	gpointer _tmp0__target;
	Comparator _tmp1_;
	gpointer _tmp1__target;
	Comparator result;
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
	_tmp0_ = self->priv->user_comparator;
	_tmp0__target = self->priv->user_comparator_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

ComparatorPredicate
data_set_get_comparator_predicate (DataSet* self,
                                   gpointer* result_target)
{
	ComparatorPredicate _tmp0_;
	gpointer _tmp0__target;
	ComparatorPredicate _tmp1_;
	gpointer _tmp1__target;
	ComparatorPredicate result;
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
	_tmp0_ = self->priv->comparator_predicate;
	_tmp0__target = self->priv->comparator_predicate_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

static gint64
_data_set_comparator_wrapper_comparator (void* a,
                                         void* b,
                                         gpointer self)
{
	gint64 result;
	result = data_set_comparator_wrapper ((DataSet*) self, a, b);
	return result;
}

void
data_set_set_comparator (DataSet* self,
                         Comparator user_comparator,
                         gpointer user_comparator_target,
                         ComparatorPredicate comparator_predicate,
                         gpointer comparator_predicate_target)
{
	SortedList* _tmp0_;
	g_return_if_fail (IS_DATA_SET (self));
	self->priv->user_comparator = user_comparator;
	self->priv->user_comparator_target = user_comparator_target;
	self->priv->comparator_predicate = comparator_predicate;
	self->priv->comparator_predicate_target = comparator_predicate_target;
	_tmp0_ = self->priv->list;
	sorted_list_resort (_tmp0_, _data_set_comparator_wrapper_comparator, self);
}

GeeList*
data_set_get_all (DataSet* self)
{
	SortedList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = sorted_list_get_read_only_view_as_list (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

DataSet*
data_set_copy (DataSet* self)
{
	DataSet* clone = NULL;
	DataSet* _tmp0_;
	SortedList* _tmp1_;
	SortedList* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
	DataSet* result;
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
	_tmp0_ = data_set_new ();
	clone = _tmp0_;
	_tmp1_ = self->priv->list;
	_tmp2_ = sorted_list_copy (_tmp1_);
	_g_object_unref0 (clone->priv->list);
	clone->priv->list = _tmp2_;
	_tmp3_ = clone->priv->hash_set;
	_tmp4_ = self->priv->hash_set;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
	result = clone;
	return result;
}

DataObject*
data_set_get_at (DataSet* self,
                 gint index)
{
	SortedList* _tmp0_;
	gpointer _tmp1_;
	DataObject* result;
	g_return_val_if_fail (IS_DATA_SET (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = sorted_list_get_at (_tmp0_, index);
	result = (DataObject*) _tmp1_;
	return result;
}

gint
data_set_index_of (DataSet* self,
                   DataObject* object)
{
	SortedList* _tmp0_;
	GEqualFunc _tmp1_;
	gint result;
	g_return_val_if_fail (IS_DATA_SET (self), 0);
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
	_tmp0_ = self->priv->list;
	_tmp1_ = g_direct_equal;
	result = sorted_list_locate (_tmp0_, object, FALSE, _tmp1_);
	return result;
}

gboolean
data_set_add (DataSet* self,
              DataObject* object)
{
	SortedList* _tmp0_;
	GeeHashSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = self->priv->list;
	if (!gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), object)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->hash_set;
	if (!gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object)) {
		SortedList* _tmp2_;
		_tmp2_ = self->priv->list;
		gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), object);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
data_set_add_many (DataSet* self,
                   GeeCollection* objects)
{
	gint count = 0;
	gint _tmp0_;
	gint _tmp1_;
	SortedList* _tmp2_;
	GeeHashSet* _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = gee_collection_get_size (objects);
	_tmp1_ = _tmp0_;
	count = _tmp1_;
	if (count == 0) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->list;
	if (!gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), objects)) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->hash_set;
	if (!gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), objects)) {
		SortedList* _tmp4_;
		_tmp4_ = self->priv->list;
		gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), objects);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
data_set_remove (DataSet* self,
                 DataObject* object)
{
	gboolean success = FALSE;
	SortedList* _tmp0_;
	GeeHashSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	success = TRUE;
	_tmp0_ = self->priv->list;
	if (!gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), object)) {
		success = FALSE;
	}
	_tmp1_ = self->priv->hash_set;
	if (!gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object)) {
		success = FALSE;
	}
	result = success;
	return result;
}

gboolean
data_set_remove_many (DataSet* self,
                      GeeCollection* objects)
{
	gboolean success = FALSE;
	SortedList* _tmp0_;
	GeeHashSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (objects, GEE_TYPE_COLLECTION), FALSE);
	success = TRUE;
	_tmp0_ = self->priv->list;
	if (!gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), objects)) {
		success = FALSE;
	}
	_tmp1_ = self->priv->hash_set;
	if (!gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), objects)) {
		success = FALSE;
	}
	result = success;
	return result;
}

gboolean
data_set_resort_object (DataSet* self,
                        DataObject* object,
                        Alteration* alteration)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ComparatorPredicate _tmp2_;
	gpointer _tmp2__target;
	SortedList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (IS_DATA_SET (self), FALSE);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail ((alteration == NULL) || IS_ALTERATION (alteration), FALSE);
	_tmp2_ = self->priv->comparator_predicate;
	_tmp2__target = self->priv->comparator_predicate_target;
	if (_tmp2_ != NULL) {
		_tmp1_ = alteration != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ComparatorPredicate _tmp3_;
		gpointer _tmp3__target;
		_tmp3_ = self->priv->comparator_predicate;
		_tmp3__target = self->priv->comparator_predicate_target;
		_tmp0_ = !_tmp3_ (object, alteration, _tmp3__target);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->list;
	result = sorted_list_resort_item (_tmp4_, object);
	return result;
}

static void
value_data_set_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_data_set_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		data_set_unref (value->data[0].v_pointer);
	}
}

static void
value_data_set_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = data_set_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_data_set_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_data_set_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DataSet * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = data_set_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_data_set_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	DataSet ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = data_set_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_data_set (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecDataSet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_SET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_data_set (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET), NULL);
	return value->data[0].v_pointer;
}

void
value_set_data_set (GValue* value,
                    gpointer v_object)
{
	DataSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		data_set_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_set_unref (old);
	}
}

void
value_take_data_set (GValue* value,
                     gpointer v_object)
{
	DataSet * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_SET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_SET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_set_unref (old);
	}
}

static void
data_set_class_init (DataSetClass * klass,
                     gpointer klass_data)
{
	data_set_parent_class = g_type_class_peek_parent (klass);
	((DataSetClass *) klass)->finalize = data_set_finalize;
	g_type_class_adjust_private_offset (klass, &DataSet_private_offset);
}

static void
data_set_instance_init (DataSet * self,
                        gpointer klass)
{
	SortedList* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = data_set_get_instance_private (self);
	_tmp0_ = sorted_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL);
	self->priv->list = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->hash_set = _tmp1_;
	self->priv->user_comparator = NULL;
	self->priv->user_comparator_target = NULL;
	self->priv->comparator_predicate = NULL;
	self->priv->comparator_predicate_target = NULL;
	self->ref_count = 1;
}

static void
data_set_finalize (DataSet * obj)
{
	DataSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_SET, DataSet);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->list);
	_g_object_unref0 (self->priv->hash_set);
}

static GType
data_set_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_data_set_init, value_data_set_free_value, value_data_set_copy_value, value_data_set_peek_pointer, "p", value_data_set_collect_value, "p", value_data_set_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataSet), 0, (GInstanceInitFunc) data_set_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType data_set_type_id;
	data_set_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataSet", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DataSet_private_offset = g_type_add_instance_private (data_set_type_id, sizeof (DataSetPrivate));
	return data_set_type_id;
}

GType
data_set_get_type (void)
{
	static volatile gsize data_set_type_id__once = 0;
	if (g_once_init_enter (&data_set_type_id__once)) {
		GType data_set_type_id;
		data_set_type_id = data_set_get_type_once ();
		g_once_init_leave (&data_set_type_id__once, data_set_type_id);
	}
	return data_set_type_id__once;
}

gpointer
data_set_ref (gpointer instance)
{
	DataSet * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
data_set_unref (gpointer instance)
{
	DataSet * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DATA_SET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

