/* Generated from /build/samba/src/samba-4.23.3/third_party/heimdal/lib/asn1/pkcs12.asn1 */
/* Do not edit */

#ifndef __pkcs12_asn1_h__
#define __pkcs12_asn1_h__

#include <stddef.h>
#include <stdint.h>
#include <time.h>

#ifndef __asn1_common_definitions__
#define __asn1_common_definitions__

#ifndef __HEIM_BASE_DATA__
#define __HEIM_BASE_DATA__ 1
struct heim_base_data {
    size_t length;
    void *data;
};
typedef struct heim_base_data heim_octet_string;
#endif

typedef struct heim_integer {
  size_t length;
  void *data;
  int negative;
} heim_integer;

typedef char *heim_general_string;

typedef char *heim_utf8_string;

typedef struct heim_base_data heim_printable_string;

typedef struct heim_base_data heim_ia5_string;

typedef struct heim_bmp_string {
  size_t length;
  uint16_t *data;
} heim_bmp_string;

typedef struct heim_universal_string {
  size_t length;
  uint32_t *data;
} heim_universal_string;

typedef char *heim_visible_string;

typedef struct heim_oid {
  size_t length;
  unsigned *components;
} heim_oid;

typedef struct heim_bit_string {
  size_t length;
  void *data;
} heim_bit_string;

typedef struct heim_base_data heim_any;
typedef struct heim_base_data heim_any_set;
typedef struct heim_base_data HEIM_ANY;
typedef struct heim_base_data HEIM_ANY_SET;

enum asn1_print_flags {
   ASN1_PRINT_INDENT = 1,
};

#define ASN1_MALLOC_ENCODE(T, B, BL, S, L, R)                  \
  do {                                                         \
    (BL) = length_##T((S));                                    \
    (B) = calloc(1, (BL));                                     \
    if((B) == NULL) {                                          \
      *(L) = 0;                                                \
      (R) = ENOMEM;                                            \
    } else {                                                   \
      (R) = encode_##T(((unsigned char*)(B)) + (BL) - 1, (BL), \
                       (S), (L));                              \
      if((R) != 0) {                                           \
        free((B));                                             \
        (B) = NULL;                                            \
        *(L) = 0;                                              \
      }                                                        \
    }                                                          \
  } while (0)

#ifdef _WIN32
#ifndef ASN1_LIB
#define ASN1EXP  __declspec(dllimport)
#else
#define ASN1EXP
#endif
#define ASN1CALL __stdcall
#else
#define ASN1EXP
#define ASN1CALL
#endif
#ifndef ENOTSUP
/* Very old MSVC CRTs lack ENOTSUP */
#define ENOTSUP EINVAL
#endif
struct units;

#endif

#include <cms_asn1.h>
#include <rfc2459_asn1.h>
#include <heim_asn1.h>
/* OBJECT IDENTIFIER id-pkcs-12 ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs_12;
#define ASN1_OID_ID_PKCS_12 (&asn1_oid_id_pkcs_12)

/* OBJECT IDENTIFIER id-pkcs-12PbeIds ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs_12PbeIds;
#define ASN1_OID_ID_PKCS_12PBEIDS (&asn1_oid_id_pkcs_12PbeIds)

/* OBJECT IDENTIFIER id-pbeWithSHAAnd128BitRC4 ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(1) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbeWithSHAAnd128BitRC4;
#define ASN1_OID_ID_PBEWITHSHAAND128BITRC4 (&asn1_oid_id_pbeWithSHAAnd128BitRC4)

/* OBJECT IDENTIFIER id-pbeWithSHAAnd40BitRC4 ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(2) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbeWithSHAAnd40BitRC4;
#define ASN1_OID_ID_PBEWITHSHAAND40BITRC4 (&asn1_oid_id_pbeWithSHAAnd40BitRC4)

/* OBJECT IDENTIFIER id-pbeWithSHAAnd3-KeyTripleDES-CBC ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(3) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbeWithSHAAnd3_KeyTripleDES_CBC;
#define ASN1_OID_ID_PBEWITHSHAAND3_KEYTRIPLEDES_CBC (&asn1_oid_id_pbeWithSHAAnd3_KeyTripleDES_CBC)

/* OBJECT IDENTIFIER id-pbeWithSHAAnd2-KeyTripleDES-CBC ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(4) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbeWithSHAAnd2_KeyTripleDES_CBC;
#define ASN1_OID_ID_PBEWITHSHAAND2_KEYTRIPLEDES_CBC (&asn1_oid_id_pbeWithSHAAnd2_KeyTripleDES_CBC)

/* OBJECT IDENTIFIER id-pbeWithSHAAnd128BitRC2-CBC ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(5) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbeWithSHAAnd128BitRC2_CBC;
#define ASN1_OID_ID_PBEWITHSHAAND128BITRC2_CBC (&asn1_oid_id_pbeWithSHAAnd128BitRC2_CBC)

/* OBJECT IDENTIFIER id-pbewithSHAAnd40BitRC2-CBC ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(1) label-less(6) } */
extern ASN1EXP const heim_oid asn1_oid_id_pbewithSHAAnd40BitRC2_CBC;
#define ASN1_OID_ID_PBEWITHSHAAND40BITRC2_CBC (&asn1_oid_id_pbewithSHAAnd40BitRC2_CBC)

/* OBJECT IDENTIFIER id-pkcs12-bagtypes ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_bagtypes;
#define ASN1_OID_ID_PKCS12_BAGTYPES (&asn1_oid_id_pkcs12_bagtypes)

/* OBJECT IDENTIFIER id-pkcs12-keyBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(1) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_keyBag;
#define ASN1_OID_ID_PKCS12_KEYBAG (&asn1_oid_id_pkcs12_keyBag)

/* OBJECT IDENTIFIER id-pkcs12-pkcs8ShroudedKeyBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(2) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_pkcs8ShroudedKeyBag;
#define ASN1_OID_ID_PKCS12_PKCS8SHROUDEDKEYBAG (&asn1_oid_id_pkcs12_pkcs8ShroudedKeyBag)

/* OBJECT IDENTIFIER id-pkcs12-certBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(3) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_certBag;
#define ASN1_OID_ID_PKCS12_CERTBAG (&asn1_oid_id_pkcs12_certBag)

/* OBJECT IDENTIFIER id-pkcs12-crlBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(4) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_crlBag;
#define ASN1_OID_ID_PKCS12_CRLBAG (&asn1_oid_id_pkcs12_crlBag)

/* OBJECT IDENTIFIER id-pkcs12-secretBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(5) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_secretBag;
#define ASN1_OID_ID_PKCS12_SECRETBAG (&asn1_oid_id_pkcs12_secretBag)

/* OBJECT IDENTIFIER id-pkcs12-safeContentsBag ::= { iso(1) member-body(2) us(840) rsadsi(113549) pkcs(1) pkcs-12(12) label-less(10) label-less(1) label-less(6) } */
extern ASN1EXP const heim_oid asn1_oid_id_pkcs12_safeContentsBag;
#define ASN1_OID_ID_PKCS12_SAFECONTENTSBAG (&asn1_oid_id_pkcs12_safeContentsBag)

typedef struct PKCS12_MacData PKCS12_MacData;

typedef struct PKCS12_PFX PKCS12_PFX;

typedef struct PKCS12_AuthenticatedSafe PKCS12_AuthenticatedSafe;

typedef struct PKCS12_Attribute PKCS12_Attribute;

typedef struct PKCS12_Attributes PKCS12_Attributes;

typedef struct PKCS12_SafeBag PKCS12_SafeBag;

typedef struct PKCS12_SafeContents PKCS12_SafeContents;

typedef struct PKCS12_CertBag PKCS12_CertBag;

typedef struct PKCS12_PBEParams PKCS12_PBEParams;

typedef heim_octet_string PKCS12_OctetString;

/*
PKCS12-MacData ::= SEQUENCE {
  mac             DigestInfo,
  macSalt         OCTET STRING,
  iterations      INTEGER OPTIONAL,
}
*/

enum { asn1_tag_length_PKCS12_MacData = 1,
       asn1_tag_class_PKCS12_MacData = 0,
       asn1_tag_tag_PKCS12_MacData = 16 };
struct PKCS12_MacData {
  DigestInfo mac;
  heim_octet_string macSalt;
  heim_integer *iterations;
};

ASN1EXP int    ASN1CALL decode_PKCS12_MacData(const unsigned char *, size_t, PKCS12_MacData *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_MacData(unsigned char *, size_t, const PKCS12_MacData *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_MacData(const PKCS12_MacData *);
ASN1EXP int    ASN1CALL copy_PKCS12_MacData  (const PKCS12_MacData *, PKCS12_MacData *);
ASN1EXP void   ASN1CALL free_PKCS12_MacData  (PKCS12_MacData *);
ASN1EXP char * ASN1CALL print_PKCS12_MacData (const PKCS12_MacData *, int);


/*
PKCS12-PFX ::= SEQUENCE {
  version         INTEGER,
  authSafe        ContentInfo,
  macData         PKCS12-MacData OPTIONAL,
}
*/

enum { asn1_tag_length_PKCS12_PFX = 1,
       asn1_tag_class_PKCS12_PFX = 0,
       asn1_tag_tag_PKCS12_PFX = 16 };
struct PKCS12_PFX {
  heim_integer version;
  ContentInfo authSafe;
  PKCS12_MacData *macData;
};

ASN1EXP int    ASN1CALL decode_PKCS12_PFX(const unsigned char *, size_t, PKCS12_PFX *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_PFX(unsigned char *, size_t, const PKCS12_PFX *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_PFX(const PKCS12_PFX *);
ASN1EXP int    ASN1CALL copy_PKCS12_PFX  (const PKCS12_PFX *, PKCS12_PFX *);
ASN1EXP void   ASN1CALL free_PKCS12_PFX  (PKCS12_PFX *);
ASN1EXP char * ASN1CALL print_PKCS12_PFX (const PKCS12_PFX *, int);


/*
PKCS12-AuthenticatedSafe ::= SEQUENCE OF ContentInfo
*/

enum { asn1_tag_length_PKCS12_AuthenticatedSafe = 1,
       asn1_tag_class_PKCS12_AuthenticatedSafe = 0,
       asn1_tag_tag_PKCS12_AuthenticatedSafe = 16 };
struct PKCS12_AuthenticatedSafe {
  unsigned int len;
  ContentInfo *val;
};

ASN1EXP int    ASN1CALL decode_PKCS12_AuthenticatedSafe(const unsigned char *, size_t, PKCS12_AuthenticatedSafe *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_AuthenticatedSafe(unsigned char *, size_t, const PKCS12_AuthenticatedSafe *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_AuthenticatedSafe(const PKCS12_AuthenticatedSafe *);
ASN1EXP int    ASN1CALL copy_PKCS12_AuthenticatedSafe  (const PKCS12_AuthenticatedSafe *, PKCS12_AuthenticatedSafe *);
ASN1EXP void   ASN1CALL free_PKCS12_AuthenticatedSafe  (PKCS12_AuthenticatedSafe *);
ASN1EXP char * ASN1CALL print_PKCS12_AuthenticatedSafe (const PKCS12_AuthenticatedSafe *, int);


/*
PKCS12-Attribute ::= SEQUENCE {
  attrId            OBJECT IDENTIFIER,
  attrValues      HEIM_ANY_SET,
}
*/

enum { asn1_tag_length_PKCS12_Attribute = 1,
       asn1_tag_class_PKCS12_Attribute = 0,
       asn1_tag_tag_PKCS12_Attribute = 16 };
struct PKCS12_Attribute {
  heim_oid attrId;
  HEIM_ANY_SET attrValues;
};

ASN1EXP int    ASN1CALL decode_PKCS12_Attribute(const unsigned char *, size_t, PKCS12_Attribute *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_Attribute(unsigned char *, size_t, const PKCS12_Attribute *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_Attribute(const PKCS12_Attribute *);
ASN1EXP int    ASN1CALL copy_PKCS12_Attribute  (const PKCS12_Attribute *, PKCS12_Attribute *);
ASN1EXP void   ASN1CALL free_PKCS12_Attribute  (PKCS12_Attribute *);
ASN1EXP char * ASN1CALL print_PKCS12_Attribute (const PKCS12_Attribute *, int);


/*
PKCS12-Attributes ::= SET OF PKCS12-Attribute
*/

enum { asn1_tag_length_PKCS12_Attributes = 1,
       asn1_tag_class_PKCS12_Attributes = 0,
       asn1_tag_tag_PKCS12_Attributes = 17 };
struct PKCS12_Attributes {
  unsigned int len;
  PKCS12_Attribute *val;
};

ASN1EXP int    ASN1CALL decode_PKCS12_Attributes(const unsigned char *, size_t, PKCS12_Attributes *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_Attributes(unsigned char *, size_t, const PKCS12_Attributes *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_Attributes(const PKCS12_Attributes *);
ASN1EXP int    ASN1CALL copy_PKCS12_Attributes  (const PKCS12_Attributes *, PKCS12_Attributes *);
ASN1EXP void   ASN1CALL free_PKCS12_Attributes  (PKCS12_Attributes *);
ASN1EXP char * ASN1CALL print_PKCS12_Attributes (const PKCS12_Attributes *, int);


/*
PKCS12-SafeBag ::= SEQUENCE {
  bagId             OBJECT IDENTIFIER,
  bagValue        [0] HEIM_ANY,
  bagAttributes   PKCS12-Attributes OPTIONAL,
}
*/

enum { asn1_tag_length_PKCS12_SafeBag = 1,
       asn1_tag_class_PKCS12_SafeBag = 0,
       asn1_tag_tag_PKCS12_SafeBag = 16 };
struct PKCS12_SafeBag {
  heim_oid bagId;
  HEIM_ANY bagValue;
  PKCS12_Attributes *bagAttributes;
};

ASN1EXP int    ASN1CALL decode_PKCS12_SafeBag(const unsigned char *, size_t, PKCS12_SafeBag *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_SafeBag(unsigned char *, size_t, const PKCS12_SafeBag *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_SafeBag(const PKCS12_SafeBag *);
ASN1EXP int    ASN1CALL copy_PKCS12_SafeBag  (const PKCS12_SafeBag *, PKCS12_SafeBag *);
ASN1EXP void   ASN1CALL free_PKCS12_SafeBag  (PKCS12_SafeBag *);
ASN1EXP char * ASN1CALL print_PKCS12_SafeBag (const PKCS12_SafeBag *, int);


/*
PKCS12-SafeContents ::= SEQUENCE OF PKCS12-SafeBag
*/

enum { asn1_tag_length_PKCS12_SafeContents = 1,
       asn1_tag_class_PKCS12_SafeContents = 0,
       asn1_tag_tag_PKCS12_SafeContents = 16 };
struct PKCS12_SafeContents {
  unsigned int len;
  PKCS12_SafeBag *val;
};

ASN1EXP int    ASN1CALL decode_PKCS12_SafeContents(const unsigned char *, size_t, PKCS12_SafeContents *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_SafeContents(unsigned char *, size_t, const PKCS12_SafeContents *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_SafeContents(const PKCS12_SafeContents *);
ASN1EXP int    ASN1CALL copy_PKCS12_SafeContents  (const PKCS12_SafeContents *, PKCS12_SafeContents *);
ASN1EXP void   ASN1CALL free_PKCS12_SafeContents  (PKCS12_SafeContents *);
ASN1EXP char * ASN1CALL print_PKCS12_SafeContents (const PKCS12_SafeContents *, int);


/*
PKCS12-CertBag ::= SEQUENCE {
  certType          OBJECT IDENTIFIER,
  certValue       [0] HEIM_ANY,
}
*/

enum { asn1_tag_length_PKCS12_CertBag = 1,
       asn1_tag_class_PKCS12_CertBag = 0,
       asn1_tag_tag_PKCS12_CertBag = 16 };
struct PKCS12_CertBag {
  heim_oid certType;
  HEIM_ANY certValue;
};

ASN1EXP int    ASN1CALL decode_PKCS12_CertBag(const unsigned char *, size_t, PKCS12_CertBag *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_CertBag(unsigned char *, size_t, const PKCS12_CertBag *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_CertBag(const PKCS12_CertBag *);
ASN1EXP int    ASN1CALL copy_PKCS12_CertBag  (const PKCS12_CertBag *, PKCS12_CertBag *);
ASN1EXP void   ASN1CALL free_PKCS12_CertBag  (PKCS12_CertBag *);
ASN1EXP char * ASN1CALL print_PKCS12_CertBag (const PKCS12_CertBag *, int);


/*
PKCS12-PBEParams ::= SEQUENCE {
  salt            OCTET STRING,
  iterations      INTEGER (0..4294967295) OPTIONAL,
}
*/

enum { asn1_tag_length_PKCS12_PBEParams = 1,
       asn1_tag_class_PKCS12_PBEParams = 0,
       asn1_tag_tag_PKCS12_PBEParams = 16 };
struct PKCS12_PBEParams {
  heim_octet_string salt;
  unsigned int *iterations;
};

ASN1EXP int    ASN1CALL decode_PKCS12_PBEParams(const unsigned char *, size_t, PKCS12_PBEParams *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_PBEParams(unsigned char *, size_t, const PKCS12_PBEParams *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_PBEParams(const PKCS12_PBEParams *);
ASN1EXP int    ASN1CALL copy_PKCS12_PBEParams  (const PKCS12_PBEParams *, PKCS12_PBEParams *);
ASN1EXP void   ASN1CALL free_PKCS12_PBEParams  (PKCS12_PBEParams *);
ASN1EXP char * ASN1CALL print_PKCS12_PBEParams (const PKCS12_PBEParams *, int);


/*
PKCS12-OctetString ::= OCTET STRING
*/

enum { asn1_tag_length_PKCS12_OctetString = 1,
       asn1_tag_class_PKCS12_OctetString = 0,
       asn1_tag_tag_PKCS12_OctetString = 4 };
ASN1EXP int    ASN1CALL decode_PKCS12_OctetString(const unsigned char *, size_t, PKCS12_OctetString *, size_t *);
ASN1EXP int    ASN1CALL encode_PKCS12_OctetString(unsigned char *, size_t, const PKCS12_OctetString *, size_t *);
ASN1EXP size_t ASN1CALL length_PKCS12_OctetString(const PKCS12_OctetString *);
ASN1EXP int    ASN1CALL copy_PKCS12_OctetString  (const PKCS12_OctetString *, PKCS12_OctetString *);
ASN1EXP void   ASN1CALL free_PKCS12_OctetString  (PKCS12_OctetString *);
ASN1EXP char * ASN1CALL print_PKCS12_OctetString (const PKCS12_OctetString *, int);


#endif /* __pkcs12_asn1_h__ */
