/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: TritonInstrumentOps.td                                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace triton {
namespace instrument {
/// assert the condition within the current thread
/// Assert that the condition is true given all the values are available in the current thread.
///     If the condition is false, the message is printed, and the program is aborted.
///     If check_any is true, any of the values in the condition must be true. Otherwise, all the
///     values in the condition must be true.
class ExperimentalAssertInThreadOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// definte an array of pointers to shared memory buffers
/// Create a tensor of pointers to shared memory buffers.
class ExperimentalBufferPointersOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// verify that the barrier is not used to track any writes
/// Verify that the column corresponding to the mbar in writeBars tensor is all 0.
class ExperimentalCheckBarrierWritesClearedOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// Check if the buffer has an outstanding commit.
/// Verify that the entry corresponding to the buffer in outstandingCommits tensor is 0.
class ExperimentalCheckOutstandingCommitsOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// check if there are outstanding reads from a buffer guarded by a mbar
/// Check if any of the entries in readBars in the row corresponding to the buffer is non-zero.
class ExperimentalCheckReadBarriersOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// check if there are outstanding writes to a buffer guarded by a mbar
/// Check if the writeState tensor has non-zero value associated with the buffer.
/// 
///     If hwPipelined is true, shift the bitfield by 1 to check the second bit - this
///     means that the error won't be triggered if another pipelined write is outstanding.
class ExperimentalCheckWriteStateOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// Clear all the outstanding commits more distant than `outstandingNum.
/// Clear all the outstanding commits more distant than `outstandingNum` from the current thread.
class ExperimentalClearOutstandingCommitsOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// clear the read state for buffers being guarded by an mbar
/// Set all the entries in the column corresponding to the mbar in readBars tensor to 0.
class ExperimentalClearReadBarrierOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// clear the write state for buffers being guarded by an mbar
/// For each buffer that has [buffer, mbar] entry in writeBars tensor, set the corresponding entry in writeState tensor to 0.
///     Also, set the corresponding entry in writeBars tensor to 0.
class ExperimentalClearWriteBarrierOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// Commit all the staged accesses for all the buffers.
/// Increment the value in outstandingCommits tensor for each entry greater than 0.
///     Change all the `-1` entries in outstandingCommits tensor to 1, signifying 1 outstanding commit.
class ExperimentalCommitAccessesOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// Mark all buffers being currently written as tracked by the barrier.
/// For all buffers currently marked in writeState tensor, mark them as tracked by the mbar in
///     writeBars tensor.
class ExperimentalCommitWriteWithBarrierOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// mark a buffer as being read from using mbar as a guard
/// Set the entry under [buffer, mbar] in readBars tensor to 1, marking the buffer as tracked by the barrier.
class ExperimentalSetReadBarrierOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// mark a buffer as being written in writeState tensor
/// Mark a buffer as being written to. It is not yet tracked by a barrier, until
///     `commit_write_with_barrier` is called, at which point all the buffers being written
///     to are marked as tracked by the barrier in writeBars tensor.
/// 
///     If hwPipelined is true, the write won't trigger an error if another pipelined
///     write is executed later without waiting for the barrier.
class ExperimentalSetWriteStateOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace instrument {
/// For operations that use `outstanding` to track the number of outstanding commits (rather than mbarriers),
///     mark the buffer as being accessed, but not commited yet, by marking it with `-1`.
class ExperimentalStageAccessForCommitOp;
} // namespace instrument
} // namespace triton
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalAssertInThreadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalAssertInThreadOpGenericAdaptorBase {
public:
  struct Properties {
    using check_anyTy = ::mlir::BoolAttr;
    check_anyTy check_any;

    auto getCheckAny() const {
      auto &propStorage = this->check_any;
      return ::llvm::cast<::mlir::BoolAttr>(propStorage);
    }
    void setCheckAny(const ::mlir::BoolAttr &propValue) {
      this->check_any = propValue;
    }
    using messageTy = ::mlir::StringAttr;
    messageTy message;

    auto getMessage() const {
      auto &propStorage = this->message;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setMessage(const ::mlir::StringAttr &propValue) {
      this->message = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.check_any == this->check_any &&
        rhs.message == this->message &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalAssertInThreadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_assert_in_thread", odsAttrs.getContext());
  }

  ExperimentalAssertInThreadOpGenericAdaptorBase(ExperimentalAssertInThreadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getMessageAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().message);
    return attr;
  }

  ::llvm::StringRef getMessage();
  ::mlir::BoolAttr getCheckAnyAttr() {
    auto attr = ::llvm::cast<::mlir::BoolAttr>(getProperties().check_any);
    return attr;
  }

  bool getCheckAny();
};
} // namespace detail
template <typename RangeT>
class ExperimentalAssertInThreadOpGenericAdaptor : public detail::ExperimentalAssertInThreadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalAssertInThreadOpGenericAdaptorBase;
  static constexpr int odsIndex_condition = 0;
public:
  ExperimentalAssertInThreadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalAssertInThreadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalAssertInThreadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalAssertInThreadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalAssertInThreadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalAssertInThreadOpGenericAdaptor(RangeT values, const ExperimentalAssertInThreadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalAssertInThreadOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalAssertInThreadOp>>>
  ExperimentalAssertInThreadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getCondition() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalAssertInThreadOpAdaptor : public ExperimentalAssertInThreadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalAssertInThreadOpGenericAdaptor::ExperimentalAssertInThreadOpGenericAdaptor;
  ExperimentalAssertInThreadOpAdaptor(ExperimentalAssertInThreadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalAssertInThreadOp : public ::mlir::Op<ExperimentalAssertInThreadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalAssertInThreadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalAssertInThreadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_condition = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("check_any"), ::llvm::StringRef("message")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCheckAnyAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCheckAnyAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getMessageAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getMessageAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_assert_in_thread");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getCondition() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getConditionMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getMessageAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().message);
  }

  ::llvm::StringRef getMessage();
  ::mlir::BoolAttr getCheckAnyAttr() {
    return ::llvm::cast<::mlir::BoolAttr>(getProperties().check_any);
  }

  bool getCheckAny();
  void setMessageAttr(::mlir::StringAttr attr) {
    getProperties().message = attr;
  }

  void setMessage(::llvm::StringRef attrValue);
  void setCheckAnyAttr(::mlir::BoolAttr attr) {
    getProperties().check_any = attr;
  }

  void setCheckAny(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::mlir::StringAttr message, ::mlir::BoolAttr check_any);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value condition, ::llvm::StringRef message, bool check_any);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalAssertInThreadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalAssertInThreadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalAssertInThreadOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalBufferPointersOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalBufferPointersOpGenericAdaptorBase {
public:
  struct Properties {
    using memTypeTy = ::mlir::triton::instrument::MemTypeAttr;
    memTypeTy memType;

    auto getMemType() const {
      auto &propStorage = this->memType;
      return ::llvm::cast<::mlir::triton::instrument::MemTypeAttr>(propStorage);
    }
    void setMemType(const ::mlir::triton::instrument::MemTypeAttr &propValue) {
      this->memType = propValue;
    }
    using offsetsTy = ::mlir::DenseI32ArrayAttr;
    offsetsTy offsets;

    auto getOffsets() const {
      auto &propStorage = this->offsets;
      return ::llvm::cast<::mlir::DenseI32ArrayAttr>(propStorage);
    }
    void setOffsets(const ::mlir::DenseI32ArrayAttr &propValue) {
      this->offsets = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.memType == this->memType &&
        rhs.offsets == this->offsets &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalBufferPointersOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_buffer_pointers", odsAttrs.getContext());
  }

  ExperimentalBufferPointersOpGenericAdaptorBase(ExperimentalBufferPointersOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::DenseI32ArrayAttr getOffsetsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().offsets);
    return attr;
  }

  ::llvm::ArrayRef<int32_t> getOffsets();
  ::mlir::triton::instrument::MemTypeAttr getMemTypeAttr() {
    auto attr = ::llvm::cast<::mlir::triton::instrument::MemTypeAttr>(getProperties().memType);
    return attr;
  }

  ::mlir::triton::instrument::MemType getMemType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalBufferPointersOpGenericAdaptor : public detail::ExperimentalBufferPointersOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalBufferPointersOpGenericAdaptorBase;
public:
  ExperimentalBufferPointersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalBufferPointersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalBufferPointersOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalBufferPointersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalBufferPointersOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalBufferPointersOpGenericAdaptor(RangeT values, const ExperimentalBufferPointersOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalBufferPointersOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalBufferPointersOp>>>
  ExperimentalBufferPointersOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalBufferPointersOpAdaptor : public ExperimentalBufferPointersOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalBufferPointersOpGenericAdaptor::ExperimentalBufferPointersOpGenericAdaptor;
  ExperimentalBufferPointersOpAdaptor(ExperimentalBufferPointersOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalBufferPointersOp : public ::mlir::Op<ExperimentalBufferPointersOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalBufferPointersOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalBufferPointersOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("memType"), ::llvm::StringRef("offsets")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMemTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMemTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOffsetsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOffsetsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_buffer_pointers");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::DenseI32ArrayAttr getOffsetsAttr() {
    return ::llvm::cast<::mlir::DenseI32ArrayAttr>(getProperties().offsets);
  }

  ::llvm::ArrayRef<int32_t> getOffsets();
  ::mlir::triton::instrument::MemTypeAttr getMemTypeAttr() {
    return ::llvm::cast<::mlir::triton::instrument::MemTypeAttr>(getProperties().memType);
  }

  ::mlir::triton::instrument::MemType getMemType();
  void setOffsetsAttr(::mlir::DenseI32ArrayAttr attr) {
    getProperties().offsets = attr;
  }

  void setOffsets(::llvm::ArrayRef<int32_t> attrValue);
  void setMemTypeAttr(::mlir::triton::instrument::MemTypeAttr attr) {
    getProperties().memType = attr;
  }

  void setMemType(::mlir::triton::instrument::MemType attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::DenseI32ArrayAttr offsets, ::mlir::triton::instrument::MemTypeAttr memType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::ArrayRef<int32_t> offsets, ::mlir::triton::instrument::MemType memType);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalBufferPointersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalBufferPointersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalBufferPointersOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckBarrierWritesClearedOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase {
public:
  struct Properties {
    using writeBarsTypeTy = ::mlir::TypeAttr;
    writeBarsTypeTy writeBarsType;

    auto getWriteBarsType() const {
      auto &propStorage = this->writeBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteBarsType(const ::mlir::TypeAttr &propValue) {
      this->writeBarsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.writeBarsType == this->writeBarsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_check_barrier_writes_cleared", odsAttrs.getContext());
  }

  ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase(ExperimentalCheckBarrierWritesClearedOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
    return attr;
  }

  ::mlir::Type getWriteBarsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCheckBarrierWritesClearedOpGenericAdaptor : public detail::ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(RangeT values, const ExperimentalCheckBarrierWritesClearedOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCheckBarrierWritesClearedOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCheckBarrierWritesClearedOp>>>
  ExperimentalCheckBarrierWritesClearedOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMbar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBarriers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getWriteBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCheckBarrierWritesClearedOpAdaptor : public ExperimentalCheckBarrierWritesClearedOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCheckBarrierWritesClearedOpGenericAdaptor::ExperimentalCheckBarrierWritesClearedOpGenericAdaptor;
  ExperimentalCheckBarrierWritesClearedOpAdaptor(ExperimentalCheckBarrierWritesClearedOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCheckBarrierWritesClearedOp : public ::mlir::Op<ExperimentalCheckBarrierWritesClearedOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCheckBarrierWritesClearedOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCheckBarrierWritesClearedOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("writeBarsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWriteBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWriteBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_check_barrier_writes_cleared");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBarriers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBarriersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
  }

  ::mlir::Type getWriteBarsType();
  void setWriteBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeBarsType = attr;
  }

  void setWriteBarsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckBarrierWritesClearedOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckBarrierWritesClearedOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckOutstandingCommitsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase {
public:
  struct Properties {
    using outstandingCommitsTypeTy = ::mlir::TypeAttr;
    outstandingCommitsTypeTy outstandingCommitsType;

    auto getOutstandingCommitsType() const {
      auto &propStorage = this->outstandingCommitsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOutstandingCommitsType(const ::mlir::TypeAttr &propValue) {
      this->outstandingCommitsType = propValue;
    }
    using pendingAccessTypeTy = ::mlir::StringAttr;
    pendingAccessTypeTy pendingAccessType;

    auto getPendingAccessType() const {
      auto &propStorage = this->pendingAccessType;
      return ::llvm::cast<::mlir::StringAttr>(propStorage);
    }
    void setPendingAccessType(const ::mlir::StringAttr &propValue) {
      this->pendingAccessType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.outstandingCommitsType == this->outstandingCommitsType &&
        rhs.pendingAccessType == this->pendingAccessType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_check_outstanding_commits", odsAttrs.getContext());
  }

  ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase(ExperimentalCheckOutstandingCommitsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
    return attr;
  }

  ::mlir::Type getOutstandingCommitsType();
  ::mlir::StringAttr getPendingAccessTypeAttr() {
    auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().pendingAccessType);
    return attr;
  }

  ::llvm::StringRef getPendingAccessType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCheckOutstandingCommitsOpGenericAdaptor : public detail::ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_outstandingCommits = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalCheckOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCheckOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCheckOutstandingCommitsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCheckOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCheckOutstandingCommitsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCheckOutstandingCommitsOpGenericAdaptor(RangeT values, const ExperimentalCheckOutstandingCommitsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCheckOutstandingCommitsOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCheckOutstandingCommitsOp>>>
  ExperimentalCheckOutstandingCommitsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutstandingCommits() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCheckOutstandingCommitsOpAdaptor : public ExperimentalCheckOutstandingCommitsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCheckOutstandingCommitsOpGenericAdaptor::ExperimentalCheckOutstandingCommitsOpGenericAdaptor;
  ExperimentalCheckOutstandingCommitsOpAdaptor(ExperimentalCheckOutstandingCommitsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCheckOutstandingCommitsOp : public ::mlir::Op<ExperimentalCheckOutstandingCommitsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCheckOutstandingCommitsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCheckOutstandingCommitsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_outstandingCommits = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("outstandingCommitsType"), ::llvm::StringRef("pendingAccessType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutstandingCommitsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutstandingCommitsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getPendingAccessTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getPendingAccessTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_check_outstanding_commits");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getOutstandingCommits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutstandingCommitsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
  }

  ::mlir::Type getOutstandingCommitsType();
  ::mlir::StringAttr getPendingAccessTypeAttr() {
    return ::llvm::cast<::mlir::StringAttr>(getProperties().pendingAccessType);
  }

  ::llvm::StringRef getPendingAccessType();
  void setOutstandingCommitsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().outstandingCommitsType = attr;
  }

  void setOutstandingCommitsType(::mlir::Type attrValue);
  void setPendingAccessTypeAttr(::mlir::StringAttr attr) {
    getProperties().pendingAccessType = attr;
  }

  void setPendingAccessType(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::StringAttr pendingAccessType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, ::llvm::StringRef pendingAccessType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckOutstandingCommitsOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckReadBarriersOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCheckReadBarriersOpGenericAdaptorBase {
public:
  struct Properties {
    using readBarsTypeTy = ::mlir::TypeAttr;
    readBarsTypeTy readBarsType;

    auto getReadBarsType() const {
      auto &propStorage = this->readBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setReadBarsType(const ::mlir::TypeAttr &propValue) {
      this->readBarsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.readBarsType == this->readBarsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCheckReadBarriersOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_check_read_barriers", odsAttrs.getContext());
  }

  ExperimentalCheckReadBarriersOpGenericAdaptorBase(ExperimentalCheckReadBarriersOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getReadBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
    return attr;
  }

  ::mlir::Type getReadBarsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCheckReadBarriersOpGenericAdaptor : public detail::ExperimentalCheckReadBarriersOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCheckReadBarriersOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_readBars = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalCheckReadBarriersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCheckReadBarriersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCheckReadBarriersOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCheckReadBarriersOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCheckReadBarriersOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCheckReadBarriersOpGenericAdaptor(RangeT values, const ExperimentalCheckReadBarriersOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCheckReadBarriersOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCheckReadBarriersOp>>>
  ExperimentalCheckReadBarriersOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getReadBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCheckReadBarriersOpAdaptor : public ExperimentalCheckReadBarriersOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCheckReadBarriersOpGenericAdaptor::ExperimentalCheckReadBarriersOpGenericAdaptor;
  ExperimentalCheckReadBarriersOpAdaptor(ExperimentalCheckReadBarriersOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCheckReadBarriersOp : public ::mlir::Op<ExperimentalCheckReadBarriersOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCheckReadBarriersOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCheckReadBarriersOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_readBars = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("readBarsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReadBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReadBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_check_read_barriers");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getReadBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReadBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getReadBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
  }

  ::mlir::Type getReadBarsType();
  void setReadBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().readBarsType = attr;
  }

  void setReadBarsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckReadBarriersOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckReadBarriersOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckReadBarriersOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCheckWriteStateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCheckWriteStateOpGenericAdaptorBase {
public:
  struct Properties {
    using hwPipelinedTy = ::mlir::IntegerAttr;
    hwPipelinedTy hwPipelined;

    auto getHwPipelined() const {
      auto &propStorage = this->hwPipelined;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setHwPipelined(const ::mlir::IntegerAttr &propValue) {
      this->hwPipelined = propValue;
    }
    using writeBarsTypeTy = ::mlir::TypeAttr;
    writeBarsTypeTy writeBarsType;

    auto getWriteBarsType() const {
      auto &propStorage = this->writeBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteBarsType(const ::mlir::TypeAttr &propValue) {
      this->writeBarsType = propValue;
    }
    using writeStateTypeTy = ::mlir::TypeAttr;
    writeStateTypeTy writeStateType;

    auto getWriteStateType() const {
      auto &propStorage = this->writeStateType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteStateType(const ::mlir::TypeAttr &propValue) {
      this->writeStateType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.hwPipelined == this->hwPipelined &&
        rhs.writeBarsType == this->writeBarsType &&
        rhs.writeStateType == this->writeStateType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCheckWriteStateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_check_write_state", odsAttrs.getContext());
  }

  ExperimentalCheckWriteStateOpGenericAdaptorBase(ExperimentalCheckWriteStateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
    return attr;
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
    return attr;
  }

  ::mlir::Type getWriteStateType();
  ::mlir::IntegerAttr getHwPipelinedAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().hwPipelined);
    return attr;
  }

  bool getHwPipelined();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCheckWriteStateOpGenericAdaptor : public detail::ExperimentalCheckWriteStateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCheckWriteStateOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
public:
  ExperimentalCheckWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCheckWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCheckWriteStateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCheckWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCheckWriteStateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCheckWriteStateOpGenericAdaptor(RangeT values, const ExperimentalCheckWriteStateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCheckWriteStateOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCheckWriteStateOp>>>
  ExperimentalCheckWriteStateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getWriteBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getWriteState() {
    return (*getODSOperands(3).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCheckWriteStateOpAdaptor : public ExperimentalCheckWriteStateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCheckWriteStateOpGenericAdaptor::ExperimentalCheckWriteStateOpGenericAdaptor;
  ExperimentalCheckWriteStateOpAdaptor(ExperimentalCheckWriteStateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCheckWriteStateOp : public ::mlir::Op<ExperimentalCheckWriteStateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCheckWriteStateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCheckWriteStateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("hwPipelined"), ::llvm::StringRef("writeBarsType"), ::llvm::StringRef("writeStateType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getHwPipelinedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getHwPipelinedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getWriteBarsTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getWriteBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getWriteStateTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getWriteStateTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_check_write_state");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteState() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteStateMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
  }

  ::mlir::Type getWriteStateType();
  ::mlir::IntegerAttr getHwPipelinedAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().hwPipelined);
  }

  bool getHwPipelined();
  void setWriteBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeBarsType = attr;
  }

  void setWriteBarsType(::mlir::Type attrValue);
  void setWriteStateTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeStateType = attr;
  }

  void setWriteStateType(::mlir::Type attrValue);
  void setHwPipelinedAttr(::mlir::IntegerAttr attr) {
    getProperties().hwPipelined = attr;
  }

  void setHwPipelined(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCheckWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCheckWriteStateOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearOutstandingCommitsOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalClearOutstandingCommitsOpGenericAdaptorBase {
public:
  struct Properties {
    using outstandingCommitsTypeTy = ::mlir::TypeAttr;
    outstandingCommitsTypeTy outstandingCommitsType;

    auto getOutstandingCommitsType() const {
      auto &propStorage = this->outstandingCommitsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOutstandingCommitsType(const ::mlir::TypeAttr &propValue) {
      this->outstandingCommitsType = propValue;
    }
    using outstandingNumTy = ::mlir::IntegerAttr;
    outstandingNumTy outstandingNum;

    auto getOutstandingNum() const {
      auto &propStorage = this->outstandingNum;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setOutstandingNum(const ::mlir::IntegerAttr &propValue) {
      this->outstandingNum = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.outstandingCommitsType == this->outstandingCommitsType &&
        rhs.outstandingNum == this->outstandingNum &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalClearOutstandingCommitsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_clear_outstanding_commits", odsAttrs.getContext());
  }

  ExperimentalClearOutstandingCommitsOpGenericAdaptorBase(ExperimentalClearOutstandingCommitsOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
    return attr;
  }

  ::mlir::Type getOutstandingCommitsType();
  ::mlir::IntegerAttr getOutstandingNumAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().outstandingNum);
    return attr;
  }

  uint32_t getOutstandingNum();
};
} // namespace detail
template <typename RangeT>
class ExperimentalClearOutstandingCommitsOpGenericAdaptor : public detail::ExperimentalClearOutstandingCommitsOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalClearOutstandingCommitsOpGenericAdaptorBase;
  static constexpr int odsIndex_outstandingCommits = 0;
  static constexpr int odsIndex_pred = 1;
public:
  ExperimentalClearOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalClearOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalClearOutstandingCommitsOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalClearOutstandingCommitsOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalClearOutstandingCommitsOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalClearOutstandingCommitsOpGenericAdaptor(RangeT values, const ExperimentalClearOutstandingCommitsOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalClearOutstandingCommitsOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalClearOutstandingCommitsOp>>>
  ExperimentalClearOutstandingCommitsOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOutstandingCommits() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalClearOutstandingCommitsOpAdaptor : public ExperimentalClearOutstandingCommitsOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalClearOutstandingCommitsOpGenericAdaptor::ExperimentalClearOutstandingCommitsOpGenericAdaptor;
  ExperimentalClearOutstandingCommitsOpAdaptor(ExperimentalClearOutstandingCommitsOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalClearOutstandingCommitsOp : public ::mlir::Op<ExperimentalClearOutstandingCommitsOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalClearOutstandingCommitsOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalClearOutstandingCommitsOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_outstandingCommits = 0;
  static constexpr int odsIndex_pred = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("outstandingCommitsType"), ::llvm::StringRef("outstandingNum")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutstandingCommitsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutstandingCommitsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOutstandingNumAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getOutstandingNumAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_clear_outstanding_commits");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOutstandingCommits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getOutstandingCommitsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
  }

  ::mlir::Type getOutstandingCommitsType();
  ::mlir::IntegerAttr getOutstandingNumAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().outstandingNum);
  }

  uint32_t getOutstandingNum();
  void setOutstandingCommitsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().outstandingCommitsType = attr;
  }

  void setOutstandingCommitsType(::mlir::Type attrValue);
  void setOutstandingNumAttr(::mlir::IntegerAttr attr) {
    getProperties().outstandingNum = attr;
  }

  void setOutstandingNum(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, ::mlir::IntegerAttr outstandingNum, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, uint32_t outstandingNum, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearOutstandingCommitsOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearOutstandingCommitsOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearOutstandingCommitsOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearReadBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalClearReadBarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using readBarsTypeTy = ::mlir::TypeAttr;
    readBarsTypeTy readBarsType;

    auto getReadBarsType() const {
      auto &propStorage = this->readBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setReadBarsType(const ::mlir::TypeAttr &propValue) {
      this->readBarsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.readBarsType == this->readBarsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalClearReadBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_clear_read_barrier", odsAttrs.getContext());
  }

  ExperimentalClearReadBarrierOpGenericAdaptorBase(ExperimentalClearReadBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getReadBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
    return attr;
  }

  ::mlir::Type getReadBarsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalClearReadBarrierOpGenericAdaptor : public detail::ExperimentalClearReadBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalClearReadBarrierOpGenericAdaptorBase;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_readBars = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalClearReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalClearReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalClearReadBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalClearReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalClearReadBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalClearReadBarrierOpGenericAdaptor(RangeT values, const ExperimentalClearReadBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalClearReadBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalClearReadBarrierOp>>>
  ExperimentalClearReadBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMbar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBarriers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getReadBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalClearReadBarrierOpAdaptor : public ExperimentalClearReadBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalClearReadBarrierOpGenericAdaptor::ExperimentalClearReadBarrierOpGenericAdaptor;
  ExperimentalClearReadBarrierOpAdaptor(ExperimentalClearReadBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalClearReadBarrierOp : public ::mlir::Op<ExperimentalClearReadBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalClearReadBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalClearReadBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_readBars = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("readBarsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReadBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReadBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_clear_read_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBarriers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getReadBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBarriersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReadBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getReadBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
  }

  ::mlir::Type getReadBarsType();
  void setReadBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().readBarsType = attr;
  }

  void setReadBarsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearReadBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalClearWriteBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalClearWriteBarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using writeBarsTypeTy = ::mlir::TypeAttr;
    writeBarsTypeTy writeBarsType;

    auto getWriteBarsType() const {
      auto &propStorage = this->writeBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteBarsType(const ::mlir::TypeAttr &propValue) {
      this->writeBarsType = propValue;
    }
    using writeStateTypeTy = ::mlir::TypeAttr;
    writeStateTypeTy writeStateType;

    auto getWriteStateType() const {
      auto &propStorage = this->writeStateType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteStateType(const ::mlir::TypeAttr &propValue) {
      this->writeStateType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.writeBarsType == this->writeBarsType &&
        rhs.writeStateType == this->writeStateType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalClearWriteBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_clear_write_barrier", odsAttrs.getContext());
  }

  ExperimentalClearWriteBarrierOpGenericAdaptorBase(ExperimentalClearWriteBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
    return attr;
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
    return attr;
  }

  ::mlir::Type getWriteStateType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalClearWriteBarrierOpGenericAdaptor : public detail::ExperimentalClearWriteBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalClearWriteBarrierOpGenericAdaptorBase;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
public:
  ExperimentalClearWriteBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalClearWriteBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalClearWriteBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalClearWriteBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalClearWriteBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalClearWriteBarrierOpGenericAdaptor(RangeT values, const ExperimentalClearWriteBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalClearWriteBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalClearWriteBarrierOp>>>
  ExperimentalClearWriteBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMbar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBarriers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getWriteBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getWriteState() {
    return (*getODSOperands(3).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalClearWriteBarrierOpAdaptor : public ExperimentalClearWriteBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalClearWriteBarrierOpGenericAdaptor::ExperimentalClearWriteBarrierOpGenericAdaptor;
  ExperimentalClearWriteBarrierOpAdaptor(ExperimentalClearWriteBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalClearWriteBarrierOp : public ::mlir::Op<ExperimentalClearWriteBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalClearWriteBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalClearWriteBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("writeBarsType"), ::llvm::StringRef("writeStateType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWriteBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWriteBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getWriteStateTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getWriteStateTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_clear_write_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBarriers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteState() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBarriersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteStateMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
  }

  ::mlir::Type getWriteStateType();
  void setWriteBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeBarsType = attr;
  }

  void setWriteBarsType(::mlir::Type attrValue);
  void setWriteStateTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeStateType = attr;
  }

  void setWriteStateType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearWriteBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalClearWriteBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalClearWriteBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCommitAccessesOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCommitAccessesOpGenericAdaptorBase {
public:
  struct Properties {
    using outstandingCommitsTypeTy = ::mlir::TypeAttr;
    outstandingCommitsTypeTy outstandingCommitsType;

    auto getOutstandingCommitsType() const {
      auto &propStorage = this->outstandingCommitsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOutstandingCommitsType(const ::mlir::TypeAttr &propValue) {
      this->outstandingCommitsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.outstandingCommitsType == this->outstandingCommitsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCommitAccessesOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_commit_accesses", odsAttrs.getContext());
  }

  ExperimentalCommitAccessesOpGenericAdaptorBase(ExperimentalCommitAccessesOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
    return attr;
  }

  ::mlir::Type getOutstandingCommitsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCommitAccessesOpGenericAdaptor : public detail::ExperimentalCommitAccessesOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCommitAccessesOpGenericAdaptorBase;
  static constexpr int odsIndex_outstandingCommits = 0;
  static constexpr int odsIndex_pred = 1;
public:
  ExperimentalCommitAccessesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCommitAccessesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCommitAccessesOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCommitAccessesOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCommitAccessesOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCommitAccessesOpGenericAdaptor(RangeT values, const ExperimentalCommitAccessesOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCommitAccessesOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCommitAccessesOp>>>
  ExperimentalCommitAccessesOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getOutstandingCommits() {
    return (*getODSOperands(0).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCommitAccessesOpAdaptor : public ExperimentalCommitAccessesOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCommitAccessesOpGenericAdaptor::ExperimentalCommitAccessesOpGenericAdaptor;
  ExperimentalCommitAccessesOpAdaptor(ExperimentalCommitAccessesOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCommitAccessesOp : public ::mlir::Op<ExperimentalCommitAccessesOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCommitAccessesOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCommitAccessesOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_outstandingCommits = 0;
  static constexpr int odsIndex_pred = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("outstandingCommitsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutstandingCommitsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutstandingCommitsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_commit_accesses");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getOutstandingCommits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(1);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getOutstandingCommitsMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
  }

  ::mlir::Type getOutstandingCommitsType();
  void setOutstandingCommitsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().outstandingCommitsType = attr;
  }

  void setOutstandingCommitsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCommitAccessesOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCommitAccessesOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCommitAccessesOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalCommitWriteWithBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using writeBarsTypeTy = ::mlir::TypeAttr;
    writeBarsTypeTy writeBarsType;

    auto getWriteBarsType() const {
      auto &propStorage = this->writeBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteBarsType(const ::mlir::TypeAttr &propValue) {
      this->writeBarsType = propValue;
    }
    using writeStateTypeTy = ::mlir::TypeAttr;
    writeStateTypeTy writeStateType;

    auto getWriteStateType() const {
      auto &propStorage = this->writeStateType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteStateType(const ::mlir::TypeAttr &propValue) {
      this->writeStateType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.writeBarsType == this->writeBarsType &&
        rhs.writeStateType == this->writeStateType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_commit_write_with_barrier", odsAttrs.getContext());
  }

  ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase(ExperimentalCommitWriteWithBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
    return attr;
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
    return attr;
  }

  ::mlir::Type getWriteStateType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalCommitWriteWithBarrierOpGenericAdaptor : public detail::ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
public:
  ExperimentalCommitWriteWithBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalCommitWriteWithBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalCommitWriteWithBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalCommitWriteWithBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalCommitWriteWithBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalCommitWriteWithBarrierOpGenericAdaptor(RangeT values, const ExperimentalCommitWriteWithBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalCommitWriteWithBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalCommitWriteWithBarrierOp>>>
  ExperimentalCommitWriteWithBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMbar() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBarriers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getWriteBars() {
    return (*getODSOperands(2).begin());
  }

  ValueT getWriteState() {
    return (*getODSOperands(3).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalCommitWriteWithBarrierOpAdaptor : public ExperimentalCommitWriteWithBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalCommitWriteWithBarrierOpGenericAdaptor::ExperimentalCommitWriteWithBarrierOpGenericAdaptor;
  ExperimentalCommitWriteWithBarrierOpAdaptor(ExperimentalCommitWriteWithBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalCommitWriteWithBarrierOp : public ::mlir::Op<ExperimentalCommitWriteWithBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalCommitWriteWithBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalCommitWriteWithBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_mbar = 0;
  static constexpr int odsIndex_barriers = 1;
  static constexpr int odsIndex_writeBars = 2;
  static constexpr int odsIndex_writeState = 3;
  static constexpr int odsIndex_pred = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("writeBarsType"), ::llvm::StringRef("writeStateType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getWriteBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getWriteBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getWriteStateTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getWriteStateTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_commit_write_with_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBarriers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteState() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBarriersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteBarsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteStateMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getWriteBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeBarsType);
  }

  ::mlir::Type getWriteBarsType();
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
  }

  ::mlir::Type getWriteStateType();
  void setWriteBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeBarsType = attr;
  }

  void setWriteBarsType(::mlir::Type attrValue);
  void setWriteStateTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeStateType = attr;
  }

  void setWriteStateType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::TypeAttr writeBarsType, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value mbar, ::mlir::Value barriers, ::mlir::Value writeBars, ::mlir::Type writeBarsType, ::mlir::Value writeState, ::mlir::Type writeStateType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalCommitWriteWithBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalCommitWriteWithBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalSetReadBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalSetReadBarrierOpGenericAdaptorBase {
public:
  struct Properties {
    using readBarsTypeTy = ::mlir::TypeAttr;
    readBarsTypeTy readBarsType;

    auto getReadBarsType() const {
      auto &propStorage = this->readBarsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setReadBarsType(const ::mlir::TypeAttr &propValue) {
      this->readBarsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.readBarsType == this->readBarsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalSetReadBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_set_read_barrier", odsAttrs.getContext());
  }

  ExperimentalSetReadBarrierOpGenericAdaptorBase(ExperimentalSetReadBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getReadBarsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
    return attr;
  }

  ::mlir::Type getReadBarsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalSetReadBarrierOpGenericAdaptor : public detail::ExperimentalSetReadBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalSetReadBarrierOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_mbar = 1;
  static constexpr int odsIndex_buffers = 2;
  static constexpr int odsIndex_barriers = 3;
  static constexpr int odsIndex_readBars = 4;
  static constexpr int odsIndex_pred = 5;
public:
  ExperimentalSetReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalSetReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalSetReadBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalSetReadBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalSetReadBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalSetReadBarrierOpGenericAdaptor(RangeT values, const ExperimentalSetReadBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalSetReadBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalSetReadBarrierOp>>>
  ExperimentalSetReadBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMbar() {
    return (*getODSOperands(1).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(2).begin());
  }

  ValueT getBarriers() {
    return (*getODSOperands(3).begin());
  }

  ValueT getReadBars() {
    return (*getODSOperands(4).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalSetReadBarrierOpAdaptor : public ExperimentalSetReadBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalSetReadBarrierOpGenericAdaptor::ExperimentalSetReadBarrierOpGenericAdaptor;
  ExperimentalSetReadBarrierOpAdaptor(ExperimentalSetReadBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalSetReadBarrierOp : public ::mlir::Op<ExperimentalSetReadBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalSetReadBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalSetReadBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_mbar = 1;
  static constexpr int odsIndex_buffers = 2;
  static constexpr int odsIndex_barriers = 3;
  static constexpr int odsIndex_readBars = 4;
  static constexpr int odsIndex_pred = 5;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("readBarsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getReadBarsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getReadBarsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_set_read_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getMbar() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBarriers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getReadBars() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(4).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(5);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMbarMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBarriersMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getReadBarsMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getReadBarsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().readBarsType);
  }

  ::mlir::Type getReadBarsType();
  void setReadBarsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().readBarsType = attr;
  }

  void setReadBarsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::TypeAttr readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value mbar, ::mlir::Value buffers, ::mlir::Value barriers, ::mlir::Value readBars, ::mlir::Type readBarsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalSetReadBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalSetReadBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalSetReadBarrierOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalSetWriteStateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalSetWriteStateOpGenericAdaptorBase {
public:
  struct Properties {
    using hwPipelinedTy = ::mlir::IntegerAttr;
    hwPipelinedTy hwPipelined;

    auto getHwPipelined() const {
      auto &propStorage = this->hwPipelined;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setHwPipelined(const ::mlir::IntegerAttr &propValue) {
      this->hwPipelined = propValue;
    }
    using writeStateTypeTy = ::mlir::TypeAttr;
    writeStateTypeTy writeStateType;

    auto getWriteStateType() const {
      auto &propStorage = this->writeStateType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setWriteStateType(const ::mlir::TypeAttr &propValue) {
      this->writeStateType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.hwPipelined == this->hwPipelined &&
        rhs.writeStateType == this->writeStateType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalSetWriteStateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_set_write_state", odsAttrs.getContext());
  }

  ExperimentalSetWriteStateOpGenericAdaptorBase(ExperimentalSetWriteStateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getWriteStateTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
    return attr;
  }

  ::mlir::Type getWriteStateType();
  ::mlir::IntegerAttr getHwPipelinedAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().hwPipelined);
    return attr;
  }

  bool getHwPipelined();
};
} // namespace detail
template <typename RangeT>
class ExperimentalSetWriteStateOpGenericAdaptor : public detail::ExperimentalSetWriteStateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalSetWriteStateOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_writeState = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalSetWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalSetWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalSetWriteStateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalSetWriteStateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalSetWriteStateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalSetWriteStateOpGenericAdaptor(RangeT values, const ExperimentalSetWriteStateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalSetWriteStateOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalSetWriteStateOp>>>
  ExperimentalSetWriteStateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getWriteState() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalSetWriteStateOpAdaptor : public ExperimentalSetWriteStateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalSetWriteStateOpGenericAdaptor::ExperimentalSetWriteStateOpGenericAdaptor;
  ExperimentalSetWriteStateOpAdaptor(ExperimentalSetWriteStateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalSetWriteStateOp : public ::mlir::Op<ExperimentalSetWriteStateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalSetWriteStateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalSetWriteStateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_writeState = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("hwPipelined"), ::llvm::StringRef("writeStateType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getHwPipelinedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getHwPipelinedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getWriteStateTypeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getWriteStateTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_set_write_state");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getWriteState() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWriteStateMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getWriteStateTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().writeStateType);
  }

  ::mlir::Type getWriteStateType();
  ::mlir::IntegerAttr getHwPipelinedAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().hwPipelined);
  }

  bool getHwPipelined();
  void setWriteStateTypeAttr(::mlir::TypeAttr attr) {
    getProperties().writeStateType = attr;
  }

  void setWriteStateType(::mlir::Type attrValue);
  void setHwPipelinedAttr(::mlir::IntegerAttr attr) {
    getProperties().hwPipelined = attr;
  }

  void setHwPipelined(bool attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::TypeAttr writeStateType, ::mlir::IntegerAttr hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value writeState, ::mlir::Type writeStateType, bool hwPipelined, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalSetWriteStateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalSetWriteStateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalSetWriteStateOp)

namespace mlir {
namespace triton {
namespace instrument {

//===----------------------------------------------------------------------===//
// ::mlir::triton::instrument::ExperimentalStageAccessForCommitOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExperimentalStageAccessForCommitOpGenericAdaptorBase {
public:
  struct Properties {
    using outstandingCommitsTypeTy = ::mlir::TypeAttr;
    outstandingCommitsTypeTy outstandingCommitsType;

    auto getOutstandingCommitsType() const {
      auto &propStorage = this->outstandingCommitsType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setOutstandingCommitsType(const ::mlir::TypeAttr &propValue) {
      this->outstandingCommitsType = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.outstandingCommitsType == this->outstandingCommitsType &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExperimentalStageAccessForCommitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("tti.experimental_stage_access_for_commit", odsAttrs.getContext());
  }

  ExperimentalStageAccessForCommitOpGenericAdaptorBase(ExperimentalStageAccessForCommitOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
    return attr;
  }

  ::mlir::Type getOutstandingCommitsType();
};
} // namespace detail
template <typename RangeT>
class ExperimentalStageAccessForCommitOpGenericAdaptor : public detail::ExperimentalStageAccessForCommitOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExperimentalStageAccessForCommitOpGenericAdaptorBase;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_outstandingCommits = 2;
  static constexpr int odsIndex_pred = 3;
public:
  ExperimentalStageAccessForCommitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExperimentalStageAccessForCommitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExperimentalStageAccessForCommitOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExperimentalStageAccessForCommitOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExperimentalStageAccessForCommitOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExperimentalStageAccessForCommitOpGenericAdaptor(RangeT values, const ExperimentalStageAccessForCommitOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExperimentalStageAccessForCommitOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExperimentalStageAccessForCommitOp>>>
  ExperimentalStageAccessForCommitOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getBuf() {
    return (*getODSOperands(0).begin());
  }

  ValueT getBuffers() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutstandingCommits() {
    return (*getODSOperands(2).begin());
  }

  ValueT getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExperimentalStageAccessForCommitOpAdaptor : public ExperimentalStageAccessForCommitOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExperimentalStageAccessForCommitOpGenericAdaptor::ExperimentalStageAccessForCommitOpGenericAdaptor;
  ExperimentalStageAccessForCommitOpAdaptor(ExperimentalStageAccessForCommitOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExperimentalStageAccessForCommitOp : public ::mlir::Op<ExperimentalStageAccessForCommitOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExperimentalStageAccessForCommitOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExperimentalStageAccessForCommitOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buf = 0;
  static constexpr int odsIndex_buffers = 1;
  static constexpr int odsIndex_outstandingCommits = 2;
  static constexpr int odsIndex_pred = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("outstandingCommitsType")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getOutstandingCommitsTypeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getOutstandingCommitsTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("tti.experimental_stage_access_for_commit");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::triton::gpu::MemDescType> getBuf() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::triton::gpu::MemDescType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getBuffers() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getOutstandingCommits() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getPred() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
  }

  ::mlir::OpOperand &getBufMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBuffersMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutstandingCommitsMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPredMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getOutstandingCommitsTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().outstandingCommitsType);
  }

  ::mlir::Type getOutstandingCommitsType();
  void setOutstandingCommitsTypeAttr(::mlir::TypeAttr attr) {
    getProperties().outstandingCommitsType = attr;
  }

  void setOutstandingCommitsType(::mlir::Type attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::TypeAttr outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buf, ::mlir::Value buffers, ::mlir::Value outstandingCommits, ::mlir::Type outstandingCommitsType, /*optional*/::mlir::Value pred);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalStageAccessForCommitOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExperimentalStageAccessForCommitOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace instrument
} // namespace triton
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::triton::instrument::ExperimentalStageAccessForCommitOp)


#endif  // GET_OP_CLASSES

