/* DockItemDrawValue.c generated by valac 0.56.17, the Vala compiler
 * generated from DockItemDrawValue.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _PlankParamSpecDockItemDrawValue PlankParamSpecDockItemDrawValue;

struct _PlankParamSpecDockItemDrawValue {
	GParamSpec parent_instance;
};

static gpointer plank_dock_item_draw_value_parent_class = NULL;

static void plank_dock_item_draw_value_finalize (PlankDockItemDrawValue * obj);
static GType plank_dock_item_draw_value_get_type_once (void);

PlankPointD*
plank_point_d_dup (const PlankPointD* self)
{
	PlankPointD* dup;
	dup = g_new0 (PlankPointD, 1);
	memcpy (dup, self, sizeof (PlankPointD));
	return dup;
}

void
plank_point_d_free (PlankPointD* self)
{
	g_free (self);
}

static GType
plank_point_d_get_type_once (void)
{
	GType plank_point_d_type_id;
	plank_point_d_type_id = g_boxed_type_register_static ("PlankPointD", (GBoxedCopyFunc) plank_point_d_dup, (GBoxedFreeFunc) plank_point_d_free);
	return plank_point_d_type_id;
}

GType
plank_point_d_get_type (void)
{
	static volatile gsize plank_point_d_type_id__once = 0;
	if (g_once_init_enter (&plank_point_d_type_id__once)) {
		GType plank_point_d_type_id;
		plank_point_d_type_id = plank_point_d_get_type_once ();
		g_once_init_leave (&plank_point_d_type_id__once, plank_point_d_type_id);
	}
	return plank_point_d_type_id__once;
}

void
plank_dock_item_draw_value_move_in (PlankDockItemDrawValue* self,
                                    GtkPositionType position,
                                    gdouble damount)
{
	gint amount = 0;
	g_return_if_fail (self != NULL);
	amount = (gint) damount;
	switch (position) {
		default:
		case GTK_POS_BOTTOM:
		{
			self->center.y = self->center.y - damount;
			self->static_center.y = self->static_center.y - damount;
			self->hover_region.y = self->hover_region.y - amount;
			self->draw_region.y = self->draw_region.y - amount;
			break;
		}
		case GTK_POS_TOP:
		{
			self->center.y = self->center.y + damount;
			self->static_center.y = self->static_center.y + damount;
			self->hover_region.y = self->hover_region.y + amount;
			self->draw_region.y = self->draw_region.y + amount;
			break;
		}
		case GTK_POS_LEFT:
		{
			self->center.x = self->center.x + damount;
			self->static_center.x = self->static_center.x + damount;
			self->hover_region.x = self->hover_region.x + amount;
			self->draw_region.x = self->draw_region.x + amount;
			break;
		}
		case GTK_POS_RIGHT:
		{
			self->center.x = self->center.x - damount;
			self->static_center.x = self->static_center.x - damount;
			self->hover_region.x = self->hover_region.x - amount;
			self->draw_region.x = self->draw_region.x - amount;
			break;
		}
	}
}

void
plank_dock_item_draw_value_move_right (PlankDockItemDrawValue* self,
                                       GtkPositionType position,
                                       gdouble damount)
{
	gint amount = 0;
	g_return_if_fail (self != NULL);
	amount = (gint) damount;
	switch (position) {
		default:
		case GTK_POS_BOTTOM:
		{
			self->center.x = self->center.x + damount;
			self->static_center.x = self->static_center.x + damount;
			self->hover_region.x = self->hover_region.x + amount;
			self->draw_region.x = self->draw_region.x + amount;
			self->background_region.x = self->background_region.x + amount;
			break;
		}
		case GTK_POS_TOP:
		{
			self->center.x = self->center.x + damount;
			self->static_center.x = self->static_center.x + damount;
			self->hover_region.x = self->hover_region.x + amount;
			self->draw_region.x = self->draw_region.x + amount;
			self->background_region.x = self->background_region.x + amount;
			break;
		}
		case GTK_POS_LEFT:
		{
			self->center.y = self->center.y + damount;
			self->static_center.y = self->static_center.y + damount;
			self->hover_region.y = self->hover_region.y + amount;
			self->draw_region.y = self->draw_region.y + amount;
			self->background_region.y = self->background_region.y + amount;
			break;
		}
		case GTK_POS_RIGHT:
		{
			self->center.y = self->center.y + damount;
			self->static_center.y = self->static_center.y + damount;
			self->hover_region.y = self->hover_region.y + amount;
			self->draw_region.y = self->draw_region.y + amount;
			self->background_region.y = self->background_region.y + amount;
			break;
		}
	}
}

PlankDockItemDrawValue*
plank_dock_item_draw_value_construct (GType object_type)
{
	PlankDockItemDrawValue* self = NULL;
	self = (PlankDockItemDrawValue*) g_type_create_instance (object_type);
	return self;
}

PlankDockItemDrawValue*
plank_dock_item_draw_value_new (void)
{
	return plank_dock_item_draw_value_construct (PLANK_TYPE_DOCK_ITEM_DRAW_VALUE);
}

static void
plank_value_dock_item_draw_value_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plank_value_dock_item_draw_value_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plank_dock_item_draw_value_unref (value->data[0].v_pointer);
	}
}

static void
plank_value_dock_item_draw_value_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plank_dock_item_draw_value_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plank_value_dock_item_draw_value_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plank_value_dock_item_draw_value_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PlankDockItemDrawValue * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plank_dock_item_draw_value_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plank_value_dock_item_draw_value_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	PlankDockItemDrawValue ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plank_dock_item_draw_value_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plank_param_spec_dock_item_draw_value (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	PlankParamSpecDockItemDrawValue* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plank_value_get_dock_item_draw_value (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE), NULL);
	return value->data[0].v_pointer;
}

void
plank_value_set_dock_item_draw_value (GValue* value,
                                      gpointer v_object)
{
	PlankDockItemDrawValue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plank_dock_item_draw_value_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_dock_item_draw_value_unref (old);
	}
}

void
plank_value_take_dock_item_draw_value (GValue* value,
                                       gpointer v_object)
{
	PlankDockItemDrawValue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_dock_item_draw_value_unref (old);
	}
}

static void
plank_dock_item_draw_value_class_init (PlankDockItemDrawValueClass * klass,
                                       gpointer klass_data)
{
	plank_dock_item_draw_value_parent_class = g_type_class_peek_parent (klass);
	((PlankDockItemDrawValueClass *) klass)->finalize = plank_dock_item_draw_value_finalize;
}

static void
plank_dock_item_draw_value_instance_init (PlankDockItemDrawValue * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
plank_dock_item_draw_value_finalize (PlankDockItemDrawValue * obj)
{
	PlankDockItemDrawValue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_ITEM_DRAW_VALUE, PlankDockItemDrawValue);
	g_signal_handlers_destroy (self);
}

/**
 * Contains all positions and modifications to draw a dock-item on the dock
 */
static GType
plank_dock_item_draw_value_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plank_value_dock_item_draw_value_init, plank_value_dock_item_draw_value_free_value, plank_value_dock_item_draw_value_copy_value, plank_value_dock_item_draw_value_peek_pointer, "p", plank_value_dock_item_draw_value_collect_value, "p", plank_value_dock_item_draw_value_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockItemDrawValueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_item_draw_value_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockItemDrawValue), 0, (GInstanceInitFunc) plank_dock_item_draw_value_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plank_dock_item_draw_value_type_id;
	plank_dock_item_draw_value_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PlankDockItemDrawValue", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plank_dock_item_draw_value_type_id;
}

GType
plank_dock_item_draw_value_get_type (void)
{
	static volatile gsize plank_dock_item_draw_value_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_item_draw_value_type_id__once)) {
		GType plank_dock_item_draw_value_type_id;
		plank_dock_item_draw_value_type_id = plank_dock_item_draw_value_get_type_once ();
		g_once_init_leave (&plank_dock_item_draw_value_type_id__once, plank_dock_item_draw_value_type_id);
	}
	return plank_dock_item_draw_value_type_id__once;
}

gpointer
plank_dock_item_draw_value_ref (gpointer instance)
{
	PlankDockItemDrawValue * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plank_dock_item_draw_value_unref (gpointer instance)
{
	PlankDockItemDrawValue * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLANK_DOCK_ITEM_DRAW_VALUE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

