/* DockContainer.c generated by valac 0.56.17, the Vala compiler
 * generated from DockContainer.vala, do not modify */

/**/
/*  Copyright (C) 2011-2013 Robert Dyer, Rico Tzschichholz*/
/*                2014 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_CONTAINER_0_PROPERTY,
	PLANK_DOCK_CONTAINER_VISIBLE_ELEMENTS_PROPERTY,
	PLANK_DOCK_CONTAINER_ELEMENTS_PROPERTY,
	PLANK_DOCK_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* plank_dock_container_properties[PLANK_DOCK_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLANK_DOCK_CONTAINER_ELEMENTS_CHANGED_SIGNAL,
	PLANK_DOCK_CONTAINER_STATES_CHANGED_SIGNAL,
	PLANK_DOCK_CONTAINER_POSITIONS_CHANGED_SIGNAL,
	PLANK_DOCK_CONTAINER_NUM_SIGNALS
};
static guint plank_dock_container_signals[PLANK_DOCK_CONTAINER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer plank_dock_container_parent_class = NULL;
PlankPlaceholderDockItem* plank_dock_container_placeholder_item = NULL;

static void plank_dock_container_remove_without_signaling (PlankDockContainer* self,
                                                    PlankDockElement* element);
static void plank_dock_container_real_prepare (PlankDockContainer* self);
static void plank_dock_container_add_without_signaling (PlankDockContainer* self,
                                                 PlankDockElement* element);
static void plank_dock_container_real_update_visible_elements (PlankDockContainer* self);
static gboolean plank_dock_container_real_move_to (PlankDockContainer* self,
                                            PlankDockElement* move,
                                            PlankDockElement* target);
static void plank_dock_container_real_reset_buffers (PlankDockElement* base);
static gboolean plank_dock_container_real_replace (PlankDockContainer* self,
                                            PlankDockElement* new_element,
                                            PlankDockElement* old_element);
static void plank_dock_container_real_connect_element (PlankDockContainer* self,
                                                PlankDockElement* element);
static void plank_dock_container_real_disconnect_element (PlankDockContainer* self,
                                                   PlankDockElement* element);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * plank_dock_container_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void plank_dock_container_finalize (GObject * obj);
static GType plank_dock_container_get_type_once (void);
static void _vala_plank_dock_container_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);

/**
 * Creates a new container for dock elements.
 */
PlankDockContainer*
plank_dock_container_construct (GType object_type)
{
	PlankDockContainer * self = NULL;
	self = (PlankDockContainer*) g_object_new (object_type, NULL);
	return self;
}

/**
 * Do some special implementation specific preparation
 *
 * This is meant to called after the initial batch of items was added
 * and the provider is about to be added to the dock.
 */
static void
plank_dock_container_real_prepare (PlankDockContainer* self)
{
}

void
plank_dock_container_prepare (PlankDockContainer* self)
{
	PlankDockContainerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->prepare) {
		_klass_->prepare (self);
	}
}

/**
 * Adds a dock-element to the collection.
 *
 * @param element the dock-element to add
 * @param target an existing item where to put this new one at
 * @return whether adding the item was successful
 */
gboolean
plank_dock_container_add (PlankDockContainer* self,
                          PlankDockElement* element,
                          PlankDockElement* target)
{
	GeeArrayList* _tmp0_;
	PlankDockContainer* _tmp3_;
	PlankDockContainer* _tmp4_;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = self->internal_elements;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, element)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text (element);
		_tmp2_ = _tmp1_;
		g_critical ("DockContainer.vala:127: Element '%s' already exists in this DockContai" \
"ner.", _tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = plank_dock_element_get_Container (element);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = plank_dock_element_get_Text (element);
		_tmp6_ = _tmp5_;
		g_critical ("DockContainer.vala:132: Element '%s' should be removed from its old Do" \
"ckContainer first.", _tmp6_);
		result = FALSE;
		return result;
	}
	plank_dock_container_add_without_signaling (self, element);
	if (target != NULL) {
		PlankPlaceholderDockItem* _tmp8_;
		_tmp8_ = plank_dock_container_placeholder_item;
		_tmp7_ = target != G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, PLANK_TYPE_DOCK_ELEMENT, PlankDockElement);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		plank_dock_container_move_to (self, element, target);
	} else {
		plank_dock_container_update_visible_elements (self);
	}
	result = TRUE;
	return result;
}

/**
 * Prepends a dock-element to the collection.
 * So the dock-element will appear at the first position.
 *
 * @param element the dock-element to add
 */
void
plank_dock_container_prepend (PlankDockContainer* self,
                              PlankDockElement* element)
{
	GeeArrayList* _tmp0_;
	PlankDockContainer* _tmp3_;
	PlankDockContainer* _tmp4_;
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp7_;
	PlankDockElement* target = NULL;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp14_ = FALSE;
	PlankDockElement* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->internal_elements;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, element)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text (element);
		_tmp2_ = _tmp1_;
		g_critical ("DockContainer.vala:155: Element '%s' already exists in this DockContai" \
"ner.", _tmp2_);
		return;
	}
	_tmp3_ = plank_dock_element_get_Container (element);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = plank_dock_element_get_Text (element);
		_tmp6_ = _tmp5_;
		g_critical ("DockContainer.vala:160: Element '%s' should be removed from its old Do" \
"ckContainer first.", _tmp6_);
		return;
	}
	container = PLANK_IS_DOCK_CONTAINER (element) ? ((PlankDockContainer*) element) : NULL;
	_tmp7_ = container;
	if (_tmp7_ != NULL) {
		PlankDockContainer* _tmp8_;
		_tmp8_ = container;
		plank_dock_container_prepare (_tmp8_);
	}
	plank_dock_container_add_without_signaling (self, element);
	target = NULL;
	_tmp9_ = self->internal_elements;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 1) {
		GeeArrayList* _tmp12_;
		gpointer _tmp13_;
		_tmp12_ = self->internal_elements;
		_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
		_g_object_unref0 (target);
		target = (PlankDockElement*) _tmp13_;
	}
	_tmp15_ = target;
	if (_tmp15_ != NULL) {
		PlankDockElement* _tmp16_;
		_tmp16_ = target;
		_tmp14_ = _tmp16_ != element;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp17_ = self->internal_elements;
		_tmp18_ = self->internal_elements;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		plank_dock_container_move_element ((GeeList*) _tmp17_, _tmp20_ - 1, 0, NULL);
	}
	plank_dock_container_update_visible_elements (self);
	_g_object_unref0 (target);
}

/**
 * Adds a ordered list of dock-elements to the collection.
 *
 * @param elements the dock-elements to add
 * @return whether all elements were added successfully
 */
gboolean
plank_dock_container_add_all (PlankDockContainer* self,
                              GeeArrayList* elements)
{
	gboolean _result_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elements != NULL, FALSE);
	_result_ = TRUE;
	{
		GeeArrayList* _element_list = NULL;
		gint _element_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _element_index = 0;
		_element_list = elements;
		_tmp0_ = _element_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_element_size = _tmp2_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			GeeArrayList* _tmp7_;
			PlankDockElement* _tmp8_;
			PlankDockElement* _tmp12_;
			PlankDockContainer* _tmp13_;
			PlankDockContainer* _tmp14_;
			PlankDockElement* _tmp18_;
			_element_index = _element_index + 1;
			_tmp3_ = _element_index;
			_tmp4_ = _element_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _element_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _element_index);
			element = (PlankDockElement*) _tmp6_;
			_tmp7_ = self->internal_elements;
			_tmp8_ = element;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_)) {
				PlankDockElement* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp9_ = element;
				_tmp10_ = plank_dock_element_get_Text (_tmp9_);
				_tmp11_ = _tmp10_;
				g_critical ("DockContainer.vala:191: Element '%s' already exists in this DockContai" \
"ner.", _tmp11_);
				_result_ = FALSE;
				_g_object_unref0 (element);
				continue;
			}
			_tmp12_ = element;
			_tmp13_ = plank_dock_element_get_Container (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				PlankDockElement* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = element;
				_tmp16_ = plank_dock_element_get_Text (_tmp15_);
				_tmp17_ = _tmp16_;
				g_critical ("DockContainer.vala:197: Element '%s' should be removed from its old Do" \
"ckContainer first.", _tmp17_);
				_result_ = FALSE;
				_g_object_unref0 (element);
				continue;
			}
			_tmp18_ = element;
			plank_dock_container_add_without_signaling (self, _tmp18_);
			_g_object_unref0 (element);
		}
	}
	plank_dock_container_update_visible_elements (self);
	result = _result_;
	return result;
}

/**
 * Removes a dock-element from the collection.
 *
 * @param element the dock-element to remove
 * @return whether removing the element was successful
 */
gboolean
plank_dock_container_remove (PlankDockContainer* self,
                             PlankDockElement* element)
{
	GeeArrayList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = self->internal_elements;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, element)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text (element);
		_tmp2_ = _tmp1_;
		g_critical ("DockContainer.vala:219: Element '%s' does not exist in this DockContai" \
"ner.", _tmp2_);
		result = FALSE;
		return result;
	}
	plank_dock_container_remove_without_signaling (self, element);
	plank_dock_container_update_visible_elements (self);
	result = TRUE;
	return result;
}

/**
 * Removes all given dock-elements from the collection.
 *
 * @param elements the dock-elements to remove
 * @return whether removing the elements was successful
 */
gboolean
plank_dock_container_remove_all (PlankDockContainer* self,
                                 GeeArrayList* elements)
{
	gboolean _result_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (elements != NULL, FALSE);
	_result_ = TRUE;
	{
		GeeArrayList* _element_list = NULL;
		gint _element_size = 0;
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _element_index = 0;
		_element_list = elements;
		_tmp0_ = _element_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_element_size = _tmp2_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			PlankDockElement* element = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			GeeArrayList* _tmp7_;
			PlankDockElement* _tmp8_;
			PlankDockElement* _tmp12_;
			_element_index = _element_index + 1;
			_tmp3_ = _element_index;
			_tmp4_ = _element_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _element_list;
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _element_index);
			element = (PlankDockElement*) _tmp6_;
			_tmp7_ = self->internal_elements;
			_tmp8_ = element;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp7_, _tmp8_)) {
				PlankDockElement* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp9_ = element;
				_tmp10_ = plank_dock_element_get_Text (_tmp9_);
				_tmp11_ = _tmp10_;
				g_critical ("DockContainer.vala:242: Element '%s' does not exist in this DockContai" \
"ner.", _tmp11_);
				_result_ = FALSE;
				_g_object_unref0 (element);
				continue;
			}
			_tmp12_ = element;
			plank_dock_container_remove_without_signaling (self, _tmp12_);
			_g_object_unref0 (element);
		}
	}
	plank_dock_container_update_visible_elements (self);
	result = _result_;
	return result;
}

/**
 * Clears and therefore removes all dock-elements from the collection.
 *
 * @return whether removing the elements was successful
 */
gboolean
plank_dock_container_clear (PlankDockContainer* self)
{
	GeeHashSet* elements = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_hash_set_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	elements = _tmp0_;
	_tmp1_ = elements;
	_tmp2_ = self->internal_elements;
	gee_collection_add_all ((GeeCollection*) _tmp1_, (GeeCollection*) _tmp2_);
	{
		GeeIterator* _element_it = NULL;
		GeeHashSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = elements;
		_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp3_);
		_element_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			PlankDockElement* element = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			PlankDockElement* _tmp8_;
			PlankDockElement* _tmp9_;
			_tmp5_ = _element_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _element_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			element = (PlankDockElement*) _tmp7_;
			_tmp8_ = element;
			plank_dock_container_remove_without_signaling (self, _tmp8_);
			_tmp9_ = element;
			plank_dock_element_set_Container (_tmp9_, NULL);
			_g_object_unref0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp10_ = self->internal_elements;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	plank_dock_container_update_visible_elements (self);
	result = TRUE;
	_g_object_unref0 (elements);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_dock_container_real_update_visible_elements (PlankDockContainer* self)
{
	GeeArrayList* old_items = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* added_items = NULL;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* removed_items = NULL;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gboolean _tmp31_ = FALSE;
	GeeArrayList* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	plank_logger_verbose ("DockContainer.update_visible_elements ()", NULL);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	old_items = _tmp0_;
	_tmp1_ = old_items;
	_tmp2_ = self->visible_elements;
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp2_);
	_tmp3_ = self->visible_elements;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp4_;
		gint _item_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _item_index = 0;
		_tmp4_ = self->internal_elements;
		_item_list = _tmp4_;
		_tmp5_ = _item_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_item_size = _tmp7_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			PlankDockElement* item = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			PlankDockElement* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_item_index = _item_index + 1;
			_tmp8_ = _item_index;
			_tmp9_ = _item_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _item_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _item_index);
			item = (PlankDockElement*) _tmp11_;
			_tmp12_ = item;
			_tmp13_ = plank_dock_element_get_IsAttached (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				GeeArrayList* _tmp15_;
				PlankDockElement* _tmp16_;
				_tmp15_ = self->visible_elements;
				_tmp16_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			}
			_g_object_unref0 (item);
		}
	}
	_tmp17_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	added_items = _tmp17_;
	_tmp18_ = added_items;
	_tmp19_ = self->visible_elements;
	gee_array_list_add_all (_tmp18_, (GeeCollection*) _tmp19_);
	_tmp20_ = added_items;
	_tmp21_ = old_items;
	gee_collection_remove_all ((GeeCollection*) _tmp20_, (GeeCollection*) _tmp21_);
	_tmp22_ = old_items;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	removed_items = _tmp23_;
	_tmp24_ = removed_items;
	_tmp25_ = self->visible_elements;
	gee_collection_remove_all ((GeeCollection*) _tmp24_, (GeeCollection*) _tmp25_);
	_tmp26_ = self->visible_elements;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ <= 0) {
		GeeArrayList* _tmp29_;
		PlankPlaceholderDockItem* _tmp30_;
		_tmp29_ = self->visible_elements;
		_tmp30_ = plank_dock_container_placeholder_item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, (PlankDockElement*) _tmp30_);
	}
	_tmp32_ = added_items;
	_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ > 0) {
		_tmp31_ = TRUE;
	} else {
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		_tmp35_ = removed_items;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp31_ = _tmp37_ > 0;
	}
	if (_tmp31_) {
		GeeArrayList* _tmp38_;
		GeeArrayList* _tmp39_;
		_tmp38_ = added_items;
		_tmp39_ = removed_items;
		g_signal_emit (self, plank_dock_container_signals[PLANK_DOCK_CONTAINER_ELEMENTS_CHANGED_SIGNAL], 0, (GeeList*) _tmp38_, (GeeList*) _tmp39_);
	}
	_g_object_unref0 (removed_items);
	_g_object_unref0 (added_items);
	_g_object_unref0 (old_items);
}

void
plank_dock_container_update_visible_elements (PlankDockContainer* self)
{
	PlankDockContainerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->update_visible_elements) {
		_klass_->update_visible_elements (self);
	}
}

/**
 * Move an element to the position of another element.
 * This shifts all elements which are placed between these two elements.
 *
 * @param move the element to move
 * @param target the element of the new position
 * @return whether moving the element was successful
 */
static gboolean
plank_dock_container_real_move_to (PlankDockContainer* self,
                                   PlankDockElement* move,
                                   PlankDockElement* target)
{
	gint index_move = 0;
	gint index_target = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeArrayList* _tmp8_;
	gboolean result;
	g_return_val_if_fail (move != NULL, FALSE);
	g_return_val_if_fail (target != NULL, FALSE);
	if (move == target) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->internal_elements;
	index_move = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, move);
	if (index_move < 0) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text (move);
		_tmp2_ = _tmp1_;
		g_critical ("DockContainer.vala:318: Element '%s' does not exist in this DockContai" \
"ner.", _tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = self->internal_elements;
	index_target = gee_abstract_list_index_of ((GeeAbstractList*) _tmp3_, target);
	if (index_target < 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = plank_dock_element_get_Text (target);
		_tmp5_ = _tmp4_;
		g_critical ("DockContainer.vala:323: Element '%s' does not exist in this DockContai" \
"ner.", _tmp5_);
		result = FALSE;
		return result;
	}
	_tmp6_ = self->internal_elements;
	plank_dock_container_move_element ((GeeList*) _tmp6_, index_move, index_target, NULL);
	_tmp8_ = self->visible_elements;
	index_move = gee_abstract_list_index_of ((GeeAbstractList*) _tmp8_, move);
	if (index_move >= 0) {
		GeeArrayList* _tmp9_;
		_tmp9_ = self->visible_elements;
		index_target = gee_abstract_list_index_of ((GeeAbstractList*) _tmp9_, target);
		_tmp7_ = index_target >= 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GeeArrayList* moved_items = NULL;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		_tmp10_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, NULL, NULL, NULL, NULL, NULL);
		moved_items = _tmp10_;
		_tmp11_ = self->visible_elements;
		_tmp12_ = moved_items;
		plank_dock_container_move_element ((GeeList*) _tmp11_, index_move, index_target, (GeeList*) _tmp12_);
		_tmp13_ = moved_items;
		g_signal_emit (self, plank_dock_container_signals[PLANK_DOCK_CONTAINER_POSITIONS_CHANGED_SIGNAL], 0, (GeeList*) _tmp13_);
		_g_object_unref0 (moved_items);
	} else {
		plank_dock_container_update_visible_elements (self);
	}
	result = TRUE;
	return result;
}

gboolean
plank_dock_container_move_to (PlankDockContainer* self,
                              PlankDockElement* move,
                              PlankDockElement* target)
{
	PlankDockContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->move_to) {
		return _klass_->move_to (self, move, target);
	}
	return FALSE;
}

/**
 * Reset internal buffers of all elements.
 */
static void
plank_dock_container_real_reset_buffers (PlankDockElement* base)
{
	PlankDockContainer * self;
	self = (PlankDockContainer*) base;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = self->internal_elements;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			PlankDockElement* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			PlankDockElement* _tmp8_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (PlankDockElement*) _tmp7_;
			_tmp8_ = item;
			plank_dock_element_reset_buffers (_tmp8_);
			_g_object_unref0 (item);
		}
	}
}

static void
plank_dock_container_add_without_signaling (PlankDockContainer* self,
                                            PlankDockElement* element)
{
	gint64 add_time = 0LL;
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp0_;
	GeeArrayList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	add_time = g_get_monotonic_time ();
	container = PLANK_IS_DOCK_CONTAINER (element) ? ((PlankDockContainer*) element) : NULL;
	_tmp0_ = container;
	if (_tmp0_ != NULL) {
		PlankDockContainer* _tmp1_;
		_tmp1_ = container;
		plank_dock_container_prepare (_tmp1_);
		{
			GeeArrayList* _e_list = NULL;
			PlankDockContainer* _tmp2_;
			GeeArrayList* _tmp3_;
			GeeArrayList* _tmp4_;
			gint _e_size = 0;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _e_index = 0;
			_tmp2_ = container;
			_tmp3_ = plank_dock_container_get_Elements (_tmp2_);
			_tmp4_ = _tmp3_;
			_e_list = _tmp4_;
			_tmp5_ = _e_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_e_size = _tmp7_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				PlankDockElement* e = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				PlankDockElement* _tmp12_;
				_e_index = _e_index + 1;
				_tmp8_ = _e_index;
				_tmp9_ = _e_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _e_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _e_index);
				e = (PlankDockElement*) _tmp11_;
				_tmp12_ = e;
				plank_dock_element_set_AddTime (_tmp12_, add_time);
				_g_object_unref0 (e);
			}
		}
	}
	_tmp13_ = self->internal_elements;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, element);
	plank_dock_element_set_Container (element, self);
	plank_dock_element_set_AddTime (element, add_time);
	plank_dock_element_set_RemoveTime (element, (gint64) 0);
	plank_dock_container_connect_element (self, element);
}

/**
 * Replace an element with another element.
 *
 * @param new_element the new element
 * @param old_element the element to be replaced
 * @return whether replacing the element was successful
 */
static gboolean
plank_dock_container_real_replace (PlankDockContainer* self,
                                   PlankDockElement* new_element,
                                   PlankDockElement* old_element)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp3_;
	PlankDockContainer* _tmp6_;
	PlankDockContainer* _tmp7_;
	GeeArrayList* _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	GeeArrayList* _tmp15_;
	gboolean result;
	g_return_val_if_fail (new_element != NULL, FALSE);
	g_return_val_if_fail (old_element != NULL, FALSE);
	if (new_element == old_element) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->internal_elements;
	index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, old_element);
	if (index < 0) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = plank_dock_element_get_Text (old_element);
		_tmp2_ = _tmp1_;
		g_critical ("DockContainer.vala:384: Element '%s' does not exist in this DockContai" \
"ner.", _tmp2_);
		result = FALSE;
		return result;
	}
	_tmp3_ = self->internal_elements;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, new_element)) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = plank_dock_element_get_Text (new_element);
		_tmp5_ = _tmp4_;
		g_critical ("DockContainer.vala:389: Element '%s' already exists in this DockContai" \
"ner.", _tmp5_);
		result = FALSE;
		return result;
	}
	_tmp6_ = plank_dock_element_get_Container (new_element);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = plank_dock_element_get_Text (new_element);
		_tmp9_ = _tmp8_;
		g_critical ("DockContainer.vala:394: Element '%s' should be removed from its old Do" \
"ckContainer first.", _tmp9_);
		result = FALSE;
		return result;
	}
	plank_dock_container_disconnect_element (self, old_element);
	_tmp10_ = self->internal_elements;
	gee_abstract_list_set ((GeeAbstractList*) _tmp10_, index, new_element);
	plank_dock_element_set_Container (old_element, NULL);
	plank_dock_element_set_Container (new_element, self);
	_tmp11_ = plank_dock_element_get_AddTime (old_element);
	_tmp12_ = _tmp11_;
	plank_dock_element_set_AddTime (new_element, _tmp12_);
	_tmp13_ = plank_dock_element_get_RemoveTime (old_element);
	_tmp14_ = _tmp13_;
	plank_dock_element_set_RemoveTime (new_element, _tmp14_);
	plank_dock_container_connect_element (self, new_element);
	_tmp15_ = self->visible_elements;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp15_, old_element)) {
		plank_dock_container_update_visible_elements (self);
	}
	result = TRUE;
	return result;
}

gboolean
plank_dock_container_replace (PlankDockContainer* self,
                              PlankDockElement* new_element,
                              PlankDockElement* old_element)
{
	PlankDockContainerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->replace) {
		return _klass_->replace (self, new_element, old_element);
	}
	return FALSE;
}

static void
plank_dock_container_remove_without_signaling (PlankDockContainer* self,
                                               PlankDockElement* element)
{
	gint64 remove_time = 0LL;
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp0_;
	GeeArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	remove_time = g_get_monotonic_time ();
	container = PLANK_IS_DOCK_CONTAINER (element) ? ((PlankDockContainer*) element) : NULL;
	_tmp0_ = container;
	if (_tmp0_ != NULL) {
		{
			GeeArrayList* _e_list = NULL;
			PlankDockContainer* _tmp1_;
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
			gint _e_size = 0;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _e_index = 0;
			_tmp1_ = container;
			_tmp2_ = plank_dock_container_get_Elements (_tmp1_);
			_tmp3_ = _tmp2_;
			_e_list = _tmp3_;
			_tmp4_ = _e_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_e_size = _tmp6_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				PlankDockElement* e = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				PlankDockElement* _tmp11_;
				_e_index = _e_index + 1;
				_tmp7_ = _e_index;
				_tmp8_ = _e_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _e_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _e_index);
				e = (PlankDockElement*) _tmp10_;
				_tmp11_ = e;
				plank_dock_element_set_RemoveTime (_tmp11_, remove_time);
				_g_object_unref0 (e);
			}
		}
	}
	plank_dock_element_set_RemoveTime (element, remove_time);
	plank_dock_container_disconnect_element (self, element);
	_tmp12_ = self->internal_elements;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp12_, element);
	plank_dock_element_set_Container (element, NULL);
}

static void
plank_dock_container_real_connect_element (PlankDockContainer* self,
                                           PlankDockElement* element)
{
	g_critical ("Type `%s' does not implement abstract method `plank_dock_container_connect_element'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_dock_container_connect_element (PlankDockContainer* self,
                                      PlankDockElement* element)
{
	PlankDockContainerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->connect_element) {
		_klass_->connect_element (self, element);
	}
}

static void
plank_dock_container_real_disconnect_element (PlankDockContainer* self,
                                              PlankDockElement* element)
{
	g_critical ("Type `%s' does not implement abstract method `plank_dock_container_disconnect_element'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_dock_container_disconnect_element (PlankDockContainer* self,
                                         PlankDockElement* element)
{
	PlankDockContainerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_DOCK_CONTAINER_GET_CLASS (self);
	if (_klass_->disconnect_element) {
		_klass_->disconnect_element (self, element);
	}
}

void
plank_dock_container_move_element (GeeList* elements,
                                   gint from,
                                   gint to,
                                   GeeList* moved)
{
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	PlankDockElement* item = NULL;
	gpointer _tmp2_;
	PlankDockElement* _tmp17_;
	g_return_if_fail (elements != NULL);
	_vala_assert (from >= 0, "from >= 0");
	_vala_assert (to >= 0, "to >= 0");
	_vala_assert (from != to, "from != to");
	_tmp0_ = gee_collection_get_size ((GeeCollection*) elements);
	_tmp1_ = _tmp0_;
	size = _tmp1_;
	_vala_assert (from < size, "from < size");
	_vala_assert (to < size, "to < size");
	_tmp2_ = gee_list_get (elements, from);
	item = (PlankDockElement*) _tmp2_;
	if (from < to) {
		{
			gint i = 0;
			i = from;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gpointer _tmp5_;
					PlankDockElement* _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (!(i < to)) {
						break;
					}
					_tmp5_ = gee_list_get (elements, i + 1);
					_tmp6_ = (PlankDockElement*) _tmp5_;
					gee_list_set (elements, i, _tmp6_);
					_g_object_unref0 (_tmp6_);
					if (moved != NULL) {
						gpointer _tmp7_;
						PlankDockElement* _tmp8_;
						_tmp7_ = gee_list_get (elements, i);
						_tmp8_ = (PlankDockElement*) _tmp7_;
						gee_collection_add ((GeeCollection*) moved, _tmp8_);
						_g_object_unref0 (_tmp8_);
					}
				}
			}
		}
		if (moved != NULL) {
			PlankDockElement* _tmp9_;
			_tmp9_ = item;
			gee_collection_add ((GeeCollection*) moved, _tmp9_);
		}
	} else {
		if (moved != NULL) {
			PlankDockElement* _tmp10_;
			_tmp10_ = item;
			gee_collection_add ((GeeCollection*) moved, _tmp10_);
		}
		{
			gint i = 0;
			i = from;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gpointer _tmp13_;
					PlankDockElement* _tmp14_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ - 1;
					}
					_tmp11_ = FALSE;
					if (!(i > to)) {
						break;
					}
					_tmp13_ = gee_list_get (elements, i - 1);
					_tmp14_ = (PlankDockElement*) _tmp13_;
					gee_list_set (elements, i, _tmp14_);
					_g_object_unref0 (_tmp14_);
					if (moved != NULL) {
						gpointer _tmp15_;
						PlankDockElement* _tmp16_;
						_tmp15_ = gee_list_get (elements, i);
						_tmp16_ = (PlankDockElement*) _tmp15_;
						gee_collection_add ((GeeCollection*) moved, _tmp16_);
						_g_object_unref0 (_tmp16_);
					}
				}
			}
		}
	}
	_tmp17_ = item;
	gee_list_set (elements, to, _tmp17_);
	_g_object_unref0 (item);
}

GeeArrayList*
plank_dock_container_get_VisibleElements (PlankDockContainer* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->visible_elements;
	result = _tmp0_;
	return result;
}

GeeArrayList*
plank_dock_container_get_Elements (PlankDockContainer* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->internal_elements;
	result = _tmp0_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static GObject *
plank_dock_container_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockContainer * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	PlankPlaceholderDockItem* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_dock_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_CONTAINER, PlankDockContainer);
	_tmp0_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->visible_elements);
	self->visible_elements = _tmp0_;
	_tmp1_ = gee_array_list_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->internal_elements);
	self->internal_elements = _tmp1_;
	_tmp2_ = plank_dock_container_placeholder_item;
	plank_dock_container_connect_element (self, (PlankDockElement*) _tmp2_);
	return obj;
}

static void
plank_dock_container_class_init (PlankDockContainerClass * klass,
                                 gpointer klass_data)
{
	PlankPlaceholderDockItem* _tmp0_;
	plank_dock_container_parent_class = g_type_class_peek_parent (klass);
	((PlankDockContainerClass *) klass)->prepare = (void (*) (PlankDockContainer*)) plank_dock_container_real_prepare;
	((PlankDockContainerClass *) klass)->update_visible_elements = (void (*) (PlankDockContainer*)) plank_dock_container_real_update_visible_elements;
	((PlankDockContainerClass *) klass)->move_to = (gboolean (*) (PlankDockContainer*, PlankDockElement*, PlankDockElement*)) plank_dock_container_real_move_to;
	((PlankDockElementClass *) klass)->reset_buffers = (void (*) (PlankDockElement*)) plank_dock_container_real_reset_buffers;
	((PlankDockContainerClass *) klass)->replace = (gboolean (*) (PlankDockContainer*, PlankDockElement*, PlankDockElement*)) plank_dock_container_real_replace;
	((PlankDockContainerClass *) klass)->connect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_container_real_connect_element;
	((PlankDockContainerClass *) klass)->disconnect_element = (void (*) (PlankDockContainer*, PlankDockElement*)) plank_dock_container_real_disconnect_element;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_container_get_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dock_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_container_finalize;
	/**
	 * The ordered list of the visible dock elements.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTAINER_VISIBLE_ELEMENTS_PROPERTY, plank_dock_container_properties[PLANK_DOCK_CONTAINER_VISIBLE_ELEMENTS_PROPERTY] = g_param_spec_object ("VisibleElements", "VisibleElements", "VisibleElements", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The list of the all containing dock elements.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_CONTAINER_ELEMENTS_PROPERTY, plank_dock_container_properties[PLANK_DOCK_CONTAINER_ELEMENTS_PROPERTY] = g_param_spec_object ("Elements", "Elements", "Elements", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Triggered when the collection of elements has changed.
	 *
	 * @param added the list of added elements
	 * @param removed the list of removed elements
	 */
	plank_dock_container_signals[PLANK_DOCK_CONTAINER_ELEMENTS_CHANGED_SIGNAL] = g_signal_new ("elements-changed", PLANK_TYPE_DOCK_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_LIST, GEE_TYPE_LIST);
	/**
	 * Triggered when the state of an element changes.
	 */
	plank_dock_container_signals[PLANK_DOCK_CONTAINER_STATES_CHANGED_SIGNAL] = g_signal_new ("states-changed", PLANK_TYPE_DOCK_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Triggered anytime element-positions were changed.
	 *
	 * @param elements the list of moved elements
	 */
	plank_dock_container_signals[PLANK_DOCK_CONTAINER_POSITIONS_CHANGED_SIGNAL] = g_signal_new ("positions-changed", PLANK_TYPE_DOCK_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_LIST);
	_tmp0_ = plank_placeholder_dock_item_new ();
	_g_object_unref0 (plank_dock_container_placeholder_item);
	plank_dock_container_placeholder_item = _tmp0_;
}

static void
plank_dock_container_instance_init (PlankDockContainer * self,
                                    gpointer klass)
{
}

static void
plank_dock_container_finalize (GObject * obj)
{
	PlankDockContainer * self;
	PlankPlaceholderDockItem* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashSet* elements = NULL;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp12_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_CONTAINER, PlankDockContainer);
	_tmp0_ = plank_dock_container_placeholder_item;
	plank_dock_container_disconnect_element (self, (PlankDockElement*) _tmp0_);
	_tmp1_ = self->visible_elements;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp2_ = gee_hash_set_new (PLANK_TYPE_DOCK_ELEMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	elements = _tmp2_;
	_tmp3_ = elements;
	_tmp4_ = self->internal_elements;
	gee_collection_add_all ((GeeCollection*) _tmp3_, (GeeCollection*) _tmp4_);
	{
		GeeIterator* _element_it = NULL;
		GeeHashSet* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp5_ = elements;
		_tmp6_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp5_);
		_element_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			PlankDockElement* element = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			PlankDockElement* _tmp10_;
			PlankDockElement* _tmp11_;
			_tmp7_ = _element_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			element = (PlankDockElement*) _tmp9_;
			_tmp10_ = element;
			plank_dock_container_remove_without_signaling (self, _tmp10_);
			_tmp11_ = element;
			plank_dock_element_set_Container (_tmp11_, NULL);
			_g_object_unref0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp12_ = self->internal_elements;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
	_g_object_unref0 (elements);
	_g_object_unref0 (self->visible_elements);
	_g_object_unref0 (self->internal_elements);
	G_OBJECT_CLASS (plank_dock_container_parent_class)->finalize (obj);
}

/**
 * A container and controller class for managing dock elements on a dock.
 */
static GType
plank_dock_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockContainer), 0, (GInstanceInitFunc) plank_dock_container_instance_init, NULL };
	GType plank_dock_container_type_id;
	plank_dock_container_type_id = g_type_register_static (PLANK_TYPE_DOCK_ELEMENT, "PlankDockContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return plank_dock_container_type_id;
}

GType
plank_dock_container_get_type (void)
{
	static volatile gsize plank_dock_container_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_container_type_id__once)) {
		GType plank_dock_container_type_id;
		plank_dock_container_type_id = plank_dock_container_get_type_once ();
		g_once_init_leave (&plank_dock_container_type_id__once, plank_dock_container_type_id);
	}
	return plank_dock_container_type_id__once;
}

static void
_vala_plank_dock_container_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PlankDockContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_CONTAINER, PlankDockContainer);
	switch (property_id) {
		case PLANK_DOCK_CONTAINER_VISIBLE_ELEMENTS_PROPERTY:
		g_value_set_object (value, plank_dock_container_get_VisibleElements (self));
		break;
		case PLANK_DOCK_CONTAINER_ELEMENTS_PROPERTY:
		g_value_set_object (value, plank_dock_container_get_Elements (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

