/* DockPreferences.c generated by valac 0.56.17, the Vala compiler
 * generated from DockPreferences.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "plank-internal.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_PREFERENCES_0_PROPERTY,
	PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY,
	PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY,
	PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY,
	PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY,
	PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY,
	PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY,
	PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY,
	PLANK_DOCK_PREFERENCES_POSITION_PROPERTY,
	PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY,
	PLANK_DOCK_PREFERENCES_THEME_PROPERTY,
	PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY,
	PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY,
	PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY,
	PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY,
	PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY,
	PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY,
	PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY,
	PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY,
	PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY,
	PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY,
	PLANK_DOCK_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _PlankDockPreferencesPrivate {
	gboolean _CurrentWorkspaceOnly;
	gint _IconSize;
	PlankHideType _HideMode;
	guint _UnhideDelay;
	guint _HideDelay;
	gchar* _Monitor;
	gchar** _DockItems;
	gint _DockItems_length1;
	gint __DockItems_size_;
	GtkPositionType _Position;
	gint _Offset;
	gchar* _Theme;
	GtkAlign _Alignment;
	GtkAlign _ItemsAlignment;
	gboolean _LockItems;
	gboolean _PressureReveal;
	gboolean _PinnedOnly;
	gboolean _AutoPinning;
	gboolean _ShowDockItem;
	gboolean _ZoomEnabled;
	guint _ZoomPercent;
	gboolean _TooltipsEnabled;
};

static gint PlankDockPreferences_private_offset;
static gpointer plank_dock_preferences_parent_class = NULL;

static void plank_dock_preferences_real_verify (PlankSettings* base,
                                         const gchar* prop);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void plank_dock_preferences_finalize (GObject * obj);
static GType plank_dock_preferences_get_type_once (void);
static void _vala_plank_dock_preferences_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_plank_dock_preferences_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
plank_dock_preferences_get_instance_private (PlankDockPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockPreferences_private_offset);
}

/**
 * {@inheritDoc}
 */
PlankDockPreferences*
plank_dock_preferences_construct (GType object_type,
                                  const gchar* name)
{
	PlankDockPreferences * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strdup_printf ("/net/launchpad/plank/docks/%s/", name);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_create_settings ("net.launchpad.plank.dock.settings", _tmp1_);
	_tmp3_ = _tmp2_;
	self = (PlankDockPreferences*) g_object_new (object_type, "settings", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

PlankDockPreferences*
plank_dock_preferences_new (const gchar* name)
{
	return plank_dock_preferences_construct (PLANK_TYPE_DOCK_PREFERENCES, name);
}

/**
 * Increases the IconSize, if it is not already at its max.
 */
void
plank_dock_preferences_increase_icon_size (PlankDockPreferences* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_IconSize;
	if (_tmp0_ < (PLANK_DOCK_PREFERENCES_MAX_ICON_SIZE - 1)) {
		gint _tmp1_;
		_tmp1_ = self->priv->_IconSize;
		plank_dock_preferences_set_IconSize (self, _tmp1_ + 2);
	}
}

/**
 * Decreases the IconSize, if it is not already at its min.
 */
void
plank_dock_preferences_decrease_icon_size (PlankDockPreferences* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_IconSize;
	if (_tmp0_ > (PLANK_DOCK_PREFERENCES_MIN_ICON_SIZE + 1)) {
		gint _tmp1_;
		_tmp1_ = self->priv->_IconSize;
		plank_dock_preferences_set_IconSize (self, _tmp1_ - 2);
	}
}

/**
 * Return whether or not a dock is a horizontal dock.
 *
 * @return true if the dock's position indicates it is horizontal
 */
gboolean
plank_dock_preferences_is_horizontal_dock (PlankDockPreferences* self)
{
	gboolean _tmp0_ = FALSE;
	GtkPositionType _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_Position;
	if (_tmp1_ == GTK_POS_TOP) {
		_tmp0_ = TRUE;
	} else {
		GtkPositionType _tmp2_;
		_tmp2_ = self->priv->_Position;
		_tmp0_ = _tmp2_ == GTK_POS_BOTTOM;
	}
	result = _tmp0_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
plank_dock_preferences_real_verify (PlankSettings* base,
                                    const gchar* prop)
{
	PlankDockPreferences * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	self = (PlankDockPreferences*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("IconSize")))) {
		switch (0) {
			default:
			{
				gint _tmp3_;
				_tmp3_ = self->priv->_IconSize;
				if (_tmp3_ < PLANK_DOCK_PREFERENCES_MIN_ICON_SIZE) {
					plank_dock_preferences_set_IconSize (self, PLANK_DOCK_PREFERENCES_MIN_ICON_SIZE);
				} else {
					gint _tmp4_;
					_tmp4_ = self->priv->_IconSize;
					if (_tmp4_ > PLANK_DOCK_PREFERENCES_MAX_ICON_SIZE) {
						plank_dock_preferences_set_IconSize (self, PLANK_DOCK_PREFERENCES_MAX_ICON_SIZE);
					} else {
						gint _tmp5_;
						_tmp5_ = self->priv->_IconSize;
						if ((_tmp5_ % 2) == 1) {
							gint _tmp6_;
							_tmp6_ = self->priv->_IconSize;
							plank_dock_preferences_set_IconSize (self, _tmp6_ - 1);
						}
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Theme")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				_tmp7_ = self->priv->_Theme;
				if (g_strcmp0 (_tmp7_, "") == 0) {
					plank_dock_preferences_set_Theme (self, PLANK_THEME_DEFAULT_NAME);
				} else {
					const gchar* _tmp8_;
					_tmp8_ = self->priv->_Theme;
					if (string_contains (_tmp8_, "/")) {
						const gchar* _tmp9_;
						gchar* _tmp10_;
						gchar* _tmp11_;
						_tmp9_ = self->priv->_Theme;
						_tmp10_ = string_replace (_tmp9_, "/", "");
						_tmp11_ = _tmp10_;
						plank_dock_preferences_set_Theme (self, _tmp11_);
						_g_free0 (_tmp11_);
					}
				}
				break;
			}
		}
	}
}

gboolean
plank_dock_preferences_get_CurrentWorkspaceOnly (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_CurrentWorkspaceOnly;
	return result;
}

void
plank_dock_preferences_set_CurrentWorkspaceOnly (PlankDockPreferences* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_CurrentWorkspaceOnly (self);
	if (old_value != value) {
		self->priv->_CurrentWorkspaceOnly = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY]);
	}
}

gint
plank_dock_preferences_get_IconSize (PlankDockPreferences* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_IconSize;
	return result;
}

void
plank_dock_preferences_set_IconSize (PlankDockPreferences* self,
                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_IconSize (self);
	if (old_value != value) {
		self->priv->_IconSize = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY]);
	}
}

PlankHideType
plank_dock_preferences_get_HideMode (PlankDockPreferences* self)
{
	PlankHideType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_HideMode;
	return result;
}

void
plank_dock_preferences_set_HideMode (PlankDockPreferences* self,
                                     PlankHideType value)
{
	PlankHideType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_HideMode (self);
	if (old_value != value) {
		self->priv->_HideMode = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY]);
	}
}

guint
plank_dock_preferences_get_UnhideDelay (PlankDockPreferences* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_UnhideDelay;
	return result;
}

void
plank_dock_preferences_set_UnhideDelay (PlankDockPreferences* self,
                                        guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_UnhideDelay (self);
	if (old_value != value) {
		self->priv->_UnhideDelay = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY]);
	}
}

guint
plank_dock_preferences_get_HideDelay (PlankDockPreferences* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_HideDelay;
	return result;
}

void
plank_dock_preferences_set_HideDelay (PlankDockPreferences* self,
                                      guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_HideDelay (self);
	if (old_value != value) {
		self->priv->_HideDelay = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY]);
	}
}

const gchar*
plank_dock_preferences_get_Monitor (PlankDockPreferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Monitor;
	result = _tmp0_;
	return result;
}

void
plank_dock_preferences_set_Monitor (PlankDockPreferences* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_Monitor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_Monitor);
		self->priv->_Monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY]);
	}
}

gchar**
plank_dock_preferences_get_DockItems (PlankDockPreferences* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_DockItems;
	_tmp0__length1 = self->priv->_DockItems_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
plank_dock_preferences_set_DockItems (PlankDockPreferences* self,
                                      gchar** value,
                                      gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_DockItems (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_DockItems = (_vala_array_free (self->priv->_DockItems, self->priv->_DockItems_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_DockItems = _tmp0_;
		self->priv->_DockItems_length1 = _tmp0__length1;
		self->priv->__DockItems_size_ = self->priv->_DockItems_length1;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY]);
	}
}

GtkPositionType
plank_dock_preferences_get_Position (PlankDockPreferences* self)
{
	GtkPositionType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Position;
	return result;
}

void
plank_dock_preferences_set_Position (PlankDockPreferences* self,
                                     GtkPositionType value)
{
	GtkPositionType old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_Position (self);
	if (old_value != value) {
		self->priv->_Position = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_POSITION_PROPERTY]);
	}
}

gint
plank_dock_preferences_get_Offset (PlankDockPreferences* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Offset;
	return result;
}

void
plank_dock_preferences_set_Offset (PlankDockPreferences* self,
                                   gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_Offset (self);
	if (old_value != value) {
		self->priv->_Offset = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY]);
	}
}

const gchar*
plank_dock_preferences_get_Theme (PlankDockPreferences* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Theme;
	result = _tmp0_;
	return result;
}

void
plank_dock_preferences_set_Theme (PlankDockPreferences* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_Theme (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_Theme);
		self->priv->_Theme = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_THEME_PROPERTY]);
	}
}

GtkAlign
plank_dock_preferences_get_Alignment (PlankDockPreferences* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Alignment;
	return result;
}

void
plank_dock_preferences_set_Alignment (PlankDockPreferences* self,
                                      GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_Alignment (self);
	if (old_value != value) {
		self->priv->_Alignment = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY]);
	}
}

GtkAlign
plank_dock_preferences_get_ItemsAlignment (PlankDockPreferences* self)
{
	GtkAlign result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_ItemsAlignment;
	return result;
}

void
plank_dock_preferences_set_ItemsAlignment (PlankDockPreferences* self,
                                           GtkAlign value)
{
	GtkAlign old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_ItemsAlignment (self);
	if (old_value != value) {
		self->priv->_ItemsAlignment = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_LockItems (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_LockItems;
	return result;
}

void
plank_dock_preferences_set_LockItems (PlankDockPreferences* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_LockItems (self);
	if (old_value != value) {
		self->priv->_LockItems = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_PressureReveal (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_PressureReveal;
	return result;
}

void
plank_dock_preferences_set_PressureReveal (PlankDockPreferences* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_PressureReveal (self);
	if (old_value != value) {
		self->priv->_PressureReveal = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_PinnedOnly (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_PinnedOnly;
	return result;
}

void
plank_dock_preferences_set_PinnedOnly (PlankDockPreferences* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_PinnedOnly (self);
	if (old_value != value) {
		self->priv->_PinnedOnly = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_AutoPinning (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_AutoPinning;
	return result;
}

void
plank_dock_preferences_set_AutoPinning (PlankDockPreferences* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_AutoPinning (self);
	if (old_value != value) {
		self->priv->_AutoPinning = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_ShowDockItem (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ShowDockItem;
	return result;
}

void
plank_dock_preferences_set_ShowDockItem (PlankDockPreferences* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_ShowDockItem (self);
	if (old_value != value) {
		self->priv->_ShowDockItem = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_ZoomEnabled (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ZoomEnabled;
	return result;
}

void
plank_dock_preferences_set_ZoomEnabled (PlankDockPreferences* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_ZoomEnabled (self);
	if (old_value != value) {
		self->priv->_ZoomEnabled = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY]);
	}
}

guint
plank_dock_preferences_get_ZoomPercent (PlankDockPreferences* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_ZoomPercent;
	return result;
}

void
plank_dock_preferences_set_ZoomPercent (PlankDockPreferences* self,
                                        guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_ZoomPercent (self);
	if (old_value != value) {
		self->priv->_ZoomPercent = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY]);
	}
}

gboolean
plank_dock_preferences_get_TooltipsEnabled (PlankDockPreferences* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_TooltipsEnabled;
	return result;
}

void
plank_dock_preferences_set_TooltipsEnabled (PlankDockPreferences* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_preferences_get_TooltipsEnabled (self);
	if (old_value != value) {
		self->priv->_TooltipsEnabled = value;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY]);
	}
}

static void
plank_dock_preferences_class_init (PlankDockPreferencesClass * klass,
                                   gpointer klass_data)
{
	plank_dock_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockPreferences_private_offset);
	((PlankSettingsClass *) klass)->verify = (void (*) (PlankSettings*, const gchar*)) plank_dock_preferences_real_verify;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_preferences_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_preferences_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_preferences_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY] = g_param_spec_boolean ("CurrentWorkspaceOnly", "current-workspace-only", "Whether to show only windows of the current workspace.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY] = g_param_spec_int ("IconSize", "icon-size", "The size of dock icons (in pixels).", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY] = g_param_spec_enum ("HideMode", "hide-mode", "If 0, the dock won't hide.  If 1, the dock intelligently hides.  If 2, the dock auto-hides. If 3, the dock dodges active maximized windows. If 4, the dock dodges every window.", PLANK_TYPE_HIDE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY] = g_param_spec_uint ("UnhideDelay", "unhide-delay", "Time (in ms) to wait before unhiding the dock.", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY] = g_param_spec_uint ("HideDelay", "hide-delay", "Time (in ms) to wait before hiding the dock.", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY] = g_param_spec_string ("Monitor", "monitor", "The plug-name of the monitor for the dock to show on (e.g. DVI-I-1, HDMI1, LVDS1). Leave this empty to keep on the primary monitor.", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY] = g_param_spec_boxed ("DockItems", "dock-items", "Array of the dockitem-files on this dock. DO NOT MODIFY", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_POSITION_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_POSITION_PROPERTY] = g_param_spec_enum ("Position", "position", "The position for the dock on the monitor.  If 0, left.  If 1, right.  If 2, top.  If 3, bottom.", gtk_position_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY] = g_param_spec_int ("Offset", "offset", "The dock's position offset from center (in percent).", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_THEME_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_THEME_PROPERTY] = g_param_spec_string ("Theme", "theme", "The name of the dock's theme to use.", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY] = g_param_spec_enum ("Alignment", "alignment", "The alignment for the dock on the monitor's edge.  If 0, panel-mode.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY] = g_param_spec_enum ("ItemsAlignment", "items-alignment", "The alignment of the items in this dock if panel-mode is used.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", gtk_align_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY] = g_param_spec_boolean ("LockItems", "lock-items", "Whether to prevent drag'n'drop actions and lock items on the dock.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY] = g_param_spec_boolean ("PressureReveal", "pressure-reveal", "Whether to use pressure-based revealing of the dock if the support is available.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY] = g_param_spec_boolean ("PinnedOnly", "pinned-only", "Whether to show only pinned applications. Useful for running more then one dock.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY] = g_param_spec_boolean ("AutoPinning", "auto-pinning", "Whether to automatically pin an application if it seems useful to do.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY] = g_param_spec_boolean ("ShowDockItem", "show-dock-item", "Whether to show the item for the dock itself.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY] = g_param_spec_boolean ("ZoomEnabled", "zoom-enabled", "Whether the dock will zoom when hovered.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY] = g_param_spec_uint ("ZoomPercent", "zoom-percent", "The dock's icon-zoom (in percent).", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY, plank_dock_preferences_properties[PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY] = g_param_spec_boolean ("TooltipsEnabled", "tooltips-enabled", "Whether to show tooltips when items are hovered.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
plank_dock_preferences_instance_init (PlankDockPreferences * self,
                                      gpointer klass)
{
	self->priv = plank_dock_preferences_get_instance_private (self);
}

static void
plank_dock_preferences_finalize (GObject * obj)
{
	PlankDockPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_PREFERENCES, PlankDockPreferences);
	_g_free0 (self->priv->_Monitor);
	self->priv->_DockItems = (_vala_array_free (self->priv->_DockItems, self->priv->_DockItems_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_Theme);
	G_OBJECT_CLASS (plank_dock_preferences_parent_class)->finalize (obj);
}

/**
 * Contains all preferences for docks.
 */
static GType
plank_dock_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockPreferences), 0, (GInstanceInitFunc) plank_dock_preferences_instance_init, NULL };
	GType plank_dock_preferences_type_id;
	plank_dock_preferences_type_id = g_type_register_static (PLANK_TYPE_SETTINGS, "PlankDockPreferences", &g_define_type_info, 0);
	PlankDockPreferences_private_offset = g_type_add_instance_private (plank_dock_preferences_type_id, sizeof (PlankDockPreferencesPrivate));
	return plank_dock_preferences_type_id;
}

GType
plank_dock_preferences_get_type (void)
{
	static volatile gsize plank_dock_preferences_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_preferences_type_id__once)) {
		GType plank_dock_preferences_type_id;
		plank_dock_preferences_type_id = plank_dock_preferences_get_type_once ();
		g_once_init_leave (&plank_dock_preferences_type_id__once, plank_dock_preferences_type_id);
	}
	return plank_dock_preferences_type_id__once;
}

static void
_vala_plank_dock_preferences_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	PlankDockPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_PREFERENCES, PlankDockPreferences);
	switch (property_id) {
		case PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_CurrentWorkspaceOnly (self));
		break;
		case PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY:
		g_value_set_int (value, plank_dock_preferences_get_IconSize (self));
		break;
		case PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY:
		g_value_set_enum (value, plank_dock_preferences_get_HideMode (self));
		break;
		case PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY:
		g_value_set_uint (value, plank_dock_preferences_get_UnhideDelay (self));
		break;
		case PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY:
		g_value_set_uint (value, plank_dock_preferences_get_HideDelay (self));
		break;
		case PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY:
		g_value_set_string (value, plank_dock_preferences_get_Monitor (self));
		break;
		case PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, plank_dock_preferences_get_DockItems (self, &length));
		}
		break;
		case PLANK_DOCK_PREFERENCES_POSITION_PROPERTY:
		g_value_set_enum (value, plank_dock_preferences_get_Position (self));
		break;
		case PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY:
		g_value_set_int (value, plank_dock_preferences_get_Offset (self));
		break;
		case PLANK_DOCK_PREFERENCES_THEME_PROPERTY:
		g_value_set_string (value, plank_dock_preferences_get_Theme (self));
		break;
		case PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, plank_dock_preferences_get_Alignment (self));
		break;
		case PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY:
		g_value_set_enum (value, plank_dock_preferences_get_ItemsAlignment (self));
		break;
		case PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_LockItems (self));
		break;
		case PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_PressureReveal (self));
		break;
		case PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_PinnedOnly (self));
		break;
		case PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_AutoPinning (self));
		break;
		case PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_ShowDockItem (self));
		break;
		case PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_ZoomEnabled (self));
		break;
		case PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY:
		g_value_set_uint (value, plank_dock_preferences_get_ZoomPercent (self));
		break;
		case PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY:
		g_value_set_boolean (value, plank_dock_preferences_get_TooltipsEnabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_preferences_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	PlankDockPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_PREFERENCES, PlankDockPreferences);
	switch (property_id) {
		case PLANK_DOCK_PREFERENCES_CURRENT_WORKSPACE_ONLY_PROPERTY:
		plank_dock_preferences_set_CurrentWorkspaceOnly (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_ICON_SIZE_PROPERTY:
		plank_dock_preferences_set_IconSize (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_PREFERENCES_HIDE_MODE_PROPERTY:
		plank_dock_preferences_set_HideMode (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_PREFERENCES_UNHIDE_DELAY_PROPERTY:
		plank_dock_preferences_set_UnhideDelay (self, g_value_get_uint (value));
		break;
		case PLANK_DOCK_PREFERENCES_HIDE_DELAY_PROPERTY:
		plank_dock_preferences_set_HideDelay (self, g_value_get_uint (value));
		break;
		case PLANK_DOCK_PREFERENCES_MONITOR_PROPERTY:
		plank_dock_preferences_set_Monitor (self, g_value_get_string (value));
		break;
		case PLANK_DOCK_PREFERENCES_DOCK_ITEMS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			plank_dock_preferences_set_DockItems (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case PLANK_DOCK_PREFERENCES_POSITION_PROPERTY:
		plank_dock_preferences_set_Position (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_PREFERENCES_OFFSET_PROPERTY:
		plank_dock_preferences_set_Offset (self, g_value_get_int (value));
		break;
		case PLANK_DOCK_PREFERENCES_THEME_PROPERTY:
		plank_dock_preferences_set_Theme (self, g_value_get_string (value));
		break;
		case PLANK_DOCK_PREFERENCES_ALIGNMENT_PROPERTY:
		plank_dock_preferences_set_Alignment (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_PREFERENCES_ITEMS_ALIGNMENT_PROPERTY:
		plank_dock_preferences_set_ItemsAlignment (self, g_value_get_enum (value));
		break;
		case PLANK_DOCK_PREFERENCES_LOCK_ITEMS_PROPERTY:
		plank_dock_preferences_set_LockItems (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_PRESSURE_REVEAL_PROPERTY:
		plank_dock_preferences_set_PressureReveal (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_PINNED_ONLY_PROPERTY:
		plank_dock_preferences_set_PinnedOnly (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_AUTO_PINNING_PROPERTY:
		plank_dock_preferences_set_AutoPinning (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_SHOW_DOCK_ITEM_PROPERTY:
		plank_dock_preferences_set_ShowDockItem (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_ZOOM_ENABLED_PROPERTY:
		plank_dock_preferences_set_ZoomEnabled (self, g_value_get_boolean (value));
		break;
		case PLANK_DOCK_PREFERENCES_ZOOM_PERCENT_PROPERTY:
		plank_dock_preferences_set_ZoomPercent (self, g_value_get_uint (value));
		break;
		case PLANK_DOCK_PREFERENCES_TOOLTIPS_ENABLED_PROPERTY:
		plank_dock_preferences_set_TooltipsEnabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

