/* screen-recorder-factory.c generated by valac 0.56.17, the Vala compiler
 * generated from screen-recorder-factory.vala, do not modify */

/*
Peek Copyright (c) 2017-2020 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PeekRecordingParamSpecScreenRecorderFactory PeekRecordingParamSpecScreenRecorderFactory;

struct _PeekRecordingParamSpecScreenRecorderFactory {
	GParamSpec parent_instance;
};

static gpointer peek_recording_screen_recorder_factory_parent_class = NULL;

static void peek_recording_screen_recorder_factory_finalize (PeekRecordingScreenRecorderFactory * obj);
static GType peek_recording_screen_recorder_factory_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

PeekRecordingScreenRecorder*
peek_recording_screen_recorder_factory_create_default_screen_recorder (GError** error)
{
	gchar* recorder = NULL;
	gboolean _tmp0_ = FALSE;
	FILE* _tmp5_;
	const gchar* _tmp6_;
	PeekRecordingScreenRecorder* _tmp7_ = NULL;
	const gchar* _tmp8_;
	PeekRecordingScreenRecorder* _tmp9_;
	PeekRecordingScreenRecorder* _tmp10_;
	GError* _inner_error0_ = NULL;
	PeekRecordingScreenRecorder* result;
	_tmp0_ = peek_recording_gnome_shell_dbus_recorder_is_available (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (recorder);
			return NULL;
		} else {
			_g_free0 (recorder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gnome-shell");
		_g_free0 (recorder);
		recorder = _tmp1_;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = peek_recording_ffmpeg_screen_recorder_is_available (&_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (recorder);
				return NULL;
			} else {
				_g_free0 (recorder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		if (_tmp2_) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ffmpeg");
			_g_free0 (recorder);
			recorder = _tmp3_;
		} else {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_NO_SUITABLE_SCREEN_RECORDER, _ ("Peek requires FFmpeg or running GNOME Shell session."));
			_inner_error0_ = _tmp4_;
			if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (recorder);
				return NULL;
			} else {
				_g_free0 (recorder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp5_ = stdout;
	_tmp6_ = recorder;
	fprintf (_tmp5_, "Using screen recorder backend %s\n", _tmp6_);
	_tmp8_ = recorder;
	_tmp9_ = peek_recording_screen_recorder_factory_create_screen_recorder (_tmp8_, &_inner_error0_);
	_tmp7_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (recorder);
			return NULL;
		} else {
			_g_free0 (recorder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = _tmp7_;
	_tmp7_ = NULL;
	result = _tmp10_;
	_g_object_unref0 (_tmp7_);
	_g_free0 (recorder);
	return result;
}

PeekRecordingScreenRecorder*
peek_recording_screen_recorder_factory_create_screen_recorder (const gchar* name,
                                                               GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GError* _inner_error0_ = NULL;
	PeekRecordingScreenRecorder* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("gnome-shell")))) {
		switch (0) {
			default:
			{
				{
					PeekRecordingGnomeShellDbusRecorder* _tmp3_ = NULL;
					PeekRecordingGnomeShellDbusRecorder* _tmp4_;
					PeekRecordingGnomeShellDbusRecorder* _tmp5_;
					_tmp4_ = peek_recording_gnome_shell_dbus_recorder_new (&_inner_error0_);
					_tmp3_ = _tmp4_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_IO_ERROR) {
							goto __catch0_g_io_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp5_ = _tmp3_;
					_tmp3_ = NULL;
					result = (PeekRecordingScreenRecorder*) _tmp5_;
					_g_object_unref0 (_tmp3_);
					return result;
				}
				goto __finally0;
				__catch0_g_io_error:
				{
					GError* e = NULL;
					GError* _tmp6_;
					const gchar* _tmp7_;
					GError* _tmp8_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp6_ = e;
					_tmp7_ = _tmp6_->message;
					_tmp8_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_SCREEN_RECORDER_ERROR, _tmp7_);
					_inner_error0_ = _tmp8_;
					_g_error_free0 (e);
					goto __finally0;
				}
				__finally0:
				if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("ffmpeg")))) {
		switch (0) {
			default:
			{
				gboolean _tmp9_ = FALSE;
				PeekRecordingFfmpegScreenRecorder* _tmp11_;
				_tmp9_ = peek_recording_ffmpeg_screen_recorder_is_available (&_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				if (!_tmp9_) {
					GError* _tmp10_;
					_tmp10_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_SCREEN_RECORDER_ERROR, _ ("FFmpeg executable not found."));
					_inner_error0_ = _tmp10_;
					if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp11_ = peek_recording_ffmpeg_screen_recorder_new ();
				result = (PeekRecordingScreenRecorder*) _tmp11_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				gchar* _tmp13_;
				GError* _tmp14_;
				GError* _tmp15_;
				_tmp12_ = g_strconcat ("Unknown screen recorder ", name, NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_error_new_literal (PEEK_PEEK_ERROR, PEEK_PEEK_ERROR_UNKNOWN_SCREEN_RECORDER, _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				_inner_error0_ = _tmp15_;
				if (_inner_error0_->domain == PEEK_PEEK_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return NULL;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
}

PeekRecordingScreenRecorderFactory*
peek_recording_screen_recorder_factory_construct (GType object_type)
{
	PeekRecordingScreenRecorderFactory* self = NULL;
	self = (PeekRecordingScreenRecorderFactory*) g_type_create_instance (object_type);
	return self;
}

PeekRecordingScreenRecorderFactory*
peek_recording_screen_recorder_factory_new (void)
{
	return peek_recording_screen_recorder_factory_construct (PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY);
}

static void
peek_recording_value_screen_recorder_factory_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
peek_recording_value_screen_recorder_factory_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		peek_recording_screen_recorder_factory_unref (value->data[0].v_pointer);
	}
}

static void
peek_recording_value_screen_recorder_factory_copy_value (const GValue* src_value,
                                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = peek_recording_screen_recorder_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
peek_recording_value_screen_recorder_factory_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
peek_recording_value_screen_recorder_factory_collect_value (GValue* value,
                                                            guint n_collect_values,
                                                            GTypeCValue* collect_values,
                                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PeekRecordingScreenRecorderFactory * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = peek_recording_screen_recorder_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
peek_recording_value_screen_recorder_factory_lcopy_value (const GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	PeekRecordingScreenRecorderFactory ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = peek_recording_screen_recorder_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
peek_recording_param_spec_screen_recorder_factory (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags)
{
	PeekRecordingParamSpecScreenRecorderFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
peek_recording_value_get_screen_recorder_factory (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY), NULL);
	return value->data[0].v_pointer;
}

void
peek_recording_value_set_screen_recorder_factory (GValue* value,
                                                  gpointer v_object)
{
	PeekRecordingScreenRecorderFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		peek_recording_screen_recorder_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_recording_screen_recorder_factory_unref (old);
	}
}

void
peek_recording_value_take_screen_recorder_factory (GValue* value,
                                                   gpointer v_object)
{
	PeekRecordingScreenRecorderFactory * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		peek_recording_screen_recorder_factory_unref (old);
	}
}

static void
peek_recording_screen_recorder_factory_class_init (PeekRecordingScreenRecorderFactoryClass * klass,
                                                   gpointer klass_data)
{
	peek_recording_screen_recorder_factory_parent_class = g_type_class_peek_parent (klass);
	((PeekRecordingScreenRecorderFactoryClass *) klass)->finalize = peek_recording_screen_recorder_factory_finalize;
}

static void
peek_recording_screen_recorder_factory_instance_init (PeekRecordingScreenRecorderFactory * self,
                                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
peek_recording_screen_recorder_factory_finalize (PeekRecordingScreenRecorderFactory * obj)
{
	PeekRecordingScreenRecorderFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_RECORDING_TYPE_SCREEN_RECORDER_FACTORY, PeekRecordingScreenRecorderFactory);
	g_signal_handlers_destroy (self);
}

static GType
peek_recording_screen_recorder_factory_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { peek_recording_value_screen_recorder_factory_init, peek_recording_value_screen_recorder_factory_free_value, peek_recording_value_screen_recorder_factory_copy_value, peek_recording_value_screen_recorder_factory_peek_pointer, "p", peek_recording_value_screen_recorder_factory_collect_value, "p", peek_recording_value_screen_recorder_factory_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PeekRecordingScreenRecorderFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_recording_screen_recorder_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekRecordingScreenRecorderFactory), 0, (GInstanceInitFunc) peek_recording_screen_recorder_factory_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType peek_recording_screen_recorder_factory_type_id;
	peek_recording_screen_recorder_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PeekRecordingScreenRecorderFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return peek_recording_screen_recorder_factory_type_id;
}

GType
peek_recording_screen_recorder_factory_get_type (void)
{
	static volatile gsize peek_recording_screen_recorder_factory_type_id__once = 0;
	if (g_once_init_enter (&peek_recording_screen_recorder_factory_type_id__once)) {
		GType peek_recording_screen_recorder_factory_type_id;
		peek_recording_screen_recorder_factory_type_id = peek_recording_screen_recorder_factory_get_type_once ();
		g_once_init_leave (&peek_recording_screen_recorder_factory_type_id__once, peek_recording_screen_recorder_factory_type_id);
	}
	return peek_recording_screen_recorder_factory_type_id__once;
}

gpointer
peek_recording_screen_recorder_factory_ref (gpointer instance)
{
	PeekRecordingScreenRecorderFactory * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
peek_recording_screen_recorder_factory_unref (gpointer instance)
{
	PeekRecordingScreenRecorderFactory * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PEEK_RECORDING_SCREEN_RECORDER_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

