/* ffmpeg.c generated by valac 0.56.17, the Vala compiler
 * generated from ffmpeg.vala, do not modify */

/*
Peek Copyright (c) 2015-2018 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include "../../application.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN gboolean peek_recording_ffmpeg_has_10bit_libx264 (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
peek_recording_ffmpeg_add_output_parameters (GArray* args,
                                             PeekRecordingRecordingConfig* config,
                                             gchar** extension)
{
	gchar* _vala_extension = NULL;
	PeekOutputFormat _tmp0_;
	PeekOutputFormat _tmp1_;
	gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_;
	g_return_if_fail (args != NULL);
	g_return_if_fail (config != NULL);
	_tmp0_ = peek_recording_recording_config_get_output_format (config);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == PEEK_OUTPUT_FORMAT_WEBM) {
		PeekOutputFormat _tmp2_;
		PeekOutputFormat _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp2_ = peek_recording_recording_config_get_output_format (config);
		_tmp3_ = _tmp2_;
		_tmp4_ = peek_utils_get_file_extension_for_format (_tmp3_);
		_g_free0 (_vala_extension);
		_vala_extension = _tmp4_;
		_tmp5_ = g_strdup ("-codec:v");
		g_array_append_val (args, _tmp5_);
		_tmp6_ = g_strdup ("libvpx-vp9");
		g_array_append_val (args, _tmp6_);
		_tmp7_ = g_strdup ("-qmin");
		g_array_append_val (args, _tmp7_);
		_tmp8_ = g_strdup ("10");
		g_array_append_val (args, _tmp8_);
		_tmp9_ = g_strdup ("-qmax");
		g_array_append_val (args, _tmp9_);
		_tmp10_ = g_strdup ("50");
		g_array_append_val (args, _tmp10_);
		_tmp11_ = g_strdup ("-crf");
		g_array_append_val (args, _tmp11_);
		_tmp12_ = g_strdup ("13");
		g_array_append_val (args, _tmp12_);
		_tmp13_ = g_strdup ("-b:v");
		g_array_append_val (args, _tmp13_);
		_tmp14_ = g_strdup ("1M");
		g_array_append_val (args, _tmp14_);
		_tmp15_ = g_strdup ("-pix_fmt");
		g_array_append_val (args, _tmp15_);
		_tmp16_ = g_strdup ("yuv420p");
		g_array_append_val (args, _tmp16_);
	} else {
		PeekOutputFormat _tmp17_;
		PeekOutputFormat _tmp18_;
		_tmp17_ = peek_recording_recording_config_get_output_format (config);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == PEEK_OUTPUT_FORMAT_MP4) {
			PeekOutputFormat _tmp19_;
			PeekOutputFormat _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp19_ = peek_recording_recording_config_get_output_format (config);
			_tmp20_ = _tmp19_;
			_tmp21_ = peek_utils_get_file_extension_for_format (_tmp20_);
			_g_free0 (_vala_extension);
			_vala_extension = _tmp21_;
			_tmp22_ = g_strdup ("-codec:v");
			g_array_append_val (args, _tmp22_);
			_tmp23_ = g_strdup ("libx264");
			g_array_append_val (args, _tmp23_);
			_tmp24_ = g_strdup ("-preset:v");
			g_array_append_val (args, _tmp24_);
			_tmp25_ = g_strdup ("fast");
			g_array_append_val (args, _tmp25_);
			if (!peek_recording_ffmpeg_has_10bit_libx264 ()) {
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp26_ = g_strdup ("-profile:v");
				g_array_append_val (args, _tmp26_);
				_tmp27_ = g_strdup ("baseline");
				g_array_append_val (args, _tmp27_);
			} else {
				FILE* _tmp28_;
				_tmp28_ = stderr;
				fprintf (_tmp28_, "Warning: libx264 compiled with 10bit support, baseline profile not ava" \
"ilable. The recorded MP4 might not be playable on all devices.\n");
			}
			_tmp29_ = g_strdup ("-pix_fmt");
			g_array_append_val (args, _tmp29_);
			_tmp30_ = g_strdup ("yuv420p");
			g_array_append_val (args, _tmp30_);
		} else {
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp31_ = g_strdup ("webm");
			_g_free0 (_vala_extension);
			_vala_extension = _tmp31_;
			_tmp32_ = g_strdup ("-codec:v");
			g_array_append_val (args, _tmp32_);
			_tmp33_ = g_strdup ("libvpx-vp9");
			g_array_append_val (args, _tmp33_);
			_tmp34_ = g_strdup ("-lossless");
			g_array_append_val (args, _tmp34_);
			_tmp35_ = g_strdup ("1");
			g_array_append_val (args, _tmp35_);
		}
	}
	_tmp36_ = g_strdup ("-r");
	g_array_append_val (args, _tmp36_);
	_tmp37_ = peek_recording_recording_config_get_framerate (config);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("%i", _tmp38_);
	g_array_append_val (args, _tmp39_);
	if (extension) {
		*extension = _vala_extension;
	} else {
		_g_free0 (_vala_extension);
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
peek_recording_ffmpeg_has_10bit_libx264 (void)
{
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint args_length1;
	gint _args_size_;
	gint status = 0;
	gchar* output = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = g_strdup ("ffmpeg");
	_tmp1_ = g_strdup ("-h");
	_tmp2_ = g_strdup ("encoder=libx264");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	args = _tmp3_;
	args_length1 = 3;
	_args_size_ = args_length1;
	{
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		g_spawn_sync (NULL, args, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, NULL, &_tmp5_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp4_;
		status = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		result = string_index_of (output, "10le", 0) != -1;
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_debug ("ffmpeg.vala:67: Error: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	_g_free0 (output);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

