/**
 * @file bcsc_s.h
 *
 * @copyright 2004-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Vincent Bridonneau
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/bcsc/bcsc_z.h, normal z -> s, Sun Feb 15 18:01:29 2026
 *
 **/
#ifndef _bcsc_s_h_
#define _bcsc_s_h_

/**
 * @addtogroup bcsc_internal
 * @{
 *
 *    @name PastixFloat initialization functions
 *    @{
 */
void bcsc_sinit( const spmatrix_t     *spm,
                 const pastix_order_t *ord,
                 const SolverMatrix   *solvmtx,
                 int                   initAt,
                 pastix_bcsc_t        *bcsc,
                 pastix_int_t          valuesize );

#if defined(PASTIX_WITH_MPI)
void bcsc_sstore_data( const spmatrix_t     *spm,
                       const pastix_order_t *ord,
                       const pastix_int_t   *col2cblk,
                       bcsc_handle_comm_t   *bcsc_comm );
#endif

/**
 *   @}
 * @}
 *
 * @addtogroup bcsc
 * @{
 *
 *    @name PastixFloat vector(s) operations
 *    @{
 */
void bvec_saxpy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     float        alpha,
                     const float *x,
                     float       *y );
void bvec_saxpy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     float        alpha,
                     const float *x,
                     float       *y );

void bvec_scopy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const float *x,
                     float       *y );
void bvec_scopy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const float *x,
                     float       *y );

#if defined(PRECISION_z) || defined(PRECISION_c)
float bvec_sdot_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const float *x,
                                   const float *y );
float bvec_sdot_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const float *x,
                                   const float *y );
#endif

float bvec_sdot_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const float *x,
                                   const float *y );
float bvec_sdot_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const float *x,
                                   const float *y );

void bvec_sgemv_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     float        alpha,
                     const float *A,
                     pastix_int_t              lda,
                     const float *x,
                     float        beta,
                     float       *y );
void bvec_sgemv_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     float        alpha,
                     const float *A,
                     pastix_int_t              lda,
                     const float *x,
                     float        beta,
                     float       *y );

float bvec_snrm2_seq( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const float *x );
float bvec_snrm2_smp( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const float *x );

void bvec_sscal_seq( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     float  alpha,
                     float *x );
void bvec_sscal_smp( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     float  alpha,
                     float *x );

#if defined( PASTIX_WITH_MPI )
int bvec_sexchange_data_rep( pastix_data_t      *pastix_data,
                             pastix_int_t        nrhs,
                             float *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb );
int bvec_sallocate_buf_dst( bvec_handle_comm_t *rhs_comm );
int bvec_sexchange_data_dst( pastix_data_t      *pastix_data,
                             pastix_dir_t        dir,
                             pastix_int_t        nrhs,
                             float *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb,
                             const pastix_int_t *glob2loc );
#endif

int bvec_slapmr( pastix_data_t      *pastix_data,
                 pastix_dir_t        dir,
                 pastix_int_t        m,
                 pastix_int_t        n,
                 float *A,
                 pastix_int_t        lda,
                 pastix_rhs_t        PA );

/**
 *    @}
 *
 *    @name PastixFloat matrix operations
 *    @{
 */
float bcsc_snorm( pastix_normtype_t    ntype,
                   const pastix_bcsc_t *bcsc );

void bcsc_sspsv( pastix_data_t      *pastix_data,
                 float *b,
                 float *work );

void bcsc_sspmv( const pastix_data_t      *pastix_data,
                 pastix_trans_t            trans,
                 float        alpha,
                 const float *x,
                 float        beta,
                 float       *y );

void bcsc_sspmv_seq( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     float        alpha,
                     const float *x,
                     float        beta,
                     float       *y );
void bcsc_sspmv_smp( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     float        alpha,
                     const float *x,
                     float        beta,
                     float       *y );

/**
 *    @}
 *
 *    @name PastixFloat MPI vector operations
 *    @{
 */
const float *bvec_sgather_remote( const pastix_data_t      *pastix_data,
                                               const float *y );
void bvec_snullify_remote( const pastix_data_t *pastix_data,
                           float  *y );
void bvec_sallreduce( const pastix_data_t *pastix_data,
                      float  *y );
/**
 *    @}
 * @}
 */
#endif /* _bcsc_s_h_ */
