// python wrapper for vtkSMOutputPort
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMOutputPort.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMOutputPort(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMOutputPort_ClassNew(); }

#ifndef DECLARED_PyvtkSMProxy_ClassNew
extern "C" { PyObject *PyvtkSMProxy_ClassNew(); }
#define DECLARED_PyvtkSMProxy_ClassNew
#endif

static PyObject *
PyvtkSMOutputPort_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMOutputPort::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMOutputPort::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMOutputPort *tempr = vtkSMOutputPort::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMOutputPort *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMOutputPort::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMOutputPort::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMOutputPort::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetDataInformation() :
      op->vtkSMOutputPort::GetDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetRankDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRankDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetRankDataInformation(temp0) :
      op->vtkSMOutputPort::GetRankDataInformation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetSubsetDataInformation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubsetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetSubsetDataInformation(temp0, temp1) :
      op->vtkSMOutputPort::GetSubsetDataInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMOutputPort_GetSubsetDataInformation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubsetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetSubsetDataInformation(temp0) :
      op->vtkSMOutputPort::GetSubsetDataInformation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMOutputPort_GetSubsetDataInformation_Methods[] = {
  {"GetSubsetDataInformation", PyvtkSMOutputPort_GetSubsetDataInformation_s1, METH_VARARGS,
   "@z|z"},
  {"GetSubsetDataInformation", PyvtkSMOutputPort_GetSubsetDataInformation_s2, METH_VARARGS,
   "@I"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMOutputPort_GetSubsetDataInformation(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMOutputPort_GetSubsetDataInformation_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMOutputPort_GetSubsetDataInformation_s1(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetSubsetDataInformation");
  return nullptr;
}


static PyObject *
PyvtkSMOutputPort_GetTemporalDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTemporalDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVTemporalDataInformation *tempr = (ap.IsBound() ?
      op->GetTemporalDataInformation() :
      op->vtkSMOutputPort::GetTemporalDataInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetTemporalSubsetDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTemporalSubsetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPVTemporalDataInformation *tempr = (ap.IsBound() ?
      op->GetTemporalSubsetDataInformation(temp0, temp1) :
      op->vtkSMOutputPort::GetTemporalSubsetDataInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetDataClassName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataClassName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetDataClassName() :
      op->vtkSMOutputPort::GetDataClassName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetClassNameInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClassNameInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVClassNameInformation *tempr = (ap.IsBound() ?
      op->GetClassNameInformation() :
      op->vtkSMOutputPort::GetClassNameInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_InvalidateDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvalidateDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvalidateDataInformation();
    }
    else
    {
      op->vtkSMOutputPort::InvalidateDataInformation();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetPortIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPortIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPortIndex() :
      op->vtkSMOutputPort::GetPortIndex());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetSourceProxy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSourceProxy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSourceProxy *tempr = (ap.IsBound() ?
      op->GetSourceProxy() :
      op->vtkSMOutputPort::GetSourceProxy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetSession(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSession");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSession *tempr = (ap.IsBound() ?
      op->GetSession() :
      op->vtkSMOutputPort::GetSession());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMOutputPort_GetSessionProxyManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSessionProxyManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMOutputPort *op = static_cast<vtkSMOutputPort *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSessionProxyManager *tempr = (ap.IsBound() ?
      op->GetSessionProxyManager() :
      op->vtkSMOutputPort::GetSessionProxyManager());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMOutputPort_Methods[] = {
  {"IsTypeOf", PyvtkSMOutputPort_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMOutputPort_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMOutputPort_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMOutputPort\nC++: static vtkSMOutputPort *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMOutputPort_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMOutputPort\nC++: vtkSMOutputPort *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMOutputPort_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMOutputPort_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetDataInformation", PyvtkSMOutputPort_GetDataInformation, METH_VARARGS,
   "GetDataInformation(self) -> vtkPVDataInformation\nC++: virtual vtkPVDataInformation *GetDataInformation()\n\nReturns data information. If data information is marked invalid,\ncalls GatherDataInformation. If data information is gathered then\nthis fires the vtkCommand::UpdateInformationEvent event.\n"},
  {"GetRankDataInformation", PyvtkSMOutputPort_GetRankDataInformation, METH_VARARGS,
   "GetRankDataInformation(self, rank:int) -> vtkPVDataInformation\nC++: vtkPVDataInformation *GetRankDataInformation(int rank)\n\nGet rank-specific data information.\n"},
  {"GetSubsetDataInformation", PyvtkSMOutputPort_GetSubsetDataInformation, METH_VARARGS,
   "GetSubsetDataInformation(self, selector:str, assemblyName:str=...)\n     -> vtkPVDataInformation\nC++: vtkPVDataInformation *GetSubsetDataInformation(\n    const char *selector, const char *assemblyName=nullptr)\nGetSubsetDataInformation(self, compositeIndex:int)\n    -> vtkPVDataInformation\nC++: vtkPVDataInformation *GetSubsetDataInformation(\n    unsigned int compositeIndex)\n\nFor composite datasets, `GetDataInformation` returns summary data\ninformation for all blocks combined. However, applications may\nrequire information about specific subset of blocks. In that\ncase, one can use this API. Internally, the data information is\ncached per selector / assembly-name pair. That way, if the data\ninformation is not re-gathered unless changed.\n\n@arg selector the selector expression@arg assemblyName name of\nthe assembly to use to apply the selector\n        to determine the subset. If none specified, hierarchy is\nassumed.\n"},
  {"GetTemporalDataInformation", PyvtkSMOutputPort_GetTemporalDataInformation, METH_VARARGS,
   "GetTemporalDataInformation(self) -> vtkPVTemporalDataInformation\nC++: virtual vtkPVTemporalDataInformation *GetTemporalDataInformation(\n    )\n\nReturns data information collected over all timesteps provided by\nthe pipeline. If the data information is not valid, this results\niterating over the pipeline and hence can be slow. Use with\ncaution.\n"},
  {"GetTemporalSubsetDataInformation", PyvtkSMOutputPort_GetTemporalSubsetDataInformation, METH_VARARGS,
   "GetTemporalSubsetDataInformation(self, selector:str,\n    assemblyName:str=...) -> vtkPVTemporalDataInformation\nC++: vtkPVTemporalDataInformation *GetTemporalSubsetDataInformation(\n    const char *selector, const char *assemblyName=nullptr)\n\nGet Temporal data information for a specific selector.\n\n@arg selector the selector expression@arg assemblyName name of\nthe assembly to use to apply the selector\n        to determine the subset. If none specified, hierarchy is\nassumed.\n"},
  {"GetDataClassName", PyvtkSMOutputPort_GetDataClassName, METH_VARARGS,
   "GetDataClassName(self) -> str\nC++: virtual const char *GetDataClassName()\n\nReturns the classname of the data object on this output port.\n"},
  {"GetClassNameInformation", PyvtkSMOutputPort_GetClassNameInformation, METH_VARARGS,
   "GetClassNameInformation(self) -> vtkPVClassNameInformation\nC++: virtual vtkPVClassNameInformation *GetClassNameInformation()\n\nReturns classname information.\n"},
  {"InvalidateDataInformation", PyvtkSMOutputPort_InvalidateDataInformation, METH_VARARGS,
   "InvalidateDataInformation(self) -> None\nC++: virtual void InvalidateDataInformation()\n\nMark data information as invalid.\n"},
  {"GetPortIndex", PyvtkSMOutputPort_GetPortIndex, METH_VARARGS,
   "GetPortIndex(self) -> int\nC++: virtual int GetPortIndex()\n\nReturns the index of the port the output is obtained from.\n"},
  {"GetSourceProxy", PyvtkSMOutputPort_GetSourceProxy, METH_VARARGS,
   "GetSourceProxy(self) -> vtkSMSourceProxy\nC++: vtkSMSourceProxy *GetSourceProxy()\n\nProvides access to the source proxy to which the output port\nbelongs.\n"},
  {"GetSession", PyvtkSMOutputPort_GetSession, METH_VARARGS,
   "GetSession(self) -> vtkSMSession\nC++: vtkSMSession *GetSession() override;\n\nOverridden to forward to the source proxy.\n"},
  {"GetSessionProxyManager", PyvtkSMOutputPort_GetSessionProxyManager, METH_VARARGS,
   "GetSessionProxyManager(self) -> vtkSMSessionProxyManager\nC++: vtkSMSessionProxyManager *GetSessionProxyManager() override;\n\nReturn the corresponding ProxyManager if any.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMOutputPort_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("source_proxy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetSourceProxy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSourceProxy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("port_index"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetPortIndex(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPortIndex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("session"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetSession(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSession\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("temporal_data_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetTemporalDataInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTemporalDataInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_class_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetDataClassName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataClassName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("class_name_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetClassNameInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetClassNameInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("session_proxy_manager"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMOutputPort_GetSessionProxyManager(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSessionProxyManager\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMOutputPort_Doc =
  "vtkSMOutputPort - reference for an output port of a vtkAlgorithm.\n\n"
  "Superclass: vtkSMProxy\n\n"
  "This object manages one output port of an algorithm. It is used\n"
  "internally by vtkSMSourceProxy to manage all of it's\n"
  "outputs.@attention Previously, vtkSMOutputPort used to be a\n"
  "vtkSMProxy subclass since it was indeed a Proxy for the output port.\n"
  "However that has now changed. This merely sits as a datastructure to\n"
  "manage ports specific things like data-information. However for\n"
  "backwards compatibility, to keep the impact minimal, we leave this as\n"
  "a sub-class of a Proxy with GlobalID=0 and Session=nullptr.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMOutputPort_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMOutputPort", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMOutputPort_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMOutputPort_StaticNew()
{
  return vtkSMOutputPort::New();
}

PyObject *PyvtkSMOutputPort_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMOutputPort_Type, PyvtkSMOutputPort_Methods,
    "vtkSMOutputPort",
 &PyvtkSMOutputPort_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMOutputPort_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMOutputPort(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMOutputPort_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMOutputPort", o) != 0)
  {
    Py_DECREF(o);
  }

}

