// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkStreamLinesBlending_fs.h"

const char *vtkStreamLinesBlending_fs =
"//VTK::System::Dec\n"
"//VTK::Output::Dec\n"
"\n"
"varying vec2 tcoordVC;\n"
"\n"
"uniform sampler2D prev;\n"
"uniform sampler2D prevDepth;\n"
"uniform sampler2D current;\n"
"uniform sampler2D currentDepth;\n"
"uniform float alpha;\n"
"\n"
"void main(void)\n"
"{\n"
"  vec4 pc = texture2D(prev, tcoordVC);\n"
"  vec4 cc = texture2D(current, tcoordVC);\n"
"  gl_FragData[0] = pc + cc;\n"
"  gl_FragData[0].a *= alpha;\n"
"  float pd = texture2D(prevDepth, tcoordVC).x; // previous depth\n"
"  float cd = texture2D(currentDepth, tcoordVC).x; // current depth\n"
"  if (cd < 1.0)\n"
"  {\n"
"    gl_FragDepth = cd;\n"
"  }\n"
"  else\n"
"  {\n"
"    gl_FragDepth = pd;\n"
"  }\n"
"}\n"
"";
