/* PlaybackManager.c generated by valac 0.56.17, the Vala compiler
 * generated from PlaybackManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gst/gst.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>

#define AUDIENCE_APP_ACTION_PLAY_PAUSE "action-play-pause"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
typedef struct _AudiencePlaybackManagerPrivate AudiencePlaybackManagerPrivate;
enum  {
	AUDIENCE_PLAYBACK_MANAGER_0_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY,
	AUDIENCE_PLAYBACK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_NUM_PROPERTIES];
typedef enum  {
	AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_DISABLED,
	AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ALL,
	AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ONE
} AudiencePlaybackManagerRepeatMode;

#define AUDIENCE_PLAYBACK_MANAGER_TYPE_REPEAT_MODE (audience_playback_manager_repeat_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG (audience_unsupported_file_dialog_get_type ())
#define AUDIENCE_UNSUPPORTED_FILE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG, AudienceUnsupportedFileDialog))
#define AUDIENCE_UNSUPPORTED_FILE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG, AudienceUnsupportedFileDialogClass))
#define AUDIENCE_IS_UNSUPPORTED_FILE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG))
#define AUDIENCE_IS_UNSUPPORTED_FILE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG))
#define AUDIENCE_UNSUPPORTED_FILE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_UNSUPPORTED_FILE_DIALOG, AudienceUnsupportedFileDialogClass))

typedef struct _AudienceUnsupportedFileDialog AudienceUnsupportedFileDialog;
typedef struct _AudienceUnsupportedFileDialogClass AudienceUnsupportedFileDialogClass;
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_tag_list_unref0(var) ((var == NULL) ? NULL : (var = (gst_tag_list_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	AUDIENCE_PLAYBACK_MANAGER_ENDED_SIGNAL,
	AUDIENCE_PLAYBACK_MANAGER_NEXT_AUDIO_SIGNAL,
	AUDIENCE_PLAYBACK_MANAGER_NEXT_TEXT_SIGNAL,
	AUDIENCE_PLAYBACK_MANAGER_URI_CHANGED_SIGNAL,
	AUDIENCE_PLAYBACK_MANAGER_NUM_SIGNALS
};
static guint audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_NUM_SIGNALS] = {0};

struct _AudiencePlaybackManager {
	GObject parent_instance;
	AudiencePlaybackManagerPrivate * priv;
};

struct _AudiencePlaybackManagerClass {
	GObjectClass parent_class;
};

struct _AudiencePlaybackManagerPrivate {
	GdkPaintable* _gst_video_widget;
	gchar* _subtitle_uri;
	gboolean _playing;
	gint64 _duration;
	gint64 _position;
	GtkStringList* _play_queue;
	GstElement* playbin;
	gboolean is_seeking;
	gint64 queued_seek;
	guint inhibit_token;
};

struct _Block8Data {
	int _ref_count_;
	AudiencePlaybackManager* self;
	AudienceUnsupportedFileDialog* unsupported_file_dialog;
};

struct _Block9Data {
	int _ref_count_;
	AudiencePlaybackManager* self;
	gboolean temp_playing;
	gint64 temp_position;
	gulong ready_handler_id;
};

struct _Block10Data {
	int _ref_count_;
	AudiencePlaybackManager* self;
	GtkApplication* default_application;
};

static gint AudiencePlaybackManager_private_offset;
static gpointer audience_playback_manager_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;
static GOnce audience_playback_manager_instance;
static GOnce audience_playback_manager_instance = G_ONCE_INIT;

VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN gint64 audience_playback_manager_get_duration (AudiencePlaybackManager* self);
VALA_EXTERN gint64 audience_playback_manager_get_position (AudiencePlaybackManager* self);
VALA_EXTERN GType audience_playback_manager_repeat_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
static AudiencePlaybackManager* __lambda10_ (void);
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_new (void);
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_construct (GType object_type);
static gpointer ___lambda10__gthread_func (gpointer self);
static void audience_playback_manager_handle_bus_message (AudiencePlaybackManager* self,
                                                   GstMessage* message);
VALA_EXTERN void audience_playback_manager_play_file (AudiencePlaybackManager* self,
                                          const gchar* uri,
                                          gboolean from_beginning);
VALA_EXTERN gboolean audience_playback_manager_next (AudiencePlaybackManager* self);
VALA_EXTERN GtkStringList* audience_playback_manager_get_play_queue (AudiencePlaybackManager* self);
static void audience_playback_manager_set_position (AudiencePlaybackManager* self,
                                             gint64 value);
static void audience_playback_manager_set_duration (AudiencePlaybackManager* self,
                                             gint64 value);
static void audience_playback_manager_set_playing (AudiencePlaybackManager* self,
                                            gboolean value);
VALA_EXTERN void audience_playback_manager_seek (AudiencePlaybackManager* self,
                                     gint64 position);
VALA_EXTERN gboolean audience_playback_manager_get_playing (AudiencePlaybackManager* self);
static void audience_playback_manager_update_position (AudiencePlaybackManager* self);
VALA_EXTERN GType audience_unsupported_file_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceUnsupportedFileDialog, g_object_unref)
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN AudienceUnsupportedFileDialog* audience_unsupported_file_dialog_new (const gchar* uri,
                                                                     const gchar* filename,
                                                                     const gchar* content_type);
VALA_EXTERN AudienceUnsupportedFileDialog* audience_unsupported_file_dialog_construct (GType object_type,
                                                                           const gchar* uri,
                                                                           const gchar* filename,
                                                                           const gchar* content_type);
static void ____lambda11_ (Block8Data* _data8_,
                    gint type);
static void _____lambda11__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
VALA_EXTERN void audience_playback_manager_set_subtitle (AudiencePlaybackManager* self,
                                             const gchar* uri);
static gchar* audience_playback_manager_get_subtitle_for_uri (AudiencePlaybackManager* self,
                                                       const gchar* uri);
VALA_EXTERN void audience_playback_manager_stop (AudiencePlaybackManager* self);
VALA_EXTERN void audience_playback_manager_clear_playlist (AudiencePlaybackManager* self,
                                               gboolean should_stop);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   gchar** uris,
                                                   gint uris_length1);
static gboolean audience_playback_manager_is_subtitle (AudiencePlaybackManager* self,
                                                const gchar* uri);
static void audience_playback_manager_set_subtitle_uri (AudiencePlaybackManager* self,
                                                 const gchar* value);
static guint audience_playback_manager_get_queue_position (AudiencePlaybackManager* self,
                                                    const gchar* uri);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN void audience_playback_manager_save_playlist (AudiencePlaybackManager* self);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void audience_playback_manager_previous (AudiencePlaybackManager* self);
VALA_EXTERN GList* audience_playback_manager_get_audio_tracks (AudiencePlaybackManager* self);
VALA_EXTERN GList* audience_playback_manager_get_subtitle_tracks (AudiencePlaybackManager* self);
VALA_EXTERN gchar* audience_playback_manager_get_uri (AudiencePlaybackManager* self);
VALA_EXTERN gint audience_playback_manager_get_audio_track (AudiencePlaybackManager* self);
VALA_EXTERN void audience_playback_manager_set_audio_track (AudiencePlaybackManager* self,
                                                gint track);
VALA_EXTERN gint audience_playback_manager_get_subtitle_track (AudiencePlaybackManager* self);
VALA_EXTERN void audience_playback_manager_set_subtitle_track (AudiencePlaybackManager* self,
                                                   gint track);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ___lambda12_ (Block9Data* _data9_);
static void ____lambda12__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN GdkPaintable* audience_playback_manager_get_gst_video_widget (AudiencePlaybackManager* self);
static void audience_playback_manager_set_gst_video_widget (AudiencePlaybackManager* self,
                                                     GdkPaintable* value);
VALA_EXTERN const gchar* audience_playback_manager_get_subtitle_uri (AudiencePlaybackManager* self);
static void audience_playback_manager_set_play_queue (AudiencePlaybackManager* self,
                                               GtkStringList* value);
static GObject * audience_playback_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void _audience_playback_manager_handle_bus_message_gst_bus_message (GstBus* _sender,
                                                                    GstMessage* message,
                                                                    gpointer self);
static void _audience_playback_manager___lambda13_ (AudiencePlaybackManager* self);
static void __audience_playback_manager___lambda13__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _audience_playback_manager___lambda14_ (AudiencePlaybackManager* self);
static void __audience_playback_manager___lambda14__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void _audience_playback_manager___lambda15_ (AudiencePlaybackManager* self,
                                             const gchar* name,
                                             GVariant* new_state);
static void __audience_playback_manager___lambda15__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                                  const gchar* action_name,
                                                                                  GVariant* state,
                                                                                  gpointer self);
static void _audience_playback_manager_save_playlist_g_list_model_items_changed (GListModel* _sender,
                                                                          guint position,
                                                                          guint removed,
                                                                          guint added,
                                                                          gpointer self);
static void _audience_playback_manager___lambda16_ (Block10Data* _data10_);
static GVariant* _variant_new11 (gboolean value);
static void __audience_playback_manager___lambda16__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static gboolean _audience_playback_manager___lambda17_ (AudiencePlaybackManager* self);
static gboolean __audience_playback_manager___lambda17__gsource_func (gpointer self);
static void audience_playback_manager_finalize (GObject * obj);
static GType audience_playback_manager_get_type_once (void);
static void _vala_audience_playback_manager_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_audience_playback_manager_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const gchar* AUDIENCE_SUBTITLE_EXTENSIONS[6];

static inline gpointer
audience_playback_manager_get_instance_private (AudiencePlaybackManager* self)
{
	return G_STRUCT_MEMBER_P (self, AudiencePlaybackManager_private_offset);
}

static GType
audience_playback_manager_repeat_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_DISABLED, "AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_DISABLED", "disabled"}, {AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ALL, "AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ALL", "all"}, {AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ONE, "AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ONE", "one"}, {0, NULL, NULL}};
	GType audience_playback_manager_repeat_mode_type_id;
	audience_playback_manager_repeat_mode_type_id = g_enum_register_static ("AudiencePlaybackManagerRepeatMode", values);
	return audience_playback_manager_repeat_mode_type_id;
}

GType
audience_playback_manager_repeat_mode_get_type (void)
{
	static volatile gsize audience_playback_manager_repeat_mode_type_id__once = 0;
	if (g_once_init_enter (&audience_playback_manager_repeat_mode_type_id__once)) {
		GType audience_playback_manager_repeat_mode_type_id;
		audience_playback_manager_repeat_mode_type_id = audience_playback_manager_repeat_mode_get_type_once ();
		g_once_init_leave (&audience_playback_manager_repeat_mode_type_id__once, audience_playback_manager_repeat_mode_type_id);
	}
	return audience_playback_manager_repeat_mode_type_id__once;
}

static AudiencePlaybackManager*
__lambda10_ (void)
{
	AudiencePlaybackManager* _tmp0_;
	AudiencePlaybackManager* result;
	_tmp0_ = audience_playback_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda10__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda10_ ();
	return result;
}

AudiencePlaybackManager*
audience_playback_manager_get_default (void)
{
	gconstpointer _tmp0_;
	AudiencePlaybackManager* result;
	_tmp0_ = g_once (&audience_playback_manager_instance, ___lambda10__gthread_func, NULL);
	result = (AudiencePlaybackManager*) _tmp0_;
	return result;
}

static void
audience_playback_manager_handle_bus_message (AudiencePlaybackManager* self,
                                              GstMessage* message)
{
	GtkApplication* default_application = NULL;
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = g_application_get_default ();
	default_application = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication);
	switch (message->type) {
		case GST_MESSAGE_EOS:
		{
			AudiencePlaybackManagerRepeatMode repeat_mode = 0;
			GSettings* _tmp1_;
			_tmp1_ = audience_settings;
			repeat_mode = (AudiencePlaybackManagerRepeatMode) g_settings_get_enum (_tmp1_, "repeat-mode");
			if (repeat_mode == AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ONE) {
				GstElement* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = self->priv->playbin;
				g_object_get (_tmp2_, "current-uri", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				audience_playback_manager_play_file (self, _tmp4_, TRUE);
			} else {
				if (!audience_playback_manager_next (self)) {
					if (repeat_mode == AUDIENCE_PLAYBACK_MANAGER_REPEAT_MODE_ALL) {
						GtkStringList* _tmp5_;
						const gchar* _tmp6_;
						_tmp5_ = self->priv->_play_queue;
						_tmp6_ = gtk_string_list_get_string (_tmp5_, (guint) 0);
						audience_playback_manager_play_file (self, _tmp6_, TRUE);
					} else {
						GstElement* _tmp7_;
						GSettings* _tmp8_;
						_tmp7_ = self->priv->playbin;
						gst_element_set_state (_tmp7_, GST_STATE_NULL);
						_tmp8_ = audience_settings;
						g_settings_set_int64 (_tmp8_, "last-stopped", (gint64) 0);
						audience_playback_manager_set_position (self, (gint64) 0);
						audience_playback_manager_set_duration (self, (gint64) 0);
						g_signal_emit (self, audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_ENDED_SIGNAL], 0);
					}
				}
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstState old_state = 0;
			GstState new_state = 0;
			GstState pending_state = 0;
			GstState _tmp9_ = 0;
			GstState _tmp10_ = 0;
			GstState _tmp11_ = 0;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp16_;
			gst_message_parse_state_changed (message, &_tmp9_, &_tmp10_, &_tmp11_);
			old_state = _tmp9_;
			new_state = _tmp10_;
			pending_state = _tmp11_;
			audience_playback_manager_set_playing (self, new_state == GST_STATE_PLAYING);
			if (old_state == GST_STATE_READY) {
				_tmp12_ = new_state == GST_STATE_PAUSED;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gint64 _duration = 0LL;
				GstElement* _tmp13_;
				gint64 _tmp14_ = 0LL;
				gboolean _tmp15_;
				_tmp13_ = self->priv->playbin;
				_tmp15_ = gst_element_query_duration (_tmp13_, GST_FORMAT_TIME, &_tmp14_);
				_duration = _tmp14_;
				if (_tmp15_) {
					audience_playback_manager_set_duration (self, _duration);
				}
				if (self->priv->queued_seek >= ((gint64) 0)) {
					audience_playback_manager_seek (self, self->priv->queued_seek);
				}
			}
			_tmp16_ = self->priv->_playing;
			if (_tmp16_) {
				GtkApplication* _tmp18_;
				GtkApplication* _tmp19_;
				GtkWindow* _tmp20_;
				GtkWindow* _tmp21_;
				if (self->priv->inhibit_token != ((guint) 0)) {
					GtkApplication* _tmp17_;
					_tmp17_ = default_application;
					gtk_application_uninhibit (_tmp17_, self->priv->inhibit_token);
				}
				_tmp18_ = default_application;
				_tmp19_ = default_application;
				_tmp20_ = gtk_application_get_active_window (_tmp19_);
				_tmp21_ = _tmp20_;
				self->priv->inhibit_token = gtk_application_inhibit (_tmp18_, _tmp21_, GTK_APPLICATION_INHIBIT_IDLE | GTK_APPLICATION_INHIBIT_SUSPEND, _ ("A video is playing"));
			} else {
				if (self->priv->inhibit_token != ((guint) 0)) {
					GtkApplication* _tmp22_;
					_tmp22_ = default_application;
					gtk_application_uninhibit (_tmp22_, self->priv->inhibit_token);
					self->priv->inhibit_token = (guint) 0;
				}
			}
			break;
		}
		case GST_MESSAGE_ASYNC_DONE:
		{
			if (self->priv->is_seeking) {
				self->priv->is_seeking = FALSE;
				audience_playback_manager_update_position (self);
				if (self->priv->queued_seek >= ((gint64) 0)) {
					audience_playback_manager_seek (self, self->priv->queued_seek);
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		AudiencePlaybackManager* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->unsupported_file_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
____lambda11_ (Block8Data* _data8_,
               gint type)
{
	AudiencePlaybackManager* self;
	AudienceUnsupportedFileDialog* _tmp0_;
	self = _data8_->self;
	if (type == ((gint) GTK_RESPONSE_CANCEL)) {
		if (!audience_playback_manager_next (self)) {
			g_signal_emit (self, audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_ENDED_SIGNAL], 0);
		}
	}
	_tmp0_ = _data8_->unsupported_file_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
_____lambda11__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda11_ (self, response_id);
}

void
audience_playback_manager_play_file (AudiencePlaybackManager* self,
                                     const gchar* uri,
                                     gboolean from_beginning)
{
	GstElement* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GstElement* _tmp13_;
	GstElement* _tmp20_;
	GtkRecentManager* _tmp21_;
	GSettings* _tmp22_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_debug ("PlaybackManager.vala:178: Opening %s", uri);
	_tmp0_ = self->priv->playbin;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = g_file_new_for_uri (uri);
	file = _tmp1_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_;
		const gchar* content_type = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_info_get_content_type (info);
		content_type = _tmp3_;
		_tmp4_ = content_type;
		if (!g_content_type_is_a (_tmp4_, "video/*")) {
			Block8Data* _data8_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			AudienceUnsupportedFileDialog* _tmp8_;
			AudienceUnsupportedFileDialog* _tmp9_;
			AudienceUnsupportedFileDialog* _tmp10_;
			_data8_ = g_slice_new0 (Block8Data);
			_data8_->_ref_count_ = 1;
			_data8_->self = g_object_ref (self);
			_tmp5_ = content_type;
			g_debug ("PlaybackManager.vala:188: Unrecognized file format: %s", _tmp5_);
			_tmp6_ = g_file_info_get_name (info);
			_tmp7_ = content_type;
			_tmp8_ = audience_unsupported_file_dialog_new (uri, _tmp6_, _tmp7_);
			g_object_ref_sink (_tmp8_);
			_data8_->unsupported_file_dialog = _tmp8_;
			_tmp9_ = _data8_->unsupported_file_dialog;
			gtk_window_present ((GtkWindow*) _tmp9_);
			_tmp10_ = _data8_->unsupported_file_dialog;
			g_signal_connect_data ((GtkDialog*) _tmp10_, "response", (GCallback) _____lambda11__gtk_dialog_response, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
			block8_data_unref (_data8_);
			_data8_ = NULL;
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("PlaybackManager.vala:204: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp13_ = self->priv->playbin;
	g_object_set (_tmp13_, "uri", uri, NULL);
	if (from_beginning) {
		audience_playback_manager_seek (self, (gint64) 0);
	} else {
		GSettings* _tmp14_;
		_tmp14_ = audience_settings;
		audience_playback_manager_seek (self, g_settings_get_int64 (_tmp14_, "last-stopped"));
	}
	if (!from_beginning) {
		GSettings* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = audience_settings;
		_tmp16_ = g_settings_get_string (_tmp15_, "current-external-subtitles-uri");
		_tmp17_ = _tmp16_;
		audience_playback_manager_set_subtitle (self, _tmp17_);
		_g_free0 (_tmp17_);
	} else {
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = audience_playback_manager_get_subtitle_for_uri (self, uri);
		_tmp19_ = _tmp18_;
		audience_playback_manager_set_subtitle (self, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->playbin;
	gst_element_set_state (_tmp20_, GST_STATE_PLAYING);
	_tmp21_ = gtk_recent_manager_get_default ();
	gtk_recent_manager_add_item (_tmp21_, uri);
	_tmp22_ = audience_settings;
	g_settings_set_string (_tmp22_, "current-video", uri);
	_g_object_unref0 (file);
}

void
audience_playback_manager_stop (AudiencePlaybackManager* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = audience_settings;
	g_settings_set_int64 (_tmp0_, "last-stopped", (gint64) 0);
	_tmp1_ = audience_settings;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 0;
	g_settings_set_strv (_tmp1_, "last-played-videos", _tmp3_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp4_ = audience_settings;
	g_settings_set_string (_tmp4_, "current-video", "");
	_tmp5_ = self->priv->_playing;
	if (_tmp5_) {
		GstElement* _tmp6_;
		gint64 _tmp7_;
		_tmp6_ = self->priv->playbin;
		gst_element_set_state (_tmp6_, GST_STATE_NULL);
		_tmp7_ = self->priv->_duration;
		audience_playback_manager_seek (self, _tmp7_);
		g_signal_emit (self, audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_ENDED_SIGNAL], 0);
	}
}

void
audience_playback_manager_clear_playlist (AudiencePlaybackManager* self,
                                          gboolean should_stop)
{
	GtkStringList* _tmp0_;
	GtkStringList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_play_queue;
	_tmp1_ = self->priv->_play_queue;
	gtk_string_list_splice (_tmp0_, (guint) 0, g_list_model_get_n_items ((GListModel*) _tmp1_), NULL);
	if (should_stop) {
		audience_playback_manager_stop (self);
	}
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                              gchar** uris,
                                              gint uris_length1)
{
	gchar** uris_to_queue = NULL;
	gchar** _tmp0_;
	gint uris_to_queue_length1;
	gint _uris_to_queue_size_;
	GtkStringList* _tmp7_;
	GtkStringList* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	uris_to_queue = _tmp0_;
	uris_to_queue_length1 = 0;
	_uris_to_queue_size_ = uris_to_queue_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = uris;
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp1_;
			gchar* uri = NULL;
			_tmp1_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = uri;
				if (audience_playback_manager_is_subtitle (self, _tmp2_)) {
					const gchar* _tmp3_;
					_tmp3_ = uri;
					audience_playback_manager_set_subtitle_uri (self, _tmp3_);
				} else {
					const gchar* _tmp4_;
					_tmp4_ = uri;
					if (audience_playback_manager_get_queue_position (self, _tmp4_) == GTK_INVALID_LIST_POSITION) {
						const gchar* _tmp5_;
						gchar* _tmp6_;
						_tmp5_ = uri;
						_tmp6_ = g_strdup (_tmp5_);
						_vala_array_add9 (&uris_to_queue, &uris_to_queue_length1, &_uris_to_queue_size_, _tmp6_);
					}
				}
				_g_free0 (uri);
			}
		}
	}
	_tmp7_ = self->priv->_play_queue;
	_tmp8_ = self->priv->_play_queue;
	_tmp9_ = uris_to_queue;
	_tmp9__length1 = uris_to_queue_length1;
	gtk_string_list_splice (_tmp7_, g_list_model_get_n_items ((GListModel*) _tmp8_), (guint) 0, _tmp9_);
	uris_to_queue = (_vala_array_free (uris_to_queue, uris_to_queue_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
audience_playback_manager_save_playlist (AudiencePlaybackManager* self)
{
	GSettings* privacy_settings = NULL;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	gchar** videos = NULL;
	gchar** _tmp4_;
	gint videos_length1;
	gint _videos_size_;
	GSettings* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.privacy");
	privacy_settings = _tmp0_;
	_tmp2_ = privacy_settings;
	if (!g_settings_get_boolean (_tmp2_, "remember-recent-files")) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp3_;
		_tmp3_ = privacy_settings;
		_tmp1_ = !g_settings_get_boolean (_tmp3_, "remember-app-usage");
	}
	if (_tmp1_) {
		_g_object_unref0 (privacy_settings);
		return;
	}
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	videos = _tmp4_;
	videos_length1 = 0;
	_videos_size_ = videos_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GtkStringList* _tmp7_;
				GtkStringList* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->_play_queue;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp7_))) {
					break;
				}
				_tmp8_ = self->priv->_play_queue;
				_tmp9_ = gtk_string_list_get_string (_tmp8_, (guint) i);
				_tmp10_ = g_strdup (_tmp9_);
				_vala_array_add10 (&videos, &videos_length1, &_videos_size_, _tmp10_);
			}
		}
	}
	_tmp11_ = audience_settings;
	_tmp12_ = videos;
	_tmp12__length1 = videos_length1;
	g_settings_set_strv (_tmp11_, "last-played-videos", _tmp12_);
	videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (privacy_settings);
}

gboolean
audience_playback_manager_next (AudiencePlaybackManager* self)
{
	guint position = 0U;
	GstElement* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkStringList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "current-uri", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	position = audience_playback_manager_get_queue_position (self, _tmp2_);
	_tmp3_ = self->priv->_play_queue;
	if (position < (g_list_model_get_n_items ((GListModel*) _tmp3_) - 1)) {
		GtkStringList* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_play_queue;
		_tmp5_ = gtk_string_list_get_string (_tmp4_, position + 1);
		audience_playback_manager_play_file (self, _tmp5_, TRUE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
audience_playback_manager_previous (AudiencePlaybackManager* self)
{
	guint position = 0U;
	GstElement* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "current-uri", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	position = audience_playback_manager_get_queue_position (self, _tmp2_);
	if (position == ((guint) 0)) {
		audience_playback_manager_seek (self, (gint64) 0);
	} else {
		if (position != GTK_INVALID_LIST_POSITION) {
			GtkStringList* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = self->priv->_play_queue;
			_tmp4_ = gtk_string_list_get_string (_tmp3_, position - 1);
			audience_playback_manager_play_file (self, _tmp4_, TRUE);
		}
	}
}

void
audience_playback_manager_seek (AudiencePlaybackManager* self,
                                gint64 position)
{
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GstElement* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) 0);
	state = _tmp1_;
	pending = _tmp2_;
	if (self->priv->is_seeking) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (state != GST_STATE_PAUSED) {
			_tmp4_ = state != GST_STATE_PLAYING;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp3_ = _tmp4_;
	}
	if (_tmp3_) {
		self->priv->queued_seek = position;
		return;
	}
	_tmp5_ = self->priv->playbin;
	if (gst_element_seek_simple (_tmp5_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_ACCURATE, position)) {
		self->priv->is_seeking = TRUE;
	} else {
		g_warning ("PlaybackManager.vala:313: Failed to seek.");
	}
	self->priv->queued_seek = (gint64) -1;
}

static void
audience_playback_manager_update_position (AudiencePlaybackManager* self)
{
	gint64 _position = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	_tmp2_ = gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	_position = _tmp1_;
	if (_tmp2_) {
		audience_playback_manager_set_position (self, _position);
	} else {
		audience_playback_manager_set_position (self, (gint64) 0);
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
audience_playback_manager_is_subtitle (AudiencePlaybackManager* self,
                                       const gchar* uri)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp1_ = strlen (uri);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 4) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = strlen (uri);
		_tmp4_ = _tmp3_;
		_tmp0_ = string_get_char (uri, (glong) (_tmp4_ - 4)) != ((gunichar) '.');
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		const gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = AUDIENCE_SUBTITLE_EXTENSIONS;
		ext_collection_length1 = G_N_ELEMENTS (AUDIENCE_SUBTITLE_EXTENSIONS);
		for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
			const gchar* ext = NULL;
			ext = ext_collection[ext_it];
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = g_utf8_strdown (uri, (gssize) -1);
				_tmp6_ = _tmp5_;
				_tmp7_ = ext;
				_tmp8_ = g_str_has_suffix (_tmp6_, _tmp7_);
				_g_free0 (_tmp6_);
				if (_tmp8_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

GList*
audience_playback_manager_get_audio_tracks (AudiencePlaybackManager* self)
{
	GList* list = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GstElement* _tmp2_;
				GstElement* _tmp3_;
				GstElement* _tmp4_;
				GstTagList* tag_list = NULL;
				GstElement* _tmp5_;
				GstTagList* _tmp6_ = NULL;
				gchar* lang_code = NULL;
				GstTagList* _tmp7_;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->playbin;
				g_object_get (_tmp2_, "n-audio", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (!(i < ((gint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->playbin;
				g_signal_emit_by_name (_tmp5_, "get-audio-tags", i, &_tmp6_, NULL);
				_gst_tag_list_unref0 (tag_list);
				tag_list = _tmp6_;
				_tmp7_ = tag_list;
				gst_tag_list_get_string (_tmp7_, "language-code", &_tmp8_);
				_g_free0 (lang_code);
				lang_code = _tmp8_;
				_tmp9_ = lang_code;
				_tmp10_ = g_strdup (_tmp9_);
				list = g_list_append (list, _tmp10_);
				_g_free0 (lang_code);
				_gst_tag_list_unref0 (tag_list);
			}
		}
	}
	result = list;
	return result;
}

GList*
audience_playback_manager_get_subtitle_tracks (AudiencePlaybackManager* self)
{
	GList* list = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GstElement* _tmp2_;
				GstElement* _tmp3_;
				GstElement* _tmp4_;
				GstTagList* tag_list = NULL;
				GstElement* _tmp5_;
				GstTagList* _tmp6_ = NULL;
				gchar* lang_code = NULL;
				GstTagList* _tmp7_;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->playbin;
				g_object_get (_tmp2_, "n-text", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (!(i < ((gint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->playbin;
				g_signal_emit_by_name (_tmp5_, "get-text-tags", i, &_tmp6_, NULL);
				_gst_tag_list_unref0 (tag_list);
				tag_list = _tmp6_;
				_tmp7_ = tag_list;
				gst_tag_list_get_string (_tmp7_, "language-code", &_tmp8_);
				_g_free0 (lang_code);
				lang_code = _tmp8_;
				_tmp9_ = lang_code;
				_tmp10_ = g_strdup (_tmp9_);
				list = g_list_append (list, _tmp10_);
				_g_free0 (lang_code);
				_gst_tag_list_unref0 (tag_list);
			}
		}
	}
	result = list;
	return result;
}

gchar*
audience_playback_manager_get_uri (AudiencePlaybackManager* self)
{
	GstElement* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "current-uri", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
audience_playback_manager_get_audio_track (AudiencePlaybackManager* self)
{
	GstElement* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "current-audio", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
audience_playback_manager_set_audio_track (AudiencePlaybackManager* self,
                                           gint track)
{
	GstElement* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	g_object_set (_tmp0_, "current-audio", track, NULL);
}

gint
audience_playback_manager_get_subtitle_track (AudiencePlaybackManager* self)
{
	GstElement* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "current-text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
audience_playback_manager_set_subtitle_track (AudiencePlaybackManager* self,
                                              gint track)
{
	GstElement* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	g_object_set (_tmp0_, "current-text", track, NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		AudiencePlaybackManager* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
___lambda12_ (Block9Data* _data9_)
{
	AudiencePlaybackManager* self;
	gboolean _tmp0_;
	self = _data9_->self;
	_tmp0_ = self->priv->_playing;
	if (!_tmp0_) {
		return;
	}
	g_signal_handler_disconnect ((GObject*) self, _data9_->ready_handler_id);
	audience_playback_manager_seek (self, _data9_->temp_position);
	if (!_data9_->temp_playing) {
		GstElement* _tmp1_;
		_tmp1_ = self->priv->playbin;
		gst_element_set_state (_tmp1_, GST_STATE_PAUSED);
	}
}

static void
____lambda12__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda12_ (self);
}

void
audience_playback_manager_set_subtitle (AudiencePlaybackManager* self,
                                        const gchar* uri)
{
	GstState state = 0;
	GstState pending = 0;
	GstElement* _tmp0_;
	GstState _tmp1_ = 0;
	GstState _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GSettings* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->playbin;
	gst_element_get_state (_tmp0_, &_tmp1_, &_tmp2_, (GstClockTime) 0);
	state = _tmp1_;
	pending = _tmp2_;
	if (state == GST_STATE_PAUSED) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = state == GST_STATE_PLAYING;
	}
	if (_tmp3_) {
		Block9Data* _data9_;
		gboolean _tmp4_;
		gint64 _tmp5_;
		gulong _tmp6_;
		_data9_ = g_slice_new0 (Block9Data);
		_data9_->_ref_count_ = 1;
		_data9_->self = g_object_ref (self);
		_tmp4_ = self->priv->_playing;
		_data9_->temp_playing = _tmp4_;
		_tmp5_ = self->priv->_position;
		_data9_->temp_position = _tmp5_;
		_data9_->ready_handler_id = (gulong) 0;
		_tmp6_ = g_signal_connect_data ((GObject*) self, "notify::playing", (GCallback) ____lambda12__g_object_notify, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_data9_->ready_handler_id = _tmp6_;
		block9_data_unref (_data9_);
		_data9_ = NULL;
	}
	_tmp7_ = self->priv->playbin;
	gst_element_set_state (_tmp7_, GST_STATE_NULL);
	_tmp8_ = self->priv->playbin;
	g_object_set (_tmp8_, "suburi", uri, NULL);
	_tmp9_ = self->priv->playbin;
	gst_element_set_state (_tmp9_, GST_STATE_PLAYING);
	_tmp10_ = audience_settings;
	g_settings_set_string (_tmp10_, "current-external-subtitles-uri", uri);
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
audience_playback_manager_get_subtitle_for_uri (AudiencePlaybackManager* self,
                                                const gchar* uri)
{
	gchar* without_ext = NULL;
	gint last_dot = 0;
	gint last_slash = 0;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	last_dot = string_last_index_of (uri, ".", 0);
	last_slash = string_last_index_of (uri, "/", 0);
	if (last_dot < last_slash) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (uri);
		_g_free0 (without_ext);
		without_ext = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = string_slice (uri, (glong) 0, (glong) last_dot);
		_g_free0 (without_ext);
		without_ext = _tmp1_;
	}
	{
		const gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = AUDIENCE_SUBTITLE_EXTENSIONS;
		ext_collection_length1 = G_N_ELEMENTS (AUDIENCE_SUBTITLE_EXTENSIONS);
		for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
			gchar* _tmp2_;
			gchar* ext = NULL;
			_tmp2_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp2_;
			{
				gchar* sub_uri = NULL;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				GFile* _tmp10_;
				GFile* _tmp11_;
				gboolean _tmp12_;
				_tmp3_ = without_ext;
				_tmp4_ = g_strconcat (_tmp3_, ".", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = ext;
				_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp5_);
				sub_uri = _tmp8_;
				_tmp9_ = sub_uri;
				_tmp10_ = g_file_new_for_uri (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_file_query_exists (_tmp11_, NULL);
				_g_object_unref0 (_tmp11_);
				if (_tmp12_) {
					result = sub_uri;
					_g_free0 (ext);
					_g_free0 (without_ext);
					return result;
				}
				_g_free0 (sub_uri);
				_g_free0 (ext);
			}
		}
	}
	_tmp13_ = g_strdup ("");
	result = _tmp13_;
	_g_free0 (without_ext);
	return result;
}

static guint
audience_playback_manager_get_queue_position (AudiencePlaybackManager* self,
                                              const gchar* uri)
{
	guint position = 0U;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (uri != NULL, 0U);
	position = GTK_INVALID_LIST_POSITION;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkStringList* _tmp2_;
				GtkStringList* _tmp3_;
				const gchar* _tmp4_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_play_queue;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->_play_queue;
				_tmp4_ = gtk_string_list_get_string (_tmp3_, i);
				if (g_strcmp0 (_tmp4_, uri) == 0) {
					position = i;
					break;
				}
			}
		}
	}
	result = position;
	return result;
}

AudiencePlaybackManager*
audience_playback_manager_construct (GType object_type)
{
	AudiencePlaybackManager * self = NULL;
	self = (AudiencePlaybackManager*) g_object_new (object_type, NULL);
	return self;
}

AudiencePlaybackManager*
audience_playback_manager_new (void)
{
	return audience_playback_manager_construct (AUDIENCE_TYPE_PLAYBACK_MANAGER);
}

GdkPaintable*
audience_playback_manager_get_gst_video_widget (AudiencePlaybackManager* self)
{
	GdkPaintable* result;
	GdkPaintable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gst_video_widget;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
audience_playback_manager_set_gst_video_widget (AudiencePlaybackManager* self,
                                                GdkPaintable* value)
{
	GdkPaintable* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_gst_video_widget (self);
	if (old_value != value) {
		GdkPaintable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gst_video_widget);
		self->priv->_gst_video_widget = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY]);
	}
}

const gchar*
audience_playback_manager_get_subtitle_uri (AudiencePlaybackManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subtitle_uri;
	result = _tmp0_;
	return result;
}

static void
audience_playback_manager_set_subtitle_uri (AudiencePlaybackManager* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_subtitle_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_subtitle_uri);
		self->priv->_subtitle_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY]);
	}
}

gboolean
audience_playback_manager_get_playing (AudiencePlaybackManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_playing;
	return result;
}

static void
audience_playback_manager_set_playing (AudiencePlaybackManager* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_playing (self);
	if (old_value != value) {
		self->priv->_playing = value;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY]);
	}
}

gint64
audience_playback_manager_get_duration (AudiencePlaybackManager* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_duration;
	return result;
}

static void
audience_playback_manager_set_duration (AudiencePlaybackManager* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY]);
	}
}

gint64
audience_playback_manager_get_position (AudiencePlaybackManager* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_position;
	return result;
}

static void
audience_playback_manager_set_position (AudiencePlaybackManager* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY]);
	}
}

GtkStringList*
audience_playback_manager_get_play_queue (AudiencePlaybackManager* self)
{
	GtkStringList* result;
	GtkStringList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_play_queue;
	result = _tmp0_;
	return result;
}

static void
audience_playback_manager_set_play_queue (AudiencePlaybackManager* self,
                                          GtkStringList* value)
{
	GtkStringList* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_playback_manager_get_play_queue (self);
	if (old_value != value) {
		GtkStringList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_play_queue);
		self->priv->_play_queue = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY]);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		AudiencePlaybackManager* self;
		self = _data10_->self;
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_audience_playback_manager_handle_bus_message_gst_bus_message (GstBus* _sender,
                                                               GstMessage* message,
                                                               gpointer self)
{
	audience_playback_manager_handle_bus_message ((AudiencePlaybackManager*) self, message);
}

static void
_audience_playback_manager___lambda13_ (AudiencePlaybackManager* self)
{
	const gchar* _tmp0_;
	GstElement* _tmp1_;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	_tmp0_ = self->priv->_subtitle_uri;
	_tmp1_ = self->priv->playbin;
	g_object_get (_tmp1_, "suburi", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp0_, (const gchar*) _tmp3_) != 0) {
		GstElement* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->playbin;
		g_object_get (_tmp4_, "suburi", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		audience_playback_manager_set_subtitle_uri (self, _tmp6_);
	}
}

static void
__audience_playback_manager___lambda13__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_audience_playback_manager___lambda13_ ((AudiencePlaybackManager*) self);
}

static void
_audience_playback_manager___lambda14_ (AudiencePlaybackManager* self)
{
	GstElement* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->playbin;
	g_object_get (_tmp0_, "uri", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_URI_CHANGED_SIGNAL], 0, _tmp2_);
}

static void
__audience_playback_manager___lambda14__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_audience_playback_manager___lambda14_ ((AudiencePlaybackManager*) self);
}

static void
_audience_playback_manager___lambda15_ (AudiencePlaybackManager* self,
                                        const gchar* name,
                                        GVariant* new_state)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (new_state != NULL);
	if (g_strcmp0 (name, AUDIENCE_APP_ACTION_PLAY_PAUSE) == 0) {
		gboolean should_play = FALSE;
		gboolean _tmp0_;
		should_play = g_variant_get_boolean (new_state);
		_tmp0_ = self->priv->_playing;
		if (_tmp0_ != should_play) {
			GstState _tmp1_ = 0;
			GstElement* _tmp2_;
			if (should_play) {
				_tmp1_ = GST_STATE_PLAYING;
			} else {
				_tmp1_ = GST_STATE_PAUSED;
			}
			_tmp2_ = self->priv->playbin;
			gst_element_set_state (_tmp2_, _tmp1_);
		}
	}
}

static void
__audience_playback_manager___lambda15__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                             const gchar* action_name,
                                                                             GVariant* state,
                                                                             gpointer self)
{
	_audience_playback_manager___lambda15_ ((AudiencePlaybackManager*) self, action_name, state);
}

static void
_audience_playback_manager_save_playlist_g_list_model_items_changed (GListModel* _sender,
                                                                     guint position,
                                                                     guint removed,
                                                                     guint added,
                                                                     gpointer self)
{
	audience_playback_manager_save_playlist ((AudiencePlaybackManager*) self);
}

static GVariant*
_variant_new11 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_audience_playback_manager___lambda16_ (Block10Data* _data10_)
{
	AudiencePlaybackManager* self;
	GAction* play_pause_action = NULL;
	GtkApplication* _tmp0_;
	GAction* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	gboolean _tmp4_;
	GVariant* _tmp5_;
	self = _data10_->self;
	_tmp0_ = _data10_->default_application;
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	play_pause_action = _tmp2_;
	_tmp3_ = play_pause_action;
	_tmp4_ = self->priv->_playing;
	_tmp5_ = _variant_new11 (_tmp4_);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction), _tmp5_);
	_g_variant_unref0 (_tmp5_);
	audience_playback_manager_update_position (self);
	_g_object_unref0 (play_pause_action);
}

static void
__audience_playback_manager___lambda16__g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	_audience_playback_manager___lambda16_ (self);
}

static gboolean
_audience_playback_manager___lambda17_ (AudiencePlaybackManager* self)
{
	gboolean result;
	audience_playback_manager_update_position (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
__audience_playback_manager___lambda17__gsource_func (gpointer self)
{
	gboolean result;
	result = _audience_playback_manager___lambda17_ ((AudiencePlaybackManager*) self);
	return result;
}

static GObject *
audience_playback_manager_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudiencePlaybackManager * self;
	Block10Data* _data10_;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GtkStringList* _tmp4_;
	GtkStringList* _tmp5_;
	GstElement* gtksink = NULL;
	GstElement* _tmp6_;
	GdkPaintable* _gst_video_widget = NULL;
	GstElement* _tmp7_;
	GdkPaintable* _tmp8_ = NULL;
	GdkPaintable* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GstBus* bus = NULL;
	GstElement* _tmp13_;
	GstBus* _tmp14_;
	GstBus* _tmp15_;
	GstBus* _tmp16_;
	GstElement* _tmp17_;
	GstElement* _tmp18_;
	GApplication* _tmp19_;
	GtkApplication* _tmp20_;
	GtkStringList* _tmp21_;
	parent_class = G_OBJECT_CLASS (audience_playback_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = audience_settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "last-played-videos");
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = gtk_string_list_new (_tmp3_);
	_tmp5_ = _tmp4_;
	audience_playback_manager_set_play_queue (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = gst_element_factory_make ("gtk4paintablesink", "sink");
	if (_tmp6_ != NULL) {
		g_object_ref_sink (_tmp6_);
	}
	gtksink = _tmp6_;
	_tmp7_ = gtksink;
	g_object_get ((GObject*) _tmp7_, "paintable", &_tmp8_, NULL);
	_g_object_unref0 (_gst_video_widget);
	_gst_video_widget = _tmp8_;
	_tmp9_ = _gst_video_widget;
	audience_playback_manager_set_gst_video_widget (self, _tmp9_);
	_tmp10_ = gst_element_factory_make ("playbin", "bin");
	if (_tmp10_ != NULL) {
		g_object_ref_sink (_tmp10_);
	}
	_g_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp10_;
	_tmp11_ = self->priv->playbin;
	_tmp12_ = gtksink;
	g_object_set (_tmp11_, "video-sink", _tmp12_, NULL);
	_tmp13_ = self->priv->playbin;
	_tmp14_ = gst_element_get_bus (_tmp13_);
	bus = _tmp14_;
	_tmp15_ = bus;
	gst_bus_add_signal_watch_full (_tmp15_, G_PRIORITY_DEFAULT);
	_tmp16_ = bus;
	g_signal_connect_object (_tmp16_, "message", (GCallback) _audience_playback_manager_handle_bus_message_gst_bus_message, self, 0);
	_tmp17_ = self->priv->playbin;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::suburi", (GCallback) __audience_playback_manager___lambda13__g_object_notify, self, 0);
	_tmp18_ = self->priv->playbin;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::uri", (GCallback) __audience_playback_manager___lambda14__g_object_notify, self, 0);
	_tmp19_ = g_application_get_default ();
	_data10_->default_application = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_application_get_type (), GtkApplication);
	_tmp20_ = _data10_->default_application;
	g_signal_connect_object ((GActionGroup*) _tmp20_, "action-state-changed", (GCallback) __audience_playback_manager___lambda15__g_action_group_action_state_changed, self, 0);
	_tmp21_ = self->priv->_play_queue;
	g_signal_connect_object ((GListModel*) _tmp21_, "items-changed", (GCallback) _audience_playback_manager_save_playlist_g_list_model_items_changed, self, 0);
	g_signal_connect_data ((GObject*) self, "notify::playing", (GCallback) __audience_playback_manager___lambda16__g_object_notify, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, __audience_playback_manager___lambda17__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (bus);
	_g_object_unref0 (_gst_video_widget);
	_g_object_unref0 (gtksink);
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return obj;
}

static void
audience_playback_manager_class_init (AudiencePlaybackManagerClass * klass,
                                      gpointer klass_data)
{
	audience_playback_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudiencePlaybackManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_playback_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_playback_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_playback_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_playback_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY] = g_param_spec_object ("gst-video-widget", "gst-video-widget", "gst-video-widget", gdk_paintable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY] = g_param_spec_string ("subtitle-uri", "subtitle-uri", "subtitle-uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY] = g_param_spec_boolean ("playing", "playing", "playing", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY] = g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY] = g_param_spec_int64 ("position", "position", "position", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY, audience_playback_manager_properties[AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY] = g_param_spec_object ("play-queue", "play-queue", "play-queue", gtk_string_list_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_ENDED_SIGNAL] = g_signal_new ("ended", AUDIENCE_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_NEXT_AUDIO_SIGNAL] = g_signal_new ("next-audio", AUDIENCE_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_NEXT_TEXT_SIGNAL] = g_signal_new ("next-text", AUDIENCE_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	audience_playback_manager_signals[AUDIENCE_PLAYBACK_MANAGER_URI_CHANGED_SIGNAL] = g_signal_new ("uri-changed", AUDIENCE_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
audience_playback_manager_instance_init (AudiencePlaybackManager * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = audience_playback_manager_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_subtitle_uri = _tmp0_;
	self->priv->_duration = (gint64) 0;
	self->priv->_position = (gint64) 0;
	self->priv->is_seeking = FALSE;
	self->priv->queued_seek = (gint64) -1;
	self->priv->inhibit_token = (guint) 0;
}

static void
audience_playback_manager_finalize (GObject * obj)
{
	AudiencePlaybackManager * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager);
	_tmp0_ = self->priv->_duration;
	_tmp1_ = self->priv->_position;
	if (_tmp0_ == _tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = audience_settings;
		g_settings_set_int64 (_tmp2_, "last-stopped", (gint64) 0);
	} else {
		GstElement* _tmp3_;
		GstElement* _tmp4_;
		GstElement* _tmp5_;
		_tmp3_ = self->priv->playbin;
		g_object_get (_tmp3_, "current-uri", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (g_strcmp0 ((const gchar*) _tmp5_, "") != 0) {
			GSettings* _tmp6_;
			gint64 _tmp7_;
			_tmp6_ = audience_settings;
			_tmp7_ = self->priv->_position;
			g_settings_set_int64 (_tmp6_, "last-stopped", _tmp7_);
		}
	}
	if (self->priv->inhibit_token != ((guint) 0)) {
		GApplication* _tmp8_;
		_tmp8_ = g_application_get_default ();
		gtk_application_uninhibit (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication), self->priv->inhibit_token);
		self->priv->inhibit_token = (guint) 0;
	}
	_g_object_unref0 (self->priv->_gst_video_widget);
	_g_free0 (self->priv->_subtitle_uri);
	_g_object_unref0 (self->priv->_play_queue);
	_g_object_unref0 (self->priv->playbin);
	G_OBJECT_CLASS (audience_playback_manager_parent_class)->finalize (obj);
}

static GType
audience_playback_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudiencePlaybackManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_playback_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudiencePlaybackManager), 0, (GInstanceInitFunc) audience_playback_manager_instance_init, NULL };
	GType audience_playback_manager_type_id;
	audience_playback_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "AudiencePlaybackManager", &g_define_type_info, 0);
	AudiencePlaybackManager_private_offset = g_type_add_instance_private (audience_playback_manager_type_id, sizeof (AudiencePlaybackManagerPrivate));
	return audience_playback_manager_type_id;
}

GType
audience_playback_manager_get_type (void)
{
	static volatile gsize audience_playback_manager_type_id__once = 0;
	if (g_once_init_enter (&audience_playback_manager_type_id__once)) {
		GType audience_playback_manager_type_id;
		audience_playback_manager_type_id = audience_playback_manager_get_type_once ();
		g_once_init_leave (&audience_playback_manager_type_id__once, audience_playback_manager_type_id);
	}
	return audience_playback_manager_type_id__once;
}

static void
_vala_audience_playback_manager_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	AudiencePlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager);
	switch (property_id) {
		case AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY:
		g_value_set_object (value, audience_playback_manager_get_gst_video_widget (self));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY:
		g_value_set_string (value, audience_playback_manager_get_subtitle_uri (self));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY:
		g_value_set_boolean (value, audience_playback_manager_get_playing (self));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY:
		g_value_set_int64 (value, audience_playback_manager_get_duration (self));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY:
		g_value_set_int64 (value, audience_playback_manager_get_position (self));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY:
		g_value_set_object (value, audience_playback_manager_get_play_queue (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_playback_manager_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	AudiencePlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager);
	switch (property_id) {
		case AUDIENCE_PLAYBACK_MANAGER_GST_VIDEO_WIDGET_PROPERTY:
		audience_playback_manager_set_gst_video_widget (self, g_value_get_object (value));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_SUBTITLE_URI_PROPERTY:
		audience_playback_manager_set_subtitle_uri (self, g_value_get_string (value));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_PLAYING_PROPERTY:
		audience_playback_manager_set_playing (self, g_value_get_boolean (value));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_DURATION_PROPERTY:
		audience_playback_manager_set_duration (self, g_value_get_int64 (value));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_POSITION_PROPERTY:
		audience_playback_manager_set_position (self, g_value_get_int64 (value));
		break;
		case AUDIENCE_PLAYBACK_MANAGER_PLAY_QUEUE_PROPERTY:
		audience_playback_manager_set_play_queue (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

