/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
* Copyright (c) 2011-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3, as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

VALA_EXTERN gchar* terminal_utils_sanitize_path (const gchar* _path,
                                     const gchar* shell_location,
                                     gboolean add_file_scheme);
VALA_EXTERN gchar* terminal_utils_strip_uri (const gchar* _uri);
VALA_EXTERN gchar* terminal_utils_construct_parent_path (const gchar* path);
VALA_EXTERN gchar* terminal_utils_get_parent_path_from_path (const gchar* path);
VALA_EXTERN gboolean terminal_utils_is_safe_paste (const gchar* text,
                                       gchar*** msg_array,
                                       gint* msg_array_length1);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN gchar* terminal_utils_escape_uri (const gchar* uri,
                                  gboolean allow_utf8,
                                  gboolean allow_single_quote);
VALA_EXTERN GSimpleAction* terminal_utils_action_from_group (const gchar* action_name,
                                                 GSimpleActionGroup* action_group);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
terminal_utils_sanitize_path (const gchar* _path,
                              const gchar* shell_location,
                              gboolean add_file_scheme)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	gchar* path = NULL;
	gchar* _tmp1_;
	gchar** parts_scheme = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint parts_scheme_length1;
	gint _parts_scheme_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** parts_sep = NULL;
	const gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint parts_sep_length1;
	gint _parts_sep_size_;
	gint index = 0;
	gchar** _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_;
	gchar* _result_ = NULL;
	const gchar* _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* result;
	g_return_val_if_fail (_path != NULL, NULL);
	g_return_val_if_fail (shell_location != NULL, NULL);
	_tmp0_ = g_strdup ("");
	scheme = _tmp0_;
	_tmp1_ = g_strdup ("");
	path = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (_path, "://", 2);
	parts_scheme = _tmp3_;
	parts_scheme_length1 = _vala_array_length (_tmp2_);
	_parts_scheme_size_ = parts_scheme_length1;
	_tmp4_ = parts_scheme;
	_tmp4__length1 = parts_scheme_length1;
	if (_tmp4__length1 == 2) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = parts_scheme;
		_tmp5__length1 = parts_scheme_length1;
		_tmp6_ = _tmp5_[0];
		_tmp7_ = g_strconcat (_tmp6_, "://", NULL);
		_g_free0 (scheme);
		scheme = _tmp7_;
		_tmp8_ = parts_scheme;
		_tmp8__length1 = parts_scheme_length1;
		_tmp9_ = _tmp8_[1];
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (path);
		path = _tmp10_;
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = parts_scheme;
		_tmp11__length1 = parts_scheme_length1;
		if (_tmp11__length1 == 1) {
			gchar* _tmp13_;
			if (add_file_scheme) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("file://");
				_g_free0 (scheme);
				scheme = _tmp12_;
			}
			_tmp13_ = g_strdup (_path);
			_g_free0 (path);
			path = _tmp13_;
		} else {
			g_critical ("Utils.vala:35: Invalid path");
			result = NULL;
			parts_scheme = (_vala_array_free (parts_scheme, parts_scheme_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (path);
			_g_free0 (scheme);
			return result;
		}
	}
	_tmp14_ = path;
	_tmp15_ = g_uri_unescape_string (_tmp14_, NULL);
	_g_free0 (path);
	path = _tmp15_;
	_tmp16_ = path;
	if (_tmp16_ == NULL) {
		result = NULL;
		parts_scheme = (_vala_array_free (parts_scheme, parts_scheme_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (path);
		_g_free0 (scheme);
		return result;
	}
	_tmp17_ = path;
	_tmp18_ = terminal_utils_strip_uri (_tmp17_);
	_g_free0 (path);
	path = _tmp18_;
	{
		gboolean _tmp19_ = FALSE;
		_tmp19_ = TRUE;
		while (TRUE) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			if (!_tmp19_) {
				const gchar* _tmp20_;
				_tmp20_ = path;
				if (!string_contains (_tmp20_, "//")) {
					break;
				}
			}
			_tmp19_ = FALSE;
			_tmp21_ = path;
			_tmp22_ = string_replace (_tmp21_, "//", "/");
			_g_free0 (path);
			path = _tmp22_;
		}
	}
	_tmp23_ = path;
	_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, G_DIR_SEPARATOR_S, 3);
	parts_sep = _tmp25_;
	parts_sep_length1 = _vala_array_length (_tmp24_);
	_parts_sep_size_ = parts_sep_length1;
	index = 0;
	while (TRUE) {
		gboolean _tmp26_ = FALSE;
		gchar** _tmp27_;
		gint _tmp27__length1;
		const gchar* _tmp28_;
		gint _tmp30_;
		_tmp27_ = parts_sep;
		_tmp27__length1 = parts_sep_length1;
		_tmp28_ = _tmp27_[index];
		if (_tmp28_ == NULL) {
			gchar** _tmp29_;
			gint _tmp29__length1;
			_tmp29_ = parts_sep;
			_tmp29__length1 = parts_sep_length1;
			_tmp26_ = index < (_tmp29__length1 - 1);
		} else {
			_tmp26_ = FALSE;
		}
		if (!_tmp26_) {
			break;
		}
		_tmp30_ = index;
		index = _tmp30_ + 1;
	}
	_tmp31_ = parts_sep;
	_tmp31__length1 = parts_sep_length1;
	_tmp32_ = _tmp31_[index];
	if (g_strcmp0 (_tmp32_, "~") == 0) {
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp33_ = parts_sep;
		_tmp33__length1 = parts_sep_length1;
		_tmp34_ = g_get_home_dir ();
		_tmp35_ = g_strdup (_tmp34_);
		_g_free0 (_tmp33_[index]);
		_tmp33_[index] = _tmp35_;
	} else {
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		_tmp36_ = parts_sep;
		_tmp36__length1 = parts_sep_length1;
		_tmp37_ = _tmp36_[index];
		if (g_strcmp0 (_tmp37_, ".") == 0) {
			gchar** _tmp38_;
			gint _tmp38__length1;
			gchar* _tmp39_;
			_tmp38_ = parts_sep;
			_tmp38__length1 = parts_sep_length1;
			_tmp39_ = g_strdup (shell_location);
			_g_free0 (_tmp38_[index]);
			_tmp38_[index] = _tmp39_;
		} else {
			gchar** _tmp40_;
			gint _tmp40__length1;
			const gchar* _tmp41_;
			_tmp40_ = parts_sep;
			_tmp40__length1 = parts_sep_length1;
			_tmp41_ = _tmp40_[index];
			if (g_strcmp0 (_tmp41_, "..") == 0) {
				gchar** _tmp42_;
				gint _tmp42__length1;
				gchar* _tmp43_;
				_tmp42_ = parts_sep;
				_tmp42__length1 = parts_sep_length1;
				_tmp43_ = terminal_utils_construct_parent_path (shell_location);
				_g_free0 (_tmp42_[index]);
				_tmp42_[index] = _tmp43_;
			}
		}
	}
	_tmp44_ = scheme;
	_tmp45_ = parts_sep;
	_tmp45__length1 = parts_sep_length1;
	_tmp46_ = _vala_g_strjoinv (G_DIR_SEPARATOR_S, _tmp45_, (gint) _tmp45__length1);
	_tmp47_ = _tmp46_;
	_tmp48_ = string_replace (_tmp47_, "//", "/");
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strconcat (_tmp44_, _tmp49_, NULL);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	_g_free0 (_tmp47_);
	_result_ = _tmp51_;
	result = _result_;
	parts_sep = (_vala_array_free (parts_sep, parts_sep_length1, (GDestroyNotify) g_free), NULL);
	parts_scheme = (_vala_array_free (parts_scheme, parts_scheme_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (path);
	_g_free0 (scheme);
	return result;
}

/*** Simplified version of PF.FileUtils function, with fewer checks ***/
static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
terminal_utils_get_parent_path_from_path (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	GString* string_builder = NULL;
	GString* _tmp3_;
	gint last_separator = 0;
	GString* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < 2) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (G_DIR_SEPARATOR_S);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_new (path);
	string_builder = _tmp3_;
	if (g_str_has_suffix (path, G_DIR_SEPARATOR_S)) {
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = string_builder;
		_tmp5_ = string_builder;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		g_string_erase (_tmp4_, (gssize) (_tmp8_ - 1), (gssize) -1);
	}
	_tmp9_ = string_builder;
	_tmp10_ = _tmp9_->str;
	last_separator = string_last_index_of (_tmp10_, G_DIR_SEPARATOR_S, 0);
	if (last_separator < 0) {
		last_separator = 0;
	}
	_tmp11_ = string_builder;
	g_string_erase (_tmp11_, (gssize) last_separator, (gssize) -1);
	_tmp12_ = string_builder;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strconcat (_tmp13_, G_DIR_SEPARATOR_S, NULL);
	result = _tmp14_;
	_g_string_free0 (string_builder);
	return result;
}

gchar*
terminal_utils_construct_parent_path (const gchar* path)
{
	gint _tmp0_;
	gint _tmp1_;
	GString* sb = NULL;
	GString* _tmp3_;
	gint last_separator = 0;
	GString* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp11_;
	gchar* parent_path = NULL;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = strlen (path);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < 2) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (G_DIR_SEPARATOR_S);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_new (path);
	sb = _tmp3_;
	if (g_str_has_suffix (path, G_DIR_SEPARATOR_S)) {
		GString* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = sb;
		_tmp5_ = sb;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		g_string_erase (_tmp4_, (gssize) (_tmp8_ - 1), (gssize) -1);
	}
	_tmp9_ = sb;
	_tmp10_ = _tmp9_->str;
	last_separator = string_last_index_of (_tmp10_, G_DIR_SEPARATOR_S, 0);
	if (last_separator < 0) {
		last_separator = 0;
	}
	_tmp11_ = sb;
	g_string_erase (_tmp11_, (gssize) last_separator, (gssize) -1);
	_tmp12_ = sb;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strconcat (_tmp13_, G_DIR_SEPARATOR_S, NULL);
	parent_path = _tmp14_;
	result = parent_path;
	_g_string_free0 (sb);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
terminal_utils_strip_uri (const gchar* _uri)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (_uri);
	uri = _tmp0_;
	if (_uri != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = uri;
		_tmp2_ = string_strip (_tmp1_);
		_g_free0 (uri);
		uri = _tmp2_;
		_tmp3_ = uri;
		_tmp4_ = string_replace (_tmp3_, "\n", "");
		_g_free0 (uri);
		uri = _tmp4_;
		_tmp5_ = uri;
		_tmp6_ = string_replace (_tmp5_, "\r", "");
		_g_free0 (uri);
		uri = _tmp6_;
	}
	result = uri;
	return result;
}

/**
     * Checks a string for possible unsafe contents before pasting
     *
     * @param clipboard contents containing terminal commands
     *
     * @param return localized explanation of risk
     *
     * @return true if safe, false if unsafe.
     */
static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gboolean
terminal_utils_is_safe_paste (const gchar* text,
                              gchar*** msg_array,
                              gint* msg_array_length1)
{
	gchar** _vala_msg_array = NULL;
	gint _vala_msg_array_length1 = 0;
	gchar** msgs = NULL;
	gchar** _tmp0_;
	gint msgs_length1;
	gint _msgs_size_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gchar** skip_commands = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint skip_commands_length1;
	gint _skip_commands_size_;
	gchar** words = NULL;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	msgs = _tmp0_;
	msgs_length1 = 0;
	_msgs_size_ = msgs_length1;
	if (string_contains (text, "\n")) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = string_contains (text, "&");
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = string_contains (text, "|");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_contains (text, ";");
	}
	if (_tmp1_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("The pasted text may contain multiple commands"));
		_vala_array_add16 (&msgs, &msgs_length1, &_msgs_size_, _tmp4_);
	}
	if (string_contains (text, "sudo ")) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = string_contains (text, "doas ");
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = string_contains (text, "run0 ");
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = string_contains (text, "pkexec ");
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = string_contains (text, "su ");
	}
	if (_tmp5_) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("The pasted text may be trying to gain administrative access"));
		_vala_array_add17 (&msgs, &msgs_length1, &_msgs_size_, _tmp9_);
	}
	_tmp10_ = g_strdup ("--assume-yes");
	_tmp11_ = g_strdup ("-f");
	_tmp12_ = g_strdup ("--force");
	_tmp13_ = g_strdup ("--interactive=never");
	_tmp14_ = g_strdup ("-y");
	_tmp15_ = g_strdup ("--yes");
	_tmp16_ = g_new0 (gchar*, 6 + 1);
	_tmp16_[0] = _tmp10_;
	_tmp16_[1] = _tmp11_;
	_tmp16_[2] = _tmp12_;
	_tmp16_[3] = _tmp13_;
	_tmp16_[4] = _tmp14_;
	_tmp16_[5] = _tmp15_;
	skip_commands = _tmp16_;
	skip_commands_length1 = 6;
	_skip_commands_size_ = skip_commands_length1;
	_tmp18_ = _tmp17_ = g_strsplit (text, " ", 0);
	words = _tmp18_;
	words_length1 = _vala_array_length (_tmp17_);
	_words_size_ = words_length1;
	_tmp19_ = skip_commands;
	_tmp19__length1 = skip_commands_length1;
	{
		gchar** skip_command_collection = NULL;
		gint skip_command_collection_length1 = 0;
		gint _skip_command_collection_size_ = 0;
		gint skip_command_it = 0;
		skip_command_collection = _tmp19_;
		skip_command_collection_length1 = _tmp19__length1;
		for (skip_command_it = 0; skip_command_it < skip_command_collection_length1; skip_command_it = skip_command_it + 1) {
			const gchar* skip_command = NULL;
			skip_command = skip_command_collection[skip_command_it];
			{
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp20_ = skip_command;
				_tmp21_ = words;
				_tmp21__length1 = words_length1;
				if (_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
					gchar* _tmp22_;
					_tmp22_ = g_strdup (_ ("The pasted text includes a command to skip warnings and confirmations"));
					_vala_array_add18 (&msgs, &msgs_length1, &_msgs_size_, _tmp22_);
					break;
				}
			}
		}
	}
	_tmp23_ = msgs;
	_tmp23__length1 = msgs_length1;
	if (_tmp23__length1 > 0) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp24_ = msgs;
		_tmp24__length1 = msgs_length1;
		_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup2 (_tmp24_, _tmp24__length1) : _tmp24_;
		_tmp25__length1 = _tmp24__length1;
		_vala_msg_array = (_vala_array_free (_vala_msg_array, _vala_msg_array_length1, (GDestroyNotify) g_free), NULL);
		_vala_msg_array = _tmp25_;
		_vala_msg_array_length1 = _tmp25__length1;
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		skip_commands = (_vala_array_free (skip_commands, skip_commands_length1, (GDestroyNotify) g_free), NULL);
		msgs = (_vala_array_free (msgs, msgs_length1, (GDestroyNotify) g_free), NULL);
		if (msg_array) {
			*msg_array = _vala_msg_array;
		} else {
			_vala_msg_array = (_vala_array_free (_vala_msg_array, _vala_msg_array_length1, (GDestroyNotify) g_free), NULL);
		}
		if (msg_array_length1) {
			*msg_array_length1 = _vala_msg_array_length1;
		}
		return result;
	} else {
		_vala_msg_array = (_vala_array_free (_vala_msg_array, _vala_msg_array_length1, (GDestroyNotify) g_free), NULL);
		_vala_msg_array = NULL;
		_vala_msg_array_length1 = 0;
		result = TRUE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		skip_commands = (_vala_array_free (skip_commands, skip_commands_length1, (GDestroyNotify) g_free), NULL);
		msgs = (_vala_array_free (msgs, msgs_length1, (GDestroyNotify) g_free), NULL);
		if (msg_array) {
			*msg_array = _vala_msg_array;
		} else {
			_vala_msg_array = (_vala_array_free (_vala_msg_array, _vala_msg_array_length1, (GDestroyNotify) g_free), NULL);
		}
		if (msg_array_length1) {
			*msg_array_length1 = _vala_msg_array_length1;
		}
		return result;
	}
}

gchar*
terminal_utils_escape_uri (const gchar* uri,
                           gboolean allow_utf8,
                           gboolean allow_single_quote)
{
	gchar* placeholder = NULL;
	gchar* _tmp0_;
	gchar** parts = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* uri_to_escape = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gchar* rc = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_strdup ("::::::");
	placeholder = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (uri, G_DIR_SEPARATOR_S, 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	_tmp5_ = parts;
	_tmp5__length1 = parts_length1;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	_tmp7_ = _tmp5_[_tmp6__length1 - 1];
	_tmp8_ = placeholder;
	_tmp9_ = string_replace (_tmp7_, "#", _tmp8_);
	_g_free0 (_tmp3_[_tmp4__length1 - 1]);
	_tmp3_[_tmp4__length1 - 1] = _tmp9_;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	_tmp11_ = _vala_g_strjoinv (G_DIR_SEPARATOR_S, _tmp10_, (gint) _tmp10__length1);
	uri_to_escape = _tmp11_;
	_tmp12_ = string_replace (G_URI_RESERVED_CHARS_GENERIC_DELIMITERS G_URI_RESERVED_CHARS_SUBCOMPONENT_DELIMITERS, "#", "");
	_tmp13_ = _tmp12_;
	_tmp14_ = string_replace (_tmp13_, "*", "");
	_tmp15_ = _tmp14_;
	_tmp16_ = string_replace (_tmp15_, "~", "");
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	rc = _tmp17_;
	if (!allow_single_quote) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = rc;
		_tmp19_ = string_replace (_tmp18_, "'", "");
		_g_free0 (rc);
		rc = _tmp19_;
	}
	_tmp21_ = uri_to_escape;
	_tmp22_ = g_uri_unescape_string (_tmp21_, NULL);
	_tmp20_ = _tmp22_;
	if (_tmp20_ == NULL) {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp23_ = uri_to_escape;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (_tmp20_);
		_tmp20_ = _tmp24_;
	}
	_tmp25_ = rc;
	_tmp26_ = g_uri_escape_string (_tmp20_, _tmp25_, allow_utf8);
	_tmp27_ = _tmp26_;
	_tmp28_ = placeholder;
	_tmp29_ = string_replace (_tmp27_, _tmp28_, "#");
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp27_);
	result = _tmp30_;
	_g_free0 (_tmp20_);
	_g_free0 (rc);
	_g_free0 (uri_to_escape);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (placeholder);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSimpleAction*
terminal_utils_action_from_group (const gchar* action_name,
                                  GSimpleActionGroup* action_group)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (action_name != NULL, NULL);
	g_return_val_if_fail (action_group != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) action_group, action_name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

