/* Settings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Settings.vala, do not modify */

/*-
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 * Copyright 2021 Alexander Mikhaylenko <alexm@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
 * Boston, MA 02110-1335 USA.
 */

#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PORTAL_ERROR (portal_error_get_type ())

#define PANTHEON_TYPE_ACCOUNTS_SERVICE (pantheon_accounts_service_get_type ())
#define PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsService))
#define PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_TYPE_ACCOUNTS_SERVICE, PantheonAccountsServiceIface))

typedef struct _PantheonAccountsService PantheonAccountsService;
typedef struct _PantheonAccountsServiceIface PantheonAccountsServiceIface;

#define PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (pantheon_accounts_service_proxy_get_type ())
typedef GDBusProxy PantheonAccountsServiceProxy;
typedef GDBusProxyClass PantheonAccountsServiceProxyClass;

#define SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE (settings_daemon_accounts_service_get_type ())
#define SETTINGS_DAEMON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, SettingsDaemonAccountsService))
#define SETTINGS_DAEMON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE))
#define SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, SettingsDaemonAccountsServiceIface))

typedef struct _SettingsDaemonAccountsService SettingsDaemonAccountsService;
typedef struct _SettingsDaemonAccountsServiceIface SettingsDaemonAccountsServiceIface;

#define SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY (settings_daemon_accounts_service_proxy_get_type ())
typedef GDBusProxy SettingsDaemonAccountsServiceProxy;
typedef GDBusProxyClass SettingsDaemonAccountsServiceProxyClass;

#define FDO_TYPE_ACCOUNTS (fdo_accounts_get_type ())
#define FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FDO_TYPE_ACCOUNTS, FDOAccounts))
#define FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FDO_TYPE_ACCOUNTS))
#define FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FDO_TYPE_ACCOUNTS, FDOAccountsIface))

typedef struct _FDOAccounts FDOAccounts;
typedef struct _FDOAccountsIface FDOAccountsIface;

#define FDO_TYPE_ACCOUNTS_PROXY (fdo_accounts_proxy_get_type ())
typedef GDBusProxy FDOAccountsProxy;
typedef GDBusProxyClass FDOAccountsProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ACCOUNTS_SERVICE_MONITOR (accounts_service_monitor_get_type ())
#define ACCOUNTS_SERVICE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitor))
#define ACCOUNTS_SERVICE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitorClass))
#define IS_ACCOUNTS_SERVICE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_SERVICE_MONITOR))
#define IS_ACCOUNTS_SERVICE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNTS_SERVICE_MONITOR))
#define ACCOUNTS_SERVICE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitorClass))

typedef struct _AccountsServiceMonitor AccountsServiceMonitor;
typedef struct _AccountsServiceMonitorClass AccountsServiceMonitorClass;
typedef struct _AccountsServiceMonitorPrivate AccountsServiceMonitorPrivate;
enum  {
	ACCOUNTS_SERVICE_MONITOR_0_PROPERTY,
	ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY,
	ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY,
	ACCOUNTS_SERVICE_MONITOR_NUM_PROPERTIES
};
static GParamSpec* accounts_service_monitor_properties[ACCOUNTS_SERVICE_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define SETTINGS_DAEMON_TYPE_SETTINGS (settings_daemon_settings_get_type ())
#define SETTINGS_DAEMON_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettings))
#define SETTINGS_DAEMON_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettingsClass))
#define SETTINGS_DAEMON_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_TYPE_SETTINGS))
#define SETTINGS_DAEMON_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_TYPE_SETTINGS))
#define SETTINGS_DAEMON_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettingsClass))

typedef struct _SettingsDaemonSettings SettingsDaemonSettings;
typedef struct _SettingsDaemonSettingsClass SettingsDaemonSettingsClass;
typedef struct _SettingsDaemonSettingsPrivate SettingsDaemonSettingsPrivate;
enum  {
	SETTINGS_DAEMON_SETTINGS_0_PROPERTY,
	SETTINGS_DAEMON_SETTINGS_VERSION_PROPERTY,
	SETTINGS_DAEMON_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* settings_daemon_settings_properties[SETTINGS_DAEMON_SETTINGS_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _SettingsDaemonSettingsReadAllData SettingsDaemonSettingsReadAllData;
typedef struct _SettingsDaemonSettingsReadData SettingsDaemonSettingsReadData;
typedef struct _Block2Data Block2Data;
enum  {
	SETTINGS_DAEMON_SETTINGS_SETTING_CHANGED_SIGNAL,
	SETTINGS_DAEMON_SETTINGS_NUM_SIGNALS
};
static guint settings_daemon_settings_signals[SETTINGS_DAEMON_SETTINGS_NUM_SIGNALS] = {0};
typedef struct _SettingsDaemonSettingsReadAllReadyData SettingsDaemonSettingsReadAllReadyData;
typedef struct _SettingsDaemonSettingsReadReadyData SettingsDaemonSettingsReadReadyData;

typedef enum  {
	PORTAL_ERROR_FAILED,
	PORTAL_ERROR_INVALID_ARGUMENT,
	PORTAL_ERROR_NOT_FOUND,
	PORTAL_ERROR_EXISTS,
	PORTAL_ERROR_NOT_ALLOWED,
	PORTAL_ERROR_CANCELLED,
	PORTAL_ERROR_WINDOW_DESTROYED
} PortalError;
#define PORTAL_ERROR portal_error_quark ()

struct _PantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_color_scheme) (PantheonAccountsService* self);
	void (*set_prefers_color_scheme) (PantheonAccountsService* self, gint value);
	gint (*get_prefers_accent_color) (PantheonAccountsService* self);
	void (*set_prefers_accent_color) (PantheonAccountsService* self, gint value);
};

struct _SettingsDaemonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_accent_color) (SettingsDaemonAccountsService* self);
	void (*set_accent_color) (SettingsDaemonAccountsService* self, gint value);
};

struct _FDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (FDOAccounts* self, const gchar* username, GError** error);
};

struct _AccountsServiceMonitor {
	GObject parent_instance;
	AccountsServiceMonitorPrivate * priv;
};

struct _AccountsServiceMonitorClass {
	GObjectClass parent_class;
};

struct _AccountsServiceMonitorPrivate {
	FDOAccounts* accounts_service;
	PantheonAccountsService* pantheon_act;
	SettingsDaemonAccountsService* settings_daemon_act;
	gchar* user_path;
	gint32 _color_scheme;
	gint32 _accent_color;
};

struct _SettingsDaemonSettings {
	GObject parent_instance;
	SettingsDaemonSettingsPrivate * priv;
};

struct _SettingsDaemonSettingsClass {
	GObjectClass parent_class;
};

struct _SettingsDaemonSettingsPrivate {
	GHashTable* settings;
	AccountsServiceMonitor* monitor;
};

struct _Block1Data {
	int _ref_count_;
	SettingsDaemonSettings* self;
	GHashTable* ret;
	gchar** namespaces;
	gint namespaces_length1;
	gpointer _async_data_;
};

struct _SettingsDaemonSettingsReadAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonSettings* self;
	gchar** namespaces;
	gint namespaces_length1;
	GHashTable* result;
	Block1Data* _data1_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
};

struct _SettingsDaemonSettingsReadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonSettings* self;
	gchar* namespace;
	gchar* key;
	GVariant* result;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GSettings* setting;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gboolean _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettingsSchema* _tmp7_;
	GSettingsSchema* _tmp8_;
	GSettingsSchema* _tmp9_;
	GSettings* _tmp10_;
	GVariant* _tmp11_;
	GError* _tmp12_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	SettingsDaemonSettings* self;
	const gchar* schema;
};

struct _SettingsDaemonSettingsReadAllReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** namespaces;
	gint namespaces_length1;
};

struct _SettingsDaemonSettingsReadReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* namespace;
	gchar* key;
};

static gint AccountsServiceMonitor_private_offset;
static gpointer accounts_service_monitor_parent_class = NULL;
static gint SettingsDaemonSettings_private_offset;
static gpointer settings_daemon_settings_parent_class = NULL;

VALA_EXTERN GQuark portal_error_quark (void);
VALA_EXTERN GType portal_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonAccountsService, g_object_unref)
VALA_EXTERN GType pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_accounts_service_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN gint pantheon_accounts_service_get_prefers_color_scheme (PantheonAccountsService* self);
VALA_EXTERN void pantheon_accounts_service_set_prefers_color_scheme (PantheonAccountsService* self,
                                                         gint value);
VALA_EXTERN gint pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self);
VALA_EXTERN void pantheon_accounts_service_set_prefers_accent_color (PantheonAccountsService* self,
                                                         gint value);
static GType pantheon_accounts_service_get_type_once (void);
static void pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters);
static gint pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (PantheonAccountsService* self);
static void pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (PantheonAccountsService* self,
                                                                    gint value);
static gint pantheon_accounts_service_dbus_proxy_get_prefers_accent_color (PantheonAccountsService* self);
static void pantheon_accounts_service_dbus_proxy_set_prefers_accent_color (PantheonAccountsService* self,
                                                                    gint value);
static void pantheon_accounts_service_proxy_pantheon_accounts_service_interface_init (PantheonAccountsServiceIface* iface);
static void pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static GVariant* _dbus_pantheon_accounts_service_get_prefers_color_scheme (PantheonAccountsService* self);
static GVariant* _dbus_pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self);
static gboolean pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_pantheon_accounts_service_set_prefers_color_scheme (PantheonAccountsService* self,
                                                               GVariant* _value);
static void _dbus_pantheon_accounts_service_set_prefers_accent_color (PantheonAccountsService* self,
                                                               GVariant* _value);
static void _pantheon_accounts_service_unregister_object (gpointer user_data);
VALA_EXTERN GType settings_daemon_accounts_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonAccountsService, g_object_unref)
VALA_EXTERN GType settings_daemon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint settings_daemon_accounts_service_register_object (void* object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error);
VALA_EXTERN gint settings_daemon_accounts_service_get_accent_color (SettingsDaemonAccountsService* self);
VALA_EXTERN void settings_daemon_accounts_service_set_accent_color (SettingsDaemonAccountsService* self,
                                                        gint value);
static GType settings_daemon_accounts_service_get_type_once (void);
static void settings_daemon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                      const gchar* sender_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters);
static gint settings_daemon_accounts_service_dbus_proxy_get_accent_color (SettingsDaemonAccountsService* self);
static void settings_daemon_accounts_service_dbus_proxy_set_accent_color (SettingsDaemonAccountsService* self,
                                                                   gint value);
static void settings_daemon_accounts_service_proxy_settings_daemon_accounts_service_interface_init (SettingsDaemonAccountsServiceIface* iface);
static void settings_daemon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* method_name,
                                                                  GVariant* parameters,
                                                                  GDBusMethodInvocation* invocation,
                                                                  gpointer user_data);
static GVariant* settings_daemon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GError** error,
                                                                        gpointer user_data);
static GVariant* _dbus_settings_daemon_accounts_service_get_accent_color (SettingsDaemonAccountsService* self);
static gboolean settings_daemon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GVariant* value,
                                                                       GError** error,
                                                                       gpointer user_data);
static void _dbus_settings_daemon_accounts_service_set_accent_color (SettingsDaemonAccountsService* self,
                                                              GVariant* _value);
static void _settings_daemon_accounts_service_unregister_object (gpointer user_data);
VALA_EXTERN GType fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint fdo_accounts_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType fdo_accounts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FDOAccounts, g_object_unref)
VALA_EXTERN gchar* fdo_accounts_find_user_by_name (FDOAccounts* self,
                                       const gchar* username,
                                       GError** error);
static GType fdo_accounts_get_type_once (void);
static void fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static gchar* fdo_accounts_proxy_find_user_by_name (FDOAccounts* self,
                                             const gchar* username,
                                             GError** error);
static void fdo_accounts_proxy_fdo_accounts_interface_init (FDOAccountsIface* iface);
static void _dbus_fdo_accounts_find_user_by_name (FDOAccounts* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _fdo_accounts_unregister_object (gpointer user_data);
VALA_EXTERN GType accounts_service_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AccountsServiceMonitor, g_object_unref)
static void accounts_service_monitor_setup_user_path (AccountsServiceMonitor* self);
static void accounts_service_monitor_setup_prefers_color_scheme (AccountsServiceMonitor* self);
VALA_EXTERN void accounts_service_monitor_set_color_scheme (AccountsServiceMonitor* self,
                                                gint32 value);
static void ___lambda4_ (AccountsServiceMonitor* self,
                  GVariant* changed,
                  gchar** invalid);
static void ____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void accounts_service_monitor_setup_prefers_accent_color (AccountsServiceMonitor* self);
VALA_EXTERN void accounts_service_monitor_set_accent_color (AccountsServiceMonitor* self,
                                                gint32 value);
static void ___lambda5_ (AccountsServiceMonitor* self,
                  GVariant* changed,
                  gchar** invalid);
static void ____lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
VALA_EXTERN AccountsServiceMonitor* accounts_service_monitor_new (void);
VALA_EXTERN AccountsServiceMonitor* accounts_service_monitor_construct (GType object_type);
VALA_EXTERN gint32 accounts_service_monitor_get_color_scheme (AccountsServiceMonitor* self);
VALA_EXTERN gint32 accounts_service_monitor_get_accent_color (AccountsServiceMonitor* self);
static GObject * accounts_service_monitor_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void accounts_service_monitor_finalize (GObject * obj);
static GType accounts_service_monitor_get_type_once (void);
static void _vala_accounts_service_monitor_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_accounts_service_monitor_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
VALA_EXTERN GType settings_daemon_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonSettings, g_object_unref)
VALA_EXTERN guint settings_daemon_settings_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
static gboolean settings_daemon_settings_namespace_matches (SettingsDaemonSettings* self,
                                                     const gchar* namespace,
                                                     gchar** patterns,
                                                     gint patterns_length1);
static GVariant* settings_daemon_settings_get_color_scheme (SettingsDaemonSettings* self);
static inline GVariant* settings_daemon_settings_rgb_to_variant (SettingsDaemonSettings* self,
                                                   gint rgb);
static GVariant* settings_daemon_settings_get_accent_color (SettingsDaemonSettings* self);
static void settings_daemon_settings_read_all_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_settings_read_all (SettingsDaemonSettings* self,
                                        gchar** namespaces,
                                        gint namespaces_length1,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN GHashTable* settings_daemon_settings_read_all_finish (SettingsDaemonSettings* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static gboolean settings_daemon_settings_read_all_co (SettingsDaemonSettingsReadAllData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void _g_hash_table_unref0_ (gpointer var);
static void __lambda6_ (Block1Data* _data1_,
                 const gchar* schema,
                 GSettings* setting);
static void _g_variant_unref0_ (gpointer var);
static void ___lambda6__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void settings_daemon_settings_read_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_settings_read (SettingsDaemonSettings* self,
                                    const gchar* namespace,
                                    const gchar* key,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN GVariant* settings_daemon_settings_read_finish (SettingsDaemonSettings* self,
                                                GAsyncResult* _res_,
                                                GError** error);
static gboolean settings_daemon_settings_read_co (SettingsDaemonSettingsReadData* _data_);
VALA_EXTERN SettingsDaemonSettings* settings_daemon_settings_new (void);
VALA_EXTERN SettingsDaemonSettings* settings_daemon_settings_construct (GType object_type);
VALA_EXTERN guint32 settings_daemon_settings_get_version (SettingsDaemonSettings* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_VARIANT (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static GObject * settings_daemon_settings_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _settings_daemon_settings___lambda7_ (SettingsDaemonSettings* self);
static void __settings_daemon_settings___lambda7__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _settings_daemon_settings___lambda8_ (SettingsDaemonSettings* self);
static void __settings_daemon_settings___lambda8__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _g_object_unref0_ (gpointer var);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _settings_daemon_settings______lambda9_ (Block2Data* _data2_,
                                              const gchar* key);
static void __settings_daemon_settings______lambda9__g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self);
static void settings_daemon_settings_finalize (GObject * obj);
static GType settings_daemon_settings_get_type_once (void);
static void _vala_settings_daemon_settings_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _dbus_settings_daemon_settings_read_all (SettingsDaemonSettings* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_settings_read_all_ready (GObject * source_object,
                                                    GAsyncResult * _res_,
                                                    gpointer _user_data_);
static void _dbus_settings_daemon_settings_read (SettingsDaemonSettings* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_settings_read_ready (GObject * source_object,
                                                GAsyncResult * _res_,
                                                gpointer _user_data_);
static void settings_daemon_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* settings_daemon_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static GVariant* _dbus_settings_daemon_settings_get_version (SettingsDaemonSettings* self);
static gboolean settings_daemon_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_settings_daemon_settings_setting_changed (GObject* _sender,
                                                     const gchar* namespace,
                                                     const gchar* key,
                                                     GVariant* value,
                                                     gpointer* _data);
static void _settings_daemon_settings_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusErrorEntry portal_error_entries[] = {{PORTAL_ERROR_FAILED, "org.freedesktop.portal.Error.Failed"}, {PORTAL_ERROR_INVALID_ARGUMENT, "org.freedesktop.portal.Error.InvalidArgument"}, {PORTAL_ERROR_NOT_FOUND, "org.freedesktop.portal.Error.NotFound"}, {PORTAL_ERROR_EXISTS, "org.freedesktop.portal.Error.Exists"}, {PORTAL_ERROR_NOT_ALLOWED, "org.freedesktop.portal.Error.NotAllowed"}, {PORTAL_ERROR_CANCELLED, "org.freedesktop.portal.Error.Cancelled"}, {PORTAL_ERROR_WINDOW_DESTROYED, "org.freedesktop.portal.Error.WindowDestroyed"}};
static const GDBusMethodInfo * const _pantheon_accounts_service_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _pantheon_accounts_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _pantheon_accounts_service_dbus_property_info_prefers_color_scheme = {-1, "PrefersColorScheme", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _pantheon_accounts_service_dbus_property_info_prefers_accent_color = {-1, "PrefersAccentColor", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _pantheon_accounts_service_dbus_property_info[] = {&_pantheon_accounts_service_dbus_property_info_prefers_color_scheme, &_pantheon_accounts_service_dbus_property_info_prefers_accent_color, NULL};
static const GDBusInterfaceInfo _pantheon_accounts_service_dbus_interface_info = {-1, "io.elementary.pantheon.AccountsService", (GDBusMethodInfo **) (&_pantheon_accounts_service_dbus_method_info), (GDBusSignalInfo **) (&_pantheon_accounts_service_dbus_signal_info), (GDBusPropertyInfo **) (&_pantheon_accounts_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pantheon_accounts_service_dbus_interface_vtable = {pantheon_accounts_service_dbus_interface_method_call, pantheon_accounts_service_dbus_interface_get_property, pantheon_accounts_service_dbus_interface_set_property};
static const GDBusMethodInfo * const _settings_daemon_accounts_service_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _settings_daemon_accounts_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _settings_daemon_accounts_service_dbus_property_info_accent_color = {-1, "AccentColor", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _settings_daemon_accounts_service_dbus_property_info[] = {&_settings_daemon_accounts_service_dbus_property_info_accent_color, NULL};
static const GDBusInterfaceInfo _settings_daemon_accounts_service_dbus_interface_info = {-1, "io.elementary.SettingsDaemon.AccountsService", (GDBusMethodInfo **) (&_settings_daemon_accounts_service_dbus_method_info), (GDBusSignalInfo **) (&_settings_daemon_accounts_service_dbus_signal_info), (GDBusPropertyInfo **) (&_settings_daemon_accounts_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _settings_daemon_accounts_service_dbus_interface_vtable = {settings_daemon_accounts_service_dbus_interface_method_call, settings_daemon_accounts_service_dbus_interface_get_property, settings_daemon_accounts_service_dbus_interface_set_property};
static const GDBusArgInfo _fdo_accounts_dbus_arg_info_find_user_by_name_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _fdo_accounts_dbus_arg_info_find_user_by_name_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _fdo_accounts_dbus_arg_info_find_user_by_name_in[] = {&_fdo_accounts_dbus_arg_info_find_user_by_name_username, NULL};
static const GDBusArgInfo * const _fdo_accounts_dbus_arg_info_find_user_by_name_out[] = {&_fdo_accounts_dbus_arg_info_find_user_by_name_result, NULL};
static const GDBusMethodInfo _fdo_accounts_dbus_method_info_find_user_by_name = {-1, "FindUserByName", (GDBusArgInfo **) (&_fdo_accounts_dbus_arg_info_find_user_by_name_in), (GDBusArgInfo **) (&_fdo_accounts_dbus_arg_info_find_user_by_name_out), NULL};
static const GDBusMethodInfo * const _fdo_accounts_dbus_method_info[] = {&_fdo_accounts_dbus_method_info_find_user_by_name, NULL};
static const GDBusSignalInfo * const _fdo_accounts_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _fdo_accounts_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _fdo_accounts_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_fdo_accounts_dbus_method_info), (GDBusSignalInfo **) (&_fdo_accounts_dbus_signal_info), (GDBusPropertyInfo **) (&_fdo_accounts_dbus_property_info), NULL};
static const GDBusInterfaceVTable _fdo_accounts_dbus_interface_vtable = {fdo_accounts_dbus_interface_method_call, fdo_accounts_dbus_interface_get_property, fdo_accounts_dbus_interface_set_property};
static const gchar* SETTINGS_DAEMON_SETTINGS_SUPPORTED_SCHEMAS[2] = {"io.elementary.settings-daemon.datetime", "org.freedesktop.appearance"};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_read_all_namespaces = {-1, "namespaces", "as", NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_read_all_result = {-1, "result", "a{sa{sv}}", NULL};
static const GDBusArgInfo * const _settings_daemon_settings_dbus_arg_info_read_all_in[] = {&_settings_daemon_settings_dbus_arg_info_read_all_namespaces, NULL};
static const GDBusArgInfo * const _settings_daemon_settings_dbus_arg_info_read_all_out[] = {&_settings_daemon_settings_dbus_arg_info_read_all_result, NULL};
static const GDBusMethodInfo _settings_daemon_settings_dbus_method_info_read_all = {-1, "ReadAll", (GDBusArgInfo **) (&_settings_daemon_settings_dbus_arg_info_read_all_in), (GDBusArgInfo **) (&_settings_daemon_settings_dbus_arg_info_read_all_out), NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_read_namespace = {-1, "namespace", "s", NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_read_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_read_result = {-1, "result", "v", NULL};
static const GDBusArgInfo * const _settings_daemon_settings_dbus_arg_info_read_in[] = {&_settings_daemon_settings_dbus_arg_info_read_namespace, &_settings_daemon_settings_dbus_arg_info_read_key, NULL};
static const GDBusArgInfo * const _settings_daemon_settings_dbus_arg_info_read_out[] = {&_settings_daemon_settings_dbus_arg_info_read_result, NULL};
static const GDBusMethodInfo _settings_daemon_settings_dbus_method_info_read = {-1, "Read", (GDBusArgInfo **) (&_settings_daemon_settings_dbus_arg_info_read_in), (GDBusArgInfo **) (&_settings_daemon_settings_dbus_arg_info_read_out), NULL};
static const GDBusMethodInfo * const _settings_daemon_settings_dbus_method_info[] = {&_settings_daemon_settings_dbus_method_info_read_all, &_settings_daemon_settings_dbus_method_info_read, NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_setting_changed_namespace = {-1, "namespace", "s", NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_setting_changed_key = {-1, "key", "s", NULL};
static const GDBusArgInfo _settings_daemon_settings_dbus_arg_info_setting_changed_value = {-1, "value", "v", NULL};
static const GDBusArgInfo * const _settings_daemon_settings_dbus_arg_info_setting_changed[] = {&_settings_daemon_settings_dbus_arg_info_setting_changed_namespace, &_settings_daemon_settings_dbus_arg_info_setting_changed_key, &_settings_daemon_settings_dbus_arg_info_setting_changed_value, NULL};
static const GDBusSignalInfo _settings_daemon_settings_dbus_signal_info_setting_changed = {-1, "SettingChanged", (GDBusArgInfo **) (&_settings_daemon_settings_dbus_arg_info_setting_changed), NULL};
static const GDBusSignalInfo * const _settings_daemon_settings_dbus_signal_info[] = {&_settings_daemon_settings_dbus_signal_info_setting_changed, NULL};
static const GDBusPropertyInfo _settings_daemon_settings_dbus_property_info_version = {-1, "Version", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _settings_daemon_settings_dbus_property_info[] = {&_settings_daemon_settings_dbus_property_info_version, NULL};
static const GDBusInterfaceInfo _settings_daemon_settings_dbus_interface_info = {-1, "org.freedesktop.impl.portal.Settings", (GDBusMethodInfo **) (&_settings_daemon_settings_dbus_method_info), (GDBusSignalInfo **) (&_settings_daemon_settings_dbus_signal_info), (GDBusPropertyInfo **) (&_settings_daemon_settings_dbus_property_info), NULL};
static const GDBusInterfaceVTable _settings_daemon_settings_dbus_interface_vtable = {settings_daemon_settings_dbus_interface_method_call, settings_daemon_settings_dbus_interface_get_property, settings_daemon_settings_dbus_interface_set_property};

GQuark
portal_error_quark (void)
{
	static volatile gsize portal_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("portal-error-quark", &portal_error_quark_volatile, portal_error_entries, G_N_ELEMENTS (portal_error_entries));
	return (GQuark) portal_error_quark_volatile;
}

gint
pantheon_accounts_service_get_prefers_color_scheme (PantheonAccountsService* self)
{
	PantheonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_prefers_color_scheme) {
		return _iface_->get_prefers_color_scheme (self);
	}
	return -1;
}

void
pantheon_accounts_service_set_prefers_color_scheme (PantheonAccountsService* self,
                                                    gint value)
{
	PantheonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_prefers_color_scheme) {
		_iface_->set_prefers_color_scheme (self, value);
	}
}

gint
pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self)
{
	PantheonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_prefers_accent_color) {
		return _iface_->get_prefers_accent_color (self);
	}
	return -1;
}

void
pantheon_accounts_service_set_prefers_accent_color (PantheonAccountsService* self,
                                                    gint value)
{
	PantheonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_prefers_accent_color) {
		_iface_->set_prefers_accent_color (self, value);
	}
}

static void
pantheon_accounts_service_default_init (PantheonAccountsServiceIface * iface,
                                        gpointer iface_data)
{
}

static GType
pantheon_accounts_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonAccountsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_accounts_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pantheon_accounts_service_type_id;
	pantheon_accounts_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "PantheonAccountsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pantheon_accounts_service_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pantheon_accounts_service_proxy_get_type);
	g_type_set_qdata (pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.pantheon.AccountsService");
	g_type_set_qdata (pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pantheon_accounts_service_dbus_interface_info));
	g_type_set_qdata (pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pantheon_accounts_service_register_object);
	return pantheon_accounts_service_type_id;
}

GType
pantheon_accounts_service_get_type (void)
{
	static volatile gsize pantheon_accounts_service_type_id__once = 0;
	if (g_once_init_enter (&pantheon_accounts_service_type_id__once)) {
		GType pantheon_accounts_service_type_id;
		pantheon_accounts_service_type_id = pantheon_accounts_service_get_type_once ();
		g_once_init_leave (&pantheon_accounts_service_type_id__once, pantheon_accounts_service_type_id);
	}
	return pantheon_accounts_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PantheonAccountsServiceProxy, pantheon_accounts_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PANTHEON_TYPE_ACCOUNTS_SERVICE, pantheon_accounts_service_proxy_pantheon_accounts_service_interface_init) )
static void
pantheon_accounts_service_proxy_class_init (PantheonAccountsServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pantheon_accounts_service_proxy_g_signal;
}

static void
pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters)
{
}

static void
pantheon_accounts_service_proxy_init (PantheonAccountsServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pantheon_accounts_service_dbus_interface_info));
}

static gint
pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (PantheonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrefersColorScheme");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp0_ = 0;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (PantheonAccountsService* self,
                                                               gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gint
pantheon_accounts_service_dbus_proxy_get_prefers_accent_color (PantheonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrefersAccentColor");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersAccentColor"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp1_ = 0;
			return _tmp1_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
pantheon_accounts_service_dbus_proxy_set_prefers_accent_color (PantheonAccountsService* self,
                                                               gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersAccentColor"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
pantheon_accounts_service_proxy_pantheon_accounts_service_interface_init (PantheonAccountsServiceIface* iface)
{
	iface->get_prefers_color_scheme = pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme;
	iface->set_prefers_color_scheme = pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme;
	iface->get_prefers_accent_color = pantheon_accounts_service_dbus_proxy_get_prefers_accent_color;
	iface->set_prefers_accent_color = pantheon_accounts_service_dbus_proxy_set_prefers_accent_color;
}

static void
pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_pantheon_accounts_service_get_prefers_color_scheme (PantheonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = pantheon_accounts_service_get_prefers_color_scheme (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_pantheon_accounts_service_get_prefers_accent_color (PantheonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = pantheon_accounts_service_get_prefers_accent_color (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		return _dbus_pantheon_accounts_service_get_prefers_color_scheme (object);
	} else if (strcmp (property_name, "PrefersAccentColor") == 0) {
		return _dbus_pantheon_accounts_service_get_prefers_accent_color (object);
	}
	return NULL;
}

static void
_dbus_pantheon_accounts_service_set_prefers_color_scheme (PantheonAccountsService* self,
                                                          GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	pantheon_accounts_service_set_prefers_color_scheme (self, value);
}

static void
_dbus_pantheon_accounts_service_set_prefers_accent_color (PantheonAccountsService* self,
                                                          GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	pantheon_accounts_service_set_prefers_accent_color (self, value);
}

static gboolean
pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		_dbus_pantheon_accounts_service_set_prefers_color_scheme (object, value);
		return TRUE;
	} else if (strcmp (property_name, "PrefersAccentColor") == 0) {
		_dbus_pantheon_accounts_service_set_prefers_accent_color (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
pantheon_accounts_service_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pantheon_accounts_service_dbus_interface_info), &_pantheon_accounts_service_dbus_interface_vtable, data, _pantheon_accounts_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_pantheon_accounts_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gint
settings_daemon_accounts_service_get_accent_color (SettingsDaemonAccountsService* self)
{
	SettingsDaemonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_accent_color) {
		return _iface_->get_accent_color (self);
	}
	return -1;
}

void
settings_daemon_accounts_service_set_accent_color (SettingsDaemonAccountsService* self,
                                                   gint value)
{
	SettingsDaemonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SETTINGS_DAEMON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_accent_color) {
		_iface_->set_accent_color (self, value);
	}
}

static void
settings_daemon_accounts_service_default_init (SettingsDaemonAccountsServiceIface * iface,
                                               gpointer iface_data)
{
}

static GType
settings_daemon_accounts_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonAccountsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_accounts_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType settings_daemon_accounts_service_type_id;
	settings_daemon_accounts_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SettingsDaemonAccountsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (settings_daemon_accounts_service_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) settings_daemon_accounts_service_proxy_get_type);
	g_type_set_qdata (settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.SettingsDaemon.AccountsService");
	g_type_set_qdata (settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_settings_daemon_accounts_service_dbus_interface_info));
	g_type_set_qdata (settings_daemon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) settings_daemon_accounts_service_register_object);
	return settings_daemon_accounts_service_type_id;
}

GType
settings_daemon_accounts_service_get_type (void)
{
	static volatile gsize settings_daemon_accounts_service_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_accounts_service_type_id__once)) {
		GType settings_daemon_accounts_service_type_id;
		settings_daemon_accounts_service_type_id = settings_daemon_accounts_service_get_type_once ();
		g_once_init_leave (&settings_daemon_accounts_service_type_id__once, settings_daemon_accounts_service_type_id);
	}
	return settings_daemon_accounts_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SettingsDaemonAccountsServiceProxy, settings_daemon_accounts_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE, settings_daemon_accounts_service_proxy_settings_daemon_accounts_service_interface_init) )
static void
settings_daemon_accounts_service_proxy_class_init (SettingsDaemonAccountsServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = settings_daemon_accounts_service_proxy_g_signal;
}

static void
settings_daemon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                 const gchar* sender_name,
                                                 const gchar* signal_name,
                                                 GVariant* parameters)
{
}

static void
settings_daemon_accounts_service_proxy_init (SettingsDaemonAccountsServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_settings_daemon_accounts_service_dbus_interface_info));
}

static gint
settings_daemon_accounts_service_dbus_proxy_get_accent_color (SettingsDaemonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AccentColor");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.SettingsDaemon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AccentColor"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp2_ = 0;
			return _tmp2_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
settings_daemon_accounts_service_dbus_proxy_set_accent_color (SettingsDaemonAccountsService* self,
                                                              gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.SettingsDaemon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AccentColor"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
settings_daemon_accounts_service_proxy_settings_daemon_accounts_service_interface_init (SettingsDaemonAccountsServiceIface* iface)
{
	iface->get_accent_color = settings_daemon_accounts_service_dbus_proxy_get_accent_color;
	iface->set_accent_color = settings_daemon_accounts_service_dbus_proxy_set_accent_color;
}

static void
settings_daemon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* method_name,
                                                             GVariant* parameters,
                                                             GDBusMethodInvocation* invocation,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_settings_daemon_accounts_service_get_accent_color (SettingsDaemonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = settings_daemon_accounts_service_get_accent_color (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
settings_daemon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "AccentColor") == 0) {
		return _dbus_settings_daemon_accounts_service_get_accent_color (object);
	}
	return NULL;
}

static void
_dbus_settings_daemon_accounts_service_set_accent_color (SettingsDaemonAccountsService* self,
                                                         GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	settings_daemon_accounts_service_set_accent_color (self, value);
}

static gboolean
settings_daemon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "AccentColor") == 0) {
		_dbus_settings_daemon_accounts_service_set_accent_color (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
settings_daemon_accounts_service_register_object (gpointer object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_settings_daemon_accounts_service_dbus_interface_info), &_settings_daemon_accounts_service_dbus_interface_vtable, data, _settings_daemon_accounts_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_settings_daemon_accounts_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
fdo_accounts_find_user_by_name (FDOAccounts* self,
                                const gchar* username,
                                GError** error)
{
	FDOAccountsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FDO_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->find_user_by_name) {
		return _iface_->find_user_by_name (self, username, error);
	}
	return NULL;
}

static void
fdo_accounts_default_init (FDOAccountsIface * iface,
                           gpointer iface_data)
{
}

static GType
fdo_accounts_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FDOAccountsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fdo_accounts_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType fdo_accounts_type_id;
	fdo_accounts_type_id = g_type_register_static (G_TYPE_INTERFACE, "FDOAccounts", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (fdo_accounts_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) fdo_accounts_proxy_get_type);
	g_type_set_qdata (fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_fdo_accounts_dbus_interface_info));
	g_type_set_qdata (fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) fdo_accounts_register_object);
	return fdo_accounts_type_id;
}

GType
fdo_accounts_get_type (void)
{
	static volatile gsize fdo_accounts_type_id__once = 0;
	if (g_once_init_enter (&fdo_accounts_type_id__once)) {
		GType fdo_accounts_type_id;
		fdo_accounts_type_id = fdo_accounts_get_type_once ();
		g_once_init_leave (&fdo_accounts_type_id__once, fdo_accounts_type_id);
	}
	return fdo_accounts_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FDOAccountsProxy, fdo_accounts_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FDO_TYPE_ACCOUNTS, fdo_accounts_proxy_fdo_accounts_interface_init) )
static void
fdo_accounts_proxy_class_init (FDOAccountsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = fdo_accounts_proxy_g_signal;
}

static void
fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
}

static void
fdo_accounts_proxy_init (FDOAccountsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_fdo_accounts_dbus_interface_info));
}

static gchar*
fdo_accounts_proxy_find_user_by_name (FDOAccounts* self,
                                      const gchar* username,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp3_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (username));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	g_object_unref (_reply_message);
	return _result;
}

static void
fdo_accounts_proxy_fdo_accounts_interface_init (FDOAccountsIface* iface)
{
	iface->find_user_by_name = fdo_accounts_proxy_find_user_by_name;
}

static void
_dbus_fdo_accounts_find_user_by_name (FDOAccounts* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	result = fdo_accounts_find_user_by_name (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserByName") == 0) {
		_dbus_fdo_accounts_find_user_by_name (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
fdo_accounts_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_fdo_accounts_dbus_interface_info), &_fdo_accounts_dbus_interface_vtable, data, _fdo_accounts_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_fdo_accounts_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
accounts_service_monitor_get_instance_private (AccountsServiceMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, AccountsServiceMonitor_private_offset);
}

static void
accounts_service_monitor_setup_user_path (AccountsServiceMonitor* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FDOAccounts* _tmp0_ = NULL;
		FDOAccounts* _tmp1_;
		FDOAccounts* _tmp2_;
		gchar* _tmp3_ = NULL;
		FDOAccounts* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = (FDOAccounts*) g_initable_new (FDO_TYPE_ACCOUNTS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		_tmp0_ = (FDOAccounts*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->accounts_service);
		self->priv->accounts_service = _tmp2_;
		_tmp4_ = self->priv->accounts_service;
		_tmp5_ = g_get_user_name ();
		_tmp6_ = fdo_accounts_find_user_by_name (_tmp4_, _tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (self->priv->user_path);
		self->priv->user_path = _tmp7_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Settings.vala:73: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4_ (AccountsServiceMonitor* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* value = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "PrefersColorScheme", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	value = _tmp3_;
	_tmp4_ = value;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = value;
		accounts_service_monitor_set_color_scheme (self, g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (value);
}

static void
____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	___lambda4_ ((AccountsServiceMonitor*) self, changed_properties, invalidated_properties);
}

static void
accounts_service_monitor_setup_prefers_color_scheme (AccountsServiceMonitor* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PantheonAccountsService* _tmp0_ = NULL;
		const gchar* _tmp1_;
		PantheonAccountsService* _tmp2_;
		PantheonAccountsService* _tmp3_;
		PantheonAccountsService* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		PantheonAccountsService* _tmp7_;
		_tmp1_ = self->priv->user_path;
		_tmp2_ = (PantheonAccountsService*) g_initable_new (PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp1_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
		_tmp0_ = (PantheonAccountsService*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->pantheon_act);
		self->priv->pantheon_act = _tmp3_;
		_tmp4_ = self->priv->pantheon_act;
		_tmp5_ = pantheon_accounts_service_get_prefers_color_scheme (_tmp4_);
		_tmp6_ = _tmp5_;
		accounts_service_monitor_set_color_scheme (self, (gint32) _tmp6_);
		_tmp7_ = self->priv->pantheon_act;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda4__g_dbus_proxy_g_properties_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Settings.vala:95: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5_ (AccountsServiceMonitor* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* value = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "AccentColor", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	value = _tmp3_;
	_tmp4_ = value;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = value;
		accounts_service_monitor_set_accent_color (self, g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (value);
}

static void
____lambda5__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	___lambda5_ ((AccountsServiceMonitor*) self, changed_properties, invalidated_properties);
}

static void
accounts_service_monitor_setup_prefers_accent_color (AccountsServiceMonitor* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		SettingsDaemonAccountsService* _tmp0_ = NULL;
		const gchar* _tmp1_;
		SettingsDaemonAccountsService* _tmp2_;
		SettingsDaemonAccountsService* _tmp3_;
		SettingsDaemonAccountsService* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		SettingsDaemonAccountsService* _tmp7_;
		_tmp1_ = self->priv->user_path;
		_tmp2_ = (SettingsDaemonAccountsService*) g_initable_new (SETTINGS_DAEMON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp1_, "g-interface-name", "io.elementary.SettingsDaemon.AccountsService", NULL);
		_tmp0_ = (SettingsDaemonAccountsService*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->settings_daemon_act);
		self->priv->settings_daemon_act = _tmp3_;
		_tmp4_ = self->priv->settings_daemon_act;
		_tmp5_ = settings_daemon_accounts_service_get_accent_color (_tmp4_);
		_tmp6_ = _tmp5_;
		accounts_service_monitor_set_accent_color (self, (gint32) _tmp6_);
		_tmp7_ = self->priv->settings_daemon_act;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda5__g_dbus_proxy_g_properties_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Settings.vala:117: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

AccountsServiceMonitor*
accounts_service_monitor_construct (GType object_type)
{
	AccountsServiceMonitor * self = NULL;
	self = (AccountsServiceMonitor*) g_object_new (object_type, NULL);
	return self;
}

AccountsServiceMonitor*
accounts_service_monitor_new (void)
{
	return accounts_service_monitor_construct (TYPE_ACCOUNTS_SERVICE_MONITOR);
}

gint32
accounts_service_monitor_get_color_scheme (AccountsServiceMonitor* self)
{
	gint32 result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color_scheme;
	return result;
}

void
accounts_service_monitor_set_color_scheme (AccountsServiceMonitor* self,
                                           gint32 value)
{
	gint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = accounts_service_monitor_get_color_scheme (self);
	if (old_value != value) {
		self->priv->_color_scheme = value;
		g_object_notify_by_pspec ((GObject *) self, accounts_service_monitor_properties[ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY]);
	}
}

gint32
accounts_service_monitor_get_accent_color (AccountsServiceMonitor* self)
{
	gint32 result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_accent_color;
	return result;
}

void
accounts_service_monitor_set_accent_color (AccountsServiceMonitor* self,
                                           gint32 value)
{
	gint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = accounts_service_monitor_get_accent_color (self);
	if (old_value != value) {
		self->priv->_accent_color = value;
		g_object_notify_by_pspec ((GObject *) self, accounts_service_monitor_properties[ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY]);
	}
}

static GObject *
accounts_service_monitor_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AccountsServiceMonitor * self;
	parent_class = G_OBJECT_CLASS (accounts_service_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitor);
	accounts_service_monitor_setup_user_path (self);
	accounts_service_monitor_setup_prefers_color_scheme (self);
	accounts_service_monitor_setup_prefers_accent_color (self);
	return obj;
}

static void
accounts_service_monitor_class_init (AccountsServiceMonitorClass * klass,
                                     gpointer klass_data)
{
	accounts_service_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AccountsServiceMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_accounts_service_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_accounts_service_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = accounts_service_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = accounts_service_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY, accounts_service_monitor_properties[ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY] = g_param_spec_int ("color-scheme", "color-scheme", "color-scheme", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY, accounts_service_monitor_properties[ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY] = g_param_spec_int ("accent-color", "accent-color", "accent-color", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
accounts_service_monitor_instance_init (AccountsServiceMonitor * self,
                                        gpointer klass)
{
	self->priv = accounts_service_monitor_get_instance_private (self);
	self->priv->accounts_service = NULL;
	self->priv->pantheon_act = NULL;
	self->priv->settings_daemon_act = NULL;
}

static void
accounts_service_monitor_finalize (GObject * obj)
{
	AccountsServiceMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitor);
	_g_object_unref0 (self->priv->accounts_service);
	_g_object_unref0 (self->priv->pantheon_act);
	_g_object_unref0 (self->priv->settings_daemon_act);
	_g_free0 (self->priv->user_path);
	G_OBJECT_CLASS (accounts_service_monitor_parent_class)->finalize (obj);
}

static GType
accounts_service_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountsServiceMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) accounts_service_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountsServiceMonitor), 0, (GInstanceInitFunc) accounts_service_monitor_instance_init, NULL };
	GType accounts_service_monitor_type_id;
	accounts_service_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "AccountsServiceMonitor", &g_define_type_info, 0);
	AccountsServiceMonitor_private_offset = g_type_add_instance_private (accounts_service_monitor_type_id, sizeof (AccountsServiceMonitorPrivate));
	return accounts_service_monitor_type_id;
}

GType
accounts_service_monitor_get_type (void)
{
	static volatile gsize accounts_service_monitor_type_id__once = 0;
	if (g_once_init_enter (&accounts_service_monitor_type_id__once)) {
		GType accounts_service_monitor_type_id;
		accounts_service_monitor_type_id = accounts_service_monitor_get_type_once ();
		g_once_init_leave (&accounts_service_monitor_type_id__once, accounts_service_monitor_type_id);
	}
	return accounts_service_monitor_type_id__once;
}

static void
_vala_accounts_service_monitor_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	AccountsServiceMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitor);
	switch (property_id) {
		case ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY:
		g_value_set_int (value, accounts_service_monitor_get_color_scheme (self));
		break;
		case ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY:
		g_value_set_int (value, accounts_service_monitor_get_accent_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_accounts_service_monitor_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	AccountsServiceMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNTS_SERVICE_MONITOR, AccountsServiceMonitor);
	switch (property_id) {
		case ACCOUNTS_SERVICE_MONITOR_COLOR_SCHEME_PROPERTY:
		accounts_service_monitor_set_color_scheme (self, g_value_get_int (value));
		break;
		case ACCOUNTS_SERVICE_MONITOR_ACCENT_COLOR_PROPERTY:
		accounts_service_monitor_set_accent_color (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
settings_daemon_settings_get_instance_private (SettingsDaemonSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsDaemonSettings_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
settings_daemon_settings_namespace_matches (SettingsDaemonSettings* self,
                                            const gchar* namespace,
                                            gchar** patterns,
                                            gint patterns_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (namespace != NULL, FALSE);
	{
		gchar** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
		pattern_collection = patterns;
		pattern_collection_length1 = patterns_length1;
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
			gchar* _tmp0_;
			gchar* pattern = NULL;
			_tmp0_ = g_strdup (pattern_collection[pattern_it]);
			pattern = _tmp0_;
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gint pattern_len = 0;
				const gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				_tmp1_ = pattern;
				if (string_get (_tmp1_, (glong) 0) == '\0') {
					result = TRUE;
					_g_free0 (pattern);
					return result;
				}
				_tmp2_ = pattern;
				if (g_strcmp0 (_tmp2_, namespace) == 0) {
					result = TRUE;
					_g_free0 (pattern);
					return result;
				}
				_tmp3_ = pattern;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				pattern_len = _tmp5_;
				_tmp7_ = pattern;
				if (string_get (_tmp7_, (glong) (pattern_len - 1)) == '*') {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp8_ = pattern;
					_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) (pattern_len - 1));
					_tmp10_ = _tmp9_;
					_tmp6_ = g_str_has_prefix (namespace, _tmp10_);
					_g_free0 (_tmp10_);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					result = TRUE;
					_g_free0 (pattern);
					return result;
				}
				_g_free0 (pattern);
			}
		}
	}
	result = patterns_length1 == 0;
	return result;
}

static GVariant*
settings_daemon_settings_get_color_scheme (SettingsDaemonSettings* self)
{
	AccountsServiceMonitor* _tmp0_;
	gint32 _tmp1_;
	gint32 _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->monitor;
	_tmp1_ = accounts_service_monitor_get_color_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_new_uint32 ((guint32) _tmp2_);
	g_variant_ref_sink (_tmp3_);
	result = _tmp3_;
	return result;
}

static inline GVariant*
settings_daemon_settings_rgb_to_variant (SettingsDaemonSettings* self,
                                         gint rgb)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	GVariant* _tmp0_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	r = ((rgb >> 16) & 255) / 255.0;
	g = ((rgb >> 8) & 255) / 255.0;
	b = (rgb & 255) / 255.0;
	_tmp0_ = g_variant_new ("(ddd)", r, g, b, NULL);
	g_variant_ref_sink (_tmp0_);
	result = _tmp0_;
	return result;
}

static GVariant*
settings_daemon_settings_get_accent_color (SettingsDaemonSettings* self)
{
	AccountsServiceMonitor* _tmp0_;
	gint32 _tmp1_;
	gint32 _tmp2_;
	GVariant* _tmp14_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->monitor;
	_tmp1_ = accounts_service_monitor_get_accent_color (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 1:
		{
			GVariant* _tmp3_;
			_tmp3_ = settings_daemon_settings_rgb_to_variant (self, 0xed5353);
			result = _tmp3_;
			return result;
		}
		case 2:
		{
			GVariant* _tmp4_;
			_tmp4_ = settings_daemon_settings_rgb_to_variant (self, 0xffa154);
			result = _tmp4_;
			return result;
		}
		case 3:
		{
			GVariant* _tmp5_;
			_tmp5_ = settings_daemon_settings_rgb_to_variant (self, 0xf9c440);
			result = _tmp5_;
			return result;
		}
		case 4:
		{
			GVariant* _tmp6_;
			_tmp6_ = settings_daemon_settings_rgb_to_variant (self, 0x68b723);
			result = _tmp6_;
			return result;
		}
		case 5:
		{
			GVariant* _tmp7_;
			_tmp7_ = settings_daemon_settings_rgb_to_variant (self, 0x28bca3);
			result = _tmp7_;
			return result;
		}
		case 6:
		{
			GVariant* _tmp8_;
			_tmp8_ = settings_daemon_settings_rgb_to_variant (self, 0x3689e6);
			result = _tmp8_;
			return result;
		}
		case 7:
		{
			GVariant* _tmp9_;
			_tmp9_ = settings_daemon_settings_rgb_to_variant (self, 0xa56de2);
			result = _tmp9_;
			return result;
		}
		case 8:
		{
			GVariant* _tmp10_;
			_tmp10_ = settings_daemon_settings_rgb_to_variant (self, 0xde3e80);
			result = _tmp10_;
			return result;
		}
		case 9:
		{
			GVariant* _tmp11_;
			_tmp11_ = settings_daemon_settings_rgb_to_variant (self, 0x8a715e);
			result = _tmp11_;
			return result;
		}
		case 10:
		{
			GVariant* _tmp12_;
			_tmp12_ = settings_daemon_settings_rgb_to_variant (self, 0x667885);
			result = _tmp12_;
			return result;
		}
		case 11:
		{
			GVariant* _tmp13_;
			_tmp13_ = settings_daemon_settings_rgb_to_variant (self, 0xe7c591);
			result = _tmp13_;
			return result;
		}
		default:
		break;
	}
	_tmp14_ = settings_daemon_settings_rgb_to_variant (self, 0);
	result = _tmp14_;
	return result;
}

static void
settings_daemon_settings_read_all_data_free (gpointer _data)
{
	SettingsDaemonSettingsReadAllData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonSettingsReadAllData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
settings_daemon_settings_read_all (SettingsDaemonSettings* self,
                                   gchar** namespaces,
                                   gint namespaces_length1,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SettingsDaemonSettingsReadAllData* _data_;
	SettingsDaemonSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonSettingsReadAllData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_settings_read_all_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->namespaces = namespaces;
	_data_->namespaces_length1 = namespaces_length1;
	settings_daemon_settings_read_all_co (_data_);
}

GHashTable*
settings_daemon_settings_read_all_finish (SettingsDaemonSettings* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GHashTable* result;
	SettingsDaemonSettingsReadAllData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SettingsDaemonSettings* self;
		self = _data1_->self;
		_g_hash_table_unref0 (_data1_->ret);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
__lambda6_ (Block1Data* _data1_,
            const gchar* schema,
            GSettings* setting)
{
	SettingsDaemonSettings* self;
	self = _data1_->self;
	g_return_if_fail (schema != NULL);
	g_return_if_fail (setting != NULL);
	if (settings_daemon_settings_namespace_matches (self, schema, _data1_->namespaces, (gint) _data1_->namespaces_length1)) {
		GHashTable* dict = NULL;
		GHashFunc _tmp0_;
		GEqualFunc _tmp1_;
		GHashTable* _tmp2_;
		gchar* _tmp21_;
		GHashTable* _tmp22_;
		GHashTable* _tmp23_;
		_tmp0_ = g_str_hash;
		_tmp1_ = g_str_equal;
		_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
		dict = _tmp2_;
		if (g_strcmp0 (schema, "org.freedesktop.appearance") == 0) {
			GHashTable* _tmp3_;
			gchar* _tmp4_;
			GVariant* _tmp5_;
			GHashTable* _tmp6_;
			gchar* _tmp7_;
			GVariant* _tmp8_;
			_tmp3_ = dict;
			_tmp4_ = g_strdup ("color-scheme");
			_tmp5_ = settings_daemon_settings_get_color_scheme (self);
			g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
			_tmp6_ = dict;
			_tmp7_ = g_strdup ("accent-color");
			_tmp8_ = settings_daemon_settings_get_accent_color (self);
			g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
		} else {
			gchar** keys = NULL;
			GSettingsSchema* _tmp9_;
			GSettingsSchema* _tmp10_;
			GSettingsSchema* _tmp11_;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			gint keys_length1;
			gint _keys_size_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			g_object_get (setting, "settings-schema", &_tmp9_, NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_;
			_tmp13_ = _tmp12_ = g_settings_schema_list_keys (_tmp11_);
			_tmp14_ = _tmp13_;
			_tmp14__length1 = _vala_array_length (_tmp12_);
			_g_settings_schema_unref0 (_tmp11_);
			keys = _tmp14_;
			keys_length1 = _tmp14__length1;
			_keys_size_ = keys_length1;
			_tmp15_ = keys;
			_tmp15__length1 = keys_length1;
			{
				gchar** key_collection = NULL;
				gint key_collection_length1 = 0;
				gint _key_collection_size_ = 0;
				gint key_it = 0;
				key_collection = _tmp15_;
				key_collection_length1 = _tmp15__length1;
				for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
					const gchar* key = NULL;
					key = key_collection[key_it];
					{
						GHashTable* _tmp16_;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_;
						GVariant* _tmp20_;
						_tmp16_ = dict;
						_tmp17_ = key;
						_tmp18_ = g_strdup (_tmp17_);
						_tmp19_ = key;
						_tmp20_ = g_settings_get_value (setting, _tmp19_);
						g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
					}
				}
			}
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp21_ = g_strdup (schema);
		_tmp22_ = dict;
		_tmp23_ = _g_hash_table_ref0 (_tmp22_);
		g_hash_table_insert (_data1_->ret, _tmp21_, _tmp23_);
		_g_hash_table_unref0 (dict);
	}
}

static void
___lambda6__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda6_ (self, (const gchar*) key, (GSettings*) value);
}

static gboolean
settings_daemon_settings_read_all_co (SettingsDaemonSettingsReadAllData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->namespaces = _data_->namespaces;
	_data_->_data1_->namespaces_length1 = _data_->namespaces_length1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_hash_table_unref0_);
	_data_->_data1_->ret = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->settings;
	g_hash_table_foreach (_data_->_tmp3_, ___lambda6__gh_func, _data_->_data1_);
	_data_->_tmp4_ = _g_hash_table_ref0 (_data_->_data1_->ret);
	_data_->result = _data_->_tmp4_;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
settings_daemon_settings_read_data_free (gpointer _data)
{
	SettingsDaemonSettingsReadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->namespace);
	_g_free0 (_data_->key);
	_g_variant_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonSettingsReadData, _data_);
}

void
settings_daemon_settings_read (SettingsDaemonSettings* self,
                               const gchar* namespace,
                               const gchar* key,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SettingsDaemonSettingsReadData* _data_;
	SettingsDaemonSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (namespace != NULL);
	g_return_if_fail (key != NULL);
	_data_ = g_slice_new0 (SettingsDaemonSettingsReadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_settings_read_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (namespace);
	_g_free0 (_data_->namespace);
	_data_->namespace = _tmp1_;
	_tmp2_ = g_strdup (key);
	_g_free0 (_data_->key);
	_data_->key = _tmp2_;
	settings_daemon_settings_read_co (_data_);
}

GVariant*
settings_daemon_settings_read_finish (SettingsDaemonSettings* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GVariant* result;
	SettingsDaemonSettingsReadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
settings_daemon_settings_read_co (SettingsDaemonSettingsReadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (g_strcmp0 (_data_->namespace, "org.freedesktop.appearance") == 0) {
		if (g_strcmp0 (_data_->key, "color-scheme") == 0) {
			_data_->_tmp0_ = settings_daemon_settings_get_color_scheme (_data_->self);
			_data_->result = _data_->_tmp0_;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (g_strcmp0 (_data_->key, "accent-color") == 0) {
			_data_->_tmp1_ = settings_daemon_settings_get_accent_color (_data_->self);
			_data_->result = _data_->_tmp1_;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp2_ = _data_->self->priv->settings;
	_data_->_tmp3_ = g_hash_table_lookup (_data_->_tmp2_, _data_->namespace);
	_data_->setting = (GSettings*) _data_->_tmp3_;
	_data_->_tmp5_ = _data_->setting;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->setting;
		g_object_get (_data_->_tmp6_, "settings-schema", &_data_->_tmp7_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp4_ = g_settings_schema_has_key (_data_->_tmp9_, _data_->key);
		_g_settings_schema_unref0 (_data_->_tmp9_);
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp10_ = _data_->setting;
		_data_->_tmp11_ = g_settings_get_value (_data_->_tmp10_, _data_->key);
		_data_->result = _data_->_tmp11_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("Settings.vala:271: Attempted to read unknown namespace/key pair: %s %s", _data_->namespace, _data_->key);
	_data_->_tmp12_ = g_error_new_literal (PORTAL_ERROR, PORTAL_ERROR_NOT_FOUND, "Requested setting not found");
	_data_->_inner_error0_ = _data_->_tmp12_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SettingsDaemonSettings*
settings_daemon_settings_construct (GType object_type)
{
	SettingsDaemonSettings * self = NULL;
	self = (SettingsDaemonSettings*) g_object_new (object_type, NULL);
	return self;
}

SettingsDaemonSettings*
settings_daemon_settings_new (void)
{
	return settings_daemon_settings_construct (SETTINGS_DAEMON_TYPE_SETTINGS);
}

guint32
settings_daemon_settings_get_version (SettingsDaemonSettings* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = (guint32) 1;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_VARIANT (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_VARIANT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_variant (param_values + 3), data2);
}

static void
_settings_daemon_settings___lambda7_ (SettingsDaemonSettings* self)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = settings_daemon_settings_get_color_scheme (self);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, settings_daemon_settings_signals[SETTINGS_DAEMON_SETTINGS_SETTING_CHANGED_SIGNAL], 0, "org.freedesktop.appearance", "color-scheme", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
__settings_daemon_settings___lambda7__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_settings_daemon_settings___lambda7_ ((SettingsDaemonSettings*) self);
}

static void
_settings_daemon_settings___lambda8_ (SettingsDaemonSettings* self)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = settings_daemon_settings_get_accent_color (self);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, settings_daemon_settings_signals[SETTINGS_DAEMON_SETTINGS_SETTING_CHANGED_SIGNAL], 0, "org.freedesktop.appearance", "accent-color", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
__settings_daemon_settings___lambda8__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_settings_daemon_settings___lambda8_ ((SettingsDaemonSettings*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SettingsDaemonSettings* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_settings_daemon_settings______lambda9_ (Block2Data* _data2_,
                                         const gchar* key)
{
	SettingsDaemonSettings* self;
	GVariant* value = NULL;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	GVariant* _tmp3_;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	self = _data2_->self;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _data2_->schema;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = g_settings_get_value ((GSettings*) _tmp2_, key);
	value = _tmp3_;
	_tmp4_ = _data2_->schema;
	_tmp5_ = value;
	g_signal_emit (self, settings_daemon_settings_signals[SETTINGS_DAEMON_SETTINGS_SETTING_CHANGED_SIGNAL], 0, _tmp4_, key, _tmp5_);
	_g_variant_unref0 (value);
}

static void
__settings_daemon_settings______lambda9__g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self)
{
	_settings_daemon_settings______lambda9_ (self, key);
}

static GObject *
settings_daemon_settings_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SettingsDaemonSettings * self;
	AccountsServiceMonitor* _tmp0_;
	AccountsServiceMonitor* _tmp1_;
	AccountsServiceMonitor* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	parent_class = G_OBJECT_CLASS (settings_daemon_settings_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettings);
	_tmp0_ = accounts_service_monitor_new ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = self->priv->monitor;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::color-scheme", (GCallback) __settings_daemon_settings___lambda7__g_object_notify, self, 0);
	_tmp2_ = self->priv->monitor;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::accent-color", (GCallback) __settings_daemon_settings___lambda8__g_object_notify, self, 0);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = SETTINGS_DAEMON_SETTINGS_SUPPORTED_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (SETTINGS_DAEMON_SETTINGS_SUPPORTED_SCHEMAS);
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			const gchar* schema = NULL;
			schema = schema_collection[schema_it];
			{
				Block2Data* _data2_;
				GSettingsSchemaSource* _tmp6_;
				const gchar* _tmp7_;
				GSettingsSchema* _tmp8_;
				GSettingsSchema* _tmp9_;
				gboolean _tmp10_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				_data2_->schema = schema;
				_tmp6_ = g_settings_schema_source_get_default ();
				_tmp7_ = _data2_->schema;
				_tmp8_ = g_settings_schema_source_lookup (_tmp6_, _tmp7_, TRUE);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_ != NULL;
				_g_settings_schema_unref0 (_tmp9_);
				if (_tmp10_) {
					GHashTable* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GSettings* _tmp14_;
					GHashTable* _tmp15_;
					const gchar* _tmp16_;
					gconstpointer _tmp17_;
					_tmp11_ = self->priv->settings;
					_tmp12_ = _data2_->schema;
					_tmp13_ = _data2_->schema;
					_tmp14_ = g_settings_new (_tmp13_);
					g_hash_table_insert (_tmp11_, _tmp12_, _tmp14_);
					_tmp15_ = self->priv->settings;
					_tmp16_ = _data2_->schema;
					_tmp17_ = g_hash_table_lookup (_tmp15_, _tmp16_);
					g_signal_connect_data ((GSettings*) _tmp17_, "changed", (GCallback) __settings_daemon_settings______lambda9__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = _data2_->schema;
					g_warning ("Settings.vala:156: GSettings schema `%s` not found on the system!", _tmp18_);
				}
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	return obj;
}

static void
settings_daemon_settings_class_init (SettingsDaemonSettingsClass * klass,
                                     gpointer klass_data)
{
	settings_daemon_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsDaemonSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_settings_daemon_settings_get_property;
	G_OBJECT_CLASS (klass)->constructor = settings_daemon_settings_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_daemon_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SETTINGS_DAEMON_SETTINGS_VERSION_PROPERTY, settings_daemon_settings_properties[SETTINGS_DAEMON_SETTINGS_VERSION_PROPERTY] = g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	settings_daemon_settings_signals[SETTINGS_DAEMON_SETTINGS_SETTING_CHANGED_SIGNAL] = g_signal_new ("setting-changed", SETTINGS_DAEMON_TYPE_SETTINGS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);
}

static void
settings_daemon_settings_instance_init (SettingsDaemonSettings * self,
                                        gpointer klass)
{
	self->priv = settings_daemon_settings_get_instance_private (self);
}

static void
settings_daemon_settings_finalize (GObject * obj)
{
	SettingsDaemonSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettings);
	_g_hash_table_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (settings_daemon_settings_parent_class)->finalize (obj);
}

static GType
settings_daemon_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonSettings), 0, (GInstanceInitFunc) settings_daemon_settings_instance_init, NULL };
	GType settings_daemon_settings_type_id;
	settings_daemon_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsDaemonSettings", &g_define_type_info, 0);
	g_type_set_qdata (settings_daemon_settings_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) settings_daemon_settings_register_object);
	SettingsDaemonSettings_private_offset = g_type_add_instance_private (settings_daemon_settings_type_id, sizeof (SettingsDaemonSettingsPrivate));
	return settings_daemon_settings_type_id;
}

GType
settings_daemon_settings_get_type (void)
{
	static volatile gsize settings_daemon_settings_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_settings_type_id__once)) {
		GType settings_daemon_settings_type_id;
		settings_daemon_settings_type_id = settings_daemon_settings_get_type_once ();
		g_once_init_leave (&settings_daemon_settings_type_id__once, settings_daemon_settings_type_id);
	}
	return settings_daemon_settings_type_id__once;
}

static void
_vala_settings_daemon_settings_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SettingsDaemonSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SETTINGS_DAEMON_TYPE_SETTINGS, SettingsDaemonSettings);
	switch (property_id) {
		case SETTINGS_DAEMON_SETTINGS_VERSION_PROPERTY:
		g_value_set_uint (value, settings_daemon_settings_get_version (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_settings_daemon_settings_read_all (SettingsDaemonSettings* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonSettingsReadAllReadyData* _ready_data;
	GVariant* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonSettingsReadAllReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (gchar*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (gchar*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	_ready_data->namespaces_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	_ready_data->namespaces = _tmp6_;
	g_variant_unref (_tmp5_);
	settings_daemon_settings_read_all (self, _ready_data->namespaces, _ready_data->namespaces_length1, (GAsyncReadyCallback) _dbus_settings_daemon_settings_read_all_ready, _ready_data);
	_error:
	;
}

static void
_dbus_settings_daemon_settings_read_all_ready (GObject * source_object,
                                               GAsyncResult * _res_,
                                               gpointer _user_data_)
{
	SettingsDaemonSettingsReadAllReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp9_;
	GHashTableIter _tmp10_;
	gpointer _tmp11_;
	gpointer _tmp12_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = settings_daemon_settings_read_all_finish ((SettingsDaemonSettings*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp10_, result);
	g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("a{sa{sv}}"));
	while (g_hash_table_iter_next (&_tmp10_, &_tmp11_, &_tmp12_)) {
		gchar* _key;
		GHashTable* _value;
		GVariantBuilder _tmp13_;
		GHashTableIter _tmp14_;
		gpointer _tmp15_;
		gpointer _tmp16_;
		_key = (gchar*) _tmp11_;
		_value = (GHashTable*) _tmp12_;
		g_hash_table_iter_init (&_tmp14_, _value);
		g_variant_builder_init (&_tmp13_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp14_, &_tmp15_, &_tmp16_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp15_;
			_value = (GVariant*) _tmp16_;
			g_variant_builder_add (&_tmp13_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add (&_tmp9_, "{?*}", g_variant_new_string (_key), g_variant_builder_end (&_tmp13_));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp9_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->namespaces = (_vala_array_free (_ready_data->namespaces, _ready_data->namespaces_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (SettingsDaemonSettingsReadAllReadyData, _ready_data);
}

static void
_dbus_settings_daemon_settings_read (SettingsDaemonSettings* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonSettingsReadReadyData* _ready_data;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonSettingsReadReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->namespace = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->key = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	settings_daemon_settings_read (self, _ready_data->namespace, _ready_data->key, (GAsyncReadyCallback) _dbus_settings_daemon_settings_read_ready, _ready_data);
	_error:
	;
}

static void
_dbus_settings_daemon_settings_read_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_)
{
	SettingsDaemonSettingsReadReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = settings_daemon_settings_read_finish ((SettingsDaemonSettings*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_variant (result));
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->namespace);
	_g_free0 (_ready_data->key);
	g_slice_free (SettingsDaemonSettingsReadReadyData, _ready_data);
}

static void
settings_daemon_settings_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ReadAll") == 0) {
		_dbus_settings_daemon_settings_read_all (object, parameters, invocation);
	} else if (strcmp (method_name, "Read") == 0) {
		_dbus_settings_daemon_settings_read (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_settings_daemon_settings_get_version (SettingsDaemonSettings* self)
{
	guint32 result;
	GVariant* _reply;
	result = settings_daemon_settings_get_version (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
settings_daemon_settings_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Version") == 0) {
		return _dbus_settings_daemon_settings_get_version (object);
	}
	return NULL;
}

static gboolean
settings_daemon_settings_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_settings_daemon_settings_setting_changed (GObject* _sender,
                                                const gchar* namespace,
                                                const gchar* key,
                                                GVariant* value,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (namespace));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (key));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_variant (value));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.impl.portal.Settings", "SettingChanged", _arguments, NULL);
}

guint
settings_daemon_settings_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_settings_daemon_settings_dbus_interface_info), &_settings_daemon_settings_dbus_interface_vtable, data, _settings_daemon_settings_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "setting-changed", (GCallback) _dbus_settings_daemon_settings_setting_changed, data);
	return result;
}

static void
_settings_daemon_settings_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_settings_daemon_settings_setting_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

