/* CheckerboardItem.c generated by valac 0.56.18, the Vala compiler
 * generated from CheckerboardItem.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;
enum  {
	CHECKERBOARD_ITEM_0_PROPERTY,
	CHECKERBOARD_ITEM_NUM_PROPERTIES
};
static GParamSpec* checkerboard_item_properties[CHECKERBOARD_ITEM_NUM_PROPERTIES];
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	CheckerboardItemText* comment;
	CheckerboardItemText* subtitle;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gboolean _comment_visible;
	gboolean _subtitle_visible;
	gboolean _title_visible;
};

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

static gint CheckerboardItem_private_offset;
static gpointer checkerboard_item_parent_class = NULL;

VALA_EXTERN gpointer checkerboard_item_text_ref (gpointer instance);
VALA_EXTERN void checkerboard_item_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_checkerboard_item_text (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_checkerboard_item_text (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_checkerboard_item_text (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_checkerboard_item_text (const GValue* value);
VALA_EXTERN GType checkerboard_item_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CheckerboardItemText* checkerboard_item_text_new (const gchar* text,
                                                  PangoAlignment alignment,
                                                  gboolean marked_up);
VALA_EXTERN CheckerboardItemText* checkerboard_item_text_construct (GType object_type,
                                                        const gchar* text,
                                                        PangoAlignment alignment,
                                                        gboolean marked_up);
static gchar* checkerboard_item_real_get_name (DataObject* base);
VALA_EXTERN gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
VALA_EXTERN gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self,
                                           const gchar* text,
                                           gboolean marked_up,
                                           PangoAlignment alignment);
static gboolean checkerboard_item_get_title_visible (CheckerboardItem* self);
static void checkerboard_item_recalc_size (CheckerboardItem* self,
                                    const gchar* reason);
static gboolean checkerboard_item_get_comment_visible (CheckerboardItem* self);
static gboolean checkerboard_item_get_subtitle_visible (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                       DataCollection* collection);
static void _vala_GValue_free (GValue* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self,
                                          gboolean value);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                            gboolean value);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                             gboolean value);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                            const gchar* name,
                                                            GValue* old,
                                                            GValue* val);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
VALA_EXTERN gint checkerboard_item_text_get_height (CheckerboardItemText* self);
static void checkerboard_item_real_paint (CheckerboardItem* self,
                                   cairo_t* ctx,
                                   GtkStyleContext* style_context);
VALA_EXTERN PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self,
                                                      gint max_width);
static void checkerboard_item_real_visibility_changed (DataView* base,
                                                gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                                  CheckerboardItemText* text,
                                                  GtkTooltip* tooltip);
VALA_EXTERN gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
VALA_EXTERN gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
static void checkerboard_item_finalize (GObject * obj);
static GType checkerboard_item_get_type_once (void);
static void _vala_checkerboard_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_checkerboard_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
checkerboard_item_get_instance_private (CheckerboardItem* self)
{
	return G_STRUCT_MEMBER_P (self, CheckerboardItem_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

CheckerboardItem*
checkerboard_item_construct (GType object_type,
                             ThumbnailSource* source,
                             Dimensions* initial_pixbuf_dim,
                             const gchar* title,
                             const gchar* comment,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	CheckerboardItem * self = NULL;
	Dimensions _tmp0_;
	CheckerboardItemText* _tmp1_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, source);
	_tmp0_ = *initial_pixbuf_dim;
	self->priv->pixbuf_dim = _tmp0_;
	_tmp1_ = checkerboard_item_text_new (title, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = _tmp1_;
	if (comment != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		CheckerboardItemText* _tmp4_;
		_tmp2_ = string_replace (comment, "\n", " ");
		_tmp3_ = _tmp2_;
		_tmp4_ = checkerboard_item_text_new (_tmp3_, alignment, marked_up);
		_checkerboard_item_text_unref0 (self->priv->comment);
		self->priv->comment = _tmp4_;
		_g_free0 (_tmp3_);
	}
	return self;
}

static gchar*
checkerboard_item_real_get_name (DataObject* base)
{
	CheckerboardItem * self;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	self = (CheckerboardItem*) base;
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->title;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_item_get_title (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->title;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_item_get_comment (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->comment;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->comment;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_item_set_title (CheckerboardItem* self,
                             const gchar* text,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->title;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = _tmp3_;
	_tmp4_ = checkerboard_item_get_title_visible (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		checkerboard_item_recalc_size (self, "set_title");
		data_view_notify_view_altered ((DataView*) self);
	}
}

void
checkerboard_item_clear_title (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = NULL;
	_tmp1_ = checkerboard_item_get_title_visible (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		checkerboard_item_recalc_size (self, "clear_title");
		data_view_notify_view_altered ((DataView*) self);
	}
}

void
checkerboard_item_set_comment (CheckerboardItem* self,
                               const gchar* text,
                               gboolean marked_up,
                               PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	CheckerboardItemText* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->comment;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->comment;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = string_replace (text, "\n", " ");
	_tmp4_ = _tmp3_;
	_tmp5_ = checkerboard_item_text_new (_tmp4_, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->comment);
	self->priv->comment = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = checkerboard_item_get_comment_visible (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		checkerboard_item_recalc_size (self, "set_comment");
		data_view_notify_view_altered ((DataView*) self);
	}
}

void
checkerboard_item_clear_comment (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->comment;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->comment);
	self->priv->comment = NULL;
	_tmp1_ = checkerboard_item_get_comment_visible (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		checkerboard_item_recalc_size (self, "clear_comment");
		data_view_notify_view_altered ((DataView*) self);
	}
}

gchar*
checkerboard_item_get_subtitle (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->subtitle;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->subtitle;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_item_set_subtitle (CheckerboardItem* self,
                                const gchar* text,
                                gboolean marked_up,
                                PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->subtitle;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->subtitle;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp3_;
	_tmp4_ = checkerboard_item_get_subtitle_visible (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		checkerboard_item_recalc_size (self, "set_subtitle");
		data_view_notify_view_altered ((DataView*) self);
	}
}

void
checkerboard_item_clear_subtitle (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subtitle;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = NULL;
	_tmp1_ = checkerboard_item_get_subtitle_visible (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		checkerboard_item_recalc_size (self, "clear_subtitle");
		data_view_notify_view_altered ((DataView*) self);
	}
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                  DataCollection* collection)
{
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_;
	GValue* _tmp2_;
	gboolean _tmp3_;
	gboolean comment_visible = FALSE;
	GValue* _tmp4_ = NULL;
	GValue* _tmp5_;
	GValue* _tmp6_;
	gboolean _tmp7_;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp8_ = NULL;
	GValue* _tmp9_;
	GValue* _tmp10_;
	gboolean _tmp11_;
	gboolean altered = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_ = FALSE;
	self = (CheckerboardItem*) base;
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp0_, TRUE);
	_tmp1_ = data_object_get_collection_property ((DataObject*) self, CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_value_get_boolean (_tmp1_);
	__vala_GValue_free0 (_tmp2_);
	__vala_GValue_free0 (_tmp0_);
	title_visible = _tmp3_;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp4_, TRUE);
	_tmp5_ = data_object_get_collection_property ((DataObject*) self, CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_value_get_boolean (_tmp5_);
	__vala_GValue_free0 (_tmp6_);
	__vala_GValue_free0 (_tmp4_);
	comment_visible = _tmp7_;
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp8_, FALSE);
	_tmp9_ = data_object_get_collection_property ((DataObject*) self, CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_value_get_boolean (_tmp9_);
	__vala_GValue_free0 (_tmp10_);
	__vala_GValue_free0 (_tmp8_);
	subtitle_visible = _tmp11_;
	altered = FALSE;
	_tmp12_ = checkerboard_item_get_title_visible (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != title_visible) {
		checkerboard_item_set_title_visible (self, title_visible);
		altered = TRUE;
	}
	_tmp14_ = checkerboard_item_get_comment_visible (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != comment_visible) {
		checkerboard_item_set_comment_visible (self, comment_visible);
		altered = TRUE;
	}
	_tmp16_ = checkerboard_item_get_subtitle_visible (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != subtitle_visible) {
		checkerboard_item_set_subtitle_visible (self, subtitle_visible);
		altered = TRUE;
	}
	if (altered) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = !dimensions_has_area (&self->requisition);
	}
	if (_tmp18_) {
		checkerboard_item_recalc_size (self, "notify_membership_changed");
		data_view_notify_view_altered ((DataView*) self);
	}
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), collection);
}

static void
checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                       const gchar* name,
                                                       GValue* old,
                                                       GValue* val)
{
	CheckerboardItem * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GValue _tmp6_;
	self = (CheckerboardItem*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)))) {
		switch (0) {
			default:
			{
				GValue _tmp3_;
				_tmp3_ = *val;
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp3_));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)))) {
		switch (0) {
			default:
			{
				GValue _tmp4_;
				_tmp4_ = *val;
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp4_));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)))) {
		switch (0) {
			default:
			{
				GValue _tmp5_;
				_tmp5_ = *val;
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp5_));
				break;
			}
		}
	}
	_tmp6_ = *val;
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set ((DataObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), name, old, &_tmp6_);
}

gint
checkerboard_item_get_alignment_point (CheckerboardItem* self)
{
	Dimensions _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pixbuf_dim;
	_tmp1_ = thumbnail_cache_get_scale_factor ();
	_tmp2_ = _tmp1_;
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + (_tmp0_.height / _tmp2_);
	return result;
}

static void
checkerboard_item_real_exposed (CheckerboardItem* self)
{
	self->priv->exposure = TRUE;
}

void
checkerboard_item_exposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->exposed) {
		_klass_->exposed (self);
	}
}

static void
checkerboard_item_real_unexposed (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	CheckerboardItemText* _tmp2_;
	CheckerboardItemText* _tmp4_;
	self->priv->exposure = FALSE;
	_tmp0_ = self->priv->title;
	if (_tmp0_ != NULL) {
		CheckerboardItemText* _tmp1_;
		_tmp1_ = self->priv->title;
		checkerboard_item_text_clear_pango_layout (_tmp1_);
	}
	_tmp2_ = self->priv->comment;
	if (_tmp2_ != NULL) {
		CheckerboardItemText* _tmp3_;
		_tmp3_ = self->priv->comment;
		checkerboard_item_text_clear_pango_layout (_tmp3_);
	}
	_tmp4_ = self->priv->subtitle;
	if (_tmp4_ != NULL) {
		CheckerboardItemText* _tmp5_;
		_tmp5_ = self->priv->subtitle;
		checkerboard_item_text_clear_pango_layout (_tmp5_);
	}
}

void
checkerboard_item_unexposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->unexposed) {
		_klass_->unexposed (self);
	}
}

static gboolean
checkerboard_item_real_is_exposed (CheckerboardItem* self)
{
	gboolean result;
	result = self->priv->exposure;
	return result;
}

gboolean
checkerboard_item_is_exposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->is_exposed) {
		return _klass_->is_exposed (self);
	}
	return FALSE;
}

gboolean
checkerboard_item_has_image (CheckerboardItem* self)
{
	GdkPixbuf* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pixbuf;
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
checkerboard_item_get_image (CheckerboardItem* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
checkerboard_item_set_image (CheckerboardItem* self,
                             GdkPixbuf* pixbuf)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = _tmp0_;
	_tmp1_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp1_;
	dimensions_for_pixbuf (pixbuf, &_tmp2_);
	self->priv->pixbuf_dim = _tmp2_;
	checkerboard_item_recalc_size (self, "set_image");
	data_view_notify_view_altered ((DataView*) self);
}

void
checkerboard_item_clear_image (CheckerboardItem* self,
                               Dimensions* dim)
{
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = self->priv->pixbuf;
	had_image = _tmp0_ != NULL;
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = NULL;
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = NULL;
	_tmp1_ = *dim;
	self->priv->pixbuf_dim = _tmp1_;
	checkerboard_item_recalc_size (self, "clear_image");
	if (had_image) {
		data_view_notify_view_altered ((DataView*) self);
	}
}

gint
checkerboard_item_get_max_width (gint scale)
{
	gint result;
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + scale;
	return result;
}

static void
checkerboard_item_recalc_size (CheckerboardItem* self,
                               const gchar* reason)
{
	Dimensions old_requisition = {0};
	Dimensions _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_;
	gint title_height = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	CheckerboardItemText* _tmp9_;
	gint comment_height = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_;
	gint subtitle_height = 0;
	Dimensions _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	Dimensions _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	Dimensions _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	_tmp0_ = self->requisition;
	old_requisition = _tmp0_;
	_tmp3_ = self->priv->title;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = checkerboard_item_get_title_visible (self);
		_tmp5_ = _tmp4_;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		CheckerboardItemText* _tmp6_;
		_tmp6_ = self->priv->title;
		_tmp1_ = checkerboard_item_text_get_height (_tmp6_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp1_ = 0;
	}
	title_height = _tmp1_;
	_tmp9_ = self->priv->comment;
	if (_tmp9_ != NULL) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = checkerboard_item_get_comment_visible (self);
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		CheckerboardItemText* _tmp12_;
		_tmp12_ = self->priv->comment;
		_tmp7_ = checkerboard_item_text_get_height (_tmp12_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp7_ = 0;
	}
	comment_height = _tmp7_;
	_tmp15_ = self->priv->subtitle;
	if (_tmp15_ != NULL) {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = checkerboard_item_get_subtitle_visible (self);
		_tmp17_ = _tmp16_;
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		CheckerboardItemText* _tmp18_;
		_tmp18_ = self->priv->subtitle;
		_tmp13_ = checkerboard_item_text_get_height (_tmp18_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp13_ = 0;
	}
	subtitle_height = _tmp13_;
	_tmp19_ = self->priv->pixbuf_dim;
	_tmp20_ = thumbnail_cache_get_scale_factor ();
	_tmp21_ = _tmp20_;
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + (_tmp19_.width / _tmp21_);
	_tmp22_ = self->priv->pixbuf_dim;
	_tmp23_ = thumbnail_cache_get_scale_factor ();
	_tmp24_ = _tmp23_;
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + (_tmp22_.height / _tmp24_)) + title_height) + comment_height) + subtitle_height;
	_tmp25_ = old_requisition;
	if (!dimensions_approx_equals (&self->requisition, &_tmp25_, 1)) {
		data_view_notify_geometry_altered ((DataView*) self);
	}
}

void
checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                         gint border_width,
                                         Dimensions* result)
{
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (object_dim != NULL);
	dimensions_init (&dimensions, 0, 0);
	_tmp0_ = *object_dim;
	dimensions.width = _tmp0_.width + (border_width * 2);
	_tmp1_ = *object_dim;
	dimensions.height = _tmp1_.height + (border_width * 2);
	*result = dimensions;
	return;
}

void
checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                     gint border_width,
                                     GdkPoint* result)
{
	GdkPoint origin = {0};
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	g_return_if_fail (object_origin != NULL);
	memset (&origin, 0, sizeof (GdkPoint));
	_tmp0_ = *object_origin;
	origin.x = _tmp0_.x - border_width;
	_tmp1_ = *object_origin;
	origin.y = _tmp1_.y - border_width;
	*result = origin;
	return;
}

void
checkerboard_item_get_selection_button_area (CheckerboardItem* self,
                                             GdkRectangle* result)
{
	GdkRectangle selection_button_area = {0};
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	g_return_if_fail (self != NULL);
	memset (&selection_button_area, 0, sizeof (GdkRectangle));
	_tmp0_ = self->allocation;
	selection_button_area.x = _tmp0_.x;
	_tmp1_ = self->allocation;
	selection_button_area.y = _tmp1_.y;
	selection_button_area.width = CHECKERBOARD_ITEM_SELECTION_ICON_SIZE;
	selection_button_area.height = CHECKERBOARD_ITEM_SELECTION_ICON_SIZE;
	*result = selection_button_area;
	return;
}

static void
checkerboard_item_real_paint (CheckerboardItem* self,
                              cairo_t* ctx,
                              GtkStyleContext* style_context)
{
	gchar* selection_icon = NULL;
	gint scale_factor = 0;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* selection_icon_pix = NULL;
	const gchar* _tmp16_;
	GdkPixbuf* _tmp25_;
	gint text_y = 0;
	GdkRectangle _tmp30_;
	Dimensions _tmp31_;
	gboolean _tmp32_ = FALSE;
	CheckerboardItemText* _tmp33_;
	gboolean _tmp49_ = FALSE;
	CheckerboardItemText* _tmp50_;
	gboolean _tmp66_ = FALSE;
	CheckerboardItemText* _tmp67_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (style_context != NULL);
	gtk_style_context_save (style_context);
	selection_icon = NULL;
	if (data_view_is_selected ((DataView*) self)) {
		gchar* _tmp0_;
		gtk_style_context_set_state (style_context, GTK_STATE_FLAG_CHECKED);
		_tmp0_ = g_strdup (RESOURCES_ICON_SELECTION_REMOVE);
		_g_free0 (selection_icon);
		selection_icon = _tmp0_;
	} else {
		GdkPixbuf* _tmp1_;
		_tmp1_ = self->priv->brightened;
		if (_tmp1_ != NULL) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (RESOURCES_ICON_SELECTION_ADD);
			_g_free0 (selection_icon);
			selection_icon = _tmp2_;
		}
	}
	scale_factor = gtk_style_context_get_scale (style_context);
	_tmp3_ = self->priv->display_pixbuf;
	if (_tmp3_ != NULL) {
		gint origin_x = 0;
		GdkRectangle _tmp4_;
		gint origin_y = 0;
		GdkRectangle _tmp5_;
		gint pixbuf_width = 0;
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint pixbuf_height = 0;
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint radius = 0;
		GValue _tmp12_ = {0};
		GValue _tmp13_;
		gint _tmp14_;
		GdkPixbuf* _tmp15_;
		_tmp4_ = self->allocation;
		origin_x = (_tmp4_.x + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
		_tmp5_ = self->allocation;
		origin_y = (_tmp5_.y + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
		_tmp6_ = self->priv->display_pixbuf;
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
		_tmp8_ = _tmp7_;
		pixbuf_width = _tmp8_ / scale_factor;
		_tmp9_ = self->priv->display_pixbuf;
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
		_tmp11_ = _tmp10_;
		pixbuf_height = _tmp11_ / scale_factor;
		gtk_render_background (style_context, ctx, (gdouble) origin_x, (gdouble) origin_y, (gdouble) pixbuf_width, (gdouble) pixbuf_height);
		gtk_style_context_get_property (style_context, "border-radius", gtk_style_context_get_state (style_context), &_tmp12_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_value_get_int (&_tmp13_);
		G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
		radius = _tmp14_;
		cairo_save (ctx);
		cairo_move_to (ctx, (gdouble) (origin_x + radius), (gdouble) origin_y);
		cairo_arc (ctx, (gdouble) ((origin_x + pixbuf_width) - radius), (gdouble) (origin_y + radius), (gdouble) radius, G_PI * 1.5, G_PI * 2);
		cairo_arc (ctx, (gdouble) ((origin_x + pixbuf_width) - radius), (gdouble) ((origin_y + pixbuf_height) - radius), (gdouble) radius, (gdouble) 0, G_PI_2);
		cairo_arc (ctx, (gdouble) (origin_x + radius), (gdouble) ((origin_y + pixbuf_height) - radius), (gdouble) radius, G_PI_2, G_PI);
		cairo_arc (ctx, (gdouble) (origin_x + radius), (gdouble) (origin_y + radius), (gdouble) radius, G_PI, G_PI * 1.5);
		cairo_close_path (ctx);
		cairo_scale (ctx, 1.0 / scale_factor, 1.0 / scale_factor);
		_tmp15_ = self->priv->display_pixbuf;
		gdk_cairo_set_source_pixbuf (ctx, _tmp15_, (gdouble) (origin_x * scale_factor), (gdouble) (origin_y * scale_factor));
		cairo_clip (ctx);
		cairo_paint (ctx);
		cairo_restore (ctx);
		gtk_render_frame (style_context, ctx, (gdouble) origin_x, (gdouble) origin_y, (gdouble) pixbuf_width, (gdouble) pixbuf_height);
	}
	selection_icon_pix = NULL;
	_tmp16_ = selection_icon;
	if (_tmp16_ != NULL) {
		{
			GdkPixbuf* _tmp17_ = NULL;
			GtkIconTheme* _tmp18_;
			const gchar* _tmp19_;
			GdkPixbuf* _tmp20_;
			GdkPixbuf* _tmp21_;
			_tmp18_ = gtk_icon_theme_get_default ();
			_tmp19_ = selection_icon;
			_tmp20_ = gtk_icon_theme_load_icon_for_scale (_tmp18_, _tmp19_, CHECKERBOARD_ITEM_SELECTION_ICON_SIZE, scale_factor, GTK_ICON_LOOKUP_GENERIC_FALLBACK, &_inner_error0_);
			_tmp17_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp21_ = _tmp17_;
			_tmp17_ = NULL;
			_g_object_unref0 (selection_icon_pix);
			selection_icon_pix = _tmp21_;
			_g_object_unref0 (_tmp17_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = selection_icon;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			g_warning ("CheckerboardItem.vala:420: Could not load %s: %s", _tmp22_, _tmp24_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (selection_icon_pix);
			_g_free0 (selection_icon);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp25_ = selection_icon_pix;
	if (_tmp25_ != NULL) {
		GdkRectangle selection_icon_area = {0};
		GdkRectangle _tmp26_ = {0};
		GdkPixbuf* _tmp27_;
		GdkRectangle _tmp28_;
		GdkRectangle _tmp29_;
		checkerboard_item_get_selection_button_area (self, &_tmp26_);
		selection_icon_area = _tmp26_;
		cairo_save (ctx);
		cairo_scale (ctx, 1.0 / scale_factor, 1.0 / scale_factor);
		_tmp27_ = selection_icon_pix;
		_tmp28_ = selection_icon_area;
		_tmp29_ = selection_icon_area;
		gtk_render_icon (style_context, ctx, _tmp27_, (gdouble) (_tmp28_.x * scale_factor), (gdouble) (_tmp29_.y * scale_factor));
		cairo_restore (ctx);
	}
	gtk_style_context_add_class (style_context, GTK_STYLE_CLASS_LABEL);
	_tmp30_ = self->allocation;
	_tmp31_ = self->priv->pixbuf_dim;
	text_y = (((_tmp30_.y + CHECKERBOARD_ITEM_FRAME_WIDTH) + (_tmp31_.height / scale_factor)) + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
	_tmp33_ = self->priv->title;
	if (_tmp33_ != NULL) {
		gboolean _tmp34_;
		gboolean _tmp35_;
		_tmp34_ = checkerboard_item_get_title_visible (self);
		_tmp35_ = _tmp34_;
		_tmp32_ = _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkRectangle title_allocation = {0};
		CheckerboardItemText* _tmp36_;
		GdkRectangle _tmp37_;
		GdkRectangle _tmp38_;
		Dimensions _tmp39_;
		CheckerboardItemText* _tmp40_;
		PangoLayout* layout = NULL;
		CheckerboardItemText* _tmp41_;
		Dimensions _tmp42_;
		PangoLayout* _tmp43_;
		PangoLayout* _tmp44_;
		GdkRectangle _tmp45_;
		GdkRectangle _tmp46_;
		PangoLayout* _tmp47_;
		CheckerboardItemText* _tmp48_;
		_tmp36_ = self->priv->title;
		_tmp37_ = _tmp36_->allocation;
		title_allocation = _tmp37_;
		_tmp38_ = self->allocation;
		title_allocation.x = _tmp38_.x + CHECKERBOARD_ITEM_FRAME_WIDTH;
		title_allocation.y = text_y;
		_tmp39_ = self->priv->pixbuf_dim;
		title_allocation.width = _tmp39_.width / scale_factor;
		_tmp40_ = self->priv->title;
		title_allocation.height = checkerboard_item_text_get_height (_tmp40_);
		_tmp41_ = self->priv->title;
		_tmp42_ = self->priv->pixbuf_dim;
		_tmp43_ = checkerboard_item_text_get_pango_layout (_tmp41_, _tmp42_.width / scale_factor);
		layout = _tmp43_;
		_tmp44_ = layout;
		pango_cairo_update_layout (ctx, _tmp44_);
		_tmp45_ = title_allocation;
		_tmp46_ = title_allocation;
		_tmp47_ = layout;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp45_.x, (gdouble) _tmp46_.y, _tmp47_);
		_tmp48_ = self->priv->title;
		text_y += checkerboard_item_text_get_height (_tmp48_) + CHECKERBOARD_ITEM_LABEL_PADDING;
		_g_object_unref0 (layout);
	}
	_tmp50_ = self->priv->comment;
	if (_tmp50_ != NULL) {
		gboolean _tmp51_;
		gboolean _tmp52_;
		_tmp51_ = checkerboard_item_get_comment_visible (self);
		_tmp52_ = _tmp51_;
		_tmp49_ = _tmp52_;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		GdkRectangle comment_allocation = {0};
		CheckerboardItemText* _tmp53_;
		GdkRectangle _tmp54_;
		GdkRectangle _tmp55_;
		Dimensions _tmp56_;
		CheckerboardItemText* _tmp57_;
		PangoLayout* layout = NULL;
		CheckerboardItemText* _tmp58_;
		Dimensions _tmp59_;
		PangoLayout* _tmp60_;
		PangoLayout* _tmp61_;
		GdkRectangle _tmp62_;
		GdkRectangle _tmp63_;
		PangoLayout* _tmp64_;
		CheckerboardItemText* _tmp65_;
		_tmp53_ = self->priv->comment;
		_tmp54_ = _tmp53_->allocation;
		comment_allocation = _tmp54_;
		_tmp55_ = self->allocation;
		comment_allocation.x = _tmp55_.x + CHECKERBOARD_ITEM_FRAME_WIDTH;
		comment_allocation.y = text_y;
		_tmp56_ = self->priv->pixbuf_dim;
		comment_allocation.width = _tmp56_.width / scale_factor;
		_tmp57_ = self->priv->comment;
		comment_allocation.height = checkerboard_item_text_get_height (_tmp57_);
		_tmp58_ = self->priv->comment;
		_tmp59_ = self->priv->pixbuf_dim;
		_tmp60_ = checkerboard_item_text_get_pango_layout (_tmp58_, _tmp59_.width / scale_factor);
		layout = _tmp60_;
		_tmp61_ = layout;
		pango_cairo_update_layout (ctx, _tmp61_);
		_tmp62_ = comment_allocation;
		_tmp63_ = comment_allocation;
		_tmp64_ = layout;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp62_.x, (gdouble) _tmp63_.y, _tmp64_);
		_tmp65_ = self->priv->comment;
		text_y += checkerboard_item_text_get_height (_tmp65_) + CHECKERBOARD_ITEM_LABEL_PADDING;
		_g_object_unref0 (layout);
	}
	_tmp67_ = self->priv->subtitle;
	if (_tmp67_ != NULL) {
		gboolean _tmp68_;
		gboolean _tmp69_;
		_tmp68_ = checkerboard_item_get_subtitle_visible (self);
		_tmp69_ = _tmp68_;
		_tmp66_ = _tmp69_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		GdkRectangle subtitle_allocation = {0};
		CheckerboardItemText* _tmp70_;
		GdkRectangle _tmp71_;
		GdkRectangle _tmp72_;
		Dimensions _tmp73_;
		CheckerboardItemText* _tmp74_;
		PangoLayout* layout = NULL;
		CheckerboardItemText* _tmp75_;
		Dimensions _tmp76_;
		PangoLayout* _tmp77_;
		PangoLayout* _tmp78_;
		GdkRectangle _tmp79_;
		GdkRectangle _tmp80_;
		PangoLayout* _tmp81_;
		_tmp70_ = self->priv->subtitle;
		_tmp71_ = _tmp70_->allocation;
		subtitle_allocation = _tmp71_;
		_tmp72_ = self->allocation;
		subtitle_allocation.x = _tmp72_.x + CHECKERBOARD_ITEM_FRAME_WIDTH;
		subtitle_allocation.y = text_y;
		_tmp73_ = self->priv->pixbuf_dim;
		subtitle_allocation.width = _tmp73_.width / scale_factor;
		_tmp74_ = self->priv->subtitle;
		subtitle_allocation.height = checkerboard_item_text_get_height (_tmp74_);
		_tmp75_ = self->priv->subtitle;
		_tmp76_ = self->priv->pixbuf_dim;
		_tmp77_ = checkerboard_item_text_get_pango_layout (_tmp75_, _tmp76_.width / scale_factor);
		layout = _tmp77_;
		_tmp78_ = layout;
		pango_cairo_update_layout (ctx, _tmp78_);
		_tmp79_ = subtitle_allocation;
		_tmp80_ = subtitle_allocation;
		_tmp81_ = layout;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp79_.x, (gdouble) _tmp80_.y, _tmp81_);
		_g_object_unref0 (layout);
	}
	gtk_style_context_restore (style_context);
	_g_object_unref0 (selection_icon_pix);
	_g_free0 (selection_icon);
}

void
checkerboard_item_paint (CheckerboardItem* self,
                         cairo_t* ctx,
                         GtkStyleContext* style_context)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->paint) {
		_klass_->paint (self, ctx, style_context);
	}
}

void
checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                        gint col,
                                        gint row)
{
	g_return_if_fail (self != NULL);
	self->priv->col = col;
	self->priv->row = row;
}

gint
checkerboard_item_get_column (CheckerboardItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->col;
	return result;
}

gint
checkerboard_item_get_row (CheckerboardItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->row;
	return result;
}

void
checkerboard_item_brighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->brightened;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->pixbuf;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->pixbuf;
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
	_g_object_unref0 (self->priv->brightened);
	self->priv->brightened = _tmp4_;
	_tmp5_ = self->priv->brightened;
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
	_tmp6_ = self->priv->brightened;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp7_;
	data_view_notify_view_altered ((DataView*) self);
}

void
checkerboard_item_unbrighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->brightened;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->pixbuf;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_g_object_unref0 (self->priv->brightened);
	self->priv->brightened = NULL;
	_tmp3_ = self->priv->pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp4_;
	data_view_notify_view_altered ((DataView*) self);
}

static void
checkerboard_item_real_visibility_changed (DataView* base,
                                           gboolean visible)
{
	CheckerboardItem * self;
	self = (CheckerboardItem*) base;
	if (!visible) {
		checkerboard_item_unbrighten (self);
	}
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed ((DataView*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), visible);
}

static gboolean
checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                         CheckerboardItemText* text,
                                         GtkTooltip* tooltip)
{
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = checkerboard_item_text_get_pango_layout (text, 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = !pango_layout_is_ellipsized (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	if (checkerboard_item_text_is_marked_up (text)) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = checkerboard_item_text_get_text (text);
		_tmp4_ = _tmp3_;
		gtk_tooltip_set_markup (tooltip, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = checkerboard_item_text_get_text (text);
		_tmp6_ = _tmp5_;
		gtk_tooltip_set_text (tooltip, _tmp6_);
		_g_free0 (_tmp6_);
	}
	result = TRUE;
	return result;
}

gboolean
checkerboard_item_query_tooltip (CheckerboardItem* self,
                                 gint x,
                                 gint y,
                                 GtkTooltip* tooltip)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	CheckerboardItemText* _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp2_ = self->priv->title;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = checkerboard_item_get_title_visible (self);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		CheckerboardItemText* _tmp5_;
		GdkRectangle _tmp6_;
		_tmp5_ = self->priv->title;
		_tmp6_ = _tmp5_->allocation;
		_tmp0_ = coord_in_rectangle (x, y, &_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CheckerboardItemText* _tmp7_;
		_tmp7_ = self->priv->title;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp7_, tooltip);
		return result;
	}
	_tmp10_ = self->priv->comment;
	if (_tmp10_ != NULL) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = checkerboard_item_get_comment_visible (self);
		_tmp12_ = _tmp11_;
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		CheckerboardItemText* _tmp13_;
		GdkRectangle _tmp14_;
		_tmp13_ = self->priv->comment;
		_tmp14_ = _tmp13_->allocation;
		_tmp8_ = coord_in_rectangle (x, y, &_tmp14_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		CheckerboardItemText* _tmp15_;
		_tmp15_ = self->priv->comment;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp15_, tooltip);
		return result;
	}
	_tmp18_ = self->priv->subtitle;
	if (_tmp18_ != NULL) {
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp19_ = checkerboard_item_get_subtitle_visible (self);
		_tmp20_ = _tmp19_;
		_tmp17_ = _tmp20_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		CheckerboardItemText* _tmp21_;
		GdkRectangle _tmp22_;
		_tmp21_ = self->priv->subtitle;
		_tmp22_ = _tmp21_->allocation;
		_tmp16_ = coord_in_rectangle (x, y, &_tmp22_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		CheckerboardItemText* _tmp23_;
		_tmp23_ = self->priv->subtitle;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp23_, tooltip);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
checkerboard_item_get_comment_visible (CheckerboardItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_comment_visible;
	return result;
}

static void
checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_comment_visible != value) {
		self->priv->_comment_visible = value;
		checkerboard_item_recalc_size (self, "set_comment_visible");
		data_view_notify_view_altered ((DataView*) self);
	}
}

static gboolean
checkerboard_item_get_subtitle_visible (CheckerboardItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_subtitle_visible;
	return result;
}

static void
checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_subtitle_visible != value) {
		self->priv->_subtitle_visible = value;
		checkerboard_item_recalc_size (self, "set_subtitle_visible");
		data_view_notify_view_altered ((DataView*) self);
	}
}

static gboolean
checkerboard_item_get_title_visible (CheckerboardItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_title_visible;
	return result;
}

static void
checkerboard_item_set_title_visible (CheckerboardItem* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_title_visible != value) {
		self->priv->_title_visible = value;
		checkerboard_item_recalc_size (self, "set_title_visible");
		data_view_notify_view_altered ((DataView*) self);
	}
}

static void
checkerboard_item_class_init (CheckerboardItemClass * klass,
                              gpointer klass_data)
{
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheckerboardItem_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) checkerboard_item_real_get_name;
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject*, DataCollection*)) checkerboard_item_real_notify_membership_changed;
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject*, const gchar*, GValue*, GValue*)) checkerboard_item_real_notify_collection_property_set;
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) checkerboard_item_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) checkerboard_item_real_unexposed;
	((CheckerboardItemClass *) klass)->is_exposed = (gboolean (*) (CheckerboardItem*)) checkerboard_item_real_is_exposed;
	((CheckerboardItemClass *) klass)->paint = (void (*) (CheckerboardItem*, cairo_t*, GtkStyleContext*)) checkerboard_item_real_paint;
	((DataViewClass *) klass)->visibility_changed = (void (*) (DataView*, gboolean)) checkerboard_item_real_visibility_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_checkerboard_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_checkerboard_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
}

static void
checkerboard_item_instance_init (CheckerboardItem * self,
                                 gpointer klass)
{
	self->priv = checkerboard_item_get_instance_private (self);
	dimensions_init (&self->requisition, 0, 0);
	memset (&self->allocation, 0, sizeof (GdkRectangle));
	self->priv->exposure = FALSE;
	self->priv->title = NULL;
	self->priv->comment = NULL;
	self->priv->subtitle = NULL;
	self->priv->pixbuf = NULL;
	self->priv->display_pixbuf = NULL;
	self->priv->brightened = NULL;
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
	self->priv->col = -1;
	self->priv->row = -1;
	self->priv->_comment_visible = TRUE;
	self->priv->_subtitle_visible = FALSE;
	self->priv->_title_visible = TRUE;
}

static void
checkerboard_item_finalize (GObject * obj)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	_checkerboard_item_text_unref0 (self->priv->title);
	_checkerboard_item_text_unref0 (self->priv->comment);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	_g_object_unref0 (self->priv->pixbuf);
	_g_object_unref0 (self->priv->display_pixbuf);
	_g_object_unref0 (self->priv->brightened);
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
}

static GType
checkerboard_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
	GType checkerboard_item_type_id;
	checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	CheckerboardItem_private_offset = g_type_add_instance_private (checkerboard_item_type_id, sizeof (CheckerboardItemPrivate));
	return checkerboard_item_type_id;
}

GType
checkerboard_item_get_type (void)
{
	static volatile gsize checkerboard_item_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__once)) {
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = checkerboard_item_get_type_once ();
		g_once_init_leave (&checkerboard_item_type_id__once, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__once;
}

static void
_vala_checkerboard_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_checkerboard_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

