/* MprisPlayer.c generated by valac 0.56.17, the Vala compiler
 * generated from MprisPlayer.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define MUSIC_APPLICATION_ACTION_NEXT "action-next"
#define MUSIC_APPLICATION_ACTION_PREVIOUS "action-previous"
#define MUSIC_APPLICATION_ACTION_PLAY_PAUSE "action-play-pause"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_MPRIS_PLAYER (music_mpris_player_get_type ())
#define MUSIC_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer))
#define MUSIC_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayerClass))
#define MUSIC_IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MPRIS_PLAYER))
#define MUSIC_IS_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MPRIS_PLAYER))
#define MUSIC_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayerClass))

typedef struct _MusicMprisPlayer MusicMprisPlayer;
typedef struct _MusicMprisPlayerClass MusicMprisPlayerClass;
typedef struct _MusicMprisPlayerPrivate MusicMprisPlayerPrivate;

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
enum  {
	MUSIC_MPRIS_PLAYER_0_PROPERTY,
	MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY,
	MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY,
	MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY,
	MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY,
	MUSIC_MPRIS_PLAYER_PLAYBACK_STATUS_PROPERTY,
	MUSIC_MPRIS_PLAYER_METADATA_PROPERTY,
	MUSIC_MPRIS_PLAYER_NUM_PROPERTIES
};
static GParamSpec* music_mpris_player_properties[MUSIC_MPRIS_PLAYER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define MUSIC_TYPE_AUDIO_OBJECT (music_audio_object_get_type ())
#define MUSIC_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject))
#define MUSIC_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))
#define MUSIC_IS_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_IS_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_AUDIO_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))

typedef struct _MusicAudioObject MusicAudioObject;
typedef struct _MusicAudioObjectClass MusicAudioObjectClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _MusicMprisPlayer {
	GObject parent_instance;
	MusicMprisPlayerPrivate * priv;
};

struct _MusicMprisPlayerClass {
	GObjectClass parent_class;
};

struct _MusicMprisPlayerPrivate {
	GDBusConnection* _connection;
	gboolean _can_go_next;
	gboolean _can_go_previous;
	gboolean _can_play;
	GApplication* application;
	MusicPlaybackManager* playback_manager;
};

static gint MusicMprisPlayer_private_offset;
static gpointer music_mpris_player_parent_class = NULL;

VALA_EXTERN GType music_mpris_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMprisPlayer, g_object_unref)
VALA_EXTERN guint music_mpris_player_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN MusicMprisPlayer* music_mpris_player_new (GDBusConnection* connection);
VALA_EXTERN MusicMprisPlayer* music_mpris_player_construct (GType object_type,
                                                GDBusConnection* connection);
static void music_mpris_player_send_property_change (MusicMprisPlayer* self,
                                              const gchar* name,
                                              GVariant* variant);
VALA_EXTERN GDBusConnection* music_mpris_player_get_connection (MusicMprisPlayer* self);
VALA_EXTERN void music_mpris_player_next (MusicMprisPlayer* self,
                              GError** error);
VALA_EXTERN void music_mpris_player_previous (MusicMprisPlayer* self,
                                  GError** error);
VALA_EXTERN void music_mpris_player_play_pause (MusicMprisPlayer* self,
                                    GError** error);
static void music_mpris_player_set_connection (MusicMprisPlayer* self,
                                        GDBusConnection* value);
VALA_EXTERN gboolean music_mpris_player_get_can_go_next (MusicMprisPlayer* self);
VALA_EXTERN void music_mpris_player_set_can_go_next (MusicMprisPlayer* self,
                                         gboolean value);
VALA_EXTERN gboolean music_mpris_player_get_can_go_previous (MusicMprisPlayer* self);
VALA_EXTERN void music_mpris_player_set_can_go_previous (MusicMprisPlayer* self,
                                             gboolean value);
VALA_EXTERN gboolean music_mpris_player_get_can_play (MusicMprisPlayer* self);
VALA_EXTERN void music_mpris_player_set_can_play (MusicMprisPlayer* self,
                                      gboolean value);
VALA_EXTERN const gchar* music_mpris_player_get_playback_status (MusicMprisPlayer* self);
static gboolean _variant_get1 (GVariant* value);
VALA_EXTERN GHashTable* music_mpris_player_get_metadata (MusicMprisPlayer* self);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN GType music_audio_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAudioObject, g_object_unref)
VALA_EXTERN MusicAudioObject* music_playback_manager_get_current_audio (MusicPlaybackManager* self);
VALA_EXTERN const gchar* music_audio_object_get_artist (MusicAudioObject* self);
static GVariant* _variant_new4 (gchar** value,
                         gint value_length1);
VALA_EXTERN const gchar* music_audio_object_get_title (MusicAudioObject* self);
static GVariant* _variant_new5 (const gchar* value);
static GObject * music_mpris_player_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
static void _music_mpris_player___lambda10_ (MusicMprisPlayer* self);
static GVariant* _variant_new6 (GHashTable* value);
static void __music_mpris_player___lambda10__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _music_mpris_player___lambda11_ (MusicMprisPlayer* self,
                                      const gchar* name,
                                      GVariant* new_state);
static GVariant* _variant_new7 (const gchar* value);
static void __music_mpris_player___lambda11__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                           const gchar* action_name,
                                                                           GVariant* state,
                                                                           gpointer self);
static void _music_mpris_player___lambda12_ (MusicMprisPlayer* self);
static GVariant* _variant_new8 (gboolean value);
static void __music_mpris_player___lambda12__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _music_mpris_player___lambda13_ (MusicMprisPlayer* self);
static GVariant* _variant_new9 (gboolean value);
static void __music_mpris_player___lambda13__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void _music_mpris_player___lambda14_ (MusicMprisPlayer* self);
static GVariant* _variant_new10 (gboolean value);
static void __music_mpris_player___lambda14__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void music_mpris_player_finalize (GObject * obj);
static GType music_mpris_player_get_type_once (void);
static void _vala_music_mpris_player_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_music_mpris_player_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _dbus_music_mpris_player_next (MusicMprisPlayer* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_music_mpris_player_previous (MusicMprisPlayer* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void _dbus_music_mpris_player_play_pause (MusicMprisPlayer* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation);
static void music_mpris_player_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* music_mpris_player_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static GVariant* _dbus_music_mpris_player_get_can_go_next (MusicMprisPlayer* self);
static GVariant* _dbus_music_mpris_player_get_can_go_previous (MusicMprisPlayer* self);
static GVariant* _dbus_music_mpris_player_get_can_play (MusicMprisPlayer* self);
static GVariant* _dbus_music_mpris_player_get_playback_status (MusicMprisPlayer* self);
static GVariant* _dbus_music_mpris_player_get_metadata (MusicMprisPlayer* self);
static gboolean music_mpris_player_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _dbus_music_mpris_player_set_can_go_next (MusicMprisPlayer* self,
                                               GVariant* _value);
static void _dbus_music_mpris_player_set_can_go_previous (MusicMprisPlayer* self,
                                                   GVariant* _value);
static void _dbus_music_mpris_player_set_can_play (MusicMprisPlayer* self,
                                            GVariant* _value);
static void _music_mpris_player_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_next_in[] = {NULL};
static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_next_out[] = {NULL};
static const GDBusMethodInfo _music_mpris_player_dbus_method_info_next = {-1, "Next", (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_next_in), (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_next_out), NULL};
static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_previous_in[] = {NULL};
static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_previous_out[] = {NULL};
static const GDBusMethodInfo _music_mpris_player_dbus_method_info_previous = {-1, "Previous", (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_previous_in), (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_previous_out), NULL};
static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_play_pause_in[] = {NULL};
static const GDBusArgInfo * const _music_mpris_player_dbus_arg_info_play_pause_out[] = {NULL};
static const GDBusMethodInfo _music_mpris_player_dbus_method_info_play_pause = {-1, "PlayPause", (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_play_pause_in), (GDBusArgInfo **) (&_music_mpris_player_dbus_arg_info_play_pause_out), NULL};
static const GDBusMethodInfo * const _music_mpris_player_dbus_method_info[] = {&_music_mpris_player_dbus_method_info_next, &_music_mpris_player_dbus_method_info_previous, &_music_mpris_player_dbus_method_info_play_pause, NULL};
static const GDBusSignalInfo * const _music_mpris_player_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _music_mpris_player_dbus_property_info_can_go_next = {-1, "CanGoNext", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _music_mpris_player_dbus_property_info_can_go_previous = {-1, "CanGoPrevious", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _music_mpris_player_dbus_property_info_can_play = {-1, "CanPlay", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _music_mpris_player_dbus_property_info_playback_status = {-1, "PlaybackStatus", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _music_mpris_player_dbus_property_info_metadata = {-1, "Metadata", "a{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _music_mpris_player_dbus_property_info[] = {&_music_mpris_player_dbus_property_info_can_go_next, &_music_mpris_player_dbus_property_info_can_go_previous, &_music_mpris_player_dbus_property_info_can_play, &_music_mpris_player_dbus_property_info_playback_status, &_music_mpris_player_dbus_property_info_metadata, NULL};
static const GDBusInterfaceInfo _music_mpris_player_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Player", (GDBusMethodInfo **) (&_music_mpris_player_dbus_method_info), (GDBusSignalInfo **) (&_music_mpris_player_dbus_signal_info), (GDBusPropertyInfo **) (&_music_mpris_player_dbus_property_info), NULL};
static const GDBusInterfaceVTable _music_mpris_player_dbus_interface_vtable = {music_mpris_player_dbus_interface_method_call, music_mpris_player_dbus_interface_get_property, music_mpris_player_dbus_interface_set_property};

static inline gpointer
music_mpris_player_get_instance_private (MusicMprisPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, MusicMprisPlayer_private_offset);
}

MusicMprisPlayer*
music_mpris_player_construct (GType object_type,
                              GDBusConnection* connection)
{
	MusicMprisPlayer * self = NULL;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (MusicMprisPlayer*) g_object_new (object_type, "connection", connection, NULL);
	return self;
}

MusicMprisPlayer*
music_mpris_player_new (GDBusConnection* connection)
{
	return music_mpris_player_construct (MUSIC_TYPE_MPRIS_PLAYER, connection);
}

static void
music_mpris_player_send_property_change (MusicMprisPlayer* self,
                                         const gchar* name,
                                         GVariant* variant)
{
	GVariantBuilder* invalid_builder = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp4_;
	GVariantBuilder* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_type_new ("as");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	invalid_builder = _tmp3_;
	_tmp4_ = G_VARIANT_TYPE_ARRAY;
	_tmp5_ = g_variant_builder_new (_tmp4_);
	builder = _tmp5_;
	g_variant_builder_add (builder, "{sv}", name, variant, NULL);
	{
		GDBusConnection* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		_tmp6_ = self->priv->_connection;
		_tmp7_ = g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.Player", builder, invalid_builder, NULL);
		g_variant_ref_sink (_tmp7_);
		_tmp8_ = _tmp7_;
		g_dbus_connection_emit_signal (_tmp6_, NULL, "/org/mpris/MediaPlayer2", "org.freedesktop.DBus.Properties", "PropertiesChanged", _tmp8_, &_inner_error0_);
		_g_variant_unref0 (_tmp8_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("MprisPlayer.vala:101: Could not send MPRIS property change: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_builder_unref0 (builder);
		_g_variant_builder_unref0 (invalid_builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_variant_builder_unref0 (builder);
	_g_variant_builder_unref0 (invalid_builder);
}

void
music_mpris_player_next (MusicMprisPlayer* self,
                         GError** error)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->application;
	g_action_group_activate_action ((GActionGroup*) _tmp0_, MUSIC_APPLICATION_ACTION_NEXT, NULL);
}

void
music_mpris_player_previous (MusicMprisPlayer* self,
                             GError** error)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->application;
	g_action_group_activate_action ((GActionGroup*) _tmp0_, MUSIC_APPLICATION_ACTION_PREVIOUS, NULL);
}

void
music_mpris_player_play_pause (MusicMprisPlayer* self,
                               GError** error)
{
	GApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->application;
	g_action_group_activate_action ((GActionGroup*) _tmp0_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE, NULL);
}

GDBusConnection*
music_mpris_player_get_connection (MusicMprisPlayer* self)
{
	GDBusConnection* result;
	GDBusConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}

static void
music_mpris_player_set_connection (MusicMprisPlayer* self,
                                   GDBusConnection* value)
{
	GDBusConnection* old_value;
	g_return_if_fail (self != NULL);
	old_value = music_mpris_player_get_connection (self);
	if (old_value != value) {
		self->priv->_connection = value;
		g_object_notify_by_pspec ((GObject *) self, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY]);
	}
}

gboolean
music_mpris_player_get_can_go_next (MusicMprisPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_next;
	return result;
}

void
music_mpris_player_set_can_go_next (MusicMprisPlayer* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = music_mpris_player_get_can_go_next (self);
	if (old_value != value) {
		self->priv->_can_go_next = value;
		g_object_notify_by_pspec ((GObject *) self, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY]);
	}
}

gboolean
music_mpris_player_get_can_go_previous (MusicMprisPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_previous;
	return result;
}

void
music_mpris_player_set_can_go_previous (MusicMprisPlayer* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = music_mpris_player_get_can_go_previous (self);
	if (old_value != value) {
		self->priv->_can_go_previous = value;
		g_object_notify_by_pspec ((GObject *) self, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY]);
	}
}

gboolean
music_mpris_player_get_can_play (MusicMprisPlayer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_play;
	return result;
}

void
music_mpris_player_set_can_play (MusicMprisPlayer* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = music_mpris_player_get_can_play (self);
	if (old_value != value) {
		self->priv->_can_play = value;
		g_object_notify_by_pspec ((GObject *) self, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY]);
	}
}

static gboolean
_variant_get1 (GVariant* value)
{
	return g_variant_get_boolean (value);
}

const gchar*
music_mpris_player_get_playback_status (MusicMprisPlayer* self)
{
	const gchar* result;
	gboolean state = FALSE;
	GApplication* _tmp0_;
	GAction* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->application;
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE);
	_tmp2_ = g_action_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _variant_get1 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_variant_unref0 (_tmp4_);
	state = _tmp6_;
	if (state == FALSE) {
		result = "Stopped";
		return result;
	} else {
		result = "Playing";
		return result;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new4 (gchar** value,
               gint value_length1)
{
	gchar** _tmp17_;
	GVariantBuilder _tmp18_;
	gint _tmp19_;
	_tmp17_ = value;
	g_variant_builder_init (&_tmp18_, G_VARIANT_TYPE ("as"));
	for (_tmp19_ = 0; _tmp19_ < value_length1; _tmp19_++) {
		g_variant_builder_add_value (&_tmp18_, g_variant_new_string (*_tmp17_));
		_tmp17_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp18_));
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

GHashTable*
music_mpris_player_get_metadata (MusicMprisPlayer* self)
{
	GHashTable* result;
	GHashTable* _metadata = NULL;
	GHashTable* _tmp0_;
	MusicAudioObject* audio = NULL;
	MusicPlaybackManager* _tmp1_;
	MusicAudioObject* _tmp2_;
	MusicAudioObject* _tmp3_;
	MusicAudioObject* _tmp4_;
	MusicAudioObject* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_metadata = _tmp0_;
	_tmp1_ = self->priv->playback_manager;
	_tmp2_ = music_playback_manager_get_current_audio (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	audio = _tmp4_;
	_tmp5_ = audio;
	if (_tmp5_ != NULL) {
		MusicAudioObject* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		MusicAudioObject* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp6_ = audio;
		_tmp7_ = music_audio_object_get_artist (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			gchar** array = NULL;
			MusicAudioObject* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_;
			gint array_length1;
			gint _array_size_;
			GHashTable* _tmp14_;
			gchar* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			GVariant* _tmp20_;
			_tmp9_ = audio;
			_tmp10_ = music_audio_object_get_artist (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			_tmp13_ = g_new0 (gchar*, 1 + 1);
			_tmp13_[0] = _tmp12_;
			array = _tmp13_;
			array_length1 = 1;
			_array_size_ = array_length1;
			_tmp14_ = _metadata;
			_tmp15_ = g_strdup ("xesam:artist");
			_tmp16_ = array;
			_tmp16__length1 = array_length1;
			_tmp20_ = _variant_new4 (_tmp16_, _tmp16__length1);
			g_hash_table_insert (_tmp14_, _tmp15_, _tmp20_);
			array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp21_ = audio;
		_tmp22_ = music_audio_object_get_title (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != NULL) {
			GHashTable* _tmp24_;
			gchar* _tmp25_;
			MusicAudioObject* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			GVariant* _tmp29_;
			_tmp24_ = _metadata;
			_tmp25_ = g_strdup ("xesam:title");
			_tmp26_ = audio;
			_tmp27_ = music_audio_object_get_title (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = _variant_new5 (_tmp28_);
			g_hash_table_insert (_tmp24_, _tmp25_, _tmp29_);
		}
	}
	result = _metadata;
	_g_object_unref0 (audio);
	return result;
}

static GVariant*
_variant_new6 (GHashTable* value)
{
	GVariantBuilder _tmp3_;
	GHashTableIter _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	g_hash_table_iter_init (&_tmp4_, value);
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp4_, &_tmp5_, &_tmp6_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp5_;
		_value = (GVariant*) _tmp6_;
		g_variant_builder_add (&_tmp3_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp3_));
}

static void
_music_mpris_player___lambda10_ (MusicMprisPlayer* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GVariant* _tmp7_;
	_tmp0_ = music_mpris_player_get_metadata (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp7_ = _variant_new6 (_tmp2_);
	music_mpris_player_send_property_change (self, "Metadata", _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_g_hash_table_unref0 (_tmp2_);
}

static void
__music_mpris_player___lambda10__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_music_mpris_player___lambda10_ ((MusicMprisPlayer*) self);
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_music_mpris_player___lambda11_ (MusicMprisPlayer* self,
                                 const gchar* name,
                                 GVariant* new_state)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (new_state != NULL);
	if (g_strcmp0 (name, MUSIC_APPLICATION_ACTION_PLAY_PAUSE) == 0) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		GVariant* _tmp2_;
		_tmp0_ = music_mpris_player_get_playback_status (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _variant_new7 (_tmp1_);
		music_mpris_player_send_property_change (self, "PlaybackStatus", _tmp2_);
		_g_variant_unref0 (_tmp2_);
	}
}

static void
__music_mpris_player___lambda11__g_action_group_action_state_changed (GActionGroup* _sender,
                                                                      const gchar* action_name,
                                                                      GVariant* state,
                                                                      gpointer self)
{
	_music_mpris_player___lambda11_ ((MusicMprisPlayer*) self, action_name, state);
}

static GVariant*
_variant_new8 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_music_mpris_player___lambda12_ (MusicMprisPlayer* self)
{
	gboolean _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = self->priv->_can_go_next;
	_tmp1_ = _variant_new8 (_tmp0_);
	music_mpris_player_send_property_change (self, "CanGoNext", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
__music_mpris_player___lambda12__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_music_mpris_player___lambda12_ ((MusicMprisPlayer*) self);
}

static GVariant*
_variant_new9 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_music_mpris_player___lambda13_ (MusicMprisPlayer* self)
{
	gboolean _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = self->priv->_can_go_previous;
	_tmp1_ = _variant_new9 (_tmp0_);
	music_mpris_player_send_property_change (self, "CanGoPrevious", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
__music_mpris_player___lambda13__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_music_mpris_player___lambda13_ ((MusicMprisPlayer*) self);
}

static GVariant*
_variant_new10 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_music_mpris_player___lambda14_ (MusicMprisPlayer* self)
{
	gboolean _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = self->priv->_can_play;
	_tmp1_ = _variant_new10 (_tmp0_);
	music_mpris_player_send_property_change (self, "CanPlay", _tmp1_);
	_g_variant_unref0 (_tmp1_);
}

static void
__music_mpris_player___lambda14__g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	_music_mpris_player___lambda14_ ((MusicMprisPlayer*) self);
}

static GObject *
music_mpris_player_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicMprisPlayer * self;
	GApplication* _tmp0_;
	GApplication* _tmp1_;
	MusicPlaybackManager* _tmp2_;
	MusicPlaybackManager* _tmp3_;
	MusicPlaybackManager* _tmp4_;
	GApplication* _tmp5_;
	GAction* action_next = NULL;
	GApplication* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	GAction* _tmp9_;
	GAction* action_play_pause = NULL;
	GApplication* _tmp10_;
	GAction* _tmp11_;
	GAction* _tmp12_;
	GAction* _tmp13_;
	GAction* action_previous = NULL;
	GApplication* _tmp14_;
	GAction* _tmp15_;
	GAction* _tmp16_;
	GAction* _tmp17_;
	parent_class = G_OBJECT_CLASS (music_mpris_player_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->application);
	self->priv->application = _tmp1_;
	_tmp2_ = music_playback_manager_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->playback_manager);
	self->priv->playback_manager = _tmp3_;
	_tmp4_ = self->priv->playback_manager;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::current-audio", (GCallback) __music_mpris_player___lambda10__g_object_notify, self, 0);
	_tmp5_ = self->priv->application;
	g_signal_connect_object ((GActionGroup*) _tmp5_, "action-state-changed", (GCallback) __music_mpris_player___lambda11__g_action_group_action_state_changed, self, 0);
	_tmp6_ = self->priv->application;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) _tmp6_, MUSIC_APPLICATION_ACTION_NEXT);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	action_next = _tmp8_;
	_tmp9_ = action_next;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "enabled", (GObject*) self, "can-go-next", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->application;
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) _tmp10_, MUSIC_APPLICATION_ACTION_PLAY_PAUSE);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	action_play_pause = _tmp12_;
	_tmp13_ = action_play_pause;
	g_object_bind_property_with_closures ((GObject*) _tmp13_, "enabled", (GObject*) self, "can-play", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp14_ = self->priv->application;
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) _tmp14_, MUSIC_APPLICATION_ACTION_PREVIOUS);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	action_previous = _tmp16_;
	_tmp17_ = action_previous;
	g_object_bind_property_with_closures ((GObject*) _tmp17_, "enabled", (GObject*) self, "can-go-previous", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_object ((GObject*) self, "notify::can-go-next", (GCallback) __music_mpris_player___lambda12__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::can-go-previous", (GCallback) __music_mpris_player___lambda13__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::can-play", (GCallback) __music_mpris_player___lambda14__g_object_notify, self, 0);
	_g_object_unref0 (action_previous);
	_g_object_unref0 (action_play_pause);
	_g_object_unref0 (action_next);
	return obj;
}

static void
music_mpris_player_class_init (MusicMprisPlayerClass * klass,
                               gpointer klass_data)
{
	music_mpris_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicMprisPlayer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_music_mpris_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_music_mpris_player_set_property;
	G_OBJECT_CLASS (klass)->constructor = music_mpris_player_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_mpris_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", g_dbus_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY] = g_param_spec_boolean ("can-go-next", "can-go-next", "can-go-next", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY] = g_param_spec_boolean ("can-go-previous", "can-go-previous", "can-go-previous", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY] = g_param_spec_boolean ("can-play", "can-play", "can-play", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_PLAYBACK_STATUS_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_PLAYBACK_STATUS_PROPERTY] = g_param_spec_string ("playback-status", "playback-status", "playback-status", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_MPRIS_PLAYER_METADATA_PROPERTY, music_mpris_player_properties[MUSIC_MPRIS_PLAYER_METADATA_PROPERTY] = g_param_spec_boxed ("metadata", "metadata", "metadata", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
music_mpris_player_instance_init (MusicMprisPlayer * self,
                                  gpointer klass)
{
	self->priv = music_mpris_player_get_instance_private (self);
}

static void
music_mpris_player_finalize (GObject * obj)
{
	MusicMprisPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer);
	_g_object_unref0 (self->priv->application);
	_g_object_unref0 (self->priv->playback_manager);
	G_OBJECT_CLASS (music_mpris_player_parent_class)->finalize (obj);
}

static GType
music_mpris_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicMprisPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_mpris_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicMprisPlayer), 0, (GInstanceInitFunc) music_mpris_player_instance_init, NULL };
	GType music_mpris_player_type_id;
	music_mpris_player_type_id = g_type_register_static (G_TYPE_OBJECT, "MusicMprisPlayer", &g_define_type_info, 0);
	g_type_set_qdata (music_mpris_player_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) music_mpris_player_register_object);
	MusicMprisPlayer_private_offset = g_type_add_instance_private (music_mpris_player_type_id, sizeof (MusicMprisPlayerPrivate));
	return music_mpris_player_type_id;
}

GType
music_mpris_player_get_type (void)
{
	static volatile gsize music_mpris_player_type_id__once = 0;
	if (g_once_init_enter (&music_mpris_player_type_id__once)) {
		GType music_mpris_player_type_id;
		music_mpris_player_type_id = music_mpris_player_get_type_once ();
		g_once_init_leave (&music_mpris_player_type_id__once, music_mpris_player_type_id);
	}
	return music_mpris_player_type_id__once;
}

static void
_vala_music_mpris_player_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	MusicMprisPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer);
	switch (property_id) {
		case MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY:
		g_value_set_object (value, music_mpris_player_get_connection (self));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY:
		g_value_set_boolean (value, music_mpris_player_get_can_go_next (self));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY:
		g_value_set_boolean (value, music_mpris_player_get_can_go_previous (self));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY:
		g_value_set_boolean (value, music_mpris_player_get_can_play (self));
		break;
		case MUSIC_MPRIS_PLAYER_PLAYBACK_STATUS_PROPERTY:
		g_value_set_string (value, music_mpris_player_get_playback_status (self));
		break;
		case MUSIC_MPRIS_PLAYER_METADATA_PROPERTY:
		g_value_take_boxed (value, music_mpris_player_get_metadata (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_music_mpris_player_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	MusicMprisPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer);
	switch (property_id) {
		case MUSIC_MPRIS_PLAYER_CONNECTION_PROPERTY:
		music_mpris_player_set_connection (self, g_value_get_object (value));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_GO_NEXT_PROPERTY:
		music_mpris_player_set_can_go_next (self, g_value_get_boolean (value));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_GO_PREVIOUS_PROPERTY:
		music_mpris_player_set_can_go_previous (self, g_value_get_boolean (value));
		break;
		case MUSIC_MPRIS_PLAYER_CAN_PLAY_PROPERTY:
		music_mpris_player_set_can_play (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_music_mpris_player_next (MusicMprisPlayer* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	music_mpris_player_next (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_music_mpris_player_previous (MusicMprisPlayer* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	music_mpris_player_previous (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_music_mpris_player_play_pause (MusicMprisPlayer* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	music_mpris_player_play_pause (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
music_mpris_player_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Next") == 0) {
		_dbus_music_mpris_player_next (object, parameters, invocation);
	} else if (strcmp (method_name, "Previous") == 0) {
		_dbus_music_mpris_player_previous (object, parameters, invocation);
	} else if (strcmp (method_name, "PlayPause") == 0) {
		_dbus_music_mpris_player_play_pause (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_music_mpris_player_get_can_go_next (MusicMprisPlayer* self)
{
	gboolean result;
	GVariant* _reply;
	result = music_mpris_player_get_can_go_next (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_music_mpris_player_get_can_go_previous (MusicMprisPlayer* self)
{
	gboolean result;
	GVariant* _reply;
	result = music_mpris_player_get_can_go_previous (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_music_mpris_player_get_can_play (MusicMprisPlayer* self)
{
	gboolean result;
	GVariant* _reply;
	result = music_mpris_player_get_can_play (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_music_mpris_player_get_playback_status (MusicMprisPlayer* self)
{
	const gchar* result;
	GVariant* _reply;
	result = music_mpris_player_get_playback_status (self);
	_reply = g_variant_new_string (result);
	return _reply;
}

static GVariant*
_dbus_music_mpris_player_get_metadata (MusicMprisPlayer* self)
{
	GHashTable* result;
	GVariant* _reply;
	GVariantBuilder _tmp0_;
	GHashTableIter _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	result = music_mpris_player_get_metadata (self);
	g_hash_table_iter_init (&_tmp1_, result);
	g_variant_builder_init (&_tmp0_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp1_, &_tmp2_, &_tmp3_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp2_;
		_value = (GVariant*) _tmp3_;
		g_variant_builder_add (&_tmp0_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	_reply = g_variant_builder_end (&_tmp0_);
	_g_hash_table_unref0 (result);
	return _reply;
}

static GVariant*
music_mpris_player_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "CanGoNext") == 0) {
		return _dbus_music_mpris_player_get_can_go_next (object);
	} else if (strcmp (property_name, "CanGoPrevious") == 0) {
		return _dbus_music_mpris_player_get_can_go_previous (object);
	} else if (strcmp (property_name, "CanPlay") == 0) {
		return _dbus_music_mpris_player_get_can_play (object);
	} else if (strcmp (property_name, "PlaybackStatus") == 0) {
		return _dbus_music_mpris_player_get_playback_status (object);
	} else if (strcmp (property_name, "Metadata") == 0) {
		return _dbus_music_mpris_player_get_metadata (object);
	}
	return NULL;
}

static void
_dbus_music_mpris_player_set_can_go_next (MusicMprisPlayer* self,
                                          GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	music_mpris_player_set_can_go_next (self, value);
}

static void
_dbus_music_mpris_player_set_can_go_previous (MusicMprisPlayer* self,
                                              GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	music_mpris_player_set_can_go_previous (self, value);
}

static void
_dbus_music_mpris_player_set_can_play (MusicMprisPlayer* self,
                                       GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	music_mpris_player_set_can_play (self, value);
}

static gboolean
music_mpris_player_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "CanGoNext") == 0) {
		_dbus_music_mpris_player_set_can_go_next (object, value);
		return TRUE;
	} else if (strcmp (property_name, "CanGoPrevious") == 0) {
		_dbus_music_mpris_player_set_can_go_previous (object, value);
		return TRUE;
	} else if (strcmp (property_name, "CanPlay") == 0) {
		_dbus_music_mpris_player_set_can_play (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
music_mpris_player_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_music_mpris_player_dbus_interface_info), &_music_mpris_player_dbus_interface_vtable, data, _music_mpris_player_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_music_mpris_player_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

