/* File.c generated by valac 0.56.18, the Vala compiler
 * generated from File.vala, do not modify */

/* Copyright (c) 2018-20 elementary LLC (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_FILE_0_PROPERTY,
	FILES_FILE_LOCATION_PROPERTY,
	FILES_FILE_DIRECTORY_PROPERTY,
	FILES_FILE_BASENAME_PROPERTY,
	FILES_FILE_URI_PROPERTY,
	FILES_FILE_COLOR_PROPERTY,
	FILES_FILE_IS_HIDDEN_PROPERTY,
	FILES_FILE_THUMBNAIL_PATH_PROPERTY,
	FILES_FILE_EXISTS_PROPERTY,
	FILES_FILE_NUM_PROPERTIES
};
static GParamSpec* files_file_properties[FILES_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	FILES_FILE_CHANGED_SIGNAL,
	FILES_FILE_ICON_CHANGED_SIGNAL,
	FILES_FILE_DESTROY_SIGNAL,
	FILES_FILE_NUM_SIGNALS
};
static guint files_file_signals[FILES_FILE_NUM_SIGNALS] = {0};

struct _FilesFilePrivate {
	GFile* _location;
	GFile* _directory;
	gchar* _basename;
	gchar* _uri;
	gint _color;
	gboolean pix_is_final;
	gboolean _is_hidden;
	gchar* _thumbnail_path;
	gboolean _exists;
};

static gint FilesFile_private_offset;
static gpointer files_file_parent_class = NULL;
static GHashTable* files_file_file_cache;
static GRecMutex __lock_files_file_files_file_file_cache = {0};
static GHashTable* files_file_file_cache = NULL;

static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a,
                                    gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static guint files_file_get_number_of_uri_parts (FilesFile* self);
static gboolean files_file_is_location_uri_default (FilesFile* self);
static FilesIconInfo* files_file_get_icon (FilesFile* self,
                                    gint requested_size,
                                    gint scale,
                                    FilesFileIconFlags flags);
static void files_file_clear_info (FilesFile* self);
static void files_file_target_location_update (FilesFile* self);
static void files_file_update_formated_type (FilesFile* self);
static GFileInfo* files_file_query_info (FilesFile* self);
static void files_file_ensure_item_count (FilesFile* self,
                                   gboolean recount);
static GObject * files_file_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _files_file___lambda9_ (FilesFile* self);
static void __files_file___lambda9__files_file_icon_changed (FilesFile* _sender,
                                                      gpointer self);
static void files_file_finalize (GObject * obj);
static GType files_file_get_type_once (void);
static void _vala_files_file_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_files_file_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_file_get_instance_private (FilesFile* self)
{
	return G_STRUCT_MEMBER_P (self, FilesFile_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_file_icon_flags_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_FILE_ICON_FLAGS_NONE, "FILES_FILE_ICON_FLAGS_NONE", "none"}, {FILES_FILE_ICON_FLAGS_USE_THUMBNAILS, "FILES_FILE_ICON_FLAGS_USE_THUMBNAILS", "use-thumbnails"}, {0, NULL, NULL}};
	GType files_file_icon_flags_type_id;
	files_file_icon_flags_type_id = g_enum_register_static ("FilesFileIconFlags", values);
	return files_file_icon_flags_type_id;
}

GType
files_file_icon_flags_get_type (void)
{
	static volatile gsize files_file_icon_flags_type_id__once = 0;
	if (g_once_init_enter (&files_file_icon_flags_type_id__once)) {
		GType files_file_icon_flags_type_id;
		files_file_icon_flags_type_id = files_file_icon_flags_get_type_once ();
		g_once_init_leave (&files_file_icon_flags_type_id__once, files_file_icon_flags_type_id);
	}
	return files_file_icon_flags_type_id__once;
}

 G_GNUC_NO_INLINE static GType
files_file_thumb_state_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_FILE_THUMB_STATE_UNKNOWN, "FILES_FILE_THUMB_STATE_UNKNOWN", "unknown"}, {FILES_FILE_THUMB_STATE_NONE, "FILES_FILE_THUMB_STATE_NONE", "none"}, {FILES_FILE_THUMB_STATE_READY, "FILES_FILE_THUMB_STATE_READY", "ready"}, {FILES_FILE_THUMB_STATE_LOADING, "FILES_FILE_THUMB_STATE_LOADING", "loading"}, {0, NULL, NULL}};
	GType files_file_thumb_state_type_id;
	files_file_thumb_state_type_id = g_enum_register_static ("FilesFileThumbState", values);
	return files_file_thumb_state_type_id;
}

GType
files_file_thumb_state_get_type (void)
{
	static volatile gsize files_file_thumb_state_type_id__once = 0;
	if (g_once_init_enter (&files_file_thumb_state_type_id__once)) {
		GType files_file_thumb_state_type_id;
		files_file_thumb_state_type_id = files_file_thumb_state_get_type_once ();
		g_once_init_leave (&files_file_thumb_state_type_id__once, files_file_thumb_state_type_id);
	}
	return files_file_thumb_state_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesFile*
files_file_get (GFile* location)
{
	GFile* parent = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	FilesFile* file = NULL;
	FilesFile* _tmp8_;
	FilesFile* _tmp9_;
	GError* _inner_error0_ = NULL;
	FilesFile* result;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = g_file_get_parent (location);
	parent = _tmp0_;
	_tmp1_ = parent;
	if (_tmp1_ != NULL) {
		FilesDirectory* dir = NULL;
		GFile* _tmp2_;
		FilesDirectory* _tmp3_;
		FilesDirectory* _tmp4_;
		_tmp2_ = parent;
		_tmp3_ = files_directory_cache_lookup (_tmp2_);
		dir = _tmp3_;
		_tmp4_ = dir;
		if (_tmp4_ != NULL) {
			FilesFile* file = NULL;
			FilesDirectory* _tmp5_;
			FilesFile* _tmp6_;
			FilesFile* _tmp7_;
			_tmp5_ = dir;
			_tmp6_ = files_directory_file_hash_lookup_location (_tmp5_, location);
			file = _tmp6_;
			_tmp7_ = file;
			if (_tmp7_ != NULL) {
				result = file;
				_g_object_unref0 (dir);
				_g_object_unref0 (parent);
				return result;
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (dir);
	}
	_tmp8_ = files_file_cache_lookup (location);
	file = _tmp8_;
	_tmp9_ = file;
	if (_tmp9_ == NULL) {
		GFile* _tmp10_;
		FilesFile* _tmp11_;
		_tmp10_ = parent;
		_tmp11_ = files_file_new (location, _tmp10_);
		_g_object_unref0 (file);
		file = _tmp11_;
		{
			GHashTable* _tmp12_;
			_tmp12_ = files_file_file_cache;
			g_rec_mutex_lock (&__lock_files_file_files_file_file_cache);
			{
				GHashTable* _tmp13_;
				GFile* _tmp14_;
				FilesFile* _tmp15_;
				FilesFile* _tmp16_;
				_tmp13_ = files_file_file_cache;
				_tmp14_ = _g_object_ref0 (location);
				_tmp15_ = file;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				g_hash_table_insert (_tmp13_, _tmp14_, _tmp16_);
			}
			__finally0:
			{
				GHashTable* _tmp17_;
				_tmp17_ = files_file_file_cache;
				g_rec_mutex_unlock (&__lock_files_file_files_file_file_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (parent);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = file;
	_g_object_unref0 (parent);
	return result;
}

FilesFile*
files_file_get_by_uri (const gchar* uri)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* location = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	FilesFile* _tmp6_;
	FilesFile* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	if (_tmp1_ == NULL) {
		FilesFile* _tmp2_;
		_tmp2_ = files_file_get_by_commandline_arg (uri);
		result = _tmp2_;
		_g_free0 (scheme);
		return result;
	}
	_tmp3_ = g_file_new_for_uri (uri);
	location = _tmp3_;
	_tmp4_ = location;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (location);
		_g_free0 (scheme);
		return result;
	}
	_tmp5_ = location;
	_tmp6_ = files_file_get (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (location);
	_g_free0 (scheme);
	return result;
}

FilesFile*
files_file_get_by_commandline_arg (const gchar* arg)
{
	GFile* location = NULL;
	GFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* result;
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0_ = g_file_new_for_commandline_arg (arg);
	location = _tmp0_;
	_tmp1_ = files_file_get (location);
	result = _tmp1_;
	_g_object_unref0 (location);
	return result;
}

static guint
_g_file_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = g_file_hash (key);
	return result;
}

static gboolean
_g_file_equal_gequal_func (gconstpointer a,
                           gconstpointer b)
{
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

FilesFile*
files_file_cache_lookup (GFile* file)
{
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	FilesFile* _tmp6_;
	GError* _inner_error0_ = NULL;
	FilesFile* result;
	g_return_val_if_fail (file != NULL, NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = files_file_file_cache;
		g_rec_mutex_lock (&__lock_files_file_files_file_file_cache);
		{
			GHashTable* _tmp1_;
			_tmp1_ = files_file_file_cache;
			if (_tmp1_ == NULL) {
				GHashTable* _tmp2_;
				_tmp2_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, _g_object_unref0_);
				_g_hash_table_unref0 (files_file_file_cache);
				files_file_file_cache = _tmp2_;
			}
		}
		__finally0:
		{
			GHashTable* _tmp3_;
			_tmp3_ = files_file_file_cache;
			g_rec_mutex_unlock (&__lock_files_file_files_file_file_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = files_file_file_cache;
	_tmp5_ = g_hash_table_lookup (_tmp4_, file);
	_tmp6_ = _g_object_ref0 ((FilesFile*) _tmp5_);
	result = _tmp6_;
	return result;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GMount*
files_file_get_mount_at (GFile* location)
{
	GVolumeMonitor* volume_monitor = NULL;
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GList* _tmp2_;
	GMount* result;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = g_volume_monitor_get ();
	volume_monitor = _tmp0_;
	_tmp1_ = volume_monitor;
	_tmp2_ = g_volume_monitor_get_mounts (_tmp1_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp2_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* mount = NULL;
			mount = (GMount*) mount_it->data;
			{
				GMount* _tmp3_;
				GFile* root = NULL;
				GMount* _tmp4_;
				GFile* _tmp5_;
				GFile* _tmp6_;
				_tmp3_ = mount;
				if (g_mount_is_shadowed (_tmp3_)) {
					continue;
				}
				_tmp4_ = mount;
				_tmp5_ = g_mount_get_root (_tmp4_);
				root = _tmp5_;
				_tmp6_ = root;
				if (g_file_equal (_tmp6_, location)) {
					GMount* _tmp7_;
					GMount* _tmp8_;
					_tmp7_ = mount;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					result = _tmp8_;
					_g_object_unref0 (root);
					(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
					_g_object_unref0 (volume_monitor);
					return result;
				}
				_g_object_unref0 (root);
			}
		}
		(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
	}
	result = NULL;
	_g_object_unref0 (volume_monitor);
	return result;
}

FilesFile*
files_file_construct (GType object_type,
                      GFile* location,
                      GFile* dir)
{
	FilesFile * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = g_file_get_uri (location);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_basename (location);
	_tmp3_ = _tmp2_;
	self = (FilesFile*) g_object_new (object_type, "location", location, "uri", _tmp1_, "basename", _tmp3_, "directory", dir, NULL);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

FilesFile*
files_file_new (GFile* location,
                GFile* dir)
{
	return files_file_construct (FILES_TYPE_FILE, location, dir);
}

void
files_file_remove_from_caches (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = files_file_file_cache;
	if (_tmp1_ != NULL) {
		GHashTable* _tmp2_;
		GFile* _tmp3_;
		_tmp2_ = files_file_file_cache;
		_tmp3_ = self->priv->_location;
		_tmp0_ = g_hash_table_remove (_tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_uri;
		g_debug ("File.vala:233: remove from file_cache %s", _tmp4_);
	}
	self->is_gone = TRUE;
}

void
files_file_set_expanded (FilesFile* self,
                         gboolean expanded)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (self->is_directory);
	self->is_expanded = expanded;
}

gboolean
files_file_is_folder (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	FilesFile* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->is_directory) {
		_tmp0_ = !files_file_is_root_network_folder (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (files_file_is_smb_share (self)) {
		result = TRUE;
		return result;
	}
	if (self->file_type == G_FILE_TYPE_MOUNTABLE) {
		GFileInfo* _tmp3_;
		_tmp3_ = self->info;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFileInfo* _tmp4_;
		_tmp4_ = self->info;
		_tmp1_ = g_file_info_get_attribute_boolean (_tmp4_, G_FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = self->target_gof;
	if (_tmp7_ != NULL) {
		FilesFile* _tmp8_;
		_tmp8_ = self->target_gof;
		_tmp6_ = _tmp8_->is_directory;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		FilesFile* _tmp9_;
		_tmp9_ = self->target_gof;
		_tmp5_ = files_file_is_network_uri_scheme (_tmp9_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
files_file_is_symlink (FilesFile* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->info;
	result = g_file_info_get_attribute_boolean (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK);
	return result;
}

gboolean
files_file_is_desktop_file (FilesFile* self)
{
	GFileInfo* _tmp0_;
	gboolean is_desktop_file = FALSE;
	const gchar* content_type = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	is_desktop_file = FALSE;
	_tmp1_ = files_file_get_ftype (self);
	content_type = _tmp1_;
	_tmp2_ = content_type;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = content_type;
		is_desktop_file = g_content_type_is_mime_type (_tmp3_, "application/x-desktop");
	}
	if (is_desktop_file) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_basename;
		_tmp4_ = !g_str_has_suffix (_tmp5_, ".directory");
	} else {
		_tmp4_ = FALSE;
	}
	result = _tmp4_;
	return result;
}

gboolean
files_file_is_image (FilesFile* self)
{
	GFileInfo* _tmp0_;
	gboolean is_image = FALSE;
	const gchar* content_type = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	is_image = FALSE;
	_tmp1_ = files_file_get_ftype (self);
	content_type = _tmp1_;
	_tmp2_ = content_type;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = content_type;
		is_image = g_content_type_is_mime_type (_tmp3_, "image/*");
	}
	result = is_image;
	return result;
}

gboolean
files_file_is_trashed (FilesFile* self)
{
	GFile* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = files_file_get_target_location (self);
	result = files_file_utils_location_is_in_trash (_tmp0_);
	return result;
}

gboolean
files_file_is_readable (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	FilesFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->target_gof;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		FilesFile* _tmp3_;
		GFile* _tmp4_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = self->target_gof;
		_tmp4_ = _tmp3_->priv->_location;
		_tmp0_ = !g_file_equal (_tmp2_, _tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesFile* _tmp5_;
		_tmp5_ = self->target_gof;
		result = files_file_is_readable (_tmp5_);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		GFileInfo* _tmp7_;
		_tmp7_ = self->info;
		if (_tmp7_ != NULL) {
			GFileInfo* _tmp8_;
			_tmp8_ = self->info;
			_tmp6_ = g_file_info_has_attribute (_tmp8_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GFileInfo* _tmp9_;
			_tmp9_ = self->info;
			result = g_file_info_get_attribute_boolean (_tmp9_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
			return result;
		} else {
			if (self->has_permissions) {
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				if ((self->permissions & S_IROTH) != ((guint32) 0)) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp12_ = FALSE;
					if ((self->permissions & S_IRUSR) != ((guint32) 0)) {
						gboolean _tmp13_ = FALSE;
						if (self->uid < ((guint32) 0)) {
							_tmp13_ = TRUE;
						} else {
							_tmp13_ = ((uid_t) self->uid) == geteuid ();
						}
						_tmp12_ = _tmp13_;
					} else {
						_tmp12_ = FALSE;
					}
					_tmp11_ = _tmp12_;
				}
				if (_tmp11_) {
					_tmp10_ = TRUE;
				} else {
					gboolean _tmp14_ = FALSE;
					if ((self->permissions & S_IRGRP) != ((guint32) 0)) {
						const gchar* _tmp15_;
						_tmp15_ = self->group;
						_tmp14_ = pf_user_utils_user_in_group (_tmp15_);
					} else {
						_tmp14_ = FALSE;
					}
					_tmp10_ = _tmp14_;
				}
				result = _tmp10_;
				return result;
			} else {
				result = TRUE;
				return result;
			}
		}
	}
}

gboolean
files_file_is_writable (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	FilesFile* _tmp1_;
	gboolean _tmp6_ = FALSE;
	GFileInfo* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->target_gof;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		FilesFile* _tmp3_;
		GFile* _tmp4_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = self->target_gof;
		_tmp4_ = _tmp3_->priv->_location;
		_tmp0_ = !g_file_equal (_tmp2_, _tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesFile* _tmp5_;
		_tmp5_ = self->target_gof;
		result = files_file_is_writable (_tmp5_);
		return result;
	}
	_tmp7_ = self->info;
	if (_tmp7_ != NULL) {
		GFileInfo* _tmp8_;
		_tmp8_ = self->info;
		_tmp6_ = g_file_info_has_attribute (_tmp8_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GFileInfo* _tmp9_;
		_tmp9_ = self->info;
		result = g_file_info_get_attribute_boolean (_tmp9_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
		return result;
	}
	if (self->has_permissions) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		if ((self->permissions & S_IWOTH) > ((guint32) 0)) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp12_ = FALSE;
			if ((self->permissions & S_IWUSR) > ((guint32) 0)) {
				gboolean _tmp13_ = FALSE;
				if (self->uid < ((guint32) 0)) {
					_tmp13_ = TRUE;
				} else {
					_tmp13_ = ((uid_t) self->uid) == geteuid ();
				}
				_tmp12_ = _tmp13_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp11_ = _tmp12_;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp14_ = FALSE;
			if ((self->permissions & S_IWGRP) > ((guint32) 0)) {
				const gchar* _tmp15_;
				_tmp15_ = self->group;
				_tmp14_ = pf_user_utils_user_in_group (_tmp15_);
			} else {
				_tmp14_ = FALSE;
			}
			_tmp10_ = _tmp14_;
		}
		result = _tmp10_;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

gboolean
files_file_is_executable (FilesFile* self)
{
	FilesFile* _tmp0_;
	GFileInfo* _tmp2_;
	GFileInfo* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->target_gof;
	if (_tmp0_ != NULL) {
		FilesFile* _tmp1_;
		_tmp1_ = self->target_gof;
		result = files_file_is_executable (_tmp1_);
		return result;
	}
	_tmp2_ = self->info;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->info;
	if (g_file_info_get_attribute_boolean (_tmp3_, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE)) {
		const gchar* content_type = NULL;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		_tmp4_ = files_file_get_ftype (self);
		content_type = _tmp4_;
		_tmp6_ = content_type;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = content_type;
			_tmp5_ = g_content_type_is_a (_tmp7_, "application/x-executable");
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
files_file_is_mountable (FilesFile* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = self->info;
	result = g_file_info_get_file_type (_tmp1_) == G_FILE_TYPE_MOUNTABLE;
	return result;
}

gboolean
files_file_is_smb_share (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (files_file_is_smb_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_network_uri_scheme (self);
	}
	if (_tmp0_) {
		result = files_file_get_number_of_uri_parts (self) == ((guint) 3);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
files_file_is_smb_server (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (files_file_is_smb_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_network_uri_scheme (self);
	}
	if (_tmp0_) {
		result = files_file_get_number_of_uri_parts (self) == ((guint) 2);
		return result;
	}
	result = FALSE;
	return result;
}

const gchar*
files_file_get_display_name (FilesFile* self)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->custom_display_name;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_basename;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

GFile*
files_file_get_target_location (FilesFile* self)
{
	GFile* _tmp0_;
	GFile* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->target_location;
	if (_tmp0_ != NULL) {
		GFile* _tmp1_;
		_tmp1_ = self->target_location;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	result = _tmp2_;
	return result;
}

const gchar*
files_file_get_symlink_target (FilesFile* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	const gchar* _tmp2_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->info;
	_tmp2_ = g_file_info_get_attribute_byte_string (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET);
	result = _tmp2_;
	return result;
}

const gchar*
files_file_get_ftype (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* ftype = NULL;
	GFileInfo* _tmp5_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp12_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->info;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_location_uri_default (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	if (self->is_directory) {
		result = "inode/directory";
		return result;
	}
	_tmp2_ = self->info;
	if (g_file_info_has_attribute (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE)) {
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->info;
		_tmp4_ = g_file_info_get_attribute_string (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
		result = _tmp4_;
		return result;
	}
	ftype = NULL;
	_tmp5_ = self->info;
	if (g_file_info_has_attribute (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE)) {
		GFileInfo* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->info;
		_tmp7_ = g_file_info_get_attribute_string (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
		ftype = _tmp7_;
	}
	_tmp9_ = ftype;
	if (g_strcmp0 (_tmp9_, "application/octet-stream") == 0) {
		const gchar* _tmp10_;
		_tmp10_ = self->tagstype;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		_tmp11_ = self->tagstype;
		result = _tmp11_;
		return result;
	}
	_tmp12_ = ftype;
	result = _tmp12_;
	return result;
}

gchar*
files_file_get_formated_time (FilesFile* self,
                              const gchar* attr)
{
	GFileInfo* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	_tmp0_ = self->info;
	_tmp1_ = files_file_utils_get_formatted_time_attribute_from_info (_tmp0_, attr);
	result = _tmp1_;
	return result;
}

GdkPixbuf*
files_file_get_icon_pixbuf (FilesFile* self,
                            gint _size,
                            gint scale,
                            FilesFileIconFlags flags)
{
	FilesIconInfo* _tmp0_;
	FilesIconInfo* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_file_get_icon (self, CLAMP (_size, 16, 512), scale, flags);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_icon_info_get_pixbuf_nodefault (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
files_file_get_folder_icon_from_uri_or_path (FilesFile* self)
{
	GIcon* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GIcon* _tmp12_;
	GIcon* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->icon;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp2_ = self->priv->_is_hidden;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_uri;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			gchar* path = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			const gchar* _tmp6_;
			GIcon* _tmp7_;
			_tmp4_ = self->priv->_uri;
			_tmp5_ = g_filename_from_uri (_tmp4_, NULL, &_inner_error0_);
			path = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = path;
			_tmp7_ = files_file_get_icon_user_special_dirs (self, _tmp6_);
			_g_object_unref0 (self->icon);
			self->icon = _tmp7_;
			_g_free0 (path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_debug ("File.vala:450: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = self->icon;
	if (_tmp12_ == NULL) {
		GFile* _tmp13_;
		_tmp13_ = self->priv->_location;
		_tmp11_ = !g_file_is_native (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = files_file_is_remote_uri_scheme (self);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GThemedIcon* _tmp14_;
		_tmp14_ = (GThemedIcon*) g_themed_icon_new ("folder-remote");
		_g_object_unref0 (self->icon);
		self->icon = (GIcon*) _tmp14_;
	}
	_tmp15_ = self->icon;
	if (_tmp15_ == NULL) {
		GThemedIcon* _tmp16_;
		_tmp16_ = (GThemedIcon*) g_themed_icon_new ("folder");
		_g_object_unref0 (self->icon);
		self->icon = (GIcon*) _tmp16_;
	}
}

static FilesIconInfo*
files_file_get_icon (FilesFile* self,
                     gint requested_size,
                     gint scale,
                     FilesFileIconFlags flags)
{
	FilesIconInfo* iconinfo = NULL;
	gboolean use_thumbnails = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean awaiting_thumbnail = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean thumbnail_ready = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp9_ = FALSE;
	FilesIconInfo* _tmp10_;
	gboolean _tmp14_ = FALSE;
	FilesIconInfo* _tmp15_;
	FilesIconInfo* _tmp32_;
	FilesIconInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->pix_is_final = TRUE;
	iconinfo = NULL;
	use_thumbnails = (flags & FILES_FILE_ICON_FLAGS_USE_THUMBNAILS) == FILES_FILE_ICON_FLAGS_USE_THUMBNAILS;
	if (use_thumbnails) {
		gboolean _tmp1_ = FALSE;
		if (self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_LOADING)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_UNKNOWN);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	awaiting_thumbnail = _tmp0_;
	if (use_thumbnails) {
		_tmp2_ = self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_READY);
	} else {
		_tmp2_ = FALSE;
	}
	thumbnail_ready = _tmp2_;
	_tmp3_ = self->custom_icon_name;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->custom_icon_name;
		if (g_path_is_absolute (_tmp4_)) {
			const gchar* _tmp5_;
			FilesIconInfo* _tmp6_;
			_tmp5_ = self->custom_icon_name;
			_tmp6_ = files_icon_info_lookup_from_path (_tmp5_, requested_size, scale, FALSE);
			_g_object_unref0 (iconinfo);
			iconinfo = _tmp6_;
		} else {
			const gchar* _tmp7_;
			FilesIconInfo* _tmp8_;
			_tmp7_ = self->custom_icon_name;
			_tmp8_ = files_icon_info_lookup_from_name (_tmp7_, requested_size, scale);
			_g_object_unref0 (iconinfo);
			iconinfo = _tmp8_;
		}
	}
	_tmp10_ = iconinfo;
	if (_tmp10_ == NULL) {
		_tmp9_ = thumbnail_ready;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		FilesIconInfo* _tmp13_;
		_tmp11_ = files_file_get_thumbnail_path (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = files_icon_info_lookup_from_path (_tmp12_, requested_size, scale, self->is_remote);
		_g_object_unref0 (iconinfo);
		iconinfo = _tmp13_;
	}
	_tmp15_ = iconinfo;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		FilesIconInfo* _tmp16_;
		GdkPixbuf* _tmp17_;
		GdkPixbuf* _tmp18_;
		_tmp16_ = iconinfo;
		_tmp17_ = files_icon_info_get_pixbuf (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ == NULL;
	}
	if (_tmp14_) {
		GIcon* gicon = NULL;
		GIcon* _tmp22_;
		gicon = NULL;
		if (awaiting_thumbnail) {
			GThemedIcon* _tmp19_;
			_tmp19_ = (GThemedIcon*) g_themed_icon_new ("image-loading");
			_g_object_unref0 (gicon);
			gicon = (GIcon*) _tmp19_;
			self->priv->pix_is_final = FALSE;
		} else {
			GIcon* _tmp20_;
			GIcon* _tmp21_;
			_tmp20_ = self->icon;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			_g_object_unref0 (gicon);
			gicon = _tmp21_;
		}
		_tmp22_ = gicon;
		if (_tmp22_ != NULL) {
			GIcon* _tmp23_;
			FilesIconInfo* _tmp24_;
			gboolean _tmp25_ = FALSE;
			FilesIconInfo* _tmp26_;
			_tmp23_ = gicon;
			_tmp24_ = files_icon_info_lookup (_tmp23_, requested_size, scale, self->is_remote);
			_g_object_unref0 (iconinfo);
			iconinfo = _tmp24_;
			_tmp26_ = iconinfo;
			if (_tmp26_ == NULL) {
				_tmp25_ = TRUE;
			} else {
				FilesIconInfo* _tmp27_;
				GdkPixbuf* _tmp28_;
				GdkPixbuf* _tmp29_;
				_tmp27_ = iconinfo;
				_tmp28_ = files_icon_info_get_pixbuf (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ == NULL;
			}
			if (_tmp25_) {
				FilesIconInfo* _tmp30_;
				_tmp30_ = files_icon_info_get_generic_icon (requested_size, scale);
				_g_object_unref0 (iconinfo);
				iconinfo = _tmp30_;
			}
		} else {
			FilesIconInfo* _tmp31_;
			_tmp31_ = files_icon_info_get_generic_icon (requested_size, scale);
			_g_object_unref0 (iconinfo);
			iconinfo = _tmp31_;
		}
		_g_object_unref0 (gicon);
	}
	_tmp32_ = iconinfo;
	g_assert_nonnull (_tmp32_);
	result = iconinfo;
	return result;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

void
files_file_update (FilesFile* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp12_;
	const gchar* target_uri = NULL;
	GFileInfo* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp70_ = FALSE;
	const gchar* _tmp71_;
	GFileInfo* _tmp95_;
	const gchar* _tmp106_;
	gchar* _tmp107_;
	GFileInfo* _tmp108_;
	GFileInfo* _tmp109_;
	GFileInfo* _tmp110_;
	const gchar* _tmp111_;
	gchar* _tmp112_;
	GFileInfo* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	GFileInfo* _tmp116_;
	GFileInfo* _tmp122_;
	GFileInfo* _tmp128_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		return;
	}
	files_file_clear_info (self);
	_tmp1_ = self->info;
	self->size = g_file_info_get_attribute_uint64 (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	_tmp2_ = self->info;
	self->file_type = g_file_info_get_file_type (_tmp2_);
	self->is_directory = self->file_type == G_FILE_TYPE_DIRECTORY;
	_tmp3_ = self->info;
	self->modified = g_file_info_get_attribute_uint64 (_tmp3_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
	_tmp4_ = self->info;
	self->created = g_file_info_get_attribute_uint64 (_tmp4_, G_FILE_ATTRIBUTE_TIME_CREATED);
	if (self->is_directory) {
		GFileInfo* _tmp5_;
		GFileInfo* _tmp8_;
		_tmp5_ = self->info;
		if (g_file_info_has_attribute (_tmp5_, "metadata::marlin-sort-column-id")) {
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->info;
			_tmp7_ = g_file_info_get_attribute_string (_tmp6_, "metadata::marlin-sort-column-id");
			self->sort_column_id = (gint) files_list_model_column_id_from_string (_tmp7_);
		}
		_tmp8_ = self->info;
		if (g_file_info_has_attribute (_tmp8_, "metadata::marlin-sort-reversed")) {
			GtkSortType _tmp9_ = 0;
			GFileInfo* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->info;
			_tmp11_ = g_file_info_get_attribute_string (_tmp10_, "metadata::marlin-sort-reversed");
			if (g_strcmp0 (_tmp11_, "true") == 0) {
				_tmp9_ = GTK_SORT_DESCENDING;
			} else {
				_tmp9_ = GTK_SORT_ASCENDING;
			}
			self->sort_order = _tmp9_;
		}
	}
	_tmp12_ = self->info;
	if (g_file_info_has_attribute (_tmp12_, G_FILE_ATTRIBUTE_STANDARD_ICON)) {
		GFileInfo* _tmp13_;
		GObject* _tmp14_;
		GIcon* _tmp15_;
		_tmp13_ = self->info;
		_tmp14_ = g_file_info_get_attribute_object (_tmp13_, G_FILE_ATTRIBUTE_STANDARD_ICON);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, g_icon_get_type ()) ? ((GIcon*) _tmp14_) : NULL);
		_g_object_unref0 (self->icon);
		self->icon = _tmp15_;
	}
	_tmp16_ = self->info;
	_tmp17_ = g_file_info_get_attribute_string (_tmp16_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI);
	target_uri = _tmp17_;
	_tmp18_ = target_uri;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = target_uri;
		_tmp20_ = g_uri_parse_scheme (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strcmp0 (_tmp21_, "afp") == 0;
		_g_free0 (_tmp21_);
		if (_tmp22_) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GFile* _tmp27_;
			_tmp23_ = target_uri;
			_tmp24_ = self->priv->_uri;
			_tmp25_ = files_file_utils_get_afp_target_uri (_tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_file_new_for_uri (_tmp26_);
			_g_object_unref0 (self->target_location);
			self->target_location = _tmp27_;
			_g_free0 (_tmp26_);
		} else {
			const gchar* _tmp28_;
			GFile* _tmp29_;
			_tmp28_ = target_uri;
			_tmp29_ = g_file_new_for_uri (_tmp28_);
			_g_object_unref0 (self->target_location);
			self->target_location = _tmp29_;
		}
		files_file_target_location_update (self);
		{
			GMount* _tmp30_ = NULL;
			GFile* _tmp31_;
			GMount* _tmp32_;
			GMount* _tmp33_;
			GMount* _tmp34_;
			_tmp31_ = self->target_location;
			_tmp32_ = g_file_find_enclosing_mount (_tmp31_, NULL, &_inner_error0_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp33_ = _tmp30_;
			_tmp30_ = NULL;
			_g_object_unref0 (self->mount);
			self->mount = _tmp33_;
			_tmp34_ = self->mount;
			self->is_mounted = _tmp34_ != NULL;
			_g_object_unref0 (_tmp30_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp35_;
			const gchar* _tmp36_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			self->is_mounted = FALSE;
			_tmp35_ = e;
			_tmp36_ = _tmp35_->message;
			g_debug ("File.vala:557: %s", _tmp36_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		{
			GMount* _tmp37_ = NULL;
			GFile* _tmp38_;
			GMount* _tmp39_;
			GMount* _tmp40_;
			GMount* _tmp41_;
			_tmp38_ = self->priv->_location;
			_tmp39_ = g_file_find_enclosing_mount (_tmp38_, NULL, &_inner_error0_);
			_tmp37_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp40_ = _tmp37_;
			_tmp37_ = NULL;
			_g_object_unref0 (self->mount);
			self->mount = _tmp40_;
			_tmp41_ = self->mount;
			self->is_mounted = _tmp41_ != NULL;
			_g_object_unref0 (_tmp37_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp42_;
			const gchar* _tmp43_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			self->is_mounted = FALSE;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			g_debug ("File.vala:565: %s", _tmp43_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->is_desktop = files_file_is_desktop_file (self);
	if (self->is_desktop) {
		{
			GKeyFile* key_file = NULL;
			GFile* _tmp44_;
			GKeyFile* _tmp45_;
			gchar* _tmp46_ = NULL;
			GKeyFile* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp44_ = self->priv->_location;
			_tmp45_ = files_file_utils_key_file_from_file (_tmp44_, NULL, &_inner_error0_);
			key_file = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp47_ = key_file;
			_tmp48_ = g_key_file_get_string (_tmp47_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
			_tmp46_ = _tmp48_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (key_file);
				goto __catch2_g_error;
			}
			_tmp49_ = _tmp46_;
			_tmp46_ = NULL;
			_g_free0 (self->custom_icon_name);
			self->custom_icon_name = _tmp49_;
			_tmp50_ = self->custom_icon_name;
			if (!g_path_is_absolute (_tmp50_)) {
				const gchar* _tmp51_;
				gchar** _tmp52_;
				gchar** _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				const gchar* _tmp55_;
				gchar* _tmp56_;
				_tmp51_ = self->custom_icon_name;
				_tmp53_ = _tmp52_ = g_strsplit (_tmp51_, ".", 2);
				_tmp54_ = _tmp53_;
				_tmp54__length1 = _vala_array_length (_tmp52_);
				_tmp55_ = _tmp54_[0];
				_tmp56_ = g_strdup (_tmp55_);
				_g_free0 (self->custom_icon_name);
				self->custom_icon_name = _tmp56_;
				_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (_tmp46_);
			_g_key_file_unref0 (key_file);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp57_;
			const gchar* _tmp58_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp57_ = e;
			_tmp58_ = _tmp57_->message;
			g_debug ("File.vala:581: %s", _tmp58_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			GKeyFile* key_file = NULL;
			GFile* _tmp59_;
			GKeyFile* _tmp60_;
			gchar* type = NULL;
			GKeyFile* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			_tmp59_ = self->priv->_location;
			_tmp60_ = files_file_utils_key_file_from_file (_tmp59_, NULL, &_inner_error0_);
			key_file = _tmp60_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp61_ = key_file;
			_tmp62_ = g_key_file_get_string (_tmp61_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, &_inner_error0_);
			type = _tmp62_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (key_file);
				goto __catch3_g_error;
			}
			_tmp63_ = type;
			if (g_strcmp0 (_tmp63_, G_KEY_FILE_DESKTOP_TYPE_LINK) == 0) {
				gchar* url = NULL;
				GKeyFile* _tmp64_;
				gchar* _tmp65_;
				const gchar* _tmp66_;
				GFile* _tmp67_;
				_tmp64_ = key_file;
				_tmp65_ = g_key_file_get_string (_tmp64_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_URL, &_inner_error0_);
				url = _tmp65_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (type);
					_g_key_file_unref0 (key_file);
					goto __catch3_g_error;
				}
				_tmp66_ = url;
				_tmp67_ = g_file_new_for_uri (_tmp66_);
				_g_object_unref0 (self->target_location);
				self->target_location = _tmp67_;
				files_file_target_location_update (self);
				_g_free0 (url);
			}
			_g_free0 (type);
			_g_key_file_unref0 (key_file);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp68_;
			const gchar* _tmp69_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp68_ = e;
			_tmp69_ = _tmp68_->message;
			g_debug ("File.vala:594: %s", _tmp69_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp71_ = self->custom_display_name;
	if (_tmp71_ == NULL) {
		GFileInfo* _tmp72_;
		_tmp72_ = self->info;
		_tmp70_ = _tmp72_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		const gchar* disp_name = NULL;
		GFileInfo* _tmp73_;
		const gchar* _tmp74_;
		gchar* _tmp75_ = NULL;
		GFile* _tmp76_;
		gchar* target_uri_scheme = NULL;
		gchar* _tmp79_;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_ = FALSE;
		GFile* _tmp82_;
		_tmp73_ = self->info;
		_tmp74_ = g_file_info_get_display_name (_tmp73_);
		disp_name = _tmp74_;
		_tmp76_ = self->target_location;
		if (_tmp76_ != NULL) {
			GFile* _tmp77_;
			gchar* _tmp78_;
			_tmp77_ = self->target_location;
			_tmp78_ = g_file_get_uri_scheme (_tmp77_);
			_g_free0 (_tmp75_);
			_tmp75_ = _tmp78_;
		} else {
			_g_free0 (_tmp75_);
			_tmp75_ = NULL;
		}
		_tmp79_ = g_strdup (_tmp75_);
		target_uri_scheme = _tmp79_;
		_tmp82_ = self->priv->_directory;
		if (_tmp82_ != NULL) {
			GFile* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp83_ = self->priv->_directory;
			_tmp84_ = g_file_get_uri_scheme (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp81_ = g_strcmp0 (_tmp85_, "network") == 0;
			_g_free0 (_tmp85_);
		} else {
			_tmp81_ = FALSE;
		}
		if (_tmp81_) {
			const gchar* _tmp86_;
			_tmp86_ = target_uri_scheme;
			_tmp80_ = g_strcmp0 (_tmp86_, "smb") != 0;
		} else {
			_tmp80_ = FALSE;
		}
		if (_tmp80_) {
			const gchar* _tmp87_;
			const gchar* _tmp88_;
			gint _tmp89_ = 0;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			_tmp87_ = disp_name;
			_tmp88_ = target_uri_scheme;
			_tmp90_ = string_to_utf8 (_tmp88_, &_tmp89_);
			_tmp91_ = (gchar*) _tmp90_;
			_tmp92_ = g_strdup_printf ("%s (%s)", _tmp87_, _tmp91_);
			_g_free0 (self->custom_display_name);
			self->custom_display_name = _tmp92_;
			_g_free0 (_tmp91_);
		} else {
			const gchar* _tmp93_;
			gchar* _tmp94_;
			_tmp93_ = disp_name;
			_tmp94_ = g_strdup (_tmp93_);
			_g_free0 (self->custom_display_name);
			self->custom_display_name = _tmp94_;
		}
		_g_free0 (target_uri_scheme);
		_g_free0 (_tmp75_);
	}
	files_file_ensure_size (self);
	_tmp95_ = self->info;
	if (g_file_info_has_attribute (_tmp95_, G_FILE_ATTRIBUTE_TIME_MODIFIED)) {
		gchar* _tmp96_;
		_tmp96_ = files_file_get_formated_time (self, G_FILE_ATTRIBUTE_TIME_MODIFIED);
		_g_free0 (self->formated_modified);
		self->formated_modified = _tmp96_;
	} else {
		gchar* _tmp97_;
		_tmp97_ = g_strdup (_ ("Inaccessible"));
		_g_free0 (self->formated_modified);
		self->formated_modified = _tmp97_;
	}
	if (self->is_directory) {
		files_file_get_folder_icon_from_uri_or_path (self);
	} else {
		GFileInfo* _tmp98_;
		_tmp98_ = self->info;
		if (g_file_info_get_file_type (_tmp98_) == G_FILE_TYPE_MOUNTABLE) {
			GThemedIcon* _tmp99_;
			_tmp99_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("folder-remote");
			_g_object_unref0 (self->icon);
			self->icon = (GIcon*) _tmp99_;
		} else {
			const gchar* ftype = NULL;
			const gchar* _tmp100_;
			gboolean _tmp101_ = FALSE;
			const gchar* _tmp102_;
			_tmp100_ = files_file_get_ftype (self);
			ftype = _tmp100_;
			_tmp102_ = ftype;
			if (_tmp102_ != NULL) {
				GIcon* _tmp103_;
				_tmp103_ = self->icon;
				_tmp101_ = _tmp103_ == NULL;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				const gchar* _tmp104_;
				GIcon* _tmp105_;
				_tmp104_ = ftype;
				_tmp105_ = g_content_type_get_icon (_tmp104_);
				_g_object_unref0 (self->icon);
				self->icon = _tmp105_;
			}
		}
	}
	_tmp106_ = files_file_get_display_name (self);
	_tmp107_ = g_utf8_collate_key_for_filename (_tmp106_, (gssize) -1);
	_g_free0 (self->utf8_collation_key);
	self->utf8_collation_key = _tmp107_;
	self->thumbstate = (guint) FILES_FILE_THUMB_STATE_UNKNOWN;
	files_file_update_formated_type (self);
	_tmp108_ = self->info;
	self->has_permissions = g_file_info_has_attribute (_tmp108_, G_FILE_ATTRIBUTE_UNIX_MODE);
	_tmp109_ = self->info;
	self->permissions = g_file_info_get_attribute_uint32 (_tmp109_, G_FILE_ATTRIBUTE_UNIX_MODE);
	_tmp110_ = self->info;
	_tmp111_ = g_file_info_get_attribute_string (_tmp110_, G_FILE_ATTRIBUTE_OWNER_USER);
	_tmp112_ = g_strdup (_tmp111_);
	_g_free0 (self->owner);
	self->owner = _tmp112_;
	_tmp113_ = self->info;
	_tmp114_ = g_file_info_get_attribute_string (_tmp113_, G_FILE_ATTRIBUTE_OWNER_GROUP);
	_tmp115_ = g_strdup (_tmp114_);
	_g_free0 (self->group);
	self->group = _tmp115_;
	_tmp116_ = self->info;
	if (g_file_info_has_attribute (_tmp116_, G_FILE_ATTRIBUTE_UNIX_UID)) {
		GFileInfo* _tmp117_;
		const gchar* _tmp118_;
		_tmp117_ = self->info;
		self->uid = g_file_info_get_attribute_uint32 (_tmp117_, G_FILE_ATTRIBUTE_UNIX_UID);
		_tmp118_ = self->owner;
		if (_tmp118_ == NULL) {
			gchar* _tmp119_;
			_tmp119_ = g_strdup_printf ("%u", self->uid);
			_g_free0 (self->owner);
			self->owner = _tmp119_;
		}
	} else {
		const gchar* _tmp120_;
		_tmp120_ = self->owner;
		if (_tmp120_ != NULL) {
			const gchar* _tmp121_;
			_tmp121_ = self->owner;
			self->uid = (guint32) atoi (_tmp121_);
		} else {
			_g_free0 (self->owner);
			self->owner = NULL;
		}
	}
	_tmp122_ = self->info;
	if (g_file_info_has_attribute (_tmp122_, G_FILE_ATTRIBUTE_UNIX_GID)) {
		GFileInfo* _tmp123_;
		const gchar* _tmp124_;
		_tmp123_ = self->info;
		self->gid = g_file_info_get_attribute_uint32 (_tmp123_, G_FILE_ATTRIBUTE_UNIX_GID);
		_tmp124_ = self->group;
		if (_tmp124_ == NULL) {
			gchar* _tmp125_;
			_tmp125_ = g_strdup_printf ("%u", self->gid);
			_g_free0 (self->group);
			self->group = _tmp125_;
		}
	} else {
		const gchar* _tmp126_;
		_tmp126_ = self->group;
		if (_tmp126_ != NULL) {
			const gchar* _tmp127_;
			_tmp127_ = self->group;
			self->gid = (guint32) atoi (_tmp127_);
		} else {
			_g_free0 (self->group);
			self->group = NULL;
		}
	}
	_tmp128_ = self->info;
	if (g_file_info_has_attribute (_tmp128_, G_FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT)) {
		GFileInfo* _tmp129_;
		_tmp129_ = self->info;
		self->can_unmount = g_file_info_get_attribute_boolean (_tmp129_, G_FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT);
	}
	files_file_update_emblem (self);
}

void
files_file_update_type (FilesFile* self)
{
	const gchar* ftype = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	files_file_update_formated_type (self);
	_tmp0_ = files_file_get_ftype (self);
	ftype = _tmp0_;
	_tmp1_ = ftype;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GIcon* _tmp3_;
		_tmp2_ = ftype;
		_tmp3_ = g_content_type_get_icon (_tmp2_);
		_g_object_unref0 (self->icon);
		self->icon = _tmp3_;
	}
	if (self->pix_size > 1) {
		_tmp4_ = self->pix_scale > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		files_file_update_icon (self, self->pix_size, self->pix_scale);
		g_signal_emit (self, files_file_signals[FILES_FILE_ICON_CHANGED_SIGNAL], 0);
	}
}

void
files_file_update_icon (FilesFile* self,
                        gint _size,
                        gint _scale)
{
	gint requested_size = 0;
	gint requested_scale = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean same_size = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean valid_thumbnail = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GdkPixbuf* _tmp17_;
	FilesIconInfo* iconinfo = NULL;
	FilesIconInfo* _tmp18_;
	FilesIconInfo* _tmp19_;
	GdkPixbuf* _tmp20_;
	g_return_if_fail (self != NULL);
	requested_size = _size;
	requested_scale = _scale;
	if (_size < 16) {
		requested_size = self->pix_size;
	}
	if (_scale < 1) {
		requested_scale = self->pix_scale;
	}
	if (self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_UNKNOWN)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = files_file_get_thumbnail_path (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		gchar* md5_hash = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* base_name = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = self->priv->_uri;
		g_debug ("File.vala:702: Making own thumbnail path for %s - no attribute", _tmp3_);
		_tmp4_ = self->priv->_uri;
		_tmp5_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp4_, (gsize) -1);
		md5_hash = _tmp5_;
		_tmp6_ = md5_hash;
		_tmp7_ = g_strdup_printf ("%s.png", _tmp6_);
		base_name = _tmp7_;
		_tmp8_ = g_get_user_cache_dir ();
		_tmp9_ = base_name;
		_tmp10_ = g_build_filename (_tmp8_, "thumbnails", "large", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		files_file_set_thumbnail_path (self, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (base_name);
		_g_free0 (md5_hash);
	}
	if (self->pix_size == requested_size) {
		_tmp12_ = self->pix_scale == requested_scale;
	} else {
		_tmp12_ = FALSE;
	}
	same_size = _tmp12_;
	if (self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_NONE)) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = self->thumbstate == ((guint) FILES_FILE_THUMB_STATE_READY);
	}
	if (_tmp14_) {
		_tmp13_ = self->priv->pix_is_final;
	} else {
		_tmp13_ = FALSE;
	}
	valid_thumbnail = _tmp13_;
	_tmp17_ = self->pix;
	if (_tmp17_ != NULL) {
		_tmp16_ = same_size;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = valid_thumbnail;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		return;
	}
	_tmp18_ = files_file_get_icon (self, requested_size, requested_scale, FILES_FILE_ICON_FLAGS_USE_THUMBNAILS);
	iconinfo = _tmp18_;
	_tmp19_ = iconinfo;
	_tmp20_ = files_icon_info_get_pixbuf_nodefault (_tmp19_);
	_g_object_unref0 (self->pix);
	self->pix = _tmp20_;
	self->pix_size = requested_size;
	self->pix_scale = requested_scale;
	_g_object_unref0 (iconinfo);
}

void
files_file_update_desktop_file (FilesFile* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_file_get_display_name (self);
	_tmp1_ = g_utf8_collate_key_for_filename (_tmp0_, (gssize) -1);
	_g_free0 (self->utf8_collation_key);
	self->utf8_collation_key = _tmp1_;
	files_file_update_formated_type (self);
	files_file_ensure_size (self);
	g_signal_emit (self, files_file_signals[FILES_FILE_ICON_CHANGED_SIGNAL], 0);
}

void
files_file_query_update (FilesFile* self)
{
	GFileInfo* _info = NULL;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_file_query_info (self);
	_info = _tmp0_;
	_tmp1_ = _info;
	if (_tmp1_ != NULL) {
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = _info;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->info);
		self->info = _tmp3_;
		files_file_update (self);
	}
	_g_object_unref0 (_info);
}

gboolean
files_file_ensure_query_info (FilesFile* self)
{
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	if (_tmp0_ == NULL) {
		files_file_query_update (self);
	}
	_tmp1_ = self->info;
	result = _tmp1_ != NULL;
	return result;
}

static guint
uint_parse (const gchar* str,
            guint _base)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = (guint) strtoul (str, NULL, (gint) _base);
	return result;
}

gboolean
files_file_can_set_owner (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->uid == ((guint32) -1)) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->owner;
		_tmp2_ = _tmp3_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->owner;
		_tmp1_ = self->uid == ((guint32) uint_parse (_tmp4_, (guint) 0));
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_trashed (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = geteuid () == ((uid_t) 0);
	return result;
}

gboolean
files_file_can_set_group (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	uid_t user_id = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->gid == ((guint32) -1)) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->group;
		_tmp2_ = _tmp3_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->group;
		_tmp1_ = self->gid == ((guint32) uint_parse (_tmp4_, (guint) 0));
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_trashed (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	user_id = geteuid ();
	if (user_id == ((uid_t) self->uid)) {
		result = TRUE;
		return result;
	}
	if (user_id == ((uid_t) 0)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
files_file_can_set_permissions (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->uid == ((guint32) -1)) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->owner;
		_tmp2_ = _tmp3_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->owner;
		_tmp1_ = self->uid == ((guint32) uint_parse (_tmp4_, (guint) 0));
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_trashed (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_location;
	if (g_file_is_native (_tmp5_)) {
		uid_t user_id = {0};
		user_id = geteuid ();
		if (user_id == ((uid_t) self->uid)) {
			result = TRUE;
			return result;
		}
		if (user_id == ((uid_t) 0)) {
			result = TRUE;
			return result;
		}
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
files_file_can_unmount (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->can_unmount) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		GMount* _tmp2_;
		_tmp2_ = self->mount;
		if (_tmp2_ != NULL) {
			GMount* _tmp3_;
			_tmp3_ = self->mount;
			_tmp1_ = g_mount_can_unmount (_tmp3_);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

gchar*
files_file_get_permissions_as_string (FilesFile* self)
{
	gboolean is_link = FALSE;
	gboolean suid = FALSE;
	gboolean sgid = FALSE;
	gboolean sticky = FALSE;
	gchar _tmp0_ = '\0';
	gchar _tmp2_ = '\0';
	gchar _tmp3_ = '\0';
	gchar _tmp4_ = '\0';
	gchar _tmp7_ = '\0';
	gchar _tmp8_ = '\0';
	gchar _tmp9_ = '\0';
	gchar _tmp12_ = '\0';
	gchar _tmp13_ = '\0';
	gchar _tmp14_ = '\0';
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	is_link = files_file_is_symlink (self);
	suid = (self->permissions & S_ISUID) != ((guint32) 0);
	sgid = (self->permissions & S_ISGID) != ((guint32) 0);
	sticky = (self->permissions & S_ISVTX) != ((guint32) 0);
	if (is_link) {
		_tmp0_ = 'l';
	} else {
		gchar _tmp1_ = '\0';
		if (self->is_directory) {
			_tmp1_ = 'd';
		} else {
			_tmp1_ = '-';
		}
		_tmp0_ = _tmp1_;
	}
	if ((self->permissions & S_IRUSR) != ((guint32) 0)) {
		_tmp2_ = 'r';
	} else {
		_tmp2_ = '-';
	}
	if ((self->permissions & S_IWUSR) != ((guint32) 0)) {
		_tmp3_ = 'w';
	} else {
		_tmp3_ = '-';
	}
	if ((self->permissions & S_IXUSR) != ((guint32) 0)) {
		gchar _tmp5_ = '\0';
		if (suid) {
			_tmp5_ = 's';
		} else {
			_tmp5_ = 'x';
		}
		_tmp4_ = _tmp5_;
	} else {
		gchar _tmp6_ = '\0';
		if (suid) {
			_tmp6_ = 'S';
		} else {
			_tmp6_ = '-';
		}
		_tmp4_ = _tmp6_;
	}
	if ((self->permissions & S_IRGRP) != ((guint32) 0)) {
		_tmp7_ = 'r';
	} else {
		_tmp7_ = '-';
	}
	if ((self->permissions & S_IWGRP) != ((guint32) 0)) {
		_tmp8_ = 'w';
	} else {
		_tmp8_ = '-';
	}
	if ((self->permissions & S_IXGRP) != ((guint32) 0)) {
		gchar _tmp10_ = '\0';
		if (sgid) {
			_tmp10_ = 's';
		} else {
			_tmp10_ = 'x';
		}
		_tmp9_ = _tmp10_;
	} else {
		gchar _tmp11_ = '\0';
		if (sgid) {
			_tmp11_ = 'S';
		} else {
			_tmp11_ = '-';
		}
		_tmp9_ = _tmp11_;
	}
	if ((self->permissions & S_IROTH) != ((guint32) 0)) {
		_tmp12_ = 'r';
	} else {
		_tmp12_ = '-';
	}
	if ((self->permissions & S_IWOTH) != ((guint32) 0)) {
		_tmp13_ = 'w';
	} else {
		_tmp13_ = '-';
	}
	if ((self->permissions & S_IXOTH) != ((guint32) 0)) {
		gchar _tmp15_ = '\0';
		if (sticky) {
			_tmp15_ = 't';
		} else {
			_tmp15_ = 'x';
		}
		_tmp14_ = _tmp15_;
	} else {
		gchar _tmp16_ = '\0';
		if (sticky) {
			_tmp16_ = 'T';
		} else {
			_tmp16_ = '-';
		}
		_tmp14_ = _tmp16_;
	}
	_tmp17_ = g_strdup_printf ("%c%c%c%c%c%c%c%c%c%c", (gint) _tmp0_, (gint) _tmp2_, (gint) _tmp3_, (gint) _tmp4_, (gint) _tmp7_, (gint) _tmp8_, (gint) _tmp9_, (gint) _tmp12_, (gint) _tmp13_, (gint) _tmp14_);
	result = _tmp17_;
	return result;
}

GList*
files_file_get_settable_group_names (FilesFile* self)
{
	uid_t user_id = {0};
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!files_file_can_set_group (self)) {
		result = NULL;
		return result;
	}
	user_id = geteuid ();
	if (user_id == ((uid_t) 0)) {
		GList* _tmp0_;
		_tmp0_ = pf_user_utils_get_all_group_names ();
		result = _tmp0_;
		return result;
	} else {
		if (user_id == ((uid_t) self->uid)) {
			GList* _tmp1_;
			_tmp1_ = pf_user_utils_get_group_names_for_user ();
			result = _tmp1_;
			return result;
		} else {
			g_warning ("File.vala:862: unhandled case");
		}
	}
	result = NULL;
	return result;
}

gboolean
files_file_is_remote_uri_scheme (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (files_file_is_root_network_folder (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_other_uri_scheme (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
files_file_is_root_network_folder (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (files_file_is_network_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_smb_server (self);
	}
	result = _tmp0_;
	return result;
}

gboolean
files_file_is_network_uri_scheme (FilesFile* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	result = g_file_has_uri_scheme (_tmp1_, "network");
	return result;
}

gboolean
files_file_is_smb_uri_scheme (FilesFile* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	result = g_file_has_uri_scheme (_tmp1_, "smb");
	return result;
}

gboolean
files_file_is_recent_uri_scheme (FilesFile* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	result = g_file_has_uri_scheme (_tmp1_, "recent");
	return result;
}

gboolean
files_file_is_other_uri_scheme (FilesFile* self)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GFile* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_file_get_type ())) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->_location;
	if (g_file_has_uri_scheme (_tmp5_, "ftp")) {
		_tmp4_ = TRUE;
	} else {
		GFile* _tmp6_;
		_tmp6_ = self->priv->_location;
		_tmp4_ = g_file_has_uri_scheme (_tmp6_, "sftp");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		GFile* _tmp7_;
		_tmp7_ = self->priv->_location;
		_tmp3_ = g_file_has_uri_scheme (_tmp7_, "afp");
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GFile* _tmp8_;
		_tmp8_ = self->priv->_location;
		_tmp2_ = g_file_has_uri_scheme (_tmp8_, "dav");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp9_;
		_tmp9_ = self->priv->_location;
		_tmp1_ = g_file_has_uri_scheme (_tmp9_, "davs");
	}
	result = _tmp1_;
	return result;
}

gchar*
files_file_get_display_target_uri (FilesFile* self)
{
	gchar* targ_uri = NULL;
	GFileInfo* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->info;
	_tmp1_ = g_file_info_get_attribute_as_string (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI);
	targ_uri = _tmp1_;
	_tmp2_ = targ_uri;
	if (_tmp2_ != NULL) {
		result = targ_uri;
		return result;
	}
	_tmp3_ = self->priv->_uri;
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_free0 (targ_uri);
	return result;
}

GAppInfo*
files_file_get_default_handler (FilesFile* self)
{
	const gchar* content_type = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp8_;
	GError* _inner_error0_ = NULL;
	GAppInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = files_file_get_ftype (self);
	content_type = _tmp0_;
	_tmp1_ = content_type;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GAppInfo* _tmp6_;
		GAppInfo* _tmp7_;
		_tmp2_ = content_type;
		_tmp3_ = self->priv->_location;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_app_info_get_default_for_type (_tmp2_, _tmp5_ == NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = self->target_location;
	if (_tmp8_ != NULL) {
		{
			GAppInfo* _tmp9_ = NULL;
			GFile* _tmp10_;
			GAppInfo* _tmp11_;
			GAppInfo* _tmp12_;
			_tmp10_ = self->target_location;
			_tmp11_ = g_file_query_default_handler (_tmp10_, NULL, &_inner_error0_);
			_tmp9_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp12_ = _tmp9_;
			_tmp9_ = NULL;
			result = _tmp12_;
			_g_object_unref0 (_tmp9_);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_critical ("File.vala:931: %s", _tmp14_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GAppInfo* _tmp15_ = NULL;
		GFile* _tmp16_;
		GAppInfo* _tmp17_;
		GAppInfo* _tmp18_;
		_tmp16_ = self->priv->_location;
		_tmp17_ = g_file_query_default_handler (_tmp16_, NULL, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		result = _tmp18_;
		_g_object_unref0 (_tmp15_);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("File.vala:939: %s", _tmp20_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

gboolean
files_file_execute (FilesFile* self,
                    GList* files,
                    GError** error)
{
	GFile* _tmp0_;
	GAppInfo* app_info = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (!g_file_is_native (_tmp0_)) {
		result = FALSE;
		return result;
	}
	app_info = NULL;
	if (files_file_is_desktop_file (self)) {
		{
			GKeyFile* key_file = NULL;
			GFile* _tmp1_;
			GKeyFile* _tmp2_;
			GKeyFile* _tmp3_;
			GDesktopAppInfo* _tmp4_;
			GAppInfo* _tmp5_;
			_tmp1_ = self->priv->_location;
			_tmp2_ = files_file_utils_key_file_from_file (_tmp1_, NULL, &_inner_error0_);
			key_file = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = key_file;
			_tmp4_ = g_desktop_app_info_new_from_keyfile (_tmp3_);
			_g_object_unref0 (app_info);
			app_info = (GAppInfo*) _tmp4_;
			_tmp5_ = app_info;
			if (_tmp5_ == NULL) {
				GError* _tmp6_;
				_tmp6_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _ ("Failed to parse the desktop file"));
				_inner_error0_ = _tmp6_;
				_g_key_file_unref0 (key_file);
				goto __catch0_g_error;
			}
			_g_key_file_unref0 (key_file);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* prefixed_error = NULL;
			GError* _tmp7_;
			GError* _tmp8_;
			GError* _tmp9_ = NULL;
			GError* _tmp10_;
			GError* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _g_error_copy0 (_tmp7_);
			g_propagate_prefixed_error (&_tmp9_, _tmp8_, _ ("Failed to parse the desktop file: "), NULL);
			_g_error_free0 (prefixed_error);
			prefixed_error = _tmp9_;
			_tmp10_ = prefixed_error;
			_tmp11_ = _g_error_copy0 (_tmp10_);
			_inner_error0_ = _tmp11_;
			_g_error_free0 (prefixed_error);
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (app_info);
			return _tmp12_;
		}
	} else {
		{
			gchar* path = NULL;
			GFile* _tmp13_;
			gchar* _tmp14_;
			GAppInfo* _tmp15_ = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GAppInfo* _tmp19_;
			GAppInfo* _tmp20_;
			GAppInfo* _tmp21_;
			_tmp13_ = self->priv->_location;
			_tmp14_ = g_file_get_path (_tmp13_);
			path = _tmp14_;
			_tmp16_ = path;
			_tmp17_ = g_shell_quote (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_app_info_create_from_commandline (_tmp18_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			_tmp15_ = _tmp20_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				goto __catch1_g_error;
			}
			_tmp21_ = _tmp15_;
			_tmp15_ = NULL;
			_g_object_unref0 (app_info);
			app_info = _tmp21_;
			_g_object_unref0 (_tmp15_);
			_g_free0 (path);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* prefixed_error = NULL;
			GError* _tmp22_;
			GError* _tmp23_;
			GError* _tmp24_ = NULL;
			GError* _tmp25_;
			GError* _tmp26_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _g_error_copy0 (_tmp22_);
			g_propagate_prefixed_error (&_tmp24_, _tmp23_, _ ("Failed to create command from file: "), NULL);
			_g_error_free0 (prefixed_error);
			prefixed_error = _tmp24_;
			_tmp25_ = prefixed_error;
			_tmp26_ = _g_error_copy0 (_tmp25_);
			_inner_error0_ = _tmp26_;
			_g_error_free0 (prefixed_error);
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (app_info);
			return _tmp27_;
		}
	}
	{
		GAppInfo* _tmp28_;
		_tmp28_ = app_info;
		g_app_info_launch (_tmp28_, files, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* prefixed_error = NULL;
		GError* _tmp29_;
		GError* _tmp30_;
		GError* _tmp31_ = NULL;
		GError* _tmp32_;
		GError* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _g_error_copy0 (_tmp29_);
		g_propagate_prefixed_error (&_tmp31_, _tmp30_, _ ("Unable to Launch Desktop File: "), NULL);
		_g_error_free0 (prefixed_error);
		prefixed_error = _tmp31_;
		_tmp32_ = prefixed_error;
		_tmp33_ = _g_error_copy0 (_tmp32_);
		_inner_error0_ = _tmp33_;
		_g_error_free0 (prefixed_error);
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp34_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app_info);
		return _tmp34_;
	}
	result = TRUE;
	_g_object_unref0 (app_info);
	return result;
}

gint
files_file_compare_for_sort (FilesFile* self,
                             FilesFile* other,
                             gint sort_type,
                             gboolean directories_first,
                             gboolean reversed)
{
	gint _result_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (other == self) {
		result = 0;
		return result;
	}
	if (directories_first) {
		gboolean _tmp0_ = FALSE;
		if (files_file_is_folder (self)) {
			_tmp0_ = !files_file_is_folder (other);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gint _tmp1_ = 0;
			if (reversed) {
				_tmp1_ = 1;
			} else {
				_tmp1_ = -1;
			}
			result = _tmp1_;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (files_file_is_folder (other)) {
				_tmp2_ = !files_file_is_folder (self);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gint _tmp3_ = 0;
				if (reversed) {
					_tmp3_ = -1;
				} else {
					_tmp3_ = 1;
				}
				result = _tmp3_;
				return result;
			}
		}
	}
	_result_ = 0;
	switch (sort_type) {
		case FILES_LIST_MODEL_COLUMN_ID_FILENAME:
		{
			_result_ = files_file_compare_by_display_name (self, other);
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_SIZE:
		{
			_result_ = files_file_compare_by_size (self, other);
			if (_result_ == 0) {
				_result_ = files_file_compare_by_display_name (self, other);
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_TYPE:
		{
			_result_ = files_file_compare_by_type (self, other);
			if (_result_ == 0) {
				_result_ = files_file_compare_by_display_name (self, other);
			}
			break;
		}
		case FILES_LIST_MODEL_COLUMN_ID_MODIFIED:
		{
			_result_ = files_file_compare_files_by_time (self, other);
			if (_result_ == 0) {
				_result_ = files_file_compare_by_display_name (self, other);
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	result = _result_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gint
files_file_compare_by_display_name (FilesFile* self,
                                    FilesFile* other)
{
	static const gchar SORT_LAST_CHAR1 = '.';
	static const gchar SORT_LAST_CHAR2 = '#';
	const gchar* name1 = NULL;
	const gchar* _tmp0_;
	const gchar* name2 = NULL;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean sort_last1 = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean sort_last2 = FALSE;
	gboolean _tmp8_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = files_file_get_display_name (self);
	name1 = _tmp0_;
	_tmp1_ = files_file_get_display_name (other);
	name2 = _tmp1_;
	_tmp3_ = name1;
	if (string_get (_tmp3_, (glong) 0) == SORT_LAST_CHAR1) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = name1;
		_tmp2_ = string_get (_tmp4_, (glong) 0) == SORT_LAST_CHAR2;
	}
	sort_last1 = _tmp2_;
	_tmp6_ = name2;
	if (string_get (_tmp6_, (glong) 0) == SORT_LAST_CHAR1) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = name2;
		_tmp5_ = string_get (_tmp7_, (glong) 0) == SORT_LAST_CHAR2;
	}
	sort_last2 = _tmp5_;
	if (sort_last1) {
		_tmp8_ = !sort_last2;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = 1;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		if (!sort_last1) {
			_tmp9_ = sort_last2;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = -1;
			return result;
		} else {
			GCompareFunc _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = ((GCompareFunc) g_strcmp0);
			_tmp11_ = self->utf8_collation_key;
			_tmp12_ = other->utf8_collation_key;
			result = _tmp10_ (_tmp11_, _tmp12_);
			return result;
		}
	}
}

void
files_file_update_emblem (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	if (files_file_is_other_uri_scheme (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_file_is_network_uri_scheme (self);
	}
	if (_tmp0_) {
		return;
	}
	if (files_file_is_smb_share (self)) {
		return;
	}
	_tmp1_ = self->emblems_list;
	if (_tmp1_ != NULL) {
		(self->emblems_list == NULL) ? NULL : (self->emblems_list = (_g_list_free__g_free0_ (self->emblems_list), NULL));
		self->emblems_list = NULL;
		self->n_emblems = (guint) 0;
	}
	if (files_file_is_symlink (self)) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (self->is_desktop) {
			FilesFile* _tmp4_;
			_tmp4_ = self->target_gof;
			_tmp3_ = _tmp4_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp2_ = _tmp3_;
	}
	if (_tmp2_) {
		files_file_add_emblem (self, "emblem-symbolic-link");
	}
	if (!files_file_is_writable (self)) {
		_tmp5_ = !files_file_is_recent_uri_scheme (self);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		if (files_file_is_readable (self)) {
			files_file_add_emblem (self, "emblem-readonly");
		} else {
			files_file_add_emblem (self, "emblem-unreadable");
		}
	}
}

void
files_file_add_emblem (FilesFile* self,
                       const gchar* emblem)
{
	GList* _tmp0_;
	gchar* _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (emblem != NULL);
	_tmp0_ = self->emblems_list;
	if (_tmp0_ != NULL) {
		GList* _tmp1_;
		_tmp1_ = self->emblems_list;
		{
			GList* emblem_item_collection = NULL;
			GList* emblem_item_it = NULL;
			emblem_item_collection = _tmp1_;
			for (emblem_item_it = emblem_item_collection; emblem_item_it != NULL; emblem_item_it = emblem_item_it->next) {
				const gchar* emblem_item = NULL;
				emblem_item = (const gchar*) emblem_item_it->data;
				{
					const gchar* _tmp2_;
					_tmp2_ = emblem_item;
					if (g_strcmp0 (_tmp2_, emblem) == 0) {
						return;
					}
				}
			}
		}
	} else {
		(self->emblems_list == NULL) ? NULL : (self->emblems_list = (_g_list_free__g_free0_ (self->emblems_list), NULL));
		self->emblems_list = NULL;
	}
	_tmp3_ = g_strdup (emblem);
	self->emblems_list = g_list_append (self->emblems_list, _tmp3_);
	_tmp4_ = self->n_emblems;
	self->n_emblems = _tmp4_ + 1;
	g_signal_emit (self, files_file_signals[FILES_FILE_ICON_CHANGED_SIGNAL], 0);
}

static void
files_file_target_location_update (FilesFile* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->target_location;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->target_location;
	_tmp2_ = files_file_get (_tmp1_);
	_g_object_unref0 (self->target_gof);
	self->target_gof = _tmp2_;
	_tmp3_ = self->target_gof;
	files_file_query_update (_tmp3_);
}

static void
files_file_clear_info (FilesFile* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->target_location);
	self->target_location = NULL;
	_g_object_unref0 (self->mount);
	self->mount = NULL;
	_g_free0 (self->utf8_collation_key);
	self->utf8_collation_key = NULL;
	_g_free0 (self->formated_type);
	self->formated_type = NULL;
	_g_free0 (self->format_size);
	self->format_size = NULL;
	_g_free0 (self->formated_modified);
	self->formated_modified = NULL;
	_g_object_unref0 (self->icon);
	self->icon = NULL;
	_g_free0 (self->custom_display_name);
	self->custom_display_name = NULL;
	_g_free0 (self->custom_icon_name);
	self->custom_icon_name = NULL;
	self->uid = (guint32) -1;
	self->gid = (guint32) -1;
	self->has_permissions = FALSE;
	self->permissions = (guint32) 0;
	_g_free0 (self->owner);
	self->owner = NULL;
	_g_free0 (self->group);
	self->group = NULL;
	self->can_unmount = FALSE;
}

static GFileInfo*
files_file_query_info (FilesFile* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	GFileInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_location;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, g_file_get_type ())) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_str_has_prefix (_tmp4_, FILES_NETWORK_URI);
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	self->is_mounted = TRUE;
	self->is_connected = TRUE;
	{
		GFileInfo* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		_tmp6_ = self->priv->_location;
		_tmp7_ = g_file_query_info (_tmp6_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_MOUNTED)) {
				goto __catch0_g_io_error_not_mounted;
			}
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_DIRECTORY)) {
				goto __catch0_g_io_error_not_directory;
			}
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_TIMED_OUT)) {
				goto __catch0_g_io_error_timed_out;
			}
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp8_;
		_g_object_unref0 (_tmp5_);
		return result;
	}
	goto __finally0;
	__catch0_g_io_error_not_mounted:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->is_mounted = FALSE;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_debug ("File.vala:1146: %s", _tmp10_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		files_file_set_exists (self, FALSE);
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_debug ("File.vala:1149: %s", _tmp12_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error_not_directory:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		files_file_set_exists (self, FALSE);
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_debug ("File.vala:1152: %s", _tmp14_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error_timed_out:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->is_connected = FALSE;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_debug ("File.vala:1155: %s", _tmp16_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_debug ("File.vala:1157: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

void
files_file_ensure_size (FilesFile* self)
{
	g_return_if_fail (self != NULL);
	files_file_ensure_item_count (self, TRUE);
	if (self->count >= 0) {
		if (self->count < 0) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("—");
			_g_free0 (self->format_size);
			self->format_size = _tmp0_;
		} else {
			if (self->count == 0) {
				gchar* _tmp1_;
				_tmp1_ = g_strdup (_ ("Empty"));
				_g_free0 (self->format_size);
				self->format_size = _tmp1_;
			} else {
				gchar* _tmp2_;
				_tmp2_ = g_strdup_printf (ngettext ("%'d item", "%'d items", (gulong) self->count), self->count);
				_g_free0 (self->format_size);
				self->format_size = _tmp2_;
			}
		}
	} else {
		GFileInfo* _tmp3_;
		_tmp3_ = self->info;
		if (g_file_info_has_attribute (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_SIZE)) {
			gchar* _tmp4_;
			_tmp4_ = g_format_size_full (self->size, G_FORMAT_SIZE_DEFAULT);
			_g_free0 (self->format_size);
			self->format_size = _tmp4_;
		} else {
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Inaccessible"));
			_g_free0 (self->format_size);
			self->format_size = _tmp5_;
		}
	}
}

static void
files_file_ensure_item_count (FilesFile* self,
                              gboolean recount)
{
	gboolean _tmp0_ = FALSE;
	gboolean pref_show_hidden = FALSE;
	FilesPreferences* _tmp1_;
	FilesPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_ = FALSE;
	GFile* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->count >= 0) {
		_tmp0_ = !recount;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = files_preferences_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = files_preferences_get_show_hidden_files (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	pref_show_hidden = _tmp5_;
	_tmp7_ = self->priv->_location;
	if (g_file_has_uri_scheme (_tmp7_, "file")) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		if (self->is_mounted) {
			GFile* _tmp9_;
			_tmp9_ = self->priv->_location;
			_tmp8_ = g_file_is_native (_tmp9_);
		} else {
			_tmp8_ = FALSE;
		}
		_tmp6_ = _tmp8_;
	}
	if (_tmp6_) {
		{
			GFileEnumerator* f_enum = NULL;
			GFile* _tmp10_;
			GFileEnumerator* _tmp11_;
			GFileInfo* info = NULL;
			_tmp10_ = self->priv->_location;
			_tmp11_ = g_file_enumerate_children (_tmp10_, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			f_enum = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			self->count = 0;
			while (TRUE) {
				GFileInfo* _tmp12_ = NULL;
				GFileEnumerator* _tmp13_;
				GFileInfo* _tmp14_;
				GFileInfo* _tmp15_;
				GFileInfo* _tmp16_;
				gboolean _tmp17_ = FALSE;
				_tmp13_ = f_enum;
				_tmp14_ = g_file_enumerator_next_file (_tmp13_, NULL, &_inner_error0_);
				_tmp12_ = _tmp14_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (f_enum);
					goto __catch0_g_error;
				}
				_tmp15_ = _tmp12_;
				_tmp12_ = NULL;
				_g_object_unref0 (info);
				info = _tmp15_;
				_tmp16_ = info;
				if (!(_tmp16_ != NULL)) {
					_g_object_unref0 (_tmp12_);
					break;
				}
				if (pref_show_hidden) {
					_tmp17_ = TRUE;
				} else {
					GFileInfo* _tmp18_;
					_tmp18_ = info;
					_tmp17_ = !g_file_info_get_attribute_boolean (_tmp18_, G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN);
				}
				if (_tmp17_) {
					gint _tmp19_;
					_tmp19_ = self->count;
					self->count = _tmp19_ + 1;
				}
				_g_object_unref0 (_tmp12_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (f_enum);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			self->count = -1;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
files_file_update_formated_type (FilesFile* self)
{
	const gchar* ftype = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_file_get_ftype (self);
	ftype = _tmp0_;
	_tmp1_ = ftype;
	if (_tmp1_ != NULL) {
		if (files_file_is_symlink (self)) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = ftype;
			_tmp3_ = g_content_type_get_description (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf (_ ("link to %s"), _tmp4_);
			_g_free0 (self->formated_type);
			self->formated_type = _tmp5_;
			_g_free0 (_tmp4_);
		} else {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = ftype;
			_tmp7_ = g_content_type_get_description (_tmp6_);
			_g_free0 (self->formated_type);
			self->formated_type = _tmp7_;
		}
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->formated_type);
		self->formated_type = _tmp8_;
	}
}

GIcon*
files_file_get_icon_user_special_dirs (FilesFile* self,
                                       const gchar* path)
{
	const gchar* _tmp0_;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	if (g_strcmp0 (path, _tmp0_) == 0) {
		GThemedIcon* _tmp1_;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("user-home");
		result = (GIcon*) _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
		if (g_strcmp0 (path, _tmp2_) == 0) {
			GThemedIcon* _tmp3_;
			_tmp3_ = (GThemedIcon*) g_themed_icon_new ("user-desktop");
			result = (GIcon*) _tmp3_;
			return result;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
			if (g_strcmp0 (path, _tmp4_) == 0) {
				GThemedIcon* _tmp5_;
				_tmp5_ = (GThemedIcon*) g_themed_icon_new ("folder-documents");
				result = (GIcon*) _tmp5_;
				return result;
			} else {
				const gchar* _tmp6_;
				_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
				if (g_strcmp0 (path, _tmp6_) == 0) {
					GThemedIcon* _tmp7_;
					_tmp7_ = (GThemedIcon*) g_themed_icon_new ("folder-download");
					result = (GIcon*) _tmp7_;
					return result;
				} else {
					const gchar* _tmp8_;
					_tmp8_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
					if (g_strcmp0 (path, _tmp8_) == 0) {
						GThemedIcon* _tmp9_;
						_tmp9_ = (GThemedIcon*) g_themed_icon_new ("folder-music");
						result = (GIcon*) _tmp9_;
						return result;
					} else {
						const gchar* _tmp10_;
						_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
						if (g_strcmp0 (path, _tmp10_) == 0) {
							GThemedIcon* _tmp11_;
							_tmp11_ = (GThemedIcon*) g_themed_icon_new ("folder-pictures");
							result = (GIcon*) _tmp11_;
							return result;
						} else {
							const gchar* _tmp12_;
							_tmp12_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
							if (g_strcmp0 (path, _tmp12_) == 0) {
								GThemedIcon* _tmp13_;
								_tmp13_ = (GThemedIcon*) g_themed_icon_new ("folder-publicshare");
								result = (GIcon*) _tmp13_;
								return result;
							} else {
								const gchar* _tmp14_;
								_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
								if (g_strcmp0 (path, _tmp14_) == 0) {
									GThemedIcon* _tmp15_;
									_tmp15_ = (GThemedIcon*) g_themed_icon_new ("folder-templates");
									result = (GIcon*) _tmp15_;
									return result;
								} else {
									const gchar* _tmp16_;
									_tmp16_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
									if (g_strcmp0 (path, _tmp16_) == 0) {
										GThemedIcon* _tmp17_;
										_tmp17_ = (GThemedIcon*) g_themed_icon_new ("folder-videos");
										result = (GIcon*) _tmp17_;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static guint
files_file_get_number_of_uri_parts (FilesFile* self)
{
	const gchar* target_uri = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	guint _tmp9_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	target_uri = NULL;
	_tmp0_ = self->info;
	if (_tmp0_ != NULL) {
		GFileInfo* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->info;
		_tmp2_ = g_file_info_get_attribute_string (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI);
		target_uri = _tmp2_;
	}
	_tmp3_ = target_uri;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_uri;
		target_uri = _tmp4_;
	}
	_tmp5_ = target_uri;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 6);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = (guint) _vala_array_length (_tmp6_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp9_;
	return result;
}

static gboolean
files_file_is_location_uri_default (FilesFile* self)
{
	GFileInfo* _tmp0_;
	const gchar* target_uri = NULL;
	GFileInfo* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** split = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint split_length1;
	gint _split_size_;
	gboolean _tmp8_ = FALSE;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->info;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = self->info;
	_tmp2_ = g_file_info_get_attribute_string (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_TARGET_URI);
	target_uri = _tmp2_;
	_tmp3_ = target_uri;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_uri;
		target_uri = _tmp4_;
	}
	_tmp5_ = target_uri;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 4);
	split = _tmp7_;
	split_length1 = _vala_array_length (_tmp6_);
	_split_size_ = split_length1;
	_tmp9_ = split;
	_tmp9__length1 = split_length1;
	_tmp10_ = _tmp9_[3];
	if (_tmp10_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		_tmp11_ = split;
		_tmp11__length1 = split_length1;
		_tmp12_ = _tmp11_[3];
		_tmp8_ = g_strcmp0 (_tmp12_, "") == 0;
	}
	result = _tmp8_;
	split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gint
files_file_compare_files_by_time (FilesFile* self,
                                  FilesFile* other)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (self->modified < other->modified) {
		result = 1;
		return result;
	} else {
		if (self->modified > other->modified) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}

gint
files_file_compare_files_by_created (FilesFile* self,
                                     FilesFile* other)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (self->created < other->created) {
		result = 1;
		return result;
	} else {
		if (self->created > other->created) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}

gint
files_file_compare_by_type (FilesFile* self,
                            FilesFile* other)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (files_file_is_folder (self)) {
		_tmp0_ = files_file_is_folder (other);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		if (files_file_is_folder (self)) {
			result = -1;
			return result;
		} else {
			if (files_file_is_folder (other)) {
				result = 1;
				return result;
			}
		}
	}
	_tmp1_ = self->formated_type;
	_tmp2_ = other->formated_type;
	result = g_utf8_collate (_tmp1_, _tmp2_);
	return result;
}

gint
files_file_compare_files_by_size (FilesFile* self,
                                  FilesFile* other)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (self->size < other->size) {
		result = -1;
		return result;
	} else {
		if (self->size > other->size) {
			result = 1;
			return result;
		}
	}
	result = 0;
	return result;
}

gint
files_file_compare_by_size (FilesFile* self,
                            FilesFile* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (files_file_is_folder (self)) {
		_tmp0_ = !files_file_is_folder (other);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	}
	if (files_file_is_folder (other)) {
		_tmp1_ = !files_file_is_folder (self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = 1;
		return result;
	}
	if (files_file_is_folder (self)) {
		_tmp2_ = files_file_is_folder (other);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		files_file_ensure_item_count (self, FALSE);
		files_file_ensure_item_count (other, FALSE);
		if (self->count < other->count) {
			result = -1;
			return result;
		} else {
			if (self->count > other->count) {
				result = 1;
				return result;
			}
		}
	} else {
		if (self->size < other->size) {
			result = -1;
			return result;
		} else {
			if (self->size > other->size) {
				result = 1;
				return result;
			}
		}
	}
	result = 0;
	return result;
}

GFile*
files_file_get_location (FilesFile* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static void
files_file_set_location (FilesFile* self,
                         GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_location (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_LOCATION_PROPERTY]);
	}
}

GFile*
files_file_get_directory (FilesFile* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

static void
files_file_set_directory (FilesFile* self,
                          GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_directory (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_directory);
		self->priv->_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_DIRECTORY_PROPERTY]);
	}
}

const gchar*
files_file_get_basename (FilesFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basename;
	result = _tmp0_;
	return result;
}

static void
files_file_set_basename (FilesFile* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_basename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_basename);
		self->priv->_basename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_BASENAME_PROPERTY]);
	}
}

const gchar*
files_file_get_uri (FilesFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
files_file_set_uri (FilesFile* self,
                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_URI_PROPERTY]);
	}
}

gint
files_file_get_color (FilesFile* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_color;
	return result;
}

void
files_file_set_color (FilesFile* self,
                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_color (self);
	if (old_value != value) {
		self->priv->_color = value;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_COLOR_PROPERTY]);
	}
}

gboolean
files_file_get_is_hidden (FilesFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_hidden;
	return result;
}

static void
files_file_set_is_hidden (FilesFile* self,
                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_file_get_is_hidden (self);
	if (old_value != value) {
		self->priv->_is_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_IS_HIDDEN_PROPERTY]);
	}
}

const gchar*
files_file_get_thumbnail_path (FilesFile* self)
{
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->_thumbnail_path;
	if (_tmp2_ == NULL) {
		GFileInfo* _tmp3_;
		_tmp3_ = self->info;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFileInfo* _tmp4_;
		_tmp4_ = self->info;
		_tmp0_ = g_file_info_has_attribute (_tmp4_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFileInfo* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->info;
		_tmp6_ = g_file_info_get_attribute_byte_string (_tmp5_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->_thumbnail_path);
		self->priv->_thumbnail_path = _tmp7_;
	}
	_tmp8_ = self->priv->_thumbnail_path;
	result = _tmp8_;
	return result;
}

void
files_file_set_thumbnail_path (FilesFile* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_thumbnail_path);
	self->priv->_thumbnail_path = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_THUMBNAIL_PATH_PROPERTY]);
}

gboolean
files_file_get_exists (FilesFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exists;
	return result;
}

void
files_file_set_exists (FilesFile* self,
                       gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!value) {
		_tmp0_ = self->priv->_exists;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = files_file_get_thumbnail_path (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			_tmp3_ = self->priv->_uri;
			files_file_utils_remove_thumbnail_paths_for_uri (_tmp3_);
		}
	}
	self->priv->_exists = FALSE;
	g_object_notify_by_pspec ((GObject *) self, files_file_properties[FILES_FILE_EXISTS_PROPERTY]);
}

static void
_files_file___lambda9_ (FilesFile* self)
{
	GFile* _tmp0_;
	_tmp0_ = self->priv->_directory;
	if (_tmp0_ != NULL) {
		FilesDirectory* dir = NULL;
		GFile* _tmp1_;
		FilesDirectory* _tmp2_;
		gboolean _tmp3_ = FALSE;
		FilesDirectory* _tmp4_;
		_tmp1_ = self->priv->_directory;
		_tmp2_ = files_directory_cache_lookup (_tmp1_);
		dir = _tmp2_;
		_tmp4_ = dir;
		if (_tmp4_ != NULL) {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp6_ = self->priv->_is_hidden;
			if (!_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				FilesPreferences* _tmp7_;
				FilesPreferences* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp7_ = files_preferences_get_default ();
				_tmp8_ = _tmp7_;
				_tmp9_ = files_preferences_get_show_hidden_files (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp5_ = _tmp10_;
				_g_object_unref0 (_tmp8_);
			}
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			FilesDirectory* _tmp11_;
			_tmp11_ = dir;
			g_signal_emit_by_name (_tmp11_, "icon-changed", self);
		}
		_g_object_unref0 (dir);
	}
}

static void
__files_file___lambda9__files_file_icon_changed (FilesFile* _sender,
                                                 gpointer self)
{
	_files_file___lambda9_ ((FilesFile*) self);
}

static GObject *
files_file_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesFile * self;
	gchar* scheme = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	parent_class = G_OBJECT_CLASS (files_file_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE, FilesFile);
	_tmp0_ = self->priv->_location;
	_tmp1_ = g_file_get_uri_scheme (_tmp0_);
	scheme = _tmp1_;
	_tmp3_ = scheme;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		const gchar* _tmp4_;
		_tmp4_ = scheme;
		_tmp2_ = g_strcmp0 (_tmp4_, "file") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	self->is_remote = _tmp2_;
	g_signal_connect_object (self, "icon-changed", (GCallback) __files_file___lambda9__files_file_icon_changed, self, 0);
	_tmp7_ = self->priv->_basename;
	if (g_str_has_prefix (_tmp7_, ".")) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = self->priv->_basename;
		_tmp6_ = g_str_has_prefix (_tmp8_, "~");
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = self->priv->_basename;
		_tmp5_ = g_str_has_suffix (_tmp9_, "~");
	}
	files_file_set_is_hidden (self, _tmp5_);
	_g_free0 (scheme);
	return obj;
}

static void
files_file_class_init (FilesFileClass * klass,
                       gpointer klass_data)
{
	files_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_file_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_file_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_LOCATION_PROPERTY, files_file_properties[FILES_FILE_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_DIRECTORY_PROPERTY, files_file_properties[FILES_FILE_DIRECTORY_PROPERTY] = g_param_spec_object ("directory", "directory", "directory", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_BASENAME_PROPERTY, files_file_properties[FILES_FILE_BASENAME_PROPERTY] = g_param_spec_string ("basename", "basename", "basename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_URI_PROPERTY, files_file_properties[FILES_FILE_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_COLOR_PROPERTY, files_file_properties[FILES_FILE_COLOR_PROPERTY] = g_param_spec_int ("color", "color", "color", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_IS_HIDDEN_PROPERTY, files_file_properties[FILES_FILE_IS_HIDDEN_PROPERTY] = g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_THUMBNAIL_PATH_PROPERTY, files_file_properties[FILES_FILE_THUMBNAIL_PATH_PROPERTY] = g_param_spec_string ("thumbnail-path", "thumbnail-path", "thumbnail-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_EXISTS_PROPERTY, files_file_properties[FILES_FILE_EXISTS_PROPERTY] = g_param_spec_boolean ("exists", "exists", "exists", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_file_signals[FILES_FILE_CHANGED_SIGNAL] = g_signal_new ("changed", FILES_TYPE_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_file_signals[FILES_FILE_ICON_CHANGED_SIGNAL] = g_signal_new ("icon-changed", FILES_TYPE_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_file_signals[FILES_FILE_DESTROY_SIGNAL] = g_signal_new ("destroy", FILES_TYPE_FILE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_rec_mutex_init (&__lock_files_file_files_file_file_cache);
}

static void
files_file_instance_init (FilesFile * self,
                          gpointer klass)
{
	self->priv = files_file_get_instance_private (self);
	self->target_location = NULL;
	self->target_gof = NULL;
	self->icon = NULL;
	self->emblems_list = NULL;
	self->n_emblems = (guint) 0;
	self->info = NULL;
	self->custom_display_name = NULL;
	self->size = (guint64) 0;
	self->count = -1;
	self->format_size = NULL;
	self->priv->_color = -1;
	self->formated_modified = NULL;
	self->formated_type = NULL;
	self->tagstype = NULL;
	self->pix = NULL;
	self->custom_icon_name = NULL;
	self->pix_size = 16;
	self->pix_scale = 1;
	self->priv->pix_is_final = FALSE;
	self->width = 0;
	self->height = 0;
	self->sort_column_id = (gint) FILES_LIST_MODEL_COLUMN_ID_FILENAME;
	self->sort_order = GTK_SORT_ASCENDING;
	self->is_remote = FALSE;
	self->is_directory = FALSE;
	self->is_desktop = FALSE;
	self->is_expanded = FALSE;
	self->thumbstate = (guint) FILES_FILE_THUMB_STATE_UNKNOWN;
	self->priv->_thumbnail_path = NULL;
	self->thumbnail_loaded = FALSE;
	self->is_mounted = TRUE;
	self->priv->_exists = TRUE;
	self->owner = NULL;
	self->group = NULL;
	self->mount = NULL;
	self->is_connected = TRUE;
	self->utf8_collation_key = NULL;
}

static void
files_file_finalize (GObject * obj)
{
	FilesFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE, FilesFile);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->target_location);
	_g_object_unref0 (self->target_gof);
	_g_object_unref0 (self->icon);
	(self->emblems_list == NULL) ? NULL : (self->emblems_list = (_g_list_free__g_free0_ (self->emblems_list), NULL));
	_g_object_unref0 (self->info);
	_g_free0 (self->priv->_basename);
	_g_free0 (self->custom_display_name);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->format_size);
	_g_free0 (self->formated_modified);
	_g_free0 (self->formated_type);
	_g_free0 (self->tagstype);
	_g_object_unref0 (self->pix);
	_g_free0 (self->custom_icon_name);
	_g_free0 (self->priv->_thumbnail_path);
	_g_free0 (self->owner);
	_g_free0 (self->group);
	_g_object_unref0 (self->mount);
	_g_free0 (self->utf8_collation_key);
	G_OBJECT_CLASS (files_file_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFile), 0, (GInstanceInitFunc) files_file_instance_init, NULL };
	GType files_file_type_id;
	files_file_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesFile", &g_define_type_info, 0);
	FilesFile_private_offset = g_type_add_instance_private (files_file_type_id, sizeof (FilesFilePrivate));
	return files_file_type_id;
}

GType
files_file_get_type (void)
{
	static volatile gsize files_file_type_id__once = 0;
	if (g_once_init_enter (&files_file_type_id__once)) {
		GType files_file_type_id;
		files_file_type_id = files_file_get_type_once ();
		g_once_init_leave (&files_file_type_id__once, files_file_type_id);
	}
	return files_file_type_id__once;
}

static void
_vala_files_file_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	FilesFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_FILE, FilesFile);
	switch (property_id) {
		case FILES_FILE_LOCATION_PROPERTY:
		g_value_set_object (value, files_file_get_location (self));
		break;
		case FILES_FILE_DIRECTORY_PROPERTY:
		g_value_set_object (value, files_file_get_directory (self));
		break;
		case FILES_FILE_BASENAME_PROPERTY:
		g_value_set_string (value, files_file_get_basename (self));
		break;
		case FILES_FILE_URI_PROPERTY:
		g_value_set_string (value, files_file_get_uri (self));
		break;
		case FILES_FILE_COLOR_PROPERTY:
		g_value_set_int (value, files_file_get_color (self));
		break;
		case FILES_FILE_IS_HIDDEN_PROPERTY:
		g_value_set_boolean (value, files_file_get_is_hidden (self));
		break;
		case FILES_FILE_THUMBNAIL_PATH_PROPERTY:
		g_value_set_string (value, files_file_get_thumbnail_path (self));
		break;
		case FILES_FILE_EXISTS_PROPERTY:
		g_value_set_boolean (value, files_file_get_exists (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_file_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	FilesFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_FILE, FilesFile);
	switch (property_id) {
		case FILES_FILE_LOCATION_PROPERTY:
		files_file_set_location (self, g_value_get_object (value));
		break;
		case FILES_FILE_DIRECTORY_PROPERTY:
		files_file_set_directory (self, g_value_get_object (value));
		break;
		case FILES_FILE_BASENAME_PROPERTY:
		files_file_set_basename (self, g_value_get_string (value));
		break;
		case FILES_FILE_URI_PROPERTY:
		files_file_set_uri (self, g_value_get_string (value));
		break;
		case FILES_FILE_COLOR_PROPERTY:
		files_file_set_color (self, g_value_get_int (value));
		break;
		case FILES_FILE_IS_HIDDEN_PROPERTY:
		files_file_set_is_hidden (self, g_value_get_boolean (value));
		break;
		case FILES_FILE_THUMBNAIL_PATH_PROPERTY:
		files_file_set_thumbnail_path (self, g_value_get_string (value));
		break;
		case FILES_FILE_EXISTS_PROPERTY:
		files_file_set_exists (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

