/* completion-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from completion-provider.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. <https://elementary.io>
 * Copyright (c) 2013 Mario Guerriero <mario@elementaryos.org>
 *
 * This is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */

#include "word-completion.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "codecore.h"
#include <glib/gi18n-lib.h>

#define SCRATCH_PLUGINS_COMPLETION_PROVIDER_MAX_COMPLETIONS 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_0_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
enum  {
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_CAN_PROPOSE_SIGNAL,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_SIGNALS
};
static guint scratch_plugins_completion_provider_signals[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_SIGNALS] = {0};

struct _ScratchPluginsCompletionProviderPrivate {
	gchar* _name;
	gint _priority;
	gint _interactive_delay;
	GtkSourceCompletionActivation _activation;
	GtkTextView* _view;
	EuclideCompletionParser* _parser;
	GtkTextMark* completion_end_mark;
	GtkTextMark* completion_start_mark;
	gchar* current_text_to_find;
};

static gint ScratchPluginsCompletionProvider_private_offset;
static gpointer scratch_plugins_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface * scratch_plugins_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static GType scratch_plugins_completion_provider_type_id = 0;

static gboolean scratch_plugins_completion_provider_real_match (GtkSourceCompletionProvider* base,
                                                         GtkSourceCompletionContext* context);
static GtkTextBuffer* scratch_plugins_completion_provider_get_buffer (ScratchPluginsCompletionProvider* self);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static void scratch_plugins_completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                                        GtkSourceCompletionContext* context);
static gboolean scratch_plugins_completion_provider_get_proposals (ScratchPluginsCompletionProvider* self,
                                                            GList** props,
                                                            gboolean no_minimum);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean scratch_plugins_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                                     GtkSourceCompletionProposal* proposal,
                                                                     GtkTextIter* iter);
static gboolean scratch_plugins_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                                  GtkSourceCompletionContext* context,
                                                                  GtkSourceCompletionProposal* proposal,
                                                                  GtkTextIter* iter);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static GObject * scratch_plugins_completion_provider_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void scratch_plugins_completion_provider_finalize (GObject * obj);
static void _vala_scratch_plugins_completion_provider_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_scratch_plugins_completion_provider_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);

static inline gpointer
scratch_plugins_completion_provider_get_instance_private (ScratchPluginsCompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchPluginsCompletionProvider_private_offset);
}

ScratchPluginsCompletionProvider*
scratch_plugins_completion_provider_construct (GType object_type,
                                               EuclideCompletionParser* _parser,
                                               ScratchServicesDocument* _doc)
{
	ScratchPluginsCompletionProvider * self = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	ScratchWidgetsSourceView* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (_parser != NULL, NULL);
	g_return_val_if_fail (_doc != NULL, NULL);
	_tmp0_ = scratch_services_document_get_source_view (_doc);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_services_document_get_basename (_doc);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf (_ ("%s - Word Completion"), _tmp3_);
	_tmp5_ = _tmp4_;
	self = (ScratchPluginsCompletionProvider*) g_object_new (object_type, "parser", _parser, "view", _tmp1_, "name", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	return self;
}

ScratchPluginsCompletionProvider*
scratch_plugins_completion_provider_new (EuclideCompletionParser* _parser,
                                         ScratchServicesDocument* _doc)
{
	return scratch_plugins_completion_provider_construct (SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, _parser, _doc);
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static gboolean
scratch_plugins_completion_provider_real_match (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter* _tmp7_;
	GtkTextIter* _tmp8_;
	gchar* text = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_;
	gchar* _tmp13_;
	EuclideCompletionParser* _tmp14_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "cursor-position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp6_, _tmp5_);
	end = _tmp6_;
	_tmp7_ = gtk_text_iter_copy (&end);
	_tmp8_ = _tmp7_;
	start = *_tmp8_;
	__vala_GtkTextIter_free0 (_tmp8_);
	euclide_completion_parser_back_to_word_start (&start);
	_tmp9_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = start;
	_tmp12_ = end;
	_tmp13_ = gtk_text_buffer_get_text (_tmp10_, &_tmp11_, &_tmp12_, TRUE);
	text = _tmp13_;
	_tmp14_ = self->priv->_parser;
	result = euclide_completion_parser_match (_tmp14_, text);
	_g_free0 (text);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
scratch_plugins_completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                                   GtkSourceCompletionContext* context)
{
	ScratchPluginsCompletionProvider * self;
	GList* file_props = NULL;
	gboolean no_minimum = FALSE;
	GList* _tmp0_ = NULL;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	no_minimum = gtk_source_completion_context_get_activation (context) == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	scratch_plugins_completion_provider_get_proposals (self, &_tmp0_, no_minimum);
	(file_props == NULL) ? NULL : (file_props = (_g_list_free__g_object_unref0_ (file_props), NULL));
	file_props = _tmp0_;
	gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, file_props, TRUE);
	(file_props == NULL) ? NULL : (file_props = (_g_list_free__g_object_unref0_ (file_props), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
scratch_plugins_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                            GtkSourceCompletionProposal* proposal,
                                                            GtkTextIter* iter)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextMark* _tmp10_;
	GtkTextMark* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextMark* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	GtkTextBuffer* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_mark (_tmp1_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (mark);
	mark = _tmp3_;
	_tmp4_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = mark;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp7_, _tmp6_);
	end = _tmp7_;
	_tmp8_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_text_buffer_get_mark (_tmp9_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (mark);
	mark = _tmp11_;
	_tmp12_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = mark;
	gtk_text_buffer_get_iter_at_mark (_tmp13_, &_tmp15_, _tmp14_);
	start = _tmp15_;
	_tmp16_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp17_ = _tmp16_;
	gtk_text_buffer_delete (_tmp17_, &start, &end);
	_tmp18_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gtk_source_completion_proposal_get_text (proposal);
	_tmp21_ = _tmp20_;
	_tmp22_ = gtk_source_completion_proposal_get_text (proposal);
	_tmp23_ = _tmp22_;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	gtk_text_buffer_insert (_tmp19_, &start, _tmp21_, _tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	result = TRUE;
	_g_object_unref0 (mark);
	return result;
}

static gboolean
scratch_plugins_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                         GtkSourceCompletionContext* context,
                                                         GtkSourceCompletionProposal* proposal,
                                                         GtkTextIter* iter)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_tmp0_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	mark = _tmp3_;
	_tmp4_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp6_, mark);
	cursor_iter = _tmp6_;
	_tmp7_ = cursor_iter;
	_vala_iter = _tmp7_;
	euclide_completion_parser_back_to_word_start (&_vala_iter);
	result = TRUE;
	_g_object_unref0 (mark);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
scratch_plugins_completion_provider_get_proposals (ScratchPluginsCompletionProvider* self,
                                                   GList** props,
                                                   gboolean no_minimum)
{
	GList* _vala_props = NULL;
	gchar* to_find = NULL;
	gchar* _tmp0_;
	GtkTextBuffer* temp_buffer = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	GtkTextBuffer* _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	GtkTextIter _tmp29_;
	GtkTextBuffer* _tmp30_;
	GtkTextBuffer* _tmp31_;
	GtkTextIter _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	to_find = _tmp0_;
	_tmp1_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	temp_buffer = _tmp3_;
	(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
	_vala_props = NULL;
	_tmp4_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_selection_bounds (_tmp5_, &_tmp6_, &_tmp7_);
	start = _tmp6_;
	end = _tmp7_;
	_tmp8_ = temp_buffer;
	_tmp9_ = start;
	_tmp10_ = end;
	_tmp11_ = gtk_text_buffer_get_text (_tmp8_, &_tmp9_, &_tmp10_, TRUE);
	_g_free0 (to_find);
	to_find = _tmp11_;
	_tmp12_ = to_find;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == 0) {
		GtkTextBuffer* _tmp15_;
		GtkTextBuffer* _tmp16_;
		GtkTextBuffer* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GtkTextIter _tmp20_ = {0};
		GtkTextIter _tmp21_;
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextIter _tmp24_;
		GtkTextIter _tmp25_;
		gchar* _tmp26_;
		_tmp15_ = temp_buffer;
		_tmp16_ = scratch_plugins_completion_provider_get_buffer (self);
		_tmp17_ = _tmp16_;
		g_object_get (_tmp17_, "cursor-position", &_tmp18_, NULL);
		_tmp19_ = _tmp18_;
		gtk_text_buffer_get_iter_at_offset (_tmp15_, &_tmp20_, _tmp19_);
		end = _tmp20_;
		_tmp21_ = end;
		start = _tmp21_;
		euclide_completion_parser_back_to_word_start (&start);
		_tmp22_ = scratch_plugins_completion_provider_get_buffer (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = start;
		_tmp25_ = end;
		_tmp26_ = gtk_text_buffer_get_text (_tmp23_, &_tmp24_, &_tmp25_, FALSE);
		_g_free0 (to_find);
		to_find = _tmp26_;
	}
	_tmp27_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = end;
	gtk_text_buffer_move_mark_by_name (_tmp28_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME, &_tmp29_);
	_tmp30_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = start;
	gtk_text_buffer_move_mark_by_name (_tmp31_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME, &_tmp32_);
	if (no_minimum) {
		_tmp33_ = TRUE;
	} else {
		const gchar* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp34_ = to_find;
		_tmp35_ = strlen (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp33_ = _tmp36_ >= EUCLIDE_COMPLETION_PARSER_MINIMUM_WORD_LENGTH;
	}
	if (_tmp33_) {
		GList* prop_word_list = NULL;
		EuclideCompletionParser* _tmp37_;
		const gchar* _tmp38_;
		GList* _tmp39_ = NULL;
		gboolean _tmp40_;
		_tmp37_ = self->priv->_parser;
		_tmp38_ = to_find;
		_tmp40_ = euclide_completion_parser_get_for_word (_tmp37_, _tmp38_, &_tmp39_);
		(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
		prop_word_list = _tmp39_;
		if (_tmp40_) {
			GList* _tmp41_;
			_tmp41_ = prop_word_list;
			{
				GList* word_collection = NULL;
				GList* word_it = NULL;
				word_collection = _tmp41_;
				for (word_it = word_collection; word_it != NULL; word_it = word_it->next) {
					gchar* _tmp42_;
					gchar* word = NULL;
					_tmp42_ = g_strdup ((const gchar*) word_it->data);
					word = _tmp42_;
					{
						GtkSourceCompletionItem* item = NULL;
						GtkSourceCompletionItem* _tmp43_;
						GtkSourceCompletionItem* _tmp44_;
						const gchar* _tmp45_;
						GtkSourceCompletionItem* _tmp46_;
						const gchar* _tmp47_;
						GtkSourceCompletionItem* _tmp48_;
						GtkSourceCompletionItem* _tmp49_;
						_tmp43_ = gtk_source_completion_item_new ();
						item = _tmp43_;
						_tmp44_ = item;
						_tmp45_ = word;
						g_object_set (_tmp44_, "label", _tmp45_, NULL);
						_tmp46_ = item;
						_tmp47_ = word;
						g_object_set (_tmp46_, "text", _tmp47_, NULL);
						_tmp48_ = item;
						_tmp49_ = _g_object_ref0 (_tmp48_);
						_vala_props = g_list_append (_vala_props, _tmp49_);
						_g_object_unref0 (item);
						_g_free0 (word);
					}
				}
			}
			result = TRUE;
			(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
			_g_object_unref0 (temp_buffer);
			_g_free0 (to_find);
			if (props) {
				*props = _vala_props;
			} else {
				(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
			}
			return result;
		}
		(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
	}
	result = FALSE;
	_g_object_unref0 (temp_buffer);
	_g_free0 (to_find);
	if (props) {
		*props = _vala_props;
	} else {
		(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
	}
	return result;
}

const gchar*
scratch_plugins_completion_provider_get_name (ScratchPluginsCompletionProvider* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_provider_set_name (ScratchPluginsCompletionProvider* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY]);
	}
}

gint
scratch_plugins_completion_provider_get_priority (ScratchPluginsCompletionProvider* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_priority;
	return result;
}

static void
scratch_plugins_completion_provider_set_priority (ScratchPluginsCompletionProvider* self,
                                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_priority (self);
	if (old_value != value) {
		self->priv->_priority = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY]);
	}
}

gint
scratch_plugins_completion_provider_get_interactive_delay (ScratchPluginsCompletionProvider* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_interactive_delay;
	return result;
}

static void
scratch_plugins_completion_provider_set_interactive_delay (ScratchPluginsCompletionProvider* self,
                                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_interactive_delay (self);
	if (old_value != value) {
		self->priv->_interactive_delay = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY]);
	}
}

GtkSourceCompletionActivation
scratch_plugins_completion_provider_get_activation (ScratchPluginsCompletionProvider* self)
{
	GtkSourceCompletionActivation result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_activation;
	return result;
}

static void
scratch_plugins_completion_provider_set_activation (ScratchPluginsCompletionProvider* self,
                                                    GtkSourceCompletionActivation value)
{
	GtkSourceCompletionActivation old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_activation (self);
	if (old_value != value) {
		self->priv->_activation = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY]);
	}
}

GtkTextView*
scratch_plugins_completion_provider_get_view (ScratchPluginsCompletionProvider* self)
{
	GtkTextView* result;
	GtkTextView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_provider_set_view (ScratchPluginsCompletionProvider* self,
                                              GtkTextView* value)
{
	GtkTextView* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_view (self);
	if (old_value != value) {
		GtkTextView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY]);
	}
}

EuclideCompletionParser*
scratch_plugins_completion_provider_get_parser (ScratchPluginsCompletionProvider* self)
{
	EuclideCompletionParser* result;
	EuclideCompletionParser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parser;
	result = _tmp0_;
	return result;
}

static void
scratch_plugins_completion_provider_set_parser (ScratchPluginsCompletionProvider* self,
                                                EuclideCompletionParser* value)
{
	EuclideCompletionParser* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_plugins_completion_provider_get_parser (self);
	if (old_value != value) {
		EuclideCompletionParser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_parser);
		self->priv->_parser = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY]);
	}
}

static GtkTextBuffer*
scratch_plugins_completion_provider_get_buffer (ScratchPluginsCompletionProvider* self)
{
	GtkTextBuffer* result;
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GObject *
scratch_plugins_completion_provider_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchPluginsCompletionProvider * self;
	GtkTextIter iter = {0};
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextMark* _tmp12_;
	GtkTextMark* _tmp13_;
	parent_class = G_OBJECT_CLASS (scratch_plugins_completion_provider_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, ScratchPluginsCompletionProvider);
	scratch_plugins_completion_provider_set_interactive_delay (self, (gint) SCRATCH_PLUGINS_COMPLETION_INTERACTIVE_DELAY);
	scratch_plugins_completion_provider_set_activation (self, GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE | GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED);
	_tmp0_ = self->priv->_view;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_iter_at_offset (_tmp2_, &_tmp3_, 0);
	iter = _tmp3_;
	_tmp4_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = iter;
	_tmp7_ = gtk_text_buffer_create_mark (_tmp5_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME, &_tmp6_, FALSE);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->completion_end_mark);
	self->priv->completion_end_mark = _tmp8_;
	_tmp9_ = scratch_plugins_completion_provider_get_buffer (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = iter;
	_tmp12_ = gtk_text_buffer_create_mark (_tmp10_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME, &_tmp11_, FALSE);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->completion_start_mark);
	self->priv->completion_start_mark = _tmp13_;
	return obj;
}

static void
scratch_plugins_completion_provider_class_init (ScratchPluginsCompletionProviderClass * klass,
                                                gpointer klass_data)
{
	scratch_plugins_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchPluginsCompletionProvider_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_plugins_completion_provider_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_plugins_completion_provider_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_plugins_completion_provider_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_plugins_completion_provider_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY] = g_param_spec_int ("priority", "priority", "priority", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY] = g_param_spec_int ("interactive-delay", "interactive-delay", "interactive-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY] = g_param_spec_flags ("activation", "activation", "activation", gtk_source_completion_activation_get_type (), 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", gtk_text_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY, scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY] = g_param_spec_object ("parser", "parser", "parser", EUCLIDE_COMPLETION_TYPE_PARSER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	scratch_plugins_completion_provider_signals[SCRATCH_PLUGINS_COMPLETION_PROVIDER_CAN_PROPOSE_SIGNAL] = g_signal_new ("can-propose", SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
scratch_plugins_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface,
                                                                                   gpointer iface_data)
{
	scratch_plugins_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->match = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) scratch_plugins_completion_provider_real_match;
	iface->populate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) scratch_plugins_completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) scratch_plugins_completion_provider_real_activate_proposal;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) scratch_plugins_completion_provider_real_get_start_iter;
}

static void
scratch_plugins_completion_provider_instance_init (ScratchPluginsCompletionProvider * self,
                                                   gpointer klass)
{
	gchar* _tmp0_;
	self->priv = scratch_plugins_completion_provider_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->current_text_to_find = _tmp0_;
}

static void
scratch_plugins_completion_provider_finalize (GObject * obj)
{
	ScratchPluginsCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, ScratchPluginsCompletionProvider);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_parser);
	_g_object_unref0 (self->priv->completion_end_mark);
	_g_object_unref0 (self->priv->completion_start_mark);
	_g_free0 (self->priv->current_text_to_find);
	G_OBJECT_CLASS (scratch_plugins_completion_provider_parent_class)->finalize (obj);
}

GType
scratch_plugins_completion_provider_get_type (void)
{
	return scratch_plugins_completion_provider_type_id;
}

GType
scratch_plugins_completion_provider_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchPluginsCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_plugins_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchPluginsCompletionProvider), 0, (GInstanceInitFunc) scratch_plugins_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) scratch_plugins_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	scratch_plugins_completion_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ScratchPluginsCompletionProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, scratch_plugins_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	ScratchPluginsCompletionProvider_private_offset = sizeof (ScratchPluginsCompletionProviderPrivate);
	return scratch_plugins_completion_provider_type_id;
}

static void
_vala_scratch_plugins_completion_provider_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	ScratchPluginsCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, ScratchPluginsCompletionProvider);
	switch (property_id) {
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, scratch_plugins_completion_provider_get_name (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY:
		g_value_set_int (value, scratch_plugins_completion_provider_get_priority (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY:
		g_value_set_int (value, scratch_plugins_completion_provider_get_interactive_delay (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY:
		g_value_set_flags (value, scratch_plugins_completion_provider_get_activation (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY:
		g_value_set_object (value, scratch_plugins_completion_provider_get_view (self));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY:
		g_value_set_object (value, scratch_plugins_completion_provider_get_parser (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_plugins_completion_provider_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	ScratchPluginsCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, ScratchPluginsCompletionProvider);
	switch (property_id) {
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_NAME_PROPERTY:
		scratch_plugins_completion_provider_set_name (self, g_value_get_string (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_PRIORITY_PROPERTY:
		scratch_plugins_completion_provider_set_priority (self, g_value_get_int (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_INTERACTIVE_DELAY_PROPERTY:
		scratch_plugins_completion_provider_set_interactive_delay (self, g_value_get_int (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_ACTIVATION_PROPERTY:
		scratch_plugins_completion_provider_set_activation (self, g_value_get_flags (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_VIEW_PROPERTY:
		scratch_plugins_completion_provider_set_view (self, g_value_get_object (value));
		break;
		case SCRATCH_PLUGINS_COMPLETION_PROVIDER_PARSER_PROPERTY:
		scratch_plugins_completion_provider_set_parser (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

