// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/node/inspector/protocol/Network.h"

#include "src/node/inspector/protocol/Protocol.h"

#include "crdtp/cbor.h"
#include "crdtp/find_by_first.h"
#include "crdtp/span.h"

namespace node {
namespace inspector {
namespace protocol {
namespace Network {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Network";
const char Metainfo::commandPrefix[] = "Network.";
const char Metainfo::version[] = "1.0";

namespace ResourceTypeEnum {
const char Document[] = "Document";
const char Stylesheet[] = "Stylesheet";
const char Image[] = "Image";
const char Media[] = "Media";
const char Font[] = "Font";
const char Script[] = "Script";
const char TextTrack[] = "TextTrack";
const char XHR[] = "XHR";
const char Fetch[] = "Fetch";
const char Prefetch[] = "Prefetch";
const char EventSource[] = "EventSource";
const char WebSocket[] = "WebSocket";
const char Manifest[] = "Manifest";
const char SignedExchange[] = "SignedExchange";
const char Ping[] = "Ping";
const char CSPViolationReport[] = "CSPViolationReport";
const char Preflight[] = "Preflight";
const char Other[] = "Other";
} // namespace ResourceTypeEnum






const char* Initiator::TypeEnum::Parser = "parser";
const char* Initiator::TypeEnum::Script = "script";
const char* Initiator::TypeEnum::Preload = "preload";
const char* Initiator::TypeEnum::SignedExchange = "SignedExchange";
const char* Initiator::TypeEnum::Preflight = "preflight";
const char* Initiator::TypeEnum::Other = "other";
CRDTP_BEGIN_DESERIALIZER(Initiator)
    CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD_OPT("stack", m_stack),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Initiator)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("stack", m_stack);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Request)
    CRDTP_DESERIALIZE_FIELD("hasPostData", m_hasPostData),
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("method", m_method),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Request)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("method", m_method);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
    CRDTP_SERIALIZE_FIELD("hasPostData", m_hasPostData);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Response)
    CRDTP_DESERIALIZE_FIELD("charset", m_charset),
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("mimeType", m_mimeType),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("statusText", m_statusText),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Response)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("statusText", m_statusText);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
    CRDTP_SERIALIZE_FIELD("mimeType", m_mimeType);
    CRDTP_SERIALIZE_FIELD("charset", m_charset);
CRDTP_END_SERIALIZER();



CRDTP_BEGIN_DESERIALIZER(LoadNetworkResourcePageResult)
    CRDTP_DESERIALIZE_FIELD_OPT("stream", m_stream),
    CRDTP_DESERIALIZE_FIELD("success", m_success),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(LoadNetworkResourcePageResult)
    CRDTP_SERIALIZE_FIELD("success", m_success);
    CRDTP_SERIALIZE_FIELD("stream", m_stream);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WebSocketResponse)
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("statusText", m_statusText),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WebSocketResponse)
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("statusText", m_statusText);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::requestWillBeSent(const String& requestId, std::unique_ptr<protocol::Network::Request> request, std::unique_ptr<protocol::Network::Initiator> initiator, double timestamp, double wallTime)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("request"), request);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("wallTime"), wallTime);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestWillBeSent", serializer.Finish()));
}

void Frontend::responseReceived(const String& requestId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.responseReceived", serializer.Finish()));
}

void Frontend::loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("errorText"), errorText);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFailed", serializer.Finish()));
}

void Frontend::loadingFinished(const String& requestId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFinished", serializer.Finish()));
}

void Frontend::dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength, std::optional<Binary> data)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("dataLength"), dataLength);
    serializer.AddField(crdtp::MakeSpan("encodedDataLength"), encodedDataLength);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.dataReceived", serializer.Finish()));
}

void Frontend::webSocketCreated(const String& requestId, const String& url, std::unique_ptr<protocol::Network::Initiator> initiator)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketCreated", serializer.Finish()));
}

void Frontend::webSocketClosed(const String& requestId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketClosed", serializer.Finish()));
}

void Frontend::webSocketHandshakeResponseReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketResponse> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketHandshakeResponseReceived", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getRequestPostData(const crdtp::Dispatchable& dispatchable);
    void getResponseBody(const crdtp::Dispatchable& dispatchable);
    void streamResourceContent(const crdtp::Dispatchable& dispatchable);
    void loadNetworkResource(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getRequestPostData"),
          &DomainDispatcherImpl::getRequestPostData
    },
    {
          crdtp::SpanFrom("getResponseBody"),
          &DomainDispatcherImpl::getResponseBody
    },
    {
          crdtp::SpanFrom("loadNetworkResource"),
          &DomainDispatcherImpl::loadNetworkResource
    },
    {
          crdtp::SpanFrom("streamResourceContent"),
          &DomainDispatcherImpl::streamResourceContent
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<int> maxTotalBufferSize;
    std::optional<int> maxResourceBufferSize;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("maxResourceBufferSize", maxResourceBufferSize),
    CRDTP_DESERIALIZE_FIELD_OPT("maxTotalBufferSize", maxTotalBufferSize),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.maxTotalBufferSize), std::move(params.maxResourceBufferSize));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getRequestPostDataParams : public crdtp::DeserializableProtocolObject<getRequestPostDataParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getRequestPostDataParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getRequestPostData(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getRequestPostDataParams params;
    if (!getRequestPostDataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_postData;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getRequestPostData(params.requestId, &out_postData);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.getRequestPostData"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("postData"), out_postData);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct getResponseBodyParams : public crdtp::DeserializableProtocolObject<getResponseBodyParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getResponseBodyParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getResponseBody(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getResponseBodyParams params;
    if (!getResponseBodyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    String out_body;
    bool out_base64Encoded;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getResponseBody(params.requestId, &out_body, &out_base64Encoded);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.getResponseBody"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("body"), out_body);
          serializer.AddField(crdtp::MakeSpan("base64Encoded"), out_base64Encoded);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct streamResourceContentParams : public crdtp::DeserializableProtocolObject<streamResourceContentParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(streamResourceContentParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::streamResourceContent(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    streamResourceContentParams params;
    if (!streamResourceContentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    Binary out_bufferedData;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->streamResourceContent(params.requestId, &out_bufferedData);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.streamResourceContent"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("bufferedData"), out_bufferedData);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct loadNetworkResourceParams : public crdtp::DeserializableProtocolObject<loadNetworkResourceParams> {
    String url;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(loadNetworkResourceParams)
    CRDTP_DESERIALIZE_FIELD("url", url),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::loadNetworkResource(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    loadNetworkResourceParams params;
    if (!loadNetworkResourceParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Network::LoadNetworkResourcePageResult> out_resource;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->loadNetworkResource(params.url, &out_resource);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.loadNetworkResource"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("resource"), out_resource);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Network"), SortedRedirects(), std::move(dispatcher));
}

} // Network
} // namespace node
} // namespace inspector
} // namespace protocol
