//! # DBus interface proxy for: `org.freedesktop.UDisks2.NVMe.Controller`
//!
//! This code was generated by `zbus-xmlgen` `4.0.0` from DBus introspection data.
//! Source: `org.freedesktop.UDisks2.xml`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus2.github.io/zbus/client.html)
//! section of the zbus documentation.
//!

use zbus::proxy;

use crate::error;

#[proxy(
    interface = "org.freedesktop.UDisks2.NVMe.Controller",
    default_service = "org.freedesktop.UDisks2",
    default_path = "/org/freedesktop/UDisks2/NVMe"
)]
pub trait Controller {
    /// SanitizeStart method
    fn sanitize_start(
        &self,
        action: &str,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// SmartGetAttributes method
    fn smart_get_attributes(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<std::collections::HashMap<String, zbus::zvariant::OwnedValue>>;

    /// SmartSelftestAbort method
    fn smart_selftest_abort(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// SmartSelftestStart method
    fn smart_selftest_start(
        &self,
        type_: &str,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// SmartUpdate method
    fn smart_update(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// ControllerID property
    #[zbus(property, name = "ControllerID")]
    fn controller_id(&self) -> error::Result<u16>;

    /// FGUID property
    #[zbus(property, name = "FGUID")]
    fn fguid(&self) -> error::Result<String>;

    /// NVMeRevision property
    #[zbus(property, name = "NVMeRevision")]
    fn nvme_revision(&self) -> error::Result<String>;

    /// SanitizePercentRemaining property
    #[zbus(property)]
    fn sanitize_percent_remaining(&self) -> error::Result<i32>;

    /// SanitizeStatus property
    #[zbus(property)]
    fn sanitize_status(&self) -> error::Result<String>;

    /// SmartCriticalWarning property
    #[zbus(property)]
    fn smart_critical_warning(&self) -> error::Result<Vec<String>>;

    /// SmartPowerOnHours property
    #[zbus(property)]
    fn smart_power_on_hours(&self) -> error::Result<u64>;

    /// SmartSelftestPercentRemaining property
    #[zbus(property)]
    fn smart_selftest_percent_remaining(&self) -> error::Result<i32>;

    /// SmartSelftestStatus property
    #[zbus(property)]
    fn smart_selftest_status(&self) -> error::Result<String>;

    /// SmartTemperature property
    #[zbus(property)]
    fn smart_temperature(&self) -> error::Result<u16>;

    /// SmartUpdated property
    #[zbus(property)]
    fn smart_updated(&self) -> error::Result<u64>;

    /// State property
    #[zbus(property)]
    fn state(&self) -> error::Result<String>;

    /// SubsystemNQN property
    #[zbus(property, name = "SubsystemNQN")]
    fn subsystem_nqn(&self) -> error::Result<Vec<u8>>;

    /// UnallocatedCapacity property
    #[zbus(property)]
    fn unallocated_capacity(&self) -> error::Result<u64>;
}
