/* PanelWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from PanelWindow.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <meta/common.h>
#include <meta/meta-plugin.h>
#include <meta/window.h>
#include <glib.h>
#include <meta/boxes.h>
#include <mtk/mtk.h>
#include "pantheon-desktop-shell-server-protocol.h"
#include <meta/display.h>
#include <string.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GREETER_COMPOSITOR_PANEL_WINDOW_BARRIER_OFFSET 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_PANEL_WINDOW (greeter_compositor_panel_window_get_type ())
#define GREETER_COMPOSITOR_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow))
#define GREETER_COMPOSITOR_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindowClass))
#define GREETER_COMPOSITOR_IS_PANEL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW))
#define GREETER_COMPOSITOR_IS_PANEL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW))
#define GREETER_COMPOSITOR_PANEL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindowClass))

typedef struct _GreeterCompositorPanelWindow GreeterCompositorPanelWindow;
typedef struct _GreeterCompositorPanelWindowClass GreeterCompositorPanelWindowClass;
typedef struct _GreeterCompositorPanelWindowPrivate GreeterCompositorPanelWindowPrivate;

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;

#define GREETER_COMPOSITOR_TYPE_PANEL_CLONE (greeter_compositor_panel_clone_get_type ())
#define GREETER_COMPOSITOR_PANEL_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_PANEL_CLONE, GreeterCompositorPanelClone))
#define GREETER_COMPOSITOR_PANEL_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_PANEL_CLONE, GreeterCompositorPanelCloneClass))
#define GREETER_COMPOSITOR_IS_PANEL_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_PANEL_CLONE))
#define GREETER_COMPOSITOR_IS_PANEL_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_PANEL_CLONE))
#define GREETER_COMPOSITOR_PANEL_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_PANEL_CLONE, GreeterCompositorPanelCloneClass))

typedef struct _GreeterCompositorPanelClone GreeterCompositorPanelClone;
typedef struct _GreeterCompositorPanelCloneClass GreeterCompositorPanelCloneClass;
enum  {
	GREETER_COMPOSITOR_PANEL_WINDOW_0_PROPERTY,
	GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY,
	GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY,
	GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY,
	GREETER_COMPOSITOR_PANEL_WINDOW_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block16Data Block16Data;

struct _GreeterCompositorPanelWindow {
	GObject parent_instance;
	GreeterCompositorPanelWindowPrivate * priv;
	MetaSide anchor;
};

struct _GreeterCompositorPanelWindowClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorPanelWindowPrivate {
	GreeterCompositorWindowManager* _wm;
	MetaWindow* _window;
	gboolean _hidden;
	GreeterCompositorPanelClone* clone;
	guint idle_move_id;
	gint width;
	gint height;
};

struct _Block16Data {
	int _ref_count_;
	GreeterCompositorPanelWindow* self;
	gint x;
	gint y;
};

static gint GreeterCompositorPanelWindow_private_offset;
static gpointer greeter_compositor_panel_window_parent_class = NULL;
static GHashTable* greeter_compositor_panel_window_window_struts;
static GHashTable* greeter_compositor_panel_window_window_struts = NULL;

VALA_EXTERN GType greeter_compositor_panel_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPanelWindow, g_object_unref)
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN GType greeter_compositor_panel_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorPanelClone, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
VALA_EXTERN GreeterCompositorPanelWindow* greeter_compositor_panel_window_new (GreeterCompositorWindowManager* wm,
                                                                   MetaWindow* window,
                                                                   MetaSide anchor);
VALA_EXTERN GreeterCompositorPanelWindow* greeter_compositor_panel_window_construct (GType object_type,
                                                                         GreeterCompositorWindowManager* wm,
                                                                         MetaWindow* window,
                                                                         MetaSide anchor);
VALA_EXTERN void greeter_compositor_panel_window_get_custom_window_rect (GreeterCompositorPanelWindow* self,
                                                             MtkRectangle* result);
VALA_EXTERN MetaWindow* greeter_compositor_panel_window_get_window (GreeterCompositorPanelWindow* self);
VALA_EXTERN void greeter_compositor_panel_window_set_size (GreeterCompositorPanelWindow* self,
                                               gint width,
                                               gint height);
static void greeter_compositor_panel_window_position_window (GreeterCompositorPanelWindow* self);
VALA_EXTERN void greeter_compositor_panel_window_set_hide_mode (GreeterCompositorPanelWindow* self,
                                                    enum io_elementary_pantheon_panel_v1_hide_mode hide_mode);
VALA_EXTERN enum io_elementary_pantheon_panel_v1_hide_mode greeter_compositor_panel_clone_get_hide_mode (GreeterCompositorPanelClone* self);
VALA_EXTERN void greeter_compositor_panel_window_update_anchor (GreeterCompositorPanelWindow* self,
                                                    MetaSide anchor);
VALA_EXTERN GreeterCompositorWindowManager* greeter_compositor_panel_window_get_wm (GreeterCompositorPanelWindow* self);
static void greeter_compositor_panel_window_position_window_top (GreeterCompositorPanelWindow* self,
                                                          MtkRectangle* monitor_geom,
                                                          MtkRectangle* window_rect);
static void greeter_compositor_panel_window_position_window_bottom (GreeterCompositorPanelWindow* self,
                                                             MtkRectangle* monitor_geom,
                                                             MtkRectangle* window_rect);
static void greeter_compositor_panel_window_update_strut (GreeterCompositorPanelWindow* self);
static void greeter_compositor_panel_window_move_window_idle (GreeterCompositorPanelWindow* self,
                                                       gint x,
                                                       gint y);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda81_ (Block16Data* _data16_);
static gboolean ___lambda81__gsource_func (gpointer self);
VALA_EXTERN void greeter_compositor_panel_clone_set_hide_mode (GreeterCompositorPanelClone* self,
                                                   enum io_elementary_pantheon_panel_v1_hide_mode value);
static void greeter_compositor_panel_window_make_exclusive (GreeterCompositorPanelWindow* self);
static void greeter_compositor_panel_window_unmake_exclusive (GreeterCompositorPanelWindow* self);
static MetaStrut* _meta_strut_dup (MetaStrut* self);
static void greeter_compositor_panel_window_update_struts (GreeterCompositorPanelWindow* self);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void greeter_compositor_panel_window_set_wm (GreeterCompositorPanelWindow* self,
                                             GreeterCompositorWindowManager* value);
static void greeter_compositor_panel_window_set_window (GreeterCompositorPanelWindow* self,
                                                 MetaWindow* value);
VALA_EXTERN gboolean greeter_compositor_panel_window_get_hidden (GreeterCompositorPanelWindow* self);
static void greeter_compositor_panel_window_set_hidden (GreeterCompositorPanelWindow* self,
                                                 gboolean value);
static GObject * greeter_compositor_panel_window_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _greeter_compositor_panel_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                                gpointer self);
static void _greeter_compositor_panel_window___lambda82_ (GreeterCompositorPanelWindow* self);
static void __greeter_compositor_panel_window___lambda82__meta_window_unmanaging (MetaWindow* _sender,
                                                                           gpointer self);
VALA_EXTERN GreeterCompositorPanelClone* greeter_compositor_panel_clone_new (GreeterCompositorWindowManager* wm,
                                                                 GreeterCompositorPanelWindow* panel);
VALA_EXTERN GreeterCompositorPanelClone* greeter_compositor_panel_clone_construct (GType object_type,
                                                                       GreeterCompositorWindowManager* wm,
                                                                       GreeterCompositorPanelWindow* panel);
static void _greeter_compositor_panel_window___lambda83_ (GreeterCompositorPanelWindow* self);
static void __greeter_compositor_panel_window___lambda83__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                          gpointer self);
static void _greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                           gint object,
                                                                                           gpointer self);
static void _greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                             gint object,
                                                                                             gpointer self);
static void greeter_compositor_panel_window_finalize (GObject * obj);
static GType greeter_compositor_panel_window_get_type_once (void);
static void _vala_greeter_compositor_panel_window_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_greeter_compositor_panel_window_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);

static inline gpointer
greeter_compositor_panel_window_get_instance_private (GreeterCompositorPanelWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorPanelWindow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

GreeterCompositorPanelWindow*
greeter_compositor_panel_window_construct (GType object_type,
                                           GreeterCompositorWindowManager* wm,
                                           MetaWindow* window,
                                           MetaSide anchor)
{
	GreeterCompositorPanelWindow * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GreeterCompositorPanelWindow*) g_object_new (object_type, "wm", wm, "window", window, NULL);
	self->anchor = anchor;
	return self;
}

GreeterCompositorPanelWindow*
greeter_compositor_panel_window_new (GreeterCompositorWindowManager* wm,
                                     MetaWindow* window,
                                     MetaSide anchor)
{
	return greeter_compositor_panel_window_construct (GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, wm, window, anchor);
}

void
greeter_compositor_panel_window_get_custom_window_rect (GreeterCompositorPanelWindow* self,
                                                        MtkRectangle* result)
{
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	window_rect = _tmp1_;
	if (self->priv->width > 0) {
		window_rect.width = self->priv->width;
	}
	if (self->priv->height > 0) {
		window_rect.height = self->priv->height;
	}
	*result = window_rect;
	return;
}

void
greeter_compositor_panel_window_set_size (GreeterCompositorPanelWindow* self,
                                          gint width,
                                          gint height)
{
	GreeterCompositorPanelClone* _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->width = width;
	self->priv->height = height;
	greeter_compositor_panel_window_position_window (self);
	_tmp0_ = self->priv->clone;
	_tmp1_ = greeter_compositor_panel_clone_get_hide_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	greeter_compositor_panel_window_set_hide_mode (self, _tmp2_);
}

void
greeter_compositor_panel_window_update_anchor (GreeterCompositorPanelWindow* self,
                                               MetaSide anchor)
{
	GreeterCompositorPanelClone* _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp2_;
	g_return_if_fail (self != NULL);
	self->anchor = anchor;
	greeter_compositor_panel_window_position_window (self);
	_tmp0_ = self->priv->clone;
	_tmp1_ = greeter_compositor_panel_clone_get_hide_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	greeter_compositor_panel_window_set_hide_mode (self, _tmp2_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
greeter_compositor_panel_window_position_window (GreeterCompositorPanelWindow* self)
{
	MetaDisplay* display = NULL;
	GreeterCompositorWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	MtkRectangle _tmp5_ = {0};
	MtkRectangle window_rect = {0};
	MtkRectangle _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = display;
	meta_display_get_monitor_geometry (_tmp3_, meta_display_get_primary_monitor (_tmp4_), &_tmp5_);
	monitor_geom = _tmp5_;
	greeter_compositor_panel_window_get_custom_window_rect (self, &_tmp6_);
	window_rect = _tmp6_;
	switch (self->anchor) {
		case META_SIDE_TOP:
		{
			MtkRectangle _tmp7_;
			MtkRectangle _tmp8_;
			_tmp7_ = monitor_geom;
			_tmp8_ = window_rect;
			greeter_compositor_panel_window_position_window_top (self, &_tmp7_, &_tmp8_);
			break;
		}
		case META_SIDE_BOTTOM:
		{
			MtkRectangle _tmp9_;
			MtkRectangle _tmp10_;
			_tmp9_ = monitor_geom;
			_tmp10_ = window_rect;
			greeter_compositor_panel_window_position_window_bottom (self, &_tmp9_, &_tmp10_);
			break;
		}
		default:
		{
			g_warning ("PanelWindow.vala:108: Side not supported yet");
			break;
		}
	}
	greeter_compositor_panel_window_update_strut (self);
	_g_object_unref0 (display);
}

static void
greeter_compositor_panel_window_position_window_top (GreeterCompositorPanelWindow* self,
                                                     MtkRectangle* monitor_geom,
                                                     MtkRectangle* window_rect)
{
	gint x = 0;
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	MtkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	g_return_if_fail (window_rect != NULL);
	_tmp0_ = *monitor_geom;
	_tmp1_ = *monitor_geom;
	_tmp2_ = *window_rect;
	x = _tmp0_.x + ((_tmp1_.width - _tmp2_.width) / 2);
	_tmp3_ = *monitor_geom;
	greeter_compositor_panel_window_move_window_idle (self, x, _tmp3_.y);
}

static void
greeter_compositor_panel_window_position_window_bottom (GreeterCompositorPanelWindow* self,
                                                        MtkRectangle* monitor_geom,
                                                        MtkRectangle* window_rect)
{
	gint x = 0;
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	gint y = 0;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geom != NULL);
	g_return_if_fail (window_rect != NULL);
	_tmp0_ = *monitor_geom;
	_tmp1_ = *monitor_geom;
	_tmp2_ = *window_rect;
	x = _tmp0_.x + ((_tmp1_.width - _tmp2_.width) / 2);
	_tmp3_ = *monitor_geom;
	_tmp4_ = *monitor_geom;
	_tmp5_ = *window_rect;
	y = (_tmp3_.y + _tmp4_.height) - _tmp5_.height;
	greeter_compositor_panel_window_move_window_idle (self, x, y);
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GreeterCompositorPanelWindow* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda81_ (Block16Data* _data16_)
{
	GreeterCompositorPanelWindow* self;
	MetaWindow* _tmp0_;
	gboolean result;
	self = _data16_->self;
	_tmp0_ = self->priv->_window;
	meta_window_move_frame (_tmp0_, FALSE, _data16_->x, _data16_->y);
	self->priv->idle_move_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda81__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda81_ (self);
	return result;
}

static void
greeter_compositor_panel_window_move_window_idle (GreeterCompositorPanelWindow* self,
                                                  gint x,
                                                  gint y)
{
	Block16Data* _data16_;
	g_return_if_fail (self != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->x = x;
	_data16_->y = y;
	if (self->priv->idle_move_id != ((guint) 0)) {
		g_source_remove (self->priv->idle_move_id);
	}
	self->priv->idle_move_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda81__gsource_func, block16_data_ref (_data16_), block16_data_unref);
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

void
greeter_compositor_panel_window_set_hide_mode (GreeterCompositorPanelWindow* self,
                                               enum io_elementary_pantheon_panel_v1_hide_mode hide_mode)
{
	GreeterCompositorPanelClone* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	greeter_compositor_panel_clone_set_hide_mode (_tmp0_, hide_mode);
	if (hide_mode == IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		greeter_compositor_panel_window_make_exclusive (self);
	} else {
		greeter_compositor_panel_window_unmake_exclusive (self);
	}
}

static void
greeter_compositor_panel_window_make_exclusive (GreeterCompositorPanelWindow* self)
{
	g_return_if_fail (self != NULL);
	greeter_compositor_panel_window_update_strut (self);
}

static MetaStrut*
_meta_strut_dup (MetaStrut* self)
{
	MetaStrut* dup;
	dup = g_new0 (MetaStrut, 1);
	memcpy (dup, self, sizeof (MetaStrut));
	return dup;
}

static gpointer
__meta_strut_dup0 (gpointer self)
{
	return self ? _meta_strut_dup (self) : NULL;
}

static void
greeter_compositor_panel_window_update_strut (GreeterCompositorPanelWindow* self)
{
	GreeterCompositorPanelClone* _tmp0_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp1_;
	enum io_elementary_pantheon_panel_v1_hide_mode _tmp2_;
	MtkRectangle rect = {0};
	MtkRectangle _tmp3_ = {0};
	MetaStrut strut = {0};
	MtkRectangle _tmp4_;
	MetaStrut _tmp5_ = {0};
	GHashTable* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MetaStrut _tmp9_;
	MetaStrut* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	_tmp1_ = greeter_compositor_panel_clone_get_hide_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER) {
		return;
	}
	greeter_compositor_panel_window_get_custom_window_rect (self, &_tmp3_);
	rect = _tmp3_;
	_tmp4_ = rect;
	_tmp5_.rect = _tmp4_;
	_tmp5_.side = self->anchor;
	strut = _tmp5_;
	_tmp6_ = greeter_compositor_panel_window_window_struts;
	_tmp7_ = self->priv->_window;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = strut;
	_tmp10_ = __meta_strut_dup0 (&_tmp9_);
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
	greeter_compositor_panel_window_update_struts (self);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
greeter_compositor_panel_window_update_struts (GreeterCompositorPanelWindow* self)
{
	GSList* list = NULL;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GreeterCompositorWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWorkspaceManager* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	list = NULL;
	_tmp0_ = greeter_compositor_panel_window_window_struts;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* window_strut_collection = NULL;
		GList* window_strut_it = NULL;
		window_strut_collection = _tmp1_;
		for (window_strut_it = window_strut_collection; window_strut_it != NULL; window_strut_it = window_strut_it->next) {
			MetaStrut* window_strut = NULL;
			window_strut = (MetaStrut*) window_strut_it->data;
			{
				MetaStrut* _tmp2_;
				MetaStrut* _tmp3_;
				_tmp2_ = window_strut;
				_tmp3_ = __meta_strut_dup0 (_tmp2_);
				list = g_slist_append (list, _tmp3_);
			}
		}
		(window_strut_collection == NULL) ? NULL : (window_strut_collection = (g_list_free (window_strut_collection), NULL));
	}
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_display_get_workspace_manager (_tmp5_);
	_tmp7_ = meta_workspace_manager_get_workspaces (_tmp6_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp7_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp8_;
			MetaWorkspace* workspace = NULL;
			_tmp8_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp8_;
			{
				MetaWorkspace* _tmp9_;
				GSList* _tmp10_;
				_tmp9_ = workspace;
				_tmp10_ = list;
				meta_workspace_set_builtin_struts (_tmp9_, _tmp10_);
				_g_object_unref0 (workspace);
			}
		}
	}
	(list == NULL) ? NULL : (list = (_g_slist_free__g_free0_ (list), NULL));
}

static void
greeter_compositor_panel_window_unmake_exclusive (GreeterCompositorPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = greeter_compositor_panel_window_window_struts;
	_tmp1_ = self->priv->_window;
	if (g_hash_table_contains (_tmp0_, _tmp1_)) {
		GHashTable* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp2_ = greeter_compositor_panel_window_window_struts;
		_tmp3_ = self->priv->_window;
		g_hash_table_remove (_tmp2_, _tmp3_);
		greeter_compositor_panel_window_update_struts (self);
	}
}

GreeterCompositorWindowManager*
greeter_compositor_panel_window_get_wm (GreeterCompositorPanelWindow* self)
{
	GreeterCompositorWindowManager* result;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_panel_window_set_wm (GreeterCompositorPanelWindow* self,
                                        GreeterCompositorWindowManager* value)
{
	GreeterCompositorWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_panel_window_get_wm (self);
	if (old_value != value) {
		GreeterCompositorWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY]);
	}
}

MetaWindow*
greeter_compositor_panel_window_get_window (GreeterCompositorPanelWindow* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_panel_window_set_window (GreeterCompositorPanelWindow* self,
                                            MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_panel_window_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY]);
	}
}

gboolean
greeter_compositor_panel_window_get_hidden (GreeterCompositorPanelWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hidden;
	return result;
}

static void
greeter_compositor_panel_window_set_hidden (GreeterCompositorPanelWindow* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_panel_window_get_hidden (self);
	if (old_value != value) {
		self->priv->_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY]);
	}
}

static void
_greeter_compositor_panel_window_position_window_meta_window_size_changed (MetaWindow* _sender,
                                                                           gpointer self)
{
	greeter_compositor_panel_window_position_window ((GreeterCompositorPanelWindow*) self);
}

static void
_greeter_compositor_panel_window___lambda82_ (GreeterCompositorPanelWindow* self)
{
	GHashTable* _tmp0_;
	MetaWindow* _tmp1_;
	if (self->priv->idle_move_id != ((guint) 0)) {
		g_source_remove (self->priv->idle_move_id);
	}
	_tmp0_ = greeter_compositor_panel_window_window_struts;
	_tmp1_ = self->priv->_window;
	if (g_hash_table_remove (_tmp0_, _tmp1_)) {
		greeter_compositor_panel_window_update_struts (self);
	}
}

static void
__greeter_compositor_panel_window___lambda82__meta_window_unmanaging (MetaWindow* _sender,
                                                                      gpointer self)
{
	_greeter_compositor_panel_window___lambda82_ ((GreeterCompositorPanelWindow*) self);
}

static void
_greeter_compositor_panel_window___lambda83_ (GreeterCompositorPanelWindow* self)
{
	greeter_compositor_panel_window_update_anchor (self, self->anchor);
}

static void
__greeter_compositor_panel_window___lambda83__meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                     gpointer self)
{
	_greeter_compositor_panel_window___lambda83_ ((GreeterCompositorPanelWindow*) self);
}

static void
_greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                      gint object,
                                                                                      gpointer self)
{
	greeter_compositor_panel_window_update_strut ((GreeterCompositorPanelWindow*) self);
}

static void
_greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                        gint object,
                                                                                        gpointer self)
{
	greeter_compositor_panel_window_update_strut ((GreeterCompositorPanelWindow*) self);
}

static GObject *
greeter_compositor_panel_window_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorPanelWindow * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	GreeterCompositorWindowManager* _tmp3_;
	GreeterCompositorPanelClone* _tmp4_;
	MetaMonitorManager* monitor_manager = NULL;
	GreeterCompositorWindowManager* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaContext* _tmp7_;
	MetaBackend* _tmp8_;
	MetaMonitorManager* _tmp9_;
	MetaMonitorManager* _tmp10_;
	MetaMonitorManager* _tmp11_;
	MetaWorkspaceManager* workspace_manager = NULL;
	GreeterCompositorWindowManager* _tmp12_;
	MetaDisplay* _tmp13_;
	MetaWorkspaceManager* _tmp14_;
	MetaWorkspaceManager* _tmp15_;
	MetaWorkspaceManager* _tmp16_;
	MetaWorkspaceManager* _tmp17_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_panel_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow);
	_tmp0_ = self->priv->_window;
	g_signal_connect_object (_tmp0_, "size-changed", (GCallback) _greeter_compositor_panel_window_position_window_meta_window_size_changed, self, 0);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object (_tmp1_, "unmanaging", (GCallback) __greeter_compositor_panel_window___lambda82__meta_window_unmanaging, self, 0);
	_tmp2_ = self->priv->_window;
	meta_window_stick (_tmp2_);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = greeter_compositor_panel_clone_new (_tmp3_, self);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp4_;
	_tmp5_ = self->priv->_wm;
	_tmp6_ = meta_plugin_get_display ((MetaPlugin*) _tmp5_);
	_tmp7_ = meta_display_get_context (_tmp6_);
	_tmp8_ = meta_context_get_backend (_tmp7_);
	_tmp9_ = meta_backend_get_monitor_manager (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	monitor_manager = _tmp10_;
	_tmp11_ = monitor_manager;
	g_signal_connect_object (_tmp11_, "monitors-changed", (GCallback) __greeter_compositor_panel_window___lambda83__meta_monitor_manager_monitors_changed, self, 0);
	_tmp12_ = self->priv->_wm;
	_tmp13_ = meta_plugin_get_display ((MetaPlugin*) _tmp12_);
	_tmp14_ = meta_display_get_workspace_manager (_tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	workspace_manager = _tmp15_;
	_tmp16_ = workspace_manager;
	g_signal_connect_object (_tmp16_, "workspace-added", (GCallback) _greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_added, self, 0);
	_tmp17_ = workspace_manager;
	g_signal_connect_object (_tmp17_, "workspace-removed", (GCallback) _greeter_compositor_panel_window_update_strut_meta_workspace_manager_workspace_removed, self, 0);
	_g_object_unref0 (workspace_manager);
	_g_object_unref0 (monitor_manager);
	return obj;
}

static void
greeter_compositor_panel_window_class_init (GreeterCompositorPanelWindowClass * klass,
                                            gpointer klass_data)
{
	GHashTable* _tmp0_;
	greeter_compositor_panel_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorPanelWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_panel_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_panel_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_panel_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_panel_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY, greeter_compositor_panel_window_properties[GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY] = g_param_spec_boolean ("hidden", "hidden", "hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_free0_);
	greeter_compositor_panel_window_window_struts = _tmp0_;
}

static void
greeter_compositor_panel_window_instance_init (GreeterCompositorPanelWindow * self,
                                               gpointer klass)
{
	self->priv = greeter_compositor_panel_window_get_instance_private (self);
	self->priv->_hidden = FALSE;
	self->priv->idle_move_id = (guint) 0;
	self->priv->width = -1;
	self->priv->height = -1;
}

static void
greeter_compositor_panel_window_finalize (GObject * obj)
{
	GreeterCompositorPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->clone);
	G_OBJECT_CLASS (greeter_compositor_panel_window_parent_class)->finalize (obj);
}

static GType
greeter_compositor_panel_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorPanelWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_panel_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorPanelWindow), 0, (GInstanceInitFunc) greeter_compositor_panel_window_instance_init, NULL };
	GType greeter_compositor_panel_window_type_id;
	greeter_compositor_panel_window_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorPanelWindow", &g_define_type_info, 0);
	GreeterCompositorPanelWindow_private_offset = g_type_add_instance_private (greeter_compositor_panel_window_type_id, sizeof (GreeterCompositorPanelWindowPrivate));
	return greeter_compositor_panel_window_type_id;
}

GType
greeter_compositor_panel_window_get_type (void)
{
	static volatile gsize greeter_compositor_panel_window_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_panel_window_type_id__once)) {
		GType greeter_compositor_panel_window_type_id;
		greeter_compositor_panel_window_type_id = greeter_compositor_panel_window_get_type_once ();
		g_once_init_leave (&greeter_compositor_panel_window_type_id__once, greeter_compositor_panel_window_type_id);
	}
	return greeter_compositor_panel_window_type_id__once;
}

static void
_vala_greeter_compositor_panel_window_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	GreeterCompositorPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow);
	switch (property_id) {
		case GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY:
		g_value_set_object (value, greeter_compositor_panel_window_get_wm (self));
		break;
		case GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY:
		g_value_set_object (value, greeter_compositor_panel_window_get_window (self));
		break;
		case GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY:
		g_value_set_boolean (value, greeter_compositor_panel_window_get_hidden (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_panel_window_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	GreeterCompositorPanelWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_PANEL_WINDOW, GreeterCompositorPanelWindow);
	switch (property_id) {
		case GREETER_COMPOSITOR_PANEL_WINDOW_WM_PROPERTY:
		greeter_compositor_panel_window_set_wm (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_PANEL_WINDOW_WINDOW_PROPERTY:
		greeter_compositor_panel_window_set_window (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_PANEL_WINDOW_HIDDEN_PROPERTY:
		greeter_compositor_panel_window_set_hidden (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

