
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kcountryflagemojiiconengine_wrapper.h"

// Wrappers providing overrides
#include "kcountryflagemojiiconengine_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <qdatastream.h>
#include <qfont.h>
#include <qicon.h>
#include <qiconengine.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qsize.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCountryFlagEmojiIconEngine_Type = nullptr;
static PyTypeObject *Sbk_KCountryFlagEmojiIconEngine_TypeF(void)
{
    return _Sbk_KCountryFlagEmojiIconEngine_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KCountryFlagEmojiIconEngineWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KCountryFlagEmojiIconEngineWrapper::KCountryFlagEmojiIconEngineWrapper(const ::QString & regionOrCountry) : KCountryFlagEmojiIconEngine(regionOrCountry)
{
}

::QSize KCountryFlagEmojiIconEngineWrapper::actualSize(const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "actualSize";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::actualSize(size, mode, state);
    }
    return sbk_o_actualSize("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, size, mode, state);
}

::QSize KCountryFlagEmojiIconEngineWrapper::sbk_o_actualSize(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QSize >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KCountryFlagEmojiIconEngineWrapper::addFile(const ::QString & fileName, const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "addFile";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::addFile(fileName, size, mode, state);
    }
    sbk_o_addFile("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, fileName, size, mode, state);
}

void KCountryFlagEmojiIconEngineWrapper::sbk_o_addFile(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & fileName, const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &fileName),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &fileName),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KCountryFlagEmojiIconEngineWrapper::addPixmap(const ::QPixmap & pixmap, ::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "addPixmap";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::addPixmap(pixmap, mode, state);
    }
    sbk_o_addPixmap("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, pixmap, mode, state);
}

void KCountryFlagEmojiIconEngineWrapper::sbk_o_addPixmap(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QPixmap & pixmap, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &pixmap),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &pixmap),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QList<QSize> KCountryFlagEmojiIconEngineWrapper::availableSizes(::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "availableSizes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::availableSizes(mode, state);
    }
    return sbk_o_availableSizes("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, mode, state);
}

::QList<QSize> KCountryFlagEmojiIconEngineWrapper::sbk_o_availableSizes(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkKGuiAddonsTypeConverters[SBK_KGuiAddons_QList_QSize_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QSize> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QIconEngine * KCountryFlagEmojiIconEngineWrapper::clone() const
{
    static const char *funcName = "clone";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::clone();
    }
    return sbk_o_clone("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride);
}

::QIconEngine * KCountryFlagEmojiIconEngineWrapper::sbk_o_clone(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIconEngine_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QIconEngine >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QIconEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString KCountryFlagEmojiIconEngineWrapper::iconName()
{
    static const char *funcName = "iconName";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::iconName();
    }
    return sbk_o_iconName("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride);
}

::QString KCountryFlagEmojiIconEngineWrapper::sbk_o_iconName(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KCountryFlagEmojiIconEngineWrapper::isNull()
{
    static const char *funcName = "isNull";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::isNull();
    }
    return sbk_o_isNull("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride);
}

bool KCountryFlagEmojiIconEngineWrapper::sbk_o_isNull(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString KCountryFlagEmojiIconEngineWrapper::key() const
{
    static const char *funcName = "key";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::key();
    }
    return KCountryFlagEmojiIconEngineWrapper::sbk_o_iconName("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride);
}

void KCountryFlagEmojiIconEngineWrapper::paint(::QPainter * painter, const ::QRect & rect, ::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "paint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::paint(painter, rect, mode, state);
    }
    sbk_o_paint("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, painter, rect, mode, state);
}

void KCountryFlagEmojiIconEngineWrapper::sbk_o_paint(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QPainter * painter, const ::QRect & rect, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), painter),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &rect),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), painter),
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &rect),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QPixmap KCountryFlagEmojiIconEngineWrapper::pixmap(const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    static const char *funcName = "pixmap";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::pixmap(size, mode, state);
    }
    return sbk_o_pixmap("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, size, mode, state);
}

::QPixmap KCountryFlagEmojiIconEngineWrapper::sbk_o_pixmap(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QPixmap >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPixmap cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KCountryFlagEmojiIconEngineWrapper::read(::QDataStream & in)
{
    static const char *funcName = "read";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::read(in);
    }
    return sbk_o_read("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, in);
}

bool KCountryFlagEmojiIconEngineWrapper::sbk_o_read(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDataStream & in)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDataStream_IDX]), &in)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDataStream_IDX]), &in)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPixmap KCountryFlagEmojiIconEngineWrapper::scaledPixmap(const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state, qreal scale)
{
    static const char *funcName = "scaledPixmap";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCountryFlagEmojiIconEngine::scaledPixmap(size, mode, state, scale);
    }
    return sbk_o_scaledPixmap("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, size, mode, state, scale);
}

::QPixmap KCountryFlagEmojiIconEngineWrapper::sbk_o_scaledPixmap(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QSize & size, ::QIcon::Mode mode, ::QIcon::State state, qreal scale)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &scale)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNd)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &size),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, &mode),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, &state),
        scale
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QPixmap >()), Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPixmap cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KCountryFlagEmojiIconEngineWrapper::write(::QDataStream & out) const
{
    static const char *funcName = "write";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCountryFlagEmojiIconEngine_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIconEngine::write(out);
    }
    return sbk_o_write("KCountryFlagEmojiIconEngine", funcName, gil, pyOverride, out);
}

bool KCountryFlagEmojiIconEngineWrapper::sbk_o_write(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QDataStream & out)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDataStream_IDX]), &out)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDataStream_IDX]), &out)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

KCountryFlagEmojiIconEngineWrapper::~KCountryFlagEmojiIconEngineWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KCountryFlagEmojiIconEngine_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCountryFlagEmojiIconEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCountryFlagEmojiIconEngine >()))
        return -1;

    KCountryFlagEmojiIconEngineWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KCountryFlagEmojiIconEngine", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCountryFlagEmojiIconEngine::KCountryFlagEmojiIconEngine(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // KCountryFlagEmojiIconEngine(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KCountryFlagEmojiIconEngine(QString)
            cptr = new KCountryFlagEmojiIconEngineWrapper(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KCountryFlagEmojiIconEngine >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_clone(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clone()const
        QIconEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCountryFlagEmojiIconEngine *>(cppSelf)->::KCountryFlagEmojiIconEngine::clone()
            : const_cast<const ::KCountryFlagEmojiIconEngine *>(cppSelf)->clone();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIconEngine_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KCountryFlagEmojiIconEngine::isNull()
            : cppSelf->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_key(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // key()const
        QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCountryFlagEmojiIconEngine *>(cppSelf)->::KCountryFlagEmojiIconEngine::key()
            : const_cast<const ::KCountryFlagEmojiIconEngine *>(cppSelf)->key();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_paint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "paint", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QIconEngine::paint(QPainter*,QRect,QIcon::Mode,QIcon::State)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, (pyArgs[3])))) {
        overloadId = 0; // paint(QPainter*,QRect,QIcon::Mode,QIcon::State)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "paint", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QIcon::Mode cppArg2{QIcon::Normal};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QIcon::State cppArg3{QIcon::On};
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paint(QPainter*,QRect,QIcon::Mode,QIcon::State)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCountryFlagEmojiIconEngine::paint(cppArg0, *cppArg1, cppArg2, cppArg3)
                : cppSelf->paint(cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_pixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "pixmap", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QIconEngine::pixmap(QSize,QIcon::Mode,QIcon::State)->QPixmap
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, (pyArgs[2])))) {
        overloadId = 0; // pixmap(QSize,QIcon::Mode,QIcon::State)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "pixmap", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QIcon::Mode cppArg1{QIcon::Normal};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QIcon::State cppArg2{QIcon::On};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pixmap(QSize,QIcon::Mode,QIcon::State)
            QPixmap cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCountryFlagEmojiIconEngine::pixmap(*cppArg0, cppArg1, cppArg2)
                : cppSelf->pixmap(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_scaledPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "scaledPixmap", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QIconEngine::scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)->QPixmap
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_Mode_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_State_IDX])))->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
        overloadId = 0; // scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "scaledPixmap", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QIcon::Mode cppArg1{QIcon::Normal};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QIcon::State cppArg2{QIcon::On};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // scaledPixmap(QSize,QIcon::Mode,QIcon::State,qreal)
            QPixmap cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCountryFlagEmojiIconEngine::scaledPixmap(*cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->scaledPixmap(*cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCountryFlagEmojiIconEngineFunc_setGlobalDefaultFont(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KCountryFlagEmojiIconEngine::setGlobalDefaultFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArg)))) {
        overloadId = 0; // setGlobalDefaultFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGlobalDefaultFont", errInfo, SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setGlobalDefaultFont(QFont)
            ::KCountryFlagEmojiIconEngine::setGlobalDefaultFont(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KCountryFlagEmojiIconEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCountryFlagEmojiIconEngine_methods[] = {
    {"clone", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_clone), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_isNull), METH_NOARGS, nullptr},
    {"key", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_key), METH_NOARGS, nullptr},
    {"paint", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_paint), METH_VARARGS, nullptr},
    {"pixmap", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_pixmap), METH_VARARGS, nullptr},
    {"scaledPixmap", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_scaledPixmap), METH_VARARGS, nullptr},
    {"setGlobalDefaultFont", reinterpret_cast<PyCFunction>(Sbk_KCountryFlagEmojiIconEngineFunc_setGlobalDefaultFont), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KCountryFlagEmojiIconEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KCountryFlagEmojiIconEngine *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KCountryFlagEmojiIconEngineWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KCountryFlagEmojiIconEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCountryFlagEmojiIconEngine_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCountryFlagEmojiIconEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KCountryFlagEmojiIconEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCountryFlagEmojiIconEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCountryFlagEmojiIconEngine_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCountryFlagEmojiIconEngine_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCountryFlagEmojiIconEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCountryFlagEmojiIconEngine_spec = {
    "1:KGuiAddons.KCountryFlagEmojiIconEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCountryFlagEmojiIconEngine_slots
};

} //extern "C"

static void *Sbk_KCountryFlagEmojiIconEngine_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QIconEngine >())
        return dynamic_cast< ::KCountryFlagEmojiIconEngine *>(reinterpret_cast< ::QIconEngine *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCountryFlagEmojiIconEngine_PythonToCpp_KCountryFlagEmojiIconEngine_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCountryFlagEmojiIconEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCountryFlagEmojiIconEngine_PythonToCpp_KCountryFlagEmojiIconEngine_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCountryFlagEmojiIconEngine_TypeF()))
        return KCountryFlagEmojiIconEngine_PythonToCpp_KCountryFlagEmojiIconEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCountryFlagEmojiIconEngine_PTR_CppToPython_KCountryFlagEmojiIconEngine(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KCountryFlagEmojiIconEngine_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KCountryFlagEmojiIconEngine *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KCountryFlagEmojiIconEngine_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCountryFlagEmojiIconEngine_SignatureStrings[] = {
    "KGuiAddons.KCountryFlagEmojiIconEngine(self,regionOrCountry:QString)",
    "KGuiAddons.KCountryFlagEmojiIconEngine.clone(self)->PySide6.QtGui.QIconEngine",
    "KGuiAddons.KCountryFlagEmojiIconEngine.isNull(self)->bool",
    "KGuiAddons.KCountryFlagEmojiIconEngine.key(self)->QString",
    "KGuiAddons.KCountryFlagEmojiIconEngine.paint(self,painter:PySide6.QtGui.QPainter,rect:PySide6.QtCore.QRect,mode:PySide6.QtGui.QIcon.Mode,state:PySide6.QtGui.QIcon.State)",
    "KGuiAddons.KCountryFlagEmojiIconEngine.pixmap(self,size:PySide6.QtCore.QSize,mode:PySide6.QtGui.QIcon.Mode,state:PySide6.QtGui.QIcon.State)->PySide6.QtGui.QPixmap",
    "KGuiAddons.KCountryFlagEmojiIconEngine.scaledPixmap(self,size:PySide6.QtCore.QSize,mode:PySide6.QtGui.QIcon.Mode,state:PySide6.QtGui.QIcon.State,scale:qreal)->PySide6.QtGui.QPixmap",
    "KGuiAddons.KCountryFlagEmojiIconEngine.setGlobalDefaultFont(font:typing.Union[PySide6.QtGui.QFont, QString, QStringList])",
    nullptr}; // Sentinel
#else
static constexpr size_t KCountryFlagEmojiIconEngine_SignatureByteSize = 271;
static constexpr uint8_t KCountryFlagEmojiIconEngine_SignatureBytes[271] = {
    0x78, 0xda, 0xb5, 0x53, 0x4d, 0x4f, 0xc3, 0x30, 0x0c, 0xbd, 0xef, 0x57, 0x70, 0xa4, 0x52, 0xc9,
    0x91, 0x43, 0x0f, 0x48, 0x68, 0x6c, 0x13, 0x2a, 0x1f, 0x2d, 0x15, 0x27, 0xc4, 0x21, 0x6b, 0xdd,
    0xca, 0xe0, 0xc5, 0x25, 0x71, 0x25, 0xca, 0xaf, 0x27, 0x6b, 0x3b, 0x40, 0xdb, 0x0e, 0x91, 0x26,
    0x2e, 0x51, 0xe4, 0xe7, 0xf7, 0xfc, 0xec, 0x38, 0xe9, 0xaa, 0xc3, 0xeb, 0xaa, 0x62, 0xe3, 0x54,
    0x3a, 0xe7, 0xce, 0x88, 0xed, 0x97, 0xa4, 0x9b, 0xc5, 0x86, 0xdf, 0xf0, 0xb6, 0x64, 0xb3, 0x30,
    0x0d, 0x1a, 0x38, 0x77, 0x40, 0x75, 0x6c, 0xa1, 0x41, 0x36, 0x8f, 0x76, 0xca, 0x4b, 0xf2, 0x42,
    0x2c, 0x9a, 0x26, 0x9a, 0xa5, 0x41, 0x22, 0xaa, 0x24, 0x9e, 0xa4, 0xa2, 0x8b, 0xab, 0xac, 0x2f,
    0xb0, 0x82, 0x4b, 0x95, 0x8b, 0x27, 0xab, 0xfc, 0x37, 0x2d, 0x54, 0x0d, 0xdd, 0x43, 0x47, 0xb4,
    0x93, 0x5b, 0x33, 0x53, 0x28, 0xf3, 0x1d, 0xfa, 0x1d, 0x6d, 0x6a, 0x21, 0x94, 0xd9, 0x6a, 0x34,
    0x32, 0x0e, 0x63, 0xb8, 0x82, 0x4d, 0xf6, 0xfa, 0xc8, 0xc6, 0xb0, 0x9f, 0x55, 0x29, 0x7f, 0xb0,
    0x39, 0x5b, 0x50, 0xf9, 0x93, 0x0f, 0xc6, 0x1b, 0xae, 0x20, 0x39, 0xd2, 0xbd, 0xba, 0xf7, 0x40,
    0xec, 0x44, 0xcb, 0x71, 0xb8, 0xd8, 0x22, 0xc1, 0xb3, 0x6e, 0xf1, 0x73, 0xa3, 0xdb, 0xd1, 0xaa,
    0xc3, 0x2f, 0x38, 0xf0, 0x52, 0xf8, 0xe0, 0x89, 0x5e, 0x0e, 0x1e, 0x31, 0x1b, 0x8a, 0x86, 0x5a,
    0x74, 0xa5, 0x26, 0xa8, 0xb2, 0xff, 0x37, 0x1a, 0x0f, 0x95, 0x92, 0x0f, 0x0b, 0x9a, 0x4e, 0x36,
    0x0d, 0xb2, 0x22, 0x5e, 0x6b, 0xba, 0x81, 0x5a, 0x77, 0x24, 0x4b, 0xf6, 0x0b, 0x51, 0xfb, 0x23,
    0x91, 0xbe, 0xf5, 0x9b, 0xa4, 0x9e, 0x8d, 0xff, 0x23, 0x2f, 0x7b, 0x35, 0xb6, 0x59, 0xf1, 0xd9,
    0xb4, 0x6c, 0x3f, 0x97, 0x3b, 0x74, 0xf2, 0x1a, 0xcd, 0xbe, 0x01, 0xae, 0xf3, 0x45, 0xbe
};
#endif

PyTypeObject *init_KCountryFlagEmojiIconEngine(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX].type;

    Shiboken::AutoDecRef Sbk_KCountryFlagEmojiIconEngine_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIconEngine_IDX]))));

    _Sbk_KCountryFlagEmojiIconEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCountryFlagEmojiIconEngine",
        "KCountryFlagEmojiIconEngine*",
        &Sbk_KCountryFlagEmojiIconEngine_spec,
        &Shiboken::callCppDestructor< KCountryFlagEmojiIconEngine >,
        Sbk_KCountryFlagEmojiIconEngine_Type_bases.object(),
        0);
    auto *pyType = Sbk_KCountryFlagEmojiIconEngine_TypeF(); // references _Sbk_KCountryFlagEmojiIconEngine_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCountryFlagEmojiIconEngine_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCountryFlagEmojiIconEngine_SignatureBytes, KCountryFlagEmojiIconEngine_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCountryFlagEmojiIconEngine_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KCountryFlagEmojiIconEngine_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCountryFlagEmojiIconEngine_PythonToCpp_KCountryFlagEmojiIconEngine_PTR,
        is_KCountryFlagEmojiIconEngine_PythonToCpp_KCountryFlagEmojiIconEngine_PTR_Convertible,
        KCountryFlagEmojiIconEngine_PTR_CppToPython_KCountryFlagEmojiIconEngine);

    Shiboken::Conversions::registerConverterName(converter, "KCountryFlagEmojiIconEngine");
    Shiboken::Conversions::registerConverterName(converter, "KCountryFlagEmojiIconEngine*");
    Shiboken::Conversions::registerConverterName(converter, "KCountryFlagEmojiIconEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCountryFlagEmojiIconEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KCountryFlagEmojiIconEngineWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KCountryFlagEmojiIconEngine_TypeF(), &Sbk_KCountryFlagEmojiIconEngine_typeDiscovery);

    qRegisterMetaType< ::KCountryFlagEmojiIconEngine *>();

    return pyType;
}
