
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kpluginfactory_wrapper.h"

// Wrappers providing overrides
#include "ksignalhandler_wrapper.h"

// Argument includes
#include <kpluginmetadata.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KPluginFactory_Type = nullptr;
static PyTypeObject *Sbk_KPluginFactory_TypeF(void)
{
    return _Sbk_KPluginFactory_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KPluginFactoryWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KPluginFactoryWrapper::KPluginFactoryWrapper()
{
}

void KPluginFactoryWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KPluginFactory", funcName, gil, pyOverride, event);
}

void KPluginFactoryWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KPluginFactory", funcName, gil, pyOverride, signal);
}

void KPluginFactoryWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KPluginFactory", funcName, gil, pyOverride, event);
}

void KPluginFactoryWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KPluginFactory", funcName, gil, pyOverride, signal);
}

bool KPluginFactoryWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KPluginFactory", funcName, gil, pyOverride, event);
}

bool KPluginFactoryWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KPluginFactory", funcName, gil, pyOverride, watched, event);
}

void KPluginFactoryWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KPluginFactory_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KPluginFactory", funcName, gil, pyOverride, event);
}

const QMetaObject *KPluginFactoryWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KPluginFactory::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KPluginFactoryWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KPluginFactory::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KPluginFactoryWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KPluginFactoryWrapper *>(this));
    }
    return KPluginFactory::qt_metacast(_clname);
}

KPluginFactoryWrapper::~KPluginFactoryWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KPluginFactory_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KPluginFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KPluginFactory >()))
        return -1;

    KPluginFactoryWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // KPluginFactory()
        void *addr = PySide::nextQObjectMemoryAddr();
        if (addr != nullptr) {
            cptr = new (addr) KPluginFactoryWrapper();
            PySide::setNextQObjectMemoryAddr(nullptr);
        } else {
            cptr = new KPluginFactoryWrapper();
        }

    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KPluginFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KPluginFactoryFunc_metaData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // metaData()const
        KPluginMetaData* cppResult = new KPluginMetaData(const_cast<const ::KPluginFactory *>(cppSelf)->metaData());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KPluginFactoryFunc_setMetaData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KPluginFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KPluginFactory::setMetaData(KPluginMetaData)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginMetaData_IDX]), (pyArg)))) {
        overloadId = 0; // setMetaData(KPluginMetaData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setMetaData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KPluginMetaData *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMetaData(KPluginMetaData)
            cppSelf->setMetaData(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KPluginFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KPluginFactory_EnumFlagInfo[] = {
    "ResultErrorReason:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KPluginFactory_methods[] = {
    {"metaData", reinterpret_cast<PyCFunction>(Sbk_KPluginFactoryFunc_metaData), METH_NOARGS, nullptr},
    {"setMetaData", reinterpret_cast<PyCFunction>(Sbk_KPluginFactoryFunc_setMetaData), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KPluginFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KPluginFactory *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KPluginFactoryWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KPluginFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KPluginFactory_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KPluginFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KPluginFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KPluginFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KPluginFactory_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KPluginFactory_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KPluginFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KPluginFactory_spec = {
    "1:KCoreAddons.KPluginFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KPluginFactory_slots
};

} //extern "C"

static void *Sbk_KPluginFactory_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KPluginFactory *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KPluginFactory_ResultErrorReason(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KPluginFactory::ResultErrorReason>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KPluginFactory::ResultErrorReason *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KPluginFactory_ResultErrorReason_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_ResultErrorReason_IDX])))
        return Enum_PythonToCpp_KPluginFactory_ResultErrorReason;
    return {};
}

static PyObject *KPluginFactory_ResultErrorReason_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KPluginFactory::ResultErrorReason>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KPluginFactory::ResultErrorReason *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KPluginFactory_PythonToCpp_KPluginFactory_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KPluginFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KPluginFactory_PythonToCpp_KPluginFactory_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KPluginFactory_TypeF()))
        return KPluginFactory_PythonToCpp_KPluginFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KPluginFactory_PTR_CppToPython_KPluginFactory(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KPluginFactory *>(const_cast<void *>(cppIn)), Sbk_KPluginFactory_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KPluginFactory_SignatureStrings[] = {
    "KCoreAddons.KPluginFactory(self)",
    "KCoreAddons.KPluginFactory.metaData(self)->KCoreAddons.KPluginMetaData",
    "KCoreAddons.KPluginFactory.setMetaData(self,metaData:KCoreAddons.KPluginMetaData)",
    nullptr}; // Sentinel
#else
static constexpr size_t KPluginFactory_SignatureByteSize = 79;
static constexpr uint8_t KPluginFactory_SignatureBytes[79] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0xc8, 0x29, 0x4d, 0xcf, 0xcc, 0x73, 0x4b, 0x4c, 0x2e, 0xc9, 0x2f, 0xaa, 0xd4, 0x28, 0x4e, 0xcd,
    0x49, 0xd3, 0xe4, 0xf2, 0xc6, 0xa9, 0x40, 0x2f, 0x37, 0xb5, 0x24, 0xd1, 0x25, 0xb1, 0x24, 0x11,
    0xa2, 0x52, 0xd7, 0x0e, 0x8b, 0x52, 0x5f, 0xa8, 0x12, 0x7c, 0xc6, 0x14, 0xa7, 0x96, 0xf8, 0x22,
    0x9b, 0xa4, 0x03, 0x33, 0xd7, 0x0a, 0x8f, 0x81, 0x9a, 0x5c, 0x00, 0xd3, 0x26, 0x43, 0xbf
};
#endif

PyTypeObject *init_KPluginFactory(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX].type;

    Shiboken::AutoDecRef Sbk_KPluginFactory_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KPluginFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KPluginFactory",
        "KPluginFactory*",
        &Sbk_KPluginFactory_spec,
        &Shiboken::callCppDestructor< KPluginFactory >,
        Sbk_KPluginFactory_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KPluginFactory_Type; // references _Sbk_KPluginFactory_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KPluginFactory_SignatureStrings);
#else
    InitSignatureBytes(pyType, KPluginFactory_SignatureBytes, KPluginFactory_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KPluginFactory_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KPluginFactory_PythonToCpp_KPluginFactory_PTR,
        is_KPluginFactory_PythonToCpp_KPluginFactory_PTR_Convertible,
        KPluginFactory_PTR_CppToPython_KPluginFactory);

    Shiboken::Conversions::registerConverterName(converter, "KPluginFactory");
    Shiboken::Conversions::registerConverterName(converter, "KPluginFactory*");
    Shiboken::Conversions::registerConverterName(converter, "KPluginFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KPluginFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KPluginFactoryWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KPluginFactory_TypeF(), &Sbk_KPluginFactory_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KPluginFactory_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ResultErrorReason'.
    const char *ResultErrorReason_Initializer[] = {
        "NO_PLUGIN_ERROR",
        "INVALID_PLUGIN",
        "INVALID_FACTORY",
        "INVALID_KPLUGINFACTORY_INSTANTIATION",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ResultErrorReason_InitializerValues[] = {
        uint8_t(KPluginFactory::ResultErrorReason::NO_PLUGIN_ERROR),                     //  0x00  0
        uint8_t(KPluginFactory::ResultErrorReason::INVALID_PLUGIN),                      //  0x01  1
        uint8_t(KPluginFactory::ResultErrorReason::INVALID_FACTORY),                     //  0x02  2
        uint8_t(KPluginFactory::ResultErrorReason::INVALID_KPLUGINFACTORY_INSTANTIATION) //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KPluginFactory_TypeF(),
        "1:KCoreAddons.KPluginFactory.ResultErrorReason",
        ResultErrorReason_Initializer, ResultErrorReason_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KPluginFactory_ResultErrorReason_IDX].type = EType;
    // Register converter for enum 'KPluginFactory::ResultErrorReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KPluginFactory_ResultErrorReason_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KPluginFactory_ResultErrorReason,
            is_Enum_PythonToCpp_KPluginFactory_ResultErrorReason_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KPluginFactory::ResultErrorReason");
        Shiboken::Conversions::registerConverterAlias(converter, "ResultErrorReason");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ResultErrorReason' enum.

    qRegisterMetaType< ::KPluginFactory::ResultErrorReason >("KPluginFactory::ResultErrorReason");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KPluginFactory::staticMetaObject, sizeof(KPluginFactoryWrapper));

    return pyType;
}
