{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node applying a blur effect to its single child.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.BlurNode
    ( 

-- * Exported types
    BlurNode(..)                            ,
    IsBlurNode                              ,
    toBlurNode                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.BlurNode#g:method:getChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getRadius]("GI.Gsk.Objects.BlurNode#g:method:getRadius").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveBlurNodeMethod                   ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    BlurNodeGetChildMethodInfo              ,
#endif
    blurNodeGetChild                        ,


-- ** getRadius #method:getRadius#

#if defined(ENABLE_OVERLOADING)
    BlurNodeGetRadiusMethodInfo             ,
#endif
    blurNodeGetRadius                       ,


-- ** new #method:new#

    blurNodeNew                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype BlurNode = BlurNode (SP.ManagedPtr BlurNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype BlurNode where
    toManagedPtr (BlurNode p) = p

foreign import ccall "gsk_blur_node_get_type"
    c_gsk_blur_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject BlurNode where
    glibType = c_gsk_blur_node_get_type

-- | Type class for types which can be safely cast to t'BlurNode', for instance with `toBlurNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf BlurNode o) => IsBlurNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf BlurNode o) => IsBlurNode o

instance O.HasParentTypes BlurNode
type instance O.ParentTypes BlurNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'BlurNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBlurNode :: (MIO.MonadIO m, IsBlurNode o) => o -> m BlurNode
toBlurNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo BlurNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveBlurNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBlurNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveBlurNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveBlurNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveBlurNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveBlurNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveBlurNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveBlurNodeMethod "getChild" o = BlurNodeGetChildMethodInfo
    ResolveBlurNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveBlurNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveBlurNodeMethod "getRadius" o = BlurNodeGetRadiusMethodInfo
    ResolveBlurNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBlurNodeMethod t BlurNode, O.OverloadedMethod info BlurNode p) => OL.IsLabel t (BlurNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBlurNodeMethod t BlurNode, O.OverloadedMethod info BlurNode p, R.HasField t BlurNode p) => R.HasField t BlurNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBlurNodeMethod t BlurNode, O.OverloadedMethodInfo info BlurNode) => OL.IsLabel t (O.MethodProxy info BlurNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr BlurNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method BlurNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child node to blur"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "radius"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the blur radius. Must be positive"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "BlurNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_blur_node_new" gsk_blur_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    CFloat ->                               -- radius : TBasicType TFloat
    IO (Ptr BlurNode)

-- | Creates a render node that blurs the child.
blurNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: the child node to blur
    -> Float
    -- ^ /@radius@/: the blur radius. Must be positive
    -> m BlurNode
    -- ^ __Returns:__ a new @GskRenderNode@
blurNodeNew child radius = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    let radius' = realToFrac radius
    result <- gsk_blur_node_new child' radius'
    checkUnexpectedReturnNULL "blurNodeNew" result
    result' <- (wrapPtr BlurNode) result
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method BlurNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "BlurNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a blur `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_blur_node_get_child" gsk_blur_node_get_child :: 
    Ptr BlurNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "BlurNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the child @GskRenderNode@ of the blur /@node@/.
blurNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsBlurNode a) =>
    a
    -- ^ /@node@/: a blur @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the blurred child node
blurNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_blur_node_get_child node'
    checkUnexpectedReturnNULL "blurNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data BlurNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsBlurNode a) => O.OverloadedMethod BlurNodeGetChildMethodInfo a signature where
    overloadedMethod = blurNodeGetChild

instance O.OverloadedMethodInfo BlurNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.BlurNode.blurNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-BlurNode.html#v:blurNodeGetChild"
        })


#endif

-- method BlurNode::get_radius
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "BlurNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a blur `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_blur_node_get_radius" gsk_blur_node_get_radius :: 
    Ptr BlurNode ->                         -- node : TInterface (Name {namespace = "Gsk", name = "BlurNode"})
    IO CFloat

-- | Retrieves the blur radius of the /@node@/.
blurNodeGetRadius ::
    (B.CallStack.HasCallStack, MonadIO m, IsBlurNode a) =>
    a
    -- ^ /@node@/: a blur @GskRenderNode@
    -> m Float
    -- ^ __Returns:__ the blur radius
blurNodeGetRadius node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_blur_node_get_radius node'
    let result' = realToFrac result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data BlurNodeGetRadiusMethodInfo
instance (signature ~ (m Float), MonadIO m, IsBlurNode a) => O.OverloadedMethod BlurNodeGetRadiusMethodInfo a signature where
    overloadedMethod = blurNodeGetRadius

instance O.OverloadedMethodInfo BlurNodeGetRadiusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.BlurNode.blurNodeGetRadius",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-BlurNode.html#v:blurNodeGetRadius"
        })


#endif


