/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/***********************************************************************************/
/* This file is automatically generated using bindtool and can be manually edited  */
/* The following lines can be configured to regenerate this file during cmake      */
/* If manual edits are made, the following tags should be modified accordingly.    */
/* BINDTOOL_GEN_AUTOMATIC(1)                                                       */
/* BINDTOOL_USE_PYGCCXML(0)                                                        */
/* BINDTOOL_HEADER_FILE(sink.h)                                        */
/* BINDTOOL_HEADER_FILE_HASH(d4331eb8a19b7a2aa4ed0100039f7a0e)                     */
/***********************************************************************************/

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <osmosdr/sink.h>
// pydoc.h is automatically generated in the build directory
#include <sink_pydoc.h>

void bind_sink(py::module& m)
{

    using sink    = ::osmosdr::sink;


    py::class_<sink, gr::hier_block2,
        std::shared_ptr<sink>>(m, "sink", D(sink))

        .def(py::init(&sink::make),
           py::arg("args") = "",
           D(sink,make)
        )
        




        .def("get_num_channels",&sink::get_num_channels,
            D(sink,get_num_channels)
        )


        .def("get_sample_rates",&sink::get_sample_rates,
            D(sink,get_sample_rates)
        )


        .def("set_sample_rate",&sink::set_sample_rate,
            py::arg("rate"),
            D(sink,set_sample_rate)
        )


        .def("get_sample_rate",&sink::get_sample_rate,
            D(sink,get_sample_rate)
        )


        .def("get_freq_range",&sink::get_freq_range,
            py::arg("chan") = 0,
            D(sink,get_freq_range)
        )


        .def("set_center_freq",&sink::set_center_freq,
            py::arg("freq"),
            py::arg("chan") = 0,
            D(sink,set_center_freq)
        )


        .def("get_center_freq",&sink::get_center_freq,
            py::arg("chan") = 0,
            D(sink,get_center_freq)
        )


        .def("set_freq_corr",&sink::set_freq_corr,
            py::arg("ppm"),
            py::arg("chan") = 0,
            D(sink,set_freq_corr)
        )


        .def("get_freq_corr",&sink::get_freq_corr,
            py::arg("chan") = 0,
            D(sink,get_freq_corr)
        )


        .def("get_gain_names",&sink::get_gain_names,
            py::arg("chan") = 0,
            D(sink,get_gain_names)
        )


        .def("get_gain_range",(osmosdr::gain_range_t (sink::*)(size_t))&sink::get_gain_range,
            py::arg("chan") = 0,
            D(sink,get_gain_range,0)
        )


        .def("get_gain_range",(osmosdr::gain_range_t (sink::*)(std::string const &, size_t))&sink::get_gain_range,
            py::arg("name"),
            py::arg("chan") = 0,
            D(sink,get_gain_range,1)
        )


        .def("set_gain_mode",&sink::set_gain_mode,
            py::arg("automatic"),
            py::arg("chan") = 0,
            D(sink,set_gain_mode)
        )


        .def("get_gain_mode",&sink::get_gain_mode,
            py::arg("chan") = 0,
            D(sink,get_gain_mode)
        )


        .def("set_gain",(double (sink::*)(double, size_t))&sink::set_gain,
            py::arg("gain"),
            py::arg("chan") = 0,
            D(sink,set_gain,0)
        )


        .def("set_gain",(double (sink::*)(double, std::string const &, size_t))&sink::set_gain,
            py::arg("gain"),
            py::arg("name"),
            py::arg("chan") = 0,
            D(sink,set_gain,1)
        )


        .def("get_gain",(double (sink::*)(size_t))&sink::get_gain,
            py::arg("chan") = 0,
            D(sink,get_gain,0)
        )


        .def("get_gain",(double (sink::*)(std::string const &, size_t))&sink::get_gain,
            py::arg("name"),
            py::arg("chan") = 0,
            D(sink,get_gain,1)
        )


        .def("set_if_gain",&sink::set_if_gain,
            py::arg("gain"),
            py::arg("chan") = 0,
            D(sink,set_if_gain)
        )


        .def("set_bb_gain",&sink::set_bb_gain,
            py::arg("gain"),
            py::arg("chan") = 0,
            D(sink,set_bb_gain)
        )


        .def("get_antennas",&sink::get_antennas,
            py::arg("chan") = 0,
            D(sink,get_antennas)
        )


        .def("set_antenna",&sink::set_antenna,
            py::arg("antenna"),
            py::arg("chan") = 0,
            D(sink,set_antenna)
        )


        .def("get_antenna",&sink::get_antenna,
            py::arg("chan") = 0,
            D(sink,get_antenna)
        )


        .def("set_dc_offset",&sink::set_dc_offset,
            py::arg("offset"),
            py::arg("chan") = 0,
            D(sink,set_dc_offset)
        )


        .def("set_iq_balance",&sink::set_iq_balance,
            py::arg("balance"),
            py::arg("chan") = 0,
            D(sink,set_iq_balance)
        )


        .def("set_bandwidth",&sink::set_bandwidth,
            py::arg("bandwidth"),
            py::arg("chan") = 0,
            D(sink,set_bandwidth)
        )


        .def("get_bandwidth",&sink::get_bandwidth,
            py::arg("chan") = 0,
            D(sink,get_bandwidth)
        )


        .def("get_bandwidth_range",&sink::get_bandwidth_range,
            py::arg("chan") = 0,
            D(sink,get_bandwidth_range)
        )


        .def("set_time_source",&sink::set_time_source,
            py::arg("source"),
            py::arg("mboard") = 0,
            D(sink,set_time_source)
        )


        .def("get_time_source",&sink::get_time_source,
            py::arg("mboard"),
            D(sink,get_time_source)
        )


        .def("get_time_sources",&sink::get_time_sources,
            py::arg("mboard"),
            D(sink,get_time_sources)
        )


        .def("set_clock_source",&sink::set_clock_source,
            py::arg("source"),
            py::arg("mboard") = 0,
            D(sink,set_clock_source)
        )


        .def("get_clock_source",&sink::get_clock_source,
            py::arg("mboard"),
            D(sink,get_clock_source)
        )


        .def("get_clock_sources",&sink::get_clock_sources,
            py::arg("mboard"),
            D(sink,get_clock_sources)
        )


        .def("get_clock_rate",&sink::get_clock_rate,
            py::arg("mboard") = 0,
            D(sink,get_clock_rate)
        )


        .def("set_clock_rate",&sink::set_clock_rate,
            py::arg("rate"),
            py::arg("mboard") = 0,
            D(sink,set_clock_rate)
        )


        .def("get_time_now",&sink::get_time_now,
            py::arg("mboard") = 0,
            D(sink,get_time_now)
        )


        .def("get_time_last_pps",&sink::get_time_last_pps,
            py::arg("mboard") = 0,
            D(sink,get_time_last_pps)
        )


        .def("set_time_now",&sink::set_time_now,
            py::arg("time_spec"),
            py::arg("mboard") = 0,
            D(sink,set_time_now)
        )


        .def("set_time_next_pps",&sink::set_time_next_pps,
            py::arg("time_spec"),
            D(sink,set_time_next_pps)
        )


        .def("set_time_unknown_pps",&sink::set_time_unknown_pps,
            py::arg("time_spec"),
            D(sink,set_time_unknown_pps)
        )

        ;




}







