/* score-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from score-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Tetravex.

   Copyright (C) 2010-2013 Robert Ancell
   Copyright (C) 2019 Arnaud Bonatti

   GNOME Tetravex is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   GNOME Tetravex is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this GNOME Tetravex.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _ScoreDialogPrivate ScoreDialogPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	SCORE_DIALOG_0_PROPERTY,
	SCORE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* score_dialog_properties[SCORE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _HistoryPrivate HistoryPrivate;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ScoreDialog {
	GtkDialog parent_instance;
	ScoreDialogPrivate * priv;
};

struct _ScoreDialogClass {
	GtkDialogClass parent_class;
};

struct _ScoreDialogPrivate {
	History* history;
	HistoryEntry* selected_entry;
	GtkListStore* size_model;
	GtkListStore* score_model;
	GtkComboBox* size_combo;
	GtkTreeView* scores;
};

struct _History {
	GObject parent_instance;
	HistoryPrivate * priv;
	GList* entries;
};

struct _HistoryClass {
	GObjectClass parent_class;
};

static gint ScoreDialog_private_offset;
static gpointer score_dialog_parent_class = NULL;

VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               guint8 size,
                               HistoryEntry* selected_entry);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     guint8 size,
                                     HistoryEntry* selected_entry);
static void score_dialog_entry_added_cb (ScoreDialog* self,
                                  HistoryEntry* entry);
static void _score_dialog_entry_added_cb_history_entry_added (History* _sender,
                                                       HistoryEntry* entry,
                                                       gpointer self);
static void score_dialog_size_changed_cb (ScoreDialog* self,
                                   GtkComboBox* combo);
static void _score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                          gpointer self);
static gboolean score_dialog_get_size_iter (ScoreDialog* self,
                                     guint8 requested_size,
                                     GtkTreeIter* iter);
static void score_dialog_set_size (ScoreDialog* self,
                            guint8 size);
VALA_EXTERN guint8 history_entry_get_size (HistoryEntry* self);
VALA_EXTERN GDateTime* history_entry_get_date (HistoryEntry* self);
VALA_EXTERN gchar* history_entry_get_duration_string (HistoryEntry* entry);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void score_dialog_finalize (GObject * obj);
static GType score_dialog_get_type_once (void);

static inline gpointer
score_dialog_get_instance_private (ScoreDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScoreDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_score_dialog_entry_added_cb_history_entry_added (History* _sender,
                                                  HistoryEntry* entry,
                                                  gpointer self)
{
	score_dialog_entry_added_cb ((ScoreDialog*) self, entry);
}

static void
_score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                     gpointer self)
{
	score_dialog_size_changed_cb ((ScoreDialog*) self, _sender);
}

ScoreDialog*
score_dialog_construct (GType object_type,
                        History* history,
                        guint8 size,
                        HistoryEntry* selected_entry)
{
	ScoreDialog * self = NULL;
	GtkStyleContext* _tmp0_;
	History* _tmp1_;
	HistoryEntry* _tmp2_;
	GtkListStore* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkListStore* _tmp7_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkComboBox* _tmp14_;
	GtkHeaderBar* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkListStore* _tmp27_;
	GtkTreeView* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkTreeView* _tmp30_;
	GtkCellRendererText* _tmp31_;
	GtkCellRendererText* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkTreeView* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeView* _tmp36_;
	GList* _tmp37_;
	GtkTreeView* _tmp39_;
	GtkListStore* _tmp40_;
	GtkTreeView* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkTreeView* _tmp43_;
	GList* _tmp44_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp47_ = {0};
	gboolean _tmp48_;
	g_return_val_if_fail (history != NULL, NULL);
	self = (ScoreDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "score-dialog");
	_tmp1_ = _g_object_ref0 (history);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp1_;
	g_signal_connect_object (history, "entry-added", (GCallback) _score_dialog_entry_added_cb_history_entry_added, self, 0);
	_tmp2_ = _g_object_ref0 (selected_entry);
	_g_object_unref0 (self->priv->selected_entry);
	self->priv->selected_entry = _tmp2_;
	gtk_widget_set_size_request ((GtkWidget*) self, 360, 475);
	_tmp3_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->size_model);
	self->priv->size_model = _tmp3_;
	_tmp4_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->size_combo);
	self->priv->size_combo = _tmp4_;
	_tmp5_ = self->priv->size_combo;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _score_dialog_size_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp6_ = self->priv->size_combo;
	_tmp7_ = self->priv->size_model;
	gtk_combo_box_set_model (_tmp6_, (GtkTreeModel*) _tmp7_);
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp8_);
	renderer = _tmp8_;
	_tmp9_ = self->priv->size_combo;
	_tmp10_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, TRUE);
	_tmp11_ = self->priv->size_combo;
	_tmp12_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) _tmp12_, "text", 0);
	_tmp13_ = self->priv->size_combo;
	g_object_set ((GtkWidget*) _tmp13_, "width-request", 90, NULL);
	_tmp14_ = self->priv->size_combo;
	gtk_widget_show ((GtkWidget*) _tmp14_);
	_tmp15_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp16_ = self->priv->size_combo;
	gtk_header_bar_set_custom_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp17_);
	scroll = _tmp17_;
	_tmp18_ = scroll;
	gtk_scrolled_window_set_shadow_type (_tmp18_, GTK_SHADOW_ETCHED_IN);
	_tmp19_ = scroll;
	gtk_scrolled_window_set_policy (_tmp19_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp20_ = scroll;
	gtk_scrolled_window_set_shadow_type (_tmp20_, GTK_SHADOW_NONE);
	_tmp21_ = scroll;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	_tmp22_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	content_area = _tmp23_;
	_tmp24_ = content_area;
	gtk_container_set_border_width ((GtkContainer*) _tmp24_, (guint) 0);
	_tmp25_ = content_area;
	_tmp26_ = scroll;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	_tmp27_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp27_;
	_tmp28_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->scores);
	self->priv->scores = _tmp28_;
	_tmp29_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (renderer);
	renderer = _tmp29_;
	_tmp30_ = self->priv->scores;
	_tmp31_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp30_, -1, _ ("Date"), (GtkCellRenderer*) _tmp31_, "text", 0, "weight", 2, NULL);
	_tmp32_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (renderer);
	renderer = _tmp32_;
	_tmp33_ = renderer;
	g_object_set ((GtkCellRenderer*) _tmp33_, "xalign", 1.0f, NULL);
	_tmp34_ = self->priv->scores;
	_tmp35_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp34_, -1, _ ("Time"), (GtkCellRenderer*) _tmp35_, "text", 1, "weight", 2, NULL);
	_tmp36_ = self->priv->scores;
	_tmp37_ = gtk_tree_view_get_columns (_tmp36_);
	{
		GList* column_collection = NULL;
		GList* column_it = NULL;
		column_collection = _tmp37_;
		for (column_it = column_collection; column_it != NULL; column_it = column_it->next) {
			GtkTreeViewColumn* column = NULL;
			column = (GtkTreeViewColumn*) column_it->data;
			{
				GtkTreeViewColumn* _tmp38_;
				_tmp38_ = column;
				gtk_tree_view_column_set_expand (_tmp38_, TRUE);
			}
		}
		(column_collection == NULL) ? NULL : (column_collection = (g_list_free (column_collection), NULL));
	}
	_tmp39_ = self->priv->scores;
	_tmp40_ = self->priv->score_model;
	gtk_tree_view_set_model (_tmp39_, (GtkTreeModel*) _tmp40_);
	_tmp41_ = self->priv->scores;
	gtk_widget_show ((GtkWidget*) _tmp41_);
	_tmp42_ = scroll;
	_tmp43_ = self->priv->scores;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = history->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp44_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp45_;
			HistoryEntry* entry = NULL;
			_tmp45_ = _g_object_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp45_;
			{
				HistoryEntry* _tmp46_;
				_tmp46_ = entry;
				score_dialog_entry_added_cb (self, _tmp46_);
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp48_ = score_dialog_get_size_iter (self, size, &_tmp47_);
	iter = _tmp47_;
	if (_tmp48_) {
		GtkComboBox* _tmp49_;
		GtkTreeIter _tmp50_;
		_tmp49_ = self->priv->size_combo;
		_tmp50_ = iter;
		gtk_combo_box_set_active_iter (_tmp49_, &_tmp50_);
	}
	_g_object_unref0 (content_area);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	return self;
}

ScoreDialog*
score_dialog_new (History* history,
                  guint8 size,
                  HistoryEntry* selected_entry)
{
	return score_dialog_construct (TYPE_SCORE_DIALOG, history, size, selected_entry);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
score_dialog_set_size (ScoreDialog* self,
                       guint8 size)
{
	GtkListStore* _tmp0_;
	History* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_model;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->history;
	_tmp2_ = _tmp1_->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp2_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp3_;
			HistoryEntry* entry = NULL;
			_tmp3_ = _g_object_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp3_;
			{
				HistoryEntry* _tmp4_;
				guint8 _tmp5_;
				guint8 _tmp6_;
				gchar* date_label = NULL;
				HistoryEntry* _tmp7_;
				GDateTime* _tmp8_;
				GDateTime* _tmp9_;
				gchar* _tmp10_;
				gchar* time_label = NULL;
				HistoryEntry* _tmp11_;
				gchar* _tmp12_;
				gint weight = 0;
				HistoryEntry* _tmp13_;
				HistoryEntry* _tmp14_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp15_;
				GtkTreeIter _tmp16_ = {0};
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				HistoryEntry* _tmp21_;
				HistoryEntry* _tmp22_;
				_tmp4_ = entry;
				_tmp5_ = history_entry_get_size (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ != size) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp7_ = entry;
				_tmp8_ = history_entry_get_date (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_date_time_format (_tmp9_, "%x");
				date_label = _tmp10_;
				_tmp11_ = entry;
				_tmp12_ = history_entry_get_duration_string (_tmp11_);
				time_label = _tmp12_;
				weight = (gint) PANGO_WEIGHT_NORMAL;
				_tmp13_ = entry;
				_tmp14_ = self->priv->selected_entry;
				if (_tmp13_ == _tmp14_) {
					weight = (gint) PANGO_WEIGHT_BOLD;
				}
				_tmp15_ = self->priv->score_model;
				gtk_list_store_append (_tmp15_, &_tmp16_);
				iter = _tmp16_;
				_tmp17_ = self->priv->score_model;
				_tmp18_ = iter;
				_tmp19_ = date_label;
				_tmp20_ = time_label;
				gtk_list_store_set (_tmp17_, &_tmp18_, 0, _tmp19_, 1, _tmp20_, 2, weight, -1);
				_tmp21_ = entry;
				_tmp22_ = self->priv->selected_entry;
				if (_tmp21_ == _tmp22_) {
					GtkTreeIter piter = {0};
					GtkTreeIter _tmp23_;
					GtkListStore* _tmp24_;
					gboolean _tmp25_;
					GtkTreeView* _tmp31_;
					GtkListStore* _tmp32_;
					GtkTreeIter _tmp33_;
					GtkTreePath* _tmp34_;
					GtkTreePath* _tmp35_;
					_tmp23_ = iter;
					piter = _tmp23_;
					_tmp24_ = self->priv->score_model;
					_tmp25_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp24_, &piter);
					if (_tmp25_) {
						GtkTreeIter ppiter = {0};
						GtkTreeIter _tmp26_;
						GtkListStore* _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = piter;
						ppiter = _tmp26_;
						_tmp27_ = self->priv->score_model;
						_tmp28_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp27_, &ppiter);
						if (_tmp28_) {
							GtkTreeIter _tmp29_;
							_tmp29_ = ppiter;
							piter = _tmp29_;
						}
					} else {
						GtkTreeIter _tmp30_;
						_tmp30_ = iter;
						piter = _tmp30_;
					}
					_tmp31_ = self->priv->scores;
					_tmp32_ = self->priv->score_model;
					_tmp33_ = piter;
					_tmp34_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp32_, &_tmp33_);
					_tmp35_ = _tmp34_;
					gtk_tree_view_scroll_to_cell (_tmp31_, _tmp35_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
					__vala_GtkTreePath_free0 (_tmp35_);
				}
				_g_free0 (time_label);
				_g_free0 (date_label);
				_g_object_unref0 (entry);
			}
		}
	}
}

static void
score_dialog_size_changed_cb (ScoreDialog* self,
                              GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gint size = 0;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1);
	size = _tmp5_;
	score_dialog_set_size (self, (guint8) size);
}

static void
score_dialog_entry_added_cb (ScoreDialog* self,
                             HistoryEntry* entry)
{
	GtkTreeIter iter = {0};
	guint8 _tmp0_;
	guint8 _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = history_entry_get_size (entry);
	_tmp1_ = _tmp0_;
	_tmp3_ = score_dialog_get_size_iter (self, _tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (!_tmp3_) {
		gchar* label = NULL;
		guint8 _tmp4_;
		guint8 _tmp5_;
		guint8 _tmp6_;
		guint8 _tmp7_;
		gchar* _tmp8_;
		GtkListStore* _tmp9_;
		GtkTreeIter _tmp10_ = {0};
		GtkListStore* _tmp11_;
		GtkTreeIter _tmp12_;
		const gchar* _tmp13_;
		guint8 _tmp14_;
		guint8 _tmp15_;
		GtkComboBox* _tmp16_;
		gboolean _tmp19_ = FALSE;
		HistoryEntry* _tmp20_;
		_tmp4_ = history_entry_get_size (entry);
		_tmp5_ = _tmp4_;
		_tmp6_ = history_entry_get_size (entry);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_ ("%u × %u"), (guint) _tmp5_, (guint) _tmp7_);
		label = _tmp8_;
		_tmp9_ = self->priv->size_model;
		gtk_list_store_append (_tmp9_, &_tmp10_);
		iter = _tmp10_;
		_tmp11_ = self->priv->size_model;
		_tmp12_ = iter;
		_tmp13_ = label;
		_tmp14_ = history_entry_get_size (entry);
		_tmp15_ = _tmp14_;
		gtk_list_store_set (_tmp11_, &_tmp12_, 0, _tmp13_, 1, _tmp15_, -1);
		_tmp16_ = self->priv->size_combo;
		if (gtk_combo_box_get_active (_tmp16_) == -1) {
			GtkComboBox* _tmp17_;
			GtkTreeIter _tmp18_;
			_tmp17_ = self->priv->size_combo;
			_tmp18_ = iter;
			gtk_combo_box_set_active_iter (_tmp17_, &_tmp18_);
		}
		_tmp20_ = self->priv->selected_entry;
		if (_tmp20_ != NULL) {
			guint8 _tmp21_;
			guint8 _tmp22_;
			HistoryEntry* _tmp23_;
			guint8 _tmp24_;
			guint8 _tmp25_;
			_tmp21_ = history_entry_get_size (entry);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->selected_entry;
			_tmp24_ = history_entry_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_HISTORY_ENTRY, HistoryEntry));
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp22_ == _tmp25_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GtkComboBox* _tmp26_;
			GtkTreeIter _tmp27_;
			_tmp26_ = self->priv->size_combo;
			_tmp27_ = iter;
			gtk_combo_box_set_active_iter (_tmp26_, &_tmp27_);
		}
		_g_free0 (label);
	}
}

static gboolean
score_dialog_get_size_iter (ScoreDialog* self,
                            guint8 requested_size,
                            GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->size_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	_vala_iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint size = 0;
				GtkListStore* _tmp6_;
				GtkTreeIter _tmp7_;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					GtkListStore* _tmp4_;
					gboolean _tmp5_;
					_tmp4_ = self->priv->size_model;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &_vala_iter);
					if (!_tmp5_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp6_ = self->priv->size_model;
				_tmp7_ = _vala_iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 1, &_tmp8_, -1, -1);
				size = _tmp8_;
				if (size == ((gint) requested_size)) {
					result = TRUE;
					if (iter) {
						*iter = _vala_iter;
					}
					return result;
				}
			}
		}
	}
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
score_dialog_class_init (ScoreDialogClass * klass,
                         gpointer klass_data)
{
	score_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScoreDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = score_dialog_finalize;
}

static void
score_dialog_instance_init (ScoreDialog * self,
                            gpointer klass)
{
	self->priv = score_dialog_get_instance_private (self);
	self->priv->selected_entry = NULL;
}

static void
score_dialog_finalize (GObject * obj)
{
	ScoreDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_DIALOG, ScoreDialog);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->selected_entry);
	_g_object_unref0 (self->priv->size_model);
	_g_object_unref0 (self->priv->score_model);
	_g_object_unref0 (self->priv->size_combo);
	_g_object_unref0 (self->priv->scores);
	G_OBJECT_CLASS (score_dialog_parent_class)->finalize (obj);
}

static GType
score_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreDialog), 0, (GInstanceInitFunc) score_dialog_instance_init, NULL };
	GType score_dialog_type_id;
	score_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ScoreDialog", &g_define_type_info, 0);
	ScoreDialog_private_offset = g_type_add_instance_private (score_dialog_type_id, sizeof (ScoreDialogPrivate));
	return score_dialog_type_id;
}

GType
score_dialog_get_type (void)
{
	static volatile gsize score_dialog_type_id__once = 0;
	if (g_once_init_enter (&score_dialog_type_id__once)) {
		GType score_dialog_type_id;
		score_dialog_type_id = score_dialog_get_type_once ();
		g_once_init_leave (&score_dialog_type_id__once, score_dialog_type_id);
	}
	return score_dialog_type_id__once;
}

