/* geary-account-information.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-account-information.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_ACCOUNT_INFORMATION_0_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_ID_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_DISPLAY_NAME_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_PRIMARY_MAILBOX_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SENDER_MAILBOXES_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_HAS_SENDER_ALIASES_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY,
	GEARY_ACCOUNT_INFORMATION_NUM_PROPERTIES
};
static GParamSpec* geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _GearyAccountInformationLoadOutgoingCredentialsData GearyAccountInformationLoadOutgoingCredentialsData;
typedef struct _GearyAccountInformationLoadIncomingCredentialsData GearyAccountInformationLoadIncomingCredentialsData;
typedef struct _Block3Data Block3Data;
enum  {
	GEARY_ACCOUNT_INFORMATION_AUTHENTICATION_FAILURE_SIGNAL,
	GEARY_ACCOUNT_INFORMATION_UNTRUSTED_HOST_SIGNAL,
	GEARY_ACCOUNT_INFORMATION_CHANGED_SIGNAL,
	GEARY_ACCOUNT_INFORMATION_NUM_SIGNALS
};
static guint geary_account_information_signals[GEARY_ACCOUNT_INFORMATION_NUM_SIGNALS] = {0};

struct _GearyAccountInformationPrivate {
	gchar* _id;
	gint _ordinal;
	GearyServiceProvider _service_provider;
	gchar* _service_label;
	gchar* _label;
	gint _prefetch_period_days;
	gboolean _save_sent;
	gboolean _save_drafts;
	GearyCredentialsMediator* _mediator;
	GearyServiceInformation* _incoming;
	GearyServiceInformation* _outgoing;
	GearyNonblockingMutex* _write_lock;
	gboolean _use_signature;
	gchar* _signature;
	GFile* _config_dir;
	GFile* _data_dir;
	GeeMap* special_use_paths;
	GeeList* _mailboxes;
};

struct _Block2Data {
	int _ref_count_;
	GearyAccountInformation* self;
	GearyRFC822MailboxAddress* email;
};

struct _GearyAccountInformationLoadOutgoingCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAccountInformation* self;
	GCancellable* cancellable;
	gboolean result;
	GearyCredentials* creds;
	GearyCredentials* _tmp0_;
	gboolean loaded;
	GearyCredentials* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GearyCredentialsRequirement _tmp3_;
	GearyCredentialsRequirement _tmp4_;
	gboolean _tmp5_;
	GearyCredentialsMediator* _tmp6_;
	GearyServiceInformation* _tmp7_;
	gboolean _tmp8_;
	GearyCredentialsMediator* _tmp9_;
	GearyServiceInformation* _tmp10_;
	GError* _inner_error0_;
};

struct _GearyAccountInformationLoadIncomingCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAccountInformation* self;
	GCancellable* cancellable;
	gboolean result;
	GearyCredentials* creds;
	GearyServiceInformation* _tmp0_;
	GearyCredentials* _tmp1_;
	GearyCredentials* _tmp2_;
	GearyCredentials* _tmp3_;
	gboolean loaded;
	GearyCredentials* _tmp4_;
	gboolean _tmp5_;
	GearyCredentialsMediator* _tmp6_;
	GearyServiceInformation* _tmp7_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	GearyAccountInformation* self;
	GearyAccountInformation* other;
};

static gint GearyAccountInformation_private_offset;
static gpointer geary_account_information_parent_class = NULL;
gint geary_account_information_next_ordinal = 0;

static void geary_account_information_set_id (GearyAccountInformation* self,
                                       const gchar* value);
static void geary_account_information_set_service_provider (GearyAccountInformation* self,
                                                     GearyServiceProvider value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GeeList* geary_account_information_get_mailboxes (GearyAccountInformation* self);
static void geary_account_information_set_mediator (GearyAccountInformation* self,
                                             GearyCredentialsMediator* value);
static void geary_account_information_set_write_lock (GearyAccountInformation* self,
                                               GearyNonblockingMutex* value);
static void geary_account_information_set_config_dir (GearyAccountInformation* self,
                                               GFile* value);
static void geary_account_information_set_data_dir (GearyAccountInformation* self,
                                             GFile* value);
static guint _geary_account_information_special_use_paths_lambda140_ (GearyFolderSpecialUse* k);
static guint __geary_account_information_special_use_paths_lambda140__gee_hash_data_func (gconstpointer v,
                                                                                   gpointer self);
static gboolean _geary_account_information_special_use_paths_lambda141_ (GearyFolderSpecialUse* k1,
                                                                  GearyFolderSpecialUse* k2);
static gboolean __geary_account_information_special_use_paths_lambda141__gee_equal_data_func (gconstpointer a,
                                                                                       gconstpointer b,
                                                                                       gpointer self);
static GearyFolderSpecialUse* _geary_folder_special_use_dup (GearyFolderSpecialUse* self);
static void geary_account_information_set_mailboxes (GearyAccountInformation* self,
                                              GeeList* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda125_ (Block2Data* _data2_,
                       GearyRFC822MailboxAddress* alt);
static gboolean ___lambda125__gee_predicate (gconstpointer g,
                                      gpointer self);
static void geary_account_information_load_outgoing_credentials_data_free (gpointer _data);
static gboolean geary_account_information_load_outgoing_credentials_co (GearyAccountInformationLoadOutgoingCredentialsData* _data_);
static void geary_account_information_load_outgoing_credentials_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static void geary_account_information_load_incoming_credentials_data_free (gpointer _data);
static gboolean geary_account_information_load_incoming_credentials_co (GearyAccountInformationLoadIncomingCredentialsData* _data_);
static void geary_account_information_load_incoming_credentials_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ____lambda147_ (Block3Data* _data3_,
                         GearyRFC822MailboxAddress* addr);
static gboolean _____lambda147__gee_predicate (gconstpointer g,
                                        gpointer self);
static void geary_account_information_finalize (GObject * obj);
static GType geary_account_information_get_type_once (void);
static void _vala_geary_account_information_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_account_information_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_account_information_get_instance_private (GearyAccountInformation* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAccountInformation_private_offset);
}

/** Comparator for account info objects based on their ordinals. */
gint
geary_account_information_compare_ascending (GearyAccountInformation* a,
                                             GearyAccountInformation* b)
{
	gint diff = 0;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (a), 0);
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (b), 0);
	_tmp0_ = a->priv->_ordinal;
	_tmp1_ = b->priv->_ordinal;
	diff = _tmp0_ - _tmp1_;
	if (diff != 0) {
		result = diff;
		return result;
	}
	_tmp2_ = geary_account_information_get_display_name (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_account_information_get_display_name (b);
	_tmp5_ = _tmp4_;
	result = g_utf8_collate (_tmp3_, _tmp5_);
	return result;
}

const gchar*
geary_account_information_get_id (GearyAccountInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
geary_account_information_set_id (GearyAccountInformation* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_ID_PROPERTY]);
	}
}

gint
geary_account_information_get_ordinal (GearyAccountInformation* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), 0);
	result = self->priv->_ordinal;
	return result;
}

void
geary_account_information_set_ordinal (GearyAccountInformation* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_ordinal (self);
	if (old_value != value) {
		self->priv->_ordinal = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY]);
	}
}

GearyServiceProvider
geary_account_information_get_service_provider (GearyAccountInformation* self)
{
	GearyServiceProvider result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), 0);
	result = self->priv->_service_provider;
	return result;
}

static void
geary_account_information_set_service_provider (GearyAccountInformation* self,
                                                GearyServiceProvider value)
{
	GearyServiceProvider old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_service_provider (self);
	if (old_value != value) {
		self->priv->_service_provider = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY]);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
geary_account_information_get_service_label (GearyAccountInformation* self)
{
	gchar* result;
	gchar* value = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_service_label;
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ == NULL) {
		gchar* email_domain = NULL;
		GearyRFC822MailboxAddress* _tmp3_;
		GearyRFC822MailboxAddress* _tmp4_;
		GearyRFC822MailboxAddress* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GearyServiceInformation* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp3_ = geary_account_information_get_primary_mailbox (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_rf_c822_mailbox_address_get_domain (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp5_);
		email_domain = _tmp9_;
		_tmp10_ = self->priv->_incoming;
		_tmp11_ = geary_service_information_get_host (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = email_domain;
		if (g_str_has_suffix (_tmp12_, _tmp13_)) {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = email_domain;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (value);
			value = _tmp15_;
		} else {
			gchar** host_parts = NULL;
			GearyServiceInformation* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar** _tmp19_;
			gchar** _tmp20_;
			gint host_parts_length1;
			gint _host_parts_size_;
			gboolean _tmp21_ = FALSE;
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar** _tmp28_;
			gint _tmp28__length1;
			gchar* _tmp29_;
			_tmp16_ = self->priv->_incoming;
			_tmp17_ = geary_service_information_get_host (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, ".", 0);
			host_parts = _tmp20_;
			host_parts_length1 = _vala_array_length (_tmp19_);
			_host_parts_size_ = host_parts_length1;
			_tmp22_ = host_parts;
			_tmp22__length1 = host_parts_length1;
			if (_tmp22__length1 > 2) {
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				_tmp23_ = host_parts;
				_tmp23__length1 = host_parts_length1;
				_tmp24_ = _tmp23_[0];
				_tmp21_ = atoi (_tmp24_) == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				gchar** _tmp25_;
				gint _tmp25__length1;
				gchar** _tmp26_;
				gint _tmp26__length1;
				gchar** _tmp27_;
				gint _tmp27__length1;
				_tmp25_ = host_parts;
				_tmp25__length1 = host_parts_length1;
				_tmp26_ = host_parts;
				_tmp26__length1 = host_parts_length1;
				_tmp27_ = (_tmp25_ != NULL) ? _vala_array_dup1 (_tmp25_ + 1, _tmp26__length1 - 1) : _tmp25_;
				_tmp27__length1 = _tmp26__length1 - 1;
				host_parts = (_vala_array_free (host_parts, host_parts_length1, (GDestroyNotify) g_free), NULL);
				host_parts = _tmp27_;
				host_parts_length1 = _tmp27__length1;
				_host_parts_size_ = host_parts_length1;
			}
			_tmp28_ = host_parts;
			_tmp28__length1 = host_parts_length1;
			_tmp29_ = _vala_g_strjoinv (".", _tmp28_, (gint) _tmp28__length1);
			_g_free0 (value);
			value = _tmp29_;
			host_parts = (_vala_array_free (host_parts, host_parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (email_domain);
	}
	result = value;
	return result;
}

void
geary_account_information_set_service_label (GearyAccountInformation* self,
                                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_service_label);
	self->priv->_service_label = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY]);
}

const gchar*
geary_account_information_get_display_name (GearyAccountInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp1_ = self->priv->_label;
	if (!geary_string_is_empty_or_whitespace (_tmp1_)) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_label;
		_tmp0_ = _tmp2_;
	} else {
		GearyRFC822MailboxAddress* _tmp3_;
		GearyRFC822MailboxAddress* _tmp4_;
		GearyRFC822MailboxAddress* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = geary_account_information_get_primary_mailbox (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_rf_c822_mailbox_address_get_address (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	result = _tmp0_;
	return result;
}

const gchar*
geary_account_information_get_label (GearyAccountInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

void
geary_account_information_set_label (GearyAccountInformation* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY]);
	}
}

GearyRFC822MailboxAddress*
geary_account_information_get_primary_mailbox (GearyAccountInformation* self)
{
	GearyRFC822MailboxAddress* result;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gpointer _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = geary_account_information_get_sender_mailboxes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_get (_tmp2_, 0);
	_tmp4_ = (GearyRFC822MailboxAddress*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

GeeList*
geary_account_information_get_sender_mailboxes (GearyAccountInformation* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_mailboxes;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
geary_account_information_get_has_sender_aliases (GearyAccountInformation* self)
{
	gboolean result;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	_tmp0_ = geary_account_information_get_sender_mailboxes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ > 1;
	_g_object_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

gint
geary_account_information_get_prefetch_period_days (GearyAccountInformation* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), 0);
	result = self->priv->_prefetch_period_days;
	return result;
}

void
geary_account_information_set_prefetch_period_days (GearyAccountInformation* self,
                                                    gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_prefetch_period_days (self);
	if (old_value != value) {
		self->priv->_prefetch_period_days = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY]);
	}
}

gboolean
geary_account_information_get_save_sent (GearyAccountInformation* self)
{
	gboolean result;
	gboolean save = FALSE;
	GearyServiceProvider _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	save = self->priv->_save_sent;
	_tmp0_ = self->priv->_service_provider;
	switch (_tmp0_) {
		case GEARY_SERVICE_PROVIDER_GMAIL:
		case GEARY_SERVICE_PROVIDER_OUTLOOK:
		{
			save = FALSE;
			break;
		}
		default:
		{
			break;
		}
	}
	result = save;
	return result;
}

void
geary_account_information_set_save_sent (GearyAccountInformation* self,
                                         gboolean value)
{
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	self->priv->_save_sent = value;
	g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY]);
}

gboolean
geary_account_information_get_save_drafts (GearyAccountInformation* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	result = self->priv->_save_drafts;
	return result;
}

void
geary_account_information_set_save_drafts (GearyAccountInformation* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_save_drafts (self);
	if (old_value != value) {
		self->priv->_save_drafts = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY]);
	}
}

GearyCredentialsMediator*
geary_account_information_get_mediator (GearyAccountInformation* self)
{
	GearyCredentialsMediator* result;
	GearyCredentialsMediator* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_mediator;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_account_information_set_mediator (GearyAccountInformation* self,
                                        GearyCredentialsMediator* value)
{
	GearyCredentialsMediator* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_mediator (self);
	if (old_value != value) {
		GearyCredentialsMediator* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mediator);
		self->priv->_mediator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY]);
	}
}

GearyServiceInformation*
geary_account_information_get_incoming (GearyAccountInformation* self)
{
	GearyServiceInformation* result;
	GearyServiceInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_incoming;
	result = _tmp0_;
	return result;
}

void
geary_account_information_set_incoming (GearyAccountInformation* self,
                                        GearyServiceInformation* value)
{
	GearyServiceInformation* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_incoming (self);
	if (old_value != value) {
		GearyServiceInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_incoming);
		self->priv->_incoming = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY]);
	}
}

GearyServiceInformation*
geary_account_information_get_outgoing (GearyAccountInformation* self)
{
	GearyServiceInformation* result;
	GearyServiceInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_outgoing;
	result = _tmp0_;
	return result;
}

void
geary_account_information_set_outgoing (GearyAccountInformation* self,
                                        GearyServiceInformation* value)
{
	GearyServiceInformation* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_outgoing (self);
	if (old_value != value) {
		GearyServiceInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_outgoing);
		self->priv->_outgoing = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY]);
	}
}

GearyNonblockingMutex*
geary_account_information_get_write_lock (GearyAccountInformation* self)
{
	GearyNonblockingMutex* result;
	GearyNonblockingMutex* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_write_lock;
	result = _tmp0_;
	return result;
}

static void
geary_account_information_set_write_lock (GearyAccountInformation* self,
                                          GearyNonblockingMutex* value)
{
	GearyNonblockingMutex* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_write_lock (self);
	if (old_value != value) {
		GearyNonblockingMutex* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_write_lock);
		self->priv->_write_lock = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY]);
	}
}

gboolean
geary_account_information_get_use_signature (GearyAccountInformation* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	result = self->priv->_use_signature;
	return result;
}

void
geary_account_information_set_use_signature (GearyAccountInformation* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_use_signature (self);
	if (old_value != value) {
		self->priv->_use_signature = value;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY]);
	}
}

const gchar*
geary_account_information_get_signature (GearyAccountInformation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_signature;
	result = _tmp0_;
	return result;
}

void
geary_account_information_set_signature (GearyAccountInformation* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_signature (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_signature);
		self->priv->_signature = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY]);
	}
}

GFile*
geary_account_information_get_config_dir (GearyAccountInformation* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_config_dir;
	result = _tmp0_;
	return result;
}

static void
geary_account_information_set_config_dir (GearyAccountInformation* self,
                                          GFile* value)
{
	GFile* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_config_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_config_dir);
		self->priv->_config_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY]);
	}
}

GFile*
geary_account_information_get_data_dir (GearyAccountInformation* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_data_dir;
	result = _tmp0_;
	return result;
}

static void
geary_account_information_set_data_dir (GearyAccountInformation* self,
                                        GFile* value)
{
	GFile* old_value;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	old_value = geary_account_information_get_data_dir (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_dir);
		self->priv->_data_dir = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY]);
	}
}

static guint
_geary_account_information_special_use_paths_lambda140_ (GearyFolderSpecialUse* k)
{
	GHashFunc _tmp0_;
	guint result;
	_tmp0_ = g_int_hash;
	result = _tmp0_ ((gint*) k);
	return result;
}

static guint
__geary_account_information_special_use_paths_lambda140__gee_hash_data_func (gconstpointer v,
                                                                             gpointer self)
{
	guint result;
	result = _geary_account_information_special_use_paths_lambda140_ ((GearyFolderSpecialUse*) v);
	return result;
}

static gboolean
_geary_account_information_special_use_paths_lambda141_ (GearyFolderSpecialUse* k1,
                                                         GearyFolderSpecialUse* k2)
{
	gboolean result;
	result = ((GearyFolderSpecialUse) (*k1)) == ((GearyFolderSpecialUse) (*k2));
	return result;
}

static gboolean
__geary_account_information_special_use_paths_lambda141__gee_equal_data_func (gconstpointer a,
                                                                              gconstpointer b,
                                                                              gpointer self)
{
	gboolean result;
	result = _geary_account_information_special_use_paths_lambda141_ ((GearyFolderSpecialUse*) a, (GearyFolderSpecialUse*) b);
	return result;
}

static GearyFolderSpecialUse*
_geary_folder_special_use_dup (GearyFolderSpecialUse* self)
{
	GearyFolderSpecialUse* dup;
	dup = g_new0 (GearyFolderSpecialUse, 1);
	memcpy (dup, self, sizeof (GearyFolderSpecialUse));
	return dup;
}

static GeeList*
geary_account_information_get_mailboxes (GearyAccountInformation* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->_mailboxes;
	result = _tmp0_;
	return result;
}

static void
geary_account_information_set_mailboxes (GearyAccountInformation* self,
                                         GeeList* value)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_mailboxes);
	self->priv->_mailboxes = _tmp0_;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
}

/**
     * Creates a new account with default settings.
     */
GearyAccountInformation*
geary_account_information_construct (GType object_type,
                                     const gchar* id,
                                     GearyServiceProvider provider,
                                     GearyCredentialsMediator* mediator,
                                     GearyRFC822MailboxAddress* primary_mailbox)
{
	GearyAccountInformation * self = NULL;
	GearyServiceInformation* _tmp0_;
	GearyServiceInformation* _tmp1_;
	GearyServiceInformation* _tmp2_;
	GearyServiceInformation* _tmp3_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (GEARY_IS_CREDENTIALS_MEDIATOR (mediator), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (primary_mailbox), NULL);
	self = (GearyAccountInformation*) geary_base_object_construct (object_type);
	geary_account_information_set_id (self, id);
	geary_account_information_set_mediator (self, mediator);
	geary_account_information_set_service_provider (self, provider);
	_tmp0_ = geary_service_information_new (GEARY_PROTOCOL_IMAP, provider);
	_tmp1_ = _tmp0_;
	geary_account_information_set_incoming (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = geary_service_information_new (GEARY_PROTOCOL_SMTP, provider);
	_tmp3_ = _tmp2_;
	geary_account_information_set_outgoing (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	geary_service_provider_set_account_defaults (provider, self);
	geary_account_information_append_sender (self, primary_mailbox);
	return self;
}

GearyAccountInformation*
geary_account_information_new (const gchar* id,
                               GearyServiceProvider provider,
                               GearyCredentialsMediator* mediator,
                               GearyRFC822MailboxAddress* primary_mailbox)
{
	return geary_account_information_construct (GEARY_TYPE_ACCOUNT_INFORMATION, id, provider, mediator, primary_mailbox);
}

/**
     * Creates a copy of an existing config.
     */
GearyAccountInformation*
geary_account_information_construct_copy (GType object_type,
                                          GearyAccountInformation* other)
{
	GearyAccountInformation * self = NULL;
	const gchar* _tmp0_;
	GearyServiceProvider _tmp1_;
	GearyCredentialsMediator* _tmp2_;
	GearyRFC822MailboxAddress* _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	GearyRFC822MailboxAddress* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	const gchar* _tmp25_;
	GearyServiceInformation* _tmp26_;
	GearyServiceInformation* _tmp27_;
	GearyServiceInformation* _tmp28_;
	GearyServiceInformation* _tmp29_;
	GearyServiceInformation* _tmp30_;
	GearyServiceInformation* _tmp31_;
	GeeMap* _tmp32_;
	GeeMap* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (other), NULL);
	_tmp0_ = other->priv->_id;
	_tmp1_ = other->priv->_service_provider;
	_tmp2_ = other->priv->_mediator;
	_tmp3_ = geary_account_information_get_primary_mailbox (other);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	self = (GearyAccountInformation*) geary_account_information_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = geary_account_information_get_service_label (other);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	geary_account_information_set_service_label (self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = other->priv->_label;
	geary_account_information_set_label (self, _tmp9_);
	_tmp10_ = other->priv->_mailboxes;
	_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp12_ = _tmp11_;
	if (_tmp12_ > 1) {
		GeeList* _tmp13_;
		GeeList* _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		_tmp13_ = self->priv->_mailboxes;
		_tmp14_ = other->priv->_mailboxes;
		_tmp15_ = other->priv->_mailboxes;
		_tmp16_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_list_slice (_tmp14_, 1, _tmp17_);
		_tmp19_ = _tmp18_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = other->priv->_prefetch_period_days;
	geary_account_information_set_prefetch_period_days (self, _tmp20_);
	_tmp21_ = geary_account_information_get_save_sent (other);
	_tmp22_ = _tmp21_;
	geary_account_information_set_save_sent (self, _tmp22_);
	_tmp23_ = other->priv->_save_drafts;
	geary_account_information_set_save_drafts (self, _tmp23_);
	_tmp24_ = other->priv->_use_signature;
	geary_account_information_set_use_signature (self, _tmp24_);
	_tmp25_ = other->priv->_signature;
	geary_account_information_set_signature (self, _tmp25_);
	_tmp26_ = other->priv->_incoming;
	_tmp27_ = geary_service_information_new_copy (_tmp26_);
	_tmp28_ = _tmp27_;
	geary_account_information_set_incoming (self, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = other->priv->_outgoing;
	_tmp30_ = geary_service_information_new_copy (_tmp29_);
	_tmp31_ = _tmp30_;
	geary_account_information_set_outgoing (self, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = self->priv->special_use_paths;
	_tmp33_ = other->priv->special_use_paths;
	gee_map_set_all (_tmp32_, _tmp33_);
	_tmp34_ = other->priv->_config_dir;
	geary_account_information_set_config_dir (self, _tmp34_);
	_tmp35_ = other->priv->_data_dir;
	geary_account_information_set_data_dir (self, _tmp35_);
	return self;
}

GearyAccountInformation*
geary_account_information_new_copy (GearyAccountInformation* other)
{
	return geary_account_information_construct_copy (GEARY_TYPE_ACCOUNT_INFORMATION, other);
}

/** Sets the location of the account's storage directories. */
void
geary_account_information_set_account_directories (GearyAccountInformation* self,
                                                   GFile* config,
                                                   GFile* data)
{
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (config, g_file_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (data, g_file_get_type ()));
	geary_account_information_set_config_dir (self, config);
	geary_account_information_set_data_dir (self, data);
}

/**
     * Determines if a mailbox is in the sender mailbox list.
     *
     * Returns true if the given address is equal to one of the
     * addresses in {@link sender_mailboxes}, by case-insensitive
     * matching the address parts.
     *
     * @see Geary.RFC822.MailboxAddress.equal_to
     */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GearyAccountInformation* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->email);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda125_ (Block2Data* _data2_,
              GearyRFC822MailboxAddress* alt)
{
	GearyAccountInformation* self;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (alt), FALSE);
	result = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (alt, GEE_TYPE_HASHABLE, GeeHashable), _data2_->email);
	return result;
}

static gboolean
___lambda125__gee_predicate (gconstpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda125_ (self, (GearyRFC822MailboxAddress*) g);
	return result;
}

gboolean
geary_account_information_has_sender_mailbox (GearyAccountInformation* self,
                                              GearyRFC822MailboxAddress* email)
{
	Block2Data* _data2_;
	GearyRFC822MailboxAddress* _tmp0_;
	GeeList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (email), FALSE);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (email);
	_g_object_unref0 (_data2_->email);
	_data2_->email = _tmp0_;
	_tmp1_ = self->priv->_mailboxes;
	result = gee_traversable_any_match (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_TRAVERSABLE, GeeTraversable), ___lambda125__gee_predicate, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

/**
     * Appends a mailbox to the list of sender mailboxes.
     *
     * Mailboxes with duplicate addresses will not be added.
     *
     * Returns true if the mailbox was appended.
     */
gboolean
geary_account_information_append_sender (GearyAccountInformation* self,
                                         GearyRFC822MailboxAddress* mailbox)
{
	gboolean add = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (mailbox), FALSE);
	add = !geary_account_information_has_sender_mailbox (self, mailbox);
	if (add) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->_mailboxes;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), mailbox);
	}
	result = add;
	return result;
}

/**
     * Inserts a mailbox into the list of sender mailboxes.
     *
     * Mailboxes with duplicate addresses will not be added.
     *
     * Returns true if the mailbox was inserted.
     */
gboolean
geary_account_information_insert_sender (GearyAccountInformation* self,
                                         gint index,
                                         GearyRFC822MailboxAddress* mailbox)
{
	gboolean add = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (mailbox), FALSE);
	add = !geary_account_information_has_sender_mailbox (self, mailbox);
	if (add) {
		GeeList* _tmp0_;
		_tmp0_ = self->priv->_mailboxes;
		gee_list_insert (_tmp0_, index, mailbox);
	}
	result = add;
	return result;
}

/**
     * Removes a mailbox from the list of sender mailboxes.
     *
     * The last mailbox cannot be removed.
     *
     * Returns true if the mailbox was removed.
     */
gboolean
geary_account_information_remove_sender (GearyAccountInformation* self,
                                         GearyRFC822MailboxAddress* mailbox)
{
	gboolean removed = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (mailbox), FALSE);
	removed = FALSE;
	_tmp0_ = self->priv->_mailboxes;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		GeeList* _tmp3_;
		_tmp3_ = self->priv->_mailboxes;
		removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), mailbox);
	}
	result = removed;
	return result;
}

/**
     * Replace a mailbox at the specified index.
     */
void
geary_account_information_replace_sender (GearyAccountInformation* self,
                                          gint index,
                                          GearyRFC822MailboxAddress* mailbox)
{
	GeeList* _tmp0_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (mailbox));
	_tmp0_ = self->priv->_mailboxes;
	gee_list_set (_tmp0_, index, mailbox);
}

/**
     * Returns the folder path steps configured for a specific use.
     */
GeeList*
geary_account_information_get_folder_steps_for_use (GearyAccountInformation* self,
                                                    GearyFolderSpecialUse use)
{
	GeeList* steps = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	_tmp0_ = self->priv->special_use_paths;
	_tmp1_ = gee_map_get (_tmp0_, (gpointer) ((gintptr) (&use)));
	steps = (GeeList*) _tmp1_;
	_tmp2_ = steps;
	if (_tmp2_ != NULL) {
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		_tmp3_ = steps;
		_tmp4_ = gee_list_get_read_only_view (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (steps);
		steps = _tmp5_;
	} else {
		GeeList* _tmp6_;
		_tmp6_ = gee_list_empty (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free);
		_g_object_unref0 (steps);
		steps = _tmp6_;
	}
	result = steps;
	return result;
}

/**
     * Sets the configured folder path steps for a specific use.
     */
void
geary_account_information_set_folder_steps_for_use (GearyAccountInformation* self,
                                                    GearyFolderSpecialUse special,
                                                    GeeList* new_path)
{
	GeeList* existing = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	g_return_if_fail ((new_path == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (new_path, GEE_TYPE_LIST));
	_tmp0_ = self->priv->special_use_paths;
	_tmp1_ = gee_map_get (_tmp0_, (gpointer) ((gintptr) (&special)));
	existing = (GeeList*) _tmp1_;
	if (new_path != NULL) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (new_path, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GeeMap* _tmp5_;
		_tmp5_ = self->priv->special_use_paths;
		gee_map_set (_tmp5_, (gpointer) ((gintptr) (&special)), new_path);
	} else {
		GeeMap* _tmp6_;
		_tmp6_ = self->priv->special_use_paths;
		gee_map_unset (_tmp6_, (gpointer) ((gintptr) (&special)), NULL);
	}
	_tmp10_ = existing;
	if (_tmp10_ == NULL) {
		_tmp9_ = new_path != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		GeeList* _tmp12_;
		_tmp12_ = existing;
		if (_tmp12_ != NULL) {
			_tmp11_ = new_path == NULL;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp8_ = _tmp11_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		GeeList* _tmp14_;
		_tmp14_ = existing;
		if (_tmp14_ != NULL) {
			gboolean _tmp15_ = FALSE;
			GeeList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp16_ = existing;
			_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp18_ = _tmp17_;
			_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (new_path, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp20_ = _tmp19_;
			if (_tmp18_ != _tmp20_) {
				_tmp15_ = TRUE;
			} else {
				GeeList* _tmp21_;
				_tmp21_ = existing;
				_tmp15_ = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (new_path, GEE_TYPE_COLLECTION, GeeCollection));
			}
			_tmp13_ = _tmp15_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp7_ = _tmp13_;
	}
	if (_tmp7_) {
		g_signal_emit (self, geary_account_information_signals[GEARY_ACCOUNT_INFORMATION_CHANGED_SIGNAL], 0);
	}
	_g_object_unref0 (existing);
}

/**
     * Returns a folder path based on the configured steps for a use.
     */
GearyFolderPath*
geary_account_information_new_folder_path_for_use (GearyAccountInformation* self,
                                                   GearyFolderRoot* root,
                                                   GearyFolderSpecialUse use)
{
	GearyFolderPath* path = NULL;
	GeeList* steps = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	GeeList* _tmp2_;
	GearyFolderPath* result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	g_return_val_if_fail (GEARY_IS_FOLDER_ROOT (root), NULL);
	path = NULL;
	_tmp0_ = self->priv->special_use_paths;
	_tmp1_ = gee_map_get (_tmp0_, (gpointer) ((gintptr) (&use)));
	steps = (GeeList*) _tmp1_;
	_tmp2_ = steps;
	if (_tmp2_ != NULL) {
		GearyFolderPath* _tmp3_;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (root, GEARY_TYPE_FOLDER_PATH, GearyFolderPath));
		_g_object_unref0 (path);
		path = _tmp3_;
		{
			GeeList* _step_list = NULL;
			GeeList* _tmp4_;
			gint _step_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _step_index = 0;
			_tmp4_ = steps;
			_step_list = _tmp4_;
			_tmp5_ = _step_list;
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp7_ = _tmp6_;
			_step_size = _tmp7_;
			_step_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				gchar* step = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				GearyFolderPath* _tmp12_;
				const gchar* _tmp13_;
				GearyFolderPath* _tmp14_;
				_step_index = _step_index + 1;
				_tmp8_ = _step_index;
				_tmp9_ = _step_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _step_list;
				_tmp11_ = gee_list_get (_tmp10_, _step_index);
				step = (gchar*) _tmp11_;
				_tmp12_ = path;
				_tmp13_ = step;
				_tmp14_ = geary_folder_path_get_child (_tmp12_, _tmp13_, GEARY_TRILLIAN_UNKNOWN);
				_g_object_unref0 (path);
				path = _tmp14_;
				_g_free0 (step);
			}
		}
	}
	result = path;
	_g_object_unref0 (steps);
	return result;
}

/**
     * Returns the configured special folder use for a given path.
     */
GearyFolderSpecialUse
geary_account_information_get_folder_use_for_path (GearyAccountInformation* self,
                                                   GearyFolderPath* path)
{
	gchar** path_steps = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint path_steps_length1;
	gint _path_steps_size_;
	GearyFolderSpecialUse use = 0;
	GearyFolderSpecialUse result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), 0);
	g_return_val_if_fail (GEARY_IS_FOLDER_PATH (path), 0);
	_tmp1_ = geary_folder_path_as_array (path, &_tmp0_);
	path_steps = _tmp1_;
	path_steps_length1 = _tmp0_;
	_path_steps_size_ = path_steps_length1;
	use = GEARY_FOLDER_SPECIAL_USE_NONE;
	{
		GeeIterator* _entry_it = NULL;
		GeeMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp2_ = self->priv->special_use_paths;
		_tmp3_ = gee_map_get_entries (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_entry_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GeeList* use_steps = NULL;
			GeeMapEntry* _tmp11_;
			gconstpointer _tmp12_;
			gconstpointer _tmp13_;
			GeeList* _tmp14_;
			gboolean found = FALSE;
			gchar** _tmp15_;
			gint _tmp15__length1;
			GeeList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp8_ = _entry_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _entry_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			entry = (GeeMapEntry*) _tmp10_;
			_tmp11_ = entry;
			_tmp12_ = gee_map_entry_get_value (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _g_object_ref0 ((GeeList*) _tmp13_);
			use_steps = _tmp14_;
			found = FALSE;
			_tmp15_ = path_steps;
			_tmp15__length1 = path_steps_length1;
			_tmp16_ = use_steps;
			_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp18_ = _tmp17_;
			if (_tmp15__length1 == _tmp18_) {
				found = TRUE;
				{
					gint i = 0;
					gchar** _tmp19_;
					gint _tmp19__length1;
					_tmp19_ = path_steps;
					_tmp19__length1 = path_steps_length1;
					i = _tmp19__length1 - 1;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gchar** _tmp22_;
							gint _tmp22__length1;
							const gchar* _tmp23_;
							GeeList* _tmp24_;
							gpointer _tmp25_;
							gchar* _tmp26_;
							gboolean _tmp27_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = i;
								i = _tmp21_ - 1;
							}
							_tmp20_ = FALSE;
							if (!(i >= 0)) {
								break;
							}
							_tmp22_ = path_steps;
							_tmp22__length1 = path_steps_length1;
							_tmp23_ = _tmp22_[i];
							_tmp24_ = use_steps;
							_tmp25_ = gee_list_get (_tmp24_, i);
							_tmp26_ = (gchar*) _tmp25_;
							_tmp27_ = g_strcmp0 (_tmp23_, _tmp26_) != 0;
							_g_free0 (_tmp26_);
							if (_tmp27_) {
								found = FALSE;
								break;
							}
						}
					}
				}
			}
			if (found) {
				GeeMapEntry* _tmp28_;
				gconstpointer _tmp29_;
				gconstpointer _tmp30_;
				_tmp28_ = entry;
				_tmp29_ = gee_map_entry_get_key (_tmp28_);
				_tmp30_ = _tmp29_;
				use = *((GearyFolderSpecialUse*) _tmp30_);
				_g_object_unref0 (use_steps);
				_g_object_unref0 (entry);
				break;
			}
			_g_object_unref0 (use_steps);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	result = use;
	path_steps = (_vala_array_free (path_steps, path_steps_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * Returns the best credentials to use for the outgoing service.
     *
     * This method checks for an outgoing service that use incoming
     * service's credentials for authentication and if enabled,
     * returns those. If this method returns null, then outgoing
     * authentication should not be attempted for this account.
     */
GearyCredentials*
geary_account_information_get_outgoing_credentials (GearyAccountInformation* self)
{
	GearyCredentials* outgoing = NULL;
	GearyServiceInformation* _tmp0_;
	GearyCredentialsRequirement _tmp1_;
	GearyCredentialsRequirement _tmp2_;
	GearyCredentials* result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), NULL);
	outgoing = NULL;
	_tmp0_ = self->priv->_outgoing;
	_tmp1_ = geary_service_information_get_credentials_requirement (_tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING:
		{
			GearyServiceInformation* _tmp3_;
			GearyCredentials* _tmp4_;
			GearyCredentials* _tmp5_;
			GearyCredentials* _tmp6_;
			_tmp3_ = self->priv->_incoming;
			_tmp4_ = geary_service_information_get_credentials (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (outgoing);
			outgoing = _tmp6_;
			break;
		}
		case GEARY_CREDENTIALS_REQUIREMENT_CUSTOM:
		{
			GearyServiceInformation* _tmp7_;
			GearyCredentials* _tmp8_;
			GearyCredentials* _tmp9_;
			GearyCredentials* _tmp10_;
			_tmp7_ = self->priv->_outgoing;
			_tmp8_ = geary_service_information_get_credentials (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			_g_object_unref0 (outgoing);
			outgoing = _tmp10_;
			break;
		}
		case GEARY_CREDENTIALS_REQUIREMENT_NONE:
		{
			break;
		}
		default:
		break;
	}
	result = outgoing;
	return result;
}

static void
geary_account_information_load_outgoing_credentials_data_free (gpointer _data)
{
	GearyAccountInformationLoadOutgoingCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAccountInformationLoadOutgoingCredentialsData, _data_);
}

void
geary_account_information_load_outgoing_credentials (GearyAccountInformation* self,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyAccountInformationLoadOutgoingCredentialsData* _data_;
	GearyAccountInformation* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAccountInformationLoadOutgoingCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_account_information_load_outgoing_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_account_information_load_outgoing_credentials_co (_data_);
}

gboolean
geary_account_information_load_outgoing_credentials_finish (GearyAccountInformation* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	gboolean result;
	GearyAccountInformationLoadOutgoingCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Loads the authentication token for the outgoing service.
     *
     * Credentials are loaded from the mediator, thus it may yield for
     * some time.
     *
     * Returns true if the credential's token was successfully loaded
     * or are not needed (that is, if the credentials are null), or
     * false if the token could not be loaded and the service's
     * credentials are invalid.
     */
static void
geary_account_information_load_outgoing_credentials_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GearyAccountInformationLoadOutgoingCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_account_information_load_outgoing_credentials_co (_data_);
}

static gboolean
geary_account_information_load_outgoing_credentials_co (GearyAccountInformationLoadOutgoingCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_account_information_get_outgoing_credentials (_data_->self);
	_data_->creds = _data_->_tmp0_;
	_data_->loaded = TRUE;
	_data_->_tmp1_ = _data_->creds;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->_outgoing;
		_data_->_tmp3_ = geary_service_information_get_credentials_requirement (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		if (_data_->_tmp4_ == GEARY_CREDENTIALS_REQUIREMENT_USE_INCOMING) {
			_data_->_tmp6_ = _data_->self->priv->_mediator;
			_data_->_tmp7_ = _data_->self->priv->_incoming;
			_data_->_state_ = 1;
			geary_credentials_mediator_load_token (_data_->_tmp6_, _data_->self, _data_->_tmp7_, _data_->cancellable, geary_account_information_load_outgoing_credentials_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp5_ = geary_credentials_mediator_load_token_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->creds);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->loaded = _data_->_tmp5_;
		} else {
			_data_->_tmp9_ = _data_->self->priv->_mediator;
			_data_->_tmp10_ = _data_->self->priv->_outgoing;
			_data_->_state_ = 2;
			geary_credentials_mediator_load_token (_data_->_tmp9_, _data_->self, _data_->_tmp10_, _data_->cancellable, geary_account_information_load_outgoing_credentials_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = geary_credentials_mediator_load_token_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->creds);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->loaded = _data_->_tmp8_;
		}
	}
	_data_->result = _data_->loaded;
	_g_object_unref0 (_data_->creds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_account_information_load_incoming_credentials_data_free (gpointer _data)
{
	GearyAccountInformationLoadIncomingCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAccountInformationLoadIncomingCredentialsData, _data_);
}

void
geary_account_information_load_incoming_credentials (GearyAccountInformation* self,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyAccountInformationLoadIncomingCredentialsData* _data_;
	GearyAccountInformation* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyAccountInformationLoadIncomingCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_account_information_load_incoming_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_account_information_load_incoming_credentials_co (_data_);
}

gboolean
geary_account_information_load_incoming_credentials_finish (GearyAccountInformation* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	gboolean result;
	GearyAccountInformationLoadIncomingCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Loads the authentication token for the incoming service.
     *
     * Credentials are loaded from the mediator, thus it may yield for
     * some time.
     *
     * Returns true if the credential's token was successfully loaded
     * or are not needed (that is, if the credentials are null), or
     * false if the token could not be loaded and the service's
     * credentials are invalid.
     */
static void
geary_account_information_load_incoming_credentials_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	GearyAccountInformationLoadIncomingCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_account_information_load_incoming_credentials_co (_data_);
}

static gboolean
geary_account_information_load_incoming_credentials_co (GearyAccountInformationLoadIncomingCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_incoming;
	_data_->_tmp1_ = geary_service_information_get_credentials (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_data_->creds = _data_->_tmp3_;
	_data_->loaded = TRUE;
	_data_->_tmp4_ = _data_->creds;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp6_ = _data_->self->priv->_mediator;
		_data_->_tmp7_ = _data_->self->priv->_incoming;
		_data_->_state_ = 1;
		geary_credentials_mediator_load_token (_data_->_tmp6_, _data_->self, _data_->_tmp7_, _data_->cancellable, geary_account_information_load_incoming_credentials_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = geary_credentials_mediator_load_token_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->creds);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->loaded = _data_->_tmp5_;
	}
	_data_->result = _data_->loaded;
	_g_object_unref0 (_data_->creds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GearyAccountInformation* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->other);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
____lambda147_ (Block3Data* _data3_,
                GearyRFC822MailboxAddress* addr)
{
	GearyAccountInformation* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (addr), FALSE);
	_tmp0_ = geary_account_information_get_sender_mailboxes (_data3_->other);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), addr);
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
_____lambda147__gee_predicate (gconstpointer g,
                               gpointer self)
{
	gboolean result;
	result = ____lambda147_ (self, (GearyRFC822MailboxAddress*) g);
	return result;
}

gboolean
geary_account_information_equal_to (GearyAccountInformation* self,
                                    GearyAccountInformation* other)
{
	Block3Data* _data3_;
	GearyAccountInformation* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (self), FALSE);
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (other), FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (other);
	_g_object_unref0 (_data3_->other);
	_data3_->other = _tmp0_;
	if (self == _data3_->other) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = self->priv->_id;
		_tmp22_ = _data3_->other->priv->_id;
		if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
			gint _tmp23_;
			gint _tmp24_;
			_tmp23_ = self->priv->_ordinal;
			_tmp24_ = _data3_->other->priv->_ordinal;
			_tmp20_ = _tmp23_ == _tmp24_;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GearyCredentialsMediator* _tmp25_;
			GearyCredentialsMediator* _tmp26_;
			_tmp25_ = self->priv->_mediator;
			_tmp26_ = _data3_->other->priv->_mediator;
			_tmp19_ = _tmp25_ == _tmp26_;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GearyServiceProvider _tmp27_;
			GearyServiceProvider _tmp28_;
			_tmp27_ = self->priv->_service_provider;
			_tmp28_ = _data3_->other->priv->_service_provider;
			_tmp18_ = _tmp27_ == _tmp28_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp29_ = geary_account_information_get_service_label (self);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = geary_account_information_get_service_label (_data3_->other);
			_tmp33_ = _tmp32_;
			_tmp34_ = _tmp33_;
			_tmp17_ = g_strcmp0 (_tmp31_, _tmp34_) == 0;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp31_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp35_ = self->priv->_label;
			_tmp36_ = _data3_->other->priv->_label;
			_tmp16_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			GearyRFC822MailboxAddress* _tmp37_;
			GearyRFC822MailboxAddress* _tmp38_;
			GearyRFC822MailboxAddress* _tmp39_;
			GearyRFC822MailboxAddress* _tmp40_;
			GearyRFC822MailboxAddress* _tmp41_;
			GearyRFC822MailboxAddress* _tmp42_;
			_tmp37_ = geary_account_information_get_primary_mailbox (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp40_ = geary_account_information_get_primary_mailbox (_data3_->other);
			_tmp41_ = _tmp40_;
			_tmp42_ = _tmp41_;
			_tmp15_ = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_HASHABLE, GeeHashable), _tmp42_);
			_g_object_unref0 (_tmp42_);
			_g_object_unref0 (_tmp39_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GeeList* _tmp43_;
			GeeList* _tmp44_;
			GeeList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			GeeList* _tmp48_;
			GeeList* _tmp49_;
			GeeList* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			_tmp43_ = geary_account_information_get_sender_mailboxes (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = _tmp44_;
			_tmp46_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp47_ = _tmp46_;
			_tmp48_ = geary_account_information_get_sender_mailboxes (_data3_->other);
			_tmp49_ = _tmp48_;
			_tmp50_ = _tmp49_;
			_tmp51_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp52_ = _tmp51_;
			_tmp14_ = _tmp47_ == _tmp52_;
			_g_object_unref0 (_tmp50_);
			_g_object_unref0 (_tmp45_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			GeeList* _tmp53_;
			GeeList* _tmp54_;
			GeeList* _tmp55_;
			GearyIterable* _tmp56_;
			GearyIterable* _tmp57_;
			_tmp53_ = geary_account_information_get_sender_mailboxes (self);
			_tmp54_ = _tmp53_;
			_tmp55_ = _tmp54_;
			_tmp56_ = geary_traverse (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp57_ = _tmp56_;
			_tmp13_ = geary_iterable_all (_tmp57_, _____lambda147__gee_predicate, block3_data_ref (_data3_), block3_data_unref);
			_g_object_unref0 (_tmp57_);
			_g_object_unref0 (_tmp55_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			gint _tmp58_;
			gint _tmp59_;
			_tmp58_ = self->priv->_prefetch_period_days;
			_tmp59_ = _data3_->other->priv->_prefetch_period_days;
			_tmp12_ = _tmp58_ == _tmp59_;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gboolean _tmp60_;
			gboolean _tmp61_;
			gboolean _tmp62_;
			gboolean _tmp63_;
			_tmp60_ = geary_account_information_get_save_sent (self);
			_tmp61_ = _tmp60_;
			_tmp62_ = geary_account_information_get_save_sent (_data3_->other);
			_tmp63_ = _tmp62_;
			_tmp11_ = _tmp61_ == _tmp63_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gboolean _tmp64_;
			gboolean _tmp65_;
			_tmp64_ = self->priv->_save_drafts;
			_tmp65_ = _data3_->other->priv->_save_drafts;
			_tmp10_ = _tmp64_ == _tmp65_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gboolean _tmp66_;
			gboolean _tmp67_;
			_tmp66_ = self->priv->_use_signature;
			_tmp67_ = _data3_->other->priv->_use_signature;
			_tmp9_ = _tmp66_ == _tmp67_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			_tmp68_ = self->priv->_signature;
			_tmp69_ = _data3_->other->priv->_signature;
			_tmp8_ = g_strcmp0 (_tmp68_, _tmp69_) == 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GearyServiceInformation* _tmp70_;
			GearyServiceInformation* _tmp71_;
			_tmp70_ = self->priv->_incoming;
			_tmp71_ = _data3_->other->priv->_incoming;
			_tmp7_ = geary_service_information_equal_to (_tmp70_, _tmp71_);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GearyServiceInformation* _tmp72_;
			GearyServiceInformation* _tmp73_;
			_tmp72_ = self->priv->_outgoing;
			_tmp73_ = _data3_->other->priv->_outgoing;
			_tmp6_ = geary_service_information_equal_to (_tmp72_, _tmp73_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GeeMap* _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			GeeMap* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			_tmp74_ = self->priv->special_use_paths;
			_tmp75_ = gee_map_get_size (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = _data3_->other->priv->special_use_paths;
			_tmp78_ = gee_map_get_size (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp5_ = _tmp76_ == _tmp79_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GeeMap* _tmp80_;
			GeeMap* _tmp81_;
			_tmp80_ = self->priv->special_use_paths;
			_tmp81_ = _data3_->other->priv->special_use_paths;
			_tmp4_ = gee_map_has_all (_tmp80_, _tmp81_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GFile* _tmp82_;
			GFile* _tmp83_;
			_tmp82_ = self->priv->_config_dir;
			_tmp83_ = _data3_->other->priv->_config_dir;
			_tmp3_ = _tmp82_ == _tmp83_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GFile* _tmp84_;
			GFile* _tmp85_;
			_tmp84_ = self->priv->_data_dir;
			_tmp85_ = _data3_->other->priv->_data_dir;
			_tmp2_ = _tmp84_ == _tmp85_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	result = _tmp1_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

static void
geary_account_information_class_init (GearyAccountInformationClass * klass,
                                      gpointer klass_data)
{
	gint _tmp0_;
	geary_account_information_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAccountInformation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_account_information_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_account_information_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_account_information_finalize;
	/** A unique (engine-wide), opaque identifier for the account. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_ID_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** A unique (engine-wide) ordering for the account. */
	_tmp0_ = geary_account_information_next_ordinal;
	geary_account_information_next_ordinal = _tmp0_ + 1;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY] = g_param_spec_int ("ordinal", "ordinal", "ordinal", G_MININT, G_MAXINT, _tmp0_, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Specifies the email provider for this account. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY] = g_param_spec_enum ("service-provider", "service-provider", "service-provider", GEARY_TYPE_SERVICE_PROVIDER, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A human-readable label describing the email service provider.
	     *
	     * Known providers such as Gmail will have a label specified by
	     * clients, but other accounts can only really be identified by
	     * their server names. This attempts to extract a 'nice' value for
	     * label based on the service's host names.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY] = g_param_spec_string ("service-label", "service-label", "service-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * A unique human-readable display name for this account.
	     *
	     * Use this to display a string to the user that can uniquely
	     * identify this account. Note this value is mutable - it may
	     * change as a result of user action, so do not rely on it staying
	     * the same.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_DISPLAY_NAME_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * User-provided label for the account.
	     *
	     * This is not to be used in the UI (use `display_name` instead)
	     * and not transmitted on the wire or used in correspondence.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The default sender mailbox address for the account.
	     *
	     * This is the first mailbox in the {@link sender_mailboxes} list.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_PRIMARY_MAILBOX_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_PRIMARY_MAILBOX_PROPERTY] = g_param_spec_object ("primary-mailbox", "primary-mailbox", "primary-mailbox", GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A read-only list of sender mailbox address for the account.
	     *
	     * The first address in the list is the default address, others
	     * are essentially aliases.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SENDER_MAILBOXES_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SENDER_MAILBOXES_PROPERTY] = g_param_spec_object ("sender-mailboxes", "sender-mailboxes", "sender-mailboxes", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the account has more than one sender mailbox. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_HAS_SENDER_ALIASES_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_HAS_SENDER_ALIASES_PROPERTY] = g_param_spec_boolean ("has-sender-aliases", "has-sender-aliases", "has-sender-aliases", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies the number of days to be fetched by the account sync. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY] = g_param_spec_int ("prefetch-period-days", "prefetch-period-days", "prefetch-period-days", G_MININT, G_MAXINT, GEARY_ACCOUNT_INFORMATION_DEFAULT_PREFETCH_PERIOD_DAYS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Specifies if sent email should be saved to the Sent folder. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY] = g_param_spec_boolean ("save-sent", "save-sent", "save-sent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if drafts should be saved on the server. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY] = g_param_spec_boolean ("save-drafts", "save-drafts", "save-drafts", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The source of authentication credentials for this account.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY] = g_param_spec_object ("mediator", "mediator", "mediator", GEARY_TYPE_CREDENTIALS_MEDIATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY] = g_param_spec_object ("incoming", "incoming", "incoming", GEARY_TYPE_SERVICE_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY] = g_param_spec_object ("outgoing", "outgoing", "outgoing", GEARY_TYPE_SERVICE_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** A lock that can be used to ensure saving is serialised. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY] = g_param_spec_object ("write-lock", "write-lock", "write-lock", GEARY_NONBLOCKING_TYPE_MUTEX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Specifies if an email sig should be appended to new messages. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY] = g_param_spec_boolean ("use-signature", "use-signature", "use-signature", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Specifies the email sig to be appended to new messages. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY] = g_param_spec_string ("signature", "signature", "signature", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Location of the account's config directory.
	     *
	     * This directory is used to store small, per-account
	     * configuration files, including the account's settings key file.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY] = g_param_spec_object ("config-dir", "config-dir", "config-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Location of the account's data directory.
	     *
	     * This directory is used to store large, per-account data files
	     * such as the account database.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY, geary_account_information_properties[GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY] = g_param_spec_object ("data-dir", "data-dir", "data-dir", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Emitted when a service has reported an authentication failure.
	     *
	     * No further connection attempts will be made after this signal
	     * has been fired until the associated {@link ClientService} has
	     * been restarted. It is up to the client to prompt the user for
	     * updated credentials and restart the service.
	     */
	geary_account_information_signals[GEARY_ACCOUNT_INFORMATION_AUTHENTICATION_FAILURE_SIGNAL] = g_signal_new ("authentication-failure", GEARY_TYPE_ACCOUNT_INFORMATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_SERVICE_INFORMATION);
	/**
	     * Emitted when an endpoint has reported TLS certificate warnings.
	     *
	     * This signal is emitted when either of the incoming or outgoing
	     * endpoints emit the signal with the same name. It may be more
	     * convenient for clients to connect to this instead.
	     *
	     * No further connection attempts will be made after this signal
	     * has been fired until the associated {@link ClientService} has
	     * been restarted. It is up to the client to prompt the user to
	     * take action about the certificate (e.g. decide to pin it) then
	     * restart the service.
	     *
	     * @see Endpoint.untrusted_host
	     */
	geary_account_information_signals[GEARY_ACCOUNT_INFORMATION_UNTRUSTED_HOST_SIGNAL] = g_signal_new ("untrusted-host", GEARY_TYPE_ACCOUNT_INFORMATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, GEARY_TYPE_SERVICE_INFORMATION, GEARY_TYPE_ENDPOINT, g_tls_connection_get_type ());
	/** Emitted when the account settings have changed. */
	geary_account_information_signals[GEARY_ACCOUNT_INFORMATION_CHANGED_SIGNAL] = g_signal_new ("changed", GEARY_TYPE_ACCOUNT_INFORMATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_account_information_instance_init (GearyAccountInformation * self,
                                         gpointer klass)
{
	gint _tmp0_;
	gchar* _tmp1_;
	GearyNonblockingMutex* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeLinkedList* _tmp5_;
	self->priv = geary_account_information_get_instance_private (self);
	_tmp0_ = geary_account_information_next_ordinal;
	geary_account_information_next_ordinal = _tmp0_ + 1;
	self->priv->_ordinal = _tmp0_;
	self->priv->_service_label = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_label = _tmp1_;
	self->priv->_prefetch_period_days = GEARY_ACCOUNT_INFORMATION_DEFAULT_PREFETCH_PERIOD_DAYS;
	self->priv->_save_sent = TRUE;
	self->priv->_save_drafts = TRUE;
	_tmp2_ = geary_nonblocking_mutex_new ();
	self->priv->_write_lock = _tmp2_;
	self->priv->_use_signature = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->_signature = _tmp3_;
	self->priv->_config_dir = NULL;
	self->priv->_data_dir = NULL;
	_tmp4_ = gee_hash_map_new (GEARY_FOLDER_TYPE_SPECIAL_USE, (GBoxedCopyFunc) _geary_folder_special_use_dup, (GDestroyNotify) g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, __geary_account_information_special_use_paths_lambda140__gee_hash_data_func, NULL, NULL, __geary_account_information_special_use_paths_lambda141__gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->special_use_paths = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_MAP, GeeMap);
	_tmp5_ = gee_linked_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_mailboxes = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_LIST, GeeList);
}

static void
geary_account_information_finalize (GObject * obj)
{
	GearyAccountInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ACCOUNT_INFORMATION, GearyAccountInformation);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_service_label);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_mediator);
	_g_object_unref0 (self->priv->_incoming);
	_g_object_unref0 (self->priv->_outgoing);
	_g_object_unref0 (self->priv->_write_lock);
	_g_free0 (self->priv->_signature);
	_g_object_unref0 (self->priv->_config_dir);
	_g_object_unref0 (self->priv->_data_dir);
	_g_object_unref0 (self->priv->special_use_paths);
	_g_object_unref0 (self->priv->_mailboxes);
	G_OBJECT_CLASS (geary_account_information_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_account_information_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAccountInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_account_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAccountInformation), 0, (GInstanceInitFunc) geary_account_information_instance_init, NULL };
	GType geary_account_information_type_id;
	geary_account_information_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAccountInformation", &g_define_type_info, 0);
	GearyAccountInformation_private_offset = g_type_add_instance_private (geary_account_information_type_id, sizeof (GearyAccountInformationPrivate));
	return geary_account_information_type_id;
}

GType
geary_account_information_get_type (void)
{
	static gsize geary_account_information_type_id__once = 0;
	if (g_once_init_enter (&geary_account_information_type_id__once)) {
		GType geary_account_information_type_id;
		geary_account_information_type_id = geary_account_information_get_type_once ();
		g_once_init_leave (&geary_account_information_type_id__once, geary_account_information_type_id);
	}
	return geary_account_information_type_id__once;
}

static void
_vala_geary_account_information_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyAccountInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT_INFORMATION, GearyAccountInformation);
	switch (property_id) {
		case GEARY_ACCOUNT_INFORMATION_ID_PROPERTY:
		g_value_set_string (value, geary_account_information_get_id (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY:
		g_value_set_int (value, geary_account_information_get_ordinal (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY:
		g_value_set_enum (value, geary_account_information_get_service_provider (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY:
		g_value_take_string (value, geary_account_information_get_service_label (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, geary_account_information_get_display_name (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY:
		g_value_set_string (value, geary_account_information_get_label (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_PRIMARY_MAILBOX_PROPERTY:
		g_value_take_object (value, geary_account_information_get_primary_mailbox (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SENDER_MAILBOXES_PROPERTY:
		g_value_take_object (value, geary_account_information_get_sender_mailboxes (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_HAS_SENDER_ALIASES_PROPERTY:
		g_value_set_boolean (value, geary_account_information_get_has_sender_aliases (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY:
		g_value_set_int (value, geary_account_information_get_prefetch_period_days (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY:
		g_value_set_boolean (value, geary_account_information_get_save_sent (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY:
		g_value_set_boolean (value, geary_account_information_get_save_drafts (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY:
		g_value_set_object (value, geary_account_information_get_mediator (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY:
		g_value_set_object (value, geary_account_information_get_incoming (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY:
		g_value_set_object (value, geary_account_information_get_outgoing (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY:
		g_value_set_object (value, geary_account_information_get_write_lock (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY:
		g_value_set_boolean (value, geary_account_information_get_use_signature (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY:
		g_value_set_string (value, geary_account_information_get_signature (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY:
		g_value_set_object (value, geary_account_information_get_config_dir (self));
		break;
		case GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY:
		g_value_set_object (value, geary_account_information_get_data_dir (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_account_information_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearyAccountInformation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ACCOUNT_INFORMATION, GearyAccountInformation);
	switch (property_id) {
		case GEARY_ACCOUNT_INFORMATION_ID_PROPERTY:
		geary_account_information_set_id (self, g_value_get_string (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_ORDINAL_PROPERTY:
		geary_account_information_set_ordinal (self, g_value_get_int (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_SERVICE_PROVIDER_PROPERTY:
		geary_account_information_set_service_provider (self, g_value_get_enum (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_SERVICE_LABEL_PROPERTY:
		geary_account_information_set_service_label (self, g_value_get_string (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_LABEL_PROPERTY:
		geary_account_information_set_label (self, g_value_get_string (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_PREFETCH_PERIOD_DAYS_PROPERTY:
		geary_account_information_set_prefetch_period_days (self, g_value_get_int (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_SAVE_SENT_PROPERTY:
		geary_account_information_set_save_sent (self, g_value_get_boolean (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_SAVE_DRAFTS_PROPERTY:
		geary_account_information_set_save_drafts (self, g_value_get_boolean (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_MEDIATOR_PROPERTY:
		geary_account_information_set_mediator (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_INCOMING_PROPERTY:
		geary_account_information_set_incoming (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_OUTGOING_PROPERTY:
		geary_account_information_set_outgoing (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_WRITE_LOCK_PROPERTY:
		geary_account_information_set_write_lock (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_USE_SIGNATURE_PROPERTY:
		geary_account_information_set_use_signature (self, g_value_get_boolean (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_SIGNATURE_PROPERTY:
		geary_account_information_set_signature (self, g_value_get_string (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_CONFIG_DIR_PROPERTY:
		geary_account_information_set_config_dir (self, g_value_get_object (value));
		break;
		case GEARY_ACCOUNT_INFORMATION_DATA_DIR_PROPERTY:
		geary_account_information_set_data_dir (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

