/* util.c generated by valac 0.56.18, the Vala compiler
 * generated from util.vala, do not modify */

#include "libdino.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>
#include <dino_i18n.h>
#include <libintl.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _DinoParamSpecSearchPathGenerator DinoParamSpecSearchPathGenerator;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
typedef struct _DinoComputeFileHashesData DinoComputeFileHashesData;

struct _DinoSearchPathGeneratorPrivate {
	gchar* _exec_path;
};

struct _DinoParamSpecSearchPathGenerator {
	GParamSpec parent_instance;
};

struct _DinoComputeFileHashesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* file;
	GeeList* checksum_types;
	GeeHashMap* result;
	GChecksum** checksums;
	gint _tmp0_;
	gint _tmp1_;
	GChecksum** _tmp2_;
	gint checksums_length1;
	gint _checksums_size_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GChecksum** _tmp7_;
	gint _tmp7__length1;
	gpointer _tmp8_;
	GChecksum* _tmp9_;
	GFileInputStream* stream;
	GFileInputStream* _tmp10_;
	guint8 fbuf[1024];
	gsize size;
	gssize _tmp11_;
	GFileInputStream* _tmp12_;
	gint _vala1_i;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GChecksum** _tmp17_;
	gint _tmp17__length1;
	GChecksum* _tmp18_;
	GeeHashMap* ret;
	GeeHashMap* _tmp19_;
	gint _vala2_i;
	gboolean _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GChecksumType checksum_type;
	gpointer _tmp24_;
	guint8* digest;
	guint8* _tmp25_;
	gint digest_length1;
	gint _digest_size_;
	gsize length;
	guint8* _tmp26_;
	gint _tmp26__length1;
	GChecksum** _tmp27_;
	gint _tmp27__length1;
	GChecksum* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gchar* computed_hash;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gchar* _tmp31_;
	GeeHashMap* _tmp32_;
	const gchar* _tmp33_;
	GError* _inner_error0_;
};

static gint DinoSearchPathGenerator_private_offset;
static gpointer dino_search_path_generator_parent_class = NULL;

static void dino_search_path_generator_set_exec_path (DinoSearchPathGenerator* self,
                                               const gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void dino_search_path_generator_finalize (DinoSearchPathGenerator * obj);
static GType dino_search_path_generator_get_type_once (void);
static void dino_compute_file_hashes_data_free (gpointer _data);
static gboolean dino_compute_file_hashes_co (DinoComputeFileHashesData* _data_);
static void dino_compute_file_hashes_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_search_path_generator_get_instance_private (DinoSearchPathGenerator* self)
{
	return G_STRUCT_MEMBER_P (self, DinoSearchPathGenerator_private_offset);
}

DinoSearchPathGenerator*
dino_search_path_generator_construct (GType object_type,
                                      const gchar* exec_path)
{
	DinoSearchPathGenerator* self = NULL;
	self = (DinoSearchPathGenerator*) g_type_create_instance (object_type);
	dino_search_path_generator_set_exec_path (self, exec_path);
	return self;
}

DinoSearchPathGenerator*
dino_search_path_generator_new (const gchar* exec_path)
{
	return dino_search_path_generator_construct (DINO_TYPE_SEARCH_PATH_GENERATOR, exec_path);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
dino_search_path_generator_get_locale_path (DinoSearchPathGenerator* self,
                                            const gchar* gettext_package,
                                            const gchar* locale_install_dir)
{
	gchar* locale_dir = NULL;
	gchar* dirname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gettext_package != NULL, NULL);
	g_return_val_if_fail (locale_install_dir != NULL, NULL);
	locale_dir = NULL;
	_tmp0_ = self->priv->_exec_path;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	dirname = _tmp1_;
	_tmp4_ = dirname;
	if (string_contains (_tmp4_, "dino")) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = dirname;
		_tmp3_ = g_strcmp0 (_tmp5_, ".") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = dirname;
		_tmp2_ = string_contains (_tmp6_, "build");
	}
	if (_tmp2_) {
		gchar* exec_locale = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = dirname;
		_tmp8_ = g_build_filename (_tmp7_, "locale", NULL);
		exec_locale = _tmp8_;
		_tmp9_ = exec_locale;
		_tmp10_ = g_strconcat (gettext_package, ".mo", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_build_filename (_tmp9_, "en", "LC_MESSAGES", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_IS_REGULAR);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		if (_tmp14_) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = exec_locale;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (locale_dir);
			locale_dir = _tmp16_;
		}
		_g_free0 (exec_locale);
	}
	_tmp18_ = dirname;
	if (g_strcmp0 (_tmp18_, ".") == 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp19_ = dirname;
		_tmp20_ = g_path_get_basename (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = g_strcmp0 (_tmp21_, "main") == 0;
		_g_free0 (_tmp21_);
	}
	if (_tmp17_) {
		if (g_strcmp0 (gettext_package, "dino") == 0) {
			gchar* exec_locale = NULL;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gboolean _tmp29_;
			_tmp22_ = dirname;
			_tmp23_ = g_build_filename (_tmp22_, "po", NULL);
			exec_locale = _tmp23_;
			_tmp24_ = exec_locale;
			_tmp25_ = g_strconcat (gettext_package, ".mo", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_build_filename (_tmp24_, "en", "LC_MESSAGES", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_file_test (_tmp28_, G_FILE_TEST_IS_REGULAR);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			if (_tmp29_) {
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = exec_locale;
				_tmp31_ = g_strdup (_tmp30_);
				_g_free0 (locale_dir);
				locale_dir = _tmp31_;
			}
			_g_free0 (exec_locale);
		} else {
			if (g_str_has_prefix (gettext_package, "dino-")) {
				gchar* exec_locale = NULL;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gboolean _tmp42_;
				_tmp32_ = dirname;
				_tmp33_ = string_substring (gettext_package, (glong) 5, (glong) -1);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_build_filename (_tmp32_, "..", "plugins", _tmp34_, "po", NULL);
				_tmp36_ = _tmp35_;
				_g_free0 (_tmp34_);
				exec_locale = _tmp36_;
				_tmp37_ = exec_locale;
				_tmp38_ = g_strconcat (gettext_package, ".mo", NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_build_filename (_tmp37_, "en", "LC_MESSAGES", _tmp39_, NULL);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_file_test (_tmp41_, G_FILE_TEST_IS_REGULAR);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				if (_tmp42_) {
					const gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp43_ = exec_locale;
					_tmp44_ = g_strdup (_tmp43_);
					_g_free0 (locale_dir);
					locale_dir = _tmp44_;
				}
				_g_free0 (exec_locale);
			}
		}
	}
	_tmp46_ = locale_dir;
	_tmp45_ = _tmp46_;
	if (_tmp45_ == NULL) {
		_tmp45_ = locale_install_dir;
	}
	_tmp47_ = g_strdup (_tmp45_);
	result = _tmp47_;
	_g_free0 (dirname);
	_g_free0 (locale_dir);
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
dino_search_path_generator_get_plugin_paths (DinoSearchPathGenerator* self,
                                             gint* result_length1)
{
	gchar** search_paths = NULL;
	gchar** _tmp0_;
	gint search_paths_length1;
	gint _search_paths_size_;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* exec_path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	search_paths = _tmp0_;
	search_paths_length1 = 0;
	_search_paths_size_ = search_paths_length1;
	_tmp1_ = g_getenv ("DINO_PLUGIN_DIR");
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_getenv ("DINO_PLUGIN_DIR");
		_tmp3_ = g_strdup (_tmp2_);
		_vala_array_add3 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp3_);
	}
	_tmp4_ = g_get_home_dir ();
	_tmp5_ = g_build_filename (_tmp4_, ".local", "lib", "dino", "plugins", NULL);
	_vala_array_add4 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp5_);
	_tmp6_ = self->priv->_exec_path;
	_tmp7_ = g_strdup (_tmp6_);
	exec_path = _tmp7_;
	_tmp8_ = exec_path;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gchar* dirname = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gboolean _tmp52_;
		_tmp9_ = exec_path;
		if (!string_contains (_tmp9_, G_DIR_SEPARATOR_S)) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->priv->_exec_path;
			_tmp11_ = g_find_program_in_path (_tmp10_);
			_g_free0 (exec_path);
			exec_path = _tmp11_;
		}
		_tmp12_ = exec_path;
		_tmp13_ = g_path_get_dirname (_tmp12_);
		dirname = _tmp13_;
		_tmp17_ = dirname;
		if (string_contains (_tmp17_, "dino")) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp18_;
			_tmp18_ = dirname;
			_tmp16_ = g_strcmp0 (_tmp18_, ".") == 0;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = dirname;
			_tmp15_ = string_contains (_tmp19_, "build");
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp20_ = dirname;
			_tmp21_ = g_path_get_basename (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp14_ = g_strcmp0 (_tmp22_, "main") == 0;
			_g_free0 (_tmp22_);
		}
		if (_tmp14_) {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp23_ = exec_path;
			_tmp24_ = g_path_get_dirname (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_build_filename (_tmp25_, "plugins", NULL);
			_vala_array_add5 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp26_);
			_g_free0 (_tmp25_);
		}
		_tmp28_ = dirname;
		if (g_strcmp0 (_tmp28_, ".") == 0) {
			_tmp27_ = TRUE;
		} else {
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp29_ = dirname;
			_tmp30_ = g_path_get_basename (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = g_strcmp0 (_tmp31_, "main") == 0;
			_g_free0 (_tmp31_);
		}
		if (_tmp27_) {
			{
				GDir* plugin_dir = NULL;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				GDir* _tmp35_;
				GDir* _tmp36_;
				gchar* entry = NULL;
				_tmp32_ = dirname;
				_tmp33_ = g_build_path (G_DIR_SEPARATOR_S, _tmp32_, "..", "plugins", NULL);
				_tmp34_ = _tmp33_;
				_tmp35_ = g_dir_open (_tmp34_, (guint) 0, &_inner_error0_);
				_tmp36_ = _tmp35_;
				_g_free0 (_tmp34_);
				plugin_dir = _tmp36_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_FILE_ERROR) {
						goto __catch0_g_file_error;
					}
					_g_free0 (dirname);
					_g_free0 (exec_path);
					search_paths = (_vala_array_free (search_paths, search_paths_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				entry = NULL;
				while (TRUE) {
					GDir* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					const gchar* _tmp40_;
					gchar* plugin_subdir = NULL;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp37_ = plugin_dir;
					_tmp38_ = g_dir_read_name (_tmp37_);
					_tmp39_ = g_strdup (_tmp38_);
					_g_free0 (entry);
					entry = _tmp39_;
					_tmp40_ = entry;
					if (!(_tmp40_ != NULL)) {
						break;
					}
					_tmp41_ = dirname;
					_tmp42_ = entry;
					_tmp43_ = g_build_path (G_DIR_SEPARATOR_S, _tmp41_, "..", "plugins", _tmp42_, NULL);
					plugin_subdir = _tmp43_;
					{
						const gchar* _tmp44_;
						GDir* _tmp45_;
						GDir* _tmp46_;
						const gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp44_ = plugin_subdir;
						_tmp45_ = g_dir_open (_tmp44_, (guint) 0, &_inner_error0_);
						_tmp46_ = _tmp45_;
						_g_dir_close0 (_tmp46_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == G_FILE_ERROR) {
								goto __catch1_g_file_error;
							}
							_g_free0 (plugin_subdir);
							_g_free0 (entry);
							_g_dir_close0 (plugin_dir);
							_g_free0 (dirname);
							_g_free0 (exec_path);
							search_paths = (_vala_array_free (search_paths, search_paths_length1, (GDestroyNotify) g_free), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_tmp47_ = plugin_subdir;
						_tmp48_ = g_strdup (_tmp47_);
						_vala_array_add6 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp48_);
					}
					goto __finally1;
					__catch1_g_file_error:
					{
						g_clear_error (&_inner_error0_);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (plugin_subdir);
						_g_free0 (entry);
						_g_dir_close0 (plugin_dir);
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						_g_free0 (dirname);
						_g_free0 (exec_path);
						search_paths = (_vala_array_free (search_paths, search_paths_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_g_free0 (plugin_subdir);
				}
				_g_free0 (entry);
				_g_dir_close0 (plugin_dir);
			}
			goto __finally0;
			__catch0_g_file_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (dirname);
				_g_free0 (exec_path);
				search_paths = (_vala_array_free (search_paths, search_paths_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp49_ = dirname;
		_tmp50_ = g_path_get_basename (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strcmp0 (_tmp51_, "bin") == 0;
		_g_free0 (_tmp51_);
		if (_tmp52_) {
			const gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp53_ = exec_path;
			_tmp54_ = g_path_get_dirname (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_path_get_dirname (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_build_filename (_tmp57_, DINO_SYSTEM_LIBDIR_NAME, "dino", "plugins", NULL);
			_vala_array_add7 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp58_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
		}
		_g_free0 (dirname);
	}
	_tmp59_ = g_strdup (DINO_SYSTEM_PLUGIN_DIR);
	_vala_array_add8 (&search_paths, &search_paths_length1, &_search_paths_size_, _tmp59_);
	_tmp60_ = search_paths;
	_tmp60__length1 = search_paths_length1;
	if (result_length1) {
		*result_length1 = _tmp60__length1;
	}
	result = _tmp60_;
	_g_free0 (exec_path);
	return result;
}

const gchar*
dino_search_path_generator_get_exec_path (DinoSearchPathGenerator* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec_path;
	result = _tmp0_;
	return result;
}

static void
dino_search_path_generator_set_exec_path (DinoSearchPathGenerator* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_exec_path);
	self->priv->_exec_path = _tmp0_;
}

static void
dino_value_search_path_generator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
dino_value_search_path_generator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		dino_search_path_generator_unref (value->data[0].v_pointer);
	}
}

static void
dino_value_search_path_generator_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = dino_search_path_generator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
dino_value_search_path_generator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
dino_value_search_path_generator_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DinoSearchPathGenerator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = dino_search_path_generator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
dino_value_search_path_generator_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	DinoSearchPathGenerator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = dino_search_path_generator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
dino_param_spec_search_path_generator (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	DinoParamSpecSearchPathGenerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, DINO_TYPE_SEARCH_PATH_GENERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
dino_value_get_search_path_generator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DINO_TYPE_SEARCH_PATH_GENERATOR), NULL);
	return value->data[0].v_pointer;
}

void
dino_value_set_search_path_generator (GValue* value,
                                      gpointer v_object)
{
	DinoSearchPathGenerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DINO_TYPE_SEARCH_PATH_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DINO_TYPE_SEARCH_PATH_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		dino_search_path_generator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dino_search_path_generator_unref (old);
	}
}

void
dino_value_take_search_path_generator (GValue* value,
                                       gpointer v_object)
{
	DinoSearchPathGenerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DINO_TYPE_SEARCH_PATH_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DINO_TYPE_SEARCH_PATH_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		dino_search_path_generator_unref (old);
	}
}

static void
dino_search_path_generator_class_init (DinoSearchPathGeneratorClass * klass,
                                       gpointer klass_data)
{
	dino_search_path_generator_parent_class = g_type_class_peek_parent (klass);
	((DinoSearchPathGeneratorClass *) klass)->finalize = dino_search_path_generator_finalize;
	g_type_class_adjust_private_offset (klass, &DinoSearchPathGenerator_private_offset);
}

static void
dino_search_path_generator_instance_init (DinoSearchPathGenerator * self,
                                          gpointer klass)
{
	self->priv = dino_search_path_generator_get_instance_private (self);
	self->ref_count = 1;
}

static void
dino_search_path_generator_finalize (DinoSearchPathGenerator * obj)
{
	DinoSearchPathGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_TYPE_SEARCH_PATH_GENERATOR, DinoSearchPathGenerator);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_exec_path);
}

static GType
dino_search_path_generator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { dino_value_search_path_generator_init, dino_value_search_path_generator_free_value, dino_value_search_path_generator_copy_value, dino_value_search_path_generator_peek_pointer, "p", dino_value_search_path_generator_collect_value, "p", dino_value_search_path_generator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DinoSearchPathGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_search_path_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoSearchPathGenerator), 0, (GInstanceInitFunc) dino_search_path_generator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType dino_search_path_generator_type_id;
	dino_search_path_generator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DinoSearchPathGenerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DinoSearchPathGenerator_private_offset = g_type_add_instance_private (dino_search_path_generator_type_id, sizeof (DinoSearchPathGeneratorPrivate));
	return dino_search_path_generator_type_id;
}

GType
dino_search_path_generator_get_type (void)
{
	static volatile gsize dino_search_path_generator_type_id__once = 0;
	if (g_once_init_enter (&dino_search_path_generator_type_id__once)) {
		GType dino_search_path_generator_type_id;
		dino_search_path_generator_type_id = dino_search_path_generator_get_type_once ();
		g_once_init_leave (&dino_search_path_generator_type_id__once, dino_search_path_generator_type_id);
	}
	return dino_search_path_generator_type_id__once;
}

gpointer
dino_search_path_generator_ref (gpointer instance)
{
	DinoSearchPathGenerator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
dino_search_path_generator_unref (gpointer instance)
{
	DinoSearchPathGenerator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DINO_SEARCH_PATH_GENERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gchar*
dino_get_storage_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "dino", NULL);
	result = _tmp1_;
	return result;
}

gchar*
dino_get_cache_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "dino", NULL);
	result = _tmp1_;
	return result;
}

void
dino_internationalize (const gchar* gettext_package,
                       const gchar* locales_dir)
{
	g_return_if_fail (gettext_package != NULL);
	g_return_if_fail (locales_dir != NULL);
	bind_textdomain_codeset (gettext_package, "UTF-8");
	bindtextdomain (gettext_package, locales_dir);
}

static void
dino_compute_file_hashes_data_free (gpointer _data)
{
	DinoComputeFileHashesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->checksum_types);
	_g_object_unref0 (_data_->result);
	g_slice_free (DinoComputeFileHashesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
dino_compute_file_hashes (GFile* file,
                          GeeList* checksum_types,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	DinoComputeFileHashesData* _data_;
	GFile* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (file != NULL);
	g_return_if_fail (checksum_types != NULL);
	_data_ = g_slice_new0 (DinoComputeFileHashesData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, dino_compute_file_hashes_data_free);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp0_;
	_tmp1_ = _g_object_ref0 (checksum_types);
	_g_object_unref0 (_data_->checksum_types);
	_data_->checksum_types = _tmp1_;
	dino_compute_file_hashes_co (_data_);
}

GeeHashMap*
dino_compute_file_hashes_finish (GAsyncResult* _res_)
{
	GeeHashMap* result;
	DinoComputeFileHashesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
dino_compute_file_hashes_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	DinoComputeFileHashesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dino_compute_file_hashes_co (_data_);
}

static gboolean
dino_compute_file_hashes_co (DinoComputeFileHashesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_collection_get_size ((GeeCollection*) _data_->checksum_types);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_new0 (GChecksum*, _data_->_tmp1_ + 1);
	_data_->checksums = _data_->_tmp2_;
	_data_->checksums_length1 = _data_->_tmp1_;
	_data_->_checksums_size_ = _data_->checksums_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp3_) {
					_data_->_tmp4_ = _data_->i;
					_data_->i = _data_->_tmp4_ + 1;
				}
				_data_->_tmp3_ = FALSE;
				_data_->_tmp5_ = gee_collection_get_size ((GeeCollection*) _data_->checksum_types);
				_data_->_tmp6_ = _data_->_tmp5_;
				if (!(_data_->i < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = _data_->checksums;
				_data_->_tmp7__length1 = _data_->checksums_length1;
				_data_->_tmp8_ = gee_list_get (_data_->checksum_types, _data_->i);
				_data_->_tmp9_ = g_checksum_new ((GChecksumType) ((gintptr) _data_->_tmp8_));
				_g_checksum_free0 (_data_->_tmp7_[_data_->i]);
				_data_->_tmp7_[_data_->i] = _data_->_tmp9_;
			}
		}
	}
	_data_->_state_ = 1;
	g_file_read_async (_data_->file, G_PRIORITY_DEFAULT, NULL, dino_compute_file_hashes_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp10_ = g_file_read_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
	_data_->stream = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->checksums = (_vala_array_free (_data_->checksums, _data_->checksums_length1, (GDestroyNotify) g_checksum_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp12_ = _data_->stream;
		_data_->_state_ = 2;
		g_input_stream_read_async ((GInputStream*) _data_->_tmp12_, _data_->fbuf, (gsize) 1024, G_PRIORITY_DEFAULT, NULL, dino_compute_file_hashes_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp11_ = g_input_stream_read_finish ((GInputStream*) _data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			_data_->checksums = (_vala_array_free (_data_->checksums, _data_->checksums_length1, (GDestroyNotify) g_checksum_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->size = (gsize) _data_->_tmp11_;
		if (!(_data_->size > ((gsize) 0))) {
			break;
		}
		{
			_data_->_vala1_i = 0;
			{
				_data_->_tmp13_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp13_) {
						_data_->_tmp14_ = _data_->_vala1_i;
						_data_->_vala1_i = _data_->_tmp14_ + 1;
					}
					_data_->_tmp13_ = FALSE;
					_data_->_tmp15_ = gee_collection_get_size ((GeeCollection*) _data_->checksum_types);
					_data_->_tmp16_ = _data_->_tmp15_;
					if (!(_data_->_vala1_i < _data_->_tmp16_)) {
						break;
					}
					_data_->_tmp17_ = _data_->checksums;
					_data_->_tmp17__length1 = _data_->checksums_length1;
					_data_->_tmp18_ = _data_->_tmp17_[_data_->_vala1_i];
					g_checksum_update (_data_->_tmp18_, _data_->fbuf, _data_->size);
				}
			}
		}
	}
	_data_->_tmp19_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->ret = _data_->_tmp19_;
	{
		_data_->_vala2_i = 0;
		{
			_data_->_tmp20_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp20_) {
					_data_->_tmp21_ = _data_->_vala2_i;
					_data_->_vala2_i = _data_->_tmp21_ + 1;
				}
				_data_->_tmp20_ = FALSE;
				_data_->_tmp22_ = gee_collection_get_size ((GeeCollection*) _data_->checksum_types);
				_data_->_tmp23_ = _data_->_tmp22_;
				if (!(_data_->_vala2_i < _data_->_tmp23_)) {
					break;
				}
				_data_->_tmp24_ = gee_list_get (_data_->checksum_types, _data_->_vala2_i);
				_data_->checksum_type = (GChecksumType) ((gintptr) _data_->_tmp24_);
				_data_->_tmp25_ = g_new0 (guint8, 64);
				_data_->digest = _data_->_tmp25_;
				_data_->digest_length1 = 64;
				_data_->_digest_size_ = _data_->digest_length1;
				_data_->_tmp26_ = _data_->digest;
				_data_->_tmp26__length1 = _data_->digest_length1;
				_data_->length = (gsize) _data_->_tmp26__length1;
				_data_->_tmp27_ = _data_->checksums;
				_data_->_tmp27__length1 = _data_->checksums_length1;
				_data_->_tmp28_ = _data_->_tmp27_[_data_->_vala2_i];
				_data_->_tmp29_ = _data_->digest;
				_data_->_tmp29__length1 = _data_->digest_length1;
				g_checksum_get_digest (_data_->_tmp28_, _data_->_tmp29_, &_data_->length);
				_data_->_tmp30_ = _data_->digest;
				_data_->_tmp30__length1 = _data_->digest_length1;
				_data_->_tmp31_ = g_base64_encode (_data_->_tmp30_ + 0, (gint) (((gint) _data_->length) - 0));
				_data_->computed_hash = _data_->_tmp31_;
				_data_->_tmp32_ = _data_->ret;
				_data_->_tmp33_ = _data_->computed_hash;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp32_, (gpointer) ((gintptr) _data_->checksum_type), _data_->_tmp33_);
				_g_free0 (_data_->computed_hash);
				_data_->digest = (g_free (_data_->digest), NULL);
			}
		}
	}
	_data_->result = _data_->ret;
	_g_object_unref0 (_data_->stream);
	_data_->checksums = (_vala_array_free (_data_->checksums, _data_->checksums_length1, (GDestroyNotify) g_checksum_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

