/* BackendDrive.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackendDrive.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <unistd.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_BACKEND_DRIVE_0_PROPERTY,
	DEJA_DUP_BACKEND_DRIVE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_drive_properties[DEJA_DUP_BACKEND_DRIVE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupBackendDriveCleanupData DejaDupBackendDriveCleanupData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendDriveIsReadyData DejaDupBackendDriveIsReadyData;

#define DEJA_DUP_TYPE_BACKEND_ERROR (deja_dup_backend_error_get_type ())
typedef struct _DejaDupBackendDriveMountInternalData DejaDupBackendDriveMountInternalData;
typedef struct _DejaDupBackendDriveMountData DejaDupBackendDriveMountData;
typedef struct _Block1Data Block1Data;
typedef struct _DejaDupBackendDriveWaitForVolumeData DejaDupBackendDriveWaitForVolumeData;

struct _DejaDupBackendDriveCleanupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendDrive* self;
};

struct _DejaDupBackendDriveIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendDrive* self;
	gchar* reason;
	gchar* message;
	gboolean result;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	gboolean _tmp2_;
	gchar* name;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
};

typedef enum  {
	DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED
} DejaDupBackendError;
#define DEJA_DUP_BACKEND_ERROR deja_dup_backend_error_quark ()

struct _DejaDupBackendDriveMountInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendDrive* self;
	GVolume* vol;
	gboolean result;
	GMount* _tmp0_;
	GMount* _tmp1_;
	gboolean _tmp2_;
	GMountOperation* _tmp3_;
	GMountOperation* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	gboolean _tmp7_;
	GError* _inner_error0_;
};

struct _DejaDupBackendDriveMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendDrive* self;
	gboolean result;
	GVolume* vol;
	GVolume* _tmp0_;
	gboolean rv;
	GVolume* _tmp1_;
	GVolume* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	DejaDupBackendDrive* self;
	gpointer _async_data_;
};

struct _DejaDupBackendDriveWaitForVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendDrive* self;
	GVolume* result;
	Block1Data* _data1_;
	GVolume* vol;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GVolumeMonitor* monitor;
	GVolumeMonitor* _tmp2_;
	gchar* name;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gulong sigid;
	GVolumeMonitor* _tmp9_;
	gulong _tmp10_;
	GVolumeMonitor* _tmp11_;
	GVolume* _tmp12_;
	GVolume* _tmp13_;
	GVolume* _tmp14_;
	GError* _inner_error0_;
};

static gpointer deja_dup_backend_drive_parent_class = NULL;

VALA_EXTERN GFile* deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self);
static void deja_dup_backend_drive_real_cleanup_data_free (gpointer _data);
static void deja_dup_backend_drive_real_cleanup (DejaDupBackend* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean deja_dup_backend_drive_real_cleanup_co (DejaDupBackendDriveCleanupData* _data_);
static void deja_dup_backend_drive_cleanup_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gchar* deja_dup_backend_drive_get_folder (DejaDupBackendDrive* self);
static GVolume* deja_dup_backend_drive_get_volume (DejaDupBackendDrive* self);
static GFile* deja_dup_backend_drive_real_get_root_from_settings (DejaDupBackendFile* base);
static GFile* deja_dup_backend_drive_real_get_file_from_settings (DejaDupBackendFile* base);
static gchar* deja_dup_backend_drive_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_drive_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_drive_real_is_ready (DejaDupBackend* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean deja_dup_backend_drive_real_is_ready_co (DejaDupBackendDriveIsReadyData* _data_);
static GIcon* deja_dup_backend_drive_real_get_icon (DejaDupBackend* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_backend_drive_mount_internal_data_free (gpointer _data);
static void deja_dup_backend_drive_mount_internal (DejaDupBackendDrive* self,
                                            GVolume* vol,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static gboolean deja_dup_backend_drive_mount_internal_finish (DejaDupBackendDrive* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean deja_dup_backend_drive_mount_internal_co (DejaDupBackendDriveMountInternalData* _data_);
static void deja_dup_backend_drive_mount_internal_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN GQuark deja_dup_backend_error_quark (void);
VALA_EXTERN GType deja_dup_backend_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void deja_dup_wait (guint secs,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_);
VALA_EXTERN void deja_dup_wait_finish (GAsyncResult* _res_);
static void deja_dup_backend_drive_real_mount_data_free (gpointer _data);
static void deja_dup_backend_drive_real_mount (DejaDupBackendFile* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean deja_dup_backend_drive_real_mount_co (DejaDupBackendDriveMountData* _data_);
static void deja_dup_backend_drive_wait_for_volume (DejaDupBackendDrive* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static GVolume* deja_dup_backend_drive_wait_for_volume_finish (DejaDupBackendDrive* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void deja_dup_backend_drive_mount_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void deja_dup_backend_drive_wait_for_volume_data_free (gpointer _data);
static gboolean deja_dup_backend_drive_wait_for_volume_co (DejaDupBackendDriveWaitForVolumeData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda8_ (Block1Data* _data1_,
                  GVolumeMonitor* m,
                  GVolume* v);
static void ____lambda8__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                 GVolume* volume,
                                                 gpointer self);
static void deja_dup_backend_drive_wait_for_volume_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static GType deja_dup_backend_drive_get_type_once (void);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupBackendDrive*
deja_dup_backend_drive_construct (GType object_type,
                                  GSettings* settings)
{
	DejaDupBackendDrive * self = NULL;
	GSettings* _tmp0_ = NULL;
	if (settings != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = _g_object_ref0 (settings);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		DejaDupFilteredSettings* _tmp2_;
		_tmp2_ = deja_dup_get_settings (DEJA_DUP_DRIVE_ROOT);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GSettings*) _tmp2_;
	}
	self = (DejaDupBackendDrive*) g_object_new (object_type, "kind", DEJA_DUP_BACKEND_KIND_LOCAL, "settings", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

DejaDupBackendDrive*
deja_dup_backend_drive_new (GSettings* settings)
{
	return deja_dup_backend_drive_construct (DEJA_DUP_TYPE_BACKEND_DRIVE, settings);
}

static void
deja_dup_backend_drive_real_cleanup_data_free (gpointer _data)
{
	DejaDupBackendDriveCleanupData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendDriveCleanupData, _data_);
}

static void
deja_dup_backend_drive_real_cleanup (DejaDupBackend* base,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	DejaDupBackendDrive * self;
	DejaDupBackendDriveCleanupData* _data_;
	DejaDupBackendDrive* _tmp0_;
	self = (DejaDupBackendDrive*) base;
	_data_ = g_slice_new0 (DejaDupBackendDriveCleanupData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_drive_real_cleanup_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_drive_real_cleanup_co (_data_);
}

static void
deja_dup_backend_drive_cleanup_finish (DejaDupBackend* base,
                                       GAsyncResult* _res_)
{
	DejaDupBackendDriveCleanupData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_backend_drive_cleanup_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	DejaDupBackendDriveCleanupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_drive_real_cleanup_co (_data_);
}

static gboolean
deja_dup_backend_drive_real_cleanup_co (DejaDupBackendDriveCleanupData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	sync ();
	_data_->_state_ = 1;
	DEJA_DUP_BACKEND_CLASS (deja_dup_backend_drive_parent_class)->cleanup ((DejaDupBackend*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile), deja_dup_backend_drive_cleanup_ready, _data_);
	return FALSE;
	_state_1:
	DEJA_DUP_BACKEND_CLASS (deja_dup_backend_drive_parent_class)->cleanup_finish ((DejaDupBackend*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile), _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
deja_dup_backend_drive_get_folder (DejaDupBackendDrive* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_DRIVE_FOLDER_KEY, FALSE);
	result = _tmp2_;
	return result;
}

static GVolume*
deja_dup_backend_drive_get_volume (DejaDupBackendDrive* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVolume* _tmp4_;
	GVolume* _tmp5_;
	GVolume* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, DEJA_DUP_DRIVE_UUID_KEY);
	_tmp3_ = _tmp2_;
	_tmp4_ = deja_dup_backend_drive_find_volume (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

static GFile*
deja_dup_backend_drive_real_get_root_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendDrive * self;
	GVolume* vol = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GMount* mount = NULL;
	GVolume* _tmp2_;
	GMount* _tmp3_;
	GMount* _tmp4_;
	GMount* _tmp5_;
	GFile* _tmp6_;
	GFile* result;
	self = (DejaDupBackendDrive*) base;
	_tmp0_ = deja_dup_backend_drive_get_volume (self);
	vol = _tmp0_;
	_tmp1_ = vol;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (vol);
		return result;
	}
	_tmp2_ = vol;
	_tmp3_ = g_volume_get_mount (_tmp2_);
	mount = _tmp3_;
	_tmp4_ = mount;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (mount);
		_g_object_unref0 (vol);
		return result;
	}
	_tmp5_ = mount;
	_tmp6_ = g_mount_get_root (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (mount);
	_g_object_unref0 (vol);
	return result;
}

static GFile*
deja_dup_backend_drive_real_get_file_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendDrive * self;
	GFile* root = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	self = (DejaDupBackendDrive*) base;
	_tmp0_ = deja_dup_backend_file_get_root_from_settings ((DejaDupBackendFile*) self);
	root = _tmp0_;
	_tmp1_ = root;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (root);
		return result;
	}
	{
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp3_ = root;
		_tmp4_ = deja_dup_backend_drive_get_folder (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_child_for_display_name (_tmp3_, _tmp5_, &_inner_error0_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_tmp2_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp8_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (root);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("BackendDrive.vala:61: %s", _tmp10_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (root);
		return result;
	}
	__finally0:
	_g_object_unref0 (root);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
deja_dup_backend_drive_real_get_location_pretty (DejaDupBackend* base)
{
	DejaDupBackendDrive * self;
	gchar* name = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* folder = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	self = (DejaDupBackendDrive*) base;
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, DEJA_DUP_DRIVE_NAME_KEY);
	name = _tmp2_;
	_tmp3_ = deja_dup_backend_drive_get_folder (self);
	folder = _tmp3_;
	_tmp4_ = folder;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		result = name;
		_g_free0 (folder);
		return result;
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = folder;
		_tmp6_ = name;
		_tmp7_ = g_strdup_printf (_ ("%1$s on %2$s"), _tmp5_, _tmp6_);
		result = _tmp7_;
		_g_free0 (folder);
		_g_free0 (name);
		return result;
	}
}

static void
deja_dup_backend_drive_real_is_ready_data_free (gpointer _data)
{
	DejaDupBackendDriveIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendDriveIsReadyData, _data_);
}

static void
deja_dup_backend_drive_real_is_ready (DejaDupBackend* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	DejaDupBackendDrive * self;
	DejaDupBackendDriveIsReadyData* _data_;
	DejaDupBackendDrive* _tmp0_;
	self = (DejaDupBackendDrive*) base;
	_data_ = g_slice_new0 (DejaDupBackendDriveIsReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_drive_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_drive_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_drive_is_ready_finish (DejaDupBackend* base,
                                        GAsyncResult* _res_,
                                        gchar** reason,
                                        gchar** message)
{
	gboolean result;
	DejaDupBackendDriveIsReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (reason) {
		*reason = _data_->reason;
	} else {
		_g_free0 (_data_->reason);
	}
	_data_->reason = NULL;
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static gboolean
deja_dup_backend_drive_real_is_ready_co (DejaDupBackendDriveIsReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_drive_get_volume (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_ == NULL;
	_g_object_unref0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = deja_dup_backend_get_settings ((DejaDupBackend*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_settings_get_string (_data_->_tmp4_, DEJA_DUP_DRIVE_NAME_KEY);
		_data_->name = _data_->_tmp5_;
		_data_->_tmp6_ = g_strdup ("drive-mounted");
		_g_free0 (_data_->reason);
		_data_->reason = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->name;
		_data_->_tmp8_ = g_strdup_printf (_ ("Backup will begin when %s is connected."), _data_->_tmp7_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp8_;
		_data_->result = FALSE;
		_g_free0 (_data_->name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->reason);
	_data_->reason = NULL;
	_g_free0 (_data_->message);
	_data_->message = NULL;
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GIcon*
deja_dup_backend_drive_real_get_icon (DejaDupBackend* base)
{
	DejaDupBackendDrive * self;
	gchar* icon_name = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	GIcon* result;
	self = (DejaDupBackendDrive*) base;
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, DEJA_DUP_DRIVE_ICON_KEY);
	icon_name = _tmp2_;
	{
		GIcon* _tmp3_ = NULL;
		GIcon* _tmp4_;
		GIcon* _tmp5_;
		_tmp4_ = g_icon_new_for_string (icon_name, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		result = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_g_free0 (icon_name);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("BackendDrive.vala:99: %s", _tmp7_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (icon_name);
		return result;
	}
	__finally0:
	_g_free0 (icon_name);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
deja_dup_backend_drive_get_uuid (GVolume* v)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = g_volume_get_identifier (v, G_VOLUME_IDENTIFIER_KIND_UUID);
	result = _tmp0_;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GVolume*
deja_dup_backend_drive_find_volume (const gchar* uuid)
{
	GVolumeMonitor* monitor = NULL;
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GList* _tmp2_;
	GVolume* result;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = deja_dup_get_volume_monitor ();
	monitor = _tmp0_;
	_tmp1_ = monitor;
	_tmp2_ = g_volume_monitor_get_volumes (_tmp1_);
	{
		GList* v_collection = NULL;
		GList* v_it = NULL;
		v_collection = _tmp2_;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* _tmp3_;
			GVolume* v = NULL;
			_tmp3_ = _g_object_ref0 ((GVolume*) v_it->data);
			v = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GVolume* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = v;
				_tmp6_ = deja_dup_backend_drive_get_uuid (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (_tmp7_, uuid) == 0;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					_tmp4_ = TRUE;
				} else {
					GVolume* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = v;
					_tmp10_ = g_volume_get_uuid (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp4_ = g_strcmp0 (_tmp11_, uuid) == 0;
					_g_free0 (_tmp11_);
				}
				if (_tmp4_) {
					result = v;
					(v_collection == NULL) ? NULL : (v_collection = (_g_list_free__g_object_unref0_ (v_collection), NULL));
					_g_object_unref0 (monitor);
					return result;
				}
				_g_object_unref0 (v);
			}
		}
		(v_collection == NULL) ? NULL : (v_collection = (_g_list_free__g_object_unref0_ (v_collection), NULL));
	}
	result = NULL;
	_g_object_unref0 (monitor);
	return result;
}

gboolean
deja_dup_backend_drive_is_allowed_volume (GVolume* vol)
{
	GDrive* _tmp0_;
	GDrive* _tmp1_;
	gboolean _tmp2_;
	GDrive* _tmp3_;
	GDrive* _tmp4_;
	gboolean _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GIcon* icon_in = NULL;
	GIcon* _tmp9_;
	GEmblemedIcon* icon_emblemed = NULL;
	GIcon* _tmp10_;
	GEmblemedIcon* _tmp11_;
	GEmblemedIcon* _tmp12_;
	GThemedIcon* icon = NULL;
	GIcon* _tmp16_;
	GThemedIcon* _tmp17_;
	GThemedIcon* _tmp18_;
	gchar** names = NULL;
	GThemedIcon* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gboolean result;
	g_return_val_if_fail (vol != NULL, FALSE);
	_tmp0_ = g_volume_get_drive (vol);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = g_volume_get_drive (vol);
	_tmp4_ = _tmp3_;
	_tmp5_ = !g_drive_is_removable (_tmp4_);
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = deja_dup_backend_drive_get_uuid (vol);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ == NULL;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = g_volume_get_icon (vol);
	icon_in = _tmp9_;
	_tmp10_ = icon_in;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, g_emblemed_icon_get_type ()) ? ((GEmblemedIcon*) _tmp10_) : NULL);
	icon_emblemed = _tmp11_;
	_tmp12_ = icon_emblemed;
	if (_tmp12_ != NULL) {
		GEmblemedIcon* _tmp13_;
		GIcon* _tmp14_;
		GIcon* _tmp15_;
		_tmp13_ = icon_emblemed;
		_tmp14_ = g_emblemed_icon_get_icon (_tmp13_);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_g_object_unref0 (icon_in);
		icon_in = _tmp15_;
	}
	_tmp16_ = icon_in;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, g_themed_icon_get_type ()) ? ((GThemedIcon*) _tmp16_) : NULL);
	icon = _tmp17_;
	_tmp18_ = icon;
	if (_tmp18_ == NULL) {
		result = FALSE;
		_g_object_unref0 (icon);
		_g_object_unref0 (icon_emblemed);
		_g_object_unref0 (icon_in);
		return result;
	}
	_tmp19_ = icon;
	_tmp21_ = _tmp20_ = g_themed_icon_get_names (_tmp19_);
	names = _tmp21_;
	names_length1 = _vala_array_length (_tmp20_);
	_names_size_ = names_length1;
	_tmp22_ = names;
	_tmp22__length1 = names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp22_;
		name_collection_length1 = _tmp22__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			const gchar* name = NULL;
			name = name_collection[name_it];
			{
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GQuark _tmp26_ = 0U;
				static GQuark _tmp25_label0 = 0;
				static GQuark _tmp25_label1 = 0;
				static GQuark _tmp25_label2 = 0;
				static GQuark _tmp25_label3 = 0;
				static GQuark _tmp25_label4 = 0;
				_tmp23_ = name;
				_tmp24_ = _tmp23_;
				_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
				if (((((_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("drive-harddisk")))) || (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("drive-removable-media"))))) || (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("media-flash"))))) || (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("media-floppy"))))) || (_tmp26_ == ((0 != _tmp25_label4) ? _tmp25_label4 : (_tmp25_label4 = g_quark_from_static_string ("media-tape"))))) {
					switch (0) {
						default:
						{
							result = TRUE;
							_g_object_unref0 (icon);
							_g_object_unref0 (icon_emblemed);
							_g_object_unref0 (icon_in);
							return result;
						}
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (icon);
	_g_object_unref0 (icon_emblemed);
	_g_object_unref0 (icon_in);
	return result;
}

gboolean
deja_dup_backend_drive_set_volume_info_from_file (GFile* file,
                                                  GSettings* settings)
{
	GMount* mount = NULL;
	GVolume* volume = NULL;
	GMount* _tmp4_;
	GVolume* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GVolume* _tmp7_;
	gchar* folder = NULL;
	GMount* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GVolume* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_;
	GVolume* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	{
		GMount* _tmp0_ = NULL;
		GMount* _tmp1_;
		GMount* _tmp2_;
		_tmp1_ = g_file_find_enclosing_mount (file, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (mount);
		mount = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (mount);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		_g_object_unref0 (mount);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	_tmp4_ = mount;
	_tmp5_ = g_mount_get_volume (_tmp4_);
	volume = _tmp5_;
	_tmp7_ = volume;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		GVolume* _tmp8_;
		_tmp8_ = volume;
		_tmp6_ = !deja_dup_backend_drive_is_allowed_volume (_tmp8_);
	}
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (volume);
		_g_object_unref0 (mount);
		return result;
	}
	_tmp9_ = mount;
	_tmp10_ = g_mount_get_root (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_relative_path (_tmp11_, file);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	folder = _tmp13_;
	_tmp14_ = volume;
	_tmp15_ = deja_dup_backend_drive_get_uuid (_tmp14_);
	_tmp16_ = _tmp15_;
	g_settings_set_string (settings, DEJA_DUP_DRIVE_UUID_KEY, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp18_ = folder;
	if (_tmp18_ == NULL) {
		_tmp17_ = "";
	} else {
		const gchar* _tmp19_;
		_tmp19_ = folder;
		_tmp17_ = _tmp19_;
	}
	g_settings_set_string (settings, DEJA_DUP_DRIVE_FOLDER_KEY, _tmp17_);
	_tmp20_ = volume;
	deja_dup_backend_drive_update_volume_info (_tmp20_, settings);
	result = TRUE;
	_g_free0 (folder);
	_g_object_unref0 (volume);
	_g_object_unref0 (mount);
	return result;
}

void
deja_dup_backend_drive_update_volume_info (GVolume* volume,
                                           GSettings* settings)
{
	gchar* vol_uuid = NULL;
	gchar* _tmp0_;
	gchar* fs_uuid = NULL;
	gchar* _tmp1_;
	gchar* settings_uuid = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_if_fail (volume != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = deja_dup_backend_drive_get_uuid (volume);
	vol_uuid = _tmp0_;
	_tmp1_ = g_volume_get_uuid (volume);
	fs_uuid = _tmp1_;
	_tmp2_ = g_settings_get_string (settings, DEJA_DUP_DRIVE_UUID_KEY);
	settings_uuid = _tmp2_;
	_tmp4_ = vol_uuid;
	_tmp5_ = settings_uuid;
	if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = fs_uuid;
		_tmp7_ = settings_uuid;
		_tmp3_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_g_free0 (settings_uuid);
		_g_free0 (fs_uuid);
		_g_free0 (vol_uuid);
		return;
	}
	_tmp8_ = g_settings_get_string (settings, DEJA_DUP_DRIVE_UUID_KEY);
	_tmp9_ = _tmp8_;
	_tmp10_ = vol_uuid;
	_tmp11_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
	_g_free0 (_tmp9_);
	if (_tmp11_) {
		const gchar* _tmp12_;
		_tmp12_ = vol_uuid;
		g_settings_set_string (settings, DEJA_DUP_DRIVE_UUID_KEY, _tmp12_);
	}
	_tmp13_ = g_volume_get_name (volume);
	_tmp14_ = _tmp13_;
	g_settings_set_string (settings, DEJA_DUP_DRIVE_NAME_KEY, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = g_volume_get_icon (volume);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_icon_to_string (_tmp16_);
	_tmp18_ = _tmp17_;
	g_settings_set_string (settings, DEJA_DUP_DRIVE_ICON_KEY, _tmp18_);
	_g_free0 (_tmp18_);
	_g_object_unref0 (_tmp16_);
	_g_free0 (settings_uuid);
	_g_free0 (fs_uuid);
	_g_free0 (vol_uuid);
}

static void
deja_dup_backend_drive_mount_internal_data_free (gpointer _data)
{
	DejaDupBackendDriveMountInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->vol);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendDriveMountInternalData, _data_);
}

static void
deja_dup_backend_drive_mount_internal (DejaDupBackendDrive* self,
                                       GVolume* vol,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	DejaDupBackendDriveMountInternalData* _data_;
	DejaDupBackendDrive* _tmp0_;
	GVolume* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vol != NULL);
	_data_ = g_slice_new0 (DejaDupBackendDriveMountInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_drive_mount_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (vol);
	_g_object_unref0 (_data_->vol);
	_data_->vol = _tmp1_;
	deja_dup_backend_drive_mount_internal_co (_data_);
}

static gboolean
deja_dup_backend_drive_mount_internal_finish (DejaDupBackendDrive* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	gboolean result;
	DejaDupBackendDriveMountInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_drive_mount_internal_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	DejaDupBackendDriveMountInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_drive_mount_internal_co (_data_);
}

static gboolean
deja_dup_backend_drive_mount_internal_co (DejaDupBackendDriveMountInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_volume_get_mount (_data_->vol);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->_tmp1_ != NULL;
	_g_object_unref0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp3_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		g_volume_mount (_data_->vol, G_MOUNT_MOUNT_NONE, _data_->_tmp4_, NULL, deja_dup_backend_drive_mount_internal_ready, _data_);
		return FALSE;
		_state_1:
		g_volume_mount_finish (_data_->vol, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_ALREADY_MOUNTED)) {
				goto __catch0_g_io_error_already_mounted;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED)) {
				goto __catch0_g_io_error_failed_handled;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				goto __catch0_g_io_error_permission_denied;
			}
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_DBUS_ERROR)) {
				goto __catch0_g_io_error_dbus_error;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_io_error_already_mounted:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_io_error_failed_handled:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp5_ = g_error_new_literal (DEJA_DUP_BACKEND_ERROR, DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED, "");
		_data_->_inner_error0_ = _data_->_tmp5_;
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_io_error_permission_denied:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp6_ = g_error_new_literal (DEJA_DUP_BACKEND_ERROR, DEJA_DUP_BACKEND_ERROR_MOUNT_OP_NEEDED, "");
		_data_->_inner_error0_ = _data_->_tmp6_;
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_io_error_dbus_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_state_ = 2;
		deja_dup_wait ((guint) 2, deja_dup_backend_drive_mount_internal_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_wait_finish (_data_->_res_);
		_data_->_state_ = 3;
		deja_dup_backend_drive_mount_internal (_data_->self, _data_->vol, deja_dup_backend_drive_mount_internal_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp7_ = deja_dup_backend_drive_mount_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->result = _data_->_tmp7_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_drive_real_mount_data_free (gpointer _data)
{
	DejaDupBackendDriveMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendDriveMountData, _data_);
}

static void
deja_dup_backend_drive_real_mount (DejaDupBackendFile* base,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	DejaDupBackendDrive * self;
	DejaDupBackendDriveMountData* _data_;
	DejaDupBackendDrive* _tmp0_;
	self = (DejaDupBackendDrive*) base;
	_data_ = g_slice_new0 (DejaDupBackendDriveMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_drive_real_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_drive_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_drive_mount_finish (DejaDupBackendFile* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gboolean result;
	DejaDupBackendDriveMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_drive_mount_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	DejaDupBackendDriveMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_drive_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_drive_real_mount_co (DejaDupBackendDriveMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	deja_dup_backend_drive_wait_for_volume (_data_->self, deja_dup_backend_drive_mount_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = deja_dup_backend_drive_wait_for_volume_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->vol = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->vol;
	_data_->_state_ = 2;
	deja_dup_backend_drive_mount_internal (_data_->self, _data_->_tmp1_, deja_dup_backend_drive_mount_ready, _data_);
	return FALSE;
	_state_2:
	_data_->rv = deja_dup_backend_drive_mount_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->vol);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->vol;
	_data_->_tmp3_ = deja_dup_backend_get_settings ((DejaDupBackend*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	deja_dup_backend_drive_update_volume_info (_data_->_tmp2_, _data_->_tmp4_);
	_data_->result = _data_->rv;
	_g_object_unref0 (_data_->vol);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_drive_wait_for_volume_data_free (gpointer _data)
{
	DejaDupBackendDriveWaitForVolumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendDriveWaitForVolumeData, _data_);
}

static void
deja_dup_backend_drive_wait_for_volume (DejaDupBackendDrive* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	DejaDupBackendDriveWaitForVolumeData* _data_;
	DejaDupBackendDrive* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendDriveWaitForVolumeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_drive_wait_for_volume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_drive_wait_for_volume_co (_data_);
}

static GVolume*
deja_dup_backend_drive_wait_for_volume_finish (DejaDupBackendDrive* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GVolume* result;
	DejaDupBackendDriveWaitForVolumeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		DejaDupBackendDrive* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda8_ (Block1Data* _data1_,
             GVolumeMonitor* m,
             GVolume* v)
{
	DejaDupBackendDrive* self;
	self = _data1_->self;
	g_return_if_fail (m != NULL);
	g_return_if_fail (v != NULL);
	deja_dup_backend_drive_wait_for_volume_co (_data1_->_async_data_);
}

static void
____lambda8__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                            GVolume* volume,
                                            gpointer self)
{
	___lambda8_ (self, _sender, volume);
}

static void
deja_dup_backend_drive_wait_for_volume_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	DejaDupBackendDriveWaitForVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_drive_wait_for_volume_co (_data_);
}

static gboolean
deja_dup_backend_drive_wait_for_volume_co (DejaDupBackendDriveWaitForVolumeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = deja_dup_backend_drive_get_volume (_data_->self);
	_data_->vol = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->vol;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = deja_dup_get_volume_monitor ();
		_data_->monitor = _data_->_tmp2_;
		_data_->_tmp3_ = deja_dup_backend_get_settings ((DejaDupBackend*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_settings_get_string (_data_->_tmp4_, DEJA_DUP_DRIVE_NAME_KEY);
		_data_->name = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->name;
		_data_->_tmp7_ = g_strdup_printf (_ ("Waiting for ‘%s’ to become connected…"), _data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", _ ("Storage location not available"), _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_data_->_tmp9_ = _data_->monitor;
		_data_->_tmp10_ = g_signal_connect_data (_data_->_tmp9_, "volume-added", (GCallback) ____lambda8__g_volume_monitor_volume_added, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
		_data_->sigid = _data_->_tmp10_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp11_ = _data_->monitor;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp11_, _data_->sigid);
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "pause-op", NULL, NULL);
		_data_->_state_ = 2;
		deja_dup_backend_drive_wait_for_volume (_data_->self, deja_dup_backend_drive_wait_for_volume_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp13_ = deja_dup_backend_drive_wait_for_volume_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->name);
			_g_object_unref0 (_data_->monitor);
			_g_object_unref0 (_data_->vol);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_data_->result = _data_->_tmp14_;
		_g_object_unref0 (_data_->_tmp12_);
		_g_free0 (_data_->name);
		_g_object_unref0 (_data_->monitor);
		_g_object_unref0 (_data_->vol);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->vol;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_drive_class_init (DejaDupBackendDriveClass * klass,
                                   gpointer klass_data)
{
	deja_dup_backend_drive_parent_class = g_type_class_peek_parent (klass);
	((DejaDupBackendClass *) klass)->cleanup = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_drive_real_cleanup;
	((DejaDupBackendClass *) klass)->cleanup_finish = (void (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_drive_cleanup_finish;
	((DejaDupBackendFileClass *) klass)->get_root_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_drive_real_get_root_from_settings;
	((DejaDupBackendFileClass *) klass)->get_file_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_drive_real_get_file_from_settings;
	((DejaDupBackendClass *) klass)->get_location_pretty = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_drive_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->is_ready = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_drive_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = (gboolean (*) (DejaDupBackend*, GAsyncResult*, gchar**, gchar**)) deja_dup_backend_drive_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_icon = (GIcon* (*) (DejaDupBackend*)) deja_dup_backend_drive_real_get_icon;
	((DejaDupBackendFileClass *) klass)->mount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_drive_real_mount;
	((DejaDupBackendFileClass *) klass)->mount_finish = (gboolean (*) (DejaDupBackendFile*, GAsyncResult*, GError**)) deja_dup_backend_drive_mount_finish;
}

static void
deja_dup_backend_drive_instance_init (DejaDupBackendDrive * self,
                                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_drive_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendDriveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_drive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendDrive), 0, (GInstanceInitFunc) deja_dup_backend_drive_instance_init, NULL };
	GType deja_dup_backend_drive_type_id;
	deja_dup_backend_drive_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND_FILE, "DejaDupBackendDrive", &g_define_type_info, 0);
	return deja_dup_backend_drive_type_id;
}

GType
deja_dup_backend_drive_get_type (void)
{
	static gsize deja_dup_backend_drive_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_drive_type_id__once)) {
		GType deja_dup_backend_drive_type_id;
		deja_dup_backend_drive_type_id = deja_dup_backend_drive_get_type_once ();
		g_once_init_leave (&deja_dup_backend_drive_type_id__once, deja_dup_backend_drive_type_id);
	}
	return deja_dup_backend_drive_type_id__once;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

