/* Generated by wayland-scanner 1.24.0 */

#ifndef DDE_SECURITY_SERVER_PROTOCOL_H
#define DDE_SECURITY_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_security The dde_security protocol
 * @section page_ifaces_dde_security Interfaces
 * - @subpage page_iface_dde_security - protocol provide security protection
 * - @subpage page_iface_security_session - security protection interface
 * @section page_copyright_dde_security Copyright
 * <pre>
 *
 * Copyright © 2022  luochaojiang <luochaojiang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_security;
struct security_session;

#ifndef DDE_SECURITY_INTERFACE
#define DDE_SECURITY_INTERFACE
/**
 * @page page_iface_dde_security dde_security
 * @section page_iface_dde_security_desc Description
 *
 * A global protocol provide security protection.
 * @section page_iface_dde_security_api API
 * See @ref iface_dde_security.
 */
/**
 * @defgroup iface_dde_security The dde_security interface
 *
 * A global protocol provide security protection.
 */
extern const struct wl_interface dde_security_interface;
#endif
#ifndef SECURITY_SESSION_INTERFACE
#define SECURITY_SESSION_INTERFACE
/**
 * @page page_iface_security_session security_session
 * @section page_iface_security_session_desc Description
 *
 * An interface that provide the security user interface.
 * It provides requests to report verify result.
 * @section page_iface_security_session_api API
 * See @ref iface_security_session.
 */
/**
 * @defgroup iface_security_session The security_session interface
 *
 * An interface that provide the security user interface.
 * It provides requests to report verify result.
 */
extern const struct wl_interface security_session_interface;
#endif

#ifndef DDE_SECURITY_TYPES_ENUM
#define DDE_SECURITY_TYPES_ENUM
enum dde_security_types {
	DDE_SECURITY_TYPES_SEC_CLIPBOARD_COPY = 1 << 0,
};
#endif /* DDE_SECURITY_TYPES_ENUM */

#ifndef DDE_SECURITY_TYPES_ENUM_IS_VALID
#define DDE_SECURITY_TYPES_ENUM_IS_VALID
/**
 * @ingroup iface_dde_security
 * Validate a dde_security types value.
 *
 * @return true on success, false on error.
 * @ref dde_security_types
 */
static inline bool
dde_security_types_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SECURITY_TYPES_SEC_CLIPBOARD_COPY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SECURITY_TYPES_ENUM_IS_VALID */

#ifndef DDE_SECURITY_PERMISSIONS_ENUM
#define DDE_SECURITY_PERMISSIONS_ENUM
enum dde_security_permissions {
	DDE_SECURITY_PERMISSIONS_PERMISSION_ALLOW = 1 << 0,
	DDE_SECURITY_PERMISSIONS_PERMISSION_DENY = 1 << 1,
};
#endif /* DDE_SECURITY_PERMISSIONS_ENUM */

#ifndef DDE_SECURITY_PERMISSIONS_ENUM_IS_VALID
#define DDE_SECURITY_PERMISSIONS_ENUM_IS_VALID
/**
 * @ingroup iface_dde_security
 * Validate a dde_security permissions value.
 *
 * @return true on success, false on error.
 * @ref dde_security_permissions
 */
static inline bool
dde_security_permissions_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SECURITY_PERMISSIONS_PERMISSION_ALLOW:
		return version >= 1;
	case DDE_SECURITY_PERMISSIONS_PERMISSION_DENY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SECURITY_PERMISSIONS_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_security
 * @struct dde_security_interface
 */
struct dde_security_interface {
	/**
	 * create a security session
	 *
	 * Create a security session. Values for types argument are
	 * described by dde_security.types.
	 * @param types bitfield of security types
	 */
	void (*get_session)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    uint32_t types);
	/**
	 * get all ace client pid
	 *
	 * get all ace client pid. Values for pid argument is the pid of
	 * the client caller
	 * @param pid pid of the caller
	 */
	void (*get_ace_clients)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t pid);
};

#define DDE_SECURITY_ACE_CLIENTS 0

/**
 * @ingroup iface_dde_security
 */
#define DDE_SECURITY_ACE_CLIENTS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_security
 */
#define DDE_SECURITY_GET_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_dde_security
 */
#define DDE_SECURITY_GET_ACE_CLIENTS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_security
 * Sends an ace_clients event to the client owning the resource.
 * @param resource_ The client's resource
 * @param clients ace client pid
 */
static inline void
dde_security_send_ace_clients(struct wl_resource *resource_, uint32_t count, struct wl_array *clients)
{
	wl_resource_post_event(resource_, DDE_SECURITY_ACE_CLIENTS, count, clients);
}

/**
 * @ingroup iface_security_session
 * @struct security_session_interface
 */
struct security_session_interface {
	/**
	 * remove security_session interface
	 *
	 * The security_session interface is removed.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * report security verify result
	 *
	 * Report security verify result. Values for types argument are
	 * described by dde_security.types. Values for result argument are
	 * described by dde_security.permissions.
	 * @param types bitfield of security types
	 * @param permission bitfield of verify result
	 * @param serial serial of the verify event
	 */
	void (*report_security)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t types,
				uint32_t permission,
				uint32_t serial);
};

#define SECURITY_SESSION_VERIFY_SECURITY 0

/**
 * @ingroup iface_security_session
 */
#define SECURITY_SESSION_VERIFY_SECURITY_SINCE_VERSION 1

/**
 * @ingroup iface_security_session
 */
#define SECURITY_SESSION_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_security_session
 */
#define SECURITY_SESSION_REPORT_SECURITY_SINCE_VERSION 1

/**
 * @ingroup iface_security_session
 * Sends an verify_security event to the client owning the resource.
 * @param resource_ The client's resource
 * @param types bitfield of security types
 * @param client pid of the source client
 * @param target pid of the target client
 * @param serial pass this to the report request
 */
static inline void
security_session_send_verify_security(struct wl_resource *resource_, uint32_t types, uint32_t client, uint32_t target, uint32_t serial)
{
	wl_resource_post_event(resource_, SECURITY_SESSION_VERIFY_SECURITY, types, client, target, serial);
}

#ifdef  __cplusplus
}
#endif

#endif
