/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::aggressiveCoreMin__option_t::type& Options::operator[](
    options::aggressiveCoreMin__option_t) const
{
  return d_holder->aggressiveCoreMin;
}
template <> bool Options::wasSetByUser(options::aggressiveCoreMin__option_t) const
{
  return d_holder->aggressiveCoreMin__setByUser__;
}
template <> const options::allowEmptyDependencies__option_t::type& Options::operator[](
    options::allowEmptyDependencies__option_t) const
{
  return d_holder->allowEmptyDependencies;
}
template <> bool Options::wasSetByUser(options::allowEmptyDependencies__option_t) const
{
  return d_holder->allowEmptyDependencies__setByUser__;
}
template <> void Options::set(
    options::fewerPreprocessingHoles__option_t,
    const options::fewerPreprocessingHoles__option_t::type& x)
{
  d_holder->fewerPreprocessingHoles = x;
}
template <> const options::fewerPreprocessingHoles__option_t::type& Options::operator[](
    options::fewerPreprocessingHoles__option_t) const
{
  return d_holder->fewerPreprocessingHoles;
}
template <> bool Options::wasSetByUser(options::fewerPreprocessingHoles__option_t) const
{
  return d_holder->fewerPreprocessingHoles__setByUser__;
}
template <> const options::lfscLetification__option_t::type& Options::operator[](
    options::lfscLetification__option_t) const
{
  return d_holder->lfscLetification;
}
template <> bool Options::wasSetByUser(options::lfscLetification__option_t) const
{
  return d_holder->lfscLetification__setByUser__;
}


namespace options {

struct aggressiveCoreMin__option_t aggressiveCoreMin;
struct allowEmptyDependencies__option_t allowEmptyDependencies;
struct fewerPreprocessingHoles__option_t fewerPreprocessingHoles;
struct lfscLetification__option_t lfscLetification;



}  // namespace options
}  // namespace CVC4
