// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/token.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Token struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id         string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3"`
	xxx_hidden_Note       string                 `protobuf:"bytes,4,opt,name=note,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Token) Reset() {
	*x = Token{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Token) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Token) ProtoMessage() {}

func (x *Token) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Token) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *Token) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *Token) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_ExpireTime
	}
	return nil
}

func (x *Token) GetNote() string {
	if x != nil {
		return x.xxx_hidden_Note
	}
	return ""
}

func (x *Token) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *Token) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *Token) SetExpireTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_ExpireTime = v
}

func (x *Token) SetNote(v string) {
	x.xxx_hidden_Note = v
}

func (x *Token) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *Token) HasExpireTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ExpireTime != nil
}

func (x *Token) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

func (x *Token) ClearExpireTime() {
	x.xxx_hidden_ExpireTime = nil
}

type Token_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Id         string
	CreateTime *timestamppb.Timestamp
	ExpireTime *timestamppb.Timestamp
	Note       string
}

func (b0 Token_builder) Build() *Token {
	m0 := &Token{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_ExpireTime = b.ExpireTime
	x.xxx_hidden_Note = b.Note
	return m0
}

type CreateTokenRequest struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Note       string                 `protobuf:"bytes,1,opt,name=note,proto3"`
	xxx_hidden_ExpireTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3"`
	xxx_hidden_UserId     string                 `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *CreateTokenRequest) Reset() {
	*x = CreateTokenRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTokenRequest) ProtoMessage() {}

func (x *CreateTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateTokenRequest) GetNote() string {
	if x != nil {
		return x.xxx_hidden_Note
	}
	return ""
}

func (x *CreateTokenRequest) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_ExpireTime
	}
	return nil
}

func (x *CreateTokenRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *CreateTokenRequest) SetNote(v string) {
	x.xxx_hidden_Note = v
}

func (x *CreateTokenRequest) SetExpireTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_ExpireTime = v
}

func (x *CreateTokenRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

func (x *CreateTokenRequest) HasExpireTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ExpireTime != nil
}

func (x *CreateTokenRequest) ClearExpireTime() {
	x.xxx_hidden_ExpireTime = nil
}

type CreateTokenRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Note string
	// The time until which the token should be valid.
	// Must be in the future. May be null for no expiry.
	ExpireTime *timestamppb.Timestamp
	// The ID of the user to create a new token, can only be
	// the user who perform this action, or a machine user.
	// Default to the user who perform this action if this is empty.
	UserId string
}

func (b0 CreateTokenRequest_builder) Build() *CreateTokenRequest {
	m0 := &CreateTokenRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Note = b.Note
	x.xxx_hidden_ExpireTime = b.ExpireTime
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type CreateTokenResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Token string                 `protobuf:"bytes,1,opt,name=token,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *CreateTokenResponse) Reset() {
	*x = CreateTokenResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTokenResponse) ProtoMessage() {}

func (x *CreateTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateTokenResponse) GetToken() string {
	if x != nil {
		return x.xxx_hidden_Token
	}
	return ""
}

func (x *CreateTokenResponse) SetToken(v string) {
	x.xxx_hidden_Token = v
}

type CreateTokenResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The plaintext token to use for authentication.
	Token string
}

func (b0 CreateTokenResponse_builder) Build() *CreateTokenResponse {
	m0 := &CreateTokenResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Token = b.Token
	return m0
}

type GetTokenRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TokenId string                 `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetTokenRequest) Reset() {
	*x = GetTokenRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTokenRequest) ProtoMessage() {}

func (x *GetTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetTokenRequest) GetTokenId() string {
	if x != nil {
		return x.xxx_hidden_TokenId
	}
	return ""
}

func (x *GetTokenRequest) SetTokenId(v string) {
	x.xxx_hidden_TokenId = v
}

type GetTokenRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TokenId string
}

func (b0 GetTokenRequest_builder) Build() *GetTokenRequest {
	m0 := &GetTokenRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TokenId = b.TokenId
	return m0
}

type GetTokenResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Token *Token                 `protobuf:"bytes,1,opt,name=token,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetTokenResponse) Reset() {
	*x = GetTokenResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTokenResponse) ProtoMessage() {}

func (x *GetTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetTokenResponse) GetToken() *Token {
	if x != nil {
		return x.xxx_hidden_Token
	}
	return nil
}

func (x *GetTokenResponse) SetToken(v *Token) {
	x.xxx_hidden_Token = v
}

func (x *GetTokenResponse) HasToken() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Token != nil
}

func (x *GetTokenResponse) ClearToken() {
	x.xxx_hidden_Token = nil
}

type GetTokenResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Token *Token
}

func (b0 GetTokenResponse_builder) Build() *GetTokenResponse {
	m0 := &GetTokenResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Token = b.Token
	return m0
}

type ListTokensRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PageSize  uint32                 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken string                 `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse   bool                   `protobuf:"varint,3,opt,name=reverse,proto3"`
	xxx_hidden_UserId    string                 `protobuf:"bytes,4,opt,name=user_id,json=userId,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ListTokensRequest) Reset() {
	*x = ListTokensRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTokensRequest) ProtoMessage() {}

func (x *ListTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListTokensRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListTokensRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListTokensRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListTokensRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ListTokensRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListTokensRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListTokensRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

func (x *ListTokensRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

type ListTokensRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	PageSize uint32
	// The first page is returned if this is empty.
	PageToken string
	Reverse   bool
	// The ID of the user to list tokens, can only be
	// the user who perform this action, or a machine user.
	// Default to the user who perform this action if this is empty.
	UserId string
}

func (b0 ListTokensRequest_builder) Build() *ListTokensRequest {
	m0 := &ListTokensRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type ListTokensResponse struct {
	state                    protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Tokens        *[]*Token              `protobuf:"bytes,1,rep,name=tokens,proto3"`
	xxx_hidden_NextPageToken string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *ListTokensResponse) Reset() {
	*x = ListTokensResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTokensResponse) ProtoMessage() {}

func (x *ListTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListTokensResponse) GetTokens() []*Token {
	if x != nil {
		if x.xxx_hidden_Tokens != nil {
			return *x.xxx_hidden_Tokens
		}
	}
	return nil
}

func (x *ListTokensResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListTokensResponse) SetTokens(v []*Token) {
	x.xxx_hidden_Tokens = &v
}

func (x *ListTokensResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListTokensResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Tokens []*Token
	// There are no more pages if this is empty.
	NextPageToken string
}

func (b0 ListTokensResponse_builder) Build() *ListTokensResponse {
	m0 := &ListTokensResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Tokens = &b.Tokens
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type DeleteTokenRequest struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_TokenId string                 `protobuf:"bytes,1,opt,name=token_id,json=tokenId,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DeleteTokenRequest) Reset() {
	*x = DeleteTokenRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTokenRequest) ProtoMessage() {}

func (x *DeleteTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteTokenRequest) GetTokenId() string {
	if x != nil {
		return x.xxx_hidden_TokenId
	}
	return ""
}

func (x *DeleteTokenRequest) SetTokenId(v string) {
	x.xxx_hidden_TokenId = v
}

type DeleteTokenRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	TokenId string
}

func (b0 DeleteTokenRequest_builder) Build() *DeleteTokenRequest {
	m0 := &DeleteTokenRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_TokenId = b.TokenId
	return m0
}

type DeleteTokenResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTokenResponse) Reset() {
	*x = DeleteTokenResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTokenResponse) ProtoMessage() {}

func (x *DeleteTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_token_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteTokenResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteTokenResponse_builder) Build() *DeleteTokenResponse {
	m0 := &DeleteTokenResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_token_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_token_proto_rawDesc = "" +
	"\n" +
	"'buf/alpha/registry/v1alpha1/token.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a\x1fgoogle/protobuf/timestamp.proto\"\xa5\x01\n" +
	"\x05Token\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12;\n" +
	"\vexpire_time\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"expireTime\x12\x12\n" +
	"\x04note\x18\x04 \x01(\tR\x04note\"~\n" +
	"\x12CreateTokenRequest\x12\x12\n" +
	"\x04note\x18\x01 \x01(\tR\x04note\x12;\n" +
	"\vexpire_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"expireTime\x12\x17\n" +
	"\auser_id\x18\x03 \x01(\tR\x06userId\"+\n" +
	"\x13CreateTokenResponse\x12\x14\n" +
	"\x05token\x18\x01 \x01(\tR\x05token\",\n" +
	"\x0fGetTokenRequest\x12\x19\n" +
	"\btoken_id\x18\x01 \x01(\tR\atokenId\"L\n" +
	"\x10GetTokenResponse\x128\n" +
	"\x05token\x18\x01 \x01(\v2\".buf.alpha.registry.v1alpha1.TokenR\x05token\"\x82\x01\n" +
	"\x11ListTokensRequest\x12\x1b\n" +
	"\tpage_size\x18\x01 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x03 \x01(\bR\areverse\x12\x17\n" +
	"\auser_id\x18\x04 \x01(\tR\x06userId\"x\n" +
	"\x12ListTokensResponse\x12:\n" +
	"\x06tokens\x18\x01 \x03(\v2\".buf.alpha.registry.v1alpha1.TokenR\x06tokens\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"/\n" +
	"\x12DeleteTokenRequest\x12\x19\n" +
	"\btoken_id\x18\x01 \x01(\tR\atokenId\"\x15\n" +
	"\x13DeleteTokenResponse2\xd9\x03\n" +
	"\fTokenService\x12p\n" +
	"\vCreateToken\x12/.buf.alpha.registry.v1alpha1.CreateTokenRequest\x1a0.buf.alpha.registry.v1alpha1.CreateTokenResponse\x12l\n" +
	"\bGetToken\x12,.buf.alpha.registry.v1alpha1.GetTokenRequest\x1a-.buf.alpha.registry.v1alpha1.GetTokenResponse\"\x03\x90\x02\x01\x12r\n" +
	"\n" +
	"ListTokens\x12..buf.alpha.registry.v1alpha1.ListTokensRequest\x1a/.buf.alpha.registry.v1alpha1.ListTokensResponse\"\x03\x90\x02\x01\x12u\n" +
	"\vDeleteToken\x12/.buf.alpha.registry.v1alpha1.DeleteTokenRequest\x1a0.buf.alpha.registry.v1alpha1.DeleteTokenResponse\"\x03\x90\x02\x02B\x97\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\n" +
	"TokenProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_token_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_buf_alpha_registry_v1alpha1_token_proto_goTypes = []any{
	(*Token)(nil),                 // 0: buf.alpha.registry.v1alpha1.Token
	(*CreateTokenRequest)(nil),    // 1: buf.alpha.registry.v1alpha1.CreateTokenRequest
	(*CreateTokenResponse)(nil),   // 2: buf.alpha.registry.v1alpha1.CreateTokenResponse
	(*GetTokenRequest)(nil),       // 3: buf.alpha.registry.v1alpha1.GetTokenRequest
	(*GetTokenResponse)(nil),      // 4: buf.alpha.registry.v1alpha1.GetTokenResponse
	(*ListTokensRequest)(nil),     // 5: buf.alpha.registry.v1alpha1.ListTokensRequest
	(*ListTokensResponse)(nil),    // 6: buf.alpha.registry.v1alpha1.ListTokensResponse
	(*DeleteTokenRequest)(nil),    // 7: buf.alpha.registry.v1alpha1.DeleteTokenRequest
	(*DeleteTokenResponse)(nil),   // 8: buf.alpha.registry.v1alpha1.DeleteTokenResponse
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
}
var file_buf_alpha_registry_v1alpha1_token_proto_depIdxs = []int32{
	9, // 0: buf.alpha.registry.v1alpha1.Token.create_time:type_name -> google.protobuf.Timestamp
	9, // 1: buf.alpha.registry.v1alpha1.Token.expire_time:type_name -> google.protobuf.Timestamp
	9, // 2: buf.alpha.registry.v1alpha1.CreateTokenRequest.expire_time:type_name -> google.protobuf.Timestamp
	0, // 3: buf.alpha.registry.v1alpha1.GetTokenResponse.token:type_name -> buf.alpha.registry.v1alpha1.Token
	0, // 4: buf.alpha.registry.v1alpha1.ListTokensResponse.tokens:type_name -> buf.alpha.registry.v1alpha1.Token
	1, // 5: buf.alpha.registry.v1alpha1.TokenService.CreateToken:input_type -> buf.alpha.registry.v1alpha1.CreateTokenRequest
	3, // 6: buf.alpha.registry.v1alpha1.TokenService.GetToken:input_type -> buf.alpha.registry.v1alpha1.GetTokenRequest
	5, // 7: buf.alpha.registry.v1alpha1.TokenService.ListTokens:input_type -> buf.alpha.registry.v1alpha1.ListTokensRequest
	7, // 8: buf.alpha.registry.v1alpha1.TokenService.DeleteToken:input_type -> buf.alpha.registry.v1alpha1.DeleteTokenRequest
	2, // 9: buf.alpha.registry.v1alpha1.TokenService.CreateToken:output_type -> buf.alpha.registry.v1alpha1.CreateTokenResponse
	4, // 10: buf.alpha.registry.v1alpha1.TokenService.GetToken:output_type -> buf.alpha.registry.v1alpha1.GetTokenResponse
	6, // 11: buf.alpha.registry.v1alpha1.TokenService.ListTokens:output_type -> buf.alpha.registry.v1alpha1.ListTokensResponse
	8, // 12: buf.alpha.registry.v1alpha1.TokenService.DeleteToken:output_type -> buf.alpha.registry.v1alpha1.DeleteTokenResponse
	9, // [9:13] is the sub-list for method output_type
	5, // [5:9] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_token_proto_init() }
func file_buf_alpha_registry_v1alpha1_token_proto_init() {
	if File_buf_alpha_registry_v1alpha1_token_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_token_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_token_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_token_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_token_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_token_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_token_proto = out.File
	file_buf_alpha_registry_v1alpha1_token_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_token_proto_depIdxs = nil
}
