/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.behavior.InvalidBehaviorIdException;
import org.apache.wicket.util.lang.Args;

final class Behaviors {
    private Behaviors() {
    }

    public static void add(Component component, Behavior ... behaviors) {
        Args.notNull((Object)behaviors, (String)"behaviors");
        for (Behavior behavior : behaviors) {
            Args.notNull((Object)behavior, (String)"behavior");
            Behaviors.internalAdd(component, behavior);
            if (!behavior.isTemporary(component)) {
                component.addStateChange();
            }
            behavior.bind(component);
        }
    }

    private static void internalAdd(Component component, Behavior behavior) {
        component.data_add(behavior);
        if (!behavior.getStatelessHint(component)) {
            Behaviors.getBehaviorId(component, behavior);
        }
    }

    public static <M extends Behavior> List<M> getBehaviors(Component component, Class<M> type) {
        int len = component.data_length();
        if (len == 0) {
            return Collections.emptyList();
        }
        int start = component.data_start();
        if (len < start) {
            return Collections.emptyList();
        }
        ArrayList<Behavior> subset = null;
        for (int i = start; i < len; ++i) {
            Object obj = component.data_get(i);
            if (!(obj instanceof Behavior) || type != null && !type.isAssignableFrom(obj.getClass())) continue;
            if (subset == null) {
                subset = new ArrayList<Behavior>(len);
            }
            subset.add((Behavior)obj);
        }
        if (subset == null || subset.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subset);
    }

    public static void remove(Component component, Behavior behavior) {
        Args.notNull((Object)behavior, (String)"behavior");
        if (Behaviors.internalRemove(component, behavior)) {
            if (!behavior.isTemporary(component)) {
                component.addStateChange();
            }
        } else {
            throw new IllegalStateException("Tried to remove a behavior that was not added to the component. Behavior: " + behavior.toString());
        }
        behavior.detach(component);
    }

    public static void detach(Component component) {
        int len = component.data_length();
        if (len == 0) {
            return;
        }
        int start = component.data_start();
        if (len < start) {
            return;
        }
        for (int i = start; i < len; ++i) {
            Object obj = component.data_get(i);
            if (!(obj instanceof Behavior)) continue;
            Behavior behavior = (Behavior)obj;
            behavior.detach(component);
            int currentLength = component.data_length();
            if (len != currentLength) {
                for (int j = start; j < currentLength; ++j) {
                    if (behavior != component.data_get(j)) continue;
                    i = j;
                    len = currentLength;
                    break;
                }
            }
            if (!behavior.isTemporary(component)) continue;
            Behaviors.internalRemove(component, behavior);
            --i;
            --len;
        }
    }

    private static boolean internalRemove(Component component, Behavior behavior) {
        int len = component.data_length();
        for (int i = component.data_start(); i < len; ++i) {
            Object o = component.data_get(i);
            if (o == null || !o.equals(behavior)) continue;
            component.data_remove(i);
            behavior.unbind(component);
            BehaviorIdList ids = Behaviors.getBehaviorsIdList(component, false);
            if (ids != null) {
                int idx = ids.indexOf(behavior);
                if (idx == ids.size() - 1) {
                    ids.remove(idx);
                } else if (idx >= 0) {
                    ids.set(idx, null);
                }
                ids.trimToSize();
                if (ids.isEmpty()) {
                    Behaviors.removeBehaviorsIdList(component);
                }
            }
            return true;
        }
        return false;
    }

    private static void removeBehaviorsIdList(Component component) {
        for (int i = component.data_start(); i < component.data_length(); ++i) {
            Object obj = component.data_get(i);
            if (!(obj instanceof BehaviorIdList)) continue;
            component.data_remove(i);
            return;
        }
    }

    private static BehaviorIdList getBehaviorsIdList(Component component, boolean createIfNotFound) {
        int len = component.data_length();
        for (int i = component.data_start(); i < len; ++i) {
            Object obj = component.data_get(i);
            if (!(obj instanceof BehaviorIdList)) continue;
            return (BehaviorIdList)obj;
        }
        if (createIfNotFound) {
            BehaviorIdList list = new BehaviorIdList();
            component.data_add(list);
            return list;
        }
        return null;
    }

    public static void onRemove(Component component) {
        int len = component.data_length();
        if (len == 0) {
            return;
        }
        int start = component.data_start();
        if (len < start) {
            return;
        }
        for (int i = start; i < len; ++i) {
            Object obj = component.data_get(i);
            if (!(obj instanceof Behavior)) continue;
            Behavior behavior = (Behavior)obj;
            behavior.onRemove(component);
        }
    }

    public static int getBehaviorId(Component component, Behavior behavior) {
        Args.notNull((Object)behavior, (String)"behavior");
        boolean found = false;
        for (int i = component.data_start(); i < component.data_length(); ++i) {
            if (behavior != component.data_get(i)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Behavior must be added to component before its id can be generated. Behavior: " + String.valueOf(behavior) + ", Component: " + String.valueOf(component));
        }
        BehaviorIdList ids = Behaviors.getBehaviorsIdList(component, true);
        int id = ids.indexOf(behavior);
        if (id < 0) {
            for (int i = 0; i < ids.size(); ++i) {
                if (ids.get(i) != null) continue;
                ids.set(i, behavior);
                id = i;
                break;
            }
        }
        if (id < 0) {
            id = ids.size();
            ids.add(behavior);
            ids.trimToSize();
        }
        return id;
    }

    public static Behavior getBehaviorById(Component component, int id) {
        Behavior behavior = null;
        BehaviorIdList ids = Behaviors.getBehaviorsIdList(component, false);
        if (ids != null && id >= 0 && id < ids.size()) {
            behavior = (Behavior)ids.get(id);
        }
        if (behavior != null) {
            return behavior;
        }
        throw new InvalidBehaviorIdException(component, id);
    }

    private static class BehaviorIdList
    extends ArrayList<Behavior> {
        private static final long serialVersionUID = 1L;

        public BehaviorIdList() {
            super(1);
        }
    }
}

