/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.spring;

import java.io.File;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.fulcrum.spring.AvalonContainerBean;
import org.apache.fulcrum.spring.BeanFactoryServiceManager;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;

public class YaafiContainerBean
extends AvalonContainerBean {
    private String containerConfigValue = "./conf/containerConfiguration.xml";
    private String applicationHome = ".";
    private String tempHome = System.getProperty("java.io.tmpdir", ".");

    public void initialize() throws Exception {
        ServiceContainerConfiguration config = new ServiceContainerConfiguration();
        BeanFactoryServiceManager beanFactoryServiceManager = new BeanFactoryServiceManager(this.getBeanFactory());
        config.setLogger(this.getLogger());
        config.setApplicationRootDir(this.getApplicationHome());
        config.setTempRootDir(this.getTempHome());
        config.loadContainerConfiguration(this.getContainerConfigValue(), "auto");
        config.setParentServiceManager((ServiceManager)beanFactoryServiceManager);
        config.setContext((Context)new DefaultContext(this.getDefaultContext()));
        this.setServiceManager((ServiceManager)ServiceContainerFactory.create((ServiceContainerConfiguration)config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.getServiceManager() == null) {
            return;
        }
        try {
            ((Disposable)this.getServiceManager()).dispose();
        }
        catch (Exception e) {
            String msg = "Failed to terminate " + this.getClass().getName();
            this.getLogger().error(msg, (Throwable)e);
        }
        finally {
            this.setServiceManager(null);
        }
    }

    public String getApplicationHome() {
        return this.applicationHome;
    }

    public void setApplicationHome(String applicationHome) {
        this.applicationHome = applicationHome;
    }

    public String getContainerConfigValue() {
        return this.containerConfigValue;
    }

    public void setContainerConfigValue(String containerConfigValue) {
        this.containerConfigValue = containerConfigValue;
    }

    public String getTempHome() {
        return this.tempHome;
    }

    public void setTempHome(String tempHome) {
        this.tempHome = tempHome;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode()));
        result.append('[');
        result.append("beanName=").append(this.getBeanName());
        result.append(',');
        result.append("workingDir=").append(new File("").getAbsolutePath());
        result.append(',');
        result.append("applicationHome=").append(this.getApplicationHome());
        result.append(',');
        result.append("tempHome=").append(this.getTempHome());
        result.append(',');
        result.append("logger=").append(this.getLogger().getClass().getName());
        result.append(',');
        result.append("containerConfigValue=").append(this.getContainerConfigValue());
        result.append(']');
        return result.toString();
    }
}

