/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class IntervalMonthData {
    public final int units;

    public static IntervalMonthData newInterval(double d, int n) {
        int n2 = DTIType.intervalIndexMap.get(n);
        return new IntervalMonthData((long)(d *= (double)DTIType.yearToSecondFactors[n2]));
    }

    public static IntervalMonthData newIntervalYear(long l, IntervalType intervalType) {
        return new IntervalMonthData(l * 12L, intervalType);
    }

    public static IntervalMonthData newIntervalMonth(long l, IntervalType intervalType) {
        return new IntervalMonthData(l, intervalType);
    }

    public IntervalMonthData(long l, IntervalType intervalType) {
        if (l >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3406);
        }
        if (intervalType.typeCode == 101) {
            l -= l % 12L;
        }
        this.units = (int)l;
    }

    public IntervalMonthData(long l) {
        this.units = (int)l;
    }

    public boolean equals(Object object) {
        if (object instanceof IntervalMonthData) {
            return this.units == ((IntervalMonthData)object).units;
        }
        return false;
    }

    public int hashCode() {
        return this.units;
    }

    public int compareTo(IntervalMonthData intervalMonthData) {
        if (this.units > intervalMonthData.units) {
            return 1;
        }
        if (this.units < intervalMonthData.units) {
            return -1;
        }
        return 0;
    }

    public int getMonths() {
        return this.units;
    }

    public String toString() {
        return Type.SQL_INTERVAL_MONTH_MAX_PRECISION.convertToString(this);
    }
}

