import Authenticator, { AuthenticatorOptions } from './authenticator.cjs';
export type SaslAuthenticatorOptions = AuthenticatorOptions & {
    mechanism?: any;
};
export default class SaslAuthenticator extends Authenticator {
    /**
     * Creates a new instance of SaslAuthenticator.
     * @param {Object} [options] The authentication options.
     * @param {Object} [options.mechanism] The mechanism to be used for authentication.
     * @constructor
     */
    constructor(options: SaslAuthenticatorOptions);
    /**
     * Evaluates the challenge from the server and returns appropriate response.
     * @param {String} challenge Challenge string presented by the server.
     * @return {Object} A Promise that resolves to a valid sasl response object.
     */
    evaluateChallenge(challenge: string): any;
}
