/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.freemarker;

import freemarker.core.Environment;
import freemarker.ext.jakarta.servlet.HttpRequestHashModel;
import freemarker.ext.jakarta.servlet.ServletContextHashModel;
import freemarker.template.TemplateModelException;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.freemarker.NotAvailableFreemarkerServletException;
import org.apache.tiles.request.servlet.ServletUtil;

public final class FreemarkerRequestUtil {
    private FreemarkerRequestUtil() {
    }

    public static HttpRequestHashModel getRequestHashModel(Environment env) {
        try {
            return (HttpRequestHashModel)env.getDataModel().get("Request");
        }
        catch (TemplateModelException e) {
            throw new NotAvailableFreemarkerServletException("Exception got when obtaining the request hash model", e);
        }
    }

    public static ServletContextHashModel getServletContextHashModel(Environment env) {
        try {
            return (ServletContextHashModel)env.getDataModel().get("Application");
        }
        catch (TemplateModelException e) {
            throw new NotAvailableFreemarkerServletException("Exception got when obtaining the application hash model", e);
        }
    }

    public static ApplicationContext getApplicationContext(Environment env) {
        return ServletUtil.getApplicationContext(FreemarkerRequestUtil.getServletContextHashModel(env).getServlet().getServletContext());
    }
}

