/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.parser;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.InfoAlert;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import com.google.gxp.compiler.parser.UnsupportedExternalEntityException;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemEntityResolver
implements SourceEntityResolver {
    private static final String EXTERNAL_ENTITY_PREFIX = "http://gxp.googlecode.com/svn/trunk/resources/";
    private static final String SOURCE_ROOT_PUBLIC_ID_PREFIX = "//";
    private final FileSystem fileSystem;

    public FileSystemEntityResolver(FileSystem fileSystem) {
        this.fileSystem = Preconditions.checkNotNull(fileSystem);
    }

    @Override
    public InputStream resolveEntity(SourcePosition pos, String publicId, String systemId, AlertSink alertSink) throws IOException {
        String relPath;
        if (systemId.startsWith(EXTERNAL_ENTITY_PREFIX)) {
            InputStream stream = this.resolveEntityFromResource(pos, systemId, EXTERNAL_ENTITY_PREFIX.length(), alertSink);
            if (stream != null) {
                return stream;
            }
        } else if (publicId != null && publicId.startsWith(SOURCE_ROOT_PUBLIC_ID_PREFIX) && !"".equals(relPath = publicId.substring(SOURCE_ROOT_PUBLIC_ID_PREFIX.length())) && !relPath.startsWith("/")) {
            FileRef file = this.fileSystem.getRoot().join(relPath);
            alertSink.add(new EntityResolvedNotification(pos, publicId, file.toFilename()));
            return file.openInputStream();
        }
        throw FileSystemEntityResolver.unresolved(pos, publicId, systemId, null);
    }

    private InputStream resolveEntityFromResource(SourcePosition pos, String systemId, int prefixLength, AlertSink alertSink) throws IOException {
        Class<?> cls = this.getClass();
        String resourceName = "/" + cls.getPackage().getName().replace('.', '/') + "/" + systemId.substring(prefixLength);
        alertSink.add(new EntityResolvedNotification(pos, systemId, resourceName));
        return cls.getResourceAsStream(resourceName);
    }

    private static RuntimeException unresolved(SourcePosition pos, String publicId, String systemId, Throwable cause) {
        UnsupportedExternalEntityException error = new UnsupportedExternalEntityException(pos, publicId, systemId);
        if (cause != null) {
            error.initCause(cause);
        }
        return error;
    }

    public static class EntityResolvedNotification
    extends InfoAlert {
        private EntityResolvedNotification(SourcePosition entityRefPos, String id, String realPath) {
            super(entityRefPos, "Resolved entity `" + id + "` to `" + realPath + "`");
        }
    }
}

