/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bloomfilter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.bloomfilter.BlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveBlockSplitBloomFilter
implements BloomFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptiveBlockSplitBloomFilter.class);
    private final List<BloomFilterCandidate> candidates = new ArrayList<BloomFilterCandidate>();
    private BloomFilterCandidate largestCandidate;
    private long numDistinctHashValues = 0L;
    private boolean finalized = false;
    private static final int NDV_STEP = 500;
    private int maximumBytes = 0x8000000;
    private int minimumBytes = 32;
    private int minimumCandidateNdv = 16;
    private final BloomFilter.HashStrategy hashStrategy;
    private ColumnDescriptor column;

    public AdaptiveBlockSplitBloomFilter(int maximumBytes, int numCandidates, double fpp, ColumnDescriptor column) {
        this(maximumBytes, BloomFilter.HashStrategy.XXH64, fpp, numCandidates, column);
    }

    public AdaptiveBlockSplitBloomFilter(int maximumBytes, BloomFilter.HashStrategy hashStrategy, double fpp, int numCandidates, ColumnDescriptor column) {
        this.column = column;
        switch (hashStrategy) {
            case XXH64: {
                this.hashStrategy = hashStrategy;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported hash strategy");
            }
        }
        this.initCandidates(maximumBytes, numCandidates, fpp);
    }

    private void initCandidates(int maxBytes, int numCandidates, double fpp) {
        int candidateExpectedNDV;
        int candidateByteSize = this.calculateBoundedPowerOfTwo(maxBytes);
        for (int i = 0; i < numCandidates && (candidateExpectedNDV = this.expectedNDV(candidateByteSize, fpp)) > 0; ++i) {
            BloomFilterCandidate candidate = new BloomFilterCandidate(candidateExpectedNDV, candidateByteSize, this.minimumBytes, this.maximumBytes, this.hashStrategy);
            this.candidates.add(candidate);
            candidateByteSize = this.calculateBoundedPowerOfTwo(candidateByteSize / 2);
        }
        if (this.candidates.isEmpty()) {
            this.candidates.add(new BloomFilterCandidate(this.minimumCandidateNdv, this.minimumBytes, this.minimumBytes, this.maximumBytes, this.hashStrategy));
        }
        this.largestCandidate = (BloomFilterCandidate)this.candidates.stream().max(BloomFilterCandidate::compareTo).get();
    }

    private int expectedNDV(int numBytes, double fpp) {
        int expectedNDV = 0;
        int optimalBytes = 0;
        while (optimalBytes < numBytes) {
            optimalBytes = BlockSplitBloomFilter.optimalNumOfBits(expectedNDV += 500, fpp) / 8;
        }
        if ((expectedNDV -= 500) <= 0) {
            expectedNDV = 0;
        }
        return expectedNDV;
    }

    private int calculateBoundedPowerOfTwo(int numBytes) {
        if (numBytes < this.minimumBytes) {
            numBytes = this.minimumBytes;
        }
        if ((numBytes & numBytes - 1) != 0) {
            numBytes = Integer.highestOneBit(numBytes);
        }
        numBytes = Math.min(numBytes, this.maximumBytes);
        numBytes = Math.max(numBytes, this.minimumBytes);
        return numBytes;
    }

    protected BloomFilterCandidate optimalCandidate() {
        return (BloomFilterCandidate)this.candidates.stream().min(BloomFilterCandidate::compareTo).get();
    }

    protected List<BloomFilterCandidate> getCandidates() {
        return this.candidates;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.finalized = true;
        BloomFilterCandidate optimalBloomFilter = this.optimalCandidate();
        optimalBloomFilter.bloomFilter.writeTo(out);
        String columnName = this.column != null && this.column.getPath() != null ? Arrays.toString(this.column.getPath()) : "unknown";
        LOG.info("The number of distinct values in {} is approximately {}, the optimal bloom filter can accept {} distinct values, byte size is {}.", new Object[]{columnName, this.numDistinctHashValues, optimalBloomFilter.getExpectedNDV(), optimalBloomFilter.bloomFilter.getBitsetSize()});
    }

    @Override
    public void insertHash(long hash) {
        Preconditions.checkArgument((!this.finalized ? 1 : 0) != 0, (String)"Insertion has been mark as finalized, no more data is allowed!");
        if (!this.largestCandidate.bloomFilter.findHash(hash)) {
            ++this.numDistinctHashValues;
        }
        this.candidates.removeIf(candidate -> (long)candidate.getExpectedNDV() < this.numDistinctHashValues && candidate != this.largestCandidate);
        this.candidates.forEach(candidate -> candidate.getBloomFilter().insertHash(hash));
    }

    @Override
    public int getBitsetSize() {
        return this.optimalCandidate().getBloomFilter().getBitsetSize();
    }

    @Override
    public boolean findHash(long hash) {
        return this.largestCandidate.bloomFilter.findHash(hash);
    }

    @Override
    public long hash(Object value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    @Override
    public BloomFilter.HashStrategy getHashStrategy() {
        return this.largestCandidate.bloomFilter.getHashStrategy();
    }

    @Override
    public BloomFilter.Algorithm getAlgorithm() {
        return this.largestCandidate.bloomFilter.getAlgorithm();
    }

    @Override
    public BloomFilter.Compression getCompression() {
        return this.largestCandidate.bloomFilter.getCompression();
    }

    @Override
    public long hash(int value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    @Override
    public long hash(long value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    @Override
    public long hash(double value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    @Override
    public long hash(float value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    @Override
    public long hash(Binary value) {
        return this.largestCandidate.bloomFilter.hash(value);
    }

    protected class BloomFilterCandidate
    implements Comparable<BloomFilterCandidate> {
        private final BlockSplitBloomFilter bloomFilter;
        private final int expectedNDV;

        public BloomFilterCandidate(int expectedNDV, int candidateBytes, int minimumBytes, int maximumBytes, BloomFilter.HashStrategy hashStrategy) {
            this.bloomFilter = new BlockSplitBloomFilter(candidateBytes, minimumBytes, maximumBytes, hashStrategy);
            this.expectedNDV = expectedNDV;
        }

        public BlockSplitBloomFilter getBloomFilter() {
            return this.bloomFilter;
        }

        public int getExpectedNDV() {
            return this.expectedNDV;
        }

        @Override
        public int compareTo(BloomFilterCandidate o) {
            return this.bloomFilter.getBitsetSize() - o.bloomFilter.getBitsetSize();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BloomFilterCandidate that = (BloomFilterCandidate)o;
            return this.expectedNDV == that.expectedNDV && Objects.equals(this.bloomFilter, that.bloomFilter);
        }

        public int hashCode() {
            return Objects.hash(this.bloomFilter, this.expectedNDV);
        }
    }
}

