/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FMRegressionModel$;
import org.apache.spark.ml.regression.FMRegressionModel$FMRegressionModelReader$;
import org.apache.spark.ml.regression.FMRegressionModel$FMRegressionModelWriter$;
import org.apache.spark.ml.regression.FMRegressorParams;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5h\u0001B A\u0001-C\u0001\u0002\u0019\u0001\u0003\u0006\u0004%\t%\u0019\u0005\tq\u0002\u0011\t\u0011)A\u0005E\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010C\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005y\"Q\u0011q\u0001\u0001\u0003\u0006\u0004%\t!!\u0003\t\u0013\u00055\u0001A!A!\u0002\u0013\u0001\u0006BCA\t\u0001\t\u0015\r\u0011\"\u0001\u0002\u0014!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u0011\u0005\u0005\u0002\u0001\"\u0001A\u0003GA\u0001\"!\t\u0001\t\u0003\u0011\u0015Q\u0007\u0005\n\u0003o\u0001!\u0019!C!\u0003sA\u0001\"a\u0011\u0001A\u0003%\u00111\b\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000\u001d9\u00111\u0011!\t\u0002\u0005\u0015eAB A\u0011\u0003\t9\tC\u0004\u0002\"M!\t!!*\u0007\u000f\u0005\u001d6\u0003\u0011\"\u0002*\"A!0\u0006BK\u0002\u0013\u00051\u0010C\u0005\u0002\u0004U\u0011\t\u0012)A\u0005y\"Q\u0011qA\u000b\u0003\u0016\u0004%\t!!\u0003\t\u0013\u00055QC!E!\u0002\u0013\u0001\u0006BCA\t+\tU\r\u0011\"\u0001\u0002\u0014!Q\u0011QD\u000b\u0003\u0012\u0003\u0006I!!\u0006\t\u000f\u0005\u0005R\u0003\"\u0001\u0002B\"I\u0011\u0011K\u000b\u0002\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003+,\u0012\u0013!C\u0001\u0003/D\u0011\"a;\u0016#\u0003%\t!!<\t\u0013\u0005EX#%A\u0005\u0002\u0005M\b\"CA|+\u0005\u0005I\u0011IA}\u0011%\u0011)!FA\u0001\n\u0003\tI\u0004C\u0005\u0003\bU\t\t\u0011\"\u0001\u0003\n!I!QC\u000b\u0002\u0002\u0013\u0005#q\u0003\u0005\n\u0005K)\u0012\u0011!C\u0001\u0005OA\u0011B!\r\u0016\u0003\u0003%\tEa\r\t\u0013\t]R#!A\u0005B\te\u0002\"CA?+\u0005\u0005I\u0011\tB\u001e\u0011%\u0011i$FA\u0001\n\u0003\u0012yd\u0002\u0006\u0003DM\t\t\u0011#\u0001C\u0005\u000b2!\"a*\u0014\u0003\u0003E\tA\u0011B$\u0011\u001d\t\tc\u000bC\u0001\u0005+B\u0011\"! ,\u0003\u0003%)Ea\u000f\t\u0013\t]3&!A\u0005\u0002\ne\u0003\"\u0003B1W\u0005\u0005I\u0011\u0011B2\u0011%\u0011)hKA\u0001\n\u0013\u00119\b\u0003\u0005\u0003\u0000M!\tA\u0011BA\u0011!\u00119j\u0005C\u0001\u0005\ne\u0005b\u0002BS'\u0011\u0005#q\u0015\u0005\b\u0005c\u001bB\u0011\tBZ\r\u001d\u0011Yl\u0005\u0001\u0014\u0005{C\u0011Ba36\u0005\u0003\u0005\u000b\u0011\u0002,\t\u000f\u0005\u0005R\u0007\"\u0001\u0003N\"9!1[\u001b\u0005R\tUgA\u0002Bm'\u0011\u0011Y\u000eC\u0004\u0002\"e\"\tA!8\t\u0013\t\u0005\u0018H1A\u0005\n\u0005e\b\u0002\u0003Brs\u0001\u0006I!a?\t\u000f\tE\u0016\b\"\u0011\u0003f\"I!QO\n\u0002\u0002\u0013%!q\u000f\u0002\u0012\r6\u0013Vm\u001a:fgNLwN\\'pI\u0016d'BA!C\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u0007\u0012\u000b!!\u001c7\u000b\u0005\u00153\u0015!B:qCJ\\'BA$I\u0003\u0019\t\u0007/Y2iK*\t\u0011*A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0019^S\u0006\u0003B'O!Zk\u0011\u0001Q\u0005\u0003\u001f\u0002\u0013qBU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003#Rk\u0011A\u0015\u0006\u0003'\n\u000ba\u0001\\5oC2<\u0017BA+S\u0005\u00191Vm\u0019;peB\u0011Q\n\u0001\t\u0003\u001bbK!!\u0017!\u0003#\u0019k%+Z4sKN\u001cxN\u001d)be\u0006l7\u000f\u0005\u0002\\=6\tAL\u0003\u0002^\u0005\u0006!Q\u000f^5m\u0013\tyFL\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005\u0011\u0007CA2m\u001d\t!'\u000e\u0005\u0002fQ6\taM\u0003\u0002h\u0015\u00061AH]8pizR\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\fa\u0001\u0015:fI\u00164\u0017BA7o\u0005\u0019\u0019FO]5oO*\u00111\u000e\u001b\u0015\u0004\u0003A4\bCA9u\u001b\u0005\u0011(BA:E\u0003)\tgN\\8uCRLwN\\\u0005\u0003kJ\u0014QaU5oG\u0016\f\u0013a^\u0001\u0006g9\u0002d\u0006M\u0001\u0005k&$\u0007\u0005K\u0002\u0003aZ\f\u0011\"\u001b8uKJ\u001cW\r\u001d;\u0016\u0003q\u0004\"! @\u000e\u0003!L!a 5\u0003\r\u0011{WO\u00197fQ\r\u0019\u0001O^\u0001\u000bS:$XM]2faR\u0004\u0003f\u0001\u0003qm\u00061A.\u001b8fCJ,\u0012\u0001\u0015\u0015\u0004\u000bA4\u0018a\u00027j]\u0016\f'\u000f\t\u0015\u0004\rA4\u0018a\u00024bGR|'o]\u000b\u0003\u0003+\u00012!UA\f\u0013\r\tIB\u0015\u0002\u0007\u001b\u0006$(/\u001b=)\u0007\u001d\u0001h/\u0001\u0005gC\u000e$xN]:!Q\rA\u0001O^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013Y\u000b)#!\u000b\u0002.\u0005E\u0002\"\u00021\n\u0001\u0004\u0011\u0007\u0006BA\u0013aZDQA_\u0005A\u0002qDC!!\u000bqm\"1\u0011qA\u0005A\u0002ACC!!\fqm\"9\u0011\u0011C\u0005A\u0002\u0005U\u0001\u0006BA\u0019aZ$\u0012AV\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u0002<A\u0019Q0!\u0010\n\u0007\u0005}\u0002NA\u0002J]RD3a\u00039w\u00031qW/\u001c$fCR,(/Z:!Q\ra\u0001O^\u0001\baJ,G-[2u)\ra\u00181\n\u0005\u0007\u0003\u001bj\u0001\u0019\u0001)\u0002\u0011\u0019,\u0017\r^;sKND3!\u00049w\u0003\u0011\u0019w\u000e]=\u0015\u0007Y\u000b)\u0006C\u0004\u0002X9\u0001\r!!\u0017\u0002\u000b\u0015DHO]1\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018C\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t\u0019'!\u0018\u0003\u0011A\u000b'/Y7NCBD3A\u00049w\u00035)7\u000f^5nCR,GmU5{KV\u0011\u00111\u000e\t\u0004{\u00065\u0014bAA8Q\n!Aj\u001c8h\u0003\u00159(/\u001b;f+\t\t)\bE\u0002\\\u0003oJ1!!\u001f]\u0005!iEj\u0016:ji\u0016\u0014\bf\u0001\tqm\u0006AAo\\*ue&tw\rF\u0001cQ\r\u0001\u0001O^\u0001\u0012\r6\u0013Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA'\u0014'\u001d\u0019\u0012\u0011RAH\u0003+\u00032!`AF\u0013\r\ti\t\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\tm\u000b\tJV\u0005\u0004\u0003'c&AC'M%\u0016\fG-\u00192mKB!\u0011qSAQ\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015AA5p\u0015\t\ty*\u0001\u0003kCZ\f\u0017\u0002BAR\u00033\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\"\u0003\t\u0011\u000bG/Y\n\b+\u0005%\u00151VAY!\ri\u0018QV\u0005\u0004\u0003_C'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003g\u000biL\u0004\u0003\u00026\u0006efbA3\u00028&\t\u0011.C\u0002\u0002<\"\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006}&bAA^QRA\u00111YAd\u0003\u0013\fY\rE\u0002\u0002FVi\u0011a\u0005\u0005\u0006ur\u0001\r\u0001 \u0005\u0007\u0003\u000fa\u0002\u0019\u0001)\t\u000f\u0005EA\u00041\u0001\u0002\u0016QA\u00111YAh\u0003#\f\u0019\u000eC\u0004{;A\u0005\t\u0019\u0001?\t\u0011\u0005\u001dQ\u0004%AA\u0002AC\u0011\"!\u0005\u001e!\u0003\u0005\r!!\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001c\u0016\u0004y\u0006m7FAAo!\u0011\ty.a:\u000e\u0005\u0005\u0005(\u0002BAr\u0003K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005MD\u0017\u0002BAu\u0003C\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a<+\u0007A\u000bY.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U(\u0006BA\u000b\u00037\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA~!\u0011\tiPa\u0001\u000e\u0005\u0005}(\u0002\u0002B\u0001\u0003;\u000bA\u0001\\1oO&\u0019Q.a@\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0002B\t!\ri(QB\u0005\u0004\u0005\u001fA'aA!os\"I!1C\u0012\u0002\u0002\u0003\u0007\u00111H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\te\u0001C\u0002B\u000e\u0005C\u0011Y!\u0004\u0002\u0003\u001e)\u0019!q\u00045\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003$\tu!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u000b\u00030A\u0019QPa\u000b\n\u0007\t5\u0002NA\u0004C_>dW-\u00198\t\u0013\tMQ%!AA\u0002\t-\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a?\u00036!I!1\u0003\u0014\u0002\u0002\u0003\u0007\u00111H\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111\b\u000b\u0003\u0003w\fa!Z9vC2\u001cH\u0003\u0002B\u0015\u0005\u0003B\u0011Ba\u0005*\u0003\u0003\u0005\rAa\u0003\u0002\t\u0011\u000bG/\u0019\t\u0004\u0003\u000b\\3#B\u0016\u0003J\u0005U\u0005C\u0003B&\u0005#b\b+!\u0006\u0002D6\u0011!Q\n\u0006\u0004\u0005\u001fB\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0012iEA\tBEN$(/Y2u\rVt7\r^5p]N\"\"A!\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005\r'1\fB/\u0005?BQA\u001f\u0018A\u0002qDa!a\u0002/\u0001\u0004\u0001\u0006bBA\t]\u0001\u0007\u0011QC\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)G!\u001d\u0011\u000bu\u00149Ga\u001b\n\u0007\t%\u0004N\u0001\u0004PaRLwN\u001c\t\b{\n5D\u0010UA\u000b\u0013\r\u0011y\u0007\u001b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\tMt&!AA\u0002\u0005\r\u0017a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0010\t\u0005\u0003{\u0014Y(\u0003\u0003\u0003~\u0005}(AB(cU\u0016\u001cG/A\u0007tKJL\u0017\r\\5{K\u0012\u000bG/\u0019\u000b\u0007\u0005\u0007\u0013II!$\u0011\u0007u\u0014))C\u0002\u0003\b\"\u0014A!\u00168ji\"9!1R\u0019A\u0002\u0005\r\u0017\u0001\u00023bi\u0006DqAa$2\u0001\u0004\u0011\t*A\u0002e_N\u0004B!a&\u0003\u0014&!!QSAM\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW.A\beKN,'/[1mSj,G)\u0019;b)\u0011\t\u0019Ma'\t\u000f\tu%\u00071\u0001\u0003 \u0006\u0019A-[:\u0011\t\u0005]%\u0011U\u0005\u0005\u0005G\u000bIJA\bECR\f\u0017J\u001c9viN#(/Z1n\u0003\u0011\u0011X-\u00193\u0016\u0005\t%\u0006\u0003B.\u0003,ZK1A!,]\u0005!iEJU3bI\u0016\u0014\bfA\u001aqm\u0006!An\\1e)\r1&Q\u0017\u0005\u0007\u0005o#\u0004\u0019\u00012\u0002\tA\fG\u000f\u001b\u0015\u0004iA4(a\u0006$N%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\u0015)\u0014Q\u000fB`!\u0011\u0011\tMa2\u000e\u0005\t\r'b\u0001Bc\t\u0006A\u0011N\u001c;fe:\fG.\u0003\u0003\u0003J\n\r'a\u0002'pO\u001eLgnZ\u0001\tS:\u001cH/\u00198dKR!!q\u001aBi!\r\t)-\u000e\u0005\u0007\u0005\u0017<\u0004\u0019\u0001,\u0002\u0011M\fg/Z%na2$BAa!\u0003X\"1!q\u0017\u001dA\u0002\t\u0014qCR'SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007e\u0012I\u000b\u0006\u0002\u0003`B\u0019\u0011QY\u001d\u0002\u0013\rd\u0017m]:OC6,\u0017AC2mCN\u001ch*Y7fAQ\u0019aKa:\t\r\t]V\b1\u0001cQ\r\u0019\u0002O\u001e\u0015\u0004%A4\b")
public class FMRegressionModel
extends RegressionModel<Vector, FMRegressionModel>
implements FMRegressorParams,
MLWritable {
    private final String uid;
    private final double intercept;
    private final Vector linear;
    private final Matrix factors;
    private final int numFeatures;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMRegressionModel load(String path) {
        return FMRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<FMRegressionModel> read() {
        return FMRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double intercept() {
        return this.intercept;
    }

    public Vector linear() {
        return this.linear;
    }

    public Matrix factors() {
        return this.factors;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public double predict(Vector features) {
        return FactorizationMachines$.MODULE$.getRawPrediction(features, this.intercept(), this.linear(), this.factors());
    }

    @Override
    public FMRegressionModel copy(ParamMap extra) {
        return this.copyValues(new FMRegressionModel(this.uid(), this.intercept(), this.linear(), this.factors()), extra);
    }

    @Override
    public long estimatedSize() {
        long size;
        block1: {
            size = this.estimateMatadataSize();
            if (this.linear() != null) {
                size += this.linear().getSizeInBytes();
            }
            if (this.factors() == null) break block1;
            size += this.factors().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new FMRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return "FMRegressionModel: uid=" + Identifiable.toString$(this) + ", numFeatures=" + this.numFeatures() + ", factorSize=" + this.$(this.factorSize()) + ", fitLinear=" + this.$(this.fitLinear()) + ", fitIntercept=" + this.$(this.fitIntercept());
    }

    public FMRegressionModel(String uid, double intercept, Vector linear, Matrix factors) {
        this.uid = uid;
        this.intercept = intercept;
        this.linear = linear;
        this.factors = factors;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        MLWritable.$init$(this);
        this.numFeatures = linear.size();
        Statics.releaseFence();
    }

    public FMRegressionModel() {
        this("", Double.NaN, (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    public static class Data
    implements Product,
    Serializable {
        private final double intercept;
        private final Vector linear;
        private final Matrix factors;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double intercept() {
            return this.intercept;
        }

        public Vector linear() {
            return this.linear;
        }

        public Matrix factors() {
            return this.factors;
        }

        public Data copy(double intercept, Vector linear, Matrix factors) {
            return new Data(intercept, linear, factors);
        }

        public double copy$default$1() {
            return this.intercept();
        }

        public Vector copy$default$2() {
            return this.linear();
        }

        public Matrix copy$default$3() {
            return this.factors();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
                case 1: {
                    return this.linear();
                }
                case 2: {
                    return this.factors();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "intercept";
                }
                case 1: {
                    return "linear";
                }
                case 2: {
                    return "factors";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.linear()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.factors()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            Vector vector = this.linear();
            Vector vector2 = data.linear();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            Matrix matrix = this.factors();
            Matrix matrix2 = data.factors();
            if (matrix == null) {
                if (matrix2 != null) {
                    return false;
                }
            } else if (!matrix.equals(matrix2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(double intercept, Vector linear, Matrix factors) {
            this.intercept = intercept;
            this.linear = linear;
            this.factors = factors;
            Product.$init$((Product)this);
        }
    }

    private static class FMRegressionModelReader
    extends MLReader<FMRegressionModel> {
        private final String className = FMRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public FMRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMRegressionModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.FMRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2(FMRegressionModelReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> FMRegressionModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelReader$$typecreator1$2(null)));
            FMRegressionModel model = new FMRegressionModel(metadata.uid(), data.intercept(), data.linear(), data.factors());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class FMRegressionModelWriter
    extends MLWriter {
        private final FMRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.FMRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1(FMRegressionModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.intercept(), this.instance.linear(), this.instance.factors());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FMRegressionModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                FMRegressionModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_FMRegressionModel$FMRegressionModelWriter$$typecreator1$1(null)));
        }

        public FMRegressionModelWriter(FMRegressionModel instance) {
            this.instance = instance;
        }
    }
}

