/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ml;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.MlCommand;
import org.apache.spark.connect.proto.MlOperator;
import org.apache.spark.connect.proto.MlParams;
import org.apache.spark.connect.proto.MlRelation;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.classification.BinaryClassificationSummary;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassificationSummary;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.FMClassificationModel;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.RandomForestClassificationModel;
import org.apache.spark.ml.classification.TrainingSummary;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.clustering.BisectingKMeansSummary;
import org.apache.spark.ml.clustering.ClusteringSummary;
import org.apache.spark.ml.clustering.DistributedLDAModel;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.ChiSqSelectorModel;
import org.apache.spark.ml.feature.CountVectorizerModel;
import org.apache.spark.ml.feature.IDFModel;
import org.apache.spark.ml.feature.ImputerModel;
import org.apache.spark.ml.feature.LSHModel;
import org.apache.spark.ml.feature.MaxAbsScalerModel;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.feature.RobustScalerModel;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.feature.UnivariateFeatureSelectorModel;
import org.apache.spark.ml.feature.VarianceThresholdSelectorModel;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.ml.fpm.FPGrowthModel;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.IsotonicRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.util.ConnectHelper;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.connect.common.ProtoSpecializedArray$;
import org.apache.spark.sql.connect.ml.MLAttributeNotAllowedException;
import org.apache.spark.sql.connect.ml.MlUnsupportedException;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner$;
import org.apache.spark.sql.connect.plugin.SparkConnectPluginRegistry$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MLUtils$ {
    public static final MLUtils$ MODULE$ = new MLUtils$();
    private static Seq<Tuple2<Class<? super ConnectHelper>, Set<String>>> ALLOWED_ATTRIBUTES;
    private static volatile boolean bitmap$0;

    public scala.collection.immutable.Map<String, Class<?>> loadOperators(Class<?> mlCls) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        ServiceLoader<?> serviceLoader = ServiceLoader.load(mlCls, loader);
        return CollectionConverters$.MODULE$.MapHasAsScala(serviceLoader.stream().collect(Collectors.toMap(est -> est.type().getName(), est -> est.type()))).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Vector deserializeVector(Expression.Literal.Struct s2) {
        Predef$.MODULE$.assert(s2.getElementsCount() == 4);
        int n = s2.getElements(0).getByte();
        switch (n) {
            case 0: {
                int size = s2.getElements(1).getInteger();
                int[] indices = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(2).getSpecializedArray().getInts());
                double[] values = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(3).getSpecializedArray().getDoubles());
                return Vectors$.MODULE$.sparse(size, indices, values);
            }
            case 1: {
                double[] values = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(3).getSpecializedArray().getDoubles());
                return Vectors$.MODULE$.dense(values);
            }
        }
        throw new MlUnsupportedException("Unknown Vector type " + n);
    }

    public Matrix deserializeMatrix(Expression.Literal.Struct s2) {
        Predef$.MODULE$.assert(s2.getElementsCount() == 7);
        int n = s2.getElements(0).getByte();
        switch (n) {
            case 0: {
                int numRows = s2.getElements(1).getInteger();
                int numCols = s2.getElements(2).getInteger();
                int[] colPtrs = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(3).getSpecializedArray().getInts());
                int[] rowIndices = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(4).getSpecializedArray().getInts());
                double[] values = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(5).getSpecializedArray().getDoubles());
                boolean isTransposed = s2.getElements(6).getBoolean();
                return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
            }
            case 1: {
                int numRows = s2.getElements(1).getInteger();
                int numCols = s2.getElements(2).getInteger();
                double[] values = ProtoSpecializedArray$.MODULE$.toArray(s2.getElements(5).getSpecializedArray().getDoubles());
                boolean isTransposed = s2.getElements(6).getBoolean();
                return new DenseMatrix(numRows, numCols, values, isTransposed);
            }
        }
        throw new MlUnsupportedException("Unknown Matrix type " + n);
    }

    public void setInstanceParams(Params instance, MlParams params) {
        CollectionConverters$.MODULE$.MapHasAsScala(params.getParamsMap()).asScala().foreach((Function1 & Serializable)x0$1 -> {
            Object object;
            Param p;
            block9: {
                Class clazz;
                Expression.Literal literal;
                String name;
                block8: {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    name = (String)tuple2._1();
                    literal = (Expression.Literal)tuple2._2();
                    p = instance.getParam(name);
                    Expression.Literal.LiteralTypeCase literalTypeCase = literal.getLiteralTypeCase();
                    if (!Expression.Literal.LiteralTypeCase.STRUCT.equals(literalTypeCase)) break block8;
                    Expression.Literal.Struct s2 = literal.getStruct();
                    String string = s2.getStructType().getUdt().getJvmClass();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -442626967: {
                            if (!"org.apache.spark.ml.linalg.MatrixUDT".equals(string)) throw new MlUnsupportedException("Unsupported struct " + literal.getStruct() + " for " + name);
                            object = MODULE$.deserializeMatrix(s2);
                            break block9;
                        }
                        case 1006386087: {
                            if (!"org.apache.spark.ml.linalg.VectorUDT".equals(string)) throw new MlUnsupportedException("Unsupported struct " + literal.getStruct() + " for " + name);
                            object = MODULE$.deserializeVector(s2);
                            break block9;
                        }
                        default: {
                            throw new MlUnsupportedException("Unsupported struct " + literal.getStruct() + " for " + name);
                        }
                    }
                }
                Object paramValue = LiteralValueProtoConverter$.MODULE$.toScalaValue(literal);
                if (p.dataClass() == null) {
                    if (paramValue instanceof String) {
                        clazz = String.class;
                    } else {
                        if (!(paramValue instanceof Boolean)) throw new MlUnsupportedException("Spark Connect ML requires the customized ML Param class setting 'dataClass' parameter if the param value type is not String or Boolean type, but the param " + name + " does not have the required dataClass.");
                        clazz = Boolean.TYPE;
                    }
                } else {
                    clazz = p.dataClass();
                }
                Class<String> paramType = clazz;
                object = MODULE$.reconcileParam(paramType, paramValue);
            }
            Object value = object;
            return instance.set(p, value);
        });
    }

    public Object reconcileArray(Class<?> elementType, Object array) {
        Class<?> clazz = elementType;
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToByte((byte)MLUtils$.$anonfun$reconcileArray$1(x$1)), (ClassTag)ClassTag$.MODULE$.Byte());
        }
        Class<?> clazz3 = elementType;
        Class<Short> clazz4 = Short.TYPE;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToShort((short)MLUtils$.$anonfun$reconcileArray$2(x$2)), (ClassTag)ClassTag$.MODULE$.Short());
        }
        Class<?> clazz5 = elementType;
        Class<Integer> clazz6 = Integer.TYPE;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)MLUtils$.$anonfun$reconcileArray$3(x$3)), (ClassTag)ClassTag$.MODULE$.Int());
        }
        Class<?> clazz7 = elementType;
        Class<Long> clazz8 = Long.TYPE;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)MLUtils$.$anonfun$reconcileArray$4(x$4)), (ClassTag)ClassTag$.MODULE$.Long());
        }
        Class<?> clazz9 = elementType;
        Class<Float> clazz10 = Float.TYPE;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToFloat((float)MLUtils$.$anonfun$reconcileArray$5(x$5)), (ClassTag)ClassTag$.MODULE$.Float());
        }
        Class<?> clazz11 = elementType;
        Class<Double> clazz12 = Double.TYPE;
        if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)MLUtils$.$anonfun$reconcileArray$6(x$6)), (ClassTag)ClassTag$.MODULE$.Double());
        }
        Class<?> clazz13 = elementType;
        Class<String> clazz14 = String.class;
        if (!(clazz13 != null ? !clazz13.equals(clazz14) : clazz14 != null)) {
            return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$7 -> (String)x$7, ClassTag$.MODULE$.apply(String.class));
        }
        if (elementType.isArray()) {
            Class<?> clazz15 = elementType.getComponentType();
            Class<Double> clazz16 = Double.TYPE;
            if (!(clazz15 != null ? !clazz15.equals(clazz16) : clazz16 != null)) {
                return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$8 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(x$8), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToDouble((double)MLUtils$.$anonfun$reconcileArray$9(x$9)), (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            }
        }
        if (elementType.isArray()) {
            Class<?> clazz17 = elementType.getComponentType();
            Class<String> clazz18 = String.class;
            if (!(clazz17 != null ? !clazz17.equals(clazz18) : clazz18 != null)) {
                return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x$10 -> (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(x$10), (Function1 & Serializable)x$11 -> (String)x$11, ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            }
        }
        throw new MlUnsupportedException("array element type unsupported, found " + elementType.getName());
    }

    private Object reconcileParam(Class<?> paramType, Object value) {
        Class<?> clazz = paramType;
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return BoxesRunTime.boxToByte((byte)((Number)value).byteValue());
        }
        Class<?> clazz3 = paramType;
        Class<Short> clazz4 = Short.TYPE;
        if (!(clazz3 != null ? !clazz3.equals(clazz4) : clazz4 != null)) {
            return BoxesRunTime.boxToShort((short)((Number)value).shortValue());
        }
        Class<?> clazz5 = paramType;
        Class<Integer> clazz6 = Integer.TYPE;
        if (!(clazz5 != null ? !clazz5.equals(clazz6) : clazz6 != null)) {
            return BoxesRunTime.boxToInteger((int)((Number)value).intValue());
        }
        Class<?> clazz7 = paramType;
        Class<Long> clazz8 = Long.TYPE;
        if (!(clazz7 != null ? !clazz7.equals(clazz8) : clazz8 != null)) {
            return BoxesRunTime.boxToLong((long)((Number)value).longValue());
        }
        Class<?> clazz9 = paramType;
        Class<Float> clazz10 = Float.TYPE;
        if (!(clazz9 != null ? !clazz9.equals(clazz10) : clazz10 != null)) {
            return BoxesRunTime.boxToFloat((float)((Number)value).floatValue());
        }
        Class<?> clazz11 = paramType;
        Class<Double> clazz12 = Double.TYPE;
        if (!(clazz11 != null ? !clazz11.equals(clazz12) : clazz12 != null)) {
            return BoxesRunTime.boxToDouble((double)((Number)value).doubleValue());
        }
        Class<?> clazz13 = paramType;
        Class<Boolean> clazz14 = Boolean.TYPE;
        if (!(clazz13 != null ? !clazz13.equals(clazz14) : clazz14 != null)) {
            return BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value));
        }
        Class<?> clazz15 = paramType;
        Class<String> clazz16 = String.class;
        if (!(clazz15 != null ? !clazz15.equals(clazz16) : clazz16 != null)) {
            return (String)value;
        }
        if (paramType.isArray()) {
            Class<?> compType = paramType.getComponentType();
            Object[] array = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(value), (Function1 & Serializable)e -> MODULE$.reconcileParam(compType, e), ClassTag$.MODULE$.Any());
            return this.reconcileArray(compType, array);
        }
        throw new MlUnsupportedException("Unsupported parameter type, found " + paramType.getName());
    }

    public Dataset<Row> parseRelationProto(Relation relation, SessionHolder sessionHolder) {
        SparkConnectPlanner planner = new SparkConnectPlanner(sessionHolder, SparkConnectPlanner$.MODULE$.$lessinit$greater$default$2());
        LogicalPlan plan = planner.transformRelation(relation);
        return Dataset$.MODULE$.ofRows(sessionHolder.session(), plan);
    }

    private <T> T getInstance(String name, String uid, scala.collection.immutable.Map<String, Class<?>> instanceMap, Option<MlParams> params) {
        if (instanceMap.isEmpty() || !instanceMap.contains((Object)name)) {
            throw new MlUnsupportedException("Unsupported ML operator, found " + name);
        }
        Object instance = ((Class)instanceMap.apply((Object)name)).getConstructor(String.class).newInstance(uid);
        params.foreach((Function1 & Serializable)p -> {
            MLUtils$.MODULE$.setInstanceParams((Params)instance, p);
            return BoxedUnit.UNIT;
        });
        return instance;
    }

    public String replaceOperator(SessionHolder sessionHolder, String name) {
        return (String)((Optional)SparkConnectPluginRegistry$.MODULE$.mlBackendRegistry(sessionHolder.session().sessionState().conf()).view().map((Function1 & Serializable)p -> p.transform(name)).find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isPresent())).getOrElse((Function0 & Serializable)() -> Optional.of(name))).get();
    }

    public Estimator<?> getEstimator(SessionHolder sessionHolder, MlOperator operator, Option<MlParams> params) {
        String name = this.replaceOperator(sessionHolder, operator.getName());
        String uid = operator.getUid();
        scala.collection.immutable.Map<String, Class<?>> estimators = this.loadOperators(Estimator.class);
        return (Estimator)this.getInstance(name, uid, estimators, params);
    }

    public Transformer getTransformer(SessionHolder sessionHolder, MlRelation.Transform transformProto) {
        String name = this.replaceOperator(sessionHolder, transformProto.getTransformer().getName());
        String uid = transformProto.getTransformer().getUid();
        MlParams params = transformProto.getParams();
        scala.collection.immutable.Map<String, Class<?>> transformers = this.loadOperators(Transformer.class);
        return (Transformer)this.getInstance(name, uid, transformers, (Option<MlParams>)new Some((Object)params));
    }

    public Transformer getTransformer(SessionHolder sessionHolder, MlOperator operator, Option<MlParams> params) {
        String name = this.replaceOperator(sessionHolder, operator.getName());
        String uid = operator.getUid();
        scala.collection.immutable.Map<String, Class<?>> transformers = this.loadOperators(Transformer.class);
        return (Transformer)this.getInstance(name, uid, transformers, params);
    }

    public Evaluator getEvaluator(SessionHolder sessionHolder, MlOperator operator, Option<MlParams> params) {
        String name = this.replaceOperator(sessionHolder, operator.getName());
        String uid = operator.getUid();
        scala.collection.immutable.Map<String, Class<?>> evaluators = this.loadOperators(Evaluator.class);
        return (Evaluator)this.getInstance(name, uid, evaluators, params);
    }

    private <T> T loadOperator(SessionHolder sessionHolder, String className, String path, Class<T> operatorClass, boolean loadFromLocal) {
        Object object;
        String name = this.replaceOperator(sessionHolder, className);
        scala.collection.immutable.Map<String, Class<?>> operators = this.loadOperators(operatorClass);
        if (operators.isEmpty() || !operators.contains((Object)name)) {
            throw new MlUnsupportedException("Unsupported read for " + name);
        }
        try {
            Object loaded;
            Object object2;
            Class clazz = (Class)operators.apply((Object)name);
            if (loadFromLocal) {
                MLReader loader = (MLReader)clazz.getMethod("read", new Class[0]).invoke(null, new Object[0]);
                object2 = loader.loadFromLocal(path);
            } else {
                object2 = clazz.getMethod("load", String.class).invoke(null, path);
            }
            object = loaded = object2;
        }
        catch (Throwable throwable) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        return (T)object;
    }

    private <T> boolean loadOperator$default$5() {
        return false;
    }

    public Estimator<?> loadEstimator(SessionHolder sessionHolder, String className, String path) {
        return this.loadOperator(sessionHolder, className, path, Estimator.class, this.loadOperator$default$5());
    }

    public Transformer loadTransformer(SessionHolder sessionHolder, String className, String path, boolean loadFromLocal) {
        return this.loadOperator(sessionHolder, className, path, Transformer.class, loadFromLocal);
    }

    public boolean loadTransformer$default$4() {
        return false;
    }

    public Evaluator loadEvaluator(SessionHolder sessionHolder, String className, String path) {
        return this.loadOperator(sessionHolder, className, path, Evaluator.class, this.loadOperator$default$5());
    }

    private Seq<Tuple2<Class<? super ConnectHelper>, Set<String>>> ALLOWED_ATTRIBUTES$lzycompute() {
        MLUtils$ mLUtils$ = this;
        synchronized (mLUtils$) {
            if (!bitmap$0) {
                ALLOWED_ATTRIBUTES = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(Identifiable.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"toString"}))), new Tuple2(PredictionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predict", "numFeatures"}))), new Tuple2(ClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictRaw", "numClasses"}))), new Tuple2(ProbabilisticClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictProbability"}))), new Tuple2(LSHModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"approxNearestNeighbors", "approxSimilarityJoin"}))), new Tuple2(HasTrainingSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hasSummary", "summary"}))), new Tuple2(TrainingSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"objectiveHistory", "totalIterations"}))), new Tuple2(ClassificationSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictions", "predictionCol", "labelCol", "weightCol", "labels", "truePositiveRateByLabel", "falsePositiveRateByLabel", "precisionByLabel", "recallByLabel", "fMeasureByLabel", "accuracy", "weightedTruePositiveRate", "weightedFalsePositiveRate", "weightedRecall", "weightedPrecision", "weightedFMeasure", "weightedFMeasure"}))), new Tuple2(BinaryClassificationSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scoreCol", "roc", "areaUnderROC", "pr", "fMeasureByThreshold", "precisionByThreshold", "recallByThreshold"}))), new Tuple2(ClusteringSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictions", "predictionCol", "featuresCol", "k", "numIter", "cluster", "clusterSizes"}))), new Tuple2(DecisionTreeModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictLeaf", "numNodes", "depth", "toDebugString"}))), new Tuple2(TreeEnsembleModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictLeaf", "trees", "treeWeights", "getNumTrees", "totalNumNodes", "toDebugString"}))), new Tuple2(DecisionTreeClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances"}))), new Tuple2(RandomForestClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances", "evaluate"}))), new Tuple2(GBTClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances", "evaluateEachIteration"}))), new Tuple2(DecisionTreeRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances"}))), new Tuple2(RandomForestRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances"}))), new Tuple2(GBTRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"featureImportances", "evaluateEachIteration"}))), new Tuple2(NaiveBayesModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pi", "theta", "sigma"}))), new Tuple2(LinearSVCModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "coefficients", "evaluate"}))), new Tuple2(LogisticRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "coefficients", "interceptVector", "coefficientMatrix", "evaluate"}))), new Tuple2(LogisticRegressionSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"probabilityCol", "featuresCol"}))), new Tuple2(BinaryLogisticRegressionSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"scoreCol"}))), new Tuple2(FMClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "linear", "factors", "evaluate"}))), new Tuple2(MultilayerPerceptronClassificationModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"weights", "evaluate"}))), new Tuple2(AFTSurvivalRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "coefficients", "scale", "predictQuantiles"}))), new Tuple2(IsotonicRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"boundaries", "predictions", "numFeatures", "predict"}))), new Tuple2(GeneralizedLinearRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "coefficients", "numFeatures", "evaluate"}))), new Tuple2(GeneralizedLinearRegressionSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"aic", "degreesOfFreedom", "deviance", "dispersion", "nullDeviance", "numInstances", "predictionCol", "predictions", "rank", "residualDegreeOfFreedom", "residualDegreeOfFreedomNull", "residuals"}))), new Tuple2(GeneralizedLinearRegressionTrainingSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numIterations", "solver", "tValues", "pValues", "coefficientStandardErrors", "coefficientsWithStatistics", "toString"}))), new Tuple2(LinearRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "coefficients", "scale", "evaluate"}))), new Tuple2(LinearRegressionSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predictions", "predictionCol", "labelCol", "featuresCol", "explainedVariance", "meanAbsoluteError", "meanSquaredError", "rootMeanSquaredError", "r2", "r2adj", "residuals", "numInstances", "degreesOfFreedom", "devianceResiduals", "coefficientStandardErrors", "tValues", "pValues"}))), new Tuple2(LinearRegressionTrainingSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"objectiveHistory", "totalIterations"}))), new Tuple2(FMRegressionModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "linear", "factors"}))), new Tuple2(KMeansModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predict", "numFeatures", "clusterCenterMatrix"}))), new Tuple2(KMeansSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"trainingCost"}))), new Tuple2(BisectingKMeansModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predict", "numFeatures", "clusterCenterMatrix", "computeCost"}))), new Tuple2(BisectingKMeansSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"trainingCost"}))), new Tuple2(GaussianMixtureModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"predict", "numFeatures", "weights", "predictProbability", "gaussiansDF"}))), new Tuple2(GaussianMixtureSummary.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"probability", "probabilityCol", "logLikelihood"}))), new Tuple2(LDAModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"estimatedDocConcentration", "topicsMatrix", "isDistributed", "logLikelihood", "logPerplexity", "describeTopics", "vocabSize"}))), new Tuple2(DistributedLDAModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"trainingLogLikelihood", "logPrior", "getCheckpointFiles", "toLocal"}))), new Tuple2(ALSModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rank", "itemFactors", "userFactors", "recommendForAllUsers", "recommendForAllItems", "recommendForUserSubset", "recommendForItemSubset"}))), new Tuple2(FPGrowthModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"associationRules", "freqItemsets"}))), new Tuple2(Bucketizer.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"getSplits", "getSplitsArray"}))), new Tuple2(ImputerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"surrogateDF"}))), new Tuple2(StandardScalerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std"}))), new Tuple2(MaxAbsScalerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maxAbs"}))), new Tuple2(MinMaxScalerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"originalMax", "originalMin"}))), new Tuple2(RobustScalerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"range", "median"}))), new Tuple2(VectorIndexerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "categoryMapsDF"}))), new Tuple2(ChiSqSelectorModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"selectedFeatures"}))), new Tuple2(UnivariateFeatureSelectorModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"selectedFeatures"}))), new Tuple2(VarianceThresholdSelectorModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"selectedFeatures"}))), new Tuple2(PCAModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pc", "explainedVariance"}))), new Tuple2(Word2VecModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"getVectors", "findSynonyms"}))), new Tuple2(CountVectorizerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"vocabulary"}))), new Tuple2(OneHotEncoderModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"categorySizes"}))), new Tuple2(StringIndexerModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"labels", "labelsArray"}))), new Tuple2(RFormulaModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"resolvedFormulaString"}))), new Tuple2(IDFModel.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"idf", "docFreq", "numDocs"}))), new Tuple2(ConnectHelper.class, Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"handleOverwrite", "stringIndexerModelFromLabels", "stringIndexerModelFromLabelsArray", "countVectorizerModelFromVocabulary", "stopWordsRemoverLoadDefaultStopWords", "stopWordsRemoverGetDefaultOrUS", "chiSquareTest", "correlation", "kolmogorovSmirnovTest", "powerIterationClusteringAssignClusters", "prefixSpanFindFrequentSequentialPatterns"})))}));
                bitmap$0 = true;
            }
        }
        return ALLOWED_ATTRIBUTES;
    }

    private Seq<Tuple2<Class<? super ConnectHelper>, Set<String>>> ALLOWED_ATTRIBUTES() {
        if (!bitmap$0) {
            return this.ALLOWED_ATTRIBUTES$lzycompute();
        }
        return ALLOWED_ATTRIBUTES;
    }

    private void validate(Object obj, String method) {
        Predef$.MODULE$.assert(obj != null);
        boolean valid = this.ALLOWED_ATTRIBUTES().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MLUtils$.$anonfun$validate$1(obj, method, x0$1)));
        if (!valid) {
            throw new MLAttributeNotAllowedException(obj.getClass().getName(), method);
        }
    }

    public Object invokeMethodAllowed(Object obj, String methodName) {
        Object object;
        this.validate(obj, methodName);
        try {
            object = MethodUtils.invokeMethod((Object)obj, (String)methodName);
        }
        catch (Throwable throwable) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        return object;
    }

    public Object invokeMethodAllowed(Object obj, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Object object;
        this.validate(obj, methodName);
        try {
            object = MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])args, (Class[])parameterTypes);
        }
        catch (Throwable throwable) {
            InvocationTargetException invocationTargetException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        return object;
    }

    public void write(MLWritable instance, MlCommand.Write writeProto) {
        MLWriter writer = writeProto.hasShouldOverwrite() && writeProto.getShouldOverwrite() ? instance.write().overwrite() : instance.write();
        String path = writeProto.getPath();
        Map<String, String> options = writeProto.getOptionsMap();
        options.forEach((k, v) -> writer.option(k, v));
        writer.save(path);
    }

    public static final /* synthetic */ byte $anonfun$reconcileArray$1(Object x$1) {
        return BoxesRunTime.unboxToByte((Object)x$1);
    }

    public static final /* synthetic */ short $anonfun$reconcileArray$2(Object x$2) {
        return BoxesRunTime.unboxToShort((Object)x$2);
    }

    public static final /* synthetic */ int $anonfun$reconcileArray$3(Object x$3) {
        return BoxesRunTime.unboxToInt((Object)x$3);
    }

    public static final /* synthetic */ long $anonfun$reconcileArray$4(Object x$4) {
        return BoxesRunTime.unboxToLong((Object)x$4);
    }

    public static final /* synthetic */ float $anonfun$reconcileArray$5(Object x$5) {
        return BoxesRunTime.unboxToFloat((Object)x$5);
    }

    public static final /* synthetic */ double $anonfun$reconcileArray$6(Object x$6) {
        return BoxesRunTime.unboxToDouble((Object)x$6);
    }

    public static final /* synthetic */ double $anonfun$reconcileArray$9(Object x$9) {
        return BoxesRunTime.unboxToDouble((Object)x$9);
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(Object obj$1, String method$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class cls = (Class)tuple2._1();
            Set methods = (Set)tuple2._2();
            return cls.isInstance(obj$1) && methods.contains((Object)method$1);
        }
        throw new MatchError((Object)tuple2);
    }

    private MLUtils$() {
    }
}

